/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCompositionEvent.h"

#include "CompositionEvent.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCompositionEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCompositionEventTableValues[3] =
{
    { "data", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventData), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCompositionEventTable = { 4, 3, JSCompositionEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCompositionEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCompositionEventConstructorTable = { 1, 0, JSCompositionEventConstructorTableValues, 0 };
class JSCompositionEventConstructor : public DOMConstructorObject {
public:
    JSCompositionEventConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCompositionEventConstructor::s_info = { "CompositionEventConstructor", &DOMConstructorObject::s_info, &JSCompositionEventConstructorTable, 0 };

JSCompositionEventConstructor::JSCompositionEventConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCompositionEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCompositionEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCompositionEventConstructor, JSDOMWrapper>(exec, &JSCompositionEventConstructorTable, this, propertyName, slot);
}

bool JSCompositionEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCompositionEventConstructor, JSDOMWrapper>(exec, &JSCompositionEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSCompositionEventPrototypeTableValues[2] =
{
    { "initCompositionEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsCompositionEventPrototypeFunctionInitCompositionEvent), (intptr_t)5 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSCompositionEventPrototypeTable = { 2, 1, JSCompositionEventPrototypeTableValues, 0 };
const ClassInfo JSCompositionEventPrototype::s_info = { "CompositionEventPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSCompositionEventPrototypeTable, 0 };

JSObject* JSCompositionEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCompositionEvent>(exec, globalObject);
}

bool JSCompositionEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCompositionEventPrototypeTable, this, propertyName, slot);
}

bool JSCompositionEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCompositionEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCompositionEvent::s_info = { "CompositionEvent", &JSUIEvent::s_info, &JSCompositionEventTable, 0 };

JSCompositionEvent::JSCompositionEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CompositionEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSCompositionEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCompositionEventPrototype(exec->globalData(), globalObject, JSCompositionEventPrototype::createStructure(exec->globalData(), JSUIEventPrototype::self(exec, globalObject)));
}

bool JSCompositionEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCompositionEvent, Base>(exec, &JSCompositionEventTable, this, propertyName, slot);
}

bool JSCompositionEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCompositionEvent, Base>(exec, &JSCompositionEventTable, this, propertyName, descriptor);
}

JSValue jsCompositionEventData(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCompositionEvent* castedThis = static_cast<JSCompositionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CompositionEvent* imp = static_cast<CompositionEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->data());
    return result;
}


JSValue jsCompositionEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCompositionEvent* domObject = static_cast<JSCompositionEvent*>(asObject(slotBase));
    return JSCompositionEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSCompositionEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCompositionEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCompositionEvent::s_info))
        return throwVMTypeError(exec);
    JSCompositionEvent* castedThis = static_cast<JSCompositionEvent*>(asObject(thisValue));
    CompositionEvent* imp = static_cast<CompositionEvent*>(castedThis->impl());
    const String& typeArg(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* viewArg(toDOMWindow(exec->argument(3)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& dataArg(ustringToString(exec->argument(4).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initCompositionEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return JSValue::encode(jsUndefined());
}


}
