.\"
.\" Copyright (c) 1980, 1990, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS `AS IS' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LESS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\" - Indent in multiples of 4, usually 8.
.\"
.\" - Use \` for literal back-quote (`).
.\"
.\" - Use \e for literal backslash (\).
.\"
.\" - Use \-, not -.
.\"
.\" - Include the tilde when naming dot files. .Pa ~/.login , not .Pa .login
.\"
.\" - Refer to external commands in man page format, e.g., .Xr csh 1
.\"   However, tcsh is .Nm , because this is the tcsh man page (and
.\"   see the next note anyway).
.\"
.\" - Say `the shell', not `tcsh', unless distinguishing between tcsh and csh.
.\"
.\" - Say `shell variable'/`environment variable' instead of `variable'
.\"   and `builtin command'/`editor command' instead of `builtin' or `command'
.\"   unless the distinction is absolutely clear from context.
.\"
.\" - Use the simple present tense. `The shell uses', not `The shell will use'.
.\"
.\" - IMPORTANT: Cross-reference as much as possible. Commands, variables,
.\"   etc. in the reference section should be mentioned in the appropriate
.\"   descriptive section, or at least in the reference-section description
.\"   of another command (or whatever) which is mentioned in a description
.\"   section. Remember to note OS-specific things in "OS variant support",
.\"   new features in NEW FEATURES and referenced external commands in SEE
.\"   ALSO.
.\"
.\" UPDATE NEXT LINE FOR RELEASE
.Dd December 3, 2022
.Dt TCSH 1
.\" UPDATE NEXT LINE FOR RELEASE
.Os Astron 6.24.03
.
.Sh NAME
.Nm tcsh
.Nd C shell with file name completion and command line editing
.
.Sh SYNOPSIS
.Nm
.Op Fl bcdefFimnqstvVxX
.Op Fl D Ns Ar name Ns Op Ns = Ns Ar value
.Op Ar arg
\&...
.Nm
.Fl l
.
.Sh DESCRIPTION
.Nm
is an enhanced but completely compatible version of the Berkeley
UNIX C shell,
.Xr csh 1 .
It is a command language interpreter usable both as an interactive login
shell and a shell script command processor.
It includes a command-line editor (see
.Sx The command-line editor ) ,
programmable word completion (see
.Sx Completion and listing ) ,
spelling correction (see
.Sx Spelling correction ) ,
a history mechanism (see
.Sx History substitution ) ,
job control (see
.Sx Jobs )
and a C-like syntax.
The
.Sx NEW FEATURES
section describes major enhancements of
.Nm
over
.Xr csh 1 .
Throughout this manual, features of
.Nm
not found in most
.Xr csh 1
implementations
(specifically, the 4.4BSD
.Xr csh 1 )
are labeled with
.Sq (+) ,
and features which are present in
.Xr csh 1
but not usually documented are labeled with
.Sq (u) .
.
.Ss Argument list processing
If the first argument (argument 0) to the shell is
.Ql \-
then it is a login shell.
A login shell can be also specified by invoking the shell with
the
.Fl l
flag as the only argument.
.Pp
The rest of the flag arguments are interpreted as follows:
.Bl -tag -width indent
.
.It Fl b
Forces a
.Dq break
from option processing, causing any
further shell arguments to be treated as non-option arguments.
The remaining arguments will not be interpreted as shell options.
This may be used to pass options to a shell script without confusion
or possible subterfuge.
The shell will not run a set-user ID script without this option.
.
.It Fl c
Commands are read from the following argument (which must be present, and
must be a single argument),
stored in the
.Ic command
shell variable for reference, and executed.
Any remaining arguments are placed in the
.Ic argv
shell variable.
.
.It Fl d
The shell loads the directory stack from
.Pa ~/.cshdirs
as described under
.Sx Startup and shutdown ,
whether or not it is a login shell. (+)
.
.It Fl D Ns Ar name Ns Op Ns = Ns Ar value
Sets the environment variable
.Ar name
to
.Ar value .
(Domain/OS only) (+)
.
.It Fl e
The shell exits if any invoked command terminates abnormally or
yields a non-zero exit status.
.
.It Fl f
The shell does not load any resource or startup files, or perform any
command hashing, and thus starts faster.
.
.It Fl F
The shell uses
.Xr fork 2
instead of
.Xr vfork 2
to spawn processes. (+)
.
.It Fl i
The shell is interactive and prompts for its top-level input, even if
it appears to not be a terminal.
Shells are interactive without this option if
their inputs and outputs are terminals.
.
.It Fl l
The shell is a login shell.
Applicable only if
.Fl l
is the only
flag specified.
.
.It Fl m
The shell loads
.Pa ~/.tcshrc
even if it does not belong to the effective user.
Newer versions of
.Xr su 1
can pass
.Fl m
to the shell. (+)
.
.It Fl n
The shell parses commands but does not execute them.
This aids in debugging shell scripts.
.
.It Fl q
The shell accepts SIGQUIT (see
.Sx Signal handling )
and behaves when it is used under a debugger.
Job control is disabled. (u)
.
.It Fl s
Command input is taken from the standard input.
.
.It Fl t
The shell reads and executes a single line of input.
A
.Ql \e
may be used to
escape the newline at the end of this line and continue onto another line.
.
.It Fl v
Sets the
.Ic verbose
shell variable, so that
command input is echoed after history substitution.
.
.It Fl x
Sets the
.Ic echo
shell variable, so that commands are echoed
immediately before execution.
.
.It Fl V
Sets the
.Ic verbose
shell variable even before executing
.Pa ~/.tcshrc .
.
.It Fl X
Is to
.Fl x
as
.Fl V
is to
.Fl v .
.
.It Fl \-help
Print a help message on the standard output and exit. (+)
.
.It Fl \-version
Print the version/platform/compilation options on the standard output and exit.
This information is also contained in the
.Ic version
shell variable. (+)
.El
.Pp
After processing of flag arguments, if arguments remain but none of the
.Fl c ,
.Fl i ,
.Fl s ,
or
.Fl t
options were given, the first argument is taken as the name of a file of
commands, or
.Dq script ,
to be executed.
The shell opens this file and saves its name for possible
resubstitution by
.Ql $0 .
Because many systems use either the standard
version 6 or version 7 shells whose shell scripts are not compatible
with this shell, the shell uses such a
.Dq standard
shell to execute a script
whose first character is not a
.Ql # ,
i.e., that does not start with a
comment.
.Pp
Remaining arguments are placed in the
.Ic argv
shell variable.
.
.Ss Startup and shutdown
A login shell begins by executing commands from the system files
.Pa /etc/csh.cshrc
and
.Pa /etc/csh.login .
It then executes commands from files in the user's
.Pa home
directory:
first
.Pa ~/.tcshrc (+)
or, if
.Pa ~/.tcshrc
is not found,
.Pa ~/.cshrc ,
then the contents of
.Pa ~/.history
(or the value of the
.Ic histfile
shell variable) are loaded into memory, then
.Pa ~/.login ,
and finally
.Pa ~/.cshdirs
(or the value of the
.Ic dirsfile
shell variable) (+).
The shell may read
.Pa /etc/csh.login
before instead of after
.Pa /etc/csh.cshrc ,
and
.Pa ~/.login
before instead of after
.Pa ~/.tcshrc
or
.Pa ~/.cshrc
and
.Pa ~/.history ,
if so compiled;
see the
.Ic version
shell variable. (+)
.Pp
Non-login shells read only
.Pa /etc/csh.cshrc
and
.Pa ~/.tcshrc
or
.Pa ~/.cshrc
on startup.
.Pp
For examples of startup files, please consult:
.Lk http://tcshrc.sourceforge.net
.Pp
Commands like
.Xr stty 1
and
.Xr tset 1 ,
which need be run only once per login, usually go in one's
.Pa ~/.login
file.
Users who need to use the same set of files with both
.Xr csh 1
and
.Nm
can have only a
.Pa ~/.cshrc
which checks for the existence of the
.Ic tcsh
shell variable (q.v.) before using
.Nm Ns
\-specific commands,
or can have both a
.Pa ~/.cshrc
and a
.Pa ~/.tcshrc
which
.Ic source Ns
s
(see the builtin command)
.Pa ~/.cshrc .
The rest of this manual uses
.Pa ~/.tcshrc
to mean
.Pa ~/.tcshrc
or,
if
.Pa ~/.tcshrc
is not found,
.Pa ~/.cshrc .
.Pp
In the normal case, the shell begins reading commands from the terminal,
prompting with
.Sq Li >\ \& .
(Processing of arguments and the use of the shell to
process files containing command scripts are described later.)
The shell repeatedly reads a line of command input, breaks it into words,
places it on the command history list, parses it and executes each command
in the line.
.Pp
One can log out by typing
.Sq ^D
on an empty line,
.Ic logout
or
.Ic login
or
via the shell's autologout mechanism (see the
.Ic autologout
shell variable).
When a login shell terminates it sets the
.Ic logout
shell variable to
.Ql normal
or
.Ql automatic
as appropriate, then executes commands from the files
.Pa /etc/csh.logout
and
.Pa ~/.logout .
The shell may drop DTR on logout
if so compiled; see the
.Ic version
shell variable.
.Pp
The names of the system login and logout files vary from system to system for
compatibility with different
.Xr csh 1
variants; see
.Sx FILES .
.
.Ss Editing
We first describe
.Sx The command-line editor .
The
.Sx Completion and listing
and
.Sx Spelling correction
sections describe two sets of functionality that are implemented as editor
commands but which deserve their own treatment.
Finally,
.Sx Editor commands
lists and describes
the editor commands specific to the shell and their default bindings.
.
.Ss The command-line editor (+)
Command-line input can be edited using key sequences much like those used in
.Xr emacs 1
or
.Xr vi 1 .
The editor is active only when the
.Ic edit
shell variable is set, which it is by default in interactive shells.
The
.Ic bindkey
builtin can display and change key bindings.
.Xr emacs 1 Ns
\-style key bindings are used by default
(unless the shell was compiled otherwise; see the
.Ic version
shell variable),
but
.Ic bindkey
can change the key bindings to
.Xr vi 1 Ns
\-style bindings en masse.
.Pp
The shell always binds the arrow keys (as defined in the
.Ev TERMCAP
environment variable) to:
.Pp
.Bl -tag -width right -offset indent -compact
.It down
.Ic down-history
.It up
.Ic up-history
.It left
.Ic backward-char
.It right
.Ic forward-char
.El
.Pp
unless doing so would alter another single-character binding.
One can set the arrow key escape sequences to the empty string with
.Ic settc
to prevent these bindings.
The ANSI/VT100 sequences for arrow keys are always bound.
.Pp
Other key bindings are, for the most part, what
.Xr emacs 1
and
.Xr vi 1
users would expect and can easily be displayed by
.Ic bindkey ,
so there
is no need to list them here.
Likewise,
.Ic bindkey
can list the editor
commands with a short description of each.
Certain key bindings have different behavior depending if
.Xr emacs 1
or
.Xr vi 1 Ns
\-style bindings are being used; see
.Ic vimode
for more information.
.Pp
Note that editor commands do not have the same notion of a
.Dq word
as does the shell.
The editor delimits words with any non-alphanumeric characters not in
the shell variable
.Ic wordchars ,
while the shell recognizes only whitespace
and some of the characters with special meanings to it, listed under
.Sx Lexical structure .
.
.Ss Completion and listing (+)
The shell is often able to complete words when given a unique abbreviation.
Type part of a word (for example
.Ql ls /usr/lost )
and hit the tab key to run the
.Ic complete-word
editor command.
The shell completes the filename
.Pa /usr/lost
to
.Pa /usr/lost+found/ ,
replacing the incomplete word with the complete word in the input buffer.
(Note the terminal
.Sq Pa / ;
completion adds a
.Ql /
to the end of completed directories and a space to the end of other completed
words, to speed typing and provide a visual indicator of successful completion.
The
.Ic addsuffix
shell variable can be unset to prevent this.)
If no match is found (perhaps
.Pa /usr/lost+found
doesn't exist), the terminal bell rings.
If the word is already complete (perhaps there is a
.Pa /usr/lost
on your
system, or perhaps you were thinking too far ahead and typed the whole thing)
a
.Ql /
or space is added to the end if it isn't already there.
.Pp
Completion works anywhere in the line, not at just the end; completed
text pushes the rest of the line to the right.
Completion in the middle of a word
often results in leftover characters to the right of the cursor that need
to be deleted.
.Pp
Commands and variables can be completed in much the same way.
For example, typing
.Ql em[tab]
would complete
.Ql em
to
.Ql emacs
if
.Ql emacs
were the only command on your system beginning with
.Ql em .
Completion can find a command in any directory in
.Ic path
or if given a full pathname.
Typing
.Ql echo $ar[tab]
would complete
.Ql $ar
to
.Ql $argv
if no other variable began with
.Ql ar .
.Pp
The shell parses the input buffer to determine whether the word you want to
complete should be completed as a filename, command or variable.
The first word in the buffer and the first word following
.Ql \&; ,
.Ql | ,
.Ql |& ,
.Ql && ,
or
.Ql ||
is considered to be a command.
A word beginning with
.Ql $
is considered to be a variable.
Anything else is a filename.
An empty line is
.Dq completed
as a filename.
.Pp
You can list the possible completions of a word at any time by typing
.Sq ^D
to run the
.Ic delete-char-or-list-or-eof
editor command.
The shell lists the possible completions using the
.Ic ls\-F
builtin (q.v.)
and reprints the prompt and unfinished command line, for example:
.Bd -literal -offset indent
> ls /usr/l[^D]
lbin/       lib/        local/      lost+found/
> ls /usr/l
.Ed
.Pp
If the
.Ic autolist
shell variable is set, the shell lists the remaining
choices (if any) whenever completion fails:
.Bd -literal -offset indent
> set autolist
> nm /usr/lib/libt[tab]
libtermcap.a@ libtermlib.a@
> nm /usr/lib/libterm
.Ed
.Pp
If the
.Ic autolist
shell variable is set to
.Ql ambiguous ,
choices are listed only when
completion fails and adds no new characters to the word being completed.
.Pp
A filename to be completed can contain variables, your own or others' home
directories abbreviated with
.Ql ~
(see
.Sx Filename substitution )
and directory stack entries abbreviated with
.Ql =
(see
.Sx Directory stack substitution ) .
For example,
.Bd -literal -offset indent
> ls ~k[^D]
kahn    kas     kellogg
> ls ~ke[tab]
> ls ~kellogg/
.Ed
.Pp
or
.Bd -literal -offset indent
> set local = /usr/local
> ls $lo[tab]
> ls $local/[^D]
bin/ etc/ lib/ man/ src/
> ls $local/
.Ed
.Pp
Note that variables can also be expanded explicitly with the
.Ic expand-variables
editor command.
.Pp
.Ic delete-char-or-list-or-eof
lists at only the end of the line;
in the middle of a line it deletes the character under the cursor and
on an empty line it logs one out or, if the
.Ic ignoreeof
variable is set, does nothing.
.Sq M-^D ,
bound to the editor command
.Ic list-choices ,
lists completion
possibilities anywhere on a line, and
.Ic list-choices
(or any one of the
related editor commands that do or don't delete, list and/or log out,
listed under
.Ic delete-char-or-list-or-eof )
can be bound to
.Sq ^D
with the
.Ic bindkey
builtin command if so desired.
.Pp
The
.Ic complete-word-fwd
and
.Ic complete-word-back
editor commands
(not bound to any keys by default) can be used to cycle up and down through
the list of possible completions, replacing the current word with the next or
previous word in the list.
.Pp
The shell variable
.Ic fignore
can be set to a list of suffixes to be ignored by completion.
Consider the following:
.Bd -literal -offset indent
> ls
Makefile        condiments.h~   main.o          side.c
README          main.c          meal            side.o
condiments.h    main.c~
> set fignore = (.o \e~)
> emacs ma[^D]
main.c   main.c~  main.o
> emacs ma[tab]
> emacs main.c
.Ed
.Pp
.Ql main.c~
and
.Ql main.o
are ignored by completion (but not listing),
because they end in suffixes in
.Ic fignore .
Note that a
.Ql \e
was needed in front of
.Ql ~
to prevent it from being expanded to
.Ic home
as described under
.Sx Filename substitution .
.Ic fignore
is ignored if only one completion is possible.
.Pp
If the
.Ic complete
shell variable is set to
.Ql enhance ,
completion 1) ignores case and 2) considers periods, hyphens and underscores
.Po
.Ql \&. ,
.Ql \- ,
and
.Ql _
.Pc
to be word separators and hyphens and underscores to be equivalent.
If you had the following files
.Bd -literal -offset indent
comp.lang.c      comp.lang.perl   comp.std.c++
comp.lang.c++    comp.std.c
.Ed
.Pp
and typed
.Ql mail \-f c.l.c[tab] ,
it would be completed to
.Ql mail \-f comp.lang.c ,
and
.Sq ^D
would list
.Ql comp.lang.c
and
.Ql comp.lang.c++ .
.Ql mail \-f c..c++[^D]
would list
.Ql comp.lang.c++
and
.Ql comp.std.c++ .
Typing
.Ql rm a\-\-file[^D]
in the following directory
.Bd -literal -offset indent
A_silly_file    a-hyphenated-file    another_silly_file
.Ed
.Pp
would list all three files, because case is ignored and hyphens and
underscores are equivalent.
Periods, however, are not equivalent to
hyphens or underscores.
.Pp
If the
.Ic complete
shell variable is set to
.Ql Enhance ,
completion
ignores case and differences between a hyphen and an underscore word
separator only when the user types a lowercase character or a hyphen.
Entering an uppercase character or an underscore will not match the
corresponding lowercase character or hyphen word separator.
Typing
.Ql rm a\-\-file[^D]
in the directory of the previous example would
still list all three files, but typing
.Ql rm A\-\-file
would match only
.Ql A_silly_file
and typing
.Ql rm a__file[^D]
would match just
.Ql A_silly_file
and
.Ql another_silly_file
because the user explicitly used an uppercase
or an underscore character.
.Pp
Completion and listing are affected by several other shell variables:
.Ic recexact
can be set to complete on the shortest possible unique
match, even if more typing might result in a longer match:
.Bd -literal -offset indent
> ls
fodder   foo      food     foonly
> set recexact
> rm fo[tab]
.Ed
.Pp
just beeps, because
.Ql fo
could expand to
.Ql fod
or
.Ql foo ,
but if we type another
.Ql o ,
.Bd -literal -offset indent
> rm foo[tab]
> rm foo
.Ed
.Pp
the completion completes on
.Ql foo ,
even though
.Ql food
and
.Ql foonly
also match.
.Ic autoexpand
can be set to run the
.Ic expand-history
editor command
before each completion attempt,
.Ic autocorrect
can be set to
spelling-correct the word to be completed (see
.Sx Spelling correction )
before each completion attempt and
.Ic correct
can be set to complete commands automatically after one hits
return.
.Ic matchbeep
can be set to make completion beep or not beep in a variety
of situations, and
.Ic nobeep
can be set to never beep at all.
.Ic nostat
can be set to a list of directories and/or patterns that
match directories to prevent the completion mechanism from
.Xr stat 2 Ns
ing
those directories.
.Ic listmax
and
.Ic listmaxrows
can be set to limit the number of items
and rows (respectively) that are listed without asking first.
.Ic recognize_only_executables
can be set to make the shell list only
executables when listing commands, but it is quite slow.
.Pp
Finally, the
.Ic complete
builtin command can be used to tell the shell how
to complete words other than filenames, commands and variables.
Completion and listing do not work on glob-patterns (see
.Sx Filename substitution ) ,
but the
.Ic list-glob
and
.Ic expand-glob
editor commands perform
equivalent functions for glob-patterns.
.
.Ss Spelling correction (+)
The shell can sometimes correct the spelling of filenames, commands and
variable names as well as completing and listing them.
.Pp
Individual words can be spelling-corrected with the
.Ic spell-word
editor command (usually bound to
.Sq M-s
and
.Sq M-S )
and the entire input buffer with
.Ic spell-line
(usually bound to
.Sq M-$ ) .
The
.Ic correct
shell variable can be set to
.Ql cmd
to correct the command name or
.Ql all
to correct the entire line each time return is typed, and
.Ic autocorrect
can be set to correct the word to be completed
before each completion attempt.
.Pp
When spelling correction is invoked in any of these ways and
the shell thinks that any part of the command line is misspelled,
it prompts with the corrected line:
.Bd -literal -offset indent
> set correct = cmd
> lz /usr/bin
CORRECT>ls /usr/bin (y|n|e|a)?
.Ed
.Pp
One can answer
.Ql y
or space to execute the corrected line,
.Ql e
to leave the uncorrected command in the input buffer,
.Ql a
to abort the command as if
.Sq ^C
had been hit, and
anything else to execute the original line unchanged.
.Pp
Spelling correction recognizes user-defined completions (see the
.Ic complete
builtin command).
If an input word in a position for
which a completion is defined resembles a word in the completion list,
spelling correction registers a misspelling and suggests the latter
word as a correction.
However, if the input word does not match any of
the possible completions for that position, spelling correction does
not register a misspelling.
.Pp
Like completion, spelling correction works anywhere in the line,
pushing the rest of the line to the right and possibly leaving
extra characters to the right of the cursor.
.
.Ss Editor commands (+)
.Ic bindkey
lists key bindings and
.Ic bindkey \-l
lists and briefly describes editor commands.
Only new or especially interesting editor commands are described here.
See
.Xr emacs 1
and
.Xr vi 1
for descriptions of each editor's key bindings.
.Pp
The character or characters to which each command is bound by default is
given in parentheses.
.Sq ^ Ns Ar character
means a control character and
.Sq M- Ns Ar character
a meta character, typed as
.Sq escape- Ns Ar character
on terminals without a meta key.
Case counts, but commands that are bound
to letters by default are bound to both lower- and uppercase letters for
convenience.
.Pp
Supported editor commands are:
.Bl -tag -width indent
.
.It Ic backward-char No (^B, left)
Move back a character.
Cursor behavior modified by
.Ic vimode .
.
.It Ic backward-delete-word No (M-^H, M-^?)
Cut from beginning of current word to cursor - saved in cut buffer.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic backward-word No (M-b, M-B)
Move to beginning of current word.
Word boundary and cursor behavior modified by
.Ic vimode .
.
.It Ic beginning-of-line No (^A, home)
Move to beginning of line.
Cursor behavior modified by
.Ic vimode .
.
.It Ic capitalize-word No (M-c, M-C)
Capitalize the characters from cursor to end of current word.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic complete-word No (tab)
Completes a word as described under
.Sx Completion and listing .
.
.It Ic complete-word-back No (not bound)
Like
.Ic complete-word-fwd ,
but steps up from the end of the list.
.
.It Ic complete-word-fwd No (not bound)
Replaces the current word with the first word in the list of possible
completions.
May be repeated to step down through the list.
At the end of the list, beeps and reverts to the incomplete word.
.
.It Ic complete-word-raw No (^X-tab)
Like
.Ic complete-word ,
but ignores user-defined completions.
.
.It Ic copy-prev-word No (M-^_)
Copies the previous word in the current line into the input buffer.
See also
.Ic insert-last-word .
Word boundary behavior modified by
.Ic vimode .
.
.It Ic dabbrev-expand No (M-/)
Expands the current word to the most recent preceding one for which
the current is a leading substring, wrapping around the history list
(once) if necessary.
Repeating
.Ic dabbrev-expand
without any intervening typing
changes to the next previous word etc., skipping identical matches
much like
.Ic history-search-backward
does.
.
.It Ic delete-char No (not bound)
Deletes the character under the cursor.
See also
.Ic delete-char-or-list-or-eof .
Cursor behavior modified by
.Ic vimode .
.
.It Ic delete-char-or-eof No (not bound)
Does
.Ic delete-char
if there is a character under the cursor or
.Ic end-of-file
on an empty line.
See also
.Ic delete-char-or-list-or-eof .
Cursor behavior modified by
.Ic vimode .
.
.It Ic delete-char-or-list No (not bound)
Does
.Ic delete-char
if there is a character under the cursor
or
.Ic list-choices
at the end of the line.
See also
.Ic delete-char-or-list-or-eof .
.
.It Ic delete-char-or-list-or-eof No (^D)
Does
.Ic delete-char
if there is a character under the cursor,
.Ic list-choices
at the end of the line or
.Ic end-of-file
on an empty line.
See also those three commands, each of which does only a single action, and
.Ic delete-char-or-eof ,
.Ic delete-char-or-list ,
and
.Ic list-or-eof ,
each of which does a different two out of the three.
.
.It Ic delete-word No (M-d, M-D)
Cut from cursor to end of current word - save in cut buffer.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic down-history No (down-arrow, ^N)
Like
.Ic up-history ,
but steps down, stopping at the original input line.
.
.It Ic downcase-word No (M-l, M-L)
Lowercase the characters from cursor to end of current word.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic end-of-file No (not bound)
Signals an end of file, causing the shell to exit unless the
.Ic ignoreeof
shell variable (q.v.) is set to prevent this.
See also
.Ic delete-char-or-list-or-eof .
.
.It Ic end-of-line No (^E, end)
Move cursor to end of line.
Cursor behavior modified by
.Ic vimode .
.
.It Ic expand-history No (M-space)
Expands history substitutions in the current word.
See
.Sx History substitution .
See also
.Ic magic-space ,
.Ic toggle-literal-history ,
and the
.Ic autoexpand
shell variable.
.
.It Ic expand-glob No (^X-*)
Expands the glob-pattern to the left of the cursor.
See
.Sx Filename substitution .
.
.It Ic expand-line No (not bound)
Like
.Ic expand-history ,
but expands history substitutions in each word in the input buffer.
.
.It Ic expand-variables No (^X-$)
Expands the variable to the left of the cursor.
See
.Sx Variable substitution .
.
.It Ic forward-char No (^F, right)
Move forward one character.
Cursor behavior modified by
.Ic vimode .
.
.It Ic forward-word No (M-f, M-F)
Move forward to end of current word.
Word boundary and cursor behavior modified by
.Ic vimode .
.
.It Ic history-search-backward No (M-p, M-P)
Searches backwards through the history list for a command beginning with
the current contents of the input buffer up to the cursor and copies it
into the input buffer.
The search string may be a glob-pattern (see
.Sx Filename substitution )
containing
.Ql * ,
.Ql \&? ,
.Ql [] ,
or
.Ql {} .
.Ic up-history
and
.Ic down-history
will proceed from the
appropriate point in the history list.
Emacs mode only.
See also
.Ic history-search-forward
and
.Ic i-search-back .
.
.It Ic history-search-forward No (M-n, M-N)
Like
.Ic history-search-backward ,
but searches forward.
.
.It Ic i-search-back No (not bound)
Searches backward like
.Ic history-search-backward ,
copies the first match
into the input buffer with the cursor positioned at the end of the pattern,
and prompts with
.Sq Li bck:\ \&
and the first match.
Additional characters may be
typed to extend the search,
.Ic i-search-back
may be typed to continue
searching with the same pattern, wrapping around the history list if
necessary,
.Ic ( i-search-back
must be bound to a
single character for this to work) or one of the following special characters
may be typed:
.Pp
.Bl -tag -width indent -compact
.It ^W
Appends the rest of the word under the cursor to the search pattern.
.It delete
(or any character bound to
.Ic backward-delete-char )
Undoes the effect of the last character typed and deletes a character
from the search pattern if appropriate.
.It ^G
If the previous search was successful, aborts the entire search.
If not, goes back to the last successful search.
.It escape
Ends the search, leaving the current line in the input buffer.
.El
.Pp
Any other character not bound to
.Ic self-insert-command
terminates the
search, leaving the current line in the input buffer, and
is then interpreted as normal input.
In particular, a carriage return
causes the current line to be executed.
See also
.Ic i-search-fwd
and
.Ic history-search-backward .
Word boundary behavior modified by
.Ic vimode .
.
.It Ic i-search-fwd No (not bound)
Like
.Ic i-search-back ,
but searches forward.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic insert-last-word No (M-_)
Inserts the last word of the previous input line
.Pq Ql \&!$
into the input buffer.
See also
.Ic copy-prev-word .
.
.It Ic list-choices No (M-^D)
Lists completion possibilities as described under
.Sx Completion and listing .
See also
.Ic delete-char-or-list-or-eof
and
.Ic list-choices-raw .
.
.It Ic list-choices-raw No (^X-^D)
Like
.Ic list-choices ,
but ignores user-defined completions.
.
.It Ic list-glob No (^X-g, ^X-G)
Lists (via the
.Ic ls\-F
builtin) matches to the glob-pattern
(see
.Sx Filename substitution )
to the left of the cursor.
.
.It Ic list-or-eof No (not bound)
Does
.Ic list-choices
or
.Ic end-of-file
on an empty line.
See also
.Ic delete-char-or-list-or-eof .
.
.It Ic magic-space No (not bound)
Expands history substitutions in the current line,
like
.Ic expand-history ,
and inserts a space.
.Ic magic-space
is designed to be bound to the space bar,
but is not bound by default.
.
.It Ic normalize-command No (^X-?)
Searches for the current word in
.Ev PATH
and, if it is found, replaces it with
the full path to the executable.
Special characters are quoted.
Aliases are
expanded and quoted but commands within aliases are not.
This command is
useful with commands that take commands as arguments, e.g.,
.Ql dbx
and
.Ql sh \-x .
.
.It Ic normalize-path No (^X-n, ^X-N)
Expands the current word as described under the
.Ql expand
setting
of the
.Ic symlinks
shell variable.
.
.It Ic overwrite-mode No (unbound)
Toggles between input and overwrite modes.
.
.It Ic run-fg-editor No (M-^Z)
Saves the current input line and
looks for a stopped job where the file name portion of its first word
is found in the
.Ic editors
shell variable.
If
.Ic editors
is not set, then the file name portion of the
.Ev EDITOR
environment variable
.Ql ( ed
if unset)
and the
.Ev VISUAL
environment variable
.Ql ( vi
if unset)
will be used.
If such a job is found, it is restarted as if
.Ql fg % Ns Ar job
had been typed.
This is used to toggle back and forth between an editor and
the shell easily.
Some people bind this command to
.Sq ^Z
so they
can do this even more easily.
.
.It Ic run-help No (M-h, M-H)
Searches for documentation on the current command, using the same notion of
.Dq current command
as the completion routines, and prints it.
There is no way
to use a pager;
.Ic run-help
is designed for short help files.
If the special alias
.Ic helpcommand
is defined, it is run with the
command name as a sole argument.
Else,
documentation should be in a file named
.Pa command.help ,
.Pa command.1 ,
.Pa command.6 ,
.Pa command.8 ,
or
.Pa command ,
which should be in one
of the directories listed in the
.Ev HPATH
environment variable.
If there is more than one help file only the first is printed.
.
.It Ic self-insert-command No (text characters)
In insert mode (the default), inserts the typed character into
the input line after the character under the cursor.
In overwrite mode, replaces the character under the cursor with the typed character.
The input mode is normally preserved between lines, but the
.Ic inputmode
shell variable can be set to
.Ql insert
or
.Ql overwrite
to put the
editor in that mode at the beginning of each line.
See also
.Ic overwrite-mode .
.
.It Ic sequence-lead-in No (arrow prefix, meta prefix, ^X)
Indicates that the following characters are part of a
multi-key sequence.
Binding a command to a multi-key sequence really creates
two bindings: the first character to
.Ic sequence-lead-in
and the
whole sequence to the command.
All sequences beginning with a character
bound to
.Ic sequence-lead-in
are effectively bound to
.Ic undefined-key
unless bound to another command.
.
.It Ic spell-line No (M-$)
Attempts to correct the spelling of each word in the input buffer, like
.Ic spell-word ,
but ignores words whose first character is one of
.Ql \- ,
.Ql \&! ,
.Ql ^ ,
or
.Ql % ,
or which contain
.Ql \e ,
.Ql * ,
or
.Ql \&? ,
to avoid problems with switches, substitutions and the like.
See
.Sx Spelling correction .
.
.It Ic spell-word No (M-s, M-S)
Attempts to correct the spelling of the current word as described under
.Sx Spelling correction .
Checks each component of a word which appears to be a pathname.
.
.It Ic toggle-literal-history No (M-r, M-R)
Expands or
unexpands
history substitutions in the input buffer.
See also
.Ic expand-history
and the
.Ic autoexpand
shell variable.
.
.It Ic undefined-key No (any unbound key)
Beeps.
.
.It Ic up-history No (up-arrow, ^P)
Copies the previous entry in the history list into the input buffer.
If
.Ic histlit
is set, uses the literal form of the entry.
May be repeated to step up through the history list, stopping at the top.
.
.It Ic upcase-word No (M-u, M-U)
Uppercase the characters from cursor to end of current word.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic vi-beginning-of-next-word No (not bound)
Vi goto the beginning of next word.
Word boundary and cursor behavior modified by
.Ic vimode .
.
.It Ic vi-eword No (not bound)
Vi move to the end of the current word.
Word boundary behavior modified by
.Ic vimode .
.
.It Ic vi-search-back No (?)
Prompts with
.Sq Li \&?
for a search string (which may be a glob-pattern, as with
.Ic history-search-backward ) ,
searches for it and copies it into the input buffer.
The bell rings if no match is found.
Hitting return ends the search and leaves the last match in the input
buffer.
Hitting escape ends the search and executes the match.
.Ic vi
mode only.
.
.It Ic vi-search-fwd No (/)
Like
.Ic vi-search-back ,
but searches forward.
.
.It Ic which-command No (M-?)
Does a
.Ic which
(see the description of the builtin command) on the
first word of the input buffer.
.
.It Ic yank-pop No (M-y)
When executed immediately after a
.Ic yank
or another
.Ic yank-pop ,
replaces the yanked string with the next previous string from the
killring. This also has the effect of rotating the killring, such that
this string will be considered the most recently killed by a later
.Ic yank
command. Repeating
.Ic yank-pop
will cycle through the
killring any number of times.
.El
.
.Ss Lexical structure
The shell splits input lines into words at blanks and tabs.
The special
characters
.Ql \&& ,
.Ql | ,
.Ql \&; ,
.Ql < ,
.Ql > ,
.Ql \&( ,
and
.Ql \&) ,
and the doubled characters
.Ql && ,
.Ql || ,
.Ql << ,
and
.Ql >>
are always separate words, whether or not they are
surrounded by whitespace.
.Pp
When the shell's input is not a terminal, the character
.Ql #
is taken to begin a
comment.
Each
.Ql #
and the rest of the input line on which it appears is
discarded before further parsing.
.Pp
A special character (including a blank or tab) may be prevented from having
its special meaning, and possibly made part of another word, by preceding it
with a backslash
.Pq Ql \e
or enclosing it in single
.Pq Ql \&' ,
double
.Pq Ql \&" ,
or
backward
.Pq Ql \&`
quotes.
When not otherwise quoted a newline preceded by a
.Ql \e
is equivalent to a blank, but inside quotes this sequence results in a
newline.
.Pp
Furthermore, all
.Sx Substitutions
(see below) except
.Sx History substitution
can be prevented by enclosing the strings (or parts of strings)
in which they appear with single quotes or by quoting the crucial character(s)
(e.g.,
.Ql $
or
.Ql \&`
for
.Sx Variable substitution
or
.Sx Command substitution
respectively)
with
.Ql \e .
.Sx ( Alias substitution
is no exception: quoting in any way any
character of a word for which an
.Ic alias
has been defined prevents
substitution of the alias.
The usual way of quoting an alias is to precede it
with a backslash.)
.Sx History substitution
is prevented by
backslashes but not by single quotes.
Strings quoted with double or backward
quotes undergo
.Sx Variable substitution
and
.Sx Command substitution ,
but other substitutions are prevented.
.Pp
Text inside single or double quotes becomes a single word (or part of one).
Metacharacters in these strings, including blanks and tabs, do not form
separate words.
Only in one special case (see
.Sx Command substitution
below) can a double-quoted string yield parts of more than one word;
single-quoted strings never do.
Backward quotes are special: they signal
.Sx Command substitution
(q.v.), which may result in more than one word.
.Pp
C-style escape sequences can be used in single quoted strings by
preceding the leading quote with
.Ql $ .
(+)
See
.Sx Escape sequences
for
a complete list of recognized escape sequences.
.Pp
Quoting complex strings, particularly strings which themselves contain quoting
characters, can be confusing.
Remember that quotes need not be used as they are
in human writing!
It may be easier to quote not an entire string, but only
those parts of the string which need quoting, using different types of quoting
to do so if appropriate.
.Pp
The
.Ic backslash_quote
shell variable (q.v.) can be set to make backslashes
always quote
.Ql \e ,
.Ql \&' ,
and
.Ql \&"
(+). This may make complex quoting tasks
easier, but it can cause syntax errors in
.Xr csh 1
scripts.
.
.Ss Escape sequences (+)
The following escape sequences are always recognized inside a string
constructed using
.Ql $'' ,
and optionally by the
.Ic echo
builtin command as
controlled by the
.Ic echo_style
shell variable.
.Pp
Supported escape sequences are:
.Pp
.Bl -tag -width 12n -offset indent -compact
.It Li \ea
Bell.
.It Li \eb
Backspace.
.It Li \ec Ns Ar c
The control character denoted by
.Ql ^ Ns Ar c
in
.Xr stty 1 .
If
.Ar c
is a backslash, it must be doubled.
.It Li \ee
Escape.
.It Li \ef
Form feed.
.It Li \en
Newline.
.It Li \er
Carriage return.
.It Li \et
Horizontal tab.
.It Li \ev
Vertical tab.
.It Li \e\e
Literal backslash.
.It Li \e\&'
Literal single quote.
.It Li \e\&"
Literal double quote.
.It Li \e Ns Ar nnn
The character corresponding to the octal number
.Ar nnn .
.It Li \ex Ns Ar nn
The character corresponding to the hexadecimal number
.Ar nn
(1\-2 hexadecimal digits).
.It Li \ex{ Ns Ar nnnnnnnn Ns Li }
The character corresponding to the hexadecimal number
.Ar nnnnnnnn
(1\-8 hexadecimal digits).
.It Li \eu Ns Ar nnnn
The Unicode code point
.Ar nnnn
(1\-4 hexadecimal digits).
.It Li \eU Ns Ar nnnnnnnn
The Unicode code point
.Ar nnnnnnnn
(1\-8 hexadecimal digits).
.El
.Pp
The implementations of
.Ql \ex ,
.Ql \eu ,
and
.Ql \eU
in other shells may take a varying number of digits.  It is often safest
to use leading zeros to provide the maximum expected number of digits.
.
.Ss Substitutions
We now describe the various transformations the shell performs on the input in
the order in which they occur.
We note in passing the data structures involved
and the commands and variables which affect them.
Remember that substitutions
can be prevented by quoting as described under
.Sx Lexical structure .
.
.Ss History substitution
Each command, or
.Dq event ,
input from the terminal is saved in the history list.
The previous command is always saved, and the
.Ic history
shell
variable can be set to a number to save that many commands.
The
.Ic histdup
shell variable can be set to not save duplicate events or consecutive duplicate
events.
.Pp
Saved commands are numbered sequentially from 1 and stamped with the time.
It is not usually necessary to use event numbers, but the current event number
can be made part of the prompt by placing an
.Ql \&!
in the
.Ic prompt
shell variable.
.Pp
By default history entries are displayed by printing each parsed token
separated by space; thus the redirection operator
.Ql >\&&\&!
will be displayed as
.Ql >\0\&&\0\&! .
The shell actually saves history in expanded and literal (unexpanded) forms.
If the
.Ic histlit
shell variable is set, commands that display and store
history use the literal form.
.Pp
The
.Ic history
builtin command can print, store in a file, restore
and clear the history list at any time,
and the
.Ic savehist
and
.Ic histfile
shell variables can be set to
store the history list automatically on logout and restore it on login.
.Pp
History substitutions introduce words from the history list into the input
stream, making it easy to repeat commands, repeat arguments of a previous
command in the current command, or fix spelling mistakes in the previous
command with little typing and a high degree of confidence.
.Pp
History substitutions begin with the character
.Ql \&! .
They may begin anywhere in
the input stream, but they do not nest.
The
.Ql \&!
may be preceded by a
.Ql \e
to
prevent its special meaning; for convenience, a
.Ql \&!
is passed unchanged when it
is followed by a blank, tab, newline,
.Ql =
or
.Ql \&( .
History substitutions also
occur when an input line begins with
.Ql ^ .
This special abbreviation will be
described later.
The characters used to signal history substitution
.Po
.Ql \&!
and
.Ql ^
.Pc
can be changed by setting the
.Ic histchars
shell variable.
Any input
line which contains a history substitution is printed before it is executed.
.Pp
A history substitution may have an
.Dq event specification ,
which indicates the event from which words are to be taken, a
.Dq word designator ,
which selects particular words from the chosen event, and/or a
.Dq modifier ,
which manipulates the selected words.
.Pp
An event specification can be:
.Pp
.Bl -tag -width 5n -offset indent -compact
.
.It Ar n
A number, referring to a particular event.
.
.It Li \- Ns Ar n
An offset, referring to the event
.Ar n
before the current event.
.
.It Li #
The current event.
This should be used carefully in
.Xr csh 1 ,
where there is no check for recursion.
.Nm
allows 10 levels of recursion. (+)
.
.It Li \&!
The previous event (equivalent to
.Ql \-1 ) .
.
.It Ar s
The most recent event whose first word begins with the string
.Ar s .
.
.It Li ? Ns Ar s Ns Li ?
The most recent event which contains the string
.Ar s .
The second
.Ql \&?
can be omitted if it is immediately followed by a newline.
.El
.Pp
For example, consider this bit of someone's history list:
.Bd -literal -offset indent
 9  8:30    nroff \-man wumpus.man
10  8:31    cp wumpus.man wumpus.man.old
11  8:36    vi wumpus.man
12  8:37    diff wumpus.man.old wumpus.man
.Ed
.Pp
The commands are shown with their event numbers and time stamps.
The current event, which we haven't typed in yet, is event 13.
.Ql !11
and
.Ql !\-2
refer to event 11.
.Ql \&!!
refers to the previous event, 12.
.Ql \&!!
can be abbreviated
.Ql \&!
if it is
followed by
.Ql \&:
.Po
.Ql \&:
is described below
.Pc .
.Ql !n
refers to event 9, which begins with
.Ql n .
.Ql !?old?
also refers to event 12, which contains
.Ql old .
Without word designators or modifiers history references simply expand to the
entire event, so we might type
.Ql !cp
to redo the copy command or
.Ql !!|more
if the
.Ql diff
output scrolled off the top of the screen.
.Pp
History references may be insulated from the surrounding text with braces if
necessary.
For example,
.Ql !vdoc
would look for a command beginning with
.Ql vdoc ,
and, in this example, not find one, but
.Ql !{v}doc
would expand
unambiguously to
.Ql vi wumpus.mandoc .
Even in braces, history substitutions do not nest.
.Pp
(+) While
.Xr csh 1
expands, for example,
.Ql !3d
to event 3 with the
letter
.Ql d
appended to it,
.Nm
expands it to the last event beginning
with
.Ql 3d ;
only completely numeric arguments are treated as event numbers.
This makes it possible to recall events beginning with numbers.
To expand
.Ql !3d
as in
.Xr csh 1
type
.Ql !{3}d .
.Pp
To select words from an event we can follow the event specification by a
.Ql \&:
and a designator for the desired words.
The words of an input line are
numbered from 0, the first (usually command) word being 0, the second word
(first argument) being 1, etc.
.Pp
The basic word designators are:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li 0
The first (command) word.
.
.It Ar n
The
.Ar n Ns
th argument.
.
.It Li ^
The first argument, equivalent to
.Ql 1 .
.
.It Li $
The last argument.
.
.It Li %
The word matched by an
.Li ? Ns Ar s Ns Li ? No search.
.
.It Ar x Ns Li \- Ns Ar y
A range of words.
.
.It Li \- Ns Ar y
Equivalent to
.Ql 0\- Ns Ar y .
.
.It Li *
Equivalent to
.Ql ^\-$ ,
but returns nothing if the event contains only 1 word.
.
.It Ar x Ns Li *
Equivalent to
.Sq Ar x Ns Li \-$ .
.
.It Ar x Ns Li \-
Equivalent to
.Sq Ar x Ns Li * ,
but omitting the last word
.Pq Ql $ .
.El
.Pp
Selected words are inserted into the command line separated by single blanks.
For example, the
.Ql diff
command in the previous example might have been
typed as
.Ql diff !!:1.old !!:1
(using
.Ql \&:1
to select the first argument
from the previous event) or
.Ql diff !\-2:2 !\-2:1
to select and swap the
arguments from the
.Ql cp
command.
If we didn't care about the order of the
.Ql diff
we might have said
.Ql diff !\-2:1\-2
or simply
.Ql diff !\-2:* .
The
.Ql cp
command might have been written
.Ql cp wumpus.man !#:1.old ,
using
.Ql #
to refer to the current event.
.Ql !n:\- hurkle.man
would reuse the first two words from the
.Ql nroff
command
to type
.Ql nroff \-man hurkle.man .
.Pp
The
.Ql \&:
separating the event specification from the word designator can be
omitted if the argument selector begins with a
.Ql ^ ,
.Ql $ ,
.Ql * ,
.Ql % ,
or
.Ql \- .
For example, our
.Ql diff
command might have been
.Ql diff !!^.old !!^
or,
equivalently,
.Ql diff !!$.old !!$ .
However, if
.Ql \&!!
is abbreviated
.Ql \&! ,
an argument selector beginning with
.Ql \-
will be interpreted as an event
specification.
.Pp
A history reference may have a word designator but no event specification.
It then references the previous command.
Continuing our
.Ql diff
example, we could have said simply
.Ql diff !^.old !^
or, to get the arguments in the opposite order, just
.Ql diff !* .
.Pp
The word or words in a history reference can be edited, or
.Dq modified ,
by following it with one or more modifiers, each preceded by a
.Ql \&: :
.Pp
.Bl -tag -width 6n -offset indent -compact
.
.It Li h
Remove a trailing pathname component, leaving the head.
.
.It Li t
Remove all leading pathname components, leaving the tail.
.
.It Li r
Remove a filename extension
.Sq . Ns Ar xxx ,
leaving the root name.
.
.It Li e
Remove all but the extension.
.
.It Li u
Uppercase the first lowercase letter.
.
.It Li l
Lowercase the first uppercase letter.
.
.It Li s/ Ns Ar l Ns Li / Ns Ar r Ns Li /
Substitute
.Ar l
for
.Ar r .
.Ar l
is simply a string like
.Ar r ,
not a regular expression as in
the eponymous
.Xr ed 1
command.
Any character may be used as the delimiter in place of
.Ql / ;
a
.Ql \e
can be used to quote the delimiter inside
.Ar l
and
.Ar r
The character
.Ql &
in the
.Ar r
is replaced by
.Ar l ;
.Ql \e
also quotes
.Ql & .
If
.Ar l
is empty
.Sq ( \& ) ,
the
.Ar l
from a previous substitution or the
.Ar s
from a previous search or event number in event specification is used.
The trailing delimiter may be omitted if it is immediately followed by a
newline.
.
.It Li \&&
Repeat the previous substitution.
.
.It Li g
Apply the following modifier once to each word.
.
.It Li a No (+)
Apply the following modifier as many times as possible to a single word.
.Ql a
and
.Ql g
can be used together to apply a modifier globally.
With the
.Ql s
modifier, only the patterns contained in the original word are
substituted, not patterns that contain any substitution result.
.
.It Li p
Print the new command line but do not execute it.
.
.It Li q
Quote the substituted words, preventing further substitutions.
.
.It Li Q
Same as
.Ql q
but in addition preserve empty variables as a string containing a NUL.
This is useful to preserve positional arguments for example:
.Bd -literal -offset indent -compact
> set args=('arg 1' '' 'arg 3')
> tcsh -f -c 'echo ${#argv}' $args:gQ
3
.Ed
.
.It Li x
Like
.Ql q ,
but break into words at blanks, tabs and newlines.
.El
.Pp
Modifiers are applied to only the first modifiable word (unless
.Ql g
is used).
It is an error for no word to be modifiable.
.Pp
For example, the
.Ql diff
command might have been written as
.Ql diff wumpus.man.old !#^:r ,
using
.Ql \&:r
to remove
.Ql .old
from the first argument on the same line
(`!#^').
We could type
.Ql echo hello out there ,
then
.Ql echo !*:u
to capitalize
.Ql hello ,
.Ql echo !*:au
to upper case the first word to
.QL HELLO ,
or
.Ql echo !*:agu
to upper case all words.
We might follow
.Ql mail \-s \&"I forgot my password\&" rot
with
.Ql !:s/rot/root
to
correct the spelling of
.Ql root
(but see
.Sx Spelling correction
for a
different approach).
.Pp
There is a special abbreviation for substitutions.
.Ql ^ ,
when it is the first character on an input line, is equivalent to
.Ql !:s^ .
Thus we might have said
.Ql ^rot^root
to make the spelling correction in the
previous example.
This is the only history substitution which does not explicitly begin with
.Ql \&! .
.Pp
(+) In
.Xr csh 1
as such, only one modifier may be applied to each history
or variable expansion.
In
.Nm ,
more than one may be used, for example
.Bd -literal -offset indent
% mv wumpus.man /usr/share/man/man1/wumpus.1
% man !$:t:r
man wumpus
.Ed
.Pp
In
.Xr csh 1 ,
the result would be
.Ql wumpus.1:r .
A substitution followed by a
colon may need to be insulated from it with braces:
.Bd -literal -offset indent
> mv a.out /usr/games/wumpus
> setenv PATH !$:h:$PATH
Bad ! modifier: $.
> setenv PATH !{\-2$:h}:$PATH
setenv PATH /usr/games:/bin:/usr/bin:.
.Ed
.Pp
The first attempt would succeed in
.Xr csh 1
but fails in
.Nm ,
because
.Nm
expects another modifier after the second colon
rather than
.Ql $ .
.Pp
Finally, history can be accessed through the editor as well as through
the substitutions just described.
The
.Ic up-history
and
.Ic down-history ,
.Ic history-search-backward
and
.Ic history-search-forward ,
.Ic i-search-back
and
.Ic i-search-fwd ,
.Ic vi-search-back
and
.Ic vi-search-fwd ,
.Ic copy-prev-word
and
.Ic insert-last-word
editor commands search for
events in the history list and copy them into the input buffer.
The
.Ic toggle-literal-history
editor command switches between the
expanded and literal forms of history lines in the input buffer.
.Ic expand-history
and
.Ic expand-line
expand history substitutions
in the current word and in the entire input buffer respectively.
.
.Ss Alias substitution
The shell maintains a list of aliases which can be set, unset and printed by
the
.Ic alias
and
.Ic unalias
commands.
After a command line is parsed
into simple commands (see
.Sx Commands )
the first word of each command,
left-to-right, is checked to see if it has an alias.
If so, the first word is
replaced by the alias.
If the alias contains a history reference, it undergoes
.Sx History substitution
(q.v.) as though the original command were the
previous input line.
If the alias does not contain a history reference, the
argument list is left untouched.
.Pp
Thus if the alias for
.Ql ls
were
.Ql ls \-l
the command
.Ql ls /usr
would become
.Ql ls \-l /usr ,
the argument list here being undisturbed.
If the alias for
.Ql lookup
were
.Ql grep !^ /etc/passwd
then
.Ql lookup bill
would become
.Ql grep bill /etc/passwd .
Aliases can be used to introduce parser metasyntax.
For example,
.Sq alias print 'pr \e!* | lpr'
defines a
.Dq command
.Pq Ql print
which
.Xr pr 1 Ns s
its arguments to the line printer.
.Pp
Alias substitution is repeated until the first word of the command has no
alias.
If an alias substitution does not change the first word (as in the
previous example) it is flagged to prevent a loop.
Other loops are detected and
cause an error.
.Pp
Some aliases are referred to by the shell; see
.Sx Special aliases .
.
.Ss Variable substitution
The shell maintains a list of variables, each of which has as value a list of
zero or more words.
The values of shell variables can be displayed and changed with the
.Ic set
and
.Ic unset
commands.
The system maintains its own list of
.Dq environment
variables.
These can be displayed and changed with
.Ic printenv ,
.Ic setenv ,
and
.Ic unsetenv .
.Pp
(+) Variables may be made read-only with
.Ql set \-r
(q.v.).
Read-only variables may not be modified or unset;
attempting to do so will cause an error.
Once made read-only, a variable cannot be made writable,
so
.Ql set \-r
should be used with caution.
Environment variables cannot be made read-only.
.Pp
Some variables are set by the shell or referred to by it.
For instance, the
.Ic argv
variable is an image of the shell's argument
list, and words of this variable's value are referred to in special ways.
Some of the variables referred to by the shell are toggles;
the shell does not care what their value is, only whether they are set or not.
For instance, the
.Ic verbose
variable is a toggle which causes command
input to be echoed.
The
.Fl v
command line option sets this variable.
.Sx Special shell variables
lists all variables which are referred to by the shell.
.Pp
Other operations treat variables numerically.
The
.Sq Ic @
command permits numeric
calculations to be performed and the result assigned to a variable.
Variable
values are, however, always represented as (zero or more) strings.
For the
purposes of numeric operations, the null string is considered to be zero, and
the second and subsequent words of multi-word values are ignored.
.Pp
After the input line is aliased and parsed, and before each command is
executed, variable substitution is performed keyed by
.Ql $
characters.
This
expansion can be prevented by preceding the
.Ql $
with a
.Ql \e
except within
.Ql \&"
pairs where it
.Em always
occurs, and within
.Ql \&'
pairs where it
.Em never
occurs.
Strings quoted by
.Ql \`
are interpreted later (see
.Sx Command substitution
below) so
.Ql $
substitution does not occur there until later,
if at all.
A
.Ql $
is passed unchanged if followed by a blank, tab, or
end-of-line.
.Pp
Input/output redirections are recognized before variable expansion, and are
variable expanded separately.
Otherwise, the command name and entire argument
list are expanded together.
It is thus possible for the first (command) word
(to this point) to generate more than one word, the first of which becomes the
command name, and the rest of which become arguments.
.Pp
Unless enclosed in
.Ql \&"
or given the
.Ql \&:q
modifier the results of variable
substitution may eventually be command and filename substituted.
Within
.Ql \&" ,
a
variable whose value consists of multiple words expands to a (portion of a)
single word, with the words of the variable's value separated by blanks.
When
the
.Ql \&:q
modifier is applied to a substitution the variable will expand to
multiple words with each word separated by a blank and quoted to prevent later
command or filename substitution.
.Pp
The following metasequences are provided for introducing variable values into
the shell input:
.Pp
.Bl -tag -width 10n -offset indent -compact
.
.It Li $ Ns Ar name
.It Li ${ Ns Ar name Ns Li }
Substitutes the words of the value of variable
.Ar name ,
each separated
by a blank.
Braces insulate
.Ar name
from following characters which would
otherwise be part of it.
Shell variables have names consisting of
letters and digits starting with a letter.
The underscore character is
considered a letter.
If
.Ar name
is not a shell variable, but is set in the
environment, then that value is returned (but some of the other forms
given below are not available in this case).
.
.Pp
.It Li $ Ns Ar name Ns Li [ Ns Ar selector Ns Li ]
.It Li ${ Ns Ar name Ns Li [ Ns Ar selector Ns Li ]}
Substitutes only the selected words from the value of
.Ar name .
The
.Ar selector
is subjected to
.Ql $
substitution and may consist of
a single number or two numbers separated by a
.Ql \- .
The first word of a variable's value is numbered
.Ql 1 .
If the first number of a range is omitted it defaults to
.Ql 1 .
If the last member of a range is omitted it defaults to
.Ql $# Ns Ar name .
The
.Ar selector
.Ql *
selects all words.
It is not an error for a range to be empty if the
second argument is omitted or in range.
.
.Pp
.It Li $0
Substitutes the name of the file from which command input
is being read.
An error occurs if the name is not known.
.
.Pp
.It Li $ Ns Ar number
.It Li ${ Ns Ar number Ns Li }
Equivalent to
.Ql $argv[ Ns Ar number Ns Li \] .
.
.Pp
.It Li $*
Equivalent to
.Ql $argv ,
which is equivalent to
.Ql $argv[*] .
.El
.Pp
Except as noted, it is an error to reference a variable which
is not set.
.Pp
The
.Ql \&:
modifiers described under
.Sx History substitution ,
except for
.Ql \&:p ,
can be applied to the substitutions above.
More than one may be used.
(+)
Braces may be needed to insulate a variable substitution from a literal colon
just as with
.Sx History substitution
(q.v.); any modifiers must appear
within the braces.
.Pp
The following substitutions can not be modified with
.Ql \&:
modifiers:
.Pp
.Bl -tag -width 10n -offset indent -compact
.
.It Li $? Ns Ar name
.It Li ${? Ns Ar name Ns Li }
Substitutes the string
.Ql 1
if
.Ar name
is set,
.Ql 0
if it is not.
.
.Pp
.It Li $?0
Substitutes
.Ql 1
if the current input filename is known,
.Ql 0
if it is not.
Always
.Ql 0
in interactive shells.
.
.Pp
.It Li $# Ns Ar name
.It Li ${# Ns Ar name Ns Li }
Substitutes the number of words in
.Ar name .
.
.Pp
.It Li $#
Equivalent to
.Ql $#argv .
(+)
.
.Pp
.It Li $% Ns Ar name
.It Li ${% Ns Ar name Ns Li }
Substitutes the number of characters in
.Ar name .
(+)
.
.Pp
.It Li $% Ns Ar number
.It Li ${% Ns Ar number Ns Li }
Substitutes the number of characters in
.Ql $argv[ Ns Ar number Ns Li \] .
(+)
.
.Pp
.It Li $?
Equivalent to
.Ql $status .
(+)
.
.Pp
.It Li $$
Substitutes the (decimal) process number of the (parent) shell.
.
.Pp
.It Li $!
Substitutes the (decimal) process number of the last
background process started by this shell.
(+)
.
.Pp
.It Li $_
Substitutes the command line of the last command executed.
(+)
.
.Pp
.It Li $<
Substitutes a line from the standard input, with no further interpretation
thereafter.
It can be used to read from the keyboard in a shell script.
(+) While
.Xr csh 1
always quotes
.Ql $< ,
as if it were equivalent to
.Ql $<:q ,
.Nm
does not.
Furthermore, when
.Nm
is waiting for a line to be
typed the user may type an interrupt to interrupt the sequence into
which the line is to be substituted, but
.Xr csh 1
does not allow this.
.El
.Pp
The editor command
.Ic expand-variables ,
normally bound to
.Sq ^X-$ ,
can be used to interactively expand individual variables.
.
.Ss "Command, filename and directory stack substitution"
The remaining substitutions are applied selectively to the arguments
of builtin commands.
This means that portions of expressions which are not evaluated are
not subjected to these expansions.
For commands which are not internal to the
shell, the command name is substituted separately from the argument list.
This occurs very late, after input-output redirection is performed, and
in a child of the main shell.
.
.Ss "Command substitution"
Command substitution is indicated by a command enclosed in
.Ql \&` .
The output
from such a command is broken into separate words at blanks, tabs and newlines,
and null words are discarded.
The output is variable and command substituted
and put in place of the original string.
.Pp
Command substitutions inside double
quotes
.Pq Ql \&"
retain blanks and tabs; only newlines force new words.
The single
final newline does not force a new word in any case.
It is thus possible for a
command substitution to yield only part of a word, even if the command outputs
a complete line.
.Pp
By default, the shell since version 6.12 replaces all newline and carriage
return characters in the command by spaces.
If this is switched off by
unsetting
.Ic csubstnonl ,
newlines separate commands as usual.
.
.Ss "Filename substitution"
If a word contains any of the characters
.Ql * ,
.Ql \&? ,
.Ql \&[ ,
or
.Ql {
or begins with
the character
.Ql ~
it is a candidate for filename substitution, also known as
.Dq globbing .
This word is then regarded as a pattern
.Dq ( glob-pattern ) ,
and
replaced with an alphabetically sorted list of file names which match the
pattern.
.Pp
In matching filenames, the character
.Ql \&.
at the beginning of a filename or
immediately following a
.Ql / ,
as well as the character
.Ql /
must be matched
explicitly (unless either
.Ic globdot
or
.Ic globstar
or both are set (+)).
The character
.Ql *
matches any string of characters,
including the null string.
The character
.Ql \&?
matches any single character.
The sequence
.Ql [...]
matches any one of the characters enclosed.
Within
.Ql [...] ,
a pair of
characters separated by
.Ql \-
matches any character lexically between the two.
.Pp
(+) Some glob-patterns can be negated:
The sequence
.Ql [^...]
matches any single character
.Em not
specified by the
characters and/or ranges of characters in the braces.
.Pp
An entire glob-pattern can also be negated with
.Ql ^ :
.Bd -literal -offset indent
> echo *
bang crash crunch ouch
> echo ^cr*
bang ouch
.Ed
.Pp
Glob-patterns which do not use
.Ql \&? ,
.Ql * ,
or
.Ql [] ,
or which use
.Ql {}
or
.Ql ~
(below) are not negated correctly.
.Pp
The metanotation
.Ql a{b,c,d}e
is a shorthand for
.Ql abe ace ade .
Left-to-right order is preserved:
.Ql /usr/source/s1/{oldls,ls}.c
expands
to
.Ql /usr/source/s1/oldls.c /usr/source/s1/ls.c .
The results of matches are
sorted separately at a low level to preserve this order:
.Ql ../{memo,*box}
might expand to
.Ql ../memo ../box ../mbox .
(Note that
.Ql memo
was not sorted with the results of matching
.Ql *box . )
It is not an error when this construct expands to files which do not exist,
but it is possible to get an error from a command to which the expanded list
is passed.
This construct may be nested.
As a special case the words
.Ql { ,
.Ql } ,
and
.Ql {}
are passed undisturbed.
.Pp
The character
.Ql ~
at the beginning of a filename refers to home directories.
Standing alone, i.e.,
.Ql ~ ,
it expands to the invoker's home directory as
reflected in the value of the
.Ic home
shell variable.
When followed by a
name consisting of letters, digits and
.Ql \-
characters the shell searches for a
user with that name and substitutes their home directory; thus
.Ql ~ken
might
expand to
.Ql /usr/ken
and
.Ql ~ken/chmach
to
.Ql /usr/ken/chmach .
If the character
.Ql ~
is followed by a character other than a letter or
.Ql /
or appears elsewhere
than at the beginning of a word, it is left undisturbed.
A command like
.Ql setenv MANPATH /usr/share/man:/usr/local/share/man:~/lib/man
does not,
therefore, do home directory substitution as one might hope.
.Pp
It is an error for a glob-pattern containing
.Ql * ,
.Ql \&? ,
.Ql \&[ ,
or
.Ql ~ ,
with or
without
.Ql ^ ,
not to match any files.
However, only one pattern in a list of
glob-patterns must match a file (so that, e.g.,
.Ql rm *.a *.c *.o
would fail
only if there were no files in the current directory ending in
.Ql .a ,
.Ql .c ,
or
.Ql .o ) ,
and if the
.Ic nonomatch
shell variable is set a pattern (or list
of patterns) which matches nothing is left unchanged rather than causing
an error.
.Pp
The
.Ic globstar
shell variable can be set to allow
.Ql **
or
.Ql ***
as
a file glob pattern that matches any string of characters including
.Ql / ,
recursively traversing any existing sub-directories.
For example,
.Ql ls **.c
will list all the .c files in the current directory tree.
If used by itself, it will match zero or more sub-directories
(e.g.
.Ql ls /usr/include/**/time.h
will list any file named
.Ql time.h
in the
.Pa /usr/include
directory tree;
.Ql ls /usr/include/**time.h
will match
any file in the
.Pa /usr/include
directory tree ending in
.Ql time.h ;
and
.Ql ls /usr/include/**time**.h
will match any .h file with
.Ql time
either
in a subdirectory name or in the filename itself).
To prevent problems with recursion, the
.Ql **
glob-pattern will not
descend into a symbolic link containing a directory.
To override this,
use
.Ql ***
(+)
.Pp
The
.Ic noglob
shell variable can be set to prevent filename substitution,
and the
.Ic expand-glob
editor command, normally bound to
.Sq ^X-* ,
can be
used to interactively expand individual filename substitutions.
.
.Ss "Directory stack substitution (+)"
The directory stack is a list of directories, numbered from zero, used by the
.Ic pushd ,
.Ic popd ,
and
.Ic dirs
builtin commands (q.v.).
.Ic dirs
can print, store in a file, restore and clear the directory stack
at any time, and the
.Ic savedirs
and
.Ic dirsfile
shell variables can be set to
store the directory stack automatically on logout and restore it on login.
The
.Ic dirstack
shell variable can be examined to see the directory stack and
set to put arbitrary directories into the directory stack.
.Pp
The character
.Ql =
followed by one or more digits expands to an entry in
the directory stack.
The special case
.Ql =-
expands to the last directory in
the stack.
For example,
.Bd -literal -offset indent
> dirs \-v
0       /usr/bin
1       /usr/spool/uucp
2       /usr/accts/sys
> echo =1
/usr/spool/uucp
> echo =0/calendar
/usr/bin/calendar
> echo =\-
/usr/accts/sys
.Ed
.Pp
The
.Ic noglob
and
.Ic nonomatch
shell variables and the
.Ic expand-glob
editor command apply to directory stack as well as filename substitutions.
.
.Ss "Other substitutions (+)"
There are several more transformations involving filenames, not strictly
related to the above but mentioned here for completeness.
.Em Any
filename may be expanded to a full path when the
.Ic symlinks
variable (q.v.) is set to
.Ql expand .
Quoting prevents this expansion, and
the
.Ic normalize-path
editor command does it on demand.
The
.Ic normalize-command
editor command expands commands in
.Ev PATH
into full paths on demand.
Finally,
.Ic cd
and
.Ic pushd
interpret
.Ql \-
as the old working directory
(equivalent to the shell variable
.Ic owd ) .
This is not a substitution at all, but an abbreviation recognized by only
those commands.
Nonetheless, it too can be prevented by quoting.
.
.Ss "Commands"
The next three sections describe how the shell executes commands and
deals with their input and output.
.
.Ss "Simple commands, pipelines and sequences"
A simple command is a sequence of words, the first of which specifies the
command to be executed.
A series of simple commands joined by
.Ql |
characters
forms a pipeline.
The output of each command in a pipeline is connected to the
input of the next.
.Pp
Simple commands and pipelines may be joined into sequences with
.Ql \&; ,
and will
be executed sequentially.
Commands and pipelines can also be joined into
sequences with
.Ql ||
or
.Ql && ,
indicating, as in the C language, that the second
is to be executed only if the first fails or succeeds respectively.
.Pp
A simple command, pipeline or sequence may be placed in parentheses,
.Ql () ,
to form a simple command, which may in turn be a component of a pipeline or
sequence.
A command, pipeline or sequence can be executed
without waiting for it to terminate by following it with an
.Ql \&& .
.
.Ss "Builtin and non-builtin command execution"
Builtin commands are executed within the shell.
If any component of a
pipeline except the last is a builtin command, the pipeline is executed
in a subshell.
.Pp
Parenthesized commands are always executed in a subshell.
.Bd -literal -offset indent
(cd; pwd); pwd
.Ed
.Pp
thus prints the
.Ic home
directory, leaving you where you were
(printing this after the home directory), while
.Bd -literal -offset indent
cd; pwd
.Ed
.Pp
leaves you in the
.Ic home
directory.
Parenthesized commands are most often
used to prevent
.Ic cd
from affecting the current shell.
.Pp
When a command to be executed is found not to be a builtin command the shell
attempts to execute the command via
.Xr execve 2 .
Each word in the variable
.Ic path
names a directory in which the shell will look for the
command.
If the shell is not given a
.Fl f
option, the shell
hashes the names in these directories into an internal table so that it will
try an
.Xr execve 2
in only a directory where there is a possibility that the
command resides there.
This greatly speeds command location when a large
number of directories are present in the search path. This hashing mechanism is
not used:
.Bl -enum -width 2n -offset indent
.It
If hashing is turned explicitly off via
.Ic unhash .
.It
If the shell was given a
.Fl f Ar argument .
.It
For each directory component of
.Ic path
which does not begin with a
.Ql / .
.It
If the command contains a
.Ql / .
.El
.Pp
In the above four cases the shell concatenates each component of the path
vector with the given command name to form a path name of a file which it
then attempts to execute it. If execution is successful, the search stops.
.Pp
If the file has execute permissions but is not an executable to the system
(i.e., it is neither an executable binary nor a script that specifies its
interpreter), then it is assumed to be a file containing shell commands and
a new shell is spawned to read it.
The
.Ic shell
special alias may be set
to specify an interpreter other than the shell itself.
.Pp
On systems which do not understand the
.Ql #!
script interpreter convention
the shell may be compiled to emulate it; see the
.Ic version
shell
variable.
If so, the shell checks the first line of the file to
see if it is of the form
.Ql #! Ns Ar interpreter arg Li \&... .
If it is,
the shell starts
.Ar interpreter
with the given
.Ar arg Ns
s and feeds the
file to it on standard input.
.
.Ss "Input/output"
The standard input and standard output of a command may be redirected with the
following syntax:
.Pp
.Bl -tag -width 8n -offset indent -compact
.
.It Li < Ar name
Open file
.Ar name
(which is first variable, command and filename
expanded) as the standard input.
.
.Pp
.It Li << Ar word
Read the shell input up to a line which is identical to
.Ar word .
.Ar word
is not subjected to variable, filename or command substitution, and each input
line is compared to
.Ar word
before any substitutions are done on this input
line.
Unless a quoting
.Ql \e ,
.Ql \&" ,
.Ql \&' ,
or
.Ql \&`
appears in
.Ar word
variable and
command substitution is performed on the intervening lines, allowing
.Ql \e
to
quote
.Ql $ ,
.Ql \e ,
and
.Ql \&` .
Commands which are substituted have all blanks, tabs,
and newlines preserved, except for the final newline which is dropped.
The
resultant text is placed in an anonymous temporary file which is given to the
command as standard input.
.Pp
.It Li > Ar name
.It Li >! Ar name
.It Li >& Ar name
.It Li >&! Ar name
The file
.Ar name
is used as standard output.
If the file does not exist
then it is created; if the file exists, it is truncated, its previous contents
being lost.
.Pp
If the shell variable
.Ic noclobber
is set, then the file must not exist or be a
character special file (e.g., a terminal or
.Pa /dev/null )
or an error results.
This helps prevent accidental destruction of files.
In this case the
.Ql \&!
forms
can be used to suppress this check.
If
.Ql notempty
is given in
.Ic noclobber ,
.Ql >
is allowed on empty files;
if
.Ql ask
is given in
.Ic noclobber ,
an interacive confirmation is presented, rather than an
error.
.Pp
The forms involving
.Ql \&&
route the diagnostic output into the specified file as
well as the standard output.
.Ar name
is expanded in the same way as
.Ql <
input filenames are.
.Pp
.It Li >> Ar name
.It Li >>& Ar name
.It Li >>! Ar name
.It Li >>&! Ar name
Like
.Ql > ,
but appends output to the end of
.Ar name .
If the shell variable
.Ic noclobber
is set, then it is an error for
the file
.Em not
to exist, unless one of the
.Ql \&!
forms is given.
.El
.Pp
A command receives the environment in which the shell was invoked as modified
by the input-output parameters and the presence of the command in a pipeline.
Thus, unlike some previous shells, commands run from a file of shell commands
have no access to the text of the commands by default; rather they receive the
original standard input of the shell.
The
.Ql <<
mechanism should be used to
present inline data.
This permits shell command scripts to function as
components of pipelines and allows the shell to block read its input.
Note
that the default standard input for a command run detached is
.Em not
the empty file
.Pa /dev/null ,
but the original standard input of the shell.
If this is a terminal and if the process attempts to read from the terminal,
then the process will block and the user will be notified (see
.Sx Jobs ) .
.Pp
Diagnostic output may be directed through a pipe with the standard output.
Simply use the form
.Ql |&
rather than just
.Ql | .
.Pp
The shell cannot presently redirect diagnostic output without also redirecting
standard output, but
.Ql \&( Ar command Li > Ar output-file Li ) >& Ar error-file
is often an acceptable workaround.
Either
.Ar output-file
or
.Ar error-file
may be
.Pa /dev/tty
to send output to the terminal.
.
.Ss "Features"
Having described how the shell accepts, parses and executes
command lines, we now turn to a variety of its useful features.
.
.Ss "Control flow"
The shell contains a number of commands which can be used to regulate the
flow of control in command files (shell scripts) and (in limited but
useful ways) from terminal input.
These commands all operate by forcing the
shell to reread or skip in its input and, due to the implementation,
restrict the placement of some of the commands.
.Pp
The
.Ic foreach ,
.Ic switch ,
and
.Ic while
statements, as well as the
.Ic if \&... then \&... else
form of the
.Ic if
statement, require that the major
keywords appear in a single simple command on an input line as shown below.
.Pp
If the shell's input is not seekable, the shell buffers up input whenever
a loop is being read and performs seeks in this internal buffer to
accomplish the rereading implied by the loop.
(To the extent that this allows, backward
.Ic goto Ns
s will succeed on non-seekable inputs.)
.
.Ss "Expressions"
The
.Ic if ,
.Ic while ,
and
.Ic exit
builtin commands
use expressions with a common syntax.
The expressions can include any
of the operators described in the next three sections.
Note that the
.Ic @
builtin command (q.v.) has its own separate syntax.
.
.Ss "Logical, arithmetical and comparison operators"
These operators are similar to those of C and have the same precedence.
.Pp
The operators, in descending precedence, with equivalent precedence per line, are:
.Pp
.Bl -column -offset indent -compact "XX" "XX" "XX" "XX"
.It Li \&( Ta Li \&)
.It Li \&~
.It Li \&!
.It Li * Ta Li / Ta Li %
.It Li + Ta Li \-
.It Li << Ta Li >>
.It Li <= Ta Li >= Ta Li < Ta Li >
.It Li == Ta Li \&!= Ta Li =~ Ta Li \&!~
.It Li &
.It Li ^
.It Li |
.It Li &&
.It Li ||
.El
.Pp
The
.Ql ==
.Ql \&!=
.Ql =~
and
.Ql \&!~
operators compare
their arguments as strings; all others operate on numbers.
The operators
.Ql =~
and
.Ql \&!~
are like
.Ql ==
and
.Ql \&!=
except that the right hand side is a
glob-pattern (see
.Sx Filename substitution )
against which the left hand operand is matched.
This reduces the need for use of the
.Ic switch
builtin command in shell scripts when all that is really needed is
pattern matching.
.Pp
Null or
missing arguments are considered
.Ql 0 .
The results of all expressions are
strings, which represent decimal numbers.
It is important to note that
no two components of an expression can appear in the same word; except
when adjacent to components of expressions which are syntactically
significant to the parser
.Po
.Ql \&& ,
.Ql | ,
.Ql < ,
.Ql > ,
.Ql \&( ,
.Ql \&)
.Pc
they should be
surrounded by spaces.
.
.Ss "Command exit status"
Commands can be executed in expressions and their exit status
returned by enclosing them in braces
.Pq Ql {} .
Remember that the braces should
be separated from the words of the command by spaces.
Command executions
succeed, returning true, i.e.,
.Ql 1 ,
if the command exits with status 0,
otherwise they fail, returning false, i.e.,
.Ql 0 .
If more detailed status
information is required then the command should be executed outside of an
expression and the
.Ic status
shell variable examined.
.
.Ss "File inquiry operators"
Some of these operators perform true/false tests on files and related
objects.
They are of the form
.Fl Ar op file ,
where
.Ar op
is one of:
.Pp
.Bl -tag -width 3n -offset indent -compact
.
.It Li r
Read access.
.
.It Li w
Write access.
.
.It Li x
Execute access.
.
.It Li X
Executable in the path or shell builtin, e.g.,
.Ql \-X ls
and
.Ql \-X ls\-F
are
generally true, but
.Ql \-X /bin/ls
is not. (+)
.
.It Li e
Existence.
.
.It Li o
Ownership.
.
.It Li z
Zero size.
.
.It Li s
Non-zero size. (+)
.
.It Li f
Plain file.
.
.It Li d
Directory.
.
.It Li l
Symbolic link. (+) *
.
.It Li b
Block special file. (+)
.
.It Li c
Character special file. (+)
.
.It Li p
Named pipe (fifo). (+) *
.
.It Li S
Socket special file. (+) *
.
.It Li u
Set-user-ID bit is set. (+)
.
.It Li g
Set-group-ID bit is set. (+)
.
.It Li k
Sticky bit is set. (+)
.
.It Li t
.Ar file
(which must be a digit) is an open file descriptor
for a terminal device. (+)
.
.It Li R
Has been migrated (Convex only). (+)
.
.It Li L
Applies subsequent operators in a multiple-operator test to a symbolic link
rather than to the file to which the link points. (+) *
.El
.Pp
.Ar file
is command and filename expanded and then tested to
see if it has the specified relationship to the real user.
If
.Ar file
does not exist or is inaccessible or, for the operators indicated by
.Sq * ,
if the specified file type does not exist on the current system,
then all inquiries return false, i.e.,
.Ql 0 .
.Pp
These operators may be combined for conciseness:
.Ql \- Ns Ar xy file
is
equivalent to
.Ql \- Ns Ar x file Li && \- Ns Ar y file .
(+) For example,
.Ql \-fx
is true
(returns
.Ql 1 )
for plain executable files, but not for directories.
.Pp
.Ql L
may be used in a multiple-operator test to apply subsequent operators
to a symbolic link rather than to the file to which the link points.
For example,
.Ql \-lLo
is true for links owned by the invoking user.
.Ql Lr ,
.Ql Lw ,
and
.Ql Lx
are always true for links and false for
non-links.
.Ql L
has a different meaning when it is the last operator
in a multiple-operator test; see below.
.Pp
It is possible but not useful, and sometimes misleading, to combine operators
which expect
.Ar file
to be a file with operators which do not
(e.g.,
.Ql X
and
.Ql t ) .
Following
.Ql L
with a non-file operator
can lead to particularly strange results.
.Pp
Other operators return other information, i.e., not just
.Ql 0
or
.Ql 1 .
(+)
They have the same format as before;
.Ar op
may be one of:
.Pp
.Bl -tag -width 6n -offset indent -compact
.
.It Li A
Last file access time, as the number of seconds since the epoch.
.
.It Li A:
Like
.Ql A ,
but in timestamp format, e.g.,
.Sq Fri May 14 16:36:10 1993 .
.
.It Li M
Last file modification time.
.
.It Li M:
Like
.Ql M ,
but in timestamp format.
.
.It Li C
Last inode modification time.
.
.It Li C:
Like
.Ql C ,
but in timestamp format.
.
.It Li D
Device number.
.
.It Li I
Inode number.
.
.It Li F
Composite
.Li f Ns
ile identifier, in the form
.Ar device : Ns
.Ar inode .
.
.It Li L
The name of the file pointed to by a symbolic link.
.
.It Li N
Number of (hard) links.
.
.It Li P
Permissions, in octal, without leading zero.
.
.It Li P:
Like
.Ql P ,
with leading zero.
.
.It Li P Ns Ar mode
Equivalent to
.Ql \-P Ar file Li & Ar mode ,
e.g.,
.Ql \-P22 Ar file
returns
.Sq 22
if
.Ar file
is writable by group and other,
.Sq 20
if by group only,
and
.Sq 0
if by neither.
.
.It Li P Ns Ar mode Ns Li \&:
Like
.Ql P Ns Ar mode ,
with leading zero.
.
.It Li U
Numeric userid.
.
.It Li U:
Username, or the numeric userid if the username is unknown.
.
.It Li G
Numeric groupid.
.
.It Li G:
Groupname, or the numeric groupid if the groupname is unknown.
.
.It Li Z
Size, in bytes.
.El
.Pp
Only one of these operators may appear in a multiple-operator test, and it
must be the last.
Note that
.Ql L
has a different meaning at the end of and
elsewhere in a multiple-operator test.
Because
.Sq 0
is a valid return value
for many of these operators, they do not return
.Sq 0
when they fail: most
return
.Sq \-1 ,
and
.Ql F
returns
.Ql \&: .
.Pp
If the shell is compiled with POSIX defined (see the
.Ic version
shell
variable), the result of a file inquiry is based on the permission bits of
the file and not on the result of the
.Xr access 2
system call.
For example, if one tests a file with
.Fl w
whose permissions would
ordinarily allow writing but which is on a file system mounted read-only,
the test will succeed in a POSIX shell but fail in a non-POSIX shell.
.Pp
File inquiry operators can also be evaluated with the
.Ic filetest
builtin
command (q.v.) (+).
.
.Ss Jobs
The shell associates a
.Ar job
with each pipeline.
It keeps a table of
current jobs, printed by the
.Ic jobs
command, and assigns them small integer
numbers.
When a job is started asynchronously with
.Ql & ,
the shell prints a
line which looks like
.Bd -literal -offset indent
[1] 1234
.Ed
.Pp
indicating that the job which was started asynchronously was job number 1 and
had one (top-level) process, whose process id was 1234.
.Pp
If you are running a job and wish to do something else you may hit the suspend
key (usually
.Sq ^Z ) ,
which sends a STOP signal to the current job.
The shell will then normally
indicate that the job has been
.Sq Suspended
and print another prompt.
If the
.Ic listjobs
shell variable is set, all jobs will be listed
like the
.Ic jobs
builtin command; if it is set to
.Ql long
the listing will
be in long format, like
.Ql jobs \-l .
You can then manipulate the state of the suspended job.
You can put it in the
.Dq background
with the
.Ic bg
command or run some other commands and
eventually bring the job back into the
.Dq foreground
with
.Ic fg .
(See also the
.Ic run-fg-editor
editor command.)
A
.Sq ^Z
takes effect immediately and is like an interrupt
in that pending output and unread input are discarded when it is typed.
The
.Ic wait
builtin command causes the shell to wait for all background
jobs to complete.
.Pp
The
.Sq ^]
key sends a delayed suspend signal, which does not generate a STOP
signal until a program attempts to
.Xr read 2
it, to the current job.
This can usefully be typed ahead when you have prepared some commands for a
job which you wish to stop after it has read them.
The
.Sq ^Y
key performs this function in
.Xr csh 1 ;
in
.Nm ,
.Sq ^Y
is an editing command.
(+)
.Pp
A job being run in the background stops if it tries to read from the
terminal.
Background jobs are normally allowed to produce output, but this can
be disabled by giving the command
.Ql stty tostop .
If you set this tty option,
then background jobs will stop when they try to produce output like they do
when they try to read input.
.Pp
There are several ways to refer to jobs in the shell.
The character
.Ql %
introduces a job name.
If you wish to refer to job number 1, you can name it
as
.Ql %1 .
Just naming a job brings it to the foreground; thus
.Ql %1
is a synonym
for
.Ql fg %1 ,
bringing job 1 back into the foreground.
Similarly, typing
.Ql %1 &
resumes job 1 in the background, just like
.Ql bg %1 .
A job can also be named
by an unambiguous prefix of the string typed in to start it:
.Ql %ex
would
normally restart a suspended
.Xr ex 1
job, if there were only one suspended
job whose name began with the string
.Ql ex .
It is also possible to type
.Ql %? Ns Ar string
to specify a job whose text contains
.Ar string ,
if there is only one such job.
.Pp
The shell maintains a notion of the current and previous jobs.
In output
pertaining to jobs, the current job is marked with a
.Ql +
and the previous job
with a
.Ql \- .
The abbreviations
.Ql %+ ,
.Ql % ,
and (by analogy with the syntax of
the
.Ic history
mechanism)
.Ql %%
all refer to the current job, and
.Ql %\-
refers
to the previous job.
.Pp
The job control mechanism requires that the
.Xr stty 1
option
.Ql new
be set
on some systems.
It is an artifact from a
.Dq new
implementation of the tty
driver which allows generation of interrupt characters from the keyboard to
tell jobs to stop.
See
.Xr stty 1
and the
.Ic setty
builtin command for
details on setting options in the new tty driver.
.
.Ss "Status reporting"
The shell learns immediately whenever a process changes state.
It normally
informs you whenever a job becomes blocked so that no further progress is
possible, but only right before it prints a prompt.
This is done so that it
does not otherwise disturb your work.
If, however, you set the shell variable
.Ic notify ,
the shell will notify you immediately of changes of status in
background jobs.
There is also a builtin command
.Ic notify
which marks a
single process so that its status changes will be immediately reported.
By
default
.Ic notify
marks the current process; simply enter
.Ql notify
after
starting a background job to mark it.
.Pp
When you try to leave the shell while jobs are stopped, you will be
warned that
.Sq There are suspended jobs.
You may use the
.Ic jobs
command to
see what they are.
If you do this or immediately try to exit again, the shell
will not warn you a second time, and the suspended jobs will be terminated.
.
.Ss "Automatic, periodic and timed events (+)"
There are various ways to run commands and take other actions automatically
at various times in the
.Dq life cycle
of the shell.
They are summarized here,
and described in detail under the appropriate
.Sx Builtin commands ,
.Sx Special shell variables ,
and
.Sx Special aliases .
.Pp
The
.Ic sched
builtin command puts commands in a scheduled-event list,
to be executed by the shell at a given time.
.Pp
The
.Ic beepcmd ,
.Ic cwdcmd ,
.Ic jobcmd ,
.Ic periodic ,
.Ic precmd ,
and
.Ic postcmd
.Sx Special aliases
can be set, respectively, to execute commands:
when the shell wants to ring the bell,
when the working directory changes,
when a job is started or is brought into the foreground,
every
.Ic tperiod
minutes,
before each prompt,
and before each command gets executed.
.Pp
The
.Ic autologout
shell variable can be set to log out or lock the shell
after a given number of minutes of inactivity.
.Pp
The
.Ic mail
shell variable can be set to check for new mail periodically.
.Pp
The
.Ic printexitvalue
shell variable can be set to print the exit status
of commands which exit with a status other than zero.
.Pp
The
.Ic rmstar
shell variable can be set to ask the user, when
.Ql rm *
is
typed, if that is really what was meant.
.Pp
The
.Ic time
shell variable can be set to execute the
.Ic time
builtin
command after the completion of any process that takes more than a given
number of CPU seconds.
.Pp
The
.Ic watch
and
.Ic who
shell variables can be set to report when
selected users log in or out, and the
.Ic log
builtin command reports
on those users at any time.
.
.Ss "Native Language System support (+)"
The shell is eight bit clean
(if so compiled; see the
.Ic version
shell variable)
and thus supports character sets needing this capability.
NLS support differs depending on whether or not
the shell was compiled to use the system's NLS (again, see
.Ic version ) .
In either case, 7-bit ASCII is the default character code
(e.g., the classification of which characters are printable) and sorting,
and changing the
.Ev LANG
or
.Ev LC_CTYPE
environment variables
causes a check for possible changes in these respects.
.Pp
When using the system's NLS, the
.Xr setlocale 3
function is called
to determine appropriate character code/classification and sorting
(e.g.,
.Sq en_CA.UTF-8
would yield
.Sq UTF-8
as the character code).
This function typically examines the
.Ev LANG
and
.Ev LC_CTYPE
environment variables; refer to the system documentation for further details.
When not using the system's NLS, the shell simulates it by assuming that the
ISO 8859-1 character set is used
whenever either of the
.Ev LANG
and
.Ev LC_CTYPE
variables are set, regardless of
their values.
Sorting is not affected for the simulated NLS.
.Pp
In addition, with both real and simulated NLS, all printable
characters in the range \e200\-\e377, i.e., those that have
.No M- Ns Ar char
bindings, are automatically rebound to
.Ic self-insert-command .
The corresponding binding for the
.No escape- Ns Ar char
sequence, if any, is
left alone.
These characters are not rebound if the
.Ev NOREBIND
environment variable
is set.
This may be useful for the simulated NLS or a primitive real NLS
which assumes full ISO 8859-1.
Otherwise, all
.No M- Ns Ar char
bindings in the
range \e240\-\e377 are effectively undone.
Explicitly rebinding the relevant keys with
.Ic bindkey
is of course still possible.
.Pp
Unknown characters (i.e., those that are neither printable nor control
characters) are printed in the format \ennn.
If the tty is not in 8 bit mode, other 8 bit characters are printed by
converting them to ASCII and using standout mode.
The shell
never changes the 7/8 bit mode of the tty and tracks user-initiated
changes of 7/8 bit mode.
NLS users (or, for that matter, those who want to
use a meta key) may need to explicitly set
the tty in 8 bit mode through the appropriate
.Xr stty 1
command in, e.g., the
.Pa ~/.login
file.
.
.Ss "OS variant support (+)"
A number of new builtin commands are provided to support features in
particular operating systems.
All are described in detail in the
.Sx Builtin commands
section.
.Pp
On systems that support TCF (aix-ibm370, aix-ps2),
.Ic getspath
and
.Ic setspath
get and set the system execution path,
.Ic getxvers
and
.Ic setxvers
get and set the experimental version prefix
and
.Ic migrate
migrates processes between sites.
The
.Ic jobs
builtin
prints the site on which each job is executing.
.Pp
Under BS2000,
.Ic bs2cmd
executes commands of the underlying BS2000/OSD
operating system.
.Pp
Under Domain/OS,
.Ic inlib
adds shared libraries to the current environment,
.Ic rootnode
changes the rootnode and
.Ic ver
changes the systype.
.Pp
Under Mach,
.Ic setpath
is equivalent to Mach's
.Xr setpath 1 .
.Pp
Under Masscomp/RTU and Harris CX/UX,
.Ic universe
sets the universe.
.Pp
Under Harris CX/UX,
.Ic ucb
or
.Ic att
runs a command under the specified
universe.
.Pp
Under Convex/OS,
.Ic warp
prints or sets the universe.
.Pp
The
.Ev VENDOR ,
.Ev OSTYPE ,
and
.Ev MACHTYPE
environment variables
indicate respectively the vendor, operating system and machine type
(microprocessor class or machine model) of the
system on which the shell thinks it is running.
These are particularly useful when sharing one's home directory between several
types of machines; one can, for example,
.Bd -literal -offset indent
set path = (~/bin.$MACHTYPE /usr/ucb /bin /usr/bin .)
.Ed
.Pp
in one's
.Pa ~/.login
and put executables compiled for each machine in the
appropriate directory.
.Pp
The
.Ic version
shell
variable indicates what options were chosen when the shell was compiled.
.Pp
Note also the
.Ic newgrp
builtin, the
.Ic afsuser
and
.Ic echo_style
shell variables and the system-dependent locations of
the shell's input files (see
.Sx FILES ) .
.
.Ss "Signal handling"
Login shells ignore interrupts when reading the file
.Pa ~/.logout .
The shell ignores quit signals unless started with
.Fl q .
Login shells catch the terminate signal, but non-login shells inherit the
terminate behavior from their parents.
Other signals have the values which the shell inherited from its parent.
.Pp
In shell scripts, the shell's handling of interrupt and terminate signals
can be controlled with
.Ic onintr ,
and its handling of hangups can be
controlled with
.Ic hup
and
.Ic nohup .
.Pp
The shell exits on a hangup (see also the
.Ic logout
shell variable).
By
default, the shell's children do too, but the shell does not send them a
hangup when it exits.
.Ic hup
arranges for the shell to send a hangup to
a child when it exits, and
.Ic nohup
sets a child to ignore hangups.
.
.Ss "Terminal management (+)"
The shell uses three different sets of terminal
.Dq ( tty )
modes:
.Sq edit ,
used when editing;
.Sq quote ,
used when quoting literal characters;
and
.Sq execute ,
used when executing commands.
The shell holds some settings in each mode constant, so commands which leave
the tty in a confused state do not interfere with the shell.
The shell also matches changes in the speed and padding of the tty.
The list of tty modes that are kept constant
can be examined and modified with the
.Ic setty
builtin.
Note that although the editor uses CBREAK mode (or its equivalent),
it takes typed-ahead characters anyway.
.Pp
The
.Ic echotc ,
.Ic settc ,
and
.Ic telltc
commands can be used to
manipulate and debug terminal capabilities from the command line.
.Pp
On systems that support SIGWINCH or SIGWINDOW, the shell
adapts to window resizing automatically and adjusts the environment
variables
.Ev LINES
and
.Ev COLUMNS
if set.
If the environment
variable
.Ev TERMCAP
contains
.Ql li#
and
.Ql co#
fields, the shell adjusts
them to reflect the new window size.
.
.Sh REFERENCE
The next sections of this manual describe all of the available
.Sx Builtin commands ,
.Sx Special aliases ,
and
.Sx Special shell variables .
.
.Ss "Builtin commands"
.
.Bl -tag -width 8n
.
.It Ic % Ns Ar job
A synonym for the
.Ic fg
builtin command.
.
.It Ic % Ns Ar job Cm \&&
A synonym for the
.Ic bg
builtin command.
.
.It Ic \&:
Does nothing, successfully.
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic @
.It Ic @ Ar name Cm = Ar expr
.It Ic @ Ar name Ns Cm \&[ Ns Ar index Ns Cm \&] = Ar expr
.It Ic @ Ar name Ns Cm ++|--
.It Ic @ Ar name Ns Cm \&[ Ns Ar index Ns Cm \&]++|--
The first form prints the values of all shell variables.
.Pp
The second form assigns the value of
.Ar expr
to
.Ar name .
.Pp
The third form assigns the value of
.Ar expr
to the
.Ar index Ns
\&'th
component of
.Ar name ;
both
.Ar name
and its
.Ar index Ns
\&'th component
must already exist.
.Pp
.Ar expr
may contain the operators
.Ql * ,
.Ql + ,
etc., as in C.
If
.Ar expr
contains
.Ql < ,
.Ql > ,
.Ql & ,
or
.Ql \&|
then at least that part of
.Ar expr
must be placed within
.Ql () .
Note that the syntax of
.Ar expr
has nothing to do with that described
under
.Sx Expressions .
.Pp
The fourth and fifth forms increment
.Pq Sq Cm ++
or decrement
.Pq Sq Cm --
.Ar name
or its
.Ar index Ns
\&'th component.
.Pp
The space between
.Sq Ic @
and
.Ar name
is required.
The spaces between
.Ar name
and
.Sq Cm =
and between
.Sq Cm =
and
.Ar expr
are optional.
Components of
.Ar expr
must be separated by spaces.
.
.El
.Bl -tag -width 8n
.
.It Ic alias Op Ar name Op Ar wordlist
Without arguments, prints all aliases.
With
.Ar name ,
prints the alias for name.
With
.Ar name
and
.Ar wordlist ,
assigns
.Ar wordlist
as the alias of
.Ar name .
.Ar wordlist
is command and filename substituted.
.Ar name
may not be
.Sq Ic alias
or
.Sq Ic unalias .
See also the
.Ic unalias
builtin command.
.
.It Ic alloc
Shows the amount of dynamic memory acquired, broken down into used and free
memory.
With an argument shows the number of free and used blocks in each size
category.
The categories start at size 8 and double at each step.
This command's output may vary across system types, because systems other
than the VAX may use a different memory allocator.
.
.It Ic bg Op Cm % Ns Ar job No \&...
Puts the specified jobs (or, without arguments, the current job)
into the background, continuing each if it is stopped.
.Ar job
may be a number, a string,
.Ql \& ,
.Ql % ,
.Ql + ,
or
.Ql \-
as described under
.Sx Jobs .
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic bindkey Oo Fl l Ns | Ns Fl d Ns | Ns Fl e Ns | Ns Fl v Ns | Ns Fl u Oc No (+)
.It Ic bindkey Oo Fl a Oc Oo Fl b Oc Oo Fl k Oc Oo Fl r Oc Oo Fl \- Oc Ar key No (+)
.It Ic bindkey Oo Fl a Oc Oo Fl b Oc Oo Fl k Oc Oo Fl c Ns | Ns Fl s Oc Oo Fl \- Oc Ar key command No (+)
The first form either lists all bound keys and the editor
command to which each is bound,
lists a description of the commands,
or binds all keys to a specific mode.
.Pp
The second form lists the editor command to which
.Ar key
is bound.
.Pp
The third form binds the editor command
.Ar command
to
.Ar key .
.Pp
Supported
.Ic bindkey
options:
.Pp
.Bl -tag -width 5n -offset indent -compact
.
.It Fl a
Lists or changes key-bindings in the alternative key map.
This is the key map used in
.Ic vimode
command mode.
.
.It Fl b
.Ar key
is interpreted as
a control character written
.No ^ Ns Ar character
(e.g.,
.Sq ^A )
or
.No C- Ns Ar character
(e.g.,
.Sq C-A ) ,
a meta character written
.No M- Ns Ar character
(e.g.,
.Sq M-A ) ,
a function key written
.No F- Ns Ar string
(e.g.,
.Sq F-string ) ,
or an extended prefix key written
.No X- Ns Ar character
(e.g.,
.Sq X-A ) .
.
.It Fl c
.Ar command
is interpreted as a builtin or external command instead of an
editor command.
.
.It Fl d
Binds all keys to the standard bindings for the default editor,
as per
.Fl e
and
.Fl v .
.
.It Fl e
Binds all keys to
.Xr emacs 1 Ns
\-style bindings.
Unsets
.Ic vimode .
.
.It Fl k
.Ar key
is interpreted as a symbolic arrow key name, which may be one of
.Sq down ,
.Sq up ,
.Sq left ,
or
.Sq right .
.
.It Fl l
Lists all editor commands and a short description of each.
.
.It Fl r
Removes
.Ar key Ns
\&'s binding.
Be careful:
.Ql bindkey \-r
does
.Em not
bind
.Ar key
to
.Ic self-insert-command
(q.v.), it unbinds
.Ar key
completely.
.
.It Fl s
.Ar command
is taken as a literal string and treated as terminal input when
.Ar key
is typed.
Bound keys in
.Ar command
are themselves
reinterpreted, and this continues for ten levels of interpretation.
.
.It Fl u No (or any invalid option)
Prints a usage message.
.
.It Fl v
Binds all keys to
.Xr vi 1 Ns
\-style bindings.
Sets
.Ic vimode .
.
.It Fl \-
Forces a break from option processing, so the next word is taken as
.Ar key
even if it begins with
.Ql \- .
.
.El
.Pp
.Ar key
may be a single character or a string.
If a command is bound to a string, the first character of the string is bound to
.Ic sequence-lead-in
and the entire string is bound to the command.
.Pp
Control characters in
.Ar key
can be literal (they can be typed by preceding
them with the editor command
.Ic quoted-insert ,
normally bound to
.Sq ^V )
or
written caret-character style, e.g.,
.Sq ^A .
Delete is written
.Sq ^?
(caret-question mark).
.Ar key
and
.Ar command
can contain backslashed
escape sequences (in the style of System V
.Xr echo 1 )
as follows:
.Pp
.Bl -tag -width 5n -offset indent -compact
.
.It Li \ea
Bell.
.It Li \eb
Backspace.
.It Li \ee
Escape.
.It Li \ef
Form feed.
.It Li \en
Newline.
.It Li \er
Carriage return.
.It Li \et
Horizontal tab.
.It Li \ev
Vertical tab.
.It Li \e Ns Ar nnn
The ASCII character corresponding to the octal number
.Ar nnn .
.El
.Pp
.Ql \e
nullifies the special meaning of the following character, if it has
any, notably
.Ql \e
and
.Ql ^ .
.
.El
.Bl -tag -width 8n
.
.It Ic bs2cmd Ar bs2000-command No (+)
Passes
.Ar bs2000-command
to the BS2000 command interpreter for
execution. Only non-interactive commands can be executed, and it is
not possible to execute any command that would overlay the image
of the current process, like /EXECUTE or /CALL-PROCEDURE. (BS2000 only)
.
.It Ic break
Causes execution to resume after the
.Ic end
of the nearest
enclosing
.Ic foreach
or
.Ic while .
The remaining commands on the
current line are executed.
Multi-level breaks are thus
possible by writing them all on one line.
.
.It Ic breaksw
Causes a break from a
.Ic switch ,
resuming after the
.Ic endsw .
.
.It Ic builtins No (+)
Prints the names of all builtin commands.
.
.It Ic bye No (+)
A synonym for the
.Ic logout
builtin command.
Available only if the shell was so compiled;
see the
.Ic version
shell variable.
.
.It Ic case Ar label Ns Cm :
A label in a
.Ic switch
statement as discussed below.
.
.It Ic cd Xo
.Op Fl p
.Op Fl l
.Op Fl n Ns | Ns Fl v
.Op Fl \-
.Op Ar name
.Xc
If a directory
.Ar name
is given, changes the shell's working directory
to
.Ar name .
If not, changes to
.Ic home ,
unless the
.Ic cdtohome
variable is not set, in which case a
.Ar name
is required.
If
.Ar name
is
.Ql \-
it is interpreted as the previous working directory
(see
.Sx Other substitutions ) .
(+)
If
.Ar name
is not a subdirectory of the current directory
(and does not begin with
.Ql / ,
.Ql ./
or
.Ql ../ ) ,
each component of the variable
.Ic cdpath
is checked to see if it has a subdirectory
.Ar name .
Finally, if
all else fails but
.Ar name
is a shell variable whose value
begins with
.Ql /
or
.Ql \&. ,
then this is tried to see if it is a directory, and the
.Fl p
option is implied.
.Pp
With
.Fl p ,
prints the final directory stack, just like
.Ic dirs .
The
.Fl l ,
.Fl n ,
and
.Fl v
flags have the same effect on
.Ic cd
as on
.Ic dirs ,
and they imply
.Fl p .
(+)
Using
.Fl \-
forces a break from option processing so the next word
is taken as the directory
.Ar name
even if it begins with
.Ql \- .
(+)
.Pp
See also the
.Ic implicitcd
and
.Ic cdtohome
shell variables.
.
.It Ic chdir
A synonym for the
.Ic cd
builtin command.
.
.It Ic complete Xo
.Oo Ar command
.Oo
.Sm off
.Ar word Cm / Ar pattern Cm / Ar list Oo Cm : Ar select Oc Cm / Oo
.Op Ar suffix
.Cm /
.Oc
.Sm on
\&...
.Oc
.Oc
(+)
.Xc
Without arguments, lists all completions.
With
.Ar command ,
lists completions for
.Ar command .
With
.Ar command
and
.Ar word
etc., defines completions.
.Pp
.Ar command
may be a full command name or a glob-pattern
(see
.Sx Filename substitution ) .
It can begin with
.Ql \-
to indicate that
completion should be used only when
.Ic command
is ambiguous.
.Pp
.Ar word
specifies which word relative to the current word
is to be completed, and may be one of the following:
.Pp
.Bl -tag -width 5n -offset indent -compact
.
.It Li c
Current-word completion.
.Ar pattern
is a glob-pattern which must match the beginning of the current word on
the command line.
.Ar pattern
is ignored when completing the current word.
.
.It Li C
Like
.Ql c ,
but includes
.Ar pattern
when completing the current word.
.
.It Li n
Next-word completion.
.Ar pattern
is a glob-pattern which must match the beginning of the previous word on
the command line.
.
.It Li N
Like
.Ql n ,
but must match the beginning of the word two before the current word.
.
.It Li p
Position-dependent completion.
.Ar pattern
is a numeric range, with the same syntax used to index shell
variables, which must include the current word.
.El
.Pp
.Ar list ,
the list of possible completions, may be one of the following:
.Pp
.Bl -tag -width 5n -offset indent -compact
.
.It Li a
Aliases.
.
.It Li b
Bindings (editor commands).
.
.It Li c
Commands (builtin or external commands).
.
.It Li C
External commands which begin with the supplied path prefix.
.
.It Li d
Directories.
.
.It Li D
Directories which begin with the supplied path prefix.
.
.It Li e
Environment variables.
.
.It Li f
Filenames.
.
.It Li F
Filenames which begin with the supplied path prefix.
.
.It Li g
Groupnames.
.
.It Li j
Jobs.
.
.It Li l
Limits.
.
.It Li n
Nothing.
.
.It Li s
Shell variables.
.
.It Li S
Signals.
.
.It Li t
Plain
.Dq ( text )
files.
.
.It Li T
Plain
.Dq ( text )
files which begin with the supplied path prefix.
.
.It Li v
Any variables.
.
.It Li u
Usernames.
.
.It Li x
Like
.Ql n ,
but prints
.Ar select
when
.Ic list-choices
is used.
.
.It Li X
Completions.
.
.It Li $ Ns Ar var
Words from the variable
.Ar var .
.
.It Li (...)
Words from the given list.
.
.It Li \`...\`
Words from the output of command.
.El
.Pp
.Ar select
is an optional glob-pattern.
If given, words from only
.Ar list
that match
.Ar select
are considered
and the
.Ic fignore
shell variable is ignored.
The
.Ar list
types
.Ql $ Ns Ar var ,
.Ql (...) ,
and
.Ql \`...\`
may not have a
.Ar select
pattern, and
.Ql x
uses
.Ar select
as an explanatory message when the
.Ic list-choices
editor command is used.
.Pp
.Ar suffix
is a single character to be appended to a successful
completion.
If null, no character is appended.
If omitted (in which
case the fourth delimiter can also be omitted), a slash is appended to
directories and a space to other words.
.Pp
.Ar command
invoked from
.Ar list
.Ql \`...\`
has the additional environment variable
.Ev COMMAND_LINE
set, which
contains (as its name indicates) contents of the current (already
typed in) command line. One can examine and use contents of the
.Ev COMMAND_LINE
environment variable in a custom script to build more
sophisticated completions (see completion for
.Xr svn 1
included in this package).
.Pp
Now for some examples.
Some commands take only directories as arguments,
so there's no point completing plain files.
.Bd -literal -offset indent
> complete cd 'p/1/d/'
.Ed
.Pp
completes only the first word following
.Ql cd
.Pq Ql p/1
with a directory.
.Ql p Ns
\-type completion can also be used to narrow down command completion:
.Bd -literal -offset indent
> co[^D]
complete compress
> complete \-co* 'p/0/(compress)/'
> co[^D]
> compress
.Ed
.Pp
This completion completes commands (words in position 0,
.Ql p/0 )
which begin with
.Ql co
(thus matching
.Ql co* )
to
.Ql compress
(the only
word in the list).
The leading
.Ql \-
indicates that this completion is to be used with only
ambiguous commands.
.Bd -literal -offset indent
> complete find 'n/\-user/u/'
.Ed
.Pp
is an example of
.Ql n Ns
\-type completion.
Any word following
.Ql find
and
immediately following
.Ql \-user
is completed from the list of users.
.Bd -literal -offset indent
> complete cc 'c/\-I/d/'
.Ed
.Pp
demonstrates
.Ql c Ns
\-type completion.
Any word following
.Ql cc
and beginning with
.Ql \-I
is completed as a directory.
.Ql \-I
is not taken as part of the
directory because we used lowercase
.Ql c .
.Pp
Different
.Ar list Ns No s
are useful with different commands.
.Bd -literal -offset indent
> complete alias 'p/1/a/'
> complete man 'p/*/c/'
> complete set 'p/1/s/'
> complete true 'p/1/x:Truth has no options./'
.Ed
.Pp
These complete words following
.Ql alias
with aliases,
.Ql man
with commands,
and
.Ql set
with shell variables.
.Ic true
doesn't have any options, so
.Ql x
does nothing when completion
is attempted and prints
.Sq Truth has no options.
when completion choices are listed.
.Pp
Note that the
.Ql man
example, and several other examples below, could
just as well have used
.Ql 'c/*'
or
.Ql 'n/*'
as
.Ql 'p/*' .
.Pp
Words can be completed from a variable evaluated at completion time,
.Bd -literal -offset indent
> complete ftp 'p/1/$hostnames/'
> set hostnames = (rtfm.mit.edu tesla.ee.cornell.edu)
> ftp [^D]
rtfm.mit.edu tesla.ee.cornell.edu
> ftp [^C]
> set hostnames = (rtfm.mit.edu tesla.ee.cornell.edu uunet.uu.net)
> ftp [^D]
rtfm.mit.edu tesla.ee.cornell.edu uunet.uu.net
.Ed
.Pp
or from a command run at completion time:
.Bd -literal -offset indent
> complete kill 'p/*/\`ps | awk \e{print\e \e$1\e}\`/'
> kill \-9 [^D]
23113 23377 23380 23406 23429 23529 23530 PID
.Ed
.Pp
Note that the
.Ic complete
command does not itself quote its arguments,
so the braces, space and
.Ql $
in
.Ql {print $1}
must be quoted explicitly.
.Pp
One command can have multiple completions:
.Bd -literal -offset indent
> complete dbx 'p/2/(core)/' 'p/*/c/'
.Ed
.Pp
completes the second argument to
.Ql dbx
with the word
.Ql core
and all other
arguments with commands.
Note that the positional completion is specified
before the next-word completion.
Because completions are evaluated from left to right, if
the next-word completion were specified first it would always match
and the positional completion would never be executed.
This is a
common mistake when defining a completion.
.Pp
The
.Ar select
pattern is useful when a command takes files with only
particular forms as arguments.
For example,
.Bd -literal -offset indent
> complete cc 'p/*/f:*.[cao]/'
.Ed
.Pp
completes
.Ql cc
arguments to files ending in only
.Ql .c ,
.Ql .a ,
or
.Ql .o .
.Ar select
can also exclude files, using negation of a glob-pattern as
described under
.Sx Filename substitution .
One might use
.Bd -literal -offset indent
> complete rm 'p/*/f:^*.{c,h,cc,C,tex,1,man,l,y}/'
.Ed
.Pp
to exclude precious source code from
.Ql rm
completion.
Of course, one
could still type excluded names manually or override the completion
mechanism using the
.Ic complete-word-raw
or
.Ic list-choices-raw
editor commands (q.v.).
.Pp
The
.Ql C ,
.Ql D ,
.Ql F ,
and
.Ql T
.Ar list Ns s
are like
.Ql c ,
.Ql d ,
.Ql f ,
and
.Ql t
respectively, but they use the
.Ar select
argument in a different way: to
restrict completion to files beginning with a particular path prefix.
For
example, the Elm mail program uses
.Ql =
as an abbreviation for one's mail
directory.
One might use
.Bd -literal -offset indent
> complete elm c@=@F:$HOME/Mail/@
.Ed
.Pp
to complete
.Ql elm \-f =
as if it were
.Ql elm \-f ~/Mail/ .
Note that we used the separator
.Ql @
instead of
.Ql /
to avoid confusion with the
.Ar select
argument, and we used
.Ql $HOME
instead of
.Ql ~
because home directory substitution works at only the
beginning of a word.
.Pp
.Ar suffix
is used to add a nonstandard suffix
(not space or
.Ql /
for directories) to completed words.
.Bd -literal -offset indent
> complete finger 'c/*@/$hostnames/' 'p/1/u/@'
.Ed
.Pp
completes arguments to
.Ql finger
from the list of users, appends an
.Ql @ ,
and then completes after the
.Ql @
from the
.Ql hostnames
variable.
Note
again the order in which the completions are specified.
.Pp
Finally, here's a complex example for inspiration:
.Bd -literal -offset indent
> complete find \e
\&'n/\-name/f/' 'n/\-newer/f/' 'n/\-{,n}cpio/f/' \e
\&\'n/\-exec/c/' 'n/\-ok/c/' 'n/\-user/u/' \e
\&'n/\-group/g/' 'n/\-fstype/(nfs 4.2)/' \e
\&'n/\-type/(b c d f l p s)/' \e
\'c/\-/(name newer cpio ncpio exec ok user \e
group fstype type atime ctime depth inum \e
ls mtime nogroup nouser perm print prune \e
size xdev)/' \e
\&'p/*/d/'
.Ed
.Pp
This completes words following
.Ql \-name ,
.Ql \-newer ,
.Ql \-cpio ,
or
.Ql ncpio
(note the pattern which matches both) to files,
words following
.Ql \-exec
or
.Ql \-ok
to commands, words following
.Ql user
and
.Ql group
to users and groups respectively
and words following
.Ql \-fstype
or
.Ql \-type
to members of the
given lists.
It also completes the switches themselves from the given list
(note the use of
.Ql c Ns
\-type completion)
and completes anything not otherwise completed to a directory.
Whew.
.Pp
Remember that programmed completions are ignored if the word being completed
is a tilde substitution (beginning with
.Ql ~ )
or a variable (beginning with
.Ql $ ) .
See also the
.Ic uncomplete
builtin command.
.
.It Ic continue
Continues execution of the nearest enclosing
.Ic while
or
.Ic foreach .
The rest of the commands on the current line are executed.
.
.It Ic default:
Labels the default case in a
.Ic switch
statement.
It should come after all
.Ic case
labels.
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic dirs Xo
.Op Fl l
.Op Fl n Ns | Ns Fl v
.Xc
.It Ic dirs Xo
.Fl S Ns | Ns Fl L
.Op Ar filename
(+)
.Xc
.It Ic dirs Xo
.Fl c
(+)
.Xc
The first form prints the directory stack.
The top of the stack is at the
left and the first directory in the stack is the current directory.
With
.Fl l ,
.Ql ~
or
.Ql ~ Ns Ar name
in the output is expanded explicitly
to
.Ic home
or the pathname of the home directory for user
.Ar name .
(+)
With
.Fl n ,
entries are wrapped before they reach the edge of the screen.
(+)
With
.Fl v ,
entries are printed one per line, preceded by their stack positions.
(+)
If more than one of
.Fl n
or
.Fl v
is given,
.Fl v
takes precedence.
.Fl p
is accepted but does nothing.
.Pp
With
.Fl S ,
the second form saves the directory stack to
.Ar filename
as a series of
.Ic cd
and
.Ic pushd
commands.
With
.Fl L ,
the shell sources
.Ar filename ,
which is presumably
a directory stack file saved by the
.Fl S
option or the
.Ic savedirs
mechanism.
In either case,
.Ic dirsfile
is used if
.Ar filename
is not given and
.Pa ~/.cshdirs
is used if
.Ic dirsfile
is unset.
.Pp
Note that login shells do the equivalent of
.Ql dirs \-L
on startup
and, if
.Ic savedirs
is set,
.Ql dirs \-S
before exiting.
Because only
.Pa ~/.tcshrc
is normally sourced before
.Pa ~/.cshdirs ,
.Ic dirsfile
should be set in
.Pa ~/.tcshrc
rather than
.Pa ~/.login .
.Pp
The third form clears the directory stack.
.
.El
.Bl -tag -width 8n
.
.It Ic echo Oo Fl n Oc Ar word No \&...
Writes each
.Ar word
to the shell's standard
output, separated by spaces and terminated with a newline.
The
.Ic echo_style
shell variable may be set to emulate (or not) the flags and escape
sequences of the BSD and/or System V versions of
.Xr echo 1 ;
see
.Sx Escape sequences
and
.Xr echo 1 .
.
.It Ic echotc Oo Fl sv Oc Ar arg No \&... No (+)
Exercises the terminal capabilities (see
.Xr termcap 5 )
in
.Ar arg .
For example,
.Ql echotc home
sends the cursor to the home position,
.Ql echotc cm 3 10
sends it to column 3 and row 10, and
.Ql echotc ts 0; echo \&"This is a test.\&"; echotc fs
prints
.Sq This is a test.
in the status line.
.Pp
If
.Ar arg
is
.Ql baud ,
.Ql cols ,
.Ql lines ,
.Ql meta ,
or
.Ql tabs ,
prints the
value of that capability
.Dq ( yes
or
.Dq no
indicating that the terminal does
or does not have that capability).
One might use this to make the output
from a shell script less verbose on slow terminals, or limit command
output to the number of lines on the screen:
.Bd -literal -offset indent
> set history=\`echotc lines\`
> @ history\-\-
.Ed
.Pp
Termcap strings may contain wildcards which will not echo correctly.
One should use double quotes when setting a shell variable to a terminal
capability string, as in the following example that places the date in
the status line:
.Bd -literal -offset indent
> set tosl="\`echotc ts 0\`"
> set frsl="\`echotc fs\`"
> echo \-n "$tosl";date; echo \-n "$frsl"
.Ed
.Pp
With
.Fl s ,
nonexistent capabilities return the empty string rather
than causing an error.
With
.Fl v ,
messages are verbose.
.Pp
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic else
.It Ic end
.It Ic endif
.It Ic endsw
See the description of the
.Ic foreach ,
.Ic if ,
.Ic switch ,
and
.Ic while
statements below.
.
.El
.Bl -tag -width 8n
.
.It Ic eval Ar arg No \&...
Treats the arguments as input to the
shell and executes the resulting command(s) in the context
of the current shell.
This is usually used to execute commands
generated as the result of command or variable substitution,
because parsing occurs before these substitutions.
See
.Xr tset 1
for a sample use of
.Ic eval .
.
.It Ic exec Ar command No \&...
Executes the specified
.Ar command
in place of the current shell.
.
.It Ic exit Op Ar expr
The shell exits either with the value of the specified
.Ar expr
(an expression, as described under
.Sx Expressions )
or, without
.Ar expr ,
with the value 0.
.
.It Ic fg Op Cm % Ns Ar job No \&...
Brings the specified jobs (or, without arguments, the current job)
into the foreground, continuing each if it is stopped.
.Ar job
may be a number, a string,
.Ql \& ,
.Ql % ,
.Ql + ,
or
.Ql \-
as described under
.Sx Jobs .
See also the
.Ic run-fg-editor
editor command.
.
.It Ic filetest \- Ns Ar op file No \&... No (+)
Applies
.Ar op
(which is a file inquiry operator as described under
.Sx File inquiry operators )
to each
.Ar file
and returns the results as a
space-separated list.
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic foreach Ar name Cm \&( Ns Ar wordlist Ns Cm \&)
.It Ic \&...
.It Ic end
Successively sets the variable
.Ar name
to each member of
.Ar wordlist
and executes the sequence of commands between this command
and the matching
.Ic end .
(Both
.Ic foreach
and
.Ic end
must appear alone on separate lines.)  The builtin command
.Ic continue
may be used to continue the loop prematurely and
the builtin command
.Ic break
to terminate it prematurely.
When this command is read from the terminal, the loop is read once
prompting with
.Sq Li foreach?\ \&
(or
.Ic prompt2 )
before any statements in
the loop are executed.
If you make a mistake typing in a
loop at the terminal you can rub it out.
.
.El
.Bl -tag -width 8n
.
.It Ic getspath No (+)
Prints the system execution path.
(TCF only)
.
.It Ic getxvers No (+)
Prints the experimental version prefix.
(TCF only)
.
.It Ic glob Ar word No \&...
Like
.Ic echo ,
but the
.Fl n
parameter is not recognized and words are
delimited by null characters in the output.
Useful for
programs which wish to use the shell to filename expand a list of words.
.
.It Ic goto Ar word
.Ar word
is filename and command-substituted to
yield a string of the form
.Sq Ar label .
The shell rewinds its
input as much as possible, searches for a line of the
form
.Sq Ar label Ns No \&: ,
possibly preceded by blanks or tabs, and
continues execution after that line.
.
.It Ic hashstat
Prints a statistics line indicating how effective the
internal hash table has been at locating commands (and avoiding
.Ic exec Ns
\&'s).
An
.Ic exec
is attempted for each component of the
.Ic path
where the hash function indicates a possible hit, and
in each component which does not begin with a
.Ql / .
.Pp
On machines without
.Xr vfork 2 ,
prints only the number and size of
hash buckets.
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic history Xo
.Op Fl hTr
.Op Ar n
.Xc
.It Ic history Xo
.Fl S Ns | Ns Fl L Ns | Ns Fl M
.Op Ar filename
(+)
.Xc
.It Ic history Xo
.Fl c
(+)
.Xc
The first form prints the history event list.
If
.Ar n
is given only the
.Ar n
most recent events are printed or saved.
With
.Fl h ,
the history list is printed without leading numbers.
If
.Fl T
is specified, timestamps are printed also in comment form.
(This can be used to
produce files suitable for loading with
.Ql history \-L
or
.Ql source \-h . )
With
.Fl r ,
the order of printing is most recent
first rather than oldest first.
.Pp
With
.Fl S ,
the second form saves the history list to
.Ar filename .
If the first word of the
.Ic savehist
shell variable is set to a
number, at most that many lines are saved.
If the second word of
.Ic savehist
is set to
.Ql merge ,
the history list is merged with the
existing history file instead of replacing it (if there is one) and
sorted by time stamp.
(+) Merging is intended for an environment like
the X Window System
with several shells in simultaneous use.
If the second word of
.Ic savehist
is
.Ql merge
and the third word is set to
.Ql lock ,
the history file update
will be serialized with other shell sessions that would possibly like
to merge history at exactly the same time.
.Pp
With
.Fl L ,
the shell appends
.Ar filename ,
which is presumably a
history list saved by the
.Fl S
option or the
.Ic savehist
mechanism,
to the history list.
.Fl M
is like
.Fl L ,
but the contents of
.Ar filename
are merged
into the history list and sorted by timestamp.
In either case,
.Ic histfile
is used if
.Ar filename
is not given and
.Pa ~/.history
is used if
.Ic histfile
is unset.
.Ql history \-L
is exactly like
.Ql source \-h
except that it does not require a
filename.
.Pp
Note that login shells do the equivalent of
.Ql history \-L
on startup
and, if
.Ic savehist
is set,
.Ql history \-S
before exiting.
Because only
.Pa ~/.tcshrc
is normally sourced before
.Pa ~/.history ,
.Ic histfile
should be set in
.Pa ~/.tcshrc
rather than
.Pa ~/.login .
.Pp
If
.Ic histlit
is set, the first and second forms print and save the literal
(unexpanded) form of the history list.
.Pp
The third form clears the history list.
.
.El
.Bl -tag -width 8n
.
.It Ic hup Oo Ar command Oc No (+)
With
.Ar command ,
runs
.Ar command
such that it will exit on a hangup
signal and arranges for the shell to send it a hangup signal when the shell
exits.
Note that commands may set their own response to hangups, overriding
.Ic hup .
Without an argument, causes the non-interactive shell only to
exit on a hangup for the remainder of the script.
See also
.Sx Signal handling
and the
.Ic nohup
builtin command.
.
.It Ic if Cm \&( Ns Ar expr Ns Cm \&) Ar command
If
.Ar expr
(an expression, as described under
.Sx Expressions )
evaluates true, then
.Ar command
is executed.
Variable substitution on
.Ar command
happens early, at the same time it
does for the rest of the
.Ic if
command.
.Ar command
must be a simple command, not an alias, a pipeline, a command list
or a parenthesized command list, but it may have arguments.
Input/output redirection occurs even if
.Ar expr
is
false and
.Ar command
is thus
.Em not
executed; this is a bug.
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic if Cm \&( Ns Ar expr Ns Cm \&) then
.It Ic \&...
.It Ic else if Cm \&( Ns Ar expr2 Ns Cm \&) then
.It Ic \&...
.It Ic else
.It Ic \&...
.It Ic endif
If the specified
.Ar expr
is true then the commands to the
first
.Ic else
are executed; otherwise if
.Ar expr2
is true then
the commands to the second
.Ic else
are executed, etc.
Any
number of
.Ic else if
pairs are possible; only one
.Ic endif
is
needed.
The
.Ic else
part is likewise optional.
(The words
.Ic else
and
.Ic endif
must appear at the beginning of input lines;
the
.Ic if
must appear alone on its input line or after an
.Ic else . )
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic inlib Ar shared-library No \&... No (+)
Adds each
.Ar shared-library
to the current environment.
There is no way
to remove a shared library.
(Domain/OS only)
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic jobs Op Fl l
.It Ic jobs Fl Z Oo Ar title Oc No (+)
Lists the active jobs.
With
.Fl l ,
lists process IDs in addition to the normal information.
On TCF systems, prints the site on which each job is executing.
.Pp
The
.Fl Z
option sets the process title to
.Ar title
using
.Xr setproctitle 3
where available.
If no
.Ar title
is provided, the process title will be cleared.
.
.\" adjacant multi-tag items; add a blank
.Pp
.
.It Ic kill Fl l
.It Ic kill Xo
.Op Fl s Ar signal
.Cm % Ns Ar job Ns | Ns Ar pid No \&...
.Xc
The first form lists the signal names.
.Pp
The second form sends the specified
.Ar signal
(or, if none
is given, the TERM (terminate) signal) to the specified jobs or processes.
.Ar job
may be a number, a string,
.Ql \& ,
.Ql % ,
.Ql + ,
or
.Ql \-
as described under
.Sx Jobs .
Signals are either given by number or by name (as given in
.Pa /usr/include/signal.h ,
stripped of the prefix
.Sq SIG ) .
There is no default
.Ar job ;
entering just
.Ql kill
does not send a signal
to the current job.
If the signal being sent is TERM (terminate)
or HUP (hangup), then the job or process is sent a
CONT (continue) signal as well.
.
.El
.Bl -tag -width 8n
.
.It Ic limit Oo Fl h Oc Op Ar resource Op Ar maximum-use
Limits the consumption by the current process and each
process it creates to not individually exceed
.Ar maximum-use
on
the specified
.Ar resource .
If no
.Ar maximum-use
is given, then
the current limit is printed; if no
.Ar resource
is given, then
all limitations are given.
If the
.Fl h
flag is given, the
hard limits are used instead of the current limits.
The
hard limits impose a ceiling on the values of the current
limits.
Only the super-user may raise the hard limits, but
a user may lower or raise the current limits within the legal range.
.Pp
Controllable
.Ar resource
types currently include (if supported by the OS):
.Bl -tag -width 12n -offset indent
.
.It Ic concurrency
Maximum number of threads for this process.
.
.It Ic coredumpsize
Size of the largest core dump that will be created.
.
.It Ic cputime
Maximum number of cpu-seconds to be used by each process.
.
.It Ic datasize
Maximum growth of the data+stack region via
.Xr sbrk 2
beyond the end of the program text.
.
.It Ic descriptors No or Ic openfiles
Maximum number of open files for this process.
.
.It Ic filesize
Largest single file which can be created.
.
.It Ic heapsize
Maximum amount of memory a process
may allocate per
.Xr brk 2
system call.
.
.It Ic kqueues
Maximum number of kqueues allocated for this process.
.
.It Ic maxlocks
Maximum number of locks for this user.
.
.It Ic maxmessage
Maximum number of bytes in POSIX mqueues for this user.
.
.It Ic maxnice
Maximum nice priority the user is allowed to raise mapped from [19...-20]
to [0...39] for this user.
.
.It Ic maxproc
Maximum number of simultaneous processes for this user id.
.
.It Ic maxrtprio
Maximum realtime priority for this user.
.
.It Ic maxrttime
Timeout for RT tasks in microseconds for this user.
.
.It Ic maxsignal
Maximum number of pending signals for this user.
.
.It Ic maxthread
Maximum number of simultaneous threads (lightweight processes) for this
user id.
.
.It Ic memorylocked
Maximum size which a process may lock into memory using
.Xr mlock 2 .
.
.It Ic memoryuse
Maximum amount of physical memory a process
may have allocated to it at a given time.
.
.It Ic posixlocks
Maximum number of POSIX advisory locks for this user.
.
.It Ic pseudoterminals
Maximum number of pseudo-terminals for this user.
.
.It Ic sbsize
Maximum size of socket buffer usage for this user.
.
.It Ic stacksize
Maximum size of the automatically-extended stack region.
.
.It Ic swapsize
Maximum amount of swap space reserved or used for this user.
.
.It Ic threads
Maximum number of threads for this process.
.
.It Ic vmemoryuse
Maximum amount of virtual memory a process
may have allocated to it at a given time (address space).
.
.El
.Pp
.Ar maximum-use
may be given as a (floating point or
integer) number followed by a scale factor.
For all limits
other than
.Ic cputime
the default scale is
.Ql k
or
.Ql kilobytes
(1024 bytes); a scale factor of
.Ql m
or
.Ql megabytes
or
.Ql g
or
.Ql gigabytes
may also be used.
For
.Ic cputime
the default scaling is
.Ql seconds ,
while
.Ql m
for minutes or
.Ql h
for hours, or a time of the
form
.Sq Ar mm Ns Li : Ns Ar ss
giving minutes and seconds may be used.
.Pp
If
.Ar maximum-use
is
.Ql unlimited ,
then the limitation on the specified
.Ar resource
is removed (this is equivalent to the
.Ic unlimit
builtin command).
.Pp
For both
.Ar resource
names and scale factors, unambiguous
prefixes of the names suffice.
.
.It Ic log No (+)
Prints the
.Ic watch
shell variable and reports on each user indicated
in
.Ic watch
who is logged in, regardless of when they last logged in.
See also
.Ic watchlog .
.
.It Ic login
Terminates a login shell, replacing it with an instance of
.Pa /bin/login .
This is one way to log off, included for
compatibility with
.Xr sh 1 .
.
.It Ic logout
Terminates a login shell.
Especially useful if
.Ic ignoreeof
is set.
.
.It Ic ls\-F Xo
.Op Fl Ar switch No \&...
.Op Ar file No \&...
(+)
.Xc
Lists files like
.Ql ls \-F ,
but much faster.
It identifies each type of
special file in the listing with a special character:
.Pp
.Bl -tag -width 5n -offset indent -compact
.It Li /
Directory.
.It Li *
Executable.
.It Li #
Block device.
.It Li %
Character device.
.It Li |
Named pipe (systems with named pipes only).
.It Li =
Socket (systems with sockets only).
.It Li @
Symbolic link (systems with symbolic links only).
.It Li +
Hidden directory (AIX only) or context dependent (HP/UX only).
.It Li :
Network special (HP/UX only).
.El
.Pp
If the
.Ic listlinks
shell variable is set, symbolic links are identified
in more detail (on only systems that have them, of course):
.Pp
.Bl -tag -width 5n -offset indent -compact
.It Li @
Symbolic link to a non-directory.
.It Li >
Symbolic link to a directory.
.It Li &
Symbolic link to nowhere.
.El
.Pp
.Ic listlinks
also slows down
.Ic ls\-F
and causes partitions holding
files pointed to by symbolic links to be mounted.
.Pp
If the
.Ic listflags
shell variable is set to
.Ql x ,
.Ql a ,
or
.Ql A ,
or any
combination thereof (e.g.,
.Ql xA ) ,
they are used as flags to
.Ic ls\-F ,
making it act like
.Ql ls \-xF ,
.Ql ls \-Fa ,
.Ql ls \-FA ,
or a combination
(e.g.,
.Ql ls \-FxA ) .
On machines where
.Ql ls \-C
is not the default,
.Ic ls\-F
acts like
.Ql ls \-CF ,
unless
.Ic listflags
contains an
.Ql x ,
in which case it acts like
.Ql ls \-xF .
.Ic ls\-F
passes its arguments to
.Xr ls 1
if it is given any switches,
so
.Ql alias ls ls\-F
generally does the right thing.
.Pp
The
.Ic ls\-F
builtin can list files using different colors depending on the
filetype or extension.
See the
.Ic color
shell variable and the
.Ev LS_COLORS
environment variable.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic migrate Xo
.Op Fl Ar site
.Ar pid Ns | Ns Cm % Ns Ar jobid No \&... (+)
.Xc
.It Ic migrate Fl Ar site No (+)
The first form migrates the process or job to the site specified or the
default site determined by the system path.
(TCF only)
.Pp
The second form is equivalent to
.Ql migrate \- Ns Ar site Li $$ :
it migrates the
current process to the specified site.
Migrating the shell
itself can cause unexpected behavior, because the shell
does not like to lose its tty.
(TCF only)
.El
.Bl -tag -width 8n
.
.It Ic newgrp Oo Cm \- Oc Oo Ar group Oc No (+)
Equivalent to
.Ql exec newgrp ;
see
.Xr newgrp 1 .
Available only if the shell was so compiled;
see the
.Ic version
shell variable.
.
.It Ic nice Oo Cm + Ns Ar number Oc Op Ar command
Sets the scheduling priority for the shell to
.Ar number ,
or, without
.Ar number ,
to 4.
With
.Ar command ,
runs
.Ar command
at the appropriate
priority.
The greater the
.Ar number ,
the less cpu
the process gets.
The super-user may specify negative
priority by using
.Ql nice \- Ns Ar number Li \&... .
Command is always
executed in a sub-shell, and the restrictions placed on
commands in simple
.Ic if
statements apply.
.
.It Ic nohup Op Ar command
With
.Ar command ,
runs
.Ar command
such that it will ignore hangup signals.
Note that commands may set their own response to hangups, overriding
.Ic nohup .
Without an argument, causes the non-interactive shell only to
ignore hangups for the remainder of the script.
See also
.Sx Signal handling
and the
.Ic hup
builtin command.
.
.It Ic notify Op Cm % Ns Ar job No \&...
Causes the shell to notify the user asynchronously when the status of any
of the specified jobs (or, without
.Cm % Ns Ar job ,
the current job) changes,
instead of waiting until the next prompt as is usual.
.Ar job
may be a number, a string,
.Ql \& ,
.Ql % ,
.Ql + ,
or
.Ql \-
as described under
.Sx Jobs .
See also the
.Ic notify
shell variable.
.
.It Ic onintr Op Cm \- Ns | Ns Ar label
Controls the action of the shell on interrupts.
Without arguments,
restores the default action of the shell on interrupts,
which is to terminate shell scripts or to return to the
terminal command input level.
With
.Ql \- ,
causes all interrupts to be ignored.
With
.Ar label ,
causes the shell to execute a
.Ql goto Ar label
when an interrupt is received or a child process terminates because it was
interrupted.
.Pp
.Ic onintr
is ignored if the shell is running detached and in system
startup files (see
.Sx FILES ) ,
where interrupts are disabled anyway.
.
.It Ic popd Xo
.Op Fl p
.Op Fl l
.Op Fl n Ns | Ns Fl v
.Op Cm + Ns Ar n
.Xc
Without arguments, pops the directory stack and returns to the new top directory.
With a number
.Ql + Ns Ar n ,
discards the
.Ar n Ns
th entry in the stack.
.Pp
Finally, all forms of
.Ic popd
print the final directory stack,
just like
.Ic dirs .
The
.Ic pushdsilent
shell variable can be set to
prevent this and the
.Fl p
flag can be given to override
.Ic pushdsilent .
The
.Fl l ,
.Fl n ,
and
.Fl v
flags have the same effect on
.Ic popd
as on
.Ic dirs.
(+)
.
.It Ic printenv Oo Ar name Oc No (+)
Prints the names and values of all environment variables or,
with
.Ar name ,
the value of the environment variable
.Ar name .
.
.It Ic pushd Xo
.Op Fl p
.Op Fl l
.Op Fl n Ns | Ns Fl v
.Op Ar name Ns | Ns Cm + Ns Ar n
.Xc
Without arguments, exchanges the top two elements of the directory stack.
If
.Ic pushdtohome
is set,
.Ic pushd
without arguments does
.Ql pushd ~ ,
like
.Ic cd .
(+)
With
.Ar name ,
pushes the current working directory onto the directory
stack and changes to
.Ar name .
If
.Ar name
is
.Ql \-
it is interpreted as the previous working directory
(see
.Sx Filename substitution ) .
(+)
If
.Ic dunique
is set,
.Ic pushd
removes any instances of
.Ar name
from the stack before pushing it onto the stack.
(+)
With a number
.Ql + Ns Ar n ,
rotates the
.Ar n Ns
th element of the
directory stack around to be the top element and changes to it.
If
.Ic dextract
is set, however,
.Ql pushd + Ns Ar n
extracts the
.Ar n Ns
th
directory, pushes it onto the top of the stack and changes to it.
(+)
.Pp
Finally, all forms of
.Ic pushd
print the final directory stack,
just like
.Ic dirs .
The
.Ic pushdsilent
shell variable can be set to
prevent this and the
.Fl p
flag can be given to override
.Ic pushdsilent .
The
.Fl l ,
.Fl n ,
and
.Fl v
flags have the same effect on
.Ic pushd
as on
.Ic dirs .
(+)
.
.It Ic rehash
Causes the internal hash table of the contents of the
directories in the
.Ic path
variable to be recomputed.
This is
needed if the
.Ic autorehash
shell variable is not set and new
commands are added to directories in
.Ic path
while you are logged
in.
With
.Ic autorehash ,
a new command will be found
automatically, except in the special case where another command of
the same name which is located in a different directory already
exists in the hash table.
Also flushes the cache of home directories
built by tilde expansion.
.
.It Ic repeat Ar count Ar command
The specified
.Ar command ,
which is subject to the same restrictions as the
.Ar command
in the one line
.Ic if
statement above, is executed
.Ar count
times.
I/O redirections occur exactly once, even if
.Ar count
is 0.
.
.It Ic rootnode Cm // Ns Ar nodename No (+)
Changes the rootnode to
.Pa // Ns Ar nodename ,
so that
.Ql /
will be interpreted
as
.Ql // Ns Ar nodename .
(Domain/OS only)
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic sched No (+)
.It Ic sched Xo
.Op Cm + Ns
.Ar hh Ns Cm : Ns Ar mm
.Ar command
(+)
.Xc
.It Ic sched Cm \- Ns Ar n No (+)
The first form prints the scheduled-event list.
The
.Ic sched
shell variable may be set to define the format in which
the scheduled-event list is printed.
.Pp
The second form adds
.Ar command
to the scheduled-event list.
For example,
.Bd -literal -offset indent
> sched 11:00 echo It\e's eleven o\e'clock.
.Ed
.Pp
causes the shell to echo
.Sq It's eleven o'clock.
at 11 AM.
The time may be in 12-hour AM/PM format
.Bd -literal -offset indent
.\" TODO
> sched 5pm set prompt='[%h] It\e's after 5; go home: >'
.Ed
.Pp
or may be relative to the current time:
.Bd -literal -offset indent
> sched +2:15 /usr/lib/uucp/uucico \-r1 \-sother
.Ed
.Pp
A relative time specification may not use AM/PM format.
.Pp
The third form removes item
.Ar n
from the event list:
.Bd -literal -offset indent
> sched
1  Wed Apr  4 15:42  /usr/lib/uucp/uucico \-r1 \-sother
2  Wed Apr  4 17:00  set prompt=[%h] It's after 5; go home: >
> sched \-2
> sched
1  Wed Apr  4 15:42  /usr/lib/uucp/uucico \-r1 \-sother
.Ed
.Pp
A command in the scheduled-event list is executed just before the first
prompt is printed after the time when the command is scheduled.
It is possible to miss the exact time when the command is to be run, but
an overdue command will execute at the next prompt.
A command which comes due while the shell
is waiting for user input is executed immediately.
However, normal operation of an already-running command will not
be interrupted so that a scheduled-event list element may be run.
.Pp
This mechanism is similar to, but not the same as, the
.Xr at 1
command on some Unix systems.
Its major disadvantage is that it may not run a command at exactly the
specified time.
Its major advantage is that because
.Ic sched
runs directly from
the shell, it has access to shell variables and other structures.
This provides a mechanism for changing one's working environment
based on the time of day.
.
.\" adjacant multi-tag items; add a blank
.Pp
.
.It Ic set
.It Ic set Ar name No \&...
.It Ic set Ar name Ns Cm = Ns Ar word No \&...
.It Ic set Xo
.Op Fl r
.Op Fl f Ns | Ns Fl l
.Ar name Ns Cm =\&( Ns Ar wordlist Ns Cm \&) No \&...
(+)
.Xc
.It Ic set Ar name Ns Cm [ Ns Ar index Ns Cm ]= Ns Ar word No \&...
.It Ic set Fl r No (+)
.It Ic set Fl r Ar name No \&... No (+)
.It Ic set Fl r Ar name Ns Cm = Ns Ar word No \&... No (+)
The first form of the command prints the value of all shell variables.
Variables which contain more than a single word print as a
parenthesized word list.
.Pp
The second form sets
.Ar name
to the null string.
.Pp
The third form sets
.Ar name
to the single
.Ar word .
.Pp
The fourth form sets
.Ar name
to the list of words in
.Ar wordlist .
.Pp
In all cases the value is command and filename expanded.
If
.Fl r
is specified, the value is set read-only.
If
.Fl f
or
.Fl l
are specified, set only unique words keeping their order.
.Fl f
prefers the first occurrence of a word, and
.Fl l
the last.
.Pp
The fifth form sets the
.Ar index Ns
\&'th component of
.Ar name
to
.Ar word ;
this component must already exist.
.Pp
The sixth form lists only the names of all shell variables that are read-only.
.Pp
The seventh form makes
.Ar name
read-only, whether or not it has a value.
.Pp
The eighth form is the same as the third form, but
make
.Ar name
read-only at the same time.
.Pp
These arguments can be repeated to set and/or make read-only multiple variables
in a single set command.
Note, however, that variable expansion
happens for all arguments before any setting occurs.
Note also that
.Ql =
can
be adjacent to both
.Ar name
and
.Ar word
or separated from both by
whitespace, but cannot be adjacent to only one or the other.
See also the
.Ic unset
builtin command.
.
.El
.Bl -tag -width 8n
.
.It Ic setenv Op Ar name Op Ar value
Without arguments, prints the names and values of all environment variables.
Given
.Ar name ,
sets the environment variable
.Ar name
to
.Ar value
or, without
.Ar value ,
to the null string.
.
.It Ic setpath Ar path No (+)
Equivalent to
.Xr setpath 1 .
(Mach only)
.
.It Ic setspath Cm LOCAL Ns | Ns Ar site Ns | Ns Ar cpu No \&... No (+)
Sets the system execution path.
(TCF only)
.
.It Ic settc Ar cap value No (+)
Tells the shell to believe that the terminal capability
.Ar cap
(as defined in
.Xr termcap 5 )
has the value
.Ar value .
No sanity checking is done.
Concept terminal users may have to
.Ql settc xn no
to get proper
wrapping at the rightmost column.
.
.It Ic setty Xo
.Op Fl d Ns | Ns Fl q Ns | Ns Fl x
.Op Fl a
.Op Oo Cm + Ns | Ns Cm \- Oc Ns Ar mode
(+)
.Xc
Controls which tty modes (see
.Sx Terminal management )
the shell does not allow to change.
.Fl d ,
.Fl q ,
or
.Fl x
tells
.Ic setty
to act
on the
.Ql edit ,
.Sq quote ,
or
.Sq execute
set of tty modes respectively; without
.Fl d ,
.Fl q ,
or
.Fl x ,
.Sq execute
is used.
.Pp
Without other arguments,
.Ic setty
lists the modes in the chosen set
which are fixed on
.Pq Sq Cm + Ns Ar mode
or off
.Pq Sq Cm - Ns Ar mode .
The available modes, and thus the display, vary from system to system.
With
.Fl a ,
lists all tty modes in the chosen set
whether or not they are fixed.
With
.Cm + Ns Ar mode ,
.Cm - Ns Ar mode ,
or
.Ar mode ,
fixes
.Ar mode
on or off
or removes control from
.Ar mode
in the chosen set.
For example,
.Ql setty +echok echoe
fixes
.Ql echok
mode on and allows commands
to turn
.Ql echoe
mode on or off, both when the shell is executing commands.
.
.It Ic setxvers Oo Ar string Oc No (+)
Set the experimental version prefix to
.Ar string ,
or removes it
if
.Ar string
is omitted.
(TCF only)
.
.It Ic shift Op Ar variable
Without arguments, discards
.Ic argv Ns [1]
and shifts the members of
.Ic argv
to the left.
It is an error for
.Ic argv
not to be set or to have
less than one word as value.
With
.Ar variable ,
performs the
same function on
.Ar variable .
.
.It Ic source Oo Fl h Oc Ar name Op Ar args No \&...
The shell reads and executes commands from
.Ar name .
The commands are not placed on the history list.
If any
.Ar args
are given, they are placed in
.Ic argv .
(+)
.Ic source
commands may be nested;
if they are nested too deeply the shell may run out of file descriptors.
An error in a
.Ic source
at any level terminates all nested
.Ic source
commands.
With
.Fl h ,
commands are placed on the history list instead of being
executed, much like
.Ql history \-L .
.
.It Ic stop % Ns Ar job Ns | Ns Ar pid No \&...
Stops the specified jobs or processes which are executing in the background.
.Ar job
may be a number, a string,
.Ql \& ,
.Ql % ,
.Ql + ,
or
.Ql \-
as described under
.Sx Jobs .
There is no default
.Ar job ;
entering just
.Ql stop
does not stop
the current job.
.
.It Ic suspend
Causes the shell to stop in its tracks, much as if it had
been sent a stop signal with
.Sq ^Z .
This is most often used to
stop shells started by
.Xr su 1 .
.
.El
.Pp
.Bl -tag -width 8n -compact
.
.It Ic switch Cm \&( Ns Ar string Ns Cm \&)
.It Ic case Ar str1 Ns :
.It Ic \ \ \ \ \&...
.It Ic \ \ \ \ breaksw
.It Ic \&...
.It Ic default:
.It Ic \ \ \ \ \&...
.It Ic \ \ \ \ breaksw
.It Ic endsw
Each case label is successively matched, against the
specified
.Ar string
which is first command and filename expanded.
The file metacharacters
.Ql * ,
.Ql \&? ,
and
.Ql [...]
may be used
in the case labels, which are variable expanded.
If none
of the labels match before a
.Ic default
label is found, then
the execution begins after the
.Ic default
label.
Each case
label and the
.Ic default
label must appear at the beginning of
a line.
The command
.Ic breaksw
causes execution to continue
after the
.Ic endsw .
Otherwise control may fall through case
labels and default labels as in C.
If no label matches and
there is no default, execution continues after the
.Ic endsw .
.
.El
.Bl -tag -width 8n
.
.It Ic telltc No (+)
Lists the values of all terminal capabilities (see
.Xr termcap 5 ) .
.
.It Ic termname Oo Ar termtype Oc No (+)
Tests if
.Ar termtype
(or the current value of
.Ev TERM
if no
.Ar termtype
is given) has an entry in the hosts
.Xr termcap 5
or
.Xr terminfo 5
database. Prints the terminal type to stdout and returns 0
if an entry is present otherwise returns 1.
.
.It Ic time Op Ar command
Executes
.Ar command
(which must be a simple command, not an alias,
a pipeline, a command list or a parenthesized command list)
and prints a time summary as described under the
.Ic time
variable.
If necessary, an extra shell is created to print the time statistic when
the command completes.
Without
.Ar command ,
prints a time summary for the current shell and its
children.
..
.It Ic umask Op Ar value
Sets the file creation mask to
.Ar value ,
which is given in octal.
Common values for the mask are
002, giving all access to the group and read and execute access to others, and
022, giving read and execute access to the group and others.
Without
.Ar value ,
prints the current file creation mask.
.
.It Ic unalias Ar pattern
Removes all aliases whose names match
.Ar pattern .
.Ql unalias *
thus removes all aliases.
It is not an error for nothing to be
.Ic unalias Ns
ed.
.
.It Ic uncomplete Ar pattern No (+)
Removes all completions whose names match
.Ar pattern .
.Ql uncomplete *
thus removes all completions.
It is not an error for nothing to be
.Ic uncomplete Ns
d.
.
.It Ic unhash
Disables use of the internal hash table to speed location of
executed programs.
.
.It Ic universe Ar universe No (+)
Sets the universe to
.Ar universe .
(Masscomp/RTU only)
.
.It Ic unlimit Oo Fl hf Oc Op Ar resource
Removes the limitation on
.Ar resource
or, if no
.Ar resource
is
specified, all
.Ar resource
limitations.
With
.Fl h ,
the corresponding hard limits are removed.
Only the super-user may do this.
Note that
.Ic unlimit
may not exit successful, since most systems
do not allow
.Ic descriptors
to be unlimited.
With
.Fl f
errors are ignored.
.
.It Ic unset Ar pattern
Removes all variables whose names match
.Ar pattern ,
unless they are read-only.
.Ql unset *
thus removes all variables unless they are read-only;
this is a bad idea.
It is not an error for nothing to be
.Ic unset .
.
.It Ic unsetenv Ar pattern
Removes all environment variables whose names match
.Ar pattern .
.Ql unsetenv *
thus removes all environment variables;
this is a bad idea.
It is not an error for nothing to be
.Ar unsetenv Ns
ed.
.
.It Ic ver Oo Ar systype Oo Ar command Oc Oc No (+)
Without arguments, prints
.Ev SYSTYPE .
With
.Ar systype ,
sets
.Ev SYSTYPE
to
.Ar systype .
With
.Ar systype
and
.Ar command ,
executes
.Ar command
under
.Ar systype .
.Ar systype
may be
.Ql bsd4.3
or
.Ql sys5.3 .
(Domain/OS only)
.
.It Ic wait
The shell waits for all background jobs.
If the shell is interactive, an
interrupt will disrupt the wait and cause the shell to print the names and job
numbers of all outstanding jobs.
.
.It Ic warp Ar universe No (+)
Sets the universe to
.Ar universe .
(Convex/OS only)
.
.It Ic watchlog No (+)
An alternate name for the
.Ic log
builtin command (q.v.).
Available only if the shell was so compiled;
see the
.Ic version
shell variable.
.
.It Ic where Ar command No (+)
Reports all known instances of
.Ar command ,
including aliases, builtins and
executables in
.Ic path .
.
.It Ic which Ar command No (+)
Displays the command that will be executed by the shell after substitutions,
.Ic path
searching, etc.
The builtin command is just like
.Xr which 1 ,
but it correctly reports
.Nm
aliases and builtins and is 10 to 100 times faster.
See also the
.Ic which-command
editor command.
.
.El
.Pp
.Bl -tag -width 8n -compact
.Pp
.
.It Ic while Cm \&( Ns Ar expr Ns Cm \&)
.It Ic \&...
.It Ic end
Executes the commands between the
.Ic while
and the matching
.Ic end
while
.Ar expr
(an expression, as described under
.Sx Expressions )
evaluates non-zero.
.Ic while
and
.Ic end
must appear alone on their input lines.
.Ic break
and
.Ic continue
may be used to terminate or continue the
loop prematurely.
If the input is a terminal, the user is prompted the first time
through the loop as with
.Ic foreach .
.El
.
.Ss "Special aliases (+)"
If set, each of these aliases executes automatically at the indicated time.
They are all initially undefined.
.Pp
Supported special aliases are:
.Pp
.Bl -tag -width 8n
.
.It Ic beepcmd
Runs when the shell wants to ring the terminal bell.
.
.It Ic cwdcmd
Runs after every change of working directory.
For example, if the user is
working on an X window system using
.Xr xterm 1
and a re-parenting window
manager that supports title bars such as
.Xr twm 1
and does
.Bd -literal -offset indent
> alias cwdcmd  'echo \-n "^[]2;${HOST}:$cwd ^G"'
.Ed
.Pp
then the shell will change the title of the running
.Xr xterm 1
to be the name of the host, a colon, and the full current working directory.
A fancier way to do that is
.Bd -literal -offset indent
> alias cwdcmd 'echo \-n "^[]2;${HOST}:$cwd^G^[]1;${HOST}^G"'
.Ed
.Pp
This will put the hostname and working directory on the title bar but
only the hostname in the icon manager menu.
.Pp
Note that putting a
.Ic cd ,
.Ic pushd ,
or
.Ic popd
in
.Ic cwdcmd
may cause an infinite loop.
It is the author's opinion that anyone doing
so will get what they deserve.
.
.It Ic jobcmd
Runs before each command gets executed, or when the command changes state.
This is similar to
.Ic postcmd ,
but it does not print builtins.
.Bd -literal -offset indent
> alias jobcmd  'echo \-n "^[]2\e;\e!#:q^G"'
.Ed
.Pp
then executing
.Ql vi foo.c
will put the command string in the xterm title bar.
.
.It Ic helpcommand
Invoked by the
.Ic run-help
editor command.
The command name for which help
is sought is passed as sole argument.
For example, if one does
.Bd -literal -offset indent
> alias helpcommand '\e!:1 --help'
.Ed
.Pp
then the help display of the command itself will be invoked, using the GNU
help calling convention.
Currently there is no easy way to account for various calling conventions (e.g.,
the customary Unix
.Ql -h ) ,
except by using a table of many commands.
.
.It Ic periodic
Runs every
.Ic tperiod
minutes.
This provides a convenient means for
checking on common but infrequent changes such as new mail.
For example,
if one does
.Bd -literal -offset indent
> set tperiod = 30
> alias periodic checknews
.Ed
.Pp
then the
.Xr checknews 1
program runs every 30 minutes.
If
.Ic periodic
is set but
.Ic tperiod
is unset or set to 0,
.Ic periodic
behaves like
.Ic precmd .
.
.It Ic precmd
Runs just before each prompt is printed.
For example, if one does
.Bd -literal -offset indent
> alias precmd date
.Ed
.Pp
then
.Xr date 1
runs just before the shell prompts for each command.
There are no limits on what
.Ic precmd
can be set to do, but discretion
should be used.
.
.It Ic postcmd
Runs before each command gets executed.
.Bd -literal -offset indent
> alias postcmd  'echo \-n "^[]2\e;\e!#:q^G"'
.Ed
.Pp
then executing
.Ql vi foo.c
will put the command string in the xterm title bar.
.
.It Ic shell
Specifies the interpreter for executable scripts which do not themselves
specify an interpreter.
The first word should be a full path name to the
desired interpreter (e.g.,
.Ql /bin/csh
or
.Ql /usr/local/bin/tcsh ) .
.
.El
.
.Ss "Special shell variables"
The variables described in this section have special meaning to the shell.
.Pp
The shell sets
.Ic addsuffix ,
.Ic argv ,
.Ic autologout ,
.Ic csubstnonl ,
.Ic command ,
.Ic echo_style ,
.Ic edit ,
.Ic gid ,
.Ic group ,
.Ic home ,
.Ic loginsh ,
.Ic oid ,
.Ic path ,
.Ic prompt ,
.Ic prompt2 ,
.Ic prompt3 ,
.Ic shell ,
.Ic shlvl ,
.Ic tcsh ,
.Ic term ,
.Ic tty ,
.Ic uid ,
.Ic user ,
and
.Ic version
at
startup; they do not change thereafter unless changed by the user.
The shell updates
.Ic cwd ,
.Ic dirstack ,
.Ic owd ,
and
.Ic status
when necessary,
and sets
.Ic logout
on logout.
.Pp
The shell synchronizes
.Ic group ,
.Ic home ,
.Ic path ,
.Ic shlvl ,
.Ic term ,
and
.Ic user
with the environment variables of the same names:
whenever the environment variable changes the shell changes the corresponding
shell variable to match (unless the shell variable is read-only) and vice
versa.
Note that although
.Ic cwd
and
.Ev PWD
have identical meanings, they
are not synchronized in this manner, and that the shell automatically
converts between the different formats of
.Ic path
and
.Ev PATH .
.
.Pp
Supported special shell variables are:
.
.Bl -tag -width 8n
.
.It Ic addsuffix No (+)
If set, filename completion adds
.Ql /
to the end of directories and a space
to the end of normal files when they are matched exactly.
Set by default.
.
.It Ic afsuser No (+)
If set,
.Ic autologout Ns
\&'s autolock feature uses its value instead of
the local username for kerberos authentication.
.
.It Ic ampm No (+)
If set, all times are shown in 12-hour AM/PM format.
.
.It Ic anyerror No (+)
This variable selects what is propagated to the value of the
.Ic status
variable. For more information see the description of the
.Ic status
variable below.
.
.It Ic argv
The arguments to the shell.
Positional parameters are taken from
.Ic argv ,
i.e.,
.Ql $1
is replaced by
.Ql $argv[1] ,
etc.
Set by default, but usually empty in interactive shells.
.
.It Ic autocorrect No (+)
If set, the
.Ic spell-word
editor command is invoked automatically before
each completion attempt.
.
.It Ic autoexpand No (+)
If set, the
.Ic expand-history
editor command is invoked automatically
before each completion attempt. If this is set to
.Ql onlyhistory ,
then
only history will be expanded and a second completion will expand filenames.
.
.It Ic autolist No (+)
If set, possibilities are listed after an ambiguous completion.
If set to
.Ql ambiguous ,
possibilities are listed only when no new
characters are added by completion.
.
.It Ic autologout No (+)
The first word is the number of minutes of inactivity before automatic
logout.
The optional second word is the number of minutes of inactivity
before automatic locking.
When the shell automatically logs out, it prints
.Sq auto-logout ,
sets the
variable
.Ic logout
to
.Ql automatic
and exits.
When the shell automatically locks, the user is required to enter their password
to continue working.
Five incorrect attempts result in automatic logout.
Set to
.Ql 60
(automatic logout after 60 minutes, and no locking) by default
in login and superuser shells, but not if the shell thinks it is running
under a window system (i.e., the
.Ev DISPLAY
environment variable is set),
the tty is a pseudo-tty (pty) or the shell was not so compiled (see the
.Ic version
shell variable).
Unset
.Ic autologout
or set it to
.Ql 0
to disable automatic logout.
See also the
.Ic afsuser
and
.Ic logout
shell variables.
.
.It Ic autorehash No (+)
If set, the internal hash table of the contents of the directories in the
.Ic path
variable will be recomputed if a command is not found in the hash
table.
In addition, the list of available commands will be rebuilt for each
command completion or spelling correction attempt if set to
.Ql complete
or
.Ql correct
respectively; if set to
.Ql always ,
this will be done for both
cases.
.
.It Ic backslash_quote No (+)
.\" TODO
If set, backslashes (`\e') always quote
.Ql \e ,
.Ql \&' ,
and
.Ql \&" .
This may make
complex quoting tasks easier, but it can cause syntax errors in
.Xr csh 1
scripts.
.
.It Ic catalog
The file name of the message catalog.
If set,
.Nm
uses
.Sq tcsh.${catalog}
as a message catalog instead of
default
.Sq tcsh .
.
.It Ic cdpath
A list of directories in which
.Ic cd
should search for
subdirectories if they aren't found in the current directory.
.
.It Ic cdtohome No (+)
If not set,
.Ic cd
requires a directory
.Ar name ,
and will not go to the
.Ic home
directory if it's omitted.
This is set by default.
.
.It Ic color
If set, it enables color display for the builtin
.Ic ls\-F
and it passes
.Fl \-color=auto
to
.Xr ls 1 .
Alternatively, it can be set to only
.Ic ls\-F
or only
.Ic ls
to enable color to only one command.
Setting
it to nothing is equivalent to setting it to
.Ql (ls\-F ls) .
.
.It Ic colorcat
If set, it enables color escape sequence for NLS message files.
And display colorful NLS messages.
.
.It Ic command No (+)
If set, the command which was passed to the shell with the
.Fl c
flag (q.v.).
.
.It Ic compat_expr No (+)
If set, the shell will evaluate expressions right to left, like the original
.Xr csh 1 .
.
.It Ic complete No (+)
If set to
.Ql igncase ,
the completion becomes case insensitive.
If set to
.Ql enhance ,
completion ignores case and considers
hyphens and underscores to be equivalent; it will also treat
periods, hyphens and underscores
.Po
.Ql \&. ,
.Ql \- ,
and
.Ql _
.Pc
as word
separators.
If set to
.Ql Enhance ,
completion matches uppercase and underscore
characters explicitly and matches lowercase and hyphens in a
case-insensitive manner; it will treat periods, hyphens and underscores
as word separators.
.
.It Ic continue No (+)
If set to a list of commands, the shell will continue the listed
commands, instead of starting a new one.
.
.It Ic continue_args No (+)
Same as continue, but the shell will execute:
.Bd -literal -offset indent
echo \`pwd\` $argv > ~/.<cmd>_pause; %<cmd>
.Ed
.
.It Ic correct No (+)
If set to
.Ql cmd ,
commands are automatically spelling-corrected.
If set to
.Ql complete ,
commands are automatically completed.
If set to
.Ql all ,
the entire command line is corrected.
.
.It Ic csubstnonl No (+)
If set, newlines and carriage returns in command substitution are
replaced by spaces.
Set by default.
.
.It Ic cwd
The full pathname of the current directory.
See also the
.Ic dirstack
and
.Ic owd
shell variables.
.
.It Ic dextract No (+)
If set,
.Ql pushd + Ns Ar n
extracts the
.Ar n Ns
th directory from the directory
stack rather than rotating it to the top.
.
.It Ic dirsfile No (+)
The default location in which
.Ql dirs \-S
and
.Ql dirs \-L
look for
a history file.
If unset,
.Pa ~/.cshdirs
is used.
Because only
.Pa ~/.tcshrc
is normally sourced before
.Pa ~/.cshdirs ,
.Ic dirsfile
should be set in
.Pa ~/.tcshrc
rather than
.Pa ~/.login .
.
.It Ic dirstack No (+)
An array of all the directories on the directory stack.
.Sq $dirstack[1]
is the current working directory,
.Sq $dirstack[2]
the first directory on the stack, etc.
Note that the current working directory is
.Sq $dirstack[1]
but
.Ql =0
in
directory stack substitutions, etc.
One can change the stack arbitrarily by setting
.Ic dirstack ,
but the first element (the current working directory) is always correct.
See also the
.Ic cwd
and
.Ic owd
shell variables.
.
.It Ic dspmbyte No (+)
Has an effect only if
.Ql dspm
is listed as part of the
.Ic version
shell variable.
If set to
.Ql euc ,
it enables display and editing EUC-kanji(Japanese) code.
If set to
.Ql sjis ,
it enables display and editing Shift-JIS(Japanese) code.
If set to
.Ql big5 ,
it enables display and editing Big5(Chinese) code.
If set to
.Ql utf8 ,
it enables display and editing Utf8(Unicode) code.
If set to the following format, it enables display and editing of original
multi-byte code format:
.Bd -literal -offset indent
> set dspmbyte = 0000....(256 bytes)....0000
.Ed
.Pp
The table requires
.Em just
256 bytes.
Each character of 256 characters
corresponds (from left to right) to the ASCII codes 0x00, 0x01, ... 0xff.
Each
character
.\" (position in this table?)
is set to number 0,1,2 and 3.
Each number has the following meaning:
.Bl -tag -width 3n -offset indent -compact
.It Li 0
Not used for multi-byte characters.
.It Li 1
Used for the first byte of a multi-byte character.
.It Li 2
Used for the second byte of a multi-byte character.
.It Li 3
Used for both the first byte and second byte of a multi-byte character.
.El
.\" SHK: I tried my best to get the following to be grammatically correct.
.\" However, I still don't understand what's going on here.  In the
.\" following example, there are three bytes, but the text seems to refer to
.\" each nybble as a character.  What's going on here?  It this 3-byte code
.\" in the table?  The text above seems to imply that there are 256
.\" characters/bytes in the table.  If I get some more info on this (perhaps
.\" a complete example), I could fix the text to be grammatically correct.
.\" (steve.kelem@xilinx.com 1999/09/13)
.Pp
Example:
.Pp
If set to
.Ql 001322 ,
the first character (means 0x00 of the ASCII code) and
second character (means 0x01 of ASCII code) are set to
.Ql 0 .
Then, it is not
used for multi-byte characters.
The 3rd character (0x02) is set to
.Ql 1 ,
indicating that it is used for the first byte of a multi-byte character.
The 4th character (0x03) is set
.Ql 3 .
It is used for both the first byte and
the second byte of a multi-byte character.
The 5th and 6th characters
(0x04,0x05) are set to
.Ql 2 ,
indicating that they are used for the second
byte of a multi-byte character.
.Pp
The GNU fileutils version of ls cannot display multi-byte
filenames without the
.Fl N
.Pq Fl -literal
option.
If you are using
this version, set the second word of dspmbyte to
.Ql ls .
If not, for
example,
.Ql ls-F -l
cannot display multi-byte filenames.
.Pp
Note:
.Pp
This variable can only be used if KANJI and DSPMBYTE has been defined at
compile time.
.
.It Ic dunique No (+)
If set,
.Ic pushd
removes any instances of
.Ar name
from the stack before pushing it onto the stack.
.
.It Ic echo
If set, each command with its arguments is echoed just before it is
executed.
For non-builtin commands all expansions occur before
echoing.
Builtin commands are echoed before command and filename
substitution, because these substitutions are then done selectively.
Set by the
.Fl x
command line option.
.
.It Ic echo_style No (+)
The style of the
.Ic echo
builtin.
May be set to:
.Pp
.Bl -tag -width 4n -offset indent -compact
.It Li bsd
Don't echo a newline if the first argument is
.Fl n ;
the default for
.Xr csh 1 .
.
.It Li sysv
Recognize backslashed escape sequences in echo strings.
.
.It Li both
Recognize both the
.Fl n
flag and backslashed escape sequences; the default
for
.Nm .
.
.It Li none
Recognize neither.
.El
.Pp
Set by default to the local system default.
The BSD and System V
options are described in the
.Xr echo 1
man pages on the appropriate
systems.
.
.It Ic edit No (+)
If set, the command-line editor is used.
Set by default in interactive
shells.
.
.It Ic editors No (+)
A list of command names for the
.Ic run-fg-editor
editor command to match.
If not set, the
.Ev EDITOR
.Ql ( ed
if unset) and
.Ev VISUAL
.Ql ( vi
if unset)
environment variables will be used instead.
.
.It Ic ellipsis No (+)
If set, the
.Ql %c ,
.Ql %. ,
and
.Ql \&%C
prompt sequences (see the
.Ic prompt
shell variable) indicate skipped directories with an ellipsis
.Pq Ql \&...
instead of
.Ql /< Ns Ar skipped Ns Li > .
.
.It Ic euid No (+)
The user's effective user ID.
.
.It Ic euser No (+)
The first matching passwd entry name corresponding to the effective user ID.
.
.It Ic fignore No (+)
Lists file name suffixes to be ignored by completion.
.
.It Ic filec
In
.Nm ,
completion is always used and this variable is ignored
by default. If
.Ic edit
is unset, then the traditional
.Xr csh 1
completion is used.
If set in
.Xr csh 1 ,
filename completion is used.
.
.It Ic gid No (+)
The user's real group ID.
.
.It Ic globdot No (+)
If set, wild-card glob patterns will match files and directories beginning
with
.Ql \&.
except for
.Sq Pa \&.
and
.Sq Pa \&.. .
.
.It Ic globstar No (+)
If set, the
.Ql **
and
.Ql ***
file glob patterns will match any string of
characters including
.Ql /
traversing any existing sub-directories.
(e.g.
.Ql ls **.c
will list all the .c files in the current directory tree).
If used by itself, it will match zero or more sub-directories
(e.g.
.Ql ls /usr/include/**/time.h
will list any file named
.Ql time.h
in the
.Pa /usr/include
directory tree; whereas
.Ql ls /usr/include/**time.h
will match any file in the
.Pa /usr/include
directory tree ending in
.Ql time.h ) .
To prevent problems with recursion, the
.Ql **
glob-pattern will not
descend into a symbolic link containing a directory.
To override this,
use
.Ql *** .
.
.It Ic group No (+)
The user's group name.
.
.It Ic highlight
If set, the incremental search match (in
.Ic i-search-back
and
.Ic i-search-fwd )
and the region between the mark and the cursor are
highlighted in reverse video.
.Pp
Highlighting requires more frequent terminal writes, which introduces extra
overhead. If you care about terminal performance, you may want to leave this
unset.
.
.It Ic histchars
A string value determining the characters used in
.Sx History substitution
(q.v.).
The first character of its value is used as
the history substitution character, replacing the default character
.Ql \&! .
The second character of its value replaces the character
.Ql ^
in
quick substitutions.
.
.It Ic histdup No (+)
Controls handling of duplicate entries in the history list.
If set to
.Ql all
only unique history events are entered in the history list.
If
set to
.Ql prev
and the last history event is the same as the current
command, then the current command is not entered in the history.
If
set to
.Ql erase
and the same event is found in the history list, that
old event gets erased and the current one gets inserted.
Note that the
.Ql prev
and
.Ql all
options renumber history events so there are no gaps.
.
.It Ic histfile No (+)
The default location in which
.Ql history \-S
and
.Ql history \-L
look for
a history file.
If unset,
.Pa ~/.history
is used.
.Ic histfile
is
useful when sharing the same home directory between different machines,
or when saving separate histories on different terminals.
Because only
.Pa ~/.tcshrc
is normally sourced before
.Pa ~/.history ,
.Ic histfile
should be set in
.Pa ~/.tcshrc
rather than
.Pa ~/.login .
.
.It Ic histlit No (+)
If set, builtin and editor commands and the
.Ic savehist
mechanism
use the literal (unexpanded) form of lines in the history list.
See
also the
.Ic toggle-literal-history
editor command.
.
.It Ic history
The first word indicates the number of history events to save.
The
optional second word (+) indicates the format in which history is
printed; if not given,
.Ql %h\et%T\et%R\en
is used.
The format sequences
are described below under
.Ic prompt ;
note the variable meaning of
.Ql \&%R .
Set to
.Ql 100
by default.
.
.It Ic home
Initialized to the home directory of the invoker.
The filename
expansion of
.Ql ~
refers to this variable.
.
.It Ic ignoreeof
If set to the empty string or
.Ql 0
and the input device is a terminal,
the
.Ic end-of-file
command (usually generated by the user by typing
.Sq ^D
on an empty line) causes the shell to print
.Ql Use \&"exit\&" to leave tcsh.
instead of exiting.
This prevents the shell from accidentally
being killed.
Historically this setting exited after 26 successive
EOF's to avoid infinite loops.
If set to a number
.Sq Em n ,
the shell
ignores
.Em n
\- 1
consecutive
.Ic end-of-file Ns
s and exits on the
.Em n Ns
th.
(+) If unset,
.Ql 1
is used, i.e., the shell exits on a
single
.Sq ^D .
.
.It Ic implicitcd No (+)
If set, the shell treats a directory name typed as a command as though
it were a request to change to that directory.
If set to
.Ic verbose ,
the change of directory is echoed to the standard output.
This behavior
is inhibited in non-interactive shell scripts, or for command strings
with more than one word.
Changing directory takes precedence over
executing a like-named command, but it is done after alias
substitutions.
Tilde and variable expansions work as expected.
.
.It Ic inputmode No (+)
If set to
.Ql insert
or
.Ql overwrite ,
puts the editor into that input mode
at the beginning of each line.
.
.It Ic killdup No (+)
Controls handling of duplicate entries in the kill ring.
If set to
.Ql all
only unique strings are entered in the kill ring.
If set to
.Ql prev
and the last killed string is the same as the current killed
string, then the current string is not entered in the ring.
If set
to
.Ql erase
and the same string is found in the kill ring, the old
string is erased and the current one is inserted.
.
.It Ic killring No (+)
Indicates the number of killed strings to keep in memory.
Set to
.Ql 30
by default.
If unset or set to less than
.Ql 2 ,
the shell will only
keep the most recently killed string.
Strings are put in the killring by the editor commands that delete
(kill) strings of text, e.g.
.Ic backward-delete-word ,
.Ic kill-line ,
etc, as well as the
.Ic copy-region-as-kill
command.
The
.Ic yank
editor command will yank the most recently killed string
into the command-line, while
.Ic yank-pop
(see
.Sx Editor commands )
can be used to yank earlier killed strings.
.
.It Ic listflags No (+)
If set to
.Ql x ,
.Ql a ,
or
.Ql A ,
or any combination thereof (e.g.,
.Ql xA ) ,
they are used as flags to
.Ic ls\-F ,
making it act like
.Ql ls \-xF ,
.Ql ls \-Fa ,
.Ql ls \-FA ,
or a combination (e.g.,
.Ql ls \-FxA ) :
.Ql a
shows all
files (even if they start with a
.Ql \&. ) ,
.Ql A
shows all files but
.Ql \&.
and
.Ql \&.. ,
and
.Ql x
sorts across instead of down.
If the second word of
.Ic listflags
is set, it is used as the path to
.Xr ls 1 .
.
.It Ic listjobs No (+)
If set, all jobs are listed when a job is suspended.
If set to
.Ql long ,
the listing is in long format.
.
.It Ic listlinks No (+)
If set, the
.Ic ls\-F
builtin command shows the type of file to which
each symbolic link points.
.
.It Ic listmax No (+)
The maximum number of items which the
.Ic list-choices
editor command
will list without asking first.
.
.It Ic listmaxrows No (+)
The maximum number of rows of items which the
.Ic list-choices
editor
command will list without asking first.
.
.It Ic loginsh No (+)
Set by the shell if it is a login shell.
Setting or unsetting it
within a shell has no effect.
See also
.Ic shlvl .
.
.It Ic logout No (+)
Set by the shell to
.Ql normal
before a normal logout,
.Ql automatic
before
an automatic logout, and
.Ql hangup
if the shell was killed by a hangup
signal (see
.Sx Signal handling ) .
See also the
.Ic autologout
shell variable.
.
.It Ic mail
A list of files and directories to check for incoming mail, optionally
preceded by a numeric word.
Before each prompt, if 10 minutes have
passed since the last check, the shell checks each file and displays
.Sq You have new mail.
(or, if
.Ic mail
contains multiple files,
.Sq You have new mail in Ar name Ns \&. )
if the filesize is greater than zero in size
and has a modification time greater than its access time.
.Pp
If you are in a login shell, then no mail file is reported unless it has
been modified after the time the shell has started up, to prevent
redundant notifications.
Most login programs will tell you whether or not
you have mail when you log in.
.Pp
If a file specified in
.Ic mail
is a directory, the shell will count each
file within that directory as a separate message, and will report
.Sq You have Ar n No mails.
or
.Sq You have Ar n No mails in Ar name Ns No \&.
as appropriate.
This functionality is provided primarily for those systems which store mail
in this manner, such as the Andrew Mail System.
.Pp
If the first word of
.Ic mail
is numeric it is taken as a different mail
checking interval, in seconds.
.Pp
Under very rare circumstances, the shell may report
.Sq You have mail.
instead
of
.Sq You have new mail.
.
.It Ic matchbeep No (+)
If set to
.Ql never ,
completion never beeps.
If set to
.Ql nomatch ,
it beeps only when there is no match.
If set to
.Ql ambiguous ,
it beeps when there are multiple matches.
If set to
.Ql notunique ,
it beeps when there is one exact and other longer matches.
If unset,
.Ql ambiguous
is used.
.
.It Ic nobeep No (+)
If set, beeping is completely disabled.
See also
.Ic visiblebell .
.
.It Ic noclobber
If set, restrictions are placed on output redirection to insure that files
are not accidentally destroyed and that
.Ql >>
redirections refer to existing
files, as described in the
.Sx Input/output
section.
If contains
.Ql ask ,
an interacive confirmation is presented, rather than an
error.
If contains
.Ql notempty ,
.Ql >
is allowed on empty files.
.
.It Ic noding
If set, disable the printing of
.Ql DING!
in the
.Ic prompt
time
specifiers at the change of hour.
.
.It Ic noglob
If set,
.Sx Filename substitution
and
.Sx Directory stack substitution
(q.v.) are inhibited.
This is most useful in shell scripts which do not deal
with filenames, or after a list of filenames has been obtained and further
expansions are not desirable.
.
.It Ic nokanji No (+)
If set and the shell supports Kanji (see the
.Ic version
shell variable),
it is disabled so that the meta key can be used.
.
.It Ic nonomatch
If set, a
.Sx Filename substitution
or
.Sx Directory stack substitution
(q.v.) which does not match any
existing files is left untouched rather than causing an error.
It is still an error for the substitution to be
malformed, e.g.,
.Ql echo [
still gives an error.
.
.It Ic nostat No (+)
A list of directories (or glob-patterns which match directories; see
.Sx Filename substitution )
that should not be
.Xr stat 2 Ns ed
during a
completion operation.
This is usually used to exclude directories which
take too much time to
.Xr stat 2 ,
for example
.Pa /afs .
.
.It Ic notify
If set, the shell announces job completions asynchronously.
The default is to present job completions just before printing a prompt.
.
.It Ic oid No (+)
The user's real organization ID.
(Domain/OS only)
.
.It Ic owd No (+)
The old working directory, equivalent to the
.Ql \-
used by
.Ic cd
and
.Ic pushd .
See also the
.Ic cwd
and
.Ic dirstack
shell variables.
.
.It Ic padhour
If set, enable the printing of padding '0' for hours, in 24 and 12 hour
formats.
E.g.,
.Sq 07:45:42
versus
.Sq 7:45:42 .
.
.It Ic parseoctal
To retain compatibily with older versions numeric variables starting with
0 are not interpreted as octal. Setting this variable enables proper octal
parsing.
.
.It Ic path
A list of directories in which to look for executable commands.
A null word specifies the current directory.
If there is no
.Ic path
variable then only full path names will execute.
.Ic path
is set by the shell at startup from the
.Ev PATH
environment
variable or, if
.Ev PATH
does not exist, to a system-dependent default
something like
.Ql (/usr/local/bin /usr/bsd /bin /usr/bin .) .
The shell may put
.Ql \&.
first or last in
.Ic path
or omit it entirely
depending on how it was compiled; see the
.Ic version
shell variable.
A shell which is given neither the
.Fl c
nor the
.Fl t
option
hashes the contents of the directories in
.Ic path
after
reading
.Pa ~/.tcshrc
and each time
.Ic path
is reset.
If one adds a new command to a directory in
.Ic path
while the shell
is active, one may need to do a
.Ic rehash
for the shell to find it.
.
.It Ic printexitvalue No (+)
If set and an interactive program exits with a non-zero status, the shell
prints
.Sq Exit Ar status .
.
.It Ic prompt
The string which is printed before reading each command from the terminal.
.Pp
.Ic prompt
may include any of the following formatting sequences (+), which
are replaced by the given information:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li %/
The current working directory.
.
.It Li %~
The current working directory, but with one's home directory
represented by
.Ql ~
and other users' home directories represented by
.Ql ~ Ns Ar user
as per
.Sx Filename substitution .
.Ql ~ Ns Ar user
substitution
happens only if the shell has already used
.Ql ~ Ns Ar user
in a pathname
in the current session.
.
.It Xo
.Li %c[[0] Ns Ar n Ns Li ] ,
.Li %.[[0] Ns Ar n Ns Li ]
.Xc
The trailing component of the current working directory, or
.Ar n
trailing components if a digit
.Ar n
is given.
If
.Ar n
begins with
.Ql 0 ,
the number of skipped components precede
the trailing component(s) in the format
.Ql /< Ns Ar skipped Ns Li >trailing .
If the
.Ic ellipsis
shell variable is set, skipped components
are represented by an ellipsis so the whole becomes
.Ql \&...trailing .
.Ql ~
substitution is done as in
.Ql %~
above, but the
.Ql ~
component
is ignored when counting trailing components.
.
.It Li \&%C
Like
.Ql %c ,
but without
.Ql ~
substitution.
.
.It Li %h , %! , \&!
The current history event number.
.
.It Li \&%M
The full hostname.
.
.It Li %m
The hostname up to the first
.Ql \&. .
.
.It Li \&%S Pq Li %s
Start (stop) standout mode.
.
.It Li \&%B Pq Li %b
Start (stop) boldfacing mode.
.
.It Li \&%U (%u)
Start (stop) underline mode.
.
.It Li %t , %@
The time of day in 12-hour AM/PM format.
.
.It Li \&%T
Like
.Ql %t ,
but in 24-hour format (but see the
.Ic ampm
shell variable).
.
.It Li %p
The
.Sq precise
time of day in 12-hour AM/PM format, with seconds.
.
.It Li \&%P
Like
.Ql %p ,
but in 24-hour format (but see the
.Ic ampm
shell variable).
.
.It Li \e Ns Ar c
.Ar c
is parsed as in
.Ic bindkey .
.
.It Li ^ Ns Ar c
.Ar c
is parsed as in
.Ic bindkey .
.
.It Li %%
A single
.Ql % .
.
.It Li %n
The user name.
.
.It Li \&%N
The effective user name.
.
.It Li %j
The number of jobs.
.
.It Li %d
The weekday in
.Sq Day
format.
.
.It Li \&%D
The day in
.Sq dd
format.
.
.It Li %w
The month in
.Sq Mon
format.
.
.It Li \&%W
The month in
.Sq mm
format.
.
.It Li %y
The year in
.Sq yy
format.
.
.It Li \&%Y
The year in
.Sq yyyy
format.
.
.It Li %l
The shell's tty.
.
.It Li \&%L
Clears from the end of the prompt to end of the display or the end of the line.
.
.It Li %$
Expands the shell or environment variable name immediately after the
.Ql $ .
.
.It Li %#
.Ql >
(or the first character of the
.Ic promptchars
shell variable)
for normal users,
.Ql #
(or the second character of
.Ic promptchars )
for the superuser.
.
.It Li %{ Ns Ar string Ns Li %}
Includes
.Ic string
as a literal escape sequence.
It should be used only to change terminal attributes and
should not move the cursor location.
This
cannot be the last sequence in
.Ic prompt .
.
.It Li %?
The return code of the command executed just before the prompt.
.
.It Li \&%R
In
.Ic prompt2 ,
the status of the parser.
In
.Ic prompt3 ,
the corrected string.
In
.Ic history ,
the history string.
.
.El
.
.Pp
.Ql \&%B ,
.Ql \&%S ,
.Ql \&%U ,
and
.Ql %{ Ns Ar string Ns Li %}
are available in only
eight-bit-clean shells; see the
.Ic version
shell variable.
.Pp
The bold, standout and underline sequences are often used to distinguish a
superuser shell.
For example,
.Pp
.\" Using Bl not Bd to allow bold formatting in the second line
.Bl -tag -offset indent -compact
.It Li > set prompt = \&"%m [%h] \&%B[%@]%b [%/] you rang? \&"
.It Li tut [37] Cm [2:54pm] Li [/usr/accts/sys] you rang? _
.El
.Pp
If
.Ql %t ,
.Ql %@ ,
.Ql \&%T ,
.Ql %p ,
or
.Ql \&%P
is used, and
.Ic noding
is not set,
then print
.Sq DING!
on the change of hour (i.e,
.Sq \&:00
minutes) instead of
the actual time.
.Pp
Set by default to
.Ql %#\ \&
in interactive shells.
.
.It Ic prompt2 No (+)
The string with which to prompt in
.Ic while
and
.Ic foreach
loops and
after lines ending in
.Ql \e .
The same format sequences may be used as in
.Ic prompt
(q.v.);
note the variable meaning of
.Ql \&%R .
Set by default to
.Ql \&%R?\ \&
in interactive shells.
.
.It Ic prompt3 No (+)
The string with which to prompt when confirming automatic spelling correction.
The same format sequences may be used as in
.Ic prompt
(q.v.);
note the variable meaning of
.Ql \&%R .
Set by default to
.Ql CORRECT>%R (y|n|e|a)?\ \&
in interactive shells.
.
.It Ic promptchars No (+)
If set (to a two-character string), the
.Ql %#
formatting sequence in the
.Ic prompt
shell variable is replaced with the first character for
normal users and the second character for the superuser.
.
.It Ic pushdtohome No (+)
If set,
.Ic pushd
without arguments does
.Ql pushd ~ ,
like
.Ic cd .
.
.It Ic pushdsilent No (+)
If set,
.Ic pushd
and
.Ic popd
do not print the directory stack.
.
.It Ic recexact No (+)
If set, completion completes on an exact match even if a longer match is
possible.
.
.It Ic recognize_only_executables No (+)
If set, command listing displays only files in the path that are
executable.
Slow.
.
.It Ic rmstar No (+)
If set, the user is prompted before
.Ql rm *
is executed.
.
.It Ic rprompt No (+)
The string to print on the right-hand side of the screen (after
the command input) when the prompt is being displayed on the left.
It recognizes the same formatting characters as
.Ic prompt .
It will automatically disappear and reappear as necessary, to ensure that
command input isn't obscured, and will appear only if the prompt,
command input, and itself will fit together on the first line.
If
.Ic edit
isn't set, then
.Ic rprompt
will be printed after
the prompt and before the command input.
.
.It Ic savedirs No (+)
If set, the shell does
.Ql dirs \-S
before exiting.
If the first word is set to a number, at most that many directory stack
entries are saved.
.
.It Ic savehist
If set, the shell does
.Ql history \-S
before exiting.
If the first word is set to a number, at most that many lines are saved.
(The number should be less than or equal to the number
.Ic history
entries;
if it is set to greater than the number of
.Ic history
settings, only
.Ic history
entries will be saved.)
If the second word is set to
.Ql merge ,
the history list is merged with
the existing history file instead of replacing it (if there is one) and
sorted by time stamp and the most recent events are retained.
If the second word of
.Ic savehist
is
.Ql merge
and the third word is set to
.Ql lock ,
the history file update will be serialized with other shell sessions
that would possibly like to merge history at exactly the same time. (+)
.
.It Ic sched No (+)
The format in which the
.Ic sched
builtin command prints scheduled events;
if not given,
.Ql %h\et%T\et%R\en
is used.
The format sequences are described above under
.Ic prompt ;
note the variable meaning of
.Ql \&%R .
.
.It Ic shell
The file in which the shell resides.
This is used in forking
shells to interpret files which have execute bits set, but
which are not executable by the system.
(See the description
of
.Sx "Builtin and non-builtin command execution" . )
Initialized to the
(system-dependent) home of the shell.
.
.It Ic shlvl No (+)
The number of nested shells.
Reset to 1 in login shells.
See also
.Ic loginsh .
.
.It Ic status
The exit status from the last command or backquote expansion, or any
command in a pipeline is propagated to
.Ic status .
(This is also the
default
.Xr csh 1
behavior.)
This default does not match what POSIX mandates (to return the
status of the last command only). To match the POSIX behavior, you need
to unset
.Ic anyerror .
.Pp
If the
.Ic anyerror
variable is unset, the exit status of a pipeline
is determined only from the last command in the pipeline, and the exit
status of a backquote expansion is
.Em not
propagated to
.Ic status .
.Pp
If a command terminated abnormally, then 0200 is added to the status.
Builtin commands which fail return exit status
.Ql 1 ,
all other builtin
commands return status
.Ql 0 .
.
.It Ic symlinks No (+)
Can be set to several different values to control symbolic link
.Pq Sq symlink
resolution:
.Pp
If set to
.Ql chase ,
whenever the current directory changes to a directory
containing a symbolic link, it is expanded to the real name of the directory
to which the link points.
This does not work for the user's home directory;
this is a bug.
.Pp
If set to
.Ql ignore ,
the shell tries to construct a current directory
relative to the current directory before the link was crossed.
This means that
.Ic cd Ns
ing through a symbolic link and then
.Ql cd \&.. Ns
ing
returns one to the original directory.
This affects only builtin commands
and filename completion.
.Pp
If set to
.Ql expand ,
the shell tries to fix symbolic links by actually expanding
arguments which look like path names.
This affects any command, not just
builtins.
Unfortunately, this does not work for hard-to-recognize filenames,
such as those embedded in command options.
Expansion may be prevented by
quoting.
While this setting is usually the most convenient, it is sometimes
misleading and sometimes confusing when it fails to recognize an argument
which should be expanded.
A compromise is to use
.Ql ignore
and use the
editor command
.Ic normalize-path
(bound by default to
.Sq ^X-n )
when necessary.
.Pp
Some examples are in order.
First, let's set up some play directories:
.Bd -literal -offset indent
> cd /tmp
> mkdir from from/src to
> ln \-s from/src to/dst
.Ed
.Pp
Here's the behavior with
.Ic symlinks
unset,
.Bd -literal -offset indent
> cd /tmp/to/dst; echo $cwd
/tmp/to/dst
> cd ..; echo $cwd
/tmp/from
.Ed
.Pp
here's the behavior with
.Ic symlinks
set to
.Ql chase ,
.Bd -literal -offset indent
> cd /tmp/to/dst; echo $cwd
/tmp/from/src
> cd ..; echo $cwd
/tmp/from
.Ed
.Pp
here's the behavior with
.Ic symlinks
set to
.Ql ignore ,
.Bd -literal -offset indent
> cd /tmp/to/dst; echo $cwd
/tmp/to/dst
> cd ..; echo $cwd
/tmp/to
.Ed
.Pp
and here's the behavior with
.Ic symlinks
set to
.Ql expand .
.Bd -literal -offset indent
> cd /tmp/to/dst; echo $cwd
/tmp/to/dst
> cd ..; echo $cwd
/tmp/to
> cd /tmp/to/dst; echo $cwd
/tmp/to/dst
> cd ".."; echo $cwd
/tmp/from
> /bin/echo ..
/tmp/to
> /bin/echo ".."
\&..
.Ed
.Pp
Note that
.Ql expand
expansion 1) works just like
.Ql ignore
for builtins
like
.Ic cd ,
2) is prevented by quoting, and 3) happens before
filenames are passed to non-builtin commands.
.
.It Ic tcsh No (+)
The version number of the shell in the format
.Sq Ar R Ns No \&. Ns Ar VV Ns No \&. Ns Ar PP ,
where
.Sq Ar R
is the major release number,
.Sq Ar VV
the current version,
and
.Sq Ar PP
the patchlevel.
.
.It Ic term
The terminal type.
Usually set in
.Pa ~/.login
as described under
.Sx Startup and shutdown .
.
.It Ic time
If set to a number, then the
.Ic time
builtin (q.v.) executes automatically
after each command which takes more than that many CPU seconds.
If there is a second word, it is used as a format string for the output
of the
.Ic time
builtin.
.Pp
(u) The following sequences may be used in the
.Ic time
format string:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li \&%U
The time the process spent in user mode in cpu seconds.
.
.It Li \&%S
The time the process spent in kernel mode in cpu seconds.
.
.It Li \&%E
The elapsed (wall clock) time in seconds.
.
.It Li \&%P
The CPU percentage computed as (\&%U + \&%S) / \&%E.
.
.It Li \&%W
Number of times the process was swapped.
.
.It Li \&%X
The average amount in (shared) text space used in Kbytes.
.
.It Li \&%D
The average amount in (unshared) data/stack space used in Kbytes.
.
.It Li \&%K
The total space used (\&%X + \&%D) in Kbytes.
.
.It Li \&%M
The maximum memory the process had in use at any time in Kbytes.
.
.It Li \&%F
The number of major page faults (page needed to be brought from disk).
.
.It Li \&%R
The number of minor page faults.
.
.It Li \&%I
The number of input operations.
.
.It Li \&%O
The number of output operations.
.
.It Li %r
The number of socket messages received.
.
.It Li %s
The number of socket messages sent.
.
.It Li %k
The number of signals received.
.
.It Li %w
The number of voluntary context switches (waits).
.
.It Li %c
The number of involuntary context switches.
.
.El
.Pp
Only the first four sequences are supported on systems without BSD resource
limit functions.
The default time format is
.Ql \&%Uu \&%Ss \&%E \&%P \&%X+%Dk \&%I+%Oio \&%Fpf+%Ww
for
systems that support resource usage reporting and
.Ql \&%Uu \&%Ss \&%E \&%P
for
systems that do not.
.Pp
Under Sequent's DYNIX/ptx,
.Ql \&%X ,
.Ql \&%D ,
.Ql \&%K ,
.Ql %r ,
and
.Ql %s
are not
available, but the following additional sequences are:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li \&%Y
The number of system calls performed.
.
.It Li \&%Z
The number of pages which are zero-filled on demand.
.
.It Li %i
The number of times a process's resident set size was increased by the kernel.
.
.It Li %d
The number of times a process's resident set size was decreased by the kernel.
.
.It Li %l
The number of read system calls performed.
.
.It Li %m
The number of write system calls performed.
.
.It Li %p
The number of reads from raw disk devices.
.
.It Li %q
The number of writes to raw disk devices.
.
.El
.Pp
and the default time format is
.Ql \&%Uu \&%Ss \&%E \&%P \&%I+%Oio \&%Fpf+%Ww .
Note that the CPU percentage can be higher than 100% on multi-processors.
.
.It Ic  tperiod No (+)
The period, in minutes, between executions of the
.Ic periodic
special alias.
.
.It Ic tty No (+)
The name of the tty, or empty if not attached to one.
.
.It Ic uid No (+)
The user's real user ID.
.
.It Ic user
The user's login name.
.
.It Ic verbose
If set, causes the words of each
command to be printed, after history substitution (if any).
Set by the
.Fl v
command line option.
.
.It Ic version No (+)
The version ID stamp.
It contains the shell's version number (see
.Ic tcsh ) ,
origin, release date, vendor, operating system and machine (see
.Ev VENDOR ,
.Ev OSTYPE ,
and
.Ev MACHTYPE )
and a comma-separated
list of options which were set at compile time.
Options which are set by default in the distribution are noted.
.Pp
Supported
.Ic version
options include:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li 8b
The shell is eight bit clean; default.
.
.It Li 7b
The shell is not eight bit clean.
.
.It Li wide
The shell is multibyte encoding clean (like UTF-8).
.
.It Li nls
The system's NLS is used; default for systems with NLS.
.
.It Li lf
Login shells execute
.Pa /etc/csh.login
before instead of after
.Pa /etc/csh.cshrc
and
.Pa ~/.login
before instead of after
.Pa ~/.tcshrc
and
.Pa ~/.history .
.
.It Li dl
.Ql \&.
is put last in
.Ic path
for security; default.
.
.It Li nd
.Ql \&.
is omitted from
.Ic path
for security.
.
.It Li vi
.Xr vi 1 Ns
\-style editing is the default rather than
.Xr emacs 1 Ns
\-style.
.
.It Li dtr
Login shells drop DTR when exiting.
.
.It Li bye
.Ic bye
is a synonym for
.Ic logout
and
.Ic log
is an alternate name for
.Ic watchlog .
.
.It Li al
.Ic autologout
is enabled; default.
.
.It Li kan
Kanji is used if appropriate according to locale settings,
unless the
.Ic nokanji
shell variable is set.
.
.It Li sm
The system's
.Xr malloc 3
is used.
.
.It Li hb
The
.Ql #!<program> <args>
convention is emulated when executing shell scripts.
.
.It Li ng
The
.Ic newgrp
builtin is available.
.
.It Li rh
The shell attempts to set the
.Ev REMOTEHOST
environment variable.
.
.It Li afs
The shell verifies your password with the kerberos server if local
authentication fails.
The
.Ic afsuser
shell variable or the
.Ev AFSUSER
environment variable override your local username if set.
.
.El
.Pp
An administrator may enter additional strings to indicate differences
in the local version.
.
.It Ic vimode No (+)
If unset, various key bindings change behavior to be more
.Xr emacs 1 Ns
\-style:
word boundaries are determined by
.Ic wordchars
versus other characters.
.Pp
If set, various key bindings change behavior to be more
.Xr vi 1 Ns
\-style:
word boundaries are determined by
.Ic wordchars
versus whitespace
versus other characters;
cursor behavior depends upon current vi mode (command, delete, insert, replace).
.Pp
This variable is unset by
.Ic bindkey Fl e
and
set by
.Ic bindkey Fl v .
.Ic vimode
may be explicitly set or unset by the user after those
.Ic bindkey
operations if required.
.
.It Ic visiblebell No (+)
If set, a screen flash is used rather than the audible bell.
See also
.Ic nobeep .
.
.It Ic watch No (+)
A list of user/terminal pairs to watch for logins and logouts.
If either the user is
.Ql any
all terminals are watched for the given user
and vice versa.
Setting
.Ic watch
to
.Ql (any any)
watches all users and terminals.
For example,
.Bd -literal -offset indent
set watch = (george ttyd1 any console $user any)
.Ed
.Pp
reports activity of the user
.Ql george
on
.Ql ttyd1 ,
any user on the console, and
oneself (or a trespasser) on any terminal.
.Pp
Logins and logouts are checked every 10 minutes by default, but the first
word of
.Ic watch
can be set to a number to check every so many minutes.
For example,
.Bd -literal -offset indent
set watch = (1 any any)
.Ed
.Pp
reports any login/logout once every minute.
For the impatient, the
.Ic log
builtin command triggers a
.Ic watch
report at any time.
All current logins
are reported (as with the
.Ic log
builtin) when
.Ic watch
is first set.
.Pp
The
.Ic who
shell variable controls the format of
.Ic watch
reports.
.
.It Ic who No (+)
The format string for
.Ic watch
messages.
The following sequences
are replaced by the given information:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li %n
The name of the user who logged in/out.
.
.It Li %a
The observed action, i.e.,
.Sq logged on ,
.Sq logged off ,
or
.Sq replaced Ar olduser No on .
.
.It Li %l
The terminal (tty) on which the user logged in/out.
.
.It Li \&%M
The full hostname of the remote host, or
.Sq local
if the login/logout was
from the local host.
.
.It Li %m
The hostname of the remote host up to the first
.Sq \&. .
The full name is printed if it is an IP address or an X Window System display.
.
.El
.Pp
.Ql \&%M
and
.Ql %m
are available on only systems that store the remote hostname in
.Pa /etc/utmp .
If unset,
.Ql %n has %a %l from %m.
is used, or
.Ql %n has %a %l.
on systems
which don't store the remote hostname.
.
.It Ic wordchars No (+)
A list of non-alphanumeric characters to be considered part of a word by the
.Ic forward-word ,
.Ic backward-word ,
etc., editor commands.
If unset, the default value is determined based on the state of
.Ic vimode :
if
.Ic vimode
is unset,
.Ql *?_\-.[]~=
is used as the default;
if
.Ic vimode
is set,
.Ql _
is used as the default.
.
.El
.
.Sh ENVIRONMENT
.Bl -tag -width 8n
.
.It Ev AFSUSER No (+)
Equivalent to the
.Ic afsuser
shell variable.
.
.It Ev COMMAND_LINE
Set by
.Nm
to the current command line when invoking programs
for the
.Ic complete
.Ar list
mode
.Ql \`...\` .
See
.Ic complete
in
.Sq Builtin commands .
.
.It Ev COLUMNS
The number of columns in the terminal.
See
.Sx Terminal management .
.
.It Ev DISPLAY
Used by X Window System (see
.Xr X 1 ) .
If set, the shell does not set
.Ic autologout
(q.v.).
.
.It Ev EDITOR
The pathname to a default editor.
Used by the
.Ic run-fg-editor
editor command if the
the
.Ic editors
shell variable is unset.
See also the
.Ev VISUAL
environment variable.
.
.It Ev GROUP No (+)
Equivalent to the
.Ic group
shell variable.
.
.It Ev HOME
Equivalent to the
.Ic home
shell variable.
.
.It Ev HOST No (+)
Initialized to the name of the machine on which the shell
is running, as determined by the
.Xr gethostname 2
system call.
.
.It Ev HOSTTYPE No (+)
Initialized to the type of machine on which the shell
is running, as determined at compile time.
This variable is obsolete and
will be removed in a future version.
.
.It Ev HPATH No (+)
A colon-separated list of directories in which the
.Ic run-help
editor
command looks for command documentation.
.
.It Ev LANG
Gives the preferred character environment.
See
.Sx Native Language System support .
.
.It Ev LC_CTYPE
If set, only ctype character handling is changed.
See
.Sx Native Language System support .
.
.It Ev LINES
The number of lines in the terminal.
See
.Sx Terminal management .
.
.It Ev LS_COLORS
The format of this variable is reminiscent of the
.Xr termcap 5
file format; a colon-separated list of expressions of the form
.Li \&" Ns Ar xx Ns Li = Ns Ar string Ns Li \&" ,
where
.Li \&" Ns Ar xx Ns Li \&"
is a two-character variable name.
.Pp
The
variables with their associated defaults are:
.Pp
.Bl -column -offset indent "Li XX" "Li XXXXX" 20n
.
.It Li no Ta Li 0 Ta Normal (non-filename) text.
.
.It Li fi Ta Li 0 Ta Regular file.
.
.It Li di Ta Li 01;34 Ta Directory.
.
.It Li ln Ta Li 01;36 Ta Symbolic link.
.
.It Li pi Ta Li 33 Ta Named pipe (FIFO).
.
.It Li so Ta Li 01;35 Ta Socket.
.
.It Li do Ta Li 01;35 Ta Door.
.
.It Li bd Ta Li 01;33 Ta Block device.
.
.It Li cd Ta Li 01;32 Ta Character device.
.
.It Li ex Ta Li 01;32 Ta Executable file.
.
.It Li mi Ta (none) Ta Missing file (defaults to Li fi Ns ) .
.
.It Li or Ta (none) Ta Orphaned symbolic link (defaults to Li ln Ns ) .
.
.It Li lc Ta Li ^[[ Ta Left code.
.
.It Li rc Ta Li m Ta Right code.
.
.It Li ec Ta (none) Ta End code (replaces Li lc Ns + Ns Li no Ns + Ns Li rc Ns ) .
.
.El
.Pp
You need to include only the variables you want to change from
the default.
.Pp
File names can also be colorized based on filename extension.
This is specified in the
.Ev LS_COLORS
variable using the syntax
.Li \&"* Ns Ar ext Ns Li = Ns Ar string Ns Li \&" .
For example, using ISO 6429 codes, to color
all C\-language source files blue you would specify
.Li \&"*.c=34\&" .
This would color all files ending in
.Ql .c
in blue (34) color.
.Pp
Control characters can be written either in C\-style\-escaped
notation, or in stty\-like ^\-notation.
The C\-style notation
adds
.Ql ^[
for Escape,
.Ql \_
for a normal space character,
and
.Ql \&?
for Delete.
In addition, the
.Ql ^[
escape character
can be used to override the default interpretation of
.Ql ^[ ,
.Ql ^ ,
.Ql \&: ,
and
.Ql = .
.Pp
Each file will be written as
.Ql <lc> <color-code> <rc> <filename> <ec> .
If the
.Ql <ec>
code is undefined, the sequence
.Ql <lc> <no> <rc>
will be used instead.
This is generally more convenient
to use, but less general.
The left, right and end codes are
provided so you don't have to type common parts over and over
again and to support weird terminals; you will generally not
need to change them at all unless your terminal does not use
ISO 6429 color sequences but a different system.
.Pp
If your terminal does use ISO 6429 color codes, you can
compose the type codes (i.e., all except the
.Ql lc ,
.Ql rc ,
and
.Ql ec
codes) from numerical commands separated by semicolons.
.Pp
The
most common commands are:
.Pp
.Bl -tag -width 4n -offset indent -compact
.
.It Li 0
To restore default color.
.
.It Li 1
For brighter colors.
.
.It Li 4
For underlined text.
.
.It Li 5
For flashing text.
.
.It Li 30
For black foreground.
.
.It Li 31
For red foreground.
.
.It Li 32
For green foreground.
.
.It Li 33
For yellow (or brown) foreground.
.
.It Li 34
For blue foreground.
.
.It Li 35
For purple foreground.
.
.It Li 36
For cyan foreground.
.
.It Li 37
For white (or gray) foreground.
.
.It Li 40
For black background.
.
.It Li 41
For red background.
.
.It Li 42
For green background.
.
.It Li 43
For yellow (or brown) background.
.
.It Li 44
For blue background.
.
.It Li 45
For purple background.
.
.It Li 46
For cyan background.
.
.It Li 47
For white (or gray) background.
.
.El
.Pp
Not all commands will work on all systems or display devices.
.Pp
A few terminal programs do not recognize the default end code
properly.
If all text gets colorized after you do a directory
listing, try changing the
.Ql no
and
.Ql fi
codes from 0 to the
numerical codes for your standard fore- and background colors.
.Pp
For symbolic links the
.Ql ln
keyword can be set to
.Ql target ,
which makes
the file color the same as the color of the link target.
.
.It Ev MACHTYPE No (+)
The machine type (microprocessor class or machine model), as determined at compile time.
.
.It Ev NOREBIND No (+)
If set, printable characters are not rebound to
.Ic self-insert-command .
See
.Sx Native Language System support .
.
.It Ev OSTYPE No (+)
The operating system, as determined at compile time.
.
.It Ev PATH
A colon-separated list of directories in which to look for executables.
Equivalent to the
.Ic path
shell variable, but in a different format.
.
.It Ev PWD No (+)
Equivalent to the
.Ic cwd
shell variable, but not synchronized to it;
updated only after an actual directory change.
.
.It Ev REMOTEHOST No (+)
The host from which the user has logged in remotely, if this is the case and
the shell is able to determine it.
Set only if the shell was so compiled;
see the
.Ic version
shell variable.
.
.It Ev SHLVL No (+)
Equivalent to the
.Ic shlvl
shell variable.
.
.It Ev SYSTYPE No (+)
The current system type.
(Domain/OS only)
.
.It Ev TERM
Equivalent to the
.Ic term
shell variable.
.
.It Ev TERMCAP
The terminal capability string.
See
.Sx Terminal management .
.
.It Ev USER
Equivalent to the
.Ic user
shell variable.
.
.It Ev VENDOR No (+)
The vendor, as determined at compile time.
.
.It Ev VISUAL
The pathname to a default full-screen editor.
Used by the
.Ic run-fg-editor
editor command if the
the
.Ic editors
shell variable is unset.
See also the
.Ev EDITOR
environment variable.
.
.El
.
.Sh FILES
.Bl -tag -width 8n
.
.It Pa /etc/csh.cshrc
Read first by every shell.
ConvexOS, Stellix and Intel use
.Pa /etc/cshrc
and
NeXTs use
.Pa /etc/cshrc.std .
A/UX, AMIX, Cray and IRIX have no equivalent in
.Xr csh 1 ,
but read this file in
.Nm
anyway.
Solaris 2.x does not have it either, but
.Nm
reads
.Pa /etc/.cshrc .
(+)
.
.It Pa /etc/csh.login
Read by login shells after
.Pa /etc/csh.cshrc .
ConvexOS, Stellix and Intel use
.Pa /etc/login ,
NeXTs use
.Pa /etc/login.std ,
Solaris 2.x uses
.Pa /etc/.login
and
A/UX, AMIX, Cray and IRIX use
.Pa /etc/cshrc .
.
.It Pa ~/.tcshrc No (+)
Read by every shell after
.Pa /etc/csh.cshrc
or its equivalent.
.
.It Pa ~/.cshrc
Read by every shell, if
.Pa ~/.tcshrc
doesn't exist,
after
.Pa /etc/csh.cshrc
or its equivalent.
This manual uses
.Sq Pa ~/.tcshrc
to mean
.Do
.Pa ~/.tcshrc
or,
if
.Pa ~/.tcshrc
is not found,
.Pa ~/.cshrc
.Dc .
.
.It Pa ~/.history
Read by login shells after
.Pa ~/.tcshrc
if
.Ic savehist
is set, but see also
.Ic histfile .
.
.It Pa ~/.login
Read by login shells after
.Pa ~/.tcshrc
or
.Pa ~/.history .
The shell may be compiled to read
.Pa ~/.login
before instead of after
.Pa ~/.tcshrc
and
.Pa ~/.history ;
see the
.Ic version
shell variable.
.
.It Pa ~/.cshdirs No (+)
Read by login shells after
.Pa ~/.login
if
.Ic savedirs
is set, but see also
.Ic dirsfile .
.
.It Pa /etc/csh.logout
Read by login shells at logout.
ConvexOS, Stellix and Intel use
.Pa /etc/logout
and
NeXTs use
.Pa /etc/logout.std .
A/UX, AMIX, Cray and IRIX have no equivalent in
.Xr csh 1 ,
but read this file in
.Nm
anyway.
Solaris 2.x does not have it either, but
.Nm
reads
.Pa /etc/.logout .
(+)
.
.It Pa ~/.logout
Read by login shells at logout after
.Pa /etc/csh.logout
or its equivalent.
.
.It Pa /bin/sh
Used to interpret shell scripts not starting with a
.Ql # .
.
.It Pa /tmp/sh*
Temporary file for
.Ql << .
.
.It Pa /etc/passwd
Source of home directories for
.Sq ~name
substitutions.
.
.El
.Pp
The order in which startup files are read may differ if the shell was so
compiled; see
.Sx Startup and shutdown
and the
.Ic version
shell variable.
.
.Sh "NEW FEATURES (+)"
This manual describes
.Nm
as a single entity,
but experienced
.Xr csh 1
users will want to pay special attention to
.Nm Ns
\&'s new features.
.Pp
A command-line editor, which supports
.Xr emacs 1 Ns
\-style
or
.Xr vi 1 Ns
\-style key bindings.
See
.Sx The command-line editor
and
.Sx Editor commands .
.Pp
Programmable, interactive word completion and listing.
See
.Sx Completion and listing
and the
.Ic complete
and
.Ic uncomplete
builtin commands.
.Pp
.Sx Spelling correction
(q.v.) of filenames, commands and variables.
.Pp
.Sx Editor commands
(q.v.) which perform other useful functions in the middle of
typed commands, including documentation lookup
.Ic ( run-help ) ,
quick editor restarting
.Ic ( run-fg-editor ) ,
and
command resolution
.Ic ( which-command ) .
.Pp
An enhanced history mechanism.
Events in the history list are time-stamped.
See also the
.Ic history
command and its associated shell variables,
the previously undocumented
.Ql #
event specifier and new modifiers
under
.Sx History substitution ,
the
.Ic down-history ,
.Ic expand-history ,
.Ic history-search-backward ,
.Ic history-search-forward ,
.Ic i-search-back ,
.Ic i-search-fwd ,
.Ic toggle-literal-history ,
.Ic vi-search-back ,
.Ic vi-search-fwd ,
and
.Ic up-history
editor commands
and the
.Ic histlit
shell variable.
.Pp
Enhanced directory parsing and directory stack handling.
See the
.Ic cd ,
.Ic pushd ,
.Ic popd ,
and
.Ic dirs
commands and their associated
shell variables, the description of
.Sx Directory stack substitution ,
the
.Ic dirstack ,
.Ic owd ,
and
.Ic symlinks
shell variables and
the
.Ic normalize-command
and
.Ic normalize-path
editor commands.
.Pp
Negation in glob-patterns.
See
.Sx Filename substitution .
.Pp
New
.Sx File inquiry operators
(q.v.) and a
.Ic filetest
builtin which uses them.
.Pp
A variety of
.Sx Automatic, periodic and timed events
(q.v.) including
scheduled events, special aliases, automatic logout and terminal locking,
command timing and watching for logins and logouts.
.Pp
Support for the Native Language System
(see
.Sx Native Language System support ) ,
OS variant features
(see
.Sx OS variant support
and the
.Ic echo_style
shell variable)
and system-dependent file locations (see
.Sx FILES ) .
.Pp
Extensive terminal-management capabilities.
See
.Sx Terminal management .
.Pp
New builtin commands including
.Ic builtins ,
.Ic hup ,
.Ic ls\-F ,
.Ic newgrp ,
.Ic printenv ,
.Ic which ,
and
.Ic where
(q.v.).
.Pp
New variables that make useful information easily available to the shell.
See the
.Ic gid ,
.Ic loginsh ,
.Ic oid ,
.Ic shlvl ,
.Ic tcsh ,
.Ic tty ,
.Ic uid ,
and
.Ic version
shell variables and the
.Ev HOST ,
.Ev REMOTEHOST ,
.Ev VENDOR ,
.Ev OSTYPE ,
and
.Ev MACHTYPE
environment
variables.
.Pp
A new syntax for including useful information in the prompt string
(see
.Ic prompt ) ,
and special prompts for loops and spelling correction
(see
.Ic prompt2
and
.Ic prompt3 ) .
.Pp
Read-only variables.
See
.Sx Variable substitution .
.
.Sh BUGS
When a suspended command is restarted, the shell prints the directory
it started in if this is different from the current directory.
This can
be misleading (i.e., wrong) as the job may have changed directories internally.
.Pp
Shell builtin functions are not stoppable/restartable.
Command sequences
of the form
.Ql a \&; b \&; c
are also not handled gracefully when stopping is
attempted.
If you suspend
.Ql b ,
the shell will then immediately execute
.Ql c .
This is especially noticeable if this expansion results from an
.Ic alias .
It suffices to place the sequence of commands in
.Ql () Ns
\&'s to force it
to a subshell, i.e.,
.Ql \&( a \&; b \&; c \&) .
.Pp
Control over tty output after processes are started is primitive; perhaps
this will inspire someone to work on a good virtual terminal interface.
In a virtual terminal interface much more interesting things could be
done with output control.
.Pp
Alias substitution is most often used to clumsily simulate shell procedures;
shell procedures should be provided rather than aliases.
.Pp
Control structures should be parsed rather than being recognized as
built-in commands.
This would allow control commands to be placed anywhere,
to be combined with
.Ql | ,
and to be used with
.Ql &
and
.Ql \&;
metasyntax.
.Pp
.Ic foreach
doesn't ignore here documents when looking for its
.Ic end .
.Pp
It should be possible to use the
.Ql \&:
modifiers on the output of command
substitutions.
.Pp
The screen update for lines longer than the screen width is very poor
if the terminal cannot move the cursor up (i.e., terminal type
.Ql dumb ) .
.Pp
.Ev HPATH
and
.Ev NOREBIND
don't need to be environment variables.
.Pp
Glob-patterns which do not use
.Ql \&? ,
.Ql * ,
or
.Ql [] ,
or which use
.Ql {}
or
.Ql ~
are not negated correctly.
.Pp
The single-command form of
.Ic if
does output redirection even if
the expression is false and the command is not executed.
.Pp
.Ic ls\-F
includes file identification characters when sorting filenames
and does not handle control characters in filenames well.
It cannot be
interrupted.
.Pp
Command substitution supports multiple commands and conditions, but not
cycles or backward
.Ic goto Ns
s.
.Pp
Report bugs at
.Lk https://bugs.astron.com/
preferably with fixes.
If you want to
help maintain and test tcsh, add yourself to the mailing list in
.Lk https://mailman.astron.com/
.
.Sh THE T IN TCSH
In 1964, DEC produced the PDP-6.
The PDP-10 was a later re-implementation.
It
was re-christened the DECsystem-10 in 1970 or so when DEC brought out the
second model, the KI10.
.Pp
TENEX was created at Bolt, Beranek & Newman (a Cambridge, Massachusetts
think tank) in
1972 as an experiment in demand-paged virtual memory operating systems.
They
built a new pager for the DEC PDP-10 and created the OS to go with it.
It was
extremely successful in academia.
.Pp
In 1975, DEC brought out a new model of the PDP-10, the KL10; they intended to
have only a version of TENEX, which they had licensed from BBN, for the new
box.
They called their version TOPS-20 (their capitalization is trademarked).
A lot of TOPS-10 users (`The OPerating System for PDP-10') objected; thus DEC
found themselves supporting two incompatible systems on the same hardware--but
then there were 6 on the PDP-11!
.Pp
TENEX, and TOPS-20 to version 3, had command completion
via a user-code-level subroutine library called ULTCMD.
With version 3, DEC
moved all that capability and more into the monitor (`kernel' for you Unix
types), accessed by the COMND% JSYS (`Jump to SYStem' instruction, the
supervisor call mechanism [are my IBM roots also showing?]).
.Pp
The creator of tcsh was impressed by this feature and several others of TENEX
and TOPS-20, and created a version of csh which mimicked them.
.
.Sh LIMITATIONS
The system limits argument lists to ARG_MAX characters.
.Pp
The number of arguments to a command which involves filename expansion is
limited to 1/6th the number of characters allowed in an argument list.
.Pp
Command substitutions may substitute no more characters than are allowed in
an argument list.
.Pp
To detect looping, the shell restricts the number of
.Ic alias
substitutions on a single line to 20.
.
.Sh "SEE ALSO"
.Xr csh 1 ,
.Xr emacs 1 ,
.Xr ls 1 ,
.Xr newgrp 1 ,
.Xr sh 1 ,
.Xr setpath 1 ,
.Xr stty 1 ,
.Xr su 1 ,
.Xr tset 1 ,
.Xr vi 1 ,
.Xr x 1 ,
.Xr access 2 ,
.Xr execve 2 ,
.Xr fork 2 ,
.Xr killpg 2 ,
.Xr pipe 2 ,
.Xr setrlimit 2 ,
.Xr sigvec 2 ,
.Xr stat 2 ,
.Xr umask 2 ,
.Xr vfork 2 ,
.Xr wait 2 ,
.Xr malloc 3 ,
.Xr setlocale 3 ,
.Xr tty 4 ,
.Xr a.out 5 ,
.Xr termcap 5 ,
.Xr environ 7 ,
.Xr termio 7 ,
.Em Introduction to the C Shell
.
.Sh VERSION
.\" UPDATE NEXT LINE FOR RELEASE
This manual documents tcsh 6.24.03 (Astron) 2022-12-03.
.
.Sh AUTHORS
.
.Bl -tag -width 2n -compact
.
.It William Joy
Original author of
.Xr csh 1
.
.It J.E. Kulp, IIASA, Laxenburg, Austria
Job control and directory stack features
.
.It Ken Greer, HP Labs, 1981
File name completion
.
.It Mike Ellis, Fairchild, 1983
Command name recognition/completion
.
.It Paul Placeway, Ohio State CIS Dept., 1983-1993
Command line editor, prompt routines, new glob syntax and numerous fixes
and speedups
.
.It Karl Kleinpaste, CCI 1983-4
Special aliases, directory stack extraction stuff, login/logout watch,
scheduled events, and the idea of the new prompt format
.
.It Rayan Zachariassen, University of Toronto, 1984
.Ic ls\-F
and
.Ic which
builtins and numerous bug fixes, modifications
and speedups
.
.It Chris Kingsley, Caltech
Fast storage allocator routines
.
.It Chris Grevstad, TRW, 1987
Incorporated 4.3BSD
.Xr csh 1
into
.Nm
.
.It Christos S. Zoulas, Cornell U. EE Dept., 1987-94
Ports to HPUX, SVR2 and SVR3, a SysV version of getwd.c, SHORT_STRINGS support
and a new version of sh.glob.c
.
.It James J Dempsey, BBN, and Paul Placeway, OSU, 1988
A/UX port
.
.It Daniel Long, NNSC, 1988
.Ic wordchars
.
.It Patrick Wolfe, Kuck and Associates, Inc., 1988
.Ic vi
mode cleanup
.
.It David C Lawrence, Rensselaer Polytechnic Institute, 1989
.Ic autolist
and ambiguous completion listing
.
.It Alec Wolman, DEC, 1989
Newlines in the prompt
.
.It Matt Landau, BBN, 1989
.Pa ~/.tcshrc
.
.It Ray Moody, Purdue Physics, 1989
Magic space bar history expansion
.
.It Mordechai ????, Intel, 1989
printprompt() fixes and additions
.
.It Kazuhiro Honda, Dept. of Computer Science, Keio University, 1989
Automatic spelling correction and
.Ic prompt3
.
.It Per Hedeland, Ellemtel, Sweden, 1990-
Various bugfixes, improvements and manual updates
.
.It Hans J. Albertsson (Sun Sweden)
.Ic ampm ,
.Ic settc ,
and
.Ic telltc
.
.It Michael Bloom
Interrupt handling fixes
.
.It Michael Fine, Digital Equipment Corp
Extended key support
.
.It Eric Schnoebelen, Convex, 1990
Convex support, lots of
.Xr csh 1
bug fixes,
save and restore of directory stack
.
.It Ron Flax, Apple, 1990
A/UX 2.0 (re)port
.
.It Dan Oscarsson, LTH Sweden, 1990
NLS support and simulated NLS support for non NLS sites, fixes
.
.It Johan Widen, SICS Sweden, 1990
.Ic shlvl ,
Mach support,
.Ic correct-line ,
8-bit printing
.
.It Matt Day, Sanyo Icon, 1990
POSIX termio support, SysV limit fixes
.
.It Jaap Vermeulen, Sequent, 1990-91
Vi mode fixes, expand-line, window change fixes, Symmetry port
.
.It Martin Boyer, Institut de recherche d'Hydro-Quebec, 1991
.Ic autolist
beeping options, modified the history search to search for
the whole string from the beginning of the line to the cursor.
.
.It Scott Krotz, Motorola, 1991
Minix port
.
.It David Dawes, Sydney U. Australia, Physics Dept., 1991
SVR4 job control fixes
.
.It Jose Sousa, Interactive Systems Corp., 1991
Extended
.Ic vi
fixes and
.Ic vi
delete command
.
.It Marc Horowitz, MIT, 1991
ANSIfication fixes, new exec hashing code, imake fixes,
.Ic where
.
.It Bruce Sterling Woodcock, sterling@netcom.com, 1991-1995
ETA and Pyramid port, Makefile and lint fixes,
.Ic ignoreeof Ns
=n addition, and
various other portability changes and bug fixes
.
.It Jeff Fink, 1992
.Ic complete-word-fwd
and
.Ic complete-word-back
.
.It Harry C. Pulley, 1992
Coherent port
.
.It Andy Phillips, Mullard Space Science Lab U.K., 1992
VMS-POSIX port
.
.It Beto Appleton, IBM Corp., 1992
Walking process group fixes,
.Xr csh 1
bug fixes,
POSIX file tests, POSIX SIGHUP
.
.It Scott Bolte, Cray Computer Corp., 1992
CSOS port
.
.It Kaveh R. Ghazi, Rutgers University, 1992
Tek, m88k, Titan and Masscomp ports and fixes.
Added autoconf support.
.
.It Mark Linderman, Cornell University, 1992
OS/2 port
.
.It Mika Liljeberg, liljeber@kruuna.Helsinki.FI, 1992
Linux port
.
.It Tim P. Starrin, NASA Langley Research Center Operations, 1993
Read-only variables
.
.It Dave Schweisguth, Yale University, 1993-4
New man page and tcsh.man2html
.
.It Larry Schwimmer, Stanford University, 1993
AFS and HESIOD patches
.
.It Luke Mewburn, 1991-
Enhanced directory printing in prompt.
Added
.Ic ellipsis
and
.Ic rprompt .
.Ic vimode
improvements.
Manual page improvements.
.
.It Edward Hutchins, Silicon Graphics Inc., 1996
Added implicit cd.
.
.It Martin Kraemer, 1997
Ported to Siemens Nixdorf EBCDIC machine
.
.It Amol Deshpande, Microsoft, 1997
Ported to WIN32 (Windows/95 and Windows/NT); wrote all the missing library
and message catalog code to interface to Windows.
.
.It Taga Nayuta, 1998
Color ls additions.
.
.El
.
.Sh "THANKS TO"
Bryan Dunlap, Clayton Elwell, Karl Kleinpaste, Bob Manson, Steve Romig,
Diana Smetters, Bob Sutterfield, Mark Verber, Elizabeth Zwicky and all
the other people at Ohio State for suggestions and encouragement
.Pp
All the people on the net, for putting up with,
reporting bugs in, and suggesting new additions to each and every version
.Pp
Richard M. Alderson III, for writing the
.Sq T in tcsh
section
