/* totem-rotation-plugin.c generated by valac 0.38.7, the Vala compiler
 * generated from totem-rotation-plugin.vala, do not modify */

/*
 * Copyright (C) Simon Wenner 2011 <simon@wenner.ch>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libpeas/peas.h>
#include "bacon-video-widget.h"
#include <gio/gio.h>
#include <totem.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define TYPE_ROTATION_PLUGIN (rotation_plugin_get_type ())
#define ROTATION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ROTATION_PLUGIN, RotationPlugin))
#define ROTATION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ROTATION_PLUGIN, RotationPluginClass))
#define IS_ROTATION_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ROTATION_PLUGIN))
#define IS_ROTATION_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ROTATION_PLUGIN))
#define ROTATION_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ROTATION_PLUGIN, RotationPluginClass))

typedef struct _RotationPlugin RotationPlugin;
typedef struct _RotationPluginClass RotationPluginClass;
typedef struct _RotationPluginPrivate RotationPluginPrivate;
enum  {
	ROTATION_PLUGIN_0_PROPERTY,
	ROTATION_PLUGIN_OBJECT_PROPERTY,
	ROTATION_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rotation_plugin_properties[ROTATION_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RotationPluginStoreStateData RotationPluginStoreStateData;
typedef struct _RotationPluginTryRestoreStateData RotationPluginTryRestoreStateData;

struct _RotationPlugin {
	GObject parent_instance;
	RotationPluginPrivate * priv;
};

struct _RotationPluginClass {
	GObjectClass parent_class;
};

struct _RotationPluginPrivate {
	GObject* _object;
	BaconVideoWidget* bvw;
	GSimpleAction* rotate_left_action;
	GSimpleAction* rotate_right_action;
};

struct _RotationPluginStoreStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RotationPlugin* self;
	TotemObject* t;
	GObject* _tmp0_;
	GObject* _tmp1_;
	gchar* mrl;
	TotemObject* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* file;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	BvwRotation rotation;
	GFileInfo* file_info;
	GFile* _tmp7_;
	GFileInfo* _tmp8_;
	gchar* state_str;
	gchar* _tmp9_;
	BaconVideoWidget* _tmp10_;
	BvwRotation _tmp11_;
	BvwRotation _tmp12_;
	BvwRotation _tmp13_;
	gchar* _tmp14_;
	GFileInfo* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GFileInfo* _tmp18_;
	GError* e;
	GError* _vala1_e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError * _inner_error_;
};

struct _RotationPluginTryRestoreStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RotationPlugin* self;
	gchar* mrl;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
	GFileInfo* file_info;
	GFile* _tmp7_;
	GFileInfo* _tmp8_;
	gchar* state_str;
	GFileInfo* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gint state;
	const gchar* _tmp13_;
	guint64 _tmp14_;
	BaconVideoWidget* _tmp15_;
	gint _tmp16_;
	GError* e;
	GError* _vala1_e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError * _inner_error_;
};


static gpointer rotation_plugin_parent_class = NULL;
static PeasActivatableInterface * rotation_plugin_peas_activatable_parent_iface = NULL;
static GType rotation_plugin_type_id = 0;

#define GIO_ROTATION_FILE_ATTRIBUTE "metadata::totem::rotation"
GType rotation_plugin_get_type (void) G_GNUC_CONST;
#define ROTATION_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ROTATION_PLUGIN, RotationPluginPrivate))
#define ROTATION_PLUGIN_STATE_COUNT 4
static void rotation_plugin_real_activate (PeasActivatable* base);
static void rotation_plugin_cb_rotate_left (RotationPlugin* self);
static void _rotation_plugin_cb_rotate_left_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void rotation_plugin_cb_rotate_right (RotationPlugin* self);
static void _rotation_plugin_cb_rotate_right_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void rotation_plugin_try_restore_state (RotationPlugin* self, const gchar* mrl, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rotation_plugin_try_restore_state_finish (RotationPlugin* self, GAsyncResult* _res_);
static void ___lambda6_ (RotationPlugin* self, GObject* o, GAsyncResult* r);
static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rotation_plugin_cb_file_closed (RotationPlugin* self);
static void _rotation_plugin_cb_file_closed_totem_object_file_closed (TotemObject* _sender, gpointer self);
static void rotation_plugin_cb_file_opened (RotationPlugin* self, const gchar* mrl);
static void _rotation_plugin_cb_file_opened_totem_object_file_opened (TotemObject* _sender, const gchar* mrl, gpointer self);
static void rotation_plugin_real_deactivate (PeasActivatable* base);
static void rotation_plugin_real_update_state (PeasActivatable* base);
static void rotation_plugin_store_state (RotationPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rotation_plugin_store_state_finish (RotationPlugin* self, GAsyncResult* _res_);
static void __lambda4_ (RotationPlugin* self, GObject* o, GAsyncResult* r);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda5_ (RotationPlugin* self, GObject* o, GAsyncResult* r);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda7_ (RotationPlugin* self, GObject* o, GAsyncResult* r);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void rotation_plugin_store_state_data_free (gpointer _data);
static void rotation_plugin_store_state_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rotation_plugin_store_state_co (RotationPluginStoreStateData* _data_);
static void rotation_plugin_store_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rotation_plugin_try_restore_state_data_free (gpointer _data);
static void rotation_plugin_try_restore_state_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean rotation_plugin_try_restore_state_co (RotationPluginTryRestoreStateData* _data_);
static void rotation_plugin_try_restore_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
RotationPlugin* rotation_plugin_new (void);
RotationPlugin* rotation_plugin_construct (GType object_type);
static void rotation_plugin_finalize (GObject * obj);
static void _vala_rotation_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rotation_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void peas_register_types (GTypeModule* module);
GType rotation_plugin_register_type (GTypeModule * module);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _rotation_plugin_cb_rotate_left_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	rotation_plugin_cb_rotate_left ((RotationPlugin*) self);
}


static void _rotation_plugin_cb_rotate_right_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	rotation_plugin_cb_rotate_right ((RotationPlugin*) self);
}


static void ___lambda6_ (RotationPlugin* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	rotation_plugin_try_restore_state_finish (self, _tmp0_);
}


static void ____lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda6_ ((RotationPlugin*) self, source_object, res);
	g_object_unref (self);
}


static void _rotation_plugin_cb_file_closed_totem_object_file_closed (TotemObject* _sender, gpointer self) {
	rotation_plugin_cb_file_closed ((RotationPlugin*) self);
}


static void _rotation_plugin_cb_file_opened_totem_object_file_opened (TotemObject* _sender, const gchar* mrl, gpointer self) {
	rotation_plugin_cb_file_opened ((RotationPlugin*) self, mrl);
}


static void rotation_plugin_real_activate (PeasActivatable* base) {
	RotationPlugin * self;
	TotemObject* t = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	gchar* mrl = NULL;
	TotemObject* _tmp2_;
	gchar* _tmp3_;
	GMenu* menu = NULL;
	TotemObject* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	TotemObject* _tmp7_;
	GtkWidget* _tmp8_;
	BaconVideoWidget* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	TotemObject* _tmp12_;
	GSimpleAction* _tmp13_;
	TotemObject* _tmp14_;
	GSimpleAction* _tmp15_;
	GSimpleAction* _tmp16_;
	TotemObject* _tmp17_;
	GSimpleAction* _tmp18_;
	TotemObject* _tmp19_;
	GMenuItem* item = NULL;
	GMenuItem* _tmp20_;
	GMenuItem* _tmp21_;
	GMenu* _tmp22_;
	GMenuItem* _tmp23_;
	GMenuItem* _tmp24_;
	GMenuItem* _tmp25_;
	GMenu* _tmp26_;
	GMenuItem* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp31_;
	TotemObject* _tmp33_;
	TotemObject* _tmp34_;
	self = (RotationPlugin*) base;
	g_object_get ((PeasActivatable*) self, "object", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	t = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, totem_object_get_type (), TotemObject);
	_tmp2_ = t;
	_tmp3_ = totem_object_get_current_mrl (_tmp2_);
	mrl = _tmp3_;
	_tmp4_ = t;
	_tmp5_ = totem_object_get_menu_section (_tmp4_, "rotation-placeholder");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	menu = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = totem_object_get_video_widget (_tmp7_);
	_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, BACON_TYPE_VIDEO_WIDGET) ? ((BaconVideoWidget*) _tmp8_) : NULL;
	if (_tmp9_ == NULL) {
		_g_object_unref0 (_tmp8_);
	}
	_g_object_unref0 (self->priv->bvw);
	self->priv->bvw = _tmp9_;
	_tmp10_ = g_simple_action_new ("rotate-left", NULL);
	_g_object_unref0 (self->priv->rotate_left_action);
	self->priv->rotate_left_action = _tmp10_;
	_tmp11_ = self->priv->rotate_left_action;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) _rotation_plugin_cb_rotate_left_g_simple_action_activate, self, 0);
	_tmp12_ = t;
	_tmp13_ = self->priv->rotate_left_action;
	g_action_map_add_action ((GActionMap*) _tmp12_, (GAction*) _tmp13_);
	_tmp14_ = t;
	gtk_application_add_accelerator ((GtkApplication*) _tmp14_, "<Primary><Shift>R", "app.rotate-left", NULL);
	_tmp15_ = g_simple_action_new ("rotate-right", NULL);
	_g_object_unref0 (self->priv->rotate_right_action);
	self->priv->rotate_right_action = _tmp15_;
	_tmp16_ = self->priv->rotate_right_action;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) _rotation_plugin_cb_rotate_right_g_simple_action_activate, self, 0);
	_tmp17_ = t;
	_tmp18_ = self->priv->rotate_right_action;
	g_action_map_add_action ((GActionMap*) _tmp17_, (GAction*) _tmp18_);
	_tmp19_ = t;
	gtk_application_add_accelerator ((GtkApplication*) _tmp19_, "<Primary>R", "app.rotate-right", NULL);
	_tmp20_ = g_menu_item_new (_ ("_Rotate ↷"), "app.rotate-right");
	item = _tmp20_;
	_tmp21_ = item;
	g_menu_item_set_attribute (_tmp21_, "accel", "s", "<Primary>R", NULL);
	_tmp22_ = menu;
	_tmp23_ = item;
	g_menu_append_item (_tmp22_, _tmp23_);
	_tmp24_ = g_menu_item_new (_ ("Rotate ↶"), "app.rotate-left");
	_g_object_unref0 (item);
	item = _tmp24_;
	_tmp25_ = item;
	g_menu_item_set_attribute (_tmp25_, "accel", "s", "<Primary><Shift>R", NULL);
	_tmp26_ = menu;
	_tmp27_ = item;
	g_menu_append_item (_tmp26_, _tmp27_);
	_tmp28_ = mrl;
	if (_tmp28_ == NULL) {
		GSimpleAction* _tmp29_;
		GSimpleAction* _tmp30_;
		_tmp29_ = self->priv->rotate_right_action;
		g_simple_action_set_enabled (_tmp29_, FALSE);
		_tmp30_ = self->priv->rotate_left_action;
		g_simple_action_set_enabled (_tmp30_, FALSE);
	}
	_tmp31_ = mrl;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = mrl;
		rotation_plugin_try_restore_state (self, _tmp32_, ____lambda6__gasync_ready_callback, g_object_ref (self));
	}
	_tmp33_ = t;
	g_signal_connect_object (_tmp33_, "file-closed", (GCallback) _rotation_plugin_cb_file_closed_totem_object_file_closed, self, 0);
	_tmp34_ = t;
	g_signal_connect_object (_tmp34_, "file-opened", (GCallback) _rotation_plugin_cb_file_opened_totem_object_file_opened, self, 0);
	_g_object_unref0 (item);
	_g_object_unref0 (menu);
	_g_free0 (mrl);
	_g_object_unref0 (t);
}


static void rotation_plugin_real_deactivate (PeasActivatable* base) {
	RotationPlugin * self;
	TotemObject* t = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	BaconVideoWidget* _tmp4_;
	self = (RotationPlugin*) base;
	g_object_get ((PeasActivatable*) self, "object", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	t = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, totem_object_get_type (), TotemObject);
	g_signal_parse_name ("file-closed", totem_object_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (t, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _rotation_plugin_cb_file_closed_totem_object_file_closed, self);
	g_signal_parse_name ("file-opened", totem_object_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (t, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _rotation_plugin_cb_file_opened_totem_object_file_opened, self);
	totem_object_empty_menu_section (t, "rotation-placeholder");
	gtk_application_remove_accelerator ((GtkApplication*) t, "app.rotate-right", NULL);
	gtk_application_remove_accelerator ((GtkApplication*) t, "app.rotate-left", NULL);
	_tmp4_ = self->priv->bvw;
	bacon_video_widget_set_rotation (_tmp4_, BVW_ROTATION_R_ZERO);
	_g_object_unref0 (t);
}


static void rotation_plugin_real_update_state (PeasActivatable* base) {
	RotationPlugin * self;
	self = (RotationPlugin*) base;
}


static void __lambda4_ (RotationPlugin* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	rotation_plugin_store_state_finish (self, _tmp0_);
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda4_ ((RotationPlugin*) self, source_object, res);
	g_object_unref (self);
}


static void rotation_plugin_cb_rotate_left (RotationPlugin* self) {
	gint state = 0;
	BaconVideoWidget* _tmp0_;
	BvwRotation _tmp1_;
	BaconVideoWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bvw;
	_tmp1_ = bacon_video_widget_get_rotation (_tmp0_);
	state = (gint) ((_tmp1_ - 1) % ROTATION_PLUGIN_STATE_COUNT);
	_tmp2_ = self->priv->bvw;
	bacon_video_widget_set_rotation (_tmp2_, (BvwRotation) state);
	rotation_plugin_store_state (self, ___lambda4__gasync_ready_callback, g_object_ref (self));
}


static void __lambda5_ (RotationPlugin* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	rotation_plugin_store_state_finish (self, _tmp0_);
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda5_ ((RotationPlugin*) self, source_object, res);
	g_object_unref (self);
}


static void rotation_plugin_cb_rotate_right (RotationPlugin* self) {
	gint state = 0;
	BaconVideoWidget* _tmp0_;
	BvwRotation _tmp1_;
	BaconVideoWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bvw;
	_tmp1_ = bacon_video_widget_get_rotation (_tmp0_);
	state = (gint) ((_tmp1_ + 1) % ROTATION_PLUGIN_STATE_COUNT);
	_tmp2_ = self->priv->bvw;
	bacon_video_widget_set_rotation (_tmp2_, (BvwRotation) state);
	rotation_plugin_store_state (self, ___lambda5__gasync_ready_callback, g_object_ref (self));
}


static void rotation_plugin_cb_file_closed (RotationPlugin* self) {
	BaconVideoWidget* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bvw;
	bacon_video_widget_set_rotation (_tmp0_, BVW_ROTATION_R_ZERO);
	_tmp1_ = self->priv->rotate_right_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->rotate_left_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
}


static void __lambda7_ (RotationPlugin* self, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	rotation_plugin_try_restore_state_finish (self, _tmp0_);
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ ((RotationPlugin*) self, source_object, res);
	g_object_unref (self);
}


static void rotation_plugin_cb_file_opened (RotationPlugin* self, const gchar* mrl) {
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mrl != NULL);
	_tmp0_ = self->priv->rotate_right_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->rotate_left_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	_tmp2_ = mrl;
	rotation_plugin_try_restore_state (self, _tmp2_, ___lambda7__gasync_ready_callback, g_object_ref (self));
}


static void rotation_plugin_store_state_data_free (gpointer _data) {
	RotationPluginStoreStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RotationPluginStoreStateData, _data_);
}


static void rotation_plugin_store_state_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RotationPluginStoreStateData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rotation_plugin_store_state (RotationPlugin* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RotationPluginStoreStateData* _data_;
	RotationPlugin* _tmp0_;
	_data_ = g_slice_new0 (RotationPluginStoreStateData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rotation_plugin_store_state_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rotation_plugin_store_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rotation_plugin_store_state_co (_data_);
}


static void rotation_plugin_store_state_finish (RotationPlugin* self, GAsyncResult* _res_) {
	RotationPluginStoreStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void rotation_plugin_store_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RotationPluginStoreStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rotation_plugin_store_state_co (_data_);
}


static gboolean rotation_plugin_store_state_co (RotationPluginStoreStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_get ((PeasActivatable*) _data_->self, "object", &_data_->_tmp0_, NULL);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->t = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, totem_object_get_type (), TotemObject);
	_data_->_tmp2_ = _data_->t;
	_data_->_tmp3_ = totem_object_get_current_mrl (_data_->_tmp2_);
	_data_->mrl = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->mrl;
	if (_data_->_tmp4_ == NULL) {
		_g_free0 (_data_->mrl);
		_g_object_unref0 (_data_->t);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->mrl;
	_data_->_tmp6_ = g_file_new_for_uri (_data_->_tmp5_);
	_data_->file = _data_->_tmp6_;
	{
		_data_->_tmp7_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp7_, GIO_ROTATION_FILE_ATTRIBUTE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rotation_plugin_store_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->file_info = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
				goto __catch0_g_io_error_not_supported;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = g_strdup ("");
		_data_->state_str = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->self->priv->bvw;
		_data_->_tmp11_ = bacon_video_widget_get_rotation (_data_->_tmp10_);
		_data_->rotation = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->rotation;
		if (_data_->_tmp12_ != BVW_ROTATION_R_ZERO) {
			_data_->_tmp13_ = _data_->rotation;
			_data_->_tmp14_ = g_strdup_printf ("%u", (guint) _data_->_tmp13_);
			_g_free0 (_data_->state_str);
			_data_->state_str = _data_->_tmp14_;
		}
		_data_->_tmp15_ = _data_->file_info;
		_data_->_tmp16_ = _data_->state_str;
		g_file_info_set_attribute_string (_data_->_tmp15_, GIO_ROTATION_FILE_ATTRIBUTE, _data_->_tmp16_);
		_data_->_tmp17_ = _data_->file;
		_data_->_tmp18_ = _data_->file_info;
		_data_->_state_ = 2;
		g_file_set_attributes_async (_data_->_tmp17_, _data_->_tmp18_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rotation_plugin_store_state_ready, _data_);
		return FALSE;
		_state_2:
		g_file_set_attributes_finish (_data_->_tmp17_, _data_->_res_, NULL, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->state_str);
			_g_object_unref0 (_data_->file_info);
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
				goto __catch0_g_io_error_not_supported;
			}
			goto __catch0_g_error;
		}
		_g_free0 (_data_->state_str);
		_g_object_unref0 (_data_->file_info);
	}
	goto __finally0;
	__catch0_g_io_error_not_supported:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = _data_->_vala1_e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("totem-rotation-plugin.vala:156: Could not store file attribute: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->mrl);
		_g_object_unref0 (_data_->t);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->mrl);
	_g_object_unref0 (_data_->t);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rotation_plugin_try_restore_state_data_free (gpointer _data) {
	RotationPluginTryRestoreStateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->mrl);
	_g_object_unref0 (_data_->self);
	g_slice_free (RotationPluginTryRestoreStateData, _data_);
}


static void rotation_plugin_try_restore_state_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RotationPluginTryRestoreStateData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void rotation_plugin_try_restore_state (RotationPlugin* self, const gchar* mrl, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RotationPluginTryRestoreStateData* _data_;
	RotationPlugin* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (RotationPluginTryRestoreStateData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rotation_plugin_try_restore_state_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rotation_plugin_try_restore_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mrl;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->mrl);
	_data_->mrl = _tmp2_;
	rotation_plugin_try_restore_state_co (_data_);
}


static void rotation_plugin_try_restore_state_finish (RotationPlugin* self, GAsyncResult* _res_) {
	RotationPluginTryRestoreStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void rotation_plugin_try_restore_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RotationPluginTryRestoreStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rotation_plugin_try_restore_state_co (_data_);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean rotation_plugin_try_restore_state_co (RotationPluginTryRestoreStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->mrl;
	_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
	_data_->file = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->file;
	_data_->_tmp4_ = g_file_has_uri_scheme (_data_->_tmp3_, "http");
	if (_data_->_tmp4_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->file;
		_data_->_tmp6_ = g_file_has_uri_scheme (_data_->_tmp5_, "dvd");
		_data_->_tmp2_ = _data_->_tmp6_;
	}
	if (_data_->_tmp2_) {
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp7_, GIO_ROTATION_FILE_ATTRIBUTE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rotation_plugin_try_restore_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->file_info = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
				goto __catch1_g_io_error_not_supported;
			}
			goto __catch1_g_error;
		}
		_data_->_tmp9_ = _data_->file_info;
		_data_->_tmp10_ = g_file_info_get_attribute_string (_data_->_tmp9_, GIO_ROTATION_FILE_ATTRIBUTE);
		_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
		_data_->state_str = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->state_str;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->state_str;
			_data_->_tmp14_ = uint64_parse (_data_->_tmp13_);
			_data_->state = (gint) ((BvwRotation) _data_->_tmp14_);
			_data_->_tmp15_ = _data_->self->priv->bvw;
			_data_->_tmp16_ = _data_->state;
			bacon_video_widget_set_rotation (_data_->_tmp15_, (BvwRotation) _data_->_tmp16_);
		}
		_g_free0 (_data_->state_str);
		_g_object_unref0 (_data_->file_info);
	}
	goto __finally1;
	__catch1_g_io_error_not_supported:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = _data_->_vala1_e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_warning ("totem-rotation-plugin.vala:175: Could not query file attribute: %s", _data_->_tmp18_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


RotationPlugin* rotation_plugin_construct (GType object_type) {
	RotationPlugin * self = NULL;
	self = (RotationPlugin*) g_object_new (object_type, NULL);
	return self;
}


RotationPlugin* rotation_plugin_new (void) {
	return rotation_plugin_construct (TYPE_ROTATION_PLUGIN);
}


static GObject* rotation_plugin_real_get_object (PeasActivatable* base) {
	GObject* result;
	RotationPlugin* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	self = (RotationPlugin*) base;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void rotation_plugin_real_set_object (PeasActivatable* base, GObject* value) {
	RotationPlugin* self;
	self = (RotationPlugin*) base;
	if (rotation_plugin_real_get_object (base) != value) {
		GObject* _tmp0_;
		GObject* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, rotation_plugin_properties[ROTATION_PLUGIN_OBJECT_PROPERTY]);
	}
}


static void rotation_plugin_class_init (RotationPluginClass * klass) {
	rotation_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RotationPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rotation_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rotation_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rotation_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ROTATION_PLUGIN_OBJECT_PROPERTY, rotation_plugin_properties[ROTATION_PLUGIN_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void rotation_plugin_peas_activatable_interface_init (PeasActivatableInterface * iface) {
	rotation_plugin_peas_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (PeasActivatable *)) rotation_plugin_real_activate;
	iface->deactivate = (void (*) (PeasActivatable *)) rotation_plugin_real_deactivate;
	iface->update_state = (void (*) (PeasActivatable *)) rotation_plugin_real_update_state;
}


static void rotation_plugin_instance_init (RotationPlugin * self) {
	self->priv = ROTATION_PLUGIN_GET_PRIVATE (self);
	self->priv->bvw = NULL;
	self->priv->rotate_left_action = NULL;
	self->priv->rotate_right_action = NULL;
}


static void rotation_plugin_finalize (GObject * obj) {
	RotationPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROTATION_PLUGIN, RotationPlugin);
	_g_object_unref0 (self->priv->_object);
	_g_object_unref0 (self->priv->bvw);
	_g_object_unref0 (self->priv->rotate_left_action);
	_g_object_unref0 (self->priv->rotate_right_action);
	G_OBJECT_CLASS (rotation_plugin_parent_class)->finalize (obj);
}


GType rotation_plugin_get_type (void) {
	return rotation_plugin_type_id;
}


GType rotation_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RotationPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rotation_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RotationPlugin), 0, (GInstanceInitFunc) rotation_plugin_instance_init, NULL };
	static const GInterfaceInfo peas_activatable_info = { (GInterfaceInitFunc) rotation_plugin_peas_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	rotation_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "RotationPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, rotation_plugin_type_id, peas_activatable_get_type (), &peas_activatable_info);
	return rotation_plugin_type_id;
}


static void _vala_rotation_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RotationPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROTATION_PLUGIN, RotationPlugin);
	switch (property_id) {
		case ROTATION_PLUGIN_OBJECT_PROPERTY:
		g_value_take_object (value, rotation_plugin_real_get_object ((PeasActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rotation_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RotationPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ROTATION_PLUGIN, RotationPlugin);
	switch (property_id) {
		case ROTATION_PLUGIN_OBJECT_PROPERTY:
		rotation_plugin_real_set_object ((PeasActivatable*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_;
	PeasObjectModule* _tmp1_;
	g_return_if_fail (module != NULL);
	rotation_plugin_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, peas_activatable_get_type (), TYPE_ROTATION_PLUGIN);
	_g_object_unref0 (objmodule);
}



