/* amd64-linux.elf-so_fold.h
   created from amd64-linux.elf-so_fold.bin, 13952 (0x3680) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_LINUX_ELF_SO_FOLD_SIZE    13952
#define STUB_AMD64_LINUX_ELF_SO_FOLD_ADLER32 0x97642183
#define STUB_AMD64_LINUX_ELF_SO_FOLD_CRC32   0x5aa18d70

unsigned char stub_amd64_linux_elf_so_fold[13952] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 32, 30,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 23,  0, 20,  0,
/* 0x0040 */  72,131,236,  8, 76,139, 71,  8, 72, 57, 23,115, 10,191,127,  0,
/* 0x0050 */   0,  0,232,  0,  0,  0,  0, 72,141, 74,255, 72,131,249,255,116,
/* 0x0060 */  21, 65, 15,182,  0,136,  6, 73,255,192, 72,255,198, 72,255,201,
/* 0x0070 */  72,131,249,255,117,235, 72,  1, 87,  8, 72, 41, 23, 72,131,196,
/* 0x0080 */   8,195, 72,131,236,  8,191,127,  0,  0,  0,232,  0,  0,  0,  0,
/* 0x0090 */  65, 84, 85, 83, 72,131,236, 32, 72,137,253, 72,137,243, 73,137,
/* 0x00a0 */ 212, 72,131, 62,  0, 15,132,236,  0,  0,  0,186, 12,  0,  0,  0,
/* 0x00b0 */  72,141,116, 36, 16, 72,137,239,232,131,255,255,255,131,124, 36,
/* 0x00c0 */  16,  0,117, 49,129,124, 36, 20, 85, 80, 88, 33,116, 10,191,  2,
/* 0x00d0 */   0,  0,  0,232,170,255,255,255, 72,131,125,  0,  0, 15,132,180,
/* 0x00e0 */   0,  0,  0,191,  3,  0,  0,  0,232,149,255,255,255,102,102,144,
/* 0x00f0 */ 233,162,  0,  0,  0,131,124, 36, 20,  0,117, 10,191,  4,  0,  0,
/* 0x0100 */   0,232,124,255,255,255,139, 68, 36, 20, 59, 68, 36, 16,119,  9,
/* 0x0110 */ 139, 68, 36, 16, 72, 59,  3,118, 10,191,  5,  0,  0,  0,232, 95,
/* 0x0120 */ 255,255,255,139,116, 36, 20, 59,116, 36, 16,115, 69,139, 68, 36,
/* 0x0130 */  16, 72,137, 68, 36,  8, 72,139, 83,  8, 72,139,125,  8, 68,139,
/* 0x0140 */  68, 36, 24, 72,141, 76, 36,  8, 65,255,212,133,192,117, 11,139,
/* 0x0150 */  68, 36, 16, 72, 59, 68, 36,  8,116, 10,191,  7,  0,  0,  0,232,
/* 0x0160 */  30,255,255,255,139, 68, 36, 20, 72,  1, 69,  8, 72, 41, 69,  0,
/* 0x0170 */ 235, 16,139, 84, 36, 20, 72,139,115,  8, 72,137,239,232,190,254,
/* 0x0180 */ 255,255,139, 68, 36, 16, 72,  1, 67,  8, 72, 41,  3, 72,131, 59,
/* 0x0190 */   0, 15,133, 20,255,255,255, 72,131,196, 32, 91, 93, 65, 92,195,
/* 0x01a0 */  72,137, 92, 36,240, 72,137,108, 36,248, 72,131,236, 24,137,209,
/* 0x01b0 */ 189,  0,  0,  0,  0,187,  0,  0,  0,  0, 72,184,255,255,255,255,
/* 0x01c0 */   1,  0,  0,  0, 72, 35,  7, 72,186,  1,  0,  0,  0,  1,  0,  0,
/* 0x01d0 */   0, 72, 57,208,117,122, 72,139, 71, 40, 72,137,195, 72,  3, 95,
/* 0x01e0 */  16, 72,  1,243, 72, 59, 71, 32,117, 11,137,216,247,216, 33,200,
/* 0x01f0 */ 131,248,  5,119, 50,189,  1,  0,  0,  0, 65,185,  0,  0,  0,  0,
/* 0x0200 */  65,184,255,255,255,255,185, 34,  0,  0,  0,186,  3,  0,  0,  0,
/* 0x0210 */ 190,  0, 16,  0,  0,191,  0,  0,  0,  0,232,  0,  0,  0,  0, 72,
/* 0x0220 */ 137,195, 72,133,192,116, 36,199,  3, 15,  5, 95, 94,102,199, 67,
/* 0x0230 */   4, 90,195,133,237,116, 25,186,  5,  0,  0,  0,190,  6,  0,  0,
/* 0x0240 */   0, 72,137,223,232,  0,  0,  0,  0,235,  5,187,  0,  0,  0,  0,
/* 0x0250 */  72,137,216, 72,139, 92, 36,  8, 72,139,108, 36, 16, 72,131,196,
/* 0x0260 */  24,195, 65, 87, 65, 86, 65, 85, 65, 84, 85, 83, 72,131,236,120,
/* 0x0270 */  72,137,124, 36, 56, 73,137,246, 72,137, 84, 36, 48,139,  6, 73,
/* 0x0280 */ 137,245, 73, 41,197, 72,131,192, 16, 72,137, 68, 36, 40, 65,185,
/* 0x0290 */   0,  0,  0,  0, 65,184,255,255,255,255,185, 34,  0,  0,  0,186,
/* 0x02a0 */   3,  0,  0,  0, 72,137,198,191,  0,  0,  0,  0,232,  0,  0,  0,
/* 0x02b0 */   0, 72,137, 68, 36, 32, 72,139, 84, 36, 40, 76,137,238, 72,137,
/* 0x02c0 */ 199,232,  0,  0,  0,  0, 72,139, 68, 36, 32, 76, 41,232, 73,  1,
/* 0x02d0 */ 198, 69,139,102, 12, 72,139, 68, 36, 32, 77,141,100,  4, 24, 65,
/* 0x02e0 */ 139,  4, 36, 72,137, 68, 36, 80, 76,137,108, 36, 88, 72,137, 68,
/* 0x02f0 */  36, 96, 76,137,108, 36,104, 65,139, 52, 36,186,  3,  0,  0,  0,
/* 0x0300 */  76,137,239,232,  0,  0,  0,  0, 65,139, 68, 36,  4, 72,131,192,
/* 0x0310 */  12, 72,137, 68, 36, 64, 76,137,100, 36, 72, 72,137, 68, 36, 80,
/* 0x0320 */  76,137,100, 36, 88, 72,141,116, 36, 96, 72,141,124, 36, 80, 72,
/* 0x0330 */ 139, 84, 36, 56,232, 87,253,255,255, 65,139, 68, 36,  4, 77,141,
/* 0x0340 */ 100,  4, 12, 65, 15,183,109, 56, 73,141, 93, 64, 65,191,  0,  0,
/* 0x0350 */   0,  0,133,237,116, 20,131, 59,  1, 15,148,192, 15,182,192, 65,
/* 0x0360 */   1,199, 72,131,195, 56,255,205,117,236, 65, 15,183,109, 56, 73,
/* 0x0370 */ 141, 93, 64, 72,199, 68, 36, 24,  0,  0,  0,  0, 65,131,255,  2,
/* 0x0380 */ 119, 11, 65,139, 70, 12, 72,137, 68, 36, 24,235, 35,139, 75,  4,
/* 0x0390 */ 131,225,  7,193,225,  2,186, 64, 98, 81,115,211,234,131,226,  7,
/* 0x03a0 */  72,139,115, 40, 76,137,239, 72,  3,123, 16,232,  0,  0,  0,  0,
/* 0x03b0 */ 199, 68, 36, 20,  0,  0,  0,  0, 72,199, 68, 36,  8,  0,  0,  0,
/* 0x03c0 */   0,133,237, 15,132, 48,  1,  0,  0,131, 59,  1, 15,133, 27,  1,
/* 0x03d0 */   0,  0,246, 67,  4,  2, 15,133, 17,  1,  0,  0,255, 68, 36, 20,
/* 0x03e0 */ 131,124, 36, 20,  1,117, 10, 65,131,255,  2, 15,135,252,  0,  0,
/* 0x03f0 */   0, 65,139,  4, 36, 72,137, 68, 36, 96, 76,137,232, 72,  3, 67,
/* 0x0400 */  16, 72,137, 68, 36,104, 72,139,124, 36, 24, 72,129,199,255, 15,
/* 0x0410 */   0,  0, 72,129,231,  0,240,255,255, 72,139,115, 40, 72, 41,254,
/* 0x0420 */  72,  1,199, 65,185,  0,  0,  0,  0, 65,184,255,255,255,255,185,
/* 0x0430 */  50,  0,  0,  0,186,  3,  0,  0,  0,232,  0,  0,  0,  0, 72,139,
/* 0x0440 */  68, 36, 24, 72,  1, 68, 36,104, 65,139, 68, 36,  4, 72,131,192,
/* 0x0450 */  12, 72,137, 68, 36, 80, 76,137,100, 36, 88, 72,139, 84, 36, 56,
/* 0x0460 */  72,141,116, 36, 96, 72,141,124, 36, 80,232, 33,252,255,255, 65,
/* 0x0470 */ 139,  4, 36, 72, 59, 67, 40,115, 27, 72,139, 83, 40, 72, 41,194,
/* 0x0480 */  72,139,123, 16, 72,  1,199, 76,  1,239,190,  0,  0,  0,  0,232,
/* 0x0490 */   0,  0,  0,  0, 72,199, 68, 36, 24,  0,  0,  0,  0, 72,131,124,
/* 0x04a0 */  36,  8,  0,117, 27,246, 67,  4,  1,116, 21,186,255, 15,  0,  0,
/* 0x04b0 */  76,137,238, 72,137,223,232,229,252,255,255, 72,137, 68, 36,  8,
/* 0x04c0 */ 139, 75,  4,131,225,  7,193,225,  2,186, 64, 98, 81,115,211,234,
/* 0x04d0 */ 131,226,  7, 72,139,115, 40, 76,137,239, 72,  3,123, 16,232,  0,
/* 0x04e0 */   0,  0,  0, 65,139, 68, 36,  4, 78,141,100, 32, 12, 72,131,195,
/* 0x04f0 */  56,255,205, 15,133,208,254,255,255, 65,139, 94,  4, 76,  1,235,
/* 0x0500 */  72,139,116, 36, 40, 72,139,124, 36, 32,232,  0,  0,  0,  0, 72,
/* 0x0510 */ 139, 68, 36, 48, 72,139, 80, 16, 72,139,112,  8,139, 56,255,211,
/* 0x0520 */  72,139, 68, 36,  8, 72,131,196,120, 91, 93, 65, 92, 65, 93, 65,
/* 0x0530 */  94, 65, 95,195, 85, 72,137,229, 83, 68,137,192, 15,182,196,133,
/* 0x0540 */ 192,116, 97, 80, 68,137,192,193,232, 16, 80,255, 49, 82,232, 81,
/* 0x0550 */   0,  0,  0, 95, 94, 90, 89,131,249, 73,117, 68, 83, 87, 72,141,
/* 0x0560 */  76, 55,253, 94, 86, 91,235, 47, 72, 57,206,115, 50, 86, 94,172,
/* 0x0570 */  60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,232,
/* 0x0580 */  60,  1,119,228, 72, 57,206,115, 22, 86,173, 40,208,117,223, 95,
/* 0x0590 */  15,200, 41,248,  1,216,171, 72, 57,206,115,  3,172,235,223, 91,
/* 0x05a0 */ 195, 91, 93,195, 81, 72,  1,254, 86, 72,137,254, 82, 72,137,215,
/* 0x05b0 */  49,219, 49,201, 72,131,205,255,235, 78,139, 30, 72,131,238,252,
/* 0x05c0 */  17,219,138, 22,243,195,  1,219,116,240,243,195, 72,141,  4, 47,
/* 0x05d0 */ 131,249,  5,138, 16,118, 32,131,253,252,119, 27,131,233,  4,139,
/* 0x05e0 */  16, 72,131,192,  4,131,233,  4,137, 23, 72,141,127,  4,115,239,
/* 0x05f0 */ 131,193,  4,138, 16,116, 15, 72,255,192,136, 23,255,201,138, 16,
/* 0x0600 */  72,141,127,  1,117,241,243,195,252, 88, 72, 41,199, 88, 89,137,
/* 0x0610 */  57, 72, 41,240, 91, 93,195, 65,128,248,  8, 15,133,218,  0,  0,
/* 0x0620 */   0,235,  8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117,
/* 0x0630 */  10,139, 30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,
/* 0x0640 */ 235, 18,255,200,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0650 */ 138, 22, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0660 */ 138, 22, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0670 */ 138, 22,115,206,131,232,  3,114, 29,193,224,  8, 15,182,210,  9,
/* 0x0680 */ 208, 72,255,198,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72,
/* 0x0690 */  99,232,114, 67,235, 14,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x06a0 */  17,219,114, 51,255,193,  1,219,117,  8,139, 30, 72,131,238,252,
/* 0x06b0 */  17,219,114, 35,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x06c0 */ 138, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,
/* 0x06d0 */ 115,226,131,193,  2,235, 16,  1,219,117, 10,139, 30, 72,131,238,
/* 0x06e0 */ 252, 17,219,138, 22, 17,201, 72,129,253,  0,251,255,255,131,209,
/* 0x06f0 */   2,232,  0,  0,  0,  0,233, 48,255,255,255, 87, 94, 65,128,248,
/* 0x0700 */   5, 15,133,204,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,
/* 0x0710 */ 199,138, 22,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138,
/* 0x0720 */  22,114,230,141, 65,  1,235, 18,255,200,  1,219,117, 10,139, 30,
/* 0x0730 */  72,131,238,252, 17,219,138, 22, 17,192,  1,219,117, 10,139, 30,
/* 0x0740 */  72,131,238,252, 17,219,138, 22, 17,192,  1,219,117, 10,139, 30,
/* 0x0750 */  72,131,238,252, 17,219,138, 22,115,206,131,232,  3,114, 27,193,
/* 0x0760 */ 224,  8, 15,182,210,  9,208, 72,255,198,131,240,255, 15,132,  0,
/* 0x0770 */   0,  0,  0,209,248, 72, 99,232,235, 14,  1,219,117, 10,139, 30,
/* 0x0780 */  72,131,238,252, 17,219,138, 22, 17,201,  1,219,117, 10,139, 30,
/* 0x0790 */  72,131,238,252, 17,219,138, 22, 17,201,117, 35,255,193,  1,219,
/* 0x07a0 */ 117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,201,  1,219,
/* 0x07b0 */ 117,  8,139, 30, 72,131,238,252, 17,219,115,226,131,193,  2, 72,
/* 0x07c0 */ 129,253,  0,251,255,255,131,209,  1,232,  0,  0,  0,  0,233, 62,
/* 0x07d0 */ 255,255,255, 87, 94, 65,128,248,  2, 15,133,182,  0,  0,  0,235,
/* 0x07e0 */   8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139,
/* 0x07f0 */  30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,  1,219,
/* 0x0800 */ 117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,192,  1,219,
/* 0x0810 */ 117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,224,131,232,
/* 0x0820 */   3,114, 23,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,
/* 0x0830 */ 255, 15,132,  0,  0,  0,  0, 72, 99,232,141, 65,  1,  1,219,117,
/* 0x0840 */  10,139, 30, 72,131,238,252, 17,219,138, 22, 17,201,  1,219,117,
/* 0x0850 */  10,139, 30, 72,131,238,252, 17,219,138, 22, 17,201,117, 35,137,
/* 0x0860 */ 193,131,192,  2,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0870 */ 138, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,
/* 0x0880 */ 115,226, 72,129,253,  0,243,255,255, 17,193,232,  0,  0,  0,  0,
/* 0x0890 */ 233, 84,255,255,255, 87, 94, 91, 93, 72,141, 61,  0,  0,  0,  0,
/* 0x08a0 */  94, 72,141, 84, 36, 16,232,  0,  0,  0,  0, 85, 94, 83, 95, 91,
/* 0x08b0 */  93, 80,104, 11,  0,  0,  0, 88,195, 89, 72,137,240, 72, 41,200,
/* 0x08c0 */  90, 72, 41,215, 89,137, 57, 91, 93,195,204,195, 87,137,240,137,
/* 0x08d0 */ 209,243,170, 88,195, 87,137,208,131,224,  7, 72,137,209, 72,193,
/* 0x08e0 */ 233,  3,243, 72,165,145,243,164, 88,195,106,  9, 73,137,202, 88,
/* 0x08f0 */  15,  5,195,106, 60,235,248,106, 11,235,244,106, 10,235,240,106,
/* 0x0900 */   1, 88, 15,  5,195, 65,128,248, 14, 15,133,  0,  0,  0,  0, 85,
/* 0x0910 */  72,137,229, 68,139,  9, 73,137,208, 72,137,242, 72,141,119,  2,
/* 0x0920 */  86,138,  7,255,202,136,193, 36,  7,192,233,  3, 72,199,195,  0,
/* 0x0930 */ 253,255,255, 72,211,227,136,193, 72,141,156, 92,136,241,255,255,
/* 0x0940 */  72,131,227,192,106,  0, 72, 57,220,117,249, 83, 72,141,123,  8,
/* 0x0950 */ 138, 78,255,255,202,136, 71,  2,136,200,192,233,  4,136, 79,  1,
/* 0x0960 */  36, 15,136,  7, 72,141, 79,252, 80, 65, 87, 72,141, 71,  4, 69,
/* 0x0970 */  49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65,
/* 0x0980 */  84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,
/* 0x0990 */   0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,195, 68,137,
/* 0x09a0 */  76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,
/* 0x09b0 */ 255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,
/* 0x09c0 */ 240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,
/* 0x09d0 */ 199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,
/* 0x09e0 */ 199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,
/* 0x09f0 */ 199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,
/* 0x0a00 */ 184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,  0, 65,
/* 0x0a10 */  57,255,115, 19, 72,139, 92, 36,216,137,200,255,193, 57,249,102,
/* 0x0a20 */ 199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,208, 69, 49,
/* 0x0a30 */ 210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,231,
/* 0x0a40 */  15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,
/* 0x0a50 */ 255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124, 36,228, 15,
/* 0x0a60 */ 131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139,
/* 0x0a70 */  84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,
/* 0x0a80 */ 137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,255,255,  0,
/* 0x0a90 */  76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,
/* 0x0aa0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0ab0 */  65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0ac0 */  65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,
/* 0x0ad0 */   0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,
/* 0x0ae0 */   0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,
/* 0x0af0 */ 139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76,
/* 0x0b00 */  36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,200,
/* 0x0b10 */   6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,
/* 0x0b20 */   0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,
/* 0x0b30 */   1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,129,251,
/* 0x0b40 */ 255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119,
/* 0x0b50 */  26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,
/* 0x0b60 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,
/* 0x0b70 */   2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x0b80 */  57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,
/* 0x0b90 */ 193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,
/* 0x0ba0 */ 116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x0bb0 */ 141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,  0,  2,  0,
/* 0x0bc0 */   0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,255,255,235,
/* 0x0bd0 */ 120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,255,
/* 0x0be0 */ 255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,
/* 0x0bf0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x0c00 */  65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202,
/* 0x0c10 */  15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,
/* 0x0c20 */   1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235,161,
/* 0x0c30 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,
/* 0x0c40 */ 102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,137,
/* 0x0c50 */ 248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124, 36,200,  3,
/* 0x0c60 */ 127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139,
/* 0x0c70 */  84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,131,124, 36,
/* 0x0c80 */ 200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,
/* 0x0c90 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 72,139, 68,
/* 0x0ca0 */  36,216, 65,129,251,255,255,255,  0,102, 65,137, 17, 72,141, 52,
/* 0x0cb0 */  88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,
/* 0x0cc0 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,
/* 0x0cd0 */ 128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x0ce0 */  65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76,
/* 0x0cf0 */  36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,193,248,  5,
/* 0x0d00 */ 141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,134,128,  1,
/* 0x0d10 */   0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188, 15,159,192,
/* 0x0d20 */  73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,
/* 0x0d30 */   2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x0d40 */  41,194, 65,129,251,255,255,255,  0,102,137,150,128,  1,  0,  0,
/* 0x0d50 */ 119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,
/* 0x0d60 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,152,
/* 0x0d70 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x0d80 */  57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,
/* 0x0d90 */ 195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,141,  4,  2,
/* 0x0da0 */ 102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,
/* 0x0db0 */ 129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,
/* 0x0dc0 */ 132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0dd0 */  72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,216,
/* 0x0de0 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,
/* 0x0df0 */ 200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,102,
/* 0x0e00 */ 137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124,
/* 0x0e10 */  36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,137,
/* 0x0e20 */  68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,
/* 0x0e30 */ 248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195,
/* 0x0e40 */  65, 41,194,137,208,102,193,232,  5,102, 41,194,102,137,150,224,
/* 0x0e50 */   1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x0e60 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,
/* 0x0e70 */ 150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0,
/* 0x0e80 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x0e90 */ 194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x0ea0 */ 202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,
/* 0x0eb0 */   0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,
/* 0x0ec0 */ 139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x0ed0 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x0ee0 */ 137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,
/* 0x0ef0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x0f00 */   9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x0f10 */ 183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,
/* 0x0f20 */   0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,200,  1,  0,
/* 0x0f30 */   0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,208,102,
/* 0x0f40 */ 193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,200,  1,  0,
/* 0x0f50 */   0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,
/* 0x0f60 */ 192, 68,137,116, 36,196, 65,137,198, 49,192,131,124, 36,200,  6,
/* 0x0f70 */  76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,  0,  0,141,
/* 0x0f80 */  68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,  0,119, 26,
/* 0x0f90 */  76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x0fa0 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,
/* 0x0fb0 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 39, 65,
/* 0x0fc0 */ 137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,
/* 0x0fd0 */   4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,
/* 0x0fe0 */ 141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x0ff0 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102, 65,137, 17,
/* 0x1000 */ 119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,
/* 0x1010 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,
/* 0x1020 */   2, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x1030 */ 115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0,
/* 0x1040 */  41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68,
/* 0x1050 */  36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,
/* 0x1060 */   3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1070 */ 232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102,
/* 0x1080 */  41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,
/* 0x1090 */ 189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,255,  0, 73,
/* 0x10a0 */ 141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,
/* 0x10b0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x10c0 */ 183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,194, 65, 57,
/* 0x10d0 */ 194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,
/* 0x10e0 */ 248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,
/* 0x10f0 */ 137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,102,137, 14,
/* 0x1100 */ 255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,197,
/* 0x1110 */  68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68,
/* 0x1120 */  36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139,
/* 0x1130 */  92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,
/* 0x1140 */ 141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,
/* 0x1150 */ 129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,
/* 0x1160 */ 132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x1170 */  72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,232, 11, 15,
/* 0x1180 */ 183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,
/* 0x1190 */   0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,102,137,  6,
/* 0x11a0 */ 235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 71,141,
/* 0x11b0 */  68,  0,  1,102, 41,194,102,137, 22,255,203,117,143, 65,131,232,
/* 0x11c0 */  64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,
/* 0x11d0 */ 230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,248, 13,141,
/* 0x11e0 */ 112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,
/* 0x11f0 */ 230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,
/* 0x1200 */ 138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,255,255,255,
/* 0x1210 */   0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,
/* 0x1220 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,209,235,
/* 0x1230 */  69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,255,
/* 0x1240 */ 206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,
/* 0x1250 */   0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,
/* 0x1260 */   0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0, 77,141,  4,
/* 0x1270 */  65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,
/* 0x1280 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x1290 */  16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x12a0 */ 115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,
/* 0x12b0 */   5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,
/* 0x12c0 */ 137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,
/* 0x12d0 */ 102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,198,116, 64,
/* 0x12e0 */ 131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,248,
/* 0x12f0 */  68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,255,205,
/* 0x1300 */  68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,146,
/* 0x1310 */ 192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,247,255,255,
/* 0x1320 */  65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,
/* 0x1330 */   0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,
/* 0x1340 */ 248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,
/* 0x1350 */   1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95,
/* 0x1360 */  65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,
/* 0x1370 */   0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,
/* 0x1380 */ 137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137,
/* 0x1390 */  68, 36,232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,
/* 0x13a0 */ 137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,
/* 0x13b0 */   1,211,224, 72,139, 76, 36,240,255,200,137, 68, 36,208, 15,182,
/* 0x13c0 */   7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199,
/* 0x13d0 */  68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199,
/* 0x13e0 */  68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,
/* 0x13f0 */ 204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,
/* 0x1400 */ 141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,
/* 0x1410 */ 137,200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,
/* 0x1420 */ 124, 36,248,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,
/* 0x1430 */ 252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7,
/* 0x1440 */  65,193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,
/* 0x1450 */ 227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212,
/* 0x1460 */  72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,
/* 0x1470 */ 184, 72, 99,108, 36,184, 72,137,216, 72,193,224,  4, 72,  1,232,
/* 0x1480 */  65,129,251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231,
/* 0x1490 */  15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x14a0 */   8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232,
/* 0x14b0 */  11, 15,183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0,
/* 0x14c0 */  65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,
/* 0x14d0 */ 182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65,
/* 0x14e0 */  15,182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,
/* 0x14f0 */ 185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,
/* 0x1500 */   3,  0,  0,131,124, 36,200,  6,137,192, 76,141,140, 67,108, 14,
/* 0x1510 */   0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248,
/* 0x1520 */  68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,
/* 0x1530 */   0,  1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,
/* 0x1540 */   4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,
/* 0x1550 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1560 */   9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11,
/* 0x1570 */  15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,
/* 0x1580 */   8,  0,  0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102,
/* 0x1590 */  65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,
/* 0x15a0 */ 194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,
/* 0x15b0 */ 102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0,
/* 0x15c0 */  15,142, 97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112,
/* 0x15d0 */  72, 99,198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26,
/* 0x15e0 */  76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x15f0 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,
/* 0x1600 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,
/* 0x1610 */ 137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,
/* 0x1620 */   2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,
/* 0x1630 */ 193,232,  5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136,
/* 0x1640 */  72,139, 76, 36,232, 68,137,248, 65,255,199, 65,137,245, 64,136,
/* 0x1650 */  52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,
/* 0x1660 */   0,233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,
/* 0x1670 */   3,131,232,  6,131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,
/* 0x1680 */ 233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1690 */   5,102, 41,194, 72,139, 68, 36,216, 65,129,251,255,255,255,  0,
/* 0x16a0 */ 102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,
/* 0x16b0 */   6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x16c0 */ 199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232,
/* 0x16d0 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,
/* 0x16e0 */   0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,
/* 0x16f0 */ 137,116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,192,137, 76,
/* 0x1700 */  36,192,102,137,134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,
/* 0x1710 */ 137, 84, 36,188, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4,
/* 0x1720 */  64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1730 */ 137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,
/* 0x1740 */ 102,137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,
/* 0x1750 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1760 */  65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x1770 */  15,183,202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,
/* 0x1780 */ 184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,
/* 0x1790 */ 200,193,248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139,
/* 0x17a0 */  68, 36,216, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,
/* 0x17b0 */ 104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,
/* 0x17c0 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,
/* 0x17d0 */ 224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x17e0 */  65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,
/* 0x17f0 */ 133,255, 66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,
/* 0x1800 */   5,  0,  0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,
/* 0x1810 */ 159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240,
/* 0x1820 */  68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,
/* 0x1830 */ 216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1840 */ 102, 41,194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65,
/* 0x1850 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x1860 */ 251,255,255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,
/* 0x1870 */ 231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1880 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,
/* 0x1890 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32,
/* 0x18a0 */  65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x18b0 */ 102,137,134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0,
/* 0x18c0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,
/* 0x18d0 */ 129,251,255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76,
/* 0x18e0 */  57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x18f0 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0,
/* 0x1900 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1910 */  29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x1920 */   2,102,137,134,200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,
/* 0x1930 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,
/* 0x1940 */ 188,102,137,150,200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,
/* 0x1950 */ 139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,196, 65,137,198,
/* 0x1960 */  49,192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,
/* 0x1970 */ 129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,
/* 0x1980 */ 251,255,255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0,
/* 0x1990 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x19a0 */ 194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x19b0 */ 193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,
/* 0x19c0 */ 237, 41,200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68,
/* 0x19d0 */  36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195,
/* 0x19e0 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,
/* 0x19f0 */ 255,255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,
/* 0x1a00 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1a10 */  65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,
/* 0x1a20 */ 202, 15,175,193, 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,
/* 0x1a30 */   0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1a40 */  65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,
/* 0x1a50 */   1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195,
/* 0x1a60 */  65, 41,194,137,208,102,193,232,  5, 77,141,129,  4,  2,  0,  0,
/* 0x1a70 */  65,189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,
/* 0x1a80 */   8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,
/* 0x1a90 */ 129,251,255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,
/* 0x1aa0 */ 132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x1ab0 */  72,255,199, 65,  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,
/* 0x1ac0 */ 183,209, 15,175,194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,
/* 0x1ad0 */   0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,102,137,  6,235,
/* 0x1ae0 */  22, 65, 41,195, 65, 41,194,137,200,102,193,232,  5,141,108, 45,
/* 0x1af0 */   1,102, 41,193,102,137, 14,255,203,117,145,184,  1,  0,  0,  0,
/* 0x1b00 */  68,137,201,211,224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,
/* 0x1b10 */ 143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,
/* 0x1b20 */ 253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0,
/* 0x1b30 */  72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,
/* 0x1b40 */   0,  0,  0, 73, 99,192, 65,129,251,255,255,255,  0, 73,141, 52,
/* 0x1b50 */  65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,
/* 0x1b60 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 22,
/* 0x1b70 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1b80 */  24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,
/* 0x1b90 */   5,141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,
/* 0x1ba0 */ 208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,
/* 0x1bb0 */ 255,203,117,143, 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,
/* 0x1bc0 */ 142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,248, 65,131,
/* 0x1bd0 */ 206,  2, 65,131,248, 13,141,112,255,127, 35,137,241, 72,139, 92,
/* 0x1be0 */  36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,242, 72,141,
/* 0x1bf0 */  20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,
/* 0x1c00 */ 251, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,
/* 0x1c10 */   1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1c20 */ 199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69,
/* 0x1c30 */  41,218, 65,131,206,  1,255,206,117,199, 76,139, 76, 36,216, 65,
/* 0x1c40 */ 193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,
/* 0x1c50 */ 189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,
/* 0x1c60 */ 255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,
/* 0x1c70 */   0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1c80 */ 199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,
/* 0x1c90 */ 202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,
/* 0x1ca0 */   0,  1,219, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235,
/* 0x1cb0 */  26, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141, 92, 27,
/* 0x1cc0 */   1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,237,255,206,
/* 0x1cd0 */ 117,136, 65,255,198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,
/* 0x1ce0 */ 139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,
/* 0x1cf0 */ 137,248, 65,255,199,255,205, 68,136, 44,  2, 15,149,194, 49,192,
/* 0x1d00 */  68, 59,124, 36,228, 15,146,192,133,194,117,211, 68, 59,124, 36,
/* 0x1d10 */ 228, 15,130, 69,247,255,255, 65,129,251,255,255,255,  0,119, 22,
/* 0x1d20 */  76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,
/* 0x1d30 */   0,235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,
/* 0x1d40 */ 240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65,
/* 0x1d50 */  92, 65, 93, 65, 94, 65, 95, 72,139,117,248, 72,139,125, 16,139,
/* 0x1d60 */  75,  4, 72,  1,206,139, 19, 72,  1,215,201,235,  2, 87, 94,  0,
/* 0x1d70 */  46,115,121,109,116, 97, 98,  0, 46,115,116,114,116, 97, 98,  0,
/* 0x1d80 */  46,115,104,115,116,114,116, 97, 98,  0, 46,114,101,108, 97, 83,
/* 0x1d90 */  79, 95, 77, 65, 73, 78,  0, 69, 88, 80, 95, 72, 69, 65, 68,  0,
/* 0x1da0 */  69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,101,108, 97, 78, 82,
/* 0x1db0 */  86, 50, 69,  0, 46,114,101,108, 97, 78, 82, 86, 50, 68,  0, 46,
/* 0x1dc0 */ 114,101,108, 97, 78, 82, 86, 50, 66,  0, 46,114,101,108, 97, 83,
/* 0x1dd0 */  79, 95, 72, 69, 65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0,
/* 0x1de0 */  83, 79, 95, 84, 65, 73, 76,  0, 46,114,101,108, 97, 76, 90, 77,
/* 0x1df0 */  65, 95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1e00 */  49, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0, 76, 90,
/* 0x1e10 */  77, 65, 95, 68, 69, 67, 51, 48,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e60 */  32,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e70 */   0,  0,  0,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e80 */ 244,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1e90 */  16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ea0 */  27,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1eb0 */   0,  0,  0,  0,  0,  0,  0,  0,136, 38,  0,  0,  0,  0,  0,  0,
/* 0x1ec0 */  32,  1,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  1,  0,  0,  0,
/* 0x1ed0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ee0 */  40,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ef0 */   0,  0,  0,  0,  0,  0,  0,  0, 52,  5,  0,  0,  0,  0,  0,  0,
/* 0x1f00 */ 213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f10 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f20 */  49,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f30 */   0,  0,  0,  0,  0,  0,  0,  0,  9,  6,  0,  0,  0,  0,  0,  0,
/* 0x1f40 */  14,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f50 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f60 */  63,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f70 */   0,  0,  0,  0,  0,  0,  0,  0, 23,  6,  0,  0,  0,  0,  0,  0,
/* 0x1f80 */ 230,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1f90 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1fa0 */  58,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1fb0 */   0,  0,  0,  0,  0,  0,  0,  0,168, 39,  0,  0,  0,  0,  0,  0,
/* 0x1fc0 */  48,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  5,  0,  0,  0,
/* 0x1fd0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x1fe0 */  74,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1ff0 */   0,  0,  0,  0,  0,  0,  0,  0,253,  6,  0,  0,  0,  0,  0,  0,
/* 0x2000 */ 216,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2010 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2020 */  69,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2030 */   0,  0,  0,  0,  0,  0,  0,  0,216, 39,  0,  0,  0,  0,  0,  0,
/* 0x2040 */  48,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  7,  0,  0,  0,
/* 0x2050 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2060 */  85,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2070 */   0,  0,  0,  0,  0,  0,  0,  0,213,  7,  0,  0,  0,  0,  0,  0,
/* 0x2080 */ 194,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2090 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x20a0 */  80,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x20b0 */   0,  0,  0,  0,  0,  0,  0,  0,  8, 40,  0,  0,  0,  0,  0,  0,
/* 0x20c0 */  48,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  9,  0,  0,  0,
/* 0x20d0 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x20e0 */  96,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x20f0 */   0,  0,  0,  0,  0,  0,  0,  0,151,  8,  0,  0,  0,  0,  0,  0,
/* 0x2100 */  34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2110 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2120 */  91,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2130 */   0,  0,  0,  0,  0,  0,  0,  0, 56, 40,  0,  0,  0,  0,  0,  0,
/* 0x2140 */  48,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0, 11,  0,  0,  0,
/* 0x2150 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2160 */ 104,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2170 */   0,  0,  0,  0,  0,  0,  0,  0,185,  8,  0,  0,  0,  0,  0,  0,
/* 0x2180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2190 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21a0 */ 113,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21b0 */   0,  0,  0,  0,  0,  0,  0,  0,185,  8,  0,  0,  0,  0,  0,  0,
/* 0x21c0 */  76,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21d0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21e0 */ 126,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21f0 */   0,  0,  0,  0,  0,  0,  0,  0,  5,  9,  0,  0,  0,  0,  0,  0,
/* 0x2200 */ 100,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2210 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2220 */ 121,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2230 */   0,  0,  0,  0,  0,  0,  0,  0,104, 40,  0,  0,  0,  0,  0,  0,
/* 0x2240 */  24,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0, 15,  0,  0,  0,
/* 0x2250 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2260 */ 137,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2270 */   0,  0,  0,  0,  0,  0,  0,  0,105,  9,  0,  0,  0,  0,  0,  0,
/* 0x2280 */ 247,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2290 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22a0 */ 148,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22b0 */   0,  0,  0,  0,  0,  0,  0,  0, 96, 19,  0,  0,  0,  0,  0,  0,
/* 0x22c0 */ 247,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22d0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22e0 */ 159,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22f0 */   0,  0,  0,  0,  0,  0,  0,  0, 87, 29,  0,  0,  0,  0,  0,  0,
/* 0x2300 */  24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2310 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2320 */  17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2330 */   0,  0,  0,  0,  0,  0,  0,  0,111, 29,  0,  0,  0,  0,  0,  0,
/* 0x2340 */ 170,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2350 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2360 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2370 */   0,  0,  0,  0,  0,  0,  0,  0,224, 35,  0,  0,  0,  0,  0,  0,
/* 0x2380 */  88,  2,  0,  0,  0,  0,  0,  0, 22,  0,  0,  0, 14,  0,  0,  0,
/* 0x2390 */   8,  0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x23a0 */   9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23b0 */   0,  0,  0,  0,  0,  0,  0,  0, 56, 38,  0,  0,  0,  0,  0,  0,
/* 0x23c0 */  78,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23d0 */   1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x2400 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2410 */   0,  0,  0,  0,  3,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2420 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 13,  0,
/* 0x2430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2440 */   0,  0,  0,  0,  3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2450 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x2460 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2470 */   0,  0,  0,  0,  3,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  7,  0,
/* 0x2490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24a0 */   0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,
/* 0x24c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24d0 */   0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 15,  0,
/* 0x24f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,
/* 0x2520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2530 */   1,  0,  0,  0, 16,  0, 14,  0, 62,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */   0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0, 16,  0, 14,  0,
/* 0x2550 */  28,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2560 */  15,  0,  0,  0, 16,  0, 14,  0, 49,  0,  0,  0,  0,  0,  0,  0,
/* 0x2570 */   0,  0,  0,  0,  0,  0,  0,  0, 23,  0,  0,  0, 16,  0, 14,  0,
/* 0x2580 */  49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2590 */  28,  0,  0,  0, 18,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0, 16,  0, 14,  0,
/* 0x25b0 */  17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  39,  0,  0,  0, 16,  0, 14,  0, 70,  0,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */   0,  0,  0,  0,  0,  0,  0,  0, 45,  0,  0,  0, 16,  0, 14,  0,
/* 0x25e0 */  19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25f0 */  52,  0,  0,  0, 16,  0, 14,  0, 58,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */   0,  0,  0,  0,  0,  0,  0,  0, 57,  0,  0,  0, 16,  0, 14,  0,
/* 0x2610 */  66,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2620 */  66,  0,  0,  0, 18,  0,  1,  0, 34,  2,  0,  0,  0,  0,  0,  0,
/* 0x2630 */ 210,  2,  0,  0,  0,  0,  0,  0,  0,109,117,110,109, 97,112,  0,
/* 0x2640 */ 109,101,109, 99,112,121,  0, 79, 95, 66, 73, 78, 70, 79,  0,109,
/* 0x2650 */ 109, 97,112,  0,101,111,102,  0,102, 95,105,110,116, 51,  0,119,
/* 0x2660 */ 114,105,116,101,  0,109,101,109,115,101,116,  0,101,120,105,116,
/* 0x2670 */   0,109,112,114,111,116,101, 99,116,  0,117,112,120, 95,115,111,
/* 0x2680 */  95,109, 97,105,110,  0,  0,  0, 19,  0,  0,  0,  0,  0,  0,  0,
/* 0x2690 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x26a0 */  76,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x26b0 */ 252,255,255,255,255,255,255,255,219,  1,  0,  0,  0,  0,  0,  0,
/* 0x26c0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x26d0 */   5,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x26e0 */ 252,255,255,255,255,255,255,255,109,  2,  0,  0,  0,  0,  0,  0,
/* 0x26f0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2700 */ 130,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 15,  0,  0,  0,
/* 0x2710 */ 252,255,255,255,255,255,255,255,196,  2,  0,  0,  0,  0,  0,  0,
/* 0x2720 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2730 */ 108,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x2740 */ 252,255,255,255,255,255,255,255,250,  3,  0,  0,  0,  0,  0,  0,
/* 0x2750 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2760 */  80,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 21,  0,  0,  0,
/* 0x2770 */ 252,255,255,255,255,255,255,255,159,  4,  0,  0,  0,  0,  0,  0,
/* 0x2780 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2790 */ 203,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 14,  0,  0,  0,
/* 0x27a0 */ 252,255,255,255,255,255,255,255,219,  0,  0,  0,  0,  0,  0,  0,
/* 0x27b0 */   2,  0,  0,  0,  1,  0,  0,  0,148,  0,  0,  0,  0,  0,  0,  0,
/* 0x27c0 */ 114,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x27d0 */ 252,255,255,255,255,255,255,255,205,  0,  0,  0,  0,  0,  0,  0,
/* 0x27e0 */   2,  0,  0,  0,  1,  0,  0,  0,148,  0,  0,  0,  0,  0,  0,  0,
/* 0x27f0 */ 114,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x2800 */ 252,255,255,255,255,255,255,255,183,  0,  0,  0,  0,  0,  0,  0,
/* 0x2810 */   2,  0,  0,  0,  1,  0,  0,  0,148,  0,  0,  0,  0,  0,  0,  0,
/* 0x2820 */  94,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x2830 */ 252,255,255,255,255,255,255,255,  5,  0,  0,  0,  0,  0,  0,  0,
/* 0x2840 */   2,  0,  0,  0,  3,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2850 */  16,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 24,  0,  0,  0,
/* 0x2860 */ 252,255,255,255,255,255,255,255,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x2870 */   2,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x2890 */  52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,
/* 0x28a0 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x28b0 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x28c0 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28d0 */  32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28e0 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x28f0 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 83, 79,
/* 0x2900 */  95, 77, 65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48, 52,102, 52,
/* 0x2910 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x2920 */  52, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x2930 */  69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x2940 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 51, 52, 32, 32, 50,
/* 0x2950 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x2960 */  50, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32,
/* 0x2970 */  48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 48, 57, 32, 32,
/* 0x2980 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2990 */  32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x29a0 */  32, 48,101, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 49, 55,
/* 0x29b0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x29c0 */  10, 32, 32, 52, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32,
/* 0x29d0 */  32, 32, 32, 48,100, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54,
/* 0x29e0 */ 102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x29f0 */  84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x2a00 */  32, 32, 32, 32, 32, 48, 99, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2a10 */  48, 55,100, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2a20 */  69, 78, 84, 83, 10, 32, 32, 54, 32, 83, 79, 95, 72, 69, 65, 68,
/* 0x2a30 */  32, 32, 32, 32, 32, 32, 32, 48, 50, 50, 32, 32, 48, 32, 32, 48,
/* 0x2a40 */  32, 32, 48, 56, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2a50 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,112,116,114, 95, 78,
/* 0x2a60 */  69, 88, 84, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2a70 */  32, 32, 48, 56, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2a80 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 83, 79, 95, 84, 65,
/* 0x2a90 */  73, 76, 32, 32, 32, 32, 32, 32, 32, 48, 52, 99, 32, 32, 48, 32,
/* 0x2aa0 */  32, 48, 32, 32, 48, 56, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2ab0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77,
/* 0x2ac0 */  65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 54, 52, 32, 32,
/* 0x2ad0 */  48, 32, 32, 48, 32, 32, 48, 57, 48, 53, 32, 32, 50, 42, 42, 48,
/* 0x2ae0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76,
/* 0x2af0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57,102,
/* 0x2b00 */  55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 54, 57, 32, 32, 50,
/* 0x2b10 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x2b20 */  49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x2b30 */  48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 54,
/* 0x2b40 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b50 */  83, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x2b60 */  32, 32, 32, 32, 48, 49, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2b70 */  49,100, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2b80 */  69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x2b90 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ba0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95,
/* 0x2bb0 */  72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10,
/* 0x2bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2bd0 */  32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x2be0 */  76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48,
/* 0x2bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2c00 */  32, 32, 32,100, 32, 32,112,116,114, 95, 78, 69, 88, 84, 32, 48,
/* 0x2c10 */  32,112,116,114, 95, 78, 69, 88, 84, 10, 48, 48, 48, 48, 48, 48,
/* 0x2c20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2c30 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32,
/* 0x2c40 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x2c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2c60 */  32,100, 32, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 32, 83, 79,
/* 0x2c70 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c80 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x2c90 */  82, 86, 50, 69, 32, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x2ca0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2cb0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82,
/* 0x2cc0 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x2ce0 */  50, 66, 32, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x2cf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2d00 */  32,100, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32, 83, 79,
/* 0x2d10 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d20 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83,
/* 0x2d30 */  79, 95, 84, 65, 73, 76, 32, 48, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x2d40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d50 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69,
/* 0x2d60 */  76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x2d70 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d80 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x2d90 */  68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2da0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2db0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x2dc0 */  95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2dd0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2de0 */  48, 48, 51,101, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x2df0 */  84, 65, 73, 76, 32, 48, 32,109,117,110,109, 97,112, 10, 48, 48,
/* 0x2e00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 99, 32,103,
/* 0x2e10 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x2e20 */  32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e30 */  48, 48, 48, 48, 48, 48, 51, 49, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x2e40 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 79, 95, 66, 73, 78,
/* 0x2e50 */  70, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 51, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x2e70 */  65, 73, 76, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32,
/* 0x2e90 */  32, 32, 70, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,101,111,
/* 0x2ea0 */ 102, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2eb0 */  49, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x2ec0 */  73, 76, 32, 48, 32,102, 95,105,110,116, 51, 10, 48, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 54, 32,103, 32, 32,
/* 0x2ee0 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,119,
/* 0x2ef0 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f00 */  48, 48, 48, 49, 51, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x2f10 */  95, 84, 65, 73, 76, 32, 48, 32,109,101,109,115,101,116, 10, 48,
/* 0x2f20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 97, 32,
/* 0x2f30 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x2f40 */  48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 48, 52, 50, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f60 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,112,114,111,116,101,
/* 0x2f70 */  99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f80 */  50, 50, 50, 32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77,
/* 0x2f90 */  65, 73, 78, 32, 48, 50,100, 50, 32,117,112,120, 95,115,111, 95,
/* 0x2fa0 */ 109, 97,105,110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x2fb0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79,
/* 0x2fc0 */  95, 77, 65, 73, 78, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2fd0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x2fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x2ff0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x3000 */  51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x3010 */  32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,
/* 0x3020 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x3030 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 88,
/* 0x3040 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,101,
/* 0x3050 */ 120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x3060 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3070 */  48, 48, 48, 48, 49,100, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x3080 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,
/* 0x3090 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x30a0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x30b0 */  48, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x30c0 */  50, 32, 32, 32, 32,109,112,114,111,116,101, 99,116, 43, 48,120,
/* 0x30d0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x30e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 54,
/* 0x30f0 */ 100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x3100 */  32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x3110 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x3120 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 56, 50, 32, 82, 95, 88,
/* 0x3130 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,
/* 0x3140 */ 101,109, 99,112,121, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x3150 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3160 */  48, 48, 48, 48, 48, 48, 50, 99, 52, 32, 82, 95, 88, 56, 54, 95,
/* 0x3170 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,112,114,111,
/* 0x3180 */ 116,101, 99,116, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x3190 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31a0 */  48, 48, 48, 48, 48, 51, 54, 99, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x31b0 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,112,114,111,116,
/* 0x31c0 */ 101, 99,116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x31d0 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 48, 51,102, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x31f0 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,
/* 0x3200 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3210 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x3220 */  53, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x3230 */  50, 32, 32, 32, 32,109,101,109,115,101,116, 43, 48,120,102,102,
/* 0x3240 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x3250 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 57,102, 32,
/* 0x3260 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x3270 */  32, 32,109,112,114,111,116,101, 99,116, 43, 48,120,102,102,102,
/* 0x3280 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x3290 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 99, 98, 32, 82,
/* 0x32a0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x32b0 */  32,109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,
/* 0x32c0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79,
/* 0x32d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x32e0 */  79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x32f0 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x3300 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x3310 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3320 */  48, 48, 48,100, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x3330 */  67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x3340 */  43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3350 */  48, 57, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3360 */  48, 48, 55, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x3370 */  51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43,
/* 0x3380 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3390 */ 102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x33a0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,
/* 0x33b0 */  68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x33c0 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x33d0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x33e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,100, 32, 82, 95,
/* 0x33f0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x3400 */  69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x3410 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 52, 10, 48, 48, 48, 48,
/* 0x3420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 50, 32, 82, 95, 88,
/* 0x3430 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69,
/* 0x3440 */  88, 80, 95, 84, 65, 73, 76, 43, 48,120,102,102,102,102,102,102,
/* 0x3450 */ 102,102,102,102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79,
/* 0x3460 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x3470 */  79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x3480 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x3490 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x34a0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34b0 */  48, 48, 48, 98, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x34c0 */  67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x34d0 */  43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34e0 */  48, 57, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34f0 */  48, 48, 53,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x3500 */  51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43,
/* 0x3510 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3520 */ 102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3530 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 72,
/* 0x3540 */  69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x3550 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x3560 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x3570 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x3580 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x3590 */  32, 32,112,116,114, 95, 78, 69, 88, 84, 43, 48,120,102,102,102,
/* 0x35a0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x35b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82,
/* 0x35c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x35d0 */  32,117,112,120, 95,115,111, 95,109, 97,105,110, 43, 48,120,102,
/* 0x35e0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x35f0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x3600 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,
/* 0x3610 */  70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x3620 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x3630 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x3640 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x3650 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x3660 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48,
/* 0x3670 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 50, 10
};
