/* linkhelper.c generated by valac, the Vala compiler
 * generated from linkhelper.vala, do not modify */

/* linkhelper.vala
 *
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_HTML_LINK_HELPER_0_PROPERTY,
	VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY,
	VALADOC_HTML_LINK_HELPER_NUM_PROPERTIES
};
static GParamSpec* valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHtmlLinkHelperPrivate {
	gboolean _enable_browsable_check;
};


static gpointer valadoc_html_link_helper_parent_class = NULL;

#define VALADOC_HTML_LINK_HELPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelperPrivate))
static gchar* valadoc_html_link_helper_real_get_package_link (ValadocHtmlLinkHelper* self, ValadocApiPackage* package, ValadocSettings* settings);
static gchar* valadoc_html_link_helper_real_from_package_to_package (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_package_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_package_to_node (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiNode* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_package (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_wiki (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_node (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiNode* to);
static gchar* valadoc_html_link_helper_real_from_node_to_package (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_node_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_node_to_node (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiNode* to);
static void valadoc_html_link_helper_finalize (GObject * obj);
static void _vala_valadoc_html_link_helper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_valadoc_html_link_helper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gchar* valadoc_html_link_helper_real_get_package_link (ValadocHtmlLinkHelper* self, ValadocApiPackage* package, ValadocSettings* settings) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (package != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocApiPackage* _tmp2_;
		ValadocSettings* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = package;
		_tmp3_ = settings;
		_tmp4_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp2_, _tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = package;
	_tmp6_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_build_filename (_tmp7_, "index.htm", NULL);
	result = _tmp8_;
	return result;
}


gchar* valadoc_html_link_helper_get_package_link (ValadocHtmlLinkHelper* self, ValadocApiPackage* package, ValadocSettings* settings) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->get_package_link (self, package, settings);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* valadoc_html_link_helper_get_relative_link (ValadocHtmlLinkHelper* self, ValadocDocumentation* from, ValadocDocumentation* to, ValadocSettings* settings) {
	gchar* result = NULL;
	ValadocSettings* _tmp0_;
	ValadocSettings* _tmp1_;
	ValadocDocumentation* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->_settings);
	self->_settings = _tmp1_;
	_tmp2_ = from;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_PACKAGE)) {
		ValadocDocumentation* _tmp3_;
		_tmp3_ = to;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_API_TYPE_PACKAGE)) {
			ValadocDocumentation* _tmp4_;
			ValadocDocumentation* _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = from;
			_tmp5_ = to;
			_tmp6_ = valadoc_html_link_helper_from_package_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
			result = _tmp6_;
			return result;
		} else {
			ValadocDocumentation* _tmp7_;
			_tmp7_ = to;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALADOC_API_TYPE_NODE)) {
				ValadocDocumentation* _tmp8_;
				ValadocDocumentation* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = from;
				_tmp9_ = to;
				_tmp10_ = valadoc_html_link_helper_from_package_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_NODE, ValadocApiNode));
				result = _tmp10_;
				return result;
			} else {
				ValadocDocumentation* _tmp11_;
				_tmp11_ = to;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALADOC_TYPE_WIKI_PAGE)) {
					ValadocDocumentation* _tmp12_;
					ValadocDocumentation* _tmp13_;
					gchar* _tmp14_;
					_tmp12_ = from;
					_tmp13_ = to;
					_tmp14_ = valadoc_html_link_helper_from_package_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
					result = _tmp14_;
					return result;
				} else {
					_vala_assert (TRUE, "true");
				}
			}
		}
	} else {
		ValadocDocumentation* _tmp15_;
		_tmp15_ = from;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALADOC_API_TYPE_NODE)) {
			ValadocDocumentation* _tmp16_;
			_tmp16_ = to;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_API_TYPE_PACKAGE)) {
				ValadocDocumentation* _tmp17_;
				ValadocDocumentation* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = from;
				_tmp18_ = to;
				_tmp19_ = valadoc_html_link_helper_from_node_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
				result = _tmp19_;
				return result;
			} else {
				ValadocDocumentation* _tmp20_;
				_tmp20_ = to;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALADOC_API_TYPE_NODE)) {
					ValadocDocumentation* _tmp21_;
					ValadocDocumentation* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = from;
					_tmp22_ = to;
					_tmp23_ = valadoc_html_link_helper_from_node_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALADOC_API_TYPE_NODE, ValadocApiNode));
					result = _tmp23_;
					return result;
				} else {
					ValadocDocumentation* _tmp24_;
					_tmp24_ = to;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALADOC_TYPE_WIKI_PAGE)) {
						ValadocDocumentation* _tmp25_;
						ValadocDocumentation* _tmp26_;
						gchar* _tmp27_;
						_tmp25_ = from;
						_tmp26_ = to;
						_tmp27_ = valadoc_html_link_helper_from_node_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
						result = _tmp27_;
						return result;
					} else {
						_vala_assert (TRUE, "true");
					}
				}
			}
		} else {
			ValadocDocumentation* _tmp28_;
			_tmp28_ = from;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALADOC_TYPE_WIKI_PAGE)) {
				ValadocDocumentation* _tmp29_;
				_tmp29_ = to;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALADOC_API_TYPE_PACKAGE)) {
					ValadocDocumentation* _tmp30_;
					ValadocDocumentation* _tmp31_;
					gchar* _tmp32_;
					_tmp30_ = from;
					_tmp31_ = to;
					_tmp32_ = valadoc_html_link_helper_from_wiki_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
					result = _tmp32_;
					return result;
				} else {
					ValadocDocumentation* _tmp33_;
					_tmp33_ = to;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALADOC_API_TYPE_NODE)) {
						ValadocDocumentation* _tmp34_;
						ValadocDocumentation* _tmp35_;
						gchar* _tmp36_;
						_tmp34_ = from;
						_tmp35_ = to;
						_tmp36_ = valadoc_html_link_helper_from_wiki_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALADOC_API_TYPE_NODE, ValadocApiNode));
						result = _tmp36_;
						return result;
					} else {
						ValadocDocumentation* _tmp37_;
						_tmp37_ = to;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALADOC_TYPE_WIKI_PAGE)) {
							ValadocDocumentation* _tmp38_;
							ValadocDocumentation* _tmp39_;
							gchar* _tmp40_;
							_tmp38_ = from;
							_tmp39_ = to;
							_tmp40_ = valadoc_html_link_helper_from_wiki_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
							result = _tmp40_;
							return result;
						} else {
							_vala_assert (TRUE, "true");
						}
					}
				}
			} else {
				_vala_assert (TRUE, "true");
			}
		}
	}
	result = NULL;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch23_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch23_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally23;
	__catch23_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally23:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* valadoc_html_link_helper_translate_wiki_name (ValadocHtmlLinkHelper* self, ValadocWikiPage* page) {
	gchar* result = NULL;
	gchar* name = NULL;
	ValadocWikiPage* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = page;
	_tmp1_ = valadoc_wiki_page_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = string_last_index_of_char (name, (gunichar) '.', 0);
	_tmp5_ = string_substring (name, (glong) 0, (glong) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = string_replace (_tmp6_, "/", ".");
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".htm", NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	result = _tmp10_;
	_g_free0 (name);
	return result;
}


static gchar* valadoc_html_link_helper_real_from_package_to_package (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiPackage* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp5_;
	ValadocApiPackage* _tmp6_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocApiPackage* _tmp2_;
		ValadocSettings* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = to;
		_tmp3_ = self->_settings;
		_tmp4_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp2_, _tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = from;
	_tmp6_ = to;
	if (_tmp5_ == _tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("#");
		result = _tmp7_;
		return result;
	} else {
		ValadocApiPackage* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = to;
		_tmp9_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_build_filename ("..", _tmp10_, "index.htm", NULL);
		result = _tmp11_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_package_to_package (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiPackage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_package (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_package_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocWikiPage* to) {
	gchar* result = NULL;
	ValadocApiPackage* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = from;
	_tmp1_ = valadoc_api_package_get_is_package (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValadocSettings* _tmp3_;
		const gchar* _tmp4_;
		ValadocWikiPage* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = self->_settings;
		_tmp4_ = _tmp3_->pkg_name;
		_tmp5_ = to;
		_tmp6_ = valadoc_html_link_helper_translate_wiki_name (self, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename ("..", _tmp4_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		return result;
	} else {
		ValadocWikiPage* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = to;
		_tmp11_ = valadoc_html_link_helper_translate_wiki_name (self, _tmp10_);
		result = _tmp11_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_package_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocWikiPage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_wiki (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_package_to_node (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiNode* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp11_;
	ValadocApiNode* _tmp12_;
	ValadocApiPackage* _tmp13_;
	ValadocApiPackage* _tmp14_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocApiNode* _tmp3_;
		ValadocSettings* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = to;
		_tmp4_ = self->_settings;
		_tmp5_ = valadoc_api_node_is_browsable (_tmp3_, _tmp4_);
		if (!_tmp5_) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiNode* _tmp6_;
			ValadocApiPackage* _tmp7_;
			ValadocApiPackage* _tmp8_;
			ValadocSettings* _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = to;
			_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->_settings;
			_tmp10_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp8_, _tmp9_);
			_tmp2_ = !_tmp10_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp11_ = from;
	_tmp12_ = to;
	_tmp13_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp11_ == _tmp14_) {
		ValadocApiNode* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp15_ = to;
		_tmp16_ = valadoc_api_node_get_full_name (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, ".html", NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_build_filename (_tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		result = _tmp21_;
		return result;
	} else {
		ValadocApiNode* _tmp22_;
		ValadocApiPackage* _tmp23_;
		ValadocApiPackage* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValadocApiNode* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp22_ = to;
		_tmp23_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = to;
		_tmp28_ = valadoc_api_node_get_full_name (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, ".html", NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_build_filename ("..", _tmp26_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		result = _tmp33_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_package_to_node (ValadocHtmlLinkHelper* self, ValadocApiPackage* from, ValadocApiNode* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_node (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_wiki_to_package (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiPackage* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocApiPackage* _tmp2_;
		ValadocSettings* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = to;
		_tmp3_ = self->_settings;
		_tmp4_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp2_, _tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = to;
	_tmp6_ = valadoc_api_package_get_is_package (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		ValadocApiPackage* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = to;
		_tmp9_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_build_filename ("..", _tmp10_, "index.htm", NULL);
		result = _tmp11_;
		return result;
	} else {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("index.htm");
		result = _tmp12_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_wiki_to_package (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiPackage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_package (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_wiki_to_wiki (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocWikiPage* to) {
	gchar* result = NULL;
	ValadocWikiPage* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = to;
	_tmp1_ = valadoc_html_link_helper_translate_wiki_name (self, _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* valadoc_html_link_helper_from_wiki_to_wiki (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocWikiPage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_wiki (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_wiki_to_node (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiNode* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiNode* _tmp11_;
	ValadocApiPackage* _tmp12_;
	ValadocApiPackage* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocApiNode* _tmp3_;
		ValadocSettings* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = to;
		_tmp4_ = self->_settings;
		_tmp5_ = valadoc_api_node_is_browsable (_tmp3_, _tmp4_);
		if (!_tmp5_) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiNode* _tmp6_;
			ValadocApiPackage* _tmp7_;
			ValadocApiPackage* _tmp8_;
			ValadocSettings* _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = to;
			_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->_settings;
			_tmp10_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp8_, _tmp9_);
			_tmp2_ = !_tmp10_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp11_ = to;
	_tmp12_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_api_package_get_is_package (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		ValadocApiNode* _tmp16_;
		ValadocApiPackage* _tmp17_;
		ValadocApiPackage* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValadocApiNode* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp16_ = to;
		_tmp17_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = to;
		_tmp22_ = valadoc_api_node_get_full_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, ".html", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_build_filename ("..", _tmp20_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		result = _tmp27_;
		return result;
	} else {
		ValadocApiNode* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp28_ = to;
		_tmp29_ = valadoc_api_node_get_full_name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp30_, ".html", NULL);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		result = _tmp32_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_wiki_to_node (ValadocHtmlLinkHelper* self, ValadocWikiPage* from, ValadocApiNode* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_node (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_node_to_package (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiPackage* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiNode* _tmp5_;
	ValadocApiPackage* _tmp6_;
	ValadocApiPackage* _tmp7_;
	ValadocApiPackage* _tmp8_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocApiPackage* _tmp2_;
		ValadocSettings* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = to;
		_tmp3_ = self->_settings;
		_tmp4_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp2_, _tmp3_);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp5_ = from;
	_tmp6_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = to;
	if (_tmp7_ == _tmp8_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("index.htm");
		result = _tmp9_;
		return result;
	} else {
		ValadocApiPackage* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = to;
		_tmp11_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_build_filename ("..", _tmp12_, "index.htm", NULL);
		result = _tmp13_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_node_to_package (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiPackage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_package (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_node_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocWikiPage* to) {
	gchar* result = NULL;
	ValadocApiNode* _tmp0_;
	ValadocApiPackage* _tmp1_;
	ValadocApiPackage* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = from;
	_tmp1_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_package_get_is_package (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ValadocSettings* _tmp5_;
		const gchar* _tmp6_;
		ValadocWikiPage* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = self->_settings;
		_tmp6_ = _tmp5_->pkg_name;
		_tmp7_ = to;
		_tmp8_ = valadoc_html_link_helper_translate_wiki_name (self, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_build_filename ("..", _tmp6_, _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	} else {
		ValadocWikiPage* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = to;
		_tmp13_ = valadoc_html_link_helper_translate_wiki_name (self, _tmp12_);
		result = _tmp13_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_node_to_wiki (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocWikiPage* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_wiki (self, from, to);
}


static gchar* valadoc_html_link_helper_real_from_node_to_node (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiNode* to) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiNode* _tmp11_;
	ValadocApiPackage* _tmp12_;
	ValadocApiPackage* _tmp13_;
	ValadocApiNode* _tmp14_;
	ValadocApiPackage* _tmp15_;
	ValadocApiPackage* _tmp16_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocApiNode* _tmp3_;
		ValadocSettings* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = to;
		_tmp4_ = self->_settings;
		_tmp5_ = valadoc_api_node_is_browsable (_tmp3_, _tmp4_);
		if (!_tmp5_) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiNode* _tmp6_;
			ValadocApiPackage* _tmp7_;
			ValadocApiPackage* _tmp8_;
			ValadocSettings* _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = to;
			_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->_settings;
			_tmp10_ = valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp8_, _tmp9_);
			_tmp2_ = !_tmp10_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp11_ = from;
	_tmp12_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = to;
	_tmp15_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp13_ == _tmp16_) {
		ValadocApiNode* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp17_ = to;
		_tmp18_ = valadoc_api_node_get_full_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, ".html", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_build_filename (_tmp21_, NULL);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		result = _tmp23_;
		return result;
	} else {
		ValadocApiNode* _tmp24_;
		ValadocApiPackage* _tmp25_;
		ValadocApiPackage* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValadocApiNode* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp24_ = to;
		_tmp25_ = valadoc_documentation_get_package ((ValadocDocumentation*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = to;
		_tmp30_ = valadoc_api_node_get_full_name (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, ".html", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_build_filename ("..", _tmp28_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		result = _tmp35_;
		return result;
	}
}


gchar* valadoc_html_link_helper_from_node_to_node (ValadocHtmlLinkHelper* self, ValadocApiNode* from, ValadocApiNode* to) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_node (self, from, to);
}


ValadocHtmlLinkHelper* valadoc_html_link_helper_construct (GType object_type) {
	ValadocHtmlLinkHelper * self = NULL;
	self = (ValadocHtmlLinkHelper*) g_object_new (object_type, NULL);
	return self;
}


ValadocHtmlLinkHelper* valadoc_html_link_helper_new (void) {
	return valadoc_html_link_helper_construct (VALADOC_HTML_TYPE_LINK_HELPER);
}


gboolean valadoc_html_link_helper_get_enable_browsable_check (ValadocHtmlLinkHelper* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_browsable_check;
	result = _tmp0_;
	return result;
}


void valadoc_html_link_helper_set_enable_browsable_check (ValadocHtmlLinkHelper* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (valadoc_html_link_helper_get_enable_browsable_check (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_enable_browsable_check = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY]);
	}
}


static void valadoc_html_link_helper_class_init (ValadocHtmlLinkHelperClass * klass) {
	valadoc_html_link_helper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHtmlLinkHelperPrivate));
	((ValadocHtmlLinkHelperClass *) klass)->get_package_link = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocSettings*)) valadoc_html_link_helper_real_get_package_link;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_package_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_package_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocApiNode*)) valadoc_html_link_helper_real_from_package_to_node;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_wiki_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_wiki_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocApiNode*)) valadoc_html_link_helper_real_from_wiki_to_node;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_node_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_node_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocApiNode*)) valadoc_html_link_helper_real_from_node_to_node;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_html_link_helper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_html_link_helper_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_html_link_helper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY, valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY] = g_param_spec_boolean ("enable-browsable-check", "enable-browsable-check", "enable-browsable-check", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void valadoc_html_link_helper_instance_init (ValadocHtmlLinkHelper * self) {
	self->priv = VALADOC_HTML_LINK_HELPER_GET_PRIVATE (self);
	self->_settings = NULL;
	self->priv->_enable_browsable_check = TRUE;
}


static void valadoc_html_link_helper_finalize (GObject * obj) {
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	_g_object_unref0 (self->_settings);
	G_OBJECT_CLASS (valadoc_html_link_helper_parent_class)->finalize (obj);
}


GType valadoc_html_link_helper_get_type (void) {
	static volatile gsize valadoc_html_link_helper_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_html_link_helper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHtmlLinkHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_html_link_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHtmlLinkHelper), 0, (GInstanceInitFunc) valadoc_html_link_helper_instance_init, NULL };
		GType valadoc_html_link_helper_type_id;
		valadoc_html_link_helper_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocHtmlLinkHelper", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_html_link_helper_type_id__volatile, valadoc_html_link_helper_type_id);
	}
	return valadoc_html_link_helper_type_id__volatile;
}


static void _vala_valadoc_html_link_helper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	switch (property_id) {
		case VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY:
		g_value_set_boolean (value, valadoc_html_link_helper_get_enable_browsable_check (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_valadoc_html_link_helper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	switch (property_id) {
		case VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY:
		valadoc_html_link_helper_set_enable_browsable_check (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



