/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTextAreaElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLTextAreaElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTextAreaElementTableValues[] =
{
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementAutofocus), (intptr_t)setJSHTMLTextAreaElementAutofocus, NoIntrinsic },
    { "cols", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementCols), (intptr_t)setJSHTMLTextAreaElementCols, NoIntrinsic },
    { "dirName", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDirName), (intptr_t)setJSHTMLTextAreaElementDirName, NoIntrinsic },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDisabled), (intptr_t)setJSHTMLTextAreaElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementForm), (intptr_t)0, NoIntrinsic },
    { "maxLength", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementMaxLength), (intptr_t)setJSHTMLTextAreaElementMaxLength, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementName), (intptr_t)setJSHTMLTextAreaElementName, NoIntrinsic },
    { "placeholder", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementPlaceholder), (intptr_t)setJSHTMLTextAreaElementPlaceholder, NoIntrinsic },
    { "readOnly", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementReadOnly), (intptr_t)setJSHTMLTextAreaElementReadOnly, NoIntrinsic },
    { "required", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementRequired), (intptr_t)setJSHTMLTextAreaElementRequired, NoIntrinsic },
    { "rows", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementRows), (intptr_t)setJSHTMLTextAreaElementRows, NoIntrinsic },
    { "wrap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementWrap), (intptr_t)setJSHTMLTextAreaElementWrap, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementType), (intptr_t)0, NoIntrinsic },
    { "defaultValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDefaultValue), (intptr_t)setJSHTMLTextAreaElementDefaultValue, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValue), (intptr_t)setJSHTMLTextAreaElementValue, NoIntrinsic },
    { "textLength", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementTextLength), (intptr_t)0, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementLabels), (intptr_t)0, NoIntrinsic },
    { "selectionStart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionStart), (intptr_t)setJSHTMLTextAreaElementSelectionStart, NoIntrinsic },
    { "selectionEnd", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionEnd), (intptr_t)setJSHTMLTextAreaElementSelectionEnd, NoIntrinsic },
    { "selectionDirection", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionDirection), (intptr_t)setJSHTMLTextAreaElementSelectionDirection, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTextAreaElementTable = { 69, 63, JSHTMLTextAreaElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTextAreaElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTextAreaElementConstructorTable = { 1, 0, JSHTMLTextAreaElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTextAreaElementConstructor::s_info = { "HTMLTextAreaElementConstructor", &Base::s_info, &JSHTMLTextAreaElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTextAreaElementConstructor) };

JSHTMLTextAreaElementConstructor::JSHTMLTextAreaElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTextAreaElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLTextAreaElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLTextAreaElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTextAreaElementConstructor, JSDOMWrapper>(exec, &JSHTMLTextAreaElementConstructorTable, jsCast<JSHTMLTextAreaElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTextAreaElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTextAreaElementConstructor, JSDOMWrapper>(exec, &JSHTMLTextAreaElementConstructorTable, jsCast<JSHTMLTextAreaElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTextAreaElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTextAreaElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { "select", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSelect), (intptr_t)0, NoIntrinsic },
    { "setRangeText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetRangeText), (intptr_t)1, NoIntrinsic },
    { "setSelectionRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetSelectionRange), (intptr_t)3, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTextAreaElementPrototypeTable = { 17, 15, JSHTMLTextAreaElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTextAreaElementPrototype::s_info = { "HTMLTextAreaElementPrototype", &Base::s_info, &JSHTMLTextAreaElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTextAreaElementPrototype) };

JSObject* JSHTMLTextAreaElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTextAreaElement>(exec, globalObject);
}

bool JSHTMLTextAreaElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTextAreaElementPrototype* thisObject = jsCast<JSHTMLTextAreaElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTextAreaElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTextAreaElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTextAreaElementPrototype* thisObject = jsCast<JSHTMLTextAreaElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLTextAreaElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTextAreaElement::s_info = { "HTMLTextAreaElement", &Base::s_info, &JSHTMLTextAreaElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTextAreaElement) };

JSHTMLTextAreaElement::JSHTMLTextAreaElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTextAreaElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTextAreaElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTextAreaElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTextAreaElementPrototype::create(exec->globalData(), globalObject, JSHTMLTextAreaElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTextAreaElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTextAreaElement* thisObject = jsCast<JSHTMLTextAreaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTextAreaElement, Base>(exec, &JSHTMLTextAreaElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTextAreaElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTextAreaElement* thisObject = jsCast<JSHTMLTextAreaElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTextAreaElement, Base>(exec, &JSHTMLTextAreaElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTextAreaElementAutofocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLTextAreaElementCols(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->cols());
    return result;
}


JSValue jsHTMLTextAreaElementDirName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::dirnameAttr));
    return result;
}


JSValue jsHTMLTextAreaElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLTextAreaElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLTextAreaElementMaxLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->maxLength());
    return result;
}


JSValue jsHTMLTextAreaElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLTextAreaElementPlaceholder(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::placeholderAttr));
    return result;
}


JSValue jsHTMLTextAreaElementReadOnly(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::readonlyAttr));
    return result;
}


JSValue jsHTMLTextAreaElementRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::requiredAttr));
    return result;
}


JSValue jsHTMLTextAreaElementRows(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->rows());
    return result;
}


JSValue jsHTMLTextAreaElementWrap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::wrapAttr));
    return result;
}


JSValue jsHTMLTextAreaElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLTextAreaElementDefaultValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->defaultValue());
    return result;
}


JSValue jsHTMLTextAreaElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsHTMLTextAreaElementTextLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->textLength());
    return result;
}


JSValue jsHTMLTextAreaElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLTextAreaElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLTextAreaElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLTextAreaElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLTextAreaElementSelectionStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->selectionStart());
    return result;
}


JSValue jsHTMLTextAreaElementSelectionEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->selectionEnd());
    return result;
}


JSValue jsHTMLTextAreaElementSelectionDirection(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->selectionDirection());
    return result;
}


JSValue jsHTMLTextAreaElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTextAreaElement* domObject = jsCast<JSHTMLTextAreaElement*>(asObject(slotBase));
    return JSHTMLTextAreaElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTextAreaElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTextAreaElement* thisObject = jsCast<JSHTMLTextAreaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTextAreaElement, Base>(exec, propertyName, value, &JSHTMLTextAreaElementTable, thisObject, slot);
}

void setJSHTMLTextAreaElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLTextAreaElementCols(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setCols(value.toInt32(exec));
}


void setJSHTMLTextAreaElementDirName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::dirnameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLTextAreaElementMaxLength(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setMaxLength(value.toInt32(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLTextAreaElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementPlaceholder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::placeholderAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementReadOnly(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, value.toBoolean(exec));
}


void setJSHTMLTextAreaElementRequired(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value.toBoolean(exec));
}


void setJSHTMLTextAreaElementRows(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setRows(value.toInt32(exec));
}


void setJSHTMLTextAreaElementWrap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::wrapAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementDefaultValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setDefaultValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTextAreaElementSelectionStart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setSelectionStart(value.toInt32(exec));
}


void setJSHTMLTextAreaElementSelectionEnd(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setSelectionEnd(value.toInt32(exec));
}


void setJSHTMLTextAreaElementSelectionDirection(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(thisObject);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->setSelectionDirection(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSHTMLTextAreaElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTextAreaElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSelect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    impl->select();
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetRangeText1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& replacement(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRangeText(replacement, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetRangeText2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& replacement(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned start(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned end(exec->argument(2).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& selectionMode(argumentOrNull(exec, 3).isEmpty() ? String() : argumentOrNull(exec, 3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRangeText(replacement, start, end, selectionMode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetRangeText(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    if (argsCount == 1)
        return jsHTMLTextAreaElementPrototypeFunctionSetRangeText1(exec);
    if (argsCount == 3 || argsCount == 4)
        return jsHTMLTextAreaElementPrototypeFunctionSetRangeText2(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetSelectionRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTextAreaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTextAreaElement* castedThis = jsCast<JSHTMLTextAreaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTextAreaElement::s_info);
    HTMLTextAreaElement* impl = static_cast<HTMLTextAreaElement*>(castedThis->impl());
    int start(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int end(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 2) {
        impl->setSelectionRange(start, end);
        return JSValue::encode(jsUndefined());
    }

    const String& direction(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSelectionRange(start, end, direction);
    return JSValue::encode(jsUndefined());
}


}
