/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMWindow.h"

#include "DOMObjectCache.h"
#include "DOMWindowQuota.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMBarInfoPrivate.h"
#include "WebKitDOMCSSStyleDeclarationPrivate.h"
#include "WebKitDOMConsolePrivate.h"
#include "WebKitDOMDOMApplicationCachePrivate.h"
#include "WebKitDOMDOMSelectionPrivate.h"
#include "WebKitDOMDOMWindowCSSPrivate.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMHistoryPrivate.h"
#include "WebKitDOMMediaQueryListPrivate.h"
#include "WebKitDOMNavigatorPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPerformancePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMScreenPrivate.h"
#include "WebKitDOMStorageInfoPrivate.h"
#include "WebKitDOMStoragePrivate.h"
#include "WebKitDOMStyleMediaPrivate.h"
#include "WebKitDOMWebKitPointPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_WINDOW_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_WINDOW, WebKitDOMDOMWindowPrivate)

typedef struct _WebKitDOMDOMWindowPrivate {
    RefPtr<WebCore::DOMWindow> coreObject;
} WebKitDOMDOMWindowPrivate;

namespace WebKit {

WebKitDOMDOMWindow* kit(WebCore::DOMWindow* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_WINDOW(ret);

    return wrapDOMWindow(obj);
}

WebCore::DOMWindow* core(WebKitDOMDOMWindow* request)
{
    return request ? static_cast<WebCore::DOMWindow*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMWindow* wrapDOMWindow(WebCore::DOMWindow* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_WINDOW(g_object_new(WEBKIT_TYPE_DOM_DOM_WINDOW, "core-object", coreObject, NULL));
}

} // namespace WebKit

static void webkit_dom_dom_window_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::DOMWindow* coreTarget = static_cast<WebCore::DOMWindow*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
}

static gboolean webkit_dom_dom_window_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
    WebCore::DOMWindow* coreTarget = static_cast<WebCore::DOMWindow*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
}

static gboolean webkit_dom_dom_window_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
    WebCore::DOMWindow* coreTarget = static_cast<WebCore::DOMWindow*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_dom_window_dispatch_event;
    iface->add_event_listener = webkit_dom_dom_window_add_event_listener;
    iface->remove_event_listener = webkit_dom_dom_window_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMDOMWindow, webkit_dom_dom_window, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_SCREEN,
    PROP_HISTORY,
    PROP_LOCATIONBAR,
    PROP_MENUBAR,
    PROP_PERSONALBAR,
    PROP_SCROLLBARS,
    PROP_STATUSBAR,
    PROP_TOOLBAR,
    PROP_NAVIGATOR,
    PROP_CLIENT_INFORMATION,
    PROP_FRAME_ELEMENT,
    PROP_OFFSCREEN_BUFFERING,
    PROP_OUTER_HEIGHT,
    PROP_OUTER_WIDTH,
    PROP_INNER_HEIGHT,
    PROP_INNER_WIDTH,
    PROP_SCREEN_X,
    PROP_SCREEN_Y,
    PROP_SCREEN_LEFT,
    PROP_SCREEN_TOP,
    PROP_SCROLL_X,
    PROP_SCROLL_Y,
    PROP_PAGE_X_OFFSET,
    PROP_PAGE_Y_OFFSET,
    PROP_CLOSED,
    PROP_LENGTH,
    PROP_NAME,
    PROP_STATUS,
    PROP_DEFAULT_STATUS,
    PROP_SELF,
    PROP_WINDOW,
    PROP_FRAMES,
    PROP_OPENER,
    PROP_PARENT,
    PROP_TOP,
    PROP_DOCUMENT,
    PROP_STYLE_MEDIA,
    PROP_DEVICE_PIXEL_RATIO,
    PROP_APPLICATION_CACHE,
    PROP_SESSION_STORAGE,
    PROP_LOCAL_STORAGE,
    PROP_CONSOLE,
    PROP_PERFORMANCE,
    PROP_CSS,
    PROP_WEBKIT_STORAGE_INFO,
};

static void webkit_dom_dom_window_finalize(GObject* object)
{
    WebKitDOMDOMWindowPrivate* priv = WEBKIT_DOM_DOM_WINDOW_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMWindowPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_window_parent_class)->finalize(object);
}

static void webkit_dom_dom_window_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMWindow* self = WEBKIT_DOM_DOM_WINDOW(object);
    WebCore::DOMWindow* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        coreSelf->setName(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_STATUS: {
        coreSelf->setStatus(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DEFAULT_STATUS: {
        coreSelf->setDefaultStatus(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_dom_window_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMWindow* self = WEBKIT_DOM_DOM_WINDOW(object);
    WebCore::DOMWindow* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_SCREEN: {
        RefPtr<WebCore::Screen> ptr = coreSelf->screen();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_HISTORY: {
        RefPtr<WebCore::History> ptr = coreSelf->history();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LOCATIONBAR: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->locationbar();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_MENUBAR: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->menubar();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PERSONALBAR: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->personalbar();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_SCROLLBARS: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->scrollbars();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_STATUSBAR: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->statusbar();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_TOOLBAR: {
        RefPtr<WebCore::BarInfo> ptr = coreSelf->toolbar();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_NAVIGATOR: {
        RefPtr<WebCore::Navigator> ptr = coreSelf->navigator();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CLIENT_INFORMATION: {
        RefPtr<WebCore::Navigator> ptr = coreSelf->clientInformation();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FRAME_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->frameElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_OFFSCREEN_BUFFERING: {
        g_value_set_boolean(value, coreSelf->offscreenBuffering());
        break;
    }
    case PROP_OUTER_HEIGHT: {
        g_value_set_long(value, coreSelf->outerHeight());
        break;
    }
    case PROP_OUTER_WIDTH: {
        g_value_set_long(value, coreSelf->outerWidth());
        break;
    }
    case PROP_INNER_HEIGHT: {
        g_value_set_long(value, coreSelf->innerHeight());
        break;
    }
    case PROP_INNER_WIDTH: {
        g_value_set_long(value, coreSelf->innerWidth());
        break;
    }
    case PROP_SCREEN_X: {
        g_value_set_long(value, coreSelf->screenX());
        break;
    }
    case PROP_SCREEN_Y: {
        g_value_set_long(value, coreSelf->screenY());
        break;
    }
    case PROP_SCREEN_LEFT: {
        g_value_set_long(value, coreSelf->screenLeft());
        break;
    }
    case PROP_SCREEN_TOP: {
        g_value_set_long(value, coreSelf->screenTop());
        break;
    }
    case PROP_SCROLL_X: {
        g_value_set_long(value, coreSelf->scrollX());
        break;
    }
    case PROP_SCROLL_Y: {
        g_value_set_long(value, coreSelf->scrollY());
        break;
    }
    case PROP_PAGE_X_OFFSET: {
        g_value_set_long(value, coreSelf->pageXOffset());
        break;
    }
    case PROP_PAGE_Y_OFFSET: {
        g_value_set_long(value, coreSelf->pageYOffset());
        break;
    }
    case PROP_CLOSED: {
        g_value_set_boolean(value, coreSelf->closed());
        break;
    }
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
        break;
    }
    case PROP_STATUS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->status()));
        break;
    }
    case PROP_DEFAULT_STATUS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->defaultStatus()));
        break;
    }
    case PROP_SELF: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->self();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WINDOW: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->window();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FRAMES: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->frames();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_OPENER: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->opener();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PARENT: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->parent();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_TOP: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->top();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->document();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_STYLE_MEDIA: {
        RefPtr<WebCore::StyleMedia> ptr = coreSelf->styleMedia();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_DEVICE_PIXEL_RATIO: {
        g_value_set_double(value, coreSelf->devicePixelRatio());
        break;
    }
    case PROP_APPLICATION_CACHE: {
        RefPtr<WebCore::DOMApplicationCache> ptr = coreSelf->applicationCache();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_SESSION_STORAGE: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::Storage> ptr = coreSelf->sessionStorage(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_LOCAL_STORAGE: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::Storage> ptr = coreSelf->localStorage(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONSOLE: {
        RefPtr<WebCore::Console> ptr = coreSelf->console();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PERFORMANCE: {
        RefPtr<WebCore::Performance> ptr = coreSelf->performance();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CSS: {
#if ENABLE(CSS3_CONDITIONAL_RULES)
        RefPtr<WebCore::DOMWindowCSS> ptr = coreSelf->css();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Css3 Conditional Rules")
#endif /* ENABLE(CSS3_CONDITIONAL_RULES) */
        break;
    }
    case PROP_WEBKIT_STORAGE_INFO: {
#if ENABLE(QUOTA)
        RefPtr<WebCore::StorageInfo> ptr = WebCore::DOMWindowQuota::webkitStorageInfo(coreSelf);
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Quota")
#endif /* ENABLE(QUOTA) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_window_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_window_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMWindowPrivate* priv = WEBKIT_DOM_DOM_WINDOW_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMWindow*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_window_class_init(WebKitDOMDOMWindowClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMWindowPrivate));
    gobjectClass->constructor = webkit_dom_dom_window_constructor;
    gobjectClass->finalize = webkit_dom_dom_window_finalize;
    gobjectClass->set_property = webkit_dom_dom_window_set_property;
    gobjectClass->get_property = webkit_dom_dom_window_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN,
                                    g_param_spec_object("screen", /* name */
                                                           "dom_window_screen", /* short description */
                                                           "read-only  WebKitDOMScreen* DOMWindow.screen", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SCREEN, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HISTORY,
                                    g_param_spec_object("history", /* name */
                                                           "dom_window_history", /* short description */
                                                           "read-only  WebKitDOMHistory* DOMWindow.history", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HISTORY, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOCATIONBAR,
                                    g_param_spec_object("locationbar", /* name */
                                                           "dom_window_locationbar", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.locationbar", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MENUBAR,
                                    g_param_spec_object("menubar", /* name */
                                                           "dom_window_menubar", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.menubar", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PERSONALBAR,
                                    g_param_spec_object("personalbar", /* name */
                                                           "dom_window_personalbar", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.personalbar", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLLBARS,
                                    g_param_spec_object("scrollbars", /* name */
                                                           "dom_window_scrollbars", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.scrollbars", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STATUSBAR,
                                    g_param_spec_object("statusbar", /* name */
                                                           "dom_window_statusbar", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.statusbar", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TOOLBAR,
                                    g_param_spec_object("toolbar", /* name */
                                                           "dom_window_toolbar", /* short description */
                                                           "read-only  WebKitDOMBarInfo* DOMWindow.toolbar", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_BAR_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAVIGATOR,
                                    g_param_spec_object("navigator", /* name */
                                                           "dom_window_navigator", /* short description */
                                                           "read-only  WebKitDOMNavigator* DOMWindow.navigator", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NAVIGATOR, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLIENT_INFORMATION,
                                    g_param_spec_object("client-information", /* name */
                                                           "dom_window_client-information", /* short description */
                                                           "read-only  WebKitDOMNavigator* DOMWindow.client-information", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NAVIGATOR, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FRAME_ELEMENT,
                                    g_param_spec_object("frame-element", /* name */
                                                           "dom_window_frame-element", /* short description */
                                                           "read-only  WebKitDOMElement* DOMWindow.frame-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OFFSCREEN_BUFFERING,
                                    g_param_spec_boolean("offscreen-buffering", /* name */
                                                           "dom_window_offscreen-buffering", /* short description */
                                                           "read-only  gboolean DOMWindow.offscreen-buffering", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OUTER_HEIGHT,
                                    g_param_spec_long("outer-height", /* name */
                                                           "dom_window_outer-height", /* short description */
                                                           "read-only  glong DOMWindow.outer-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OUTER_WIDTH,
                                    g_param_spec_long("outer-width", /* name */
                                                           "dom_window_outer-width", /* short description */
                                                           "read-only  glong DOMWindow.outer-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INNER_HEIGHT,
                                    g_param_spec_long("inner-height", /* name */
                                                           "dom_window_inner-height", /* short description */
                                                           "read-only  glong DOMWindow.inner-height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INNER_WIDTH,
                                    g_param_spec_long("inner-width", /* name */
                                                           "dom_window_inner-width", /* short description */
                                                           "read-only  glong DOMWindow.inner-width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_X,
                                    g_param_spec_long("screen-x", /* name */
                                                           "dom_window_screen-x", /* short description */
                                                           "read-only  glong DOMWindow.screen-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_Y,
                                    g_param_spec_long("screen-y", /* name */
                                                           "dom_window_screen-y", /* short description */
                                                           "read-only  glong DOMWindow.screen-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_LEFT,
                                    g_param_spec_long("screen-left", /* name */
                                                           "dom_window_screen-left", /* short description */
                                                           "read-only  glong DOMWindow.screen-left", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCREEN_TOP,
                                    g_param_spec_long("screen-top", /* name */
                                                           "dom_window_screen-top", /* short description */
                                                           "read-only  glong DOMWindow.screen-top", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_X,
                                    g_param_spec_long("scroll-x", /* name */
                                                           "dom_window_scroll-x", /* short description */
                                                           "read-only  glong DOMWindow.scroll-x", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLL_Y,
                                    g_param_spec_long("scroll-y", /* name */
                                                           "dom_window_scroll-y", /* short description */
                                                           "read-only  glong DOMWindow.scroll-y", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAGE_X_OFFSET,
                                    g_param_spec_long("page-x-offset", /* name */
                                                           "dom_window_page-x-offset", /* short description */
                                                           "read-only  glong DOMWindow.page-x-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PAGE_Y_OFFSET,
                                    g_param_spec_long("page-y-offset", /* name */
                                                           "dom_window_page-y-offset", /* short description */
                                                           "read-only  glong DOMWindow.page-y-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CLOSED,
                                    g_param_spec_boolean("closed", /* name */
                                                           "dom_window_closed", /* short description */
                                                           "read-only  gboolean DOMWindow.closed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "dom_window_length", /* short description */
                                                           "read-only  gulong DOMWindow.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "dom_window_name", /* short description */
                                                           "read-write  gchar* DOMWindow.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STATUS,
                                    g_param_spec_string("status", /* name */
                                                           "dom_window_status", /* short description */
                                                           "read-write  gchar* DOMWindow.status", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_STATUS,
                                    g_param_spec_string("default-status", /* name */
                                                           "dom_window_default-status", /* short description */
                                                           "read-write  gchar* DOMWindow.default-status", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SELF,
                                    g_param_spec_object("self", /* name */
                                                           "dom_window_self", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.self", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WINDOW,
                                    g_param_spec_object("window", /* name */
                                                           "dom_window_window", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.window", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FRAMES,
                                    g_param_spec_object("frames", /* name */
                                                           "dom_window_frames", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.frames", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OPENER,
                                    g_param_spec_object("opener", /* name */
                                                           "dom_window_opener", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.opener", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT,
                                    g_param_spec_object("parent", /* name */
                                                           "dom_window_parent", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.parent", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TOP,
                                    g_param_spec_object("top", /* name */
                                                           "dom_window_top", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* DOMWindow.top", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOCUMENT,
                                    g_param_spec_object("document", /* name */
                                                           "dom_window_document", /* short description */
                                                           "read-only  WebKitDOMDocument* DOMWindow.document", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STYLE_MEDIA,
                                    g_param_spec_object("style-media", /* name */
                                                           "dom_window_style-media", /* short description */
                                                           "read-only  WebKitDOMStyleMedia* DOMWindow.style-media", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_MEDIA, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEVICE_PIXEL_RATIO,
                                    g_param_spec_double("device-pixel-ratio", /* name */
                                                           "dom_window_device-pixel-ratio", /* short description */
                                                           "read-only  gdouble DOMWindow.device-pixel-ratio", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_APPLICATION_CACHE,
                                    g_param_spec_object("application-cache", /* name */
                                                           "dom_window_application-cache", /* short description */
                                                           "read-only  WebKitDOMDOMApplicationCache* DOMWindow.application-cache", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_APPLICATION_CACHE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SESSION_STORAGE,
                                    g_param_spec_object("session-storage", /* name */
                                                           "dom_window_session-storage", /* short description */
                                                           "read-only  WebKitDOMStorage* DOMWindow.session-storage", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STORAGE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOCAL_STORAGE,
                                    g_param_spec_object("local-storage", /* name */
                                                           "dom_window_local-storage", /* short description */
                                                           "read-only  WebKitDOMStorage* DOMWindow.local-storage", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STORAGE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONSOLE,
                                    g_param_spec_object("console", /* name */
                                                           "dom_window_console", /* short description */
                                                           "read-only  WebKitDOMConsole* DOMWindow.console", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_CONSOLE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PERFORMANCE,
                                    g_param_spec_object("performance", /* name */
                                                           "dom_window_performance", /* short description */
                                                           "read-only  WebKitDOMPerformance* DOMWindow.performance", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_PERFORMANCE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CSS,
                                    g_param_spec_object("css", /* name */
                                                           "dom_window_css", /* short description */
                                                           "read-write  WebKitDOMDOMWindowCSS* DOMWindow.css", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW_CSS, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_STORAGE_INFO,
                                    g_param_spec_object("webkit-storage-info", /* name */
                                                           "dom_window_webkit-storage-info", /* short description */
                                                           "read-only  WebKitDOMStorageInfo* DOMWindow.webkit-storage-info", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STORAGE_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_window_init(WebKitDOMDOMWindow* request)
{
    WebKitDOMDOMWindowPrivate* priv = WEBKIT_DOM_DOM_WINDOW_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMWindowPrivate();
}

WebKitDOMDOMSelection*
webkit_dom_dom_window_get_selection(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMSelection> gobjectResult = WTF::getPtr(item->getSelection());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_dom_window_focus(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->focus();
}

void
webkit_dom_dom_window_blur(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->blur();
}

void
webkit_dom_dom_window_close(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->close();
}

void
webkit_dom_dom_window_print(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->print();
}

void
webkit_dom_dom_window_stop(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->stop();
}

void
webkit_dom_dom_window_alert(WebKitDOMDOMWindow* self, const gchar* message)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    g_return_if_fail(message);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedMessage = WTF::String::fromUTF8(message);
    item->alert(convertedMessage);
}

gboolean
webkit_dom_dom_window_confirm(WebKitDOMDOMWindow* self, const gchar* message)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), FALSE);
    g_return_val_if_fail(message, FALSE);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedMessage = WTF::String::fromUTF8(message);
    gboolean result = item->confirm(convertedMessage);
    return result;
}

gchar*
webkit_dom_dom_window_prompt(WebKitDOMDOMWindow* self, const gchar* message, const gchar* defaultValue)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(message, 0);
    g_return_val_if_fail(defaultValue, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedMessage = WTF::String::fromUTF8(message);
    WTF::String convertedDefaultValue = WTF::String::fromUTF8(defaultValue);
    gchar* result = convertToUTF8String(item->prompt(convertedMessage, convertedDefaultValue));
    return result;
}

gboolean
webkit_dom_dom_window_find(WebKitDOMDOMWindow* self, const gchar* string, gboolean caseSensitive, gboolean backwards, gboolean wrap, gboolean wholeWord, gboolean searchInFrames, gboolean showDialog)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), FALSE);
    g_return_val_if_fail(string, FALSE);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedString = WTF::String::fromUTF8(string);
    gboolean result = item->find(convertedString, caseSensitive, backwards, wrap, wholeWord, searchInFrames, showDialog);
    return result;
}

void
webkit_dom_dom_window_scroll_by(WebKitDOMDOMWindow* self, glong x, glong y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->scrollBy(x, y);
}

void
webkit_dom_dom_window_scroll_to(WebKitDOMDOMWindow* self, glong x, glong y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->scrollTo(x, y);
}

void
webkit_dom_dom_window_scroll(WebKitDOMDOMWindow* self, glong x, glong y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->scroll(x, y);
}

void
webkit_dom_dom_window_move_by(WebKitDOMDOMWindow* self, gfloat x, gfloat y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->moveBy(x, y);
}

void
webkit_dom_dom_window_move_to(WebKitDOMDOMWindow* self, gfloat x, gfloat y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->moveTo(x, y);
}

void
webkit_dom_dom_window_resize_by(WebKitDOMDOMWindow* self, gfloat x, gfloat y)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->resizeBy(x, y);
}

void
webkit_dom_dom_window_resize_to(WebKitDOMDOMWindow* self, gfloat width, gfloat height)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->resizeTo(width, height);
}

WebKitDOMMediaQueryList*
webkit_dom_dom_window_match_media(WebKitDOMDOMWindow* self, const gchar* query)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(query, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedQuery = WTF::String::fromUTF8(query);
    RefPtr<WebCore::MediaQueryList> gobjectResult = WTF::getPtr(item->matchMedia(convertedQuery));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMCSSStyleDeclaration*
webkit_dom_dom_window_get_computed_style(WebKitDOMDOMWindow* self, WebKitDOMElement* element, const gchar* pseudoElement)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_ELEMENT(element), 0);
    g_return_val_if_fail(pseudoElement, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::Element* convertedElement = WebKit::core(element);
    WTF::String convertedPseudoElement = WTF::String::fromUTF8(pseudoElement);
    RefPtr<WebCore::CSSStyleDeclaration> gobjectResult = WTF::getPtr(item->getComputedStyle(convertedElement, convertedPseudoElement));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMWebKitPoint*
webkit_dom_dom_window_webkit_convert_point_from_page_to_node(WebKitDOMDOMWindow* self, WebKitDOMNode* node, WebKitDOMWebKitPoint* p)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(node), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(p), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::WebKitPoint* convertedP = WebKit::core(p);
    RefPtr<WebCore::WebKitPoint> gobjectResult = WTF::getPtr(item->webkitConvertPointFromPageToNode(convertedNode, convertedP));
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMWebKitPoint*
webkit_dom_dom_window_webkit_convert_point_from_node_to_page(WebKitDOMDOMWindow* self, WebKitDOMNode* node, WebKitDOMWebKitPoint* p)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(node), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_WEBKIT_POINT(p), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::WebKitPoint* convertedP = WebKit::core(p);
    RefPtr<WebCore::WebKitPoint> gobjectResult = WTF::getPtr(item->webkitConvertPointFromNodeToPage(convertedNode, convertedP));
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_dom_window_clear_timeout(WebKitDOMDOMWindow* self, glong handle)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->clearTimeout(handle);
}

void
webkit_dom_dom_window_clear_interval(WebKitDOMDOMWindow* self, glong handle)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->clearInterval(handle);
}

void
webkit_dom_dom_window_cancel_animation_frame(WebKitDOMDOMWindow* self, glong id)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->cancelAnimationFrame(id);
}

void
webkit_dom_dom_window_webkit_cancel_animation_frame(WebKitDOMDOMWindow* self, glong id)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->cancelAnimationFrame(id);
}

void
webkit_dom_dom_window_webkit_cancel_request_animation_frame(WebKitDOMDOMWindow* self, glong id)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->cancelAnimationFrame(id);
}

gchar*
webkit_dom_dom_window_atob(WebKitDOMDOMWindow* self, const gchar* string, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(string, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedString = WTF::String::fromUTF8(string);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->atob(convertedString, ec));
    return result;
}

gchar*
webkit_dom_dom_window_btoa(WebKitDOMDOMWindow* self, const gchar* string, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(string, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedString = WTF::String::fromUTF8(string);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->btoa(convertedString, ec));
    return result;
}

gboolean
webkit_dom_dom_window_dispatch_event(WebKitDOMDOMWindow* self, WebKitDOMEvent* evt, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(evt), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::Event* convertedEvt = WebKit::core(evt);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvt, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void
webkit_dom_dom_window_capture_events(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->captureEvents();
}

void
webkit_dom_dom_window_release_events(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    WebCore::DOMWindow* item = WebKit::core(self);
    item->releaseEvents();
}

WebKitDOMScreen*
webkit_dom_dom_window_get_screen(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Screen> gobjectResult = WTF::getPtr(item->screen());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHistory*
webkit_dom_dom_window_get_history(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::History> gobjectResult = WTF::getPtr(item->history());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_locationbar(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->locationbar());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_menubar(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->menubar());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_personalbar(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->personalbar());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_scrollbars(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->scrollbars());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_statusbar(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->statusbar());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMBarInfo*
webkit_dom_dom_window_get_toolbar(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::BarInfo> gobjectResult = WTF::getPtr(item->toolbar());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNavigator*
webkit_dom_dom_window_get_navigator(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Navigator> gobjectResult = WTF::getPtr(item->navigator());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMNavigator*
webkit_dom_dom_window_get_client_information(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Navigator> gobjectResult = WTF::getPtr(item->clientInformation());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMElement*
webkit_dom_dom_window_get_frame_element(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->frameElement());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_dom_window_get_offscreen_buffering(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), FALSE);
    WebCore::DOMWindow* item = WebKit::core(self);
    gboolean result = item->offscreenBuffering();
    return result;
}

glong
webkit_dom_dom_window_get_outer_height(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->outerHeight();
    return result;
}

glong
webkit_dom_dom_window_get_outer_width(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->outerWidth();
    return result;
}

glong
webkit_dom_dom_window_get_inner_height(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->innerHeight();
    return result;
}

glong
webkit_dom_dom_window_get_inner_width(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->innerWidth();
    return result;
}

glong
webkit_dom_dom_window_get_screen_x(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->screenX();
    return result;
}

glong
webkit_dom_dom_window_get_screen_y(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->screenY();
    return result;
}

glong
webkit_dom_dom_window_get_screen_left(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->screenLeft();
    return result;
}

glong
webkit_dom_dom_window_get_screen_top(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->screenTop();
    return result;
}

glong
webkit_dom_dom_window_get_scroll_x(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->scrollX();
    return result;
}

glong
webkit_dom_dom_window_get_scroll_y(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->scrollY();
    return result;
}

glong
webkit_dom_dom_window_get_page_x_offset(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->pageXOffset();
    return result;
}

glong
webkit_dom_dom_window_get_page_y_offset(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    glong result = item->pageYOffset();
    return result;
}

gboolean
webkit_dom_dom_window_get_closed(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), FALSE);
    WebCore::DOMWindow* item = WebKit::core(self);
    gboolean result = item->closed();
    return result;
}

gulong
webkit_dom_dom_window_get_length(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

gchar*
webkit_dom_dom_window_get_name(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

void
webkit_dom_dom_window_set_name(WebKitDOMDOMWindow* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    g_return_if_fail(value);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setName(convertedValue);
}

gchar*
webkit_dom_dom_window_get_status(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->status());
    return result;
}

void
webkit_dom_dom_window_set_status(WebKitDOMDOMWindow* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    g_return_if_fail(value);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setStatus(convertedValue);
}

gchar*
webkit_dom_dom_window_get_default_status(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->defaultStatus());
    return result;
}

void
webkit_dom_dom_window_set_default_status(WebKitDOMDOMWindow* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self));
    g_return_if_fail(value);
    WebCore::DOMWindow* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDefaultStatus(convertedValue);
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_self(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->self());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_window(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->window());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_frames(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->frames());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_opener(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->opener());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_parent(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->parent());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_dom_window_get_top(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->top());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDocument*
webkit_dom_dom_window_get_document(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->document());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMStyleMedia*
webkit_dom_dom_window_get_style_media(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::StyleMedia> gobjectResult = WTF::getPtr(item->styleMedia());
    return WebKit::kit(gobjectResult.get());
}

gdouble
webkit_dom_dom_window_get_device_pixel_ratio(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    gdouble result = item->devicePixelRatio();
    return result;
}

WebKitDOMDOMApplicationCache*
webkit_dom_dom_window_get_application_cache(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMApplicationCache> gobjectResult = WTF::getPtr(item->applicationCache());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMStorage*
webkit_dom_dom_window_get_session_storage(WebKitDOMDOMWindow* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Storage> gobjectResult = WTF::getPtr(item->sessionStorage(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMStorage*
webkit_dom_dom_window_get_local_storage(WebKitDOMDOMWindow* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Storage> gobjectResult = WTF::getPtr(item->localStorage(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMConsole*
webkit_dom_dom_window_get_console(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Console> gobjectResult = WTF::getPtr(item->console());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMPerformance*
webkit_dom_dom_window_get_performance(WebKitDOMDOMWindow* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::Performance> gobjectResult = WTF::getPtr(item->performance());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindowCSS*
webkit_dom_dom_window_get_css(WebKitDOMDOMWindow* self)
{
#if ENABLE(CSS3_CONDITIONAL_RULES)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindowCSS> gobjectResult = WTF::getPtr(item->css());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css3 Conditional Rules")
    return 0;
#endif /* ENABLE(CSS3_CONDITIONAL_RULES) */
}

WebKitDOMStorageInfo*
webkit_dom_dom_window_get_webkit_storage_info(WebKitDOMDOMWindow* self)
{
#if ENABLE(QUOTA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW(self), 0);
    WebCore::DOMWindow* item = WebKit::core(self);
    RefPtr<WebCore::StorageInfo> gobjectResult = WTF::getPtr(WebCore::DOMWindowQuota::webkitStorageInfo(item));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Quota")
    return 0;
#endif /* ENABLE(QUOTA) */
}

