/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLHRElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLHRElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLHRElement* kit(WebCore::HTMLHRElement* obj)
{
    return WEBKIT_DOM_HTMLHR_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLHRElement* core(WebKitDOMHTMLHRElement* request)
{
    return request ? static_cast<WebCore::HTMLHRElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLHRElement* wrapHTMLHRElement(WebCore::HTMLHRElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTMLHR_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTMLHR_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLHRElement, webkit_dom_htmlhr_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALIGN,
    PROP_NO_SHADE,
    PROP_SIZE,
    PROP_WIDTH,
};

static void webkit_dom_htmlhr_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLHRElement* self = WEBKIT_DOM_HTMLHR_ELEMENT(object);
    WebCore::HTMLHRElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NO_SHADE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::noshadeAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SIZE: {
        coreSelf->setAttribute(WebCore::HTMLNames::sizeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlhr_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLHRElement* self = WEBKIT_DOM_HTMLHR_ELEMENT(object);
    WebCore::HTMLHRElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_NO_SHADE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::noshadeAttr));
        break;
    }
    case PROP_SIZE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::sizeAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlhr_element_class_init(WebKitDOMHTMLHRElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_htmlhr_element_set_property;
    gobjectClass->get_property = webkit_dom_htmlhr_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "htmlhr_element_align", /* short description */
                                                           "read-write  gchar* HTMLHRElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NO_SHADE,
                                    g_param_spec_boolean("no-shade", /* name */
                                                           "htmlhr_element_no-shade", /* short description */
                                                           "read-write  gboolean HTMLHRElement.no-shade", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SIZE,
                                    g_param_spec_string("size", /* name */
                                                           "htmlhr_element_size", /* short description */
                                                           "read-write  gchar* HTMLHRElement.size", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "htmlhr_element_width", /* short description */
                                                           "read-write  gchar* HTMLHRElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_htmlhr_element_init(WebKitDOMHTMLHRElement* request)
{
}

gchar*
webkit_dom_htmlhr_element_get_align(WebKitDOMHTMLHRElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self), 0);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_htmlhr_element_set_align(WebKitDOMHTMLHRElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gboolean
webkit_dom_htmlhr_element_get_no_shade(WebKitDOMHTMLHRElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self), FALSE);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::noshadeAttr);
    return result;
}

void
webkit_dom_htmlhr_element_set_no_shade(WebKitDOMHTMLHRElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self));
    WebCore::HTMLHRElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::noshadeAttr, value);
}

gchar*
webkit_dom_htmlhr_element_get_size(WebKitDOMHTMLHRElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self), 0);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::sizeAttr));
    return result;
}

void
webkit_dom_htmlhr_element_set_size(WebKitDOMHTMLHRElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::sizeAttr, convertedValue);
}

gchar*
webkit_dom_htmlhr_element_get_width(WebKitDOMHTMLHRElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self), 0);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_htmlhr_element_set_width(WebKitDOMHTMLHRElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLHR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLHRElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

