/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFocusEvent.h"

#include "EventTarget.h"
#include "FocusEvent.h"
#include "JSDictionary.h"
#include "JSEventTarget.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFocusEventTableValues[] =
{
    { "relatedTarget", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFocusEventRelatedTarget), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFocusEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFocusEventTable = { 4, 3, JSFocusEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSFocusEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFocusEventConstructorTable = { 1, 0, JSFocusEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSFocusEventConstructor::constructJSFocusEvent(ExecState* exec)
{
    JSFocusEventConstructor* jsConstructor = jsCast<JSFocusEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    FocusEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillFocusEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<FocusEvent> event = FocusEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillFocusEventInit(FocusEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillUIEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("relatedTarget", eventInit.relatedTarget))
        return false;
    return true;
}

const ClassInfo JSFocusEventConstructor::s_info = { "FocusEventConstructor", &Base::s_info, &JSFocusEventConstructorTable, 0, CREATE_METHOD_TABLE(JSFocusEventConstructor) };

JSFocusEventConstructor::JSFocusEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFocusEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFocusEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSFocusEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFocusEventConstructor, JSDOMWrapper>(exec, &JSFocusEventConstructorTable, jsCast<JSFocusEventConstructor*>(cell), propertyName, slot);
}

bool JSFocusEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFocusEventConstructor, JSDOMWrapper>(exec, &JSFocusEventConstructorTable, jsCast<JSFocusEventConstructor*>(object), propertyName, descriptor);
}

#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
ConstructType JSFocusEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSFocusEvent;
    return ConstructTypeHost;
}
#endif // ENABLE(DOM4_EVENTS_CONSTRUCTOR)

/* Hash table for prototype */

static const HashTableValue JSFocusEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFocusEventPrototypeTable = { 1, 0, JSFocusEventPrototypeTableValues, 0 };
const ClassInfo JSFocusEventPrototype::s_info = { "FocusEventPrototype", &Base::s_info, &JSFocusEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSFocusEventPrototype) };

JSObject* JSFocusEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFocusEvent>(exec, globalObject);
}

const ClassInfo JSFocusEvent::s_info = { "FocusEvent", &Base::s_info, &JSFocusEventTable, 0 , CREATE_METHOD_TABLE(JSFocusEvent) };

JSFocusEvent::JSFocusEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FocusEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSFocusEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSFocusEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFocusEventPrototype::create(exec->globalData(), globalObject, JSFocusEventPrototype::createStructure(exec->globalData(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSFocusEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFocusEvent* thisObject = jsCast<JSFocusEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSFocusEvent, Base>(exec, &JSFocusEventTable, thisObject, propertyName, slot);
}

bool JSFocusEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFocusEvent* thisObject = jsCast<JSFocusEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSFocusEvent, Base>(exec, &JSFocusEventTable, thisObject, propertyName, descriptor);
}

JSValue jsFocusEventRelatedTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFocusEvent* castedThis = jsCast<JSFocusEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FocusEvent* impl = static_cast<FocusEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->relatedTarget()));
    return result;
}


JSValue jsFocusEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFocusEvent* domObject = jsCast<JSFocusEvent*>(asObject(slotBase));
    return JSFocusEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSFocusEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFocusEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
