/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMetaElement.h"

#include "HTMLMetaElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMetaElementTableValues[] =
{
    { "content", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMetaElementContent), (intptr_t)setJSHTMLMetaElementContent, NoIntrinsic },
    { "httpEquiv", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMetaElementHttpEquiv), (intptr_t)setJSHTMLMetaElementHttpEquiv, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMetaElementName), (intptr_t)setJSHTMLMetaElementName, NoIntrinsic },
    { "scheme", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMetaElementScheme), (intptr_t)setJSHTMLMetaElementScheme, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMetaElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMetaElementTable = { 17, 15, JSHTMLMetaElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLMetaElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMetaElementConstructorTable = { 1, 0, JSHTMLMetaElementConstructorTableValues, 0 };
const ClassInfo JSHTMLMetaElementConstructor::s_info = { "HTMLMetaElementConstructor", &Base::s_info, &JSHTMLMetaElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLMetaElementConstructor) };

JSHTMLMetaElementConstructor::JSHTMLMetaElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLMetaElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLMetaElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLMetaElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMetaElementConstructor, JSDOMWrapper>(exec, &JSHTMLMetaElementConstructorTable, jsCast<JSHTMLMetaElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLMetaElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMetaElementConstructor, JSDOMWrapper>(exec, &JSHTMLMetaElementConstructorTable, jsCast<JSHTMLMetaElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMetaElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMetaElementPrototypeTable = { 1, 0, JSHTMLMetaElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLMetaElementPrototype::s_info = { "HTMLMetaElementPrototype", &Base::s_info, &JSHTMLMetaElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLMetaElementPrototype) };

JSObject* JSHTMLMetaElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMetaElement>(exec, globalObject);
}

const ClassInfo JSHTMLMetaElement::s_info = { "HTMLMetaElement", &Base::s_info, &JSHTMLMetaElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLMetaElement) };

JSHTMLMetaElement::JSHTMLMetaElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMetaElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLMetaElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLMetaElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLMetaElementPrototype::create(exec->globalData(), globalObject, JSHTMLMetaElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMetaElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMetaElement* thisObject = jsCast<JSHTMLMetaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLMetaElement, Base>(exec, &JSHTMLMetaElementTable, thisObject, propertyName, slot);
}

bool JSHTMLMetaElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMetaElement* thisObject = jsCast<JSHTMLMetaElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLMetaElement, Base>(exec, &JSHTMLMetaElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLMetaElementContent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::contentAttr));
    return result;
}


JSValue jsHTMLMetaElementHttpEquiv(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::http_equivAttr));
    return result;
}


JSValue jsHTMLMetaElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLMetaElementScheme(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::schemeAttr));
    return result;
}


JSValue jsHTMLMetaElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMetaElement* domObject = jsCast<JSHTMLMetaElement*>(asObject(slotBase));
    return JSHTMLMetaElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLMetaElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLMetaElement* thisObject = jsCast<JSHTMLMetaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLMetaElement, Base>(exec, propertyName, value, &JSHTMLMetaElementTable, thisObject, slot);
}

void setJSHTMLMetaElementContent(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(thisObject);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::contentAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLMetaElementHttpEquiv(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(thisObject);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::http_equivAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLMetaElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(thisObject);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLMetaElementScheme(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMetaElement* castedThis = jsCast<JSHTMLMetaElement*>(thisObject);
    HTMLMetaElement* impl = static_cast<HTMLMetaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::schemeAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLMetaElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMetaElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
