/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLAnchorElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLAnchorElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLAnchorElement* kit(WebCore::HTMLAnchorElement* obj)
{
    return WEBKIT_DOM_HTML_ANCHOR_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLAnchorElement* core(WebKitDOMHTMLAnchorElement* request)
{
    return request ? static_cast<WebCore::HTMLAnchorElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLAnchorElement* wrapHTMLAnchorElement(WebCore::HTMLAnchorElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_ANCHOR_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_ANCHOR_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLAnchorElement, webkit_dom_html_anchor_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CHARSET,
    PROP_COORDS,
    PROP_DOWNLOAD,
    PROP_HREF,
    PROP_HREFLANG,
    PROP_NAME,
    PROP_PING,
    PROP_REL,
    PROP_REV,
    PROP_SHAPE,
    PROP_TARGET,
    PROP_TYPE,
    PROP_HASH,
    PROP_HOST,
    PROP_HOSTNAME,
    PROP_PATHNAME,
    PROP_PORT,
    PROP_PROTOCOL,
    PROP_SEARCH,
    PROP_ORIGIN,
    PROP_TEXT,
};

static void webkit_dom_html_anchor_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAnchorElement* self = WEBKIT_DOM_HTML_ANCHOR_ELEMENT(object);
    WebCore::HTMLAnchorElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CHARSET: {
        coreSelf->setAttribute(WebCore::HTMLNames::charsetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_COORDS: {
        coreSelf->setAttribute(WebCore::HTMLNames::coordsAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DOWNLOAD: {
#if ENABLE(DOWNLOAD_ATTRIBUTE)
        coreSelf->setAttribute(WebCore::HTMLNames::downloadAttr, WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Download Attribute")
#endif /* ENABLE(DOWNLOAD_ATTRIBUTE) */
        break;
    }
    case PROP_HREF: {
        coreSelf->setAttribute(WebCore::HTMLNames::hrefAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HREFLANG: {
        coreSelf->setAttribute(WebCore::HTMLNames::hreflangAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PING: {
        coreSelf->setAttribute(WebCore::HTMLNames::pingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REL: {
        coreSelf->setAttribute(WebCore::HTMLNames::relAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REV: {
        coreSelf->setAttribute(WebCore::HTMLNames::revAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SHAPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::shapeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::targetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HASH: {
        coreSelf->setHash(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HOST: {
        coreSelf->setHost(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HOSTNAME: {
        coreSelf->setHostname(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PATHNAME: {
        coreSelf->setPathname(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PORT: {
        coreSelf->setPort(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PROTOCOL: {
        coreSelf->setProtocol(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SEARCH: {
        coreSelf->setSearch(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_anchor_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAnchorElement* self = WEBKIT_DOM_HTML_ANCHOR_ELEMENT(object);
    WebCore::HTMLAnchorElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charsetAttr)));
        break;
    }
    case PROP_COORDS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::coordsAttr)));
        break;
    }
    case PROP_DOWNLOAD: {
#if ENABLE(DOWNLOAD_ATTRIBUTE)
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::downloadAttr)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Download Attribute")
#endif /* ENABLE(DOWNLOAD_ATTRIBUTE) */
        break;
    }
    case PROP_HREF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::hrefAttr)));
        break;
    }
    case PROP_HREFLANG: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::hreflangAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_PING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::pingAttr)));
        break;
    }
    case PROP_REL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::relAttr)));
        break;
    }
    case PROP_REV: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::revAttr)));
        break;
    }
    case PROP_SHAPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::shapeAttr)));
        break;
    }
    case PROP_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::targetAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_HASH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->hash()));
        break;
    }
    case PROP_HOST: {
        g_value_take_string(value, convertToUTF8String(coreSelf->host()));
        break;
    }
    case PROP_HOSTNAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->hostname()));
        break;
    }
    case PROP_PATHNAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->pathname()));
        break;
    }
    case PROP_PORT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->port()));
        break;
    }
    case PROP_PROTOCOL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->protocol()));
        break;
    }
    case PROP_SEARCH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->search()));
        break;
    }
    case PROP_ORIGIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->origin()));
        break;
    }
    case PROP_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->text()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_anchor_element_class_init(WebKitDOMHTMLAnchorElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_anchor_element_set_property;
    gobjectClass->get_property = webkit_dom_html_anchor_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CHARSET,
                                    g_param_spec_string("charset", /* name */
                                                           "html_anchor_element_charset", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COORDS,
                                    g_param_spec_string("coords", /* name */
                                                           "html_anchor_element_coords", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.coords", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOWNLOAD,
                                    g_param_spec_string("download", /* name */
                                                           "html_anchor_element_download", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.download", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREF,
                                    g_param_spec_string("href", /* name */
                                                           "html_anchor_element_href", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.href", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREFLANG,
                                    g_param_spec_string("hreflang", /* name */
                                                           "html_anchor_element_hreflang", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.hreflang", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_anchor_element_name", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PING,
                                    g_param_spec_string("ping", /* name */
                                                           "html_anchor_element_ping", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.ping", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REL,
                                    g_param_spec_string("rel", /* name */
                                                           "html_anchor_element_rel", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.rel", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REV,
                                    g_param_spec_string("rev", /* name */
                                                           "html_anchor_element_rev", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.rev", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHAPE,
                                    g_param_spec_string("shape", /* name */
                                                           "html_anchor_element_shape", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.shape", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_string("target", /* name */
                                                           "html_anchor_element_target", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_anchor_element_type", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HASH,
                                    g_param_spec_string("hash", /* name */
                                                           "html_anchor_element_hash", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.hash", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HOST,
                                    g_param_spec_string("host", /* name */
                                                           "html_anchor_element_host", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.host", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HOSTNAME,
                                    g_param_spec_string("hostname", /* name */
                                                           "html_anchor_element_hostname", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.hostname", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PATHNAME,
                                    g_param_spec_string("pathname", /* name */
                                                           "html_anchor_element_pathname", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.pathname", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PORT,
                                    g_param_spec_string("port", /* name */
                                                           "html_anchor_element_port", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.port", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PROTOCOL,
                                    g_param_spec_string("protocol", /* name */
                                                           "html_anchor_element_protocol", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.protocol", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SEARCH,
                                    g_param_spec_string("search", /* name */
                                                           "html_anchor_element_search", /* short description */
                                                           "read-write  gchar* HTMLAnchorElement.search", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ORIGIN,
                                    g_param_spec_string("origin", /* name */
                                                           "html_anchor_element_origin", /* short description */
                                                           "read-only  gchar* HTMLAnchorElement.origin", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "html_anchor_element_text", /* short description */
                                                           "read-only  gchar* HTMLAnchorElement.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_anchor_element_init(WebKitDOMHTMLAnchorElement* request)
{
}

gchar*
webkit_dom_html_anchor_element_get_charset(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_charset(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charsetAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_coords(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::coordsAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_coords(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::coordsAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_download(WebKitDOMHTMLAnchorElement* self)
{
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::downloadAttr));
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Download Attribute")
    return 0;
#endif /* ENABLE(DOWNLOAD_ATTRIBUTE) */
}

void
webkit_dom_html_anchor_element_set_download(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::downloadAttr, convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Download Attribute")
#endif /* ENABLE(DOWNLOAD_ATTRIBUTE) */
}

gchar*
webkit_dom_html_anchor_element_get_href(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_href(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::hrefAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_hreflang(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::hreflangAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_hreflang(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::hreflangAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_name(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_anchor_element_set_name(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_ping(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::pingAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_ping(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::pingAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_rel(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::relAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_rel(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::relAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_rev(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::revAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_rev(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::revAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_shape(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::shapeAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_shape(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::shapeAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_target(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}

void
webkit_dom_html_anchor_element_set_target(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::targetAttr, convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_hash(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->hash());
    return result;
}

void
webkit_dom_html_anchor_element_set_hash(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setHash(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_host(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->host());
    return result;
}

void
webkit_dom_html_anchor_element_set_host(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setHost(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_hostname(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->hostname());
    return result;
}

void
webkit_dom_html_anchor_element_set_hostname(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setHostname(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_pathname(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->pathname());
    return result;
}

void
webkit_dom_html_anchor_element_set_pathname(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setPathname(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_port(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->port());
    return result;
}

void
webkit_dom_html_anchor_element_set_port(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setPort(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_protocol(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->protocol());
    return result;
}

void
webkit_dom_html_anchor_element_set_protocol(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setProtocol(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_search(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->search());
    return result;
}

void
webkit_dom_html_anchor_element_set_search(WebKitDOMHTMLAnchorElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setSearch(convertedValue);
}

gchar*
webkit_dom_html_anchor_element_get_origin(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->origin());
    return result;
}

gchar*
webkit_dom_html_anchor_element_get_text(WebKitDOMHTMLAnchorElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_ANCHOR_ELEMENT(self), 0);
    WebCore::HTMLAnchorElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->text());
    return result;
}

