/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPerformanceTiming.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPerformanceTimingPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_PERFORMANCE_TIMING_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_PERFORMANCE_TIMING, WebKitDOMPerformanceTimingPrivate)

typedef struct _WebKitDOMPerformanceTimingPrivate {
#if ENABLE(WEB_TIMING)
    RefPtr<WebCore::PerformanceTiming> coreObject;
#endif // ENABLE(WEB_TIMING)
} WebKitDOMPerformanceTimingPrivate;

#if ENABLE(WEB_TIMING)

namespace WebKit {

WebKitDOMPerformanceTiming* kit(WebCore::PerformanceTiming* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PERFORMANCE_TIMING(ret);

    return wrapPerformanceTiming(obj);
}

WebCore::PerformanceTiming* core(WebKitDOMPerformanceTiming* request)
{
    return request ? static_cast<WebCore::PerformanceTiming*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPerformanceTiming* wrapPerformanceTiming(WebCore::PerformanceTiming* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PERFORMANCE_TIMING(g_object_new(WEBKIT_TYPE_DOM_PERFORMANCE_TIMING, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(WEB_TIMING)

G_DEFINE_TYPE(WebKitDOMPerformanceTiming, webkit_dom_performance_timing, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_NAVIGATION_START,
    PROP_UNLOAD_EVENT_START,
    PROP_UNLOAD_EVENT_END,
    PROP_REDIRECT_START,
    PROP_REDIRECT_END,
    PROP_FETCH_START,
    PROP_DOMAIN_LOOKUP_START,
    PROP_DOMAIN_LOOKUP_END,
    PROP_CONNECT_START,
    PROP_CONNECT_END,
    PROP_SECURE_CONNECTION_START,
    PROP_REQUEST_START,
    PROP_RESPONSE_START,
    PROP_RESPONSE_END,
    PROP_DOM_LOADING,
    PROP_DOM_INTERACTIVE,
    PROP_DOM_CONTENT_LOADED_EVENT_START,
    PROP_DOM_CONTENT_LOADED_EVENT_END,
    PROP_DOM_COMPLETE,
    PROP_LOAD_EVENT_START,
    PROP_LOAD_EVENT_END,
};

static void webkit_dom_performance_timing_finalize(GObject* object)
{
    WebKitDOMPerformanceTimingPrivate* priv = WEBKIT_DOM_PERFORMANCE_TIMING_GET_PRIVATE(object);
#if ENABLE(WEB_TIMING)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(WEB_TIMING)
    priv->~WebKitDOMPerformanceTimingPrivate();
    G_OBJECT_CLASS(webkit_dom_performance_timing_parent_class)->finalize(object);
}

static void webkit_dom_performance_timing_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformanceTiming* self = WEBKIT_DOM_PERFORMANCE_TIMING(object);
    WebCore::PerformanceTiming* coreSelf = WebKit::core(self);
#endif // ENABLE(WEB_TIMING)
    switch (propertyId) {
    case PROP_NAVIGATION_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->navigationStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_UNLOAD_EVENT_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->unloadEventStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_UNLOAD_EVENT_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->unloadEventEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_REDIRECT_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->redirectStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_REDIRECT_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->redirectEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_FETCH_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->fetchStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOMAIN_LOOKUP_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domainLookupStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOMAIN_LOOKUP_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domainLookupEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_CONNECT_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->connectStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_CONNECT_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->connectEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_SECURE_CONNECTION_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->secureConnectionStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_REQUEST_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->requestStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_RESPONSE_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->responseStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_RESPONSE_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->responseEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOM_LOADING: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domLoading());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOM_INTERACTIVE: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domInteractive());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOM_CONTENT_LOADED_EVENT_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domContentLoadedEventStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOM_CONTENT_LOADED_EVENT_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domContentLoadedEventEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_DOM_COMPLETE: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->domComplete());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_LOAD_EVENT_START: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->loadEventStart());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_LOAD_EVENT_END: {
#if ENABLE(WEB_TIMING)
        g_value_set_uint64(value, coreSelf->loadEventEnd());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_performance_timing_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_performance_timing_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformanceTimingPrivate* priv = WEBKIT_DOM_PERFORMANCE_TIMING_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::PerformanceTiming*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(WEB_TIMING)
    return object;
}

static void webkit_dom_performance_timing_class_init(WebKitDOMPerformanceTimingClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMPerformanceTimingPrivate));
    gobjectClass->constructor = webkit_dom_performance_timing_constructor;
    gobjectClass->finalize = webkit_dom_performance_timing_finalize;
    gobjectClass->get_property = webkit_dom_performance_timing_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAVIGATION_START,
                                    g_param_spec_uint64("navigation-start", /* name */
                                                           "performance_timing_navigation-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.navigation-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_UNLOAD_EVENT_START,
                                    g_param_spec_uint64("unload-event-start", /* name */
                                                           "performance_timing_unload-event-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.unload-event-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_UNLOAD_EVENT_END,
                                    g_param_spec_uint64("unload-event-end", /* name */
                                                           "performance_timing_unload-event-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.unload-event-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REDIRECT_START,
                                    g_param_spec_uint64("redirect-start", /* name */
                                                           "performance_timing_redirect-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.redirect-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REDIRECT_END,
                                    g_param_spec_uint64("redirect-end", /* name */
                                                           "performance_timing_redirect-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.redirect-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FETCH_START,
                                    g_param_spec_uint64("fetch-start", /* name */
                                                           "performance_timing_fetch-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.fetch-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOMAIN_LOOKUP_START,
                                    g_param_spec_uint64("domain-lookup-start", /* name */
                                                           "performance_timing_domain-lookup-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.domain-lookup-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOMAIN_LOOKUP_END,
                                    g_param_spec_uint64("domain-lookup-end", /* name */
                                                           "performance_timing_domain-lookup-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.domain-lookup-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONNECT_START,
                                    g_param_spec_uint64("connect-start", /* name */
                                                           "performance_timing_connect-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.connect-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONNECT_END,
                                    g_param_spec_uint64("connect-end", /* name */
                                                           "performance_timing_connect-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.connect-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SECURE_CONNECTION_START,
                                    g_param_spec_uint64("secure-connection-start", /* name */
                                                           "performance_timing_secure-connection-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.secure-connection-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REQUEST_START,
                                    g_param_spec_uint64("request-start", /* name */
                                                           "performance_timing_request-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.request-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RESPONSE_START,
                                    g_param_spec_uint64("response-start", /* name */
                                                           "performance_timing_response-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.response-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RESPONSE_END,
                                    g_param_spec_uint64("response-end", /* name */
                                                           "performance_timing_response-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.response-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOM_LOADING,
                                    g_param_spec_uint64("dom-loading", /* name */
                                                           "performance_timing_dom-loading", /* short description */
                                                           "read-only  guint64 PerformanceTiming.dom-loading", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOM_INTERACTIVE,
                                    g_param_spec_uint64("dom-interactive", /* name */
                                                           "performance_timing_dom-interactive", /* short description */
                                                           "read-only  guint64 PerformanceTiming.dom-interactive", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOM_CONTENT_LOADED_EVENT_START,
                                    g_param_spec_uint64("dom-content-loaded-event-start", /* name */
                                                           "performance_timing_dom-content-loaded-event-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.dom-content-loaded-event-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOM_CONTENT_LOADED_EVENT_END,
                                    g_param_spec_uint64("dom-content-loaded-event-end", /* name */
                                                           "performance_timing_dom-content-loaded-event-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.dom-content-loaded-event-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DOM_COMPLETE,
                                    g_param_spec_uint64("dom-complete", /* name */
                                                           "performance_timing_dom-complete", /* short description */
                                                           "read-only  guint64 PerformanceTiming.dom-complete", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOAD_EVENT_START,
                                    g_param_spec_uint64("load-event-start", /* name */
                                                           "performance_timing_load-event-start", /* short description */
                                                           "read-only  guint64 PerformanceTiming.load-event-start", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LOAD_EVENT_END,
                                    g_param_spec_uint64("load-event-end", /* name */
                                                           "performance_timing_load-event-end", /* short description */
                                                           "read-only  guint64 PerformanceTiming.load-event-end", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT64, /* min */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_performance_timing_init(WebKitDOMPerformanceTiming* request)
{
    WebKitDOMPerformanceTimingPrivate* priv = WEBKIT_DOM_PERFORMANCE_TIMING_GET_PRIVATE(request);
    new (priv) WebKitDOMPerformanceTimingPrivate();
}

guint64
webkit_dom_performance_timing_get_navigation_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->navigationStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_unload_event_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->unloadEventStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_unload_event_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->unloadEventEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_redirect_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->redirectStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_redirect_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->redirectEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_fetch_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->fetchStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_domain_lookup_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domainLookupStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_domain_lookup_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domainLookupEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_connect_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->connectStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_connect_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->connectEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_secure_connection_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->secureConnectionStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_request_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->requestStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_response_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->responseStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_response_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->responseEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_dom_loading(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domLoading();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_dom_interactive(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domInteractive();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_dom_content_loaded_event_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domContentLoadedEventStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_dom_content_loaded_event_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domContentLoadedEventEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_dom_complete(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->domComplete();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_load_event_start(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->loadEventStart();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

guint64
webkit_dom_performance_timing_get_load_event_end(WebKitDOMPerformanceTiming* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE_TIMING(self), 0);
    WebCore::PerformanceTiming* item = WebKit::core(self);
    guint64 result = item->loadEventEnd();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<guint64>(0);
#endif /* ENABLE(WEB_TIMING) */
}

