/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOptionElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLOptionElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOptionElementTableValues[] =
{
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementDisabled), (intptr_t)setJSHTMLOptionElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementForm), (intptr_t)0, NoIntrinsic },
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementLabel), (intptr_t)setJSHTMLOptionElementLabel, NoIntrinsic },
    { "defaultSelected", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementDefaultSelected), (intptr_t)setJSHTMLOptionElementDefaultSelected, NoIntrinsic },
    { "selected", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementSelected), (intptr_t)setJSHTMLOptionElementSelected, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementValue), (intptr_t)setJSHTMLOptionElementValue, NoIntrinsic },
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementText), (intptr_t)setJSHTMLOptionElementText, NoIntrinsic },
    { "index", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementIndex), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOptionElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptionElementTable = { 34, 31, JSHTMLOptionElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLOptionElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptionElementConstructorTable = { 1, 0, JSHTMLOptionElementConstructorTableValues, 0 };
const ClassInfo JSHTMLOptionElementConstructor::s_info = { "HTMLOptionElementConstructor", &Base::s_info, &JSHTMLOptionElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLOptionElementConstructor) };

JSHTMLOptionElementConstructor::JSHTMLOptionElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLOptionElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOptionElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLOptionElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionElementConstructor, JSDOMWrapper>(exec, &JSHTMLOptionElementConstructorTable, jsCast<JSHTMLOptionElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLOptionElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLOptionElementConstructor, JSDOMWrapper>(exec, &JSHTMLOptionElementConstructorTable, jsCast<JSHTMLOptionElementConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSHTMLOptionElementNamedConstructor::constructJSHTMLOptionElement(ExecState* exec)
{
    JSHTMLOptionElementNamedConstructor* castedThis = jsCast<JSHTMLOptionElementNamedConstructor*>(exec->callee());
    ExceptionCode ec = 0;
    const String& data(argumentOrNull(exec, 0).isEmpty() ? String() : argumentOrNull(exec, 0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(argumentOrNull(exec, 1).isEmpty() ? String() : argumentOrNull(exec, 1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool defaultSelected(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool selected(exec->argument(3).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<HTMLOptionElement> object = HTMLOptionElement::createForJSConstructor(castedThis->document(), data, value, defaultSelected, selected, ec);
    if (ec) {
        setDOMException(exec, ec);
        return JSValue::encode(JSValue());
    }
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

const ClassInfo JSHTMLOptionElementNamedConstructor::s_info = { "OptionConstructor", &Base::s_info, 0, 0, CREATE_METHOD_TABLE(JSHTMLOptionElementNamedConstructor) };

JSHTMLOptionElementNamedConstructor::JSHTMLOptionElementNamedConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorWithDocument(structure, globalObject)
{
}

void JSHTMLOptionElementNamedConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(globalObject);
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOptionElementPrototype::self(exec, globalObject), None);
}

ConstructType JSHTMLOptionElementNamedConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSHTMLOptionElement;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOptionElementPrototypeTable = { 1, 0, JSHTMLOptionElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLOptionElementPrototype::s_info = { "HTMLOptionElementPrototype", &Base::s_info, &JSHTMLOptionElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLOptionElementPrototype) };

JSObject* JSHTMLOptionElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOptionElement>(exec, globalObject);
}

const ClassInfo JSHTMLOptionElement::s_info = { "HTMLOptionElement", &Base::s_info, &JSHTMLOptionElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLOptionElement) };

JSHTMLOptionElement::JSHTMLOptionElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLOptionElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLOptionElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLOptionElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLOptionElementPrototype::create(exec->globalData(), globalObject, JSHTMLOptionElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOptionElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLOptionElement* thisObject = jsCast<JSHTMLOptionElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLOptionElement, Base>(exec, &JSHTMLOptionElementTable, thisObject, propertyName, slot);
}

bool JSHTMLOptionElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLOptionElement* thisObject = jsCast<JSHTMLOptionElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLOptionElement, Base>(exec, &JSHTMLOptionElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLOptionElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLOptionElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLOptionElementLabel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->label());
    return result;
}


JSValue jsHTMLOptionElementDefaultSelected(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::selectedAttr));
    return result;
}


JSValue jsHTMLOptionElementSelected(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->selected());
    return result;
}


JSValue jsHTMLOptionElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsHTMLOptionElementText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->text());
    return result;
}


JSValue jsHTMLOptionElementIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->index());
    return result;
}


JSValue jsHTMLOptionElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOptionElement* domObject = jsCast<JSHTMLOptionElement*>(asObject(slotBase));
    return JSHTMLOptionElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLOptionElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLOptionElement* thisObject = jsCast<JSHTMLOptionElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLOptionElement, Base>(exec, propertyName, value, &JSHTMLOptionElementTable, thisObject, slot);
}

void setJSHTMLOptionElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLOptionElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    impl->setLabel(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSHTMLOptionElementDefaultSelected(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::selectedAttr, value.toBoolean(exec));
}


void setJSHTMLOptionElementSelected(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    impl->setSelected(value.toBoolean(exec));
}


void setJSHTMLOptionElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    impl->setValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSHTMLOptionElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOptionElement* castedThis = jsCast<JSHTMLOptionElement*>(thisObject);
    HTMLOptionElement* impl = static_cast<HTMLOptionElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setText(value.isEmpty() ? String() : value.toString(exec)->value(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSHTMLOptionElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOptionElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

HTMLOptionElement* toHTMLOptionElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLOptionElement::s_info) ? jsCast<JSHTMLOptionElement*>(asObject(value))->impl() : 0;
}

}
