/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLPreElement.h"

#include "HTMLNames.h"
#include "HTMLPreElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLPreElementTableValues[] =
{
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementWidth), (intptr_t)setJSHTMLPreElementWidth, NoIntrinsic },
    { "wrap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementWrap), (intptr_t)setJSHTMLPreElementWrap, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPreElementTable = { 9, 7, JSHTMLPreElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLPreElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPreElementConstructorTable = { 1, 0, JSHTMLPreElementConstructorTableValues, 0 };
const ClassInfo JSHTMLPreElementConstructor::s_info = { "HTMLPreElementConstructor", &Base::s_info, &JSHTMLPreElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLPreElementConstructor) };

JSHTMLPreElementConstructor::JSHTMLPreElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLPreElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLPreElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLPreElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLPreElementConstructor, JSDOMWrapper>(exec, &JSHTMLPreElementConstructorTable, jsCast<JSHTMLPreElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLPreElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLPreElementConstructor, JSDOMWrapper>(exec, &JSHTMLPreElementConstructorTable, jsCast<JSHTMLPreElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLPreElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLPreElementPrototypeTable = { 1, 0, JSHTMLPreElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLPreElementPrototype::s_info = { "HTMLPreElementPrototype", &Base::s_info, &JSHTMLPreElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLPreElementPrototype) };

JSObject* JSHTMLPreElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLPreElement>(exec, globalObject);
}

const ClassInfo JSHTMLPreElement::s_info = { "HTMLPreElement", &Base::s_info, &JSHTMLPreElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLPreElement) };

JSHTMLPreElement::JSHTMLPreElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLPreElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLPreElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLPreElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLPreElementPrototype::create(exec->globalData(), globalObject, JSHTMLPreElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLPreElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLPreElement* thisObject = jsCast<JSHTMLPreElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLPreElement, Base>(exec, &JSHTMLPreElementTable, thisObject, propertyName, slot);
}

bool JSHTMLPreElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLPreElement* thisObject = jsCast<JSHTMLPreElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLPreElement, Base>(exec, &JSHTMLPreElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLPreElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPreElement* castedThis = jsCast<JSHTMLPreElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLPreElement* impl = static_cast<HTMLPreElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->getIntegralAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLPreElementWrap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPreElement* castedThis = jsCast<JSHTMLPreElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLPreElement* impl = static_cast<HTMLPreElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::wrapAttr));
    return result;
}


JSValue jsHTMLPreElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLPreElement* domObject = jsCast<JSHTMLPreElement*>(asObject(slotBase));
    return JSHTMLPreElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLPreElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLPreElement* thisObject = jsCast<JSHTMLPreElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLPreElement, Base>(exec, propertyName, value, &JSHTMLPreElementTable, thisObject, slot);
}

void setJSHTMLPreElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLPreElement* castedThis = jsCast<JSHTMLPreElement*>(thisObject);
    HTMLPreElement* impl = static_cast<HTMLPreElement*>(castedThis->impl());
    impl->setIntegralAttribute(WebCore::HTMLNames::widthAttr, value.toInt32(exec));
}


void setJSHTMLPreElementWrap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLPreElement* castedThis = jsCast<JSHTMLPreElement*>(thisObject);
    HTMLPreElement* impl = static_cast<HTMLPreElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::wrapAttr, value.toBoolean(exec));
}


JSValue JSHTMLPreElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLPreElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
