/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSNode_h
#define JSNode_h

#include "JSDOMBinding.h"
#include "Node.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/Lookup.h>
#include <runtime/ObjectPrototype.h>
#include <wtf/AlwaysInline.h>

namespace WebCore {

class JSNode : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSNode* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Node> impl)
    {
        JSNode* ptr = new (NotNull, JSC::allocateCell<JSNode>(globalObject->globalData().heap)) JSNode(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void destroy(JSC::JSCell*);
    ~JSNode();
    static WEBKIT_EXPORTDATA const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    JSC::JSScope* pushEventHandlerScope(JSC::ExecState*, JSC::JSScope*) const;

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);


    // Custom functions
    JSC::JSValue insertBefore(JSC::ExecState*);
    JSC::JSValue replaceChild(JSC::ExecState*);
    JSC::JSValue removeChild(JSC::ExecState*);
    JSC::JSValue appendChild(JSC::ExecState*);
    Node* impl() const { return m_impl; }
    void releaseImpl() { m_impl->deref(); m_impl = 0; }

    void releaseImplIfNotNull() { if (m_impl) { m_impl->deref(); m_impl = 0; } }

private:
    Node* m_impl;
protected:
    JSNode(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<Node>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

ALWAYS_INLINE bool JSNode::getOwnPropertySlot(JSC::JSCell* cell, JSC::ExecState* exec, JSC::PropertyName propertyName, JSC::PropertySlot& slot)
{
    JSNode* thisObject = JSC::jsCast<JSNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return JSC::getStaticValueSlot<JSNode, Base>(exec, s_info.staticPropHashTable, thisObject, propertyName, slot);
}

ALWAYS_INLINE bool JSNode::getOwnPropertyDescriptor(JSC::JSObject* object, JSC::ExecState* exec, JSC::PropertyName propertyName, JSC::PropertyDescriptor& descriptor)
{
    JSNode* thisObject = JSC::jsCast<JSNode*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return JSC::getStaticValueDescriptor<JSNode, Base>(exec, s_info.staticPropHashTable, thisObject, propertyName, descriptor);
}

class JSNodeOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld*, Node*)
{
    DEFINE_STATIC_LOCAL(JSNodeOwner, jsNodeOwner, ());
    return &jsNodeOwner;
}

inline void* wrapperContext(DOMWrapperWorld* world, Node*)
{
    return world;
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, Node*);
Node* toNode(JSC::JSValue);
JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject*, Node*);

class JSNodePrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSNodePrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSNodePrototype>(globalData.heap)) JSNodePrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSNodePrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSNodeConstructor : public DOMConstructorObject {
private:
    JSNodeConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSNodeConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSNodeConstructor* ptr = new (NotNull, JSC::allocateCell<JSNodeConstructor>(*exec->heap())) JSNodeConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionInsertBefore(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionReplaceChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAppendChild(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionHasChildNodes(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCloneNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionNormalize(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSupported(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsSameNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsEqualNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupPrefix(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionIsDefaultNamespace(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionLookupNamespaceURI(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionCompareDocumentPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionContains(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsNodePrototypeFunctionDispatchEvent(JSC::ExecState*);
// Attributes

JSC::JSValue jsNodeNodeName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeNodeValue(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSNodeNodeValue(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeNodeType(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeParentNode(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeChildNodes(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeFirstChild(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeLastChild(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodePreviousSibling(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeNextSibling(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeOwnerDocument(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeNamespaceURI(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodePrefix(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSNodePrefix(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeLocalName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeBaseURI(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeTextContent(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSNodeTextContent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsNodeParentElement(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
// Constants

JSC::JSValue jsNodeELEMENT_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeATTRIBUTE_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeTEXT_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeCDATA_SECTION_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeENTITY_REFERENCE_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeENTITY_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodePROCESSING_INSTRUCTION_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeCOMMENT_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_TYPE_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_FRAGMENT_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeNOTATION_NODE(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_DISCONNECTED(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_PRECEDING(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_FOLLOWING(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_CONTAINS(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_CONTAINED_BY(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsNodeDOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif
#include "JSNodeCustom.h"
