/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGCircleElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGCircleElement.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGCircleElementTableValues[] =
{
    { "cx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementCx), (intptr_t)0, NoIntrinsic },
    { "cy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementCy), (intptr_t)0, NoIntrinsic },
    { "r", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementR), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementXmllang), (intptr_t)setJSSVGCircleElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementXmlspace), (intptr_t)setJSSVGCircleElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementTable = { 35, 31, JSSVGCircleElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGCircleElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementConstructorTable = { 1, 0, JSSVGCircleElementConstructorTableValues, 0 };
const ClassInfo JSSVGCircleElementConstructor::s_info = { "SVGCircleElementConstructor", &Base::s_info, &JSSVGCircleElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGCircleElementConstructor) };

JSSVGCircleElementConstructor::JSSVGCircleElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGCircleElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGCircleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGCircleElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGCircleElementConstructor, JSDOMWrapper>(exec, &JSSVGCircleElementConstructorTable, jsCast<JSSVGCircleElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGCircleElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGCircleElementConstructor, JSDOMWrapper>(exec, &JSSVGCircleElementConstructorTable, jsCast<JSSVGCircleElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGCircleElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGCircleElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGCircleElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGCircleElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGCircleElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGCircleElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementPrototypeTable = { 17, 15, JSSVGCircleElementPrototypeTableValues, 0 };
const ClassInfo JSSVGCircleElementPrototype::s_info = { "SVGCircleElementPrototype", &Base::s_info, &JSSVGCircleElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGCircleElementPrototype) };

JSObject* JSSVGCircleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGCircleElement>(exec, globalObject);
}

bool JSSVGCircleElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGCircleElementPrototype* thisObject = jsCast<JSSVGCircleElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGCircleElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGCircleElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGCircleElementPrototype* thisObject = jsCast<JSSVGCircleElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGCircleElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGCircleElement::s_info = { "SVGCircleElement", &Base::s_info, &JSSVGCircleElementTable, 0 , CREATE_METHOD_TABLE(JSSVGCircleElement) };

JSSVGCircleElement::JSSVGCircleElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGCircleElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGCircleElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGCircleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGCircleElementPrototype::create(exec->globalData(), globalObject, JSSVGCircleElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGCircleElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGCircleElement* thisObject = jsCast<JSSVGCircleElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGCircleElement, Base>(exec, &JSSVGCircleElementTable, thisObject, propertyName, slot);
}

bool JSSVGCircleElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGCircleElement* thisObject = jsCast<JSSVGCircleElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGCircleElement, Base>(exec, &JSSVGCircleElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGCircleElementCx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementCy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cyAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementR(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->rAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGCircleElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGCircleElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGCircleElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGCircleElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGCircleElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGCircleElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGCircleElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* domObject = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    return JSSVGCircleElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGCircleElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGCircleElement* thisObject = jsCast<JSSVGCircleElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGCircleElement, Base>(exec, propertyName, value, &JSSVGCircleElementTable, thisObject, slot);
}

void setJSSVGCircleElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(thisObject);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGCircleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(thisObject);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGCircleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGCircleElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGCircleElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGCircleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGCircleElement::s_info);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGCircleElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGCircleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGCircleElement::s_info);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGCircleElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGCircleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGCircleElement::s_info);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGCircleElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGCircleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGCircleElement::s_info);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGCircleElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGCircleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGCircleElement::s_info);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
