/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGNumberList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGNumber.h"
#include "SVGNumberList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGNumberListTableValues[] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberListNumberOfItems), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGNumberListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGNumberListTable = { 4, 3, JSSVGNumberListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGNumberListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGNumberListConstructorTable = { 1, 0, JSSVGNumberListConstructorTableValues, 0 };
const ClassInfo JSSVGNumberListConstructor::s_info = { "SVGNumberListConstructor", &Base::s_info, &JSSVGNumberListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGNumberListConstructor) };

JSSVGNumberListConstructor::JSSVGNumberListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGNumberListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGNumberListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGNumberListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberListConstructor, JSDOMWrapper>(exec, &JSSVGNumberListConstructorTable, jsCast<JSSVGNumberListConstructor*>(cell), propertyName, slot);
}

bool JSSVGNumberListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGNumberListConstructor, JSDOMWrapper>(exec, &JSSVGNumberListConstructorTable, jsCast<JSSVGNumberListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGNumberListPrototypeTableValues[] =
{
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "initialize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionInitialize), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "insertItemBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionInsertItemBefore), (intptr_t)2, NoIntrinsic },
    { "replaceItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionReplaceItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "appendItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGNumberListPrototypeFunctionAppendItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGNumberListPrototypeTable = { 18, 15, JSSVGNumberListPrototypeTableValues, 0 };
const ClassInfo JSSVGNumberListPrototype::s_info = { "SVGNumberListPrototype", &Base::s_info, &JSSVGNumberListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGNumberListPrototype) };

JSObject* JSSVGNumberListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGNumberList>(exec, globalObject);
}

bool JSSVGNumberListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGNumberListPrototype* thisObject = jsCast<JSSVGNumberListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGNumberListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGNumberListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGNumberListPrototype* thisObject = jsCast<JSSVGNumberListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGNumberListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGNumberList::s_info = { "SVGNumberList", &Base::s_info, &JSSVGNumberListTable, 0 , CREATE_METHOD_TABLE(JSSVGNumberList) };

JSSVGNumberList::JSSVGNumberList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGListPropertyTearOff<SVGNumberList> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGNumberList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGNumberList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGNumberListPrototype::create(exec->globalData(), globalObject, JSSVGNumberListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGNumberList::destroy(JSC::JSCell* cell)
{
    JSSVGNumberList* thisObject = static_cast<JSSVGNumberList*>(cell);
    thisObject->JSSVGNumberList::~JSSVGNumberList();
}

JSSVGNumberList::~JSSVGNumberList()
{
    releaseImplIfNotNull();
}

bool JSSVGNumberList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGNumberList* thisObject = jsCast<JSSVGNumberList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, thisObject, propertyName, slot);
}

bool JSSVGNumberList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGNumberList* thisObject = jsCast<JSSVGNumberList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGNumberListNumberOfItems(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JSValue result =  jsNumber(castedThis->impl()->numberOfItems());
    return result;
}


JSValue jsSVGNumberListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGNumberList* domObject = jsCast<JSSVGNumberList*>(asObject(slotBase));
    return JSSVGNumberList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGNumberList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGNumberListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGNumber::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<float>* item(toSVGNumber(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initialize(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGNumber::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<float>* item(toSVGNumber(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertItemBefore(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGNumber::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<float>* item(toSVGNumber(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->replaceItem(item, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwVMTypeError(exec);
    JSSVGNumberList* castedThis = jsCast<JSSVGNumberList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGNumberList::s_info);
    SVGListPropertyTearOff<SVGNumberList> * impl = static_cast<SVGListPropertyTearOff<SVGNumberList> *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGNumber::s_info))
        return throwVMTypeError(exec);
    SVGPropertyTearOff<float>* item(toSVGNumber(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->appendItem(item, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGNumberList* jsSVGNumberList)
{
    if (jsSVGNumberList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGNumberListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGNumberList* jsSVGNumberList = jsCast<JSSVGNumberList*>(handle.get().asCell());
    if (!isObservable(jsSVGNumberList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGNumberListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGNumberList* jsSVGNumberList = jsCast<JSSVGNumberList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGNumberList->impl(), jsSVGNumberList);
    jsSVGNumberList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGListPropertyTearOff<SVGNumberList> * impl)
{
    return wrap<JSSVGNumberList>(exec, globalObject, impl);
}

SVGListPropertyTearOff<SVGNumberList> * toSVGNumberList(JSC::JSValue value)
{
    return value.inherits(&JSSVGNumberList::s_info) ? jsCast<JSSVGNumberList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
