/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRenderingIntent.h"

#include "SVGRenderingIntent.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGRenderingIntentTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRenderingIntentTable = { 2, 1, JSSVGRenderingIntentTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGRenderingIntentConstructorTableValues[] =
{
    { "RENDERING_INTENT_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_AUTO), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_PERCEPTUAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_SATURATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_SATURATION), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRenderingIntentConstructorTable = { 16, 15, JSSVGRenderingIntentConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGRenderingIntent::RENDERING_INTENT_UNKNOWN, SVGRenderingIntentEnumRENDERING_INTENT_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGRenderingIntent::RENDERING_INTENT_AUTO, SVGRenderingIntentEnumRENDERING_INTENT_AUTOIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGRenderingIntent::RENDERING_INTENT_PERCEPTUAL, SVGRenderingIntentEnumRENDERING_INTENT_PERCEPTUALIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGRenderingIntent::RENDERING_INTENT_RELATIVE_COLORIMETRIC, SVGRenderingIntentEnumRENDERING_INTENT_RELATIVE_COLORIMETRICIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGRenderingIntent::RENDERING_INTENT_SATURATION, SVGRenderingIntentEnumRENDERING_INTENT_SATURATIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGRenderingIntent::RENDERING_INTENT_ABSOLUTE_COLORIMETRIC, SVGRenderingIntentEnumRENDERING_INTENT_ABSOLUTE_COLORIMETRICIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGRenderingIntentConstructor::s_info = { "SVGRenderingIntentConstructor", &Base::s_info, &JSSVGRenderingIntentConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGRenderingIntentConstructor) };

JSSVGRenderingIntentConstructor::JSSVGRenderingIntentConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGRenderingIntentConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGRenderingIntentPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGRenderingIntentConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRenderingIntentConstructor, JSDOMWrapper>(exec, &JSSVGRenderingIntentConstructorTable, jsCast<JSSVGRenderingIntentConstructor*>(cell), propertyName, slot);
}

bool JSSVGRenderingIntentConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRenderingIntentConstructor, JSDOMWrapper>(exec, &JSSVGRenderingIntentConstructorTable, jsCast<JSSVGRenderingIntentConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRenderingIntentPrototypeTableValues[] =
{
    { "RENDERING_INTENT_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_AUTO", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_AUTO), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_PERCEPTUAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_RELATIVE_COLORIMETRIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_SATURATION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_SATURATION), (intptr_t)0, NoIntrinsic },
    { "RENDERING_INTENT_ABSOLUTE_COLORIMETRIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRenderingIntentPrototypeTable = { 16, 15, JSSVGRenderingIntentPrototypeTableValues, 0 };
const ClassInfo JSSVGRenderingIntentPrototype::s_info = { "SVGRenderingIntentPrototype", &Base::s_info, &JSSVGRenderingIntentPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGRenderingIntentPrototype) };

JSObject* JSSVGRenderingIntentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRenderingIntent>(exec, globalObject);
}

bool JSSVGRenderingIntentPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRenderingIntentPrototype* thisObject = jsCast<JSSVGRenderingIntentPrototype*>(cell);
    return getStaticValueSlot<JSSVGRenderingIntentPrototype, JSObject>(exec, &JSSVGRenderingIntentPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGRenderingIntentPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRenderingIntentPrototype* thisObject = jsCast<JSSVGRenderingIntentPrototype*>(object);
    return getStaticValueDescriptor<JSSVGRenderingIntentPrototype, JSObject>(exec, &JSSVGRenderingIntentPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGRenderingIntent::s_info = { "SVGRenderingIntent", &Base::s_info, &JSSVGRenderingIntentTable, 0 , CREATE_METHOD_TABLE(JSSVGRenderingIntent) };

JSSVGRenderingIntent::JSSVGRenderingIntent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGRenderingIntent> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGRenderingIntent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGRenderingIntent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGRenderingIntentPrototype::create(exec->globalData(), globalObject, JSSVGRenderingIntentPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGRenderingIntent::destroy(JSC::JSCell* cell)
{
    JSSVGRenderingIntent* thisObject = static_cast<JSSVGRenderingIntent*>(cell);
    thisObject->JSSVGRenderingIntent::~JSSVGRenderingIntent();
}

JSSVGRenderingIntent::~JSSVGRenderingIntent()
{
    releaseImplIfNotNull();
}

bool JSSVGRenderingIntent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRenderingIntent* thisObject = jsCast<JSSVGRenderingIntent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGRenderingIntent, Base>(exec, &JSSVGRenderingIntentTable, thisObject, propertyName, slot);
}

bool JSSVGRenderingIntent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRenderingIntent* thisObject = jsCast<JSSVGRenderingIntent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGRenderingIntent, Base>(exec, &JSSVGRenderingIntentTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGRenderingIntentConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRenderingIntent* domObject = jsCast<JSSVGRenderingIntent*>(asObject(slotBase));
    return JSSVGRenderingIntent::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGRenderingIntent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRenderingIntentConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGRenderingIntentRENDERING_INTENT_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGRenderingIntentRENDERING_INTENT_AUTO(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGRenderingIntentRENDERING_INTENT_PERCEPTUAL(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGRenderingIntentRENDERING_INTENT_RELATIVE_COLORIMETRIC(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGRenderingIntentRENDERING_INTENT_SATURATION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSVGRenderingIntentRENDERING_INTENT_ABSOLUTE_COLORIMETRIC(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

static inline bool isObservable(JSSVGRenderingIntent* jsSVGRenderingIntent)
{
    if (jsSVGRenderingIntent->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGRenderingIntentOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGRenderingIntent* jsSVGRenderingIntent = jsCast<JSSVGRenderingIntent*>(handle.get().asCell());
    if (!isObservable(jsSVGRenderingIntent))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGRenderingIntentOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGRenderingIntent* jsSVGRenderingIntent = jsCast<JSSVGRenderingIntent*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGRenderingIntent->impl(), jsSVGRenderingIntent);
    jsSVGRenderingIntent->releaseImpl();
}

SVGRenderingIntent* toSVGRenderingIntent(JSC::JSValue value)
{
    return value.inherits(&JSSVGRenderingIntent::s_info) ? jsCast<JSSVGRenderingIntent*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
