/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLInputElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMFileListPrivate.h"
#include "WebKitDOMHTMLElementPrivate.h"
#include "WebKitDOMHTMLFormElementPrivate.h"
#include "WebKitDOMHTMLInputElementPrivate.h"
#include "WebKitDOMNodeListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMValidityStatePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLInputElement* kit(WebCore::HTMLInputElement* obj)
{
    return WEBKIT_DOM_HTML_INPUT_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLInputElement* core(WebKitDOMHTMLInputElement* request)
{
    return request ? static_cast<WebCore::HTMLInputElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLInputElement* wrapHTMLInputElement(WebCore::HTMLInputElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_INPUT_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_INPUT_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLInputElement, webkit_dom_html_input_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ACCEPT,
    PROP_ALT,
    PROP_AUTOCOMPLETE,
    PROP_AUTOFOCUS,
    PROP_DEFAULT_CHECKED,
    PROP_CHECKED,
    PROP_DIR_NAME,
    PROP_DISABLED,
    PROP_FORM,
    PROP_FILES,
    PROP_FORM_ACTION,
    PROP_FORM_ENCTYPE,
    PROP_FORM_METHOD,
    PROP_FORM_NO_VALIDATE,
    PROP_FORM_TARGET,
    PROP_HEIGHT,
    PROP_INDETERMINATE,
    PROP_LIST,
    PROP_MAX,
    PROP_MAX_LENGTH,
    PROP_MIN,
    PROP_MULTIPLE,
    PROP_NAME,
    PROP_PATTERN,
    PROP_PLACEHOLDER,
    PROP_READ_ONLY,
    PROP_REQUIRED,
    PROP_SIZE,
    PROP_SRC,
    PROP_STEP,
    PROP_TYPE,
    PROP_DEFAULT_VALUE,
    PROP_VALUE,
    PROP_VALUE_AS_NUMBER,
    PROP_WIDTH,
    PROP_WILL_VALIDATE,
    PROP_VALIDITY,
    PROP_VALIDATION_MESSAGE,
    PROP_LABELS,
    PROP_ALIGN,
    PROP_WEBKITDIRECTORY,
    PROP_USE_MAP,
    PROP_INCREMENTAL,
    PROP_WEBKIT_SPEECH,
    PROP_WEBKIT_GRAMMAR,
    PROP_CAPTURE,
};

static void webkit_dom_html_input_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLInputElement* self = WEBKIT_DOM_HTML_INPUT_ELEMENT(object);
    WebCore::HTMLInputElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ACCEPT: {
        coreSelf->setAttribute(WebCore::HTMLNames::acceptAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALT: {
        coreSelf->setAttribute(WebCore::HTMLNames::altAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_AUTOCOMPLETE: {
        coreSelf->setAttribute(WebCore::HTMLNames::autocompleteAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_AUTOFOCUS: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_DEFAULT_CHECKED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::checkedAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_CHECKED: {
        coreSelf->setChecked((g_value_get_boolean(value)));
        break;
    }
    case PROP_DIR_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::dirnameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_FORM_ACTION: {
        coreSelf->setAttribute(WebCore::HTMLNames::formactionAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_ENCTYPE: {
        coreSelf->setFormEnctype(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_METHOD: {
        coreSelf->setFormMethod(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FORM_NO_VALIDATE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_FORM_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::formtargetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setHeight((g_value_get_ulong(value)));
        break;
    }
    case PROP_INDETERMINATE: {
        coreSelf->setIndeterminate((g_value_get_boolean(value)));
        break;
    }
    case PROP_MAX: {
        coreSelf->setAttribute(WebCore::HTMLNames::maxAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MAX_LENGTH: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setMaxLength((g_value_get_long(value)), ec);
        break;
    }
    case PROP_MIN: {
        coreSelf->setAttribute(WebCore::HTMLNames::minAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MULTIPLE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::multipleAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PATTERN: {
        coreSelf->setAttribute(WebCore::HTMLNames::patternAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_PLACEHOLDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::placeholderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_READ_ONLY: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_REQUIRED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SIZE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setSize((g_value_get_ulong(value)), ec);
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_STEP: {
        coreSelf->setAttribute(WebCore::HTMLNames::stepAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setType(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DEFAULT_VALUE: {
        coreSelf->setDefaultValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE_AS_NUMBER: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setValueAsNumber((g_value_get_double(value)), ec);
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setWidth((g_value_get_ulong(value)));
        break;
    }
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WEBKITDIRECTORY: {
#if ENABLE(DIRECTORY_UPLOAD)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::webkitdirectoryAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Directory Upload")
#endif /* ENABLE(DIRECTORY_UPLOAD) */
        break;
    }
    case PROP_USE_MAP: {
        coreSelf->setAttribute(WebCore::HTMLNames::usemapAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_INCREMENTAL: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::incrementalAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_WEBKIT_SPEECH: {
#if ENABLE(INPUT_SPEECH)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::webkitspeechAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
        break;
    }
    case PROP_WEBKIT_GRAMMAR: {
#if ENABLE(INPUT_SPEECH)
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::webkitgrammarAttr, (g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
        break;
    }
    case PROP_CAPTURE: {
#if ENABLE(MEDIA_CAPTURE)
        coreSelf->setCapture(WTF::String::fromUTF8(g_value_get_string(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Capture")
#endif /* ENABLE(MEDIA_CAPTURE) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_input_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLInputElement* self = WEBKIT_DOM_HTML_INPUT_ELEMENT(object);
    WebCore::HTMLInputElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ACCEPT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::acceptAttr)));
        break;
    }
    case PROP_ALT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::altAttr)));
        break;
    }
    case PROP_AUTOCOMPLETE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::autocompleteAttr)));
        break;
    }
    case PROP_AUTOFOCUS: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
        break;
    }
    case PROP_DEFAULT_CHECKED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::checkedAttr));
        break;
    }
    case PROP_CHECKED: {
        g_value_set_boolean(value, coreSelf->checked());
        break;
    }
    case PROP_DIR_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::dirnameAttr)));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_FORM: {
        RefPtr<WebCore::HTMLFormElement> ptr = coreSelf->form();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FILES: {
        RefPtr<WebCore::FileList> ptr = coreSelf->files();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FORM_ACTION: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::formactionAttr)));
        break;
    }
    case PROP_FORM_ENCTYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->formEnctype()));
        break;
    }
    case PROP_FORM_METHOD: {
        g_value_take_string(value, convertToUTF8String(coreSelf->formMethod()));
        break;
    }
    case PROP_FORM_NO_VALIDATE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::formnovalidateAttr));
        break;
    }
    case PROP_FORM_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::formtargetAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_ulong(value, coreSelf->height());
        break;
    }
    case PROP_INDETERMINATE: {
        g_value_set_boolean(value, coreSelf->indeterminate());
        break;
    }
    case PROP_LIST: {
#if ENABLE(DATALIST_ELEMENT)
        RefPtr<WebCore::HTMLElement> ptr = coreSelf->list();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Datalist Element")
#endif /* ENABLE(DATALIST_ELEMENT) */
        break;
    }
    case PROP_MAX: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::maxAttr)));
        break;
    }
    case PROP_MAX_LENGTH: {
        g_value_set_long(value, coreSelf->maxLength());
        break;
    }
    case PROP_MIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::minAttr)));
        break;
    }
    case PROP_MULTIPLE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::multipleAttr));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_PATTERN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::patternAttr)));
        break;
    }
    case PROP_PLACEHOLDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::placeholderAttr)));
        break;
    }
    case PROP_READ_ONLY: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::readonlyAttr));
        break;
    }
    case PROP_REQUIRED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::requiredAttr));
        break;
    }
    case PROP_SIZE: {
        g_value_set_ulong(value, coreSelf->size());
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_STEP: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::stepAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_DEFAULT_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->defaultValue()));
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    case PROP_VALUE_AS_NUMBER: {
        g_value_set_double(value, coreSelf->valueAsNumber());
        break;
    }
    case PROP_WIDTH: {
        g_value_set_ulong(value, coreSelf->width());
        break;
    }
    case PROP_WILL_VALIDATE: {
        g_value_set_boolean(value, coreSelf->willValidate());
        break;
    }
    case PROP_VALIDITY: {
        RefPtr<WebCore::ValidityState> ptr = coreSelf->validity();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_VALIDATION_MESSAGE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->validationMessage()));
        break;
    }
    case PROP_LABELS: {
        RefPtr<WebCore::NodeList> ptr = coreSelf->labels();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_WEBKITDIRECTORY: {
#if ENABLE(DIRECTORY_UPLOAD)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::webkitdirectoryAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Directory Upload")
#endif /* ENABLE(DIRECTORY_UPLOAD) */
        break;
    }
    case PROP_USE_MAP: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::usemapAttr)));
        break;
    }
    case PROP_INCREMENTAL: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::incrementalAttr));
        break;
    }
    case PROP_WEBKIT_SPEECH: {
#if ENABLE(INPUT_SPEECH)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::webkitspeechAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
        break;
    }
    case PROP_WEBKIT_GRAMMAR: {
#if ENABLE(INPUT_SPEECH)
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::webkitgrammarAttr));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
        break;
    }
    case PROP_CAPTURE: {
#if ENABLE(MEDIA_CAPTURE)
        g_value_take_string(value, convertToUTF8String(coreSelf->capture()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Capture")
#endif /* ENABLE(MEDIA_CAPTURE) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_input_element_class_init(WebKitDOMHTMLInputElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_input_element_set_property;
    gobjectClass->get_property = webkit_dom_html_input_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ACCEPT,
                                    g_param_spec_string("accept", /* name */
                                                           "html_input_element_accept", /* short description */
                                                           "read-write  gchar* HTMLInputElement.accept", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALT,
                                    g_param_spec_string("alt", /* name */
                                                           "html_input_element_alt", /* short description */
                                                           "read-write  gchar* HTMLInputElement.alt", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOCOMPLETE,
                                    g_param_spec_string("autocomplete", /* name */
                                                           "html_input_element_autocomplete", /* short description */
                                                           "read-write  gchar* HTMLInputElement.autocomplete", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AUTOFOCUS,
                                    g_param_spec_boolean("autofocus", /* name */
                                                           "html_input_element_autofocus", /* short description */
                                                           "read-write  gboolean HTMLInputElement.autofocus", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_CHECKED,
                                    g_param_spec_boolean("default-checked", /* name */
                                                           "html_input_element_default-checked", /* short description */
                                                           "read-write  gboolean HTMLInputElement.default-checked", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHECKED,
                                    g_param_spec_boolean("checked", /* name */
                                                           "html_input_element_checked", /* short description */
                                                           "read-write  gboolean HTMLInputElement.checked", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DIR_NAME,
                                    g_param_spec_string("dir-name", /* name */
                                                           "html_input_element_dir-name", /* short description */
                                                           "read-write  gchar* HTMLInputElement.dir-name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_input_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLInputElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM,
                                    g_param_spec_object("form", /* name */
                                                           "html_input_element_form", /* short description */
                                                           "read-only  WebKitDOMHTMLFormElement* HTMLInputElement.form", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_FORM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FILES,
                                    g_param_spec_object("files", /* name */
                                                           "html_input_element_files", /* short description */
                                                           "read-write  WebKitDOMFileList* HTMLInputElement.files", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_FILE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_ACTION,
                                    g_param_spec_string("form-action", /* name */
                                                           "html_input_element_form-action", /* short description */
                                                           "read-write  gchar* HTMLInputElement.form-action", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_ENCTYPE,
                                    g_param_spec_string("form-enctype", /* name */
                                                           "html_input_element_form-enctype", /* short description */
                                                           "read-write  gchar* HTMLInputElement.form-enctype", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_METHOD,
                                    g_param_spec_string("form-method", /* name */
                                                           "html_input_element_form-method", /* short description */
                                                           "read-write  gchar* HTMLInputElement.form-method", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_NO_VALIDATE,
                                    g_param_spec_boolean("form-no-validate", /* name */
                                                           "html_input_element_form-no-validate", /* short description */
                                                           "read-write  gboolean HTMLInputElement.form-no-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FORM_TARGET,
                                    g_param_spec_string("form-target", /* name */
                                                           "html_input_element_form-target", /* short description */
                                                           "read-write  gchar* HTMLInputElement.form-target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_ulong("height", /* name */
                                                           "html_input_element_height", /* short description */
                                                           "read-write  gulong HTMLInputElement.height", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INDETERMINATE,
                                    g_param_spec_boolean("indeterminate", /* name */
                                                           "html_input_element_indeterminate", /* short description */
                                                           "read-write  gboolean HTMLInputElement.indeterminate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LIST,
                                    g_param_spec_object("list", /* name */
                                                           "html_input_element_list", /* short description */
                                                           "read-only  WebKitDOMHTMLElement* HTMLInputElement.list", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MAX,
                                    g_param_spec_string("max", /* name */
                                                           "html_input_element_max", /* short description */
                                                           "read-write  gchar* HTMLInputElement.max", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MAX_LENGTH,
                                    g_param_spec_long("max-length", /* name */
                                                           "html_input_element_max-length", /* short description */
                                                           "read-write  glong HTMLInputElement.max-length", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MIN,
                                    g_param_spec_string("min", /* name */
                                                           "html_input_element_min", /* short description */
                                                           "read-write  gchar* HTMLInputElement.min", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MULTIPLE,
                                    g_param_spec_boolean("multiple", /* name */
                                                           "html_input_element_multiple", /* short description */
                                                           "read-write  gboolean HTMLInputElement.multiple", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_input_element_name", /* short description */
                                                           "read-write  gchar* HTMLInputElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PATTERN,
                                    g_param_spec_string("pattern", /* name */
                                                           "html_input_element_pattern", /* short description */
                                                           "read-write  gchar* HTMLInputElement.pattern", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLACEHOLDER,
                                    g_param_spec_string("placeholder", /* name */
                                                           "html_input_element_placeholder", /* short description */
                                                           "read-write  gchar* HTMLInputElement.placeholder", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_READ_ONLY,
                                    g_param_spec_boolean("read-only", /* name */
                                                           "html_input_element_read-only", /* short description */
                                                           "read-write  gboolean HTMLInputElement.read-only", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REQUIRED,
                                    g_param_spec_boolean("required", /* name */
                                                           "html_input_element_required", /* short description */
                                                           "read-write  gboolean HTMLInputElement.required", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SIZE,
                                    g_param_spec_ulong("size", /* name */
                                                           "html_input_element_size", /* short description */
                                                           "read-write  gulong HTMLInputElement.size", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_input_element_src", /* short description */
                                                           "read-write  gchar* HTMLInputElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_STEP,
                                    g_param_spec_string("step", /* name */
                                                           "html_input_element_step", /* short description */
                                                           "read-write  gchar* HTMLInputElement.step", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_input_element_type", /* short description */
                                                           "read-write  gchar* HTMLInputElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DEFAULT_VALUE,
                                    g_param_spec_string("default-value", /* name */
                                                           "html_input_element_default-value", /* short description */
                                                           "read-write  gchar* HTMLInputElement.default-value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "html_input_element_value", /* short description */
                                                           "read-write  gchar* HTMLInputElement.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE_AS_NUMBER,
                                    g_param_spec_double("value-as-number", /* name */
                                                           "html_input_element_value-as-number", /* short description */
                                                           "read-write  gdouble HTMLInputElement.value-as-number", /* longer - could do with some extra doc stuff here */
                                                           -G_MAXDOUBLE, /* min */
G_MAXDOUBLE, /* max */
0.0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_ulong("width", /* name */
                                                           "html_input_element_width", /* short description */
                                                           "read-write  gulong HTMLInputElement.width", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WILL_VALIDATE,
                                    g_param_spec_boolean("will-validate", /* name */
                                                           "html_input_element_will-validate", /* short description */
                                                           "read-only  gboolean HTMLInputElement.will-validate", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDITY,
                                    g_param_spec_object("validity", /* name */
                                                           "html_input_element_validity", /* short description */
                                                           "read-only  WebKitDOMValidityState* HTMLInputElement.validity", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_VALIDITY_STATE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALIDATION_MESSAGE,
                                    g_param_spec_string("validation-message", /* name */
                                                           "html_input_element_validation-message", /* short description */
                                                           "read-only  gchar* HTMLInputElement.validation-message", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABELS,
                                    g_param_spec_object("labels", /* name */
                                                           "html_input_element_labels", /* short description */
                                                           "read-only  WebKitDOMNodeList* HTMLInputElement.labels", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_input_element_align", /* short description */
                                                           "read-write  gchar* HTMLInputElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKITDIRECTORY,
                                    g_param_spec_boolean("webkitdirectory", /* name */
                                                           "html_input_element_webkitdirectory", /* short description */
                                                           "read-write  gboolean HTMLInputElement.webkitdirectory", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_USE_MAP,
                                    g_param_spec_string("use-map", /* name */
                                                           "html_input_element_use-map", /* short description */
                                                           "read-write  gchar* HTMLInputElement.use-map", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_INCREMENTAL,
                                    g_param_spec_boolean("incremental", /* name */
                                                           "html_input_element_incremental", /* short description */
                                                           "read-write  gboolean HTMLInputElement.incremental", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_SPEECH,
                                    g_param_spec_boolean("webkit-speech", /* name */
                                                           "html_input_element_webkit-speech", /* short description */
                                                           "read-write  gboolean HTMLInputElement.webkit-speech", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WEBKIT_GRAMMAR,
                                    g_param_spec_boolean("webkit-grammar", /* name */
                                                           "html_input_element_webkit-grammar", /* short description */
                                                           "read-write  gboolean HTMLInputElement.webkit-grammar", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CAPTURE,
                                    g_param_spec_string("capture", /* name */
                                                           "html_input_element_capture", /* short description */
                                                           "read-write  gchar* HTMLInputElement.capture", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_input_element_init(WebKitDOMHTMLInputElement* request)
{
}

void
webkit_dom_html_input_element_step_up(WebKitDOMHTMLInputElement* self, glong n, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->stepUp(n, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_input_element_step_down(WebKitDOMHTMLInputElement* self, glong n, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->stepDown(n, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gboolean
webkit_dom_html_input_element_check_validity(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->checkValidity();
    return result;
}

void
webkit_dom_html_input_element_set_custom_validity(WebKitDOMHTMLInputElement* self, const gchar* error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedError = WTF::String::fromUTF8(error);
    item->setCustomValidity(convertedError);
}

void
webkit_dom_html_input_element_select(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->select();
}

void
webkit_dom_html_input_element_set_range_text(WebKitDOMHTMLInputElement* self, const gchar* replacement, gulong start, gulong end, const gchar* selectionMode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(replacement);
    g_return_if_fail(selectionMode);
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedReplacement = WTF::String::fromUTF8(replacement);
    WTF::String convertedSelectionMode = WTF::String::fromUTF8(selectionMode);
    WebCore::ExceptionCode ec = 0;
    item->setRangeText(convertedReplacement, start, end, convertedSelectionMode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_html_input_element_set_value_for_user(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValueForUser(convertedValue);
}

gchar*
webkit_dom_html_input_element_get_accept(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::acceptAttr));
    return result;
}

void
webkit_dom_html_input_element_set_accept(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::acceptAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_alt(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}

void
webkit_dom_html_input_element_set_alt(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::altAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_autocomplete(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::autocompleteAttr));
    return result;
}

void
webkit_dom_html_input_element_set_autocomplete(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::autocompleteAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_autofocus(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::autofocusAttr);
    return result;
}

void
webkit_dom_html_input_element_set_autofocus(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value);
}

gboolean
webkit_dom_html_input_element_get_default_checked(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::checkedAttr);
    return result;
}

void
webkit_dom_html_input_element_set_default_checked(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::checkedAttr, value);
}

gboolean
webkit_dom_html_input_element_get_checked(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->checked();
    return result;
}

void
webkit_dom_html_input_element_set_checked(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setChecked(value);
}

gchar*
webkit_dom_html_input_element_get_dir_name(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::dirnameAttr));
    return result;
}

void
webkit_dom_html_input_element_set_dir_name(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::dirnameAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_disabled(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_input_element_set_disabled(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

WebKitDOMHTMLFormElement*
webkit_dom_html_input_element_get_form(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLFormElement> gobjectResult = WTF::getPtr(item->form());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMFileList*
webkit_dom_html_input_element_get_files(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    RefPtr<WebCore::FileList> gobjectResult = WTF::getPtr(item->files());
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_html_input_element_set_files(WebKitDOMHTMLInputElement* self, WebKitDOMFileList* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(WEBKIT_DOM_IS_FILE_LIST(value));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::FileList* convertedValue = WebKit::core(value);
    item->setFiles(convertedValue);
}

gchar*
webkit_dom_html_input_element_get_form_action(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::formactionAttr));
    return result;
}

void
webkit_dom_html_input_element_set_form_action(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::formactionAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_form_enctype(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->formEnctype());
    return result;
}

void
webkit_dom_html_input_element_set_form_enctype(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setFormEnctype(convertedValue);
}

gchar*
webkit_dom_html_input_element_get_form_method(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->formMethod());
    return result;
}

void
webkit_dom_html_input_element_set_form_method(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setFormMethod(convertedValue);
}

gboolean
webkit_dom_html_input_element_get_form_no_validate(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::formnovalidateAttr);
    return result;
}

void
webkit_dom_html_input_element_set_form_no_validate(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, value);
}

gchar*
webkit_dom_html_input_element_get_form_target(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::formtargetAttr));
    return result;
}

void
webkit_dom_html_input_element_set_form_target(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::formtargetAttr, convertedValue);
}

gulong
webkit_dom_html_input_element_get_height(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gulong result = item->height();
    return result;
}

void
webkit_dom_html_input_element_set_height(WebKitDOMHTMLInputElement* self, gulong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setHeight(value);
}

gboolean
webkit_dom_html_input_element_get_indeterminate(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->indeterminate();
    return result;
}

void
webkit_dom_html_input_element_set_indeterminate(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setIndeterminate(value);
}

WebKitDOMHTMLElement*
webkit_dom_html_input_element_get_list(WebKitDOMHTMLInputElement* self)
{
#if ENABLE(DATALIST_ELEMENT)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    RefPtr<WebCore::HTMLElement> gobjectResult = WTF::getPtr(item->list());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Datalist Element")
    return 0;
#endif /* ENABLE(DATALIST_ELEMENT) */
}

gchar*
webkit_dom_html_input_element_get_max(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::maxAttr));
    return result;
}

void
webkit_dom_html_input_element_set_max(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::maxAttr, convertedValue);
}

glong
webkit_dom_html_input_element_get_max_length(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    glong result = item->maxLength();
    return result;
}

void
webkit_dom_html_input_element_set_max_length(WebKitDOMHTMLInputElement* self, glong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setMaxLength(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_input_element_get_min(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::minAttr));
    return result;
}

void
webkit_dom_html_input_element_set_min(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::minAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_multiple(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::multipleAttr);
    return result;
}

void
webkit_dom_html_input_element_set_multiple(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::multipleAttr, value);
}

gchar*
webkit_dom_html_input_element_get_name(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_input_element_set_name(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_pattern(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::patternAttr));
    return result;
}

void
webkit_dom_html_input_element_set_pattern(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::patternAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_placeholder(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::placeholderAttr));
    return result;
}

void
webkit_dom_html_input_element_set_placeholder(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::placeholderAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_read_only(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::readonlyAttr);
    return result;
}

void
webkit_dom_html_input_element_set_read_only(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, value);
}

gboolean
webkit_dom_html_input_element_get_required(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::requiredAttr);
    return result;
}

void
webkit_dom_html_input_element_set_required(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value);
}

gulong
webkit_dom_html_input_element_get_size(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gulong result = item->size();
    return result;
}

void
webkit_dom_html_input_element_set_size(WebKitDOMHTMLInputElement* self, gulong value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setSize(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_html_input_element_get_src(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_input_element_set_src(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_step(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::stepAttr));
    return result;
}

void
webkit_dom_html_input_element_set_step(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::stepAttr, convertedValue);
}

gchar*
webkit_dom_html_input_element_get_default_value(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->defaultValue());
    return result;
}

void
webkit_dom_html_input_element_set_default_value(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDefaultValue(convertedValue);
}

gchar*
webkit_dom_html_input_element_get_value(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_html_input_element_set_value(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setValue(convertedValue);
}

gdouble
webkit_dom_html_input_element_get_value_as_number(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gdouble result = item->valueAsNumber();
    return result;
}

void
webkit_dom_html_input_element_set_value_as_number(WebKitDOMHTMLInputElement* self, gdouble value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(!error || !*error);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->setValueAsNumber(value, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gulong
webkit_dom_html_input_element_get_width(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gulong result = item->width();
    return result;
}

void
webkit_dom_html_input_element_set_width(WebKitDOMHTMLInputElement* self, gulong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setWidth(value);
}

gboolean
webkit_dom_html_input_element_get_will_validate(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->willValidate();
    return result;
}

WebKitDOMValidityState*
webkit_dom_html_input_element_get_validity(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    RefPtr<WebCore::ValidityState> gobjectResult = WTF::getPtr(item->validity());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_input_element_get_validation_message(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->validationMessage());
    return result;
}

WebKitDOMNodeList*
webkit_dom_html_input_element_get_labels(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    RefPtr<WebCore::NodeList> gobjectResult = WTF::getPtr(item->labels());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_input_element_get_align(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_input_element_set_align(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_webkitdirectory(WebKitDOMHTMLInputElement* self)
{
#if ENABLE(DIRECTORY_UPLOAD)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::webkitdirectoryAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Directory Upload")
    return static_cast<gboolean>(0);
#endif /* ENABLE(DIRECTORY_UPLOAD) */
}

void
webkit_dom_html_input_element_set_webkitdirectory(WebKitDOMHTMLInputElement* self, gboolean value)
{
#if ENABLE(DIRECTORY_UPLOAD)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::webkitdirectoryAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Directory Upload")
#endif /* ENABLE(DIRECTORY_UPLOAD) */
}

gchar*
webkit_dom_html_input_element_get_use_map(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}

void
webkit_dom_html_input_element_set_use_map(WebKitDOMHTMLInputElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::usemapAttr, convertedValue);
}

gboolean
webkit_dom_html_input_element_get_incremental(WebKitDOMHTMLInputElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::incrementalAttr);
    return result;
}

void
webkit_dom_html_input_element_set_incremental(WebKitDOMHTMLInputElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::incrementalAttr, value);
}

gboolean
webkit_dom_html_input_element_get_webkit_speech(WebKitDOMHTMLInputElement* self)
{
#if ENABLE(INPUT_SPEECH)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::webkitspeechAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
    return static_cast<gboolean>(0);
#endif /* ENABLE(INPUT_SPEECH) */
}

void
webkit_dom_html_input_element_set_webkit_speech(WebKitDOMHTMLInputElement* self, gboolean value)
{
#if ENABLE(INPUT_SPEECH)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::webkitspeechAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
}

gboolean
webkit_dom_html_input_element_get_webkit_grammar(WebKitDOMHTMLInputElement* self)
{
#if ENABLE(INPUT_SPEECH)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), FALSE);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::webkitgrammarAttr);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
    return static_cast<gboolean>(0);
#endif /* ENABLE(INPUT_SPEECH) */
}

void
webkit_dom_html_input_element_set_webkit_grammar(WebKitDOMHTMLInputElement* self, gboolean value)
{
#if ENABLE(INPUT_SPEECH)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    WebCore::HTMLInputElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::webkitgrammarAttr, value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Input Speech")
#endif /* ENABLE(INPUT_SPEECH) */
}

gchar*
webkit_dom_html_input_element_get_capture(WebKitDOMHTMLInputElement* self)
{
#if ENABLE(MEDIA_CAPTURE)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self), 0);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->capture());
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Capture")
    return 0;
#endif /* ENABLE(MEDIA_CAPTURE) */
}

void
webkit_dom_html_input_element_set_capture(WebKitDOMHTMLInputElement* self, const gchar* value)
{
#if ENABLE(MEDIA_CAPTURE)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_INPUT_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLInputElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setCapture(convertedValue);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Media Capture")
#endif /* ENABLE(MEDIA_CAPTURE) */
}

