/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMProcessingInstruction.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMProcessingInstructionPrivate.h"
#include "WebKitDOMStyleSheetPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMProcessingInstruction* kit(WebCore::ProcessingInstruction* obj)
{
    return WEBKIT_DOM_PROCESSING_INSTRUCTION(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::ProcessingInstruction* core(WebKitDOMProcessingInstruction* request)
{
    return request ? static_cast<WebCore::ProcessingInstruction*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMProcessingInstruction* wrapProcessingInstruction(WebCore::ProcessingInstruction* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PROCESSING_INSTRUCTION(g_object_new(WEBKIT_TYPE_DOM_PROCESSING_INSTRUCTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMProcessingInstruction, webkit_dom_processing_instruction, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_TARGET,
    PROP_DATA,
    PROP_SHEET,
};

static void webkit_dom_processing_instruction_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMProcessingInstruction* self = WEBKIT_DOM_PROCESSING_INSTRUCTION(object);
    WebCore::ProcessingInstruction* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DATA: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setData(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_processing_instruction_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMProcessingInstruction* self = WEBKIT_DOM_PROCESSING_INSTRUCTION(object);
    WebCore::ProcessingInstruction* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->target()));
        break;
    }
    case PROP_DATA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->data()));
        break;
    }
    case PROP_SHEET: {
        RefPtr<WebCore::StyleSheet> ptr = coreSelf->sheet();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_processing_instruction_class_init(WebKitDOMProcessingInstructionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_processing_instruction_set_property;
    gobjectClass->get_property = webkit_dom_processing_instruction_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_string("target", /* name */
                                                           "processing_instruction_target", /* short description */
                                                           "read-only  gchar* ProcessingInstruction.target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DATA,
                                    g_param_spec_string("data", /* name */
                                                           "processing_instruction_data", /* short description */
                                                           "read-write  gchar* ProcessingInstruction.data", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHEET,
                                    g_param_spec_object("sheet", /* name */
                                                           "processing_instruction_sheet", /* short description */
                                                           "read-only  WebKitDOMStyleSheet* ProcessingInstruction.sheet", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_SHEET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_processing_instruction_init(WebKitDOMProcessingInstruction* request)
{
}

gchar*
webkit_dom_processing_instruction_get_target(WebKitDOMProcessingInstruction* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PROCESSING_INSTRUCTION(self), 0);
    WebCore::ProcessingInstruction* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->target());
    return result;
}

gchar*
webkit_dom_processing_instruction_get_data(WebKitDOMProcessingInstruction* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PROCESSING_INSTRUCTION(self), 0);
    WebCore::ProcessingInstruction* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->data());
    return result;
}

void
webkit_dom_processing_instruction_set_data(WebKitDOMProcessingInstruction* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_PROCESSING_INSTRUCTION(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::ProcessingInstruction* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setData(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMStyleSheet*
webkit_dom_processing_instruction_get_sheet(WebKitDOMProcessingInstruction* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PROCESSING_INSTRUCTION(self), 0);
    WebCore::ProcessingInstruction* item = WebKit::core(self);
    RefPtr<WebCore::StyleSheet> gobjectResult = WTF::getPtr(item->sheet());
    return WebKit::kit(gobjectResult.get());
}

