/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMRange.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDocumentFragmentPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMRangePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_RANGE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_RANGE, WebKitDOMRangePrivate)

typedef struct _WebKitDOMRangePrivate {
    RefPtr<WebCore::Range> coreObject;
} WebKitDOMRangePrivate;

namespace WebKit {

WebKitDOMRange* kit(WebCore::Range* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_RANGE(ret);

    return wrapRange(obj);
}

WebCore::Range* core(WebKitDOMRange* request)
{
    return request ? static_cast<WebCore::Range*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMRange* wrapRange(WebCore::Range* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_RANGE(g_object_new(WEBKIT_TYPE_DOM_RANGE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMRange, webkit_dom_range, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_START_CONTAINER,
    PROP_START_OFFSET,
    PROP_END_CONTAINER,
    PROP_END_OFFSET,
    PROP_COLLAPSED,
    PROP_COMMON_ANCESTOR_CONTAINER,
    PROP_TEXT,
};

static void webkit_dom_range_finalize(GObject* object)
{
    WebKitDOMRangePrivate* priv = WEBKIT_DOM_RANGE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMRangePrivate();
    G_OBJECT_CLASS(webkit_dom_range_parent_class)->finalize(object);
}

static void webkit_dom_range_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMRange* self = WEBKIT_DOM_RANGE(object);
    WebCore::Range* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_START_CONTAINER: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::Node> ptr = coreSelf->startContainer(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_START_OFFSET: {
        WebCore::ExceptionCode ec = 0;
        g_value_set_long(value, coreSelf->startOffset(ec));
        break;
    }
    case PROP_END_CONTAINER: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::Node> ptr = coreSelf->endContainer(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_END_OFFSET: {
        WebCore::ExceptionCode ec = 0;
        g_value_set_long(value, coreSelf->endOffset(ec));
        break;
    }
    case PROP_COLLAPSED: {
        WebCore::ExceptionCode ec = 0;
        g_value_set_boolean(value, coreSelf->collapsed(ec));
        break;
    }
    case PROP_COMMON_ANCESTOR_CONTAINER: {
        WebCore::ExceptionCode ec = 0;
        RefPtr<WebCore::Node> ptr = coreSelf->commonAncestorContainer(ec);
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->text()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_range_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_range_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMRangePrivate* priv = WEBKIT_DOM_RANGE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Range*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_range_class_init(WebKitDOMRangeClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMRangePrivate));
    gobjectClass->constructor = webkit_dom_range_constructor;
    gobjectClass->finalize = webkit_dom_range_finalize;
    gobjectClass->get_property = webkit_dom_range_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_START_CONTAINER,
                                    g_param_spec_object("start-container", /* name */
                                                           "range_start-container", /* short description */
                                                           "read-only  WebKitDOMNode* Range.start-container", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_START_OFFSET,
                                    g_param_spec_long("start-offset", /* name */
                                                           "range_start-offset", /* short description */
                                                           "read-only  glong Range.start-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_END_CONTAINER,
                                    g_param_spec_object("end-container", /* name */
                                                           "range_end-container", /* short description */
                                                           "read-only  WebKitDOMNode* Range.end-container", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_END_OFFSET,
                                    g_param_spec_long("end-offset", /* name */
                                                           "range_end-offset", /* short description */
                                                           "read-only  glong Range.end-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COLLAPSED,
                                    g_param_spec_boolean("collapsed", /* name */
                                                           "range_collapsed", /* short description */
                                                           "read-only  gboolean Range.collapsed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COMMON_ANCESTOR_CONTAINER,
                                    g_param_spec_object("common-ancestor-container", /* name */
                                                           "range_common-ancestor-container", /* short description */
                                                           "read-only  WebKitDOMNode* Range.common-ancestor-container", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TEXT,
                                    g_param_spec_string("text", /* name */
                                                           "range_text", /* short description */
                                                           "read-only  gchar* Range.text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_range_init(WebKitDOMRange* request)
{
    WebKitDOMRangePrivate* priv = WEBKIT_DOM_RANGE_GET_PRIVATE(request);
    new (priv) WebKitDOMRangePrivate();
}

void
webkit_dom_range_set_start(WebKitDOMRange* self, WebKitDOMNode* refNode, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setStart(convertedRefNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_set_end(WebKitDOMRange* self, WebKitDOMNode* refNode, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setEnd(convertedRefNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_set_start_before(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setStartBefore(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_set_start_after(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setStartAfter(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_set_end_before(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setEndBefore(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_set_end_after(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->setEndAfter(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_collapse(WebKitDOMRange* self, gboolean toStart, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->collapse(toStart, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_select_node(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->selectNode(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_select_node_contents(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(refNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    item->selectNodeContents(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gshort
webkit_dom_range_compare_boundary_points(WebKitDOMRange* self, gushort how, WebKitDOMRange* sourceRange, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(how, 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(sourceRange), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Range::CompareHow convertedHow = static_cast<WebCore::Range::CompareHow>(how);
    WebCore::Range* convertedSourceRange = WebKit::core(sourceRange);
    WebCore::ExceptionCode ec = 0;
    gshort result = item->compareBoundaryPoints(convertedHow, convertedSourceRange, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void
webkit_dom_range_delete_contents(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->deleteContents(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMDocumentFragment*
webkit_dom_range_extract_contents(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::DocumentFragment> gobjectResult = WTF::getPtr(item->extractContents(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDocumentFragment*
webkit_dom_range_clone_contents(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::DocumentFragment> gobjectResult = WTF::getPtr(item->cloneContents(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_range_insert_node(WebKitDOMRange* self, WebKitDOMNode* newNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(newNode));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedNewNode = WebKit::core(newNode);
    WebCore::ExceptionCode ec = 0;
    item->insertNode(convertedNewNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_range_surround_contents(WebKitDOMRange* self, WebKitDOMNode* newParent, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(newParent));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedNewParent = WebKit::core(newParent);
    WebCore::ExceptionCode ec = 0;
    item->surroundContents(convertedNewParent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMRange*
webkit_dom_range_clone_range(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Range> gobjectResult = WTF::getPtr(item->cloneRange(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_range_to_string(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->toString(ec));
    return result;
}

void
webkit_dom_range_detach(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->detach(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMDocumentFragment*
webkit_dom_range_create_contextual_fragment(WebKitDOMRange* self, const gchar* html, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(html, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WTF::String convertedHtml = WTF::String::fromUTF8(html);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::DocumentFragment> gobjectResult = WTF::getPtr(item->createContextualFragment(convertedHtml, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_range_intersects_node(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(refNode), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->intersectsNode(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gshort
webkit_dom_range_compare_node(WebKitDOMRange* self, WebKitDOMNode* refNode, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(refNode), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    gshort result = item->compareNode(convertedRefNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gshort
webkit_dom_range_compare_point(WebKitDOMRange* self, WebKitDOMNode* refNode, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(refNode), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    gshort result = item->comparePoint(convertedRefNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gboolean
webkit_dom_range_is_point_in_range(WebKitDOMRange* self, WebKitDOMNode* refNode, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(refNode), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::Range* item = WebKit::core(self);
    WebCore::Node* convertedRefNode = WebKit::core(refNode);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->isPointInRange(convertedRefNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

void
webkit_dom_range_expand(WebKitDOMRange* self, const gchar* unit, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(self));
    g_return_if_fail(unit);
    g_return_if_fail(!error || !*error);
    WebCore::Range* item = WebKit::core(self);
    WTF::String convertedUnit = WTF::String::fromUTF8(unit);
    WebCore::ExceptionCode ec = 0;
    item->expand(convertedUnit, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMNode*
webkit_dom_range_get_start_container(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->startContainer(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_range_get_start_offset(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    glong result = item->startOffset(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

WebKitDOMNode*
webkit_dom_range_get_end_container(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->endContainer(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_range_get_end_offset(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    glong result = item->endOffset(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gboolean
webkit_dom_range_get_collapsed(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->collapsed(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

WebKitDOMNode*
webkit_dom_range_get_common_ancestor_container(WebKitDOMRange* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Range* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->commonAncestorContainer(ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_range_get_text(WebKitDOMRange* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_RANGE(self), 0);
    WebCore::Range* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->text());
    return result;
}

