/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameElement.h"

#include "DOMWindow.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "HTMLFrameElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSDocument.h"
#include "JSSVGDocument.h"
#include "KURL.h"
#include "SVGDocument.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLFrameElementTableValues[] =
{
    { "frameBorder", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementFrameBorder), (intptr_t)setJSHTMLFrameElementFrameBorder, NoIntrinsic },
    { "longDesc", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementLongDesc), (intptr_t)setJSHTMLFrameElementLongDesc, NoIntrinsic },
    { "marginHeight", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementMarginHeight), (intptr_t)setJSHTMLFrameElementMarginHeight, NoIntrinsic },
    { "marginWidth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementMarginWidth), (intptr_t)setJSHTMLFrameElementMarginWidth, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementName), (intptr_t)setJSHTMLFrameElementName, NoIntrinsic },
    { "noResize", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementNoResize), (intptr_t)setJSHTMLFrameElementNoResize, NoIntrinsic },
    { "scrolling", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementScrolling), (intptr_t)setJSHTMLFrameElementScrolling, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementSrc), (intptr_t)setJSHTMLFrameElementSrc, NoIntrinsic },
    { "contentDocument", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementContentDocument), (intptr_t)0, NoIntrinsic },
    { "contentWindow", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementContentWindow), (intptr_t)0, NoIntrinsic },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementLocation), (intptr_t)setJSHTMLFrameElementLocation, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementHeight), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFrameElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFrameElementTable = { 36, 31, JSHTMLFrameElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLFrameElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFrameElementConstructorTable = { 1, 0, JSHTMLFrameElementConstructorTableValues, 0 };
const ClassInfo JSHTMLFrameElementConstructor::s_info = { "HTMLFrameElementConstructor", &Base::s_info, &JSHTMLFrameElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLFrameElementConstructor) };

JSHTMLFrameElementConstructor::JSHTMLFrameElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLFrameElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLFrameElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLFrameElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameElementConstructor, JSDOMWrapper>(exec, &JSHTMLFrameElementConstructorTable, jsCast<JSHTMLFrameElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLFrameElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFrameElementConstructor, JSDOMWrapper>(exec, &JSHTMLFrameElementConstructorTable, jsCast<JSHTMLFrameElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFrameElementPrototypeTableValues[] =
{
    { "getSVGDocument", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLFrameElementPrototypeFunctionGetSVGDocument), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFrameElementPrototypeTable = { 2, 1, JSHTMLFrameElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLFrameElementPrototype::s_info = { "HTMLFrameElementPrototype", &Base::s_info, &JSHTMLFrameElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLFrameElementPrototype) };

JSObject* JSHTMLFrameElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFrameElement>(exec, globalObject);
}

bool JSHTMLFrameElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFrameElementPrototype* thisObject = jsCast<JSHTMLFrameElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLFrameElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLFrameElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFrameElementPrototype* thisObject = jsCast<JSHTMLFrameElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLFrameElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLFrameElement::s_info = { "HTMLFrameElement", &Base::s_info, &JSHTMLFrameElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLFrameElement) };

JSHTMLFrameElement::JSHTMLFrameElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFrameElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLFrameElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLFrameElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLFrameElementPrototype::create(exec->globalData(), globalObject, JSHTMLFrameElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLFrameElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFrameElement* thisObject = jsCast<JSHTMLFrameElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLFrameElement, Base>(exec, &JSHTMLFrameElementTable, thisObject, propertyName, slot);
}

bool JSHTMLFrameElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFrameElement* thisObject = jsCast<JSHTMLFrameElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLFrameElement, Base>(exec, &JSHTMLFrameElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLFrameElementFrameBorder(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::frameborderAttr));
    return result;
}


JSValue jsHTMLFrameElementLongDesc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::longdescAttr));
    return result;
}


JSValue jsHTMLFrameElementMarginHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::marginheightAttr));
    return result;
}


JSValue jsHTMLFrameElementMarginWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::marginwidthAttr));
    return result;
}


JSValue jsHTMLFrameElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLFrameElementNoResize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::noresizeAttr));
    return result;
}


JSValue jsHTMLFrameElementScrolling(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::scrollingAttr));
    return result;
}


JSValue jsHTMLFrameElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLFrameElementContentDocument(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    return shouldAllowAccessToNode(exec, impl->contentDocument()) ? toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->contentDocument())) : jsNull();
}


JSValue jsHTMLFrameElementContentWindow(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->contentWindow()));
    return result;
}


JSValue jsHTMLFrameElementLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->location());
    return result;
}


JSValue jsHTMLFrameElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsHTMLFrameElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsHTMLFrameElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFrameElement* domObject = jsCast<JSHTMLFrameElement*>(asObject(slotBase));
    return JSHTMLFrameElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLFrameElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLFrameElement* thisObject = jsCast<JSHTMLFrameElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLFrameElement, Base>(exec, propertyName, value, &JSHTMLFrameElementTable, thisObject, slot);
}

void setJSHTMLFrameElementFrameBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::frameborderAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementLongDesc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::longdescAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementMarginHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::marginheightAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementMarginWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::marginwidthAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementNoResize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::noresizeAttr, value.toBoolean(exec));
}


void setJSHTMLFrameElementScrolling(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::scrollingAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLFrameElementLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLFrameElement*>(thisObject)->setLocation(exec, value);
}


JSValue JSHTMLFrameElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLFrameElementPrototypeFunctionGetSVGDocument(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLFrameElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLFrameElement* castedThis = jsCast<JSHTMLFrameElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLFrameElement::s_info);
    HTMLFrameElement* impl = static_cast<HTMLFrameElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    if (!shouldAllowAccessToNode(exec, impl->getSVGDocument(ec)))
        return JSValue::encode(jsNull());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getSVGDocument(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
