/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CSS_SHADERS)

#include "JSWebKitCSSFilterRule.h"

#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "StylePropertySet.h"
#include "WebKitCSSFilterRule.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitCSSFilterRuleTableValues[] =
{
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSFilterRuleStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSFilterRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSFilterRuleTable = { 4, 3, JSWebKitCSSFilterRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitCSSFilterRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSFilterRuleConstructorTable = { 1, 0, JSWebKitCSSFilterRuleConstructorTableValues, 0 };
const ClassInfo JSWebKitCSSFilterRuleConstructor::s_info = { "WebKitCSSFilterRuleConstructor", &Base::s_info, &JSWebKitCSSFilterRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSFilterRuleConstructor) };

JSWebKitCSSFilterRuleConstructor::JSWebKitCSSFilterRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitCSSFilterRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitCSSFilterRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitCSSFilterRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSFilterRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSFilterRuleConstructorTable, jsCast<JSWebKitCSSFilterRuleConstructor*>(cell), propertyName, slot);
}

bool JSWebKitCSSFilterRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSFilterRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSFilterRuleConstructorTable, jsCast<JSWebKitCSSFilterRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSFilterRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSFilterRulePrototypeTable = { 1, 0, JSWebKitCSSFilterRulePrototypeTableValues, 0 };
const ClassInfo JSWebKitCSSFilterRulePrototype::s_info = { "WebKitCSSFilterRulePrototype", &Base::s_info, &JSWebKitCSSFilterRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSFilterRulePrototype) };

JSObject* JSWebKitCSSFilterRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSFilterRule>(exec, globalObject);
}

const ClassInfo JSWebKitCSSFilterRule::s_info = { "WebKitCSSFilterRule", &Base::s_info, &JSWebKitCSSFilterRuleTable, 0 , CREATE_METHOD_TABLE(JSWebKitCSSFilterRule) };

JSWebKitCSSFilterRule::JSWebKitCSSFilterRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitCSSFilterRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSWebKitCSSFilterRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitCSSFilterRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitCSSFilterRulePrototype::create(exec->globalData(), globalObject, JSWebKitCSSFilterRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSWebKitCSSFilterRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitCSSFilterRule* thisObject = jsCast<JSWebKitCSSFilterRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitCSSFilterRule, Base>(exec, &JSWebKitCSSFilterRuleTable, thisObject, propertyName, slot);
}

bool JSWebKitCSSFilterRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitCSSFilterRule* thisObject = jsCast<JSWebKitCSSFilterRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitCSSFilterRule, Base>(exec, &JSWebKitCSSFilterRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitCSSFilterRuleStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSFilterRule* castedThis = jsCast<JSWebKitCSSFilterRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSFilterRule* impl = static_cast<WebKitCSSFilterRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsWebKitCSSFilterRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSFilterRule* domObject = jsCast<JSWebKitCSSFilterRule*>(asObject(slotBase));
    return JSWebKitCSSFilterRule::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitCSSFilterRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSFilterRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(CSS_SHADERS)
