/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMConsole.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMConsolePrivate.h"
#include "WebKitDOMMemoryInfoPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_CONSOLE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_CONSOLE, WebKitDOMConsolePrivate)

typedef struct _WebKitDOMConsolePrivate {
    RefPtr<WebCore::Console> coreObject;
} WebKitDOMConsolePrivate;

namespace WebKit {

WebKitDOMConsole* kit(WebCore::Console* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_CONSOLE(ret);

    return wrapConsole(obj);
}

WebCore::Console* core(WebKitDOMConsole* request)
{
    return request ? static_cast<WebCore::Console*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMConsole* wrapConsole(WebCore::Console* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_CONSOLE(g_object_new(WEBKIT_TYPE_DOM_CONSOLE, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMConsole, webkit_dom_console, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_MEMORY,
};

static void webkit_dom_console_finalize(GObject* object)
{
    WebKitDOMConsolePrivate* priv = WEBKIT_DOM_CONSOLE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMConsolePrivate();
    G_OBJECT_CLASS(webkit_dom_console_parent_class)->finalize(object);
}

static void webkit_dom_console_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMConsole* self = WEBKIT_DOM_CONSOLE(object);
    WebCore::Console* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_MEMORY: {
        RefPtr<WebCore::MemoryInfo> ptr = coreSelf->memory();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_console_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_console_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMConsolePrivate* priv = WEBKIT_DOM_CONSOLE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Console*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_console_class_init(WebKitDOMConsoleClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMConsolePrivate));
    gobjectClass->constructor = webkit_dom_console_constructor;
    gobjectClass->finalize = webkit_dom_console_finalize;
    gobjectClass->get_property = webkit_dom_console_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_MEMORY,
                                    g_param_spec_object("memory", /* name */
                                                           "console_memory", /* short description */
                                                           "read-only  WebKitDOMMemoryInfo* Console.memory", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_MEMORY_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_console_init(WebKitDOMConsole* request)
{
    WebKitDOMConsolePrivate* priv = WEBKIT_DOM_CONSOLE_GET_PRIVATE(request);
    new (priv) WebKitDOMConsolePrivate();
}

void
webkit_dom_console_time(WebKitDOMConsole* self, const gchar* title)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CONSOLE(self));
    g_return_if_fail(title);
    WebCore::Console* item = WebKit::core(self);
    WTF::String convertedTitle = WTF::String::fromUTF8(title);
    item->time(convertedTitle);
}

void
webkit_dom_console_group_end(WebKitDOMConsole* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CONSOLE(self));
    WebCore::Console* item = WebKit::core(self);
    item->groupEnd();
}

WebKitDOMMemoryInfo*
webkit_dom_console_get_memory(WebKitDOMConsole* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CONSOLE(self), 0);
    WebCore::Console* item = WebKit::core(self);
    RefPtr<WebCore::MemoryInfo> gobjectResult = WTF::getPtr(item->memory());
    return WebKit::kit(gobjectResult.get());
}

