/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLFrameElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMWindowPrivate.h"
#include "WebKitDOMDocumentPrivate.h"
#include "WebKitDOMHTMLFrameElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLFrameElement* kit(WebCore::HTMLFrameElement* obj)
{
    return WEBKIT_DOM_HTML_FRAME_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLFrameElement* core(WebKitDOMHTMLFrameElement* request)
{
    return request ? static_cast<WebCore::HTMLFrameElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLFrameElement* wrapHTMLFrameElement(WebCore::HTMLFrameElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_FRAME_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_FRAME_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLFrameElement, webkit_dom_html_frame_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_FRAME_BORDER,
    PROP_LONG_DESC,
    PROP_MARGIN_HEIGHT,
    PROP_MARGIN_WIDTH,
    PROP_NAME,
    PROP_NO_RESIZE,
    PROP_SCROLLING,
    PROP_SRC,
    PROP_CONTENT_DOCUMENT,
    PROP_CONTENT_WINDOW,
    PROP_WIDTH,
    PROP_HEIGHT,
};

static void webkit_dom_html_frame_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFrameElement* self = WEBKIT_DOM_HTML_FRAME_ELEMENT(object);
    WebCore::HTMLFrameElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_FRAME_BORDER: {
        coreSelf->setAttribute(WebCore::HTMLNames::frameborderAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_LONG_DESC: {
        coreSelf->setAttribute(WebCore::HTMLNames::longdescAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MARGIN_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::marginheightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MARGIN_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::marginwidthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NO_RESIZE: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::noresizeAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_SCROLLING: {
        coreSelf->setAttribute(WebCore::HTMLNames::scrollingAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SRC: {
        coreSelf->setAttribute(WebCore::HTMLNames::srcAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_frame_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFrameElement* self = WEBKIT_DOM_HTML_FRAME_ELEMENT(object);
    WebCore::HTMLFrameElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_FRAME_BORDER: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::frameborderAttr)));
        break;
    }
    case PROP_LONG_DESC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::longdescAttr)));
        break;
    }
    case PROP_MARGIN_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::marginheightAttr)));
        break;
    }
    case PROP_MARGIN_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::marginwidthAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_NO_RESIZE: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::noresizeAttr));
        break;
    }
    case PROP_SCROLLING: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::scrollingAttr)));
        break;
    }
    case PROP_SRC: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::srcAttr)));
        break;
    }
    case PROP_CONTENT_DOCUMENT: {
        RefPtr<WebCore::Document> ptr = coreSelf->contentDocument();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_CONTENT_WINDOW: {
        RefPtr<WebCore::DOMWindow> ptr = coreSelf->contentWindow();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->width());
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_long(value, coreSelf->height());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_frame_element_class_init(WebKitDOMHTMLFrameElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_frame_element_set_property;
    gobjectClass->get_property = webkit_dom_html_frame_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_FRAME_BORDER,
                                    g_param_spec_string("frame-border", /* name */
                                                           "html_frame_element_frame-border", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.frame-border", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LONG_DESC,
                                    g_param_spec_string("long-desc", /* name */
                                                           "html_frame_element_long-desc", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.long-desc", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MARGIN_HEIGHT,
                                    g_param_spec_string("margin-height", /* name */
                                                           "html_frame_element_margin-height", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.margin-height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MARGIN_WIDTH,
                                    g_param_spec_string("margin-width", /* name */
                                                           "html_frame_element_margin-width", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.margin-width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_frame_element_name", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NO_RESIZE,
                                    g_param_spec_boolean("no-resize", /* name */
                                                           "html_frame_element_no-resize", /* short description */
                                                           "read-write  gboolean HTMLFrameElement.no-resize", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCROLLING,
                                    g_param_spec_string("scrolling", /* name */
                                                           "html_frame_element_scrolling", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.scrolling", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SRC,
                                    g_param_spec_string("src", /* name */
                                                           "html_frame_element_src", /* short description */
                                                           "read-write  gchar* HTMLFrameElement.src", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_DOCUMENT,
                                    g_param_spec_object("content-document", /* name */
                                                           "html_frame_element_content-document", /* short description */
                                                           "read-only  WebKitDOMDocument* HTMLFrameElement.content-document", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOCUMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT_WINDOW,
                                    g_param_spec_object("content-window", /* name */
                                                           "html_frame_element_content-window", /* short description */
                                                           "read-only  WebKitDOMDOMWindow* HTMLFrameElement.content-window", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_WINDOW, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_frame_element_width", /* short description */
                                                           "read-only  glong HTMLFrameElement.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_long("height", /* name */
                                                           "html_frame_element_height", /* short description */
                                                           "read-only  glong HTMLFrameElement.height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_frame_element_init(WebKitDOMHTMLFrameElement* request)
{
}

gchar*
webkit_dom_html_frame_element_get_frame_border(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::frameborderAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_frame_border(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::frameborderAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_element_get_long_desc(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::longdescAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_long_desc(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::longdescAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_element_get_margin_height(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::marginheightAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_margin_height(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::marginheightAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_element_get_margin_width(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::marginwidthAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_margin_width(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::marginwidthAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_element_get_name(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_frame_element_set_name(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gboolean
webkit_dom_html_frame_element_get_no_resize(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), FALSE);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::noresizeAttr);
    return result;
}

void
webkit_dom_html_frame_element_set_no_resize(WebKitDOMHTMLFrameElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::noresizeAttr, value);
}

gchar*
webkit_dom_html_frame_element_get_scrolling(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::scrollingAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_scrolling(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::scrollingAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_element_get_src(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

void
webkit_dom_html_frame_element_set_src(WebKitDOMHTMLFrameElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::srcAttr, convertedValue);
}

WebKitDOMDocument*
webkit_dom_html_frame_element_get_content_document(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    RefPtr<WebCore::Document> gobjectResult = WTF::getPtr(item->contentDocument());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMDOMWindow*
webkit_dom_html_frame_element_get_content_window(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    RefPtr<WebCore::DOMWindow> gobjectResult = WTF::getPtr(item->contentWindow());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_frame_element_get_width(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    glong result = item->width();
    return result;
}

glong
webkit_dom_html_frame_element_get_height(WebKitDOMHTMLFrameElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_ELEMENT(self), 0);
    WebCore::HTMLFrameElement* item = WebKit::core(self);
    glong result = item->height();
    return result;
}

