/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMediaQueryList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMMediaQueryListPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_MEDIA_QUERY_LIST_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_MEDIA_QUERY_LIST, WebKitDOMMediaQueryListPrivate)

typedef struct _WebKitDOMMediaQueryListPrivate {
    RefPtr<WebCore::MediaQueryList> coreObject;
} WebKitDOMMediaQueryListPrivate;

namespace WebKit {

WebKitDOMMediaQueryList* kit(WebCore::MediaQueryList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_MEDIA_QUERY_LIST(ret);

    return wrapMediaQueryList(obj);
}

WebCore::MediaQueryList* core(WebKitDOMMediaQueryList* request)
{
    return request ? static_cast<WebCore::MediaQueryList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMediaQueryList* wrapMediaQueryList(WebCore::MediaQueryList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MEDIA_QUERY_LIST(g_object_new(WEBKIT_TYPE_DOM_MEDIA_QUERY_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMMediaQueryList, webkit_dom_media_query_list, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_MEDIA,
    PROP_MATCHES,
};

static void webkit_dom_media_query_list_finalize(GObject* object)
{
    WebKitDOMMediaQueryListPrivate* priv = WEBKIT_DOM_MEDIA_QUERY_LIST_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMMediaQueryListPrivate();
    G_OBJECT_CLASS(webkit_dom_media_query_list_parent_class)->finalize(object);
}

static void webkit_dom_media_query_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMMediaQueryList* self = WEBKIT_DOM_MEDIA_QUERY_LIST(object);
    WebCore::MediaQueryList* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_MEDIA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->media()));
        break;
    }
    case PROP_MATCHES: {
        g_value_set_boolean(value, coreSelf->matches());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_media_query_list_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_media_query_list_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMMediaQueryListPrivate* priv = WEBKIT_DOM_MEDIA_QUERY_LIST_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::MediaQueryList*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_media_query_list_class_init(WebKitDOMMediaQueryListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMMediaQueryListPrivate));
    gobjectClass->constructor = webkit_dom_media_query_list_constructor;
    gobjectClass->finalize = webkit_dom_media_query_list_finalize;
    gobjectClass->get_property = webkit_dom_media_query_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_MEDIA,
                                    g_param_spec_string("media", /* name */
                                                           "media_query_list_media", /* short description */
                                                           "read-only  gchar* MediaQueryList.media", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MATCHES,
                                    g_param_spec_boolean("matches", /* name */
                                                           "media_query_list_matches", /* short description */
                                                           "read-only  gboolean MediaQueryList.matches", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_media_query_list_init(WebKitDOMMediaQueryList* request)
{
    WebKitDOMMediaQueryListPrivate* priv = WEBKIT_DOM_MEDIA_QUERY_LIST_GET_PRIVATE(request);
    new (priv) WebKitDOMMediaQueryListPrivate();
}

gchar*
webkit_dom_media_query_list_get_media(WebKitDOMMediaQueryList* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEDIA_QUERY_LIST(self), 0);
    WebCore::MediaQueryList* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->media());
    return result;
}

gboolean
webkit_dom_media_query_list_get_matches(WebKitDOMMediaQueryList* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEDIA_QUERY_LIST(self), FALSE);
    WebCore::MediaQueryList* item = WebKit::core(self);
    gboolean result = item->matches();
    return result;
}

