/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of ZBar.xs. Do not edit this file, edit ZBar.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "ZBar.xs"
//------------------------------------------------------------------------
//  Copyright 2008-2010 (c) Jeff Brown <spadix@users.sourceforge.net>
//
//  This file is part of the ZBar Bar Code Reader.
//
//  The ZBar Bar Code Reader is free software; you can redistribute it
//  and/or modify it under the terms of the GNU Lesser Public License as
//  published by the Free Software Foundation; either version 2.1 of
//  the License, or (at your option) any later version.
//
//  The ZBar Bar Code Reader is distributed in the hope that it will be
//  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
//  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser Public License for more details.
//
//  You should have received a copy of the GNU Lesser Public License
//  along with the ZBar Bar Code Reader; if not, write to the Free
//  Software Foundation, Inc., 51 Franklin St, Fifth Floor,
//  Boston, MA  02110-1301  USA
//
//  http://sourceforge.net/projects/zbar
//------------------------------------------------------------------------
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <zbar.h>

typedef zbar_symbol_t *Barcode__ZBar__Symbol;
typedef zbar_image_t *Barcode__ZBar__Image;
typedef zbar_processor_t *Barcode__ZBar__Processor;
typedef zbar_video_t *Barcode__ZBar__Video;
typedef zbar_window_t *Barcode__ZBar__Window;
typedef zbar_image_scanner_t *Barcode__ZBar__ImageScanner;
typedef zbar_decoder_t *Barcode__ZBar__Decoder;
typedef zbar_scanner_t *Barcode__ZBar__Scanner;
typedef void *Barcode__ZBar__Error;

typedef unsigned long fourcc_t;
typedef int timeout_t;
typedef int config_error;

typedef struct handler_wrapper_s {
    SV *instance;
    SV *handler;
    SV *closure;
} handler_wrapper_t;


static AV *LOOKUP_zbar_color_t = NULL;
static AV *LOOKUP_zbar_symbol_type_t = NULL;
static AV *LOOKUP_zbar_error_t = NULL;
static AV *LOOKUP_zbar_config_t = NULL;
static AV *LOOKUP_zbar_modifier_t = NULL;
static AV *LOOKUP_zbar_orientation_t = NULL;

#define CONSTANT(typ, prefix, sym, name)                \
    do {                                                \
        SV *c = newSViv(ZBAR_ ## prefix ## sym);        \
        sv_setpv(c, name);                              \
        SvIOK_on(c);                                    \
        newCONSTSUB(stash, #sym, c);                    \
        av_store(LOOKUP_zbar_ ## typ ## _t,             \
                 ZBAR_ ## prefix ## sym,                \
                 SvREFCNT_inc(c));                      \
    } while(0)

#define LOOKUP_ENUM(typ, val) \
    lookup_enum(LOOKUP_zbar_ ## typ ## _t, val)

static inline SV *lookup_enum (AV *lookup, int val)
{
    SV **tmp = av_fetch(lookup, val, 0);
    return((tmp) ? *tmp : sv_newmortal());
}

static inline void check_error (int rc, void *obj)
{
    if(rc < 0) {
        sv_setref_pv(get_sv("@", TRUE), "Barcode::ZBar::Error", obj);
        croak(NULL);
    }
}

#define PUSH_SYMS(x)                                                    \
    do {                                                                \
        const zbar_symbol_t *sym = (const zbar_symbol_t*)(x);           \
        for(; sym; sym = zbar_symbol_next(sym)) {                       \
            zbar_symbol_t *s = (zbar_symbol_t*)sym;                     \
            zbar_symbol_ref(s, 1);                                      \
            XPUSHs(sv_setref_pv(sv_newmortal(), "Barcode::ZBar::Symbol", \
                                (void*)sym));                           \
        }                                                               \
    } while(0);

#define PUSH_ENUM_MASK(typ, TYP, val)                         \
    do {                                                      \
        unsigned mask = (val);                                \
        int i;                                                \
        for(i = 0; i < ZBAR_ ## TYP ## _NUM; i++, mask >>= 1) \
            if(mask & 1)                                      \
                XPUSHs(LOOKUP_ENUM(typ, i));                  \
    } while(0);

static void image_cleanup_handler (zbar_image_t *image)
{
    SV *data = zbar_image_get_userdata(image);
    if(!data)
        /* FIXME this is internal error */
        return;

    /* release reference to cleanup data */
    SvREFCNT_dec(data);
}

static inline int set_handler (handler_wrapper_t **wrapp,
                               SV *instance,
                               SV *handler,
                               SV *closure)
{
    handler_wrapper_t *wrap = *wrapp;
    if(!handler || !SvOK(handler)) {
        if(wrap) {
            if(wrap->instance) SvREFCNT_dec(wrap->instance);
            if(wrap->handler) SvREFCNT_dec(wrap->handler);
            if(wrap->closure) SvREFCNT_dec(wrap->closure);
            wrap->instance = wrap->handler = wrap->closure = NULL;
        }
        return(0);
    }

    if(!wrap) {
        Newxz(wrap, 1, handler_wrapper_t);
        wrap->instance = newSVsv(instance);
        wrap->closure = newSV(0);
        *wrapp = wrap;
    }

    if(wrap->handler)
        SvSetSV(wrap->handler, handler);
    else
        wrap->handler = newSVsv(handler);

    if(!closure || !SvOK(closure))
        SvSetSV(wrap->closure, &PL_sv_undef);
    else
        SvSetSV(wrap->closure, closure);
    return(1);
}

static inline void activate_handler (handler_wrapper_t *wrap,
                                     SV *param)
{
    dSP;
    if(!wrap)
        /* FIXME this is internal error */
        return;

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 3);
    PUSHs(sv_mortalcopy(wrap->instance));
    if(param)
        PUSHs(param);
    PUSHs(sv_mortalcopy(wrap->closure));
    PUTBACK;

    call_sv(wrap->handler, G_DISCARD);

    FREETMPS;
    LEAVE;
}

static void processor_handler (zbar_image_t *image,
                               const void *userdata)
{
    SV *img;
    zbar_image_ref(image, 1);
    img = sv_setref_pv(newSV(0), "Barcode::ZBar::Image", image);
    activate_handler((void*)userdata, img);
    SvREFCNT_dec(img);
}

static void decoder_handler (zbar_decoder_t *decoder)
{
    activate_handler(zbar_decoder_get_userdata(decoder), NULL);
}


#line 204 "ZBar.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 348 "ZBar.c"

XS_EUPXS(XS_Barcode__ZBar_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar_version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 210 "ZBar.xs"
	unsigned major;
        unsigned minor;
#line 360 "ZBar.c"
	SV *	RETVAL;
#line 213 "ZBar.xs"
        zbar_version(&major, &minor, NULL);
        RETVAL = newSVpvf("%u.%u", major, minor);
#line 365 "ZBar.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar_increase_verbosity); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar_increase_verbosity)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	zbar_increase_verbosity();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar_set_verbosity); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar_set_verbosity)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "verbosity");
    {
	int	verbosity = (int)SvIV(ST(0))
;

	zbar_set_verbosity(verbosity);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar_parse_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar_parse_config)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "config_string");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	config_string = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
#line 229 "ZBar.xs"
        zbar_symbol_type_t sym;
        zbar_config_t cfg;
        int val;
#line 418 "ZBar.c"
	SV *	RETVAL;
#line 233 "ZBar.xs"
        if(zbar_parse_config(config_string, &sym, &cfg, &val))
            croak("invalid configuration setting: %s", config_string);
        EXTEND(SP, 3);
        PUSHs(LOOKUP_ENUM(symbol_type, sym));
        PUSHs(LOOKUP_ENUM(config, cfg));
        mPUSHi(val);
#line 427 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Error_get_error_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Error_get_error_code)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "err");
    {
	Barcode__ZBar__Error	err;
	zbar_error_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Error")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    err = INT2PTR(Barcode__ZBar__Error,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Error::get_error_code",
			"err", "Barcode::ZBar::Error",
			refstr, ST(0)
		);
	}
;
#line 265 "ZBar.xs"
	RETVAL = _zbar_get_error_code(err);
#line 459 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_error_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Error_error_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Error_error_string)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "err");
    {
	Barcode__ZBar__Error	err;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Error")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    err = INT2PTR(Barcode__ZBar__Error,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Error::error_string",
			"err", "Barcode::ZBar::Error",
			refstr, ST(0)
		);
	}
;
#line 273 "ZBar.xs"
	RETVAL = _zbar_error_string(err, 1);
#line 497 "ZBar.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::Symbol::DESTROY",
			"symbol")
;
#line 354 "ZBar.xs"
        zbar_symbol_ref(symbol, -1);
#line 526 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_type",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_symbol_get_type(symbol);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_configs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_configs)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Symbol	symbol;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_configs",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;
#line 364 "ZBar.xs"
        PUSH_ENUM_MASK(config, CFG, zbar_symbol_get_configs(symbol));
#line 595 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_modifiers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_modifiers)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Symbol	symbol;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_modifiers",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;
#line 370 "ZBar.xs"
        PUSH_ENUM_MASK(modifier, MOD, zbar_symbol_get_modifiers(symbol));
#line 629 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_data",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;
#line 376 "ZBar.xs"
	RETVAL = newSVpvn(zbar_symbol_get_data(symbol),
                          zbar_symbol_get_data_length(symbol));
#line 662 "ZBar.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_count",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_symbol_get_count(symbol);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_quality); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_quality)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_quality",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_symbol_get_quality(symbol);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_loc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_loc)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Symbol	symbol;
#line 393 "ZBar.xs"
        unsigned i, size;
#line 748 "ZBar.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_loc",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;
#line 395 "ZBar.xs"
        size = zbar_symbol_get_loc_size(symbol);
        EXTEND(SP, size);
        for(i = 0; i < size; i++) {
            AV *pt = (AV*)sv_2mortal((SV*)newAV());
            PUSHs(newRV((SV*)pt));
            av_push(pt, newSVuv(zbar_symbol_get_loc_x(symbol, i)));
            av_push(pt, newSVuv(zbar_symbol_get_loc_y(symbol, i)));
        }
#line 773 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_orientation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_orientation)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    {
	Barcode__ZBar__Symbol	symbol;
	zbar_orientation_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_orientation",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_symbol_get_orientation(symbol);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_orientation_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Symbol_get_components); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Symbol_get_components)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "symbol");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Symbol	symbol;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Symbol")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    symbol = INT2PTR(Barcode__ZBar__Symbol,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Symbol::get_components",
			"symbol", "Barcode::ZBar::Symbol",
			refstr, ST(0)
		);
	}
;
#line 412 "ZBar.xs"
        PUSH_SYMS(zbar_symbol_first_component(symbol));
#line 843 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Image_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "package");
    {
	char *	package = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
	Barcode__ZBar__Image	RETVAL;
#line 421 "ZBar.xs"
        RETVAL = zbar_image_create();
#line 862 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Image", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    {
	Barcode__ZBar__Image	image;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::Image::DESTROY",
			"image")
;
#line 429 "ZBar.xs"
        zbar_image_destroy(image);
#line 894 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Image_convert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_convert)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "image, format");
    {
	Barcode__ZBar__Image	image;
	fourcc_t	format;
	Barcode__ZBar__Image	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::convert",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	{
            if(SvPOK(ST(1))) {
                char *str = SvPV_nolen(ST(1));
                format = zbar_fourcc_parse(str);
            }
            else
                format = SvUV(ST(1));
        }
;

	RETVAL = zbar_image_convert(image, format);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Image", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_convert_resize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_convert_resize)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "image, format, width, height");
    {
	Barcode__ZBar__Image	image;
	fourcc_t	format;
	unsigned	width = (unsigned)SvUV(ST(2))
;
	unsigned	height = (unsigned)SvUV(ST(3))
;
	Barcode__ZBar__Image	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::convert_resize",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	{
            if(SvPOK(ST(1))) {
                char *str = SvPV_nolen(ST(1));
                format = zbar_fourcc_parse(str);
            }
            else
                format = SvUV(ST(1));
        }
;

	RETVAL = zbar_image_convert_resize(image, format, width, height);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Image", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_format); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_format)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    {
	Barcode__ZBar__Image	image;
	fourcc_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_format",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_image_get_format(image);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    {
		char str[4] = {
		    RETVAL & 0xff,
		    (RETVAL >> 8) & 0xff,
		    (RETVAL >> 16) & 0xff,
		    (RETVAL >> 24) & 0xff,
		};
		sv_setuv(RETVALSV, RETVAL);
		sv_setpvn(RETVALSV, str, 4);
		SvIOK_on(RETVALSV);
	    }
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_sequence); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_sequence)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    {
	Barcode__ZBar__Image	image;
	unsigned	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_sequence",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_image_get_sequence(image);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Image	image;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_size",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;
#line 455 "ZBar.xs"
        EXTEND(SP, 2);
        mPUSHu(zbar_image_get_width(image));
        mPUSHu(zbar_image_get_height(image));
#line 1105 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_crop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_crop)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Image	image;
#line 463 "ZBar.xs"
        unsigned x, y, w, h;
#line 1124 "ZBar.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_crop",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;
#line 465 "ZBar.xs"
        zbar_image_get_crop(image, &x, &y, &w, &h);
        EXTEND(SP, 4);
        mPUSHu(x);
        mPUSHu(y);
        mPUSHu(w);
        mPUSHu(h);
#line 1146 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    {
	Barcode__ZBar__Image	image;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_data",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;
#line 476 "ZBar.xs"
	RETVAL = newSVpvn(zbar_image_get_data(image),
                          zbar_image_get_data_length(image));
#line 1179 "ZBar.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Image_get_symbols); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_get_symbols)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "image");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Image	image;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::get_symbols",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;
#line 485 "ZBar.xs"
        PUSH_SYMS(zbar_image_first_symbol(image));
#line 1214 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Image_set_format); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_set_format)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "image, format");
    {
	Barcode__ZBar__Image	image;
	fourcc_t	format;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::set_format",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	{
            if(SvPOK(ST(1))) {
                char *str = SvPV_nolen(ST(1));
                format = zbar_fourcc_parse(str);
            }
            else
                format = SvUV(ST(1));
        }
;

	zbar_image_set_format(image, format);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Image_set_sequence); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_set_sequence)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "image, seq_num");
    {
	Barcode__ZBar__Image	image;
	unsigned	seq_num = (unsigned)SvUV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::set_sequence",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	zbar_image_set_sequence(image, seq_num);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Image_set_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_set_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "image, width, height");
    {
	Barcode__ZBar__Image	image;
	int	width = (int)SvIV(ST(1))
;
	int	height = (int)SvIV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::set_size",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	 if(width < 0) width = 0;

	 if(height < 0) height = 0;

	zbar_image_set_size(image, width, height);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Image_set_crop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_set_crop)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "image, x, y, width, height");
    {
	Barcode__ZBar__Image	image;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::set_crop",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;

	 if(x < 0) { width += x; x = 0; }

	 if(y < 0) { height += y; y = 0; }

	zbar_image_set_crop(image, x, y, width, height);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Image_set_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Image_set_data)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "image, data");
    {
	Barcode__ZBar__Image	image;
	SV *	data = ST(1)
;
#line 516 "ZBar.xs"
        SV *old;
#line 1382 "ZBar.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Image::set_data",
			"image", "Barcode::ZBar::Image",
			refstr, ST(0)
		);
	}
;
#line 518 "ZBar.xs"
	if(!data || !SvOK(data)) {
            zbar_image_set_data(image, NULL, 0, NULL);
            zbar_image_set_userdata(image, NULL);
        }
        else if(SvPOK(data)) {
            /* FIXME is this copy of data or new ref to same data?
             * not sure this is correct:
             * need to retain a reference to image data,
             * but do not really want to copy it...maybe an RV?
             */
            SV *copy = newSVsv(data);
            STRLEN len;
            void *raw = SvPV(copy, len);
            zbar_image_set_data(image, raw, len, image_cleanup_handler);
            zbar_image_set_userdata(image, copy);
        }
        else
            croak("image data must be binary string");
#line 1416 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "package, threaded=0");
    {
	char *	package = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
	bool	threaded;
	Barcode__ZBar__Processor	RETVAL;

	if (items < 2)
	    threaded = 0;
	else {
	    threaded = (bool)SvTRUE(ST(1))
;
	}
#line 545 "ZBar.xs"
        RETVAL = zbar_processor_create(threaded);
#line 1442 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Processor", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "processor");
    {
	Barcode__ZBar__Processor	processor;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::Processor::DESTROY",
			"processor")
;
#line 553 "ZBar.xs"
        zbar_processor_destroy(processor);
#line 1474 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_init)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "processor, video_device=\"\", enable_display=1");
    {
	Barcode__ZBar__Processor	processor;
	const char *	video_device;
	bool	enable_display;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::init",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    video_device = "";
	else {
	    video_device = SvOK(ST(1)) ? SvPV_nolen(ST(1)) : NULL
;
	}

	if (items < 3)
	    enable_display = 1;
	else {
	    enable_display = (bool)SvTRUE(ST(2))
;
	}
#line 561 "ZBar.xs"
        check_error(zbar_processor_init(processor, video_device, enable_display),
                    processor);
#line 1521 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_request_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_request_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "processor, width, height");
    {
	Barcode__ZBar__Processor	processor;
	unsigned	width = (unsigned)SvUV(ST(1))
;
	unsigned	height = (unsigned)SvUV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::request_size",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;
#line 570 "ZBar.xs"
	check_error(zbar_processor_request_size(processor, width, height),
                    processor);
#line 1556 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_force_format); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_force_format)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "processor, input_format=0, output_format=0");
    {
	Barcode__ZBar__Processor	processor;
	fourcc_t	input_format;
	fourcc_t	output_format;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::force_format",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    input_format = 0;
	else {
	    {
	    if(SvPOK(ST(1))) {
		char *str = SvPV_nolen(ST(1));
		input_format = zbar_fourcc_parse(str);
	    }
	    else
		input_format = SvUV(ST(1));
	}
;
	}

	if (items < 3)
	    output_format = 0;
	else {
	    {
	    if(SvPOK(ST(2))) {
		char *str = SvPV_nolen(ST(2));
		output_format = zbar_fourcc_parse(str);
	    }
	    else
		output_format = SvUV(ST(2));
	}
;
	}
#line 579 "ZBar.xs"
	check_error(zbar_processor_force_format(processor, input_format, output_format),
                    processor);
#line 1617 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_set_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_set_config)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "processor, symbology, config, value=1");
    {
	Barcode__ZBar__Processor	processor;
	zbar_symbol_type_t	symbology = (zbar_symbol_type_t)SvIV(ST(1))
;
	zbar_config_t	config = (zbar_config_t)SvIV(ST(2))
;
	int	value;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::set_config",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    value = 1;
	else {
	    value = (int)SvIV(ST(3))
;
	}

	zbar_processor_set_config(processor, symbology, config, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_parse_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_parse_config)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "processor, config_string");
    {
	Barcode__ZBar__Processor	processor;
	const char *	config_string = SvOK(ST(1)) ? SvPV_nolen(ST(1)) : NULL
;
	config_error	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::parse_config",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_processor_parse_config(processor, config_string);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if(RETVAL)
		croak("invalid configuration setting: %s", config_string);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_is_visible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_is_visible)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "processor");
    {
	Barcode__ZBar__Processor	processor;
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::is_visible",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;
#line 598 "ZBar.xs"
	check_error((RETVAL = zbar_processor_is_visible(processor)),
                    processor);
#line 1729 "ZBar.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_set_visible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_set_visible)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "processor, visible=1");
    {
	Barcode__ZBar__Processor	processor;
	bool	visible;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::set_visible",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    visible = 1;
	else {
	    visible = (bool)SvTRUE(ST(1))
;
	}
#line 608 "ZBar.xs"
	check_error(zbar_processor_set_visible(processor, visible),
                    processor);
#line 1769 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_set_active); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_set_active)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "processor, active=1");
    {
	Barcode__ZBar__Processor	processor;
	bool	active;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::set_active",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    active = 1;
	else {
	    active = (bool)SvTRUE(ST(1))
;
	}
#line 616 "ZBar.xs"
	check_error(zbar_processor_set_active(processor, active),
                    processor);
#line 1808 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Processor_get_results); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_get_results)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "processor");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Processor	processor;
#line 623 "ZBar.xs"
        const zbar_symbol_set_t	*syms;
#line 1826 "ZBar.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::get_results",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;
#line 625 "ZBar.xs"
        syms = zbar_processor_get_results(processor);
        PUSH_SYMS(zbar_symbol_set_first_symbol(syms));
        zbar_symbol_set_ref(syms, -1);
#line 1846 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Processor_user_wait); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_user_wait)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "processor, timeout=-1");
    {
	Barcode__ZBar__Processor	processor;
	timeout_t	timeout;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::user_wait",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    timeout = -1;
	else {
	    if((timeout = (timeout_t)(SvNV(ST(1)) * 1000.)) < 0)
	    timeout = -1
;
	}
#line 634 "ZBar.xs"
	check_error((RETVAL = zbar_processor_user_wait(processor, timeout)),
                    processor);
#line 1889 "ZBar.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_process_one); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_process_one)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "processor, timeout=-1");
    {
	Barcode__ZBar__Processor	processor;
	timeout_t	timeout;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::process_one",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    timeout = -1;
	else {
	    if((timeout = (timeout_t)(SvNV(ST(1)) * 1000.)) < 0)
	    timeout = -1
;
	}
#line 644 "ZBar.xs"
	check_error((RETVAL = zbar_process_one(processor, timeout)),
                    processor);
#line 1933 "ZBar.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_process_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_process_image)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "processor, image");
    {
	Barcode__ZBar__Processor	processor;
	Barcode__ZBar__Image	image;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::process_image",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::process_image",
			"image", "Barcode::ZBar::Image",
			refstr, ST(1)
		);
	}
;
#line 654 "ZBar.xs"
	check_error((RETVAL = zbar_process_image(processor, image)),
                    processor);
#line 1983 "ZBar.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Processor_set_data_handler); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Processor_set_data_handler)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "processor, handler = 0, closure = 0");
    {
	Barcode__ZBar__Processor	processor;
	SV *	handler;
	SV *	closure;
#line 665 "ZBar.xs"
        handler_wrapper_t *wrap;
        zbar_image_data_handler_t *callback = NULL;
#line 2004 "ZBar.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Processor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    processor = INT2PTR(Barcode__ZBar__Processor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Processor::set_data_handler",
			"processor", "Barcode::ZBar::Processor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    handler = 0;
	else {
	    handler = ST(1)
;
	}

	if (items < 3)
	    closure = 0;
	else {
	    closure = ST(2)
;
	}
#line 668 "ZBar.xs"
        wrap = zbar_processor_get_userdata(processor);
        if(set_handler(&wrap, ST(0), handler, closure))
            callback = processor_handler;
        zbar_processor_set_data_handler(processor, callback, wrap);
#line 2038 "ZBar.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "package");
    {
	char *	package = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
	Barcode__ZBar__ImageScanner	RETVAL;
#line 680 "ZBar.xs"
        RETVAL = zbar_image_scanner_create();
#line 2056 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::ImageScanner", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__ImageScanner	scanner;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::ImageScanner::DESTROY",
			"scanner")
;
#line 688 "ZBar.xs"
        zbar_image_scanner_destroy(scanner);
#line 2088 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_set_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_set_config)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "scanner, symbology, config, value=1");
    {
	Barcode__ZBar__ImageScanner	scanner;
	zbar_symbol_type_t	symbology = (zbar_symbol_type_t)SvIV(ST(1))
;
	zbar_config_t	config = (zbar_config_t)SvIV(ST(2))
;
	int	value;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::set_config",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    value = 1;
	else {
	    value = (int)SvIV(ST(3))
;
	}

	zbar_image_scanner_set_config(scanner, symbology, config, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_parse_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_parse_config)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "scanner, config_string");
    {
	Barcode__ZBar__ImageScanner	scanner;
	const char *	config_string = SvOK(ST(1)) ? SvPV_nolen(ST(1)) : NULL
;
	config_error	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::parse_config",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_image_scanner_parse_config(scanner, config_string);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if(RETVAL)
		croak("invalid configuration setting: %s", config_string);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_enable_cache); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_enable_cache)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "scanner, enable");
    {
	Barcode__ZBar__ImageScanner	scanner;
	int	enable = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::enable_cache",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;

	zbar_image_scanner_enable_cache(scanner, enable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_recycle_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_recycle_image)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "scanner, image");
    {
	Barcode__ZBar__ImageScanner	scanner;
	Barcode__ZBar__Image	image;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::recycle_image",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::recycle_image",
			"image", "Barcode::ZBar::Image",
			refstr, ST(1)
		);
	}
;

	zbar_image_scanner_recycle_image(scanner, image);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_get_results); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_get_results)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__ImageScanner	scanner;
#line 716 "ZBar.xs"
        const zbar_symbol_set_t	*syms;
#line 2261 "ZBar.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::get_results",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;
#line 718 "ZBar.xs"
        syms = zbar_image_scanner_get_results(scanner);
        PUSH_SYMS(zbar_symbol_set_first_symbol(syms));
#line 2280 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__ImageScanner_scan_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__ImageScanner_scan_image)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "scanner, image");
    {
	Barcode__ZBar__ImageScanner	scanner;
	Barcode__ZBar__Image	image;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::ImageScanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__ImageScanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::scan_image",
			"scanner", "Barcode::ZBar::ImageScanner",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Barcode::ZBar::Image")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    image = INT2PTR(Barcode__ZBar__Image,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::ImageScanner::scan_image",
			"image", "Barcode::ZBar::Image",
			refstr, ST(1)
		);
	}
;
#line 726 "ZBar.xs"
	RETVAL = zbar_scan_image(scanner, image);
#line 2328 "ZBar.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "package");
    {
	char *	package = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
	Barcode__ZBar__Decoder	RETVAL;
#line 737 "ZBar.xs"
        RETVAL = zbar_decoder_create();
#line 2348 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Decoder", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::Decoder::DESTROY",
			"decoder")
;
#line 745 "ZBar.xs"
        /* FIXME cleanup handler wrapper */
        zbar_decoder_destroy(decoder);
#line 2381 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_set_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_set_config)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "decoder, symbology, config, value=1");
    {
	Barcode__ZBar__Decoder	decoder;
	zbar_symbol_type_t	symbology = (zbar_symbol_type_t)SvIV(ST(1))
;
	zbar_config_t	config = (zbar_config_t)SvIV(ST(2))
;
	int	value;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::set_config",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	if (items < 4)
	    value = 1;
	else {
	    value = (int)SvIV(ST(3))
;
	}

	zbar_decoder_set_config(decoder, symbology, config, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_parse_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_parse_config)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "decoder, config_string");
    {
	Barcode__ZBar__Decoder	decoder;
	const char *	config_string = SvOK(ST(1)) ? SvPV_nolen(ST(1)) : NULL
;
	config_error	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::parse_config",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_decoder_parse_config(decoder, config_string);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    if(RETVAL)
		croak("invalid configuration setting: %s", config_string);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::reset",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	zbar_decoder_reset(decoder);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_new_scan); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_new_scan)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::new_scan",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	zbar_decoder_new_scan(decoder);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_decode_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_decode_width)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "decoder, width");
    {
	Barcode__ZBar__Decoder	decoder;
	unsigned	width = (unsigned)SvUV(ST(1))
;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::decode_width",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;
#line 773 "ZBar.xs"
	RETVAL = zbar_decode_width(decoder, width);
#line 2552 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_color); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_color)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;
	zbar_color_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_color",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_decoder_get_color(decoder);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_color_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_data",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;
#line 785 "ZBar.xs"
	RETVAL = newSVpvn(zbar_decoder_get_data(decoder),
                          zbar_decoder_get_data_length(decoder));
#line 2626 "ZBar.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_type",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_decoder_get_type(decoder);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_configs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_configs)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "decoder, symbology");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Decoder	decoder;
	zbar_symbol_type_t	symbology = (zbar_symbol_type_t)SvIV(ST(1))
;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_configs",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;
#line 799 "ZBar.xs"
        if(symbology == ZBAR_NONE)
            symbology = zbar_decoder_get_type(decoder);
        PUSH_ENUM_MASK(config, CFG, zbar_decoder_get_configs(decoder, symbology));
#line 2701 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_modifiers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_modifiers)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Barcode__ZBar__Decoder	decoder;
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_modifiers",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;
#line 807 "ZBar.xs"
        PUSH_ENUM_MASK(modifier, MOD, zbar_decoder_get_modifiers(decoder));
#line 2735 "ZBar.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_get_direction); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_get_direction)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "decoder");
    {
	Barcode__ZBar__Decoder	decoder;
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::get_direction",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_decoder_get_direction(decoder);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Decoder_set_handler); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Decoder_set_handler)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "decoder, handler = 0, closure = 0");
    {
	Barcode__ZBar__Decoder	decoder;
	SV *	handler;
	SV *	closure;
#line 819 "ZBar.xs"
        handler_wrapper_t *wrap;
#line 2787 "ZBar.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Decoder")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Decoder::set_handler",
			"decoder", "Barcode::ZBar::Decoder",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    handler = 0;
	else {
	    handler = ST(1)
;
	}

	if (items < 3)
	    closure = 0;
	else {
	    closure = ST(2)
;
	}
#line 821 "ZBar.xs"
        wrap = zbar_decoder_get_userdata(decoder);
        zbar_decoder_set_handler(decoder, NULL);
        if(set_handler(&wrap, ST(0), handler, closure)) {
            zbar_decoder_set_userdata(decoder, wrap);
            zbar_decoder_set_handler(decoder, decoder_handler);
        }
#line 2823 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "package, decoder = 0");
    {
	char *	package = SvOK(ST(0)) ? SvPV_nolen(ST(0)) : NULL
;
	Barcode__ZBar__Decoder	decoder;
	Barcode__ZBar__Scanner	RETVAL;

	if (items < 2)
	    decoder = 0;
	else {
	    if (SvROK(ST(1)) && sv_derived_from(ST(1), "Barcode::ZBar::Decoder")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		decoder = INT2PTR(Barcode__ZBar__Decoder,tmp);
	    }
	    else {
		    const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
		Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			    "Barcode::ZBar::Scanner::new",
			    "decoder", "Barcode::ZBar::Decoder",
			    refstr, ST(1)
		    );
	    }
;
	}
#line 836 "ZBar.xs"
        RETVAL = zbar_scanner_create(decoder);
#line 2860 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Barcode::ZBar::Scanner", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__Scanner	scanner;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Barcode::ZBar::Scanner::DESTROY",
			"scanner")
;
#line 844 "ZBar.xs"
        zbar_scanner_destroy(scanner);
#line 2892 "ZBar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_reset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__Scanner	scanner;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Scanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Scanner::reset",
			"scanner", "Barcode::ZBar::Scanner",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_scanner_reset(scanner);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_new_scan); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_new_scan)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__Scanner	scanner;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Scanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Scanner::new_scan",
			"scanner", "Barcode::ZBar::Scanner",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_scanner_new_scan(scanner);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_get_color); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_get_color)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__Scanner	scanner;
	zbar_color_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Scanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Scanner::get_color",
			"scanner", "Barcode::ZBar::Scanner",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_scanner_get_color(scanner);
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_color_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_get_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_get_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "scanner");
    {
	Barcode__ZBar__Scanner	scanner;
	unsigned	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Scanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Scanner::get_width",
			"scanner", "Barcode::ZBar::Scanner",
			refstr, ST(0)
		);
	}
;

	RETVAL = zbar_scanner_get_width(scanner);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Barcode__ZBar__Scanner_scan_y); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Barcode__ZBar__Scanner_scan_y)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "scanner, y");
    {
	Barcode__ZBar__Scanner	scanner;
	int	y = (int)SvIV(ST(1))
;
	zbar_symbol_type_t	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Barcode::ZBar::Scanner")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    scanner = INT2PTR(Barcode__ZBar__Scanner,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Barcode::ZBar::Scanner::scan_y",
			"scanner", "Barcode::ZBar::Scanner",
			refstr, ST(0)
		);
	}
;
#line 867 "ZBar.xs"
	RETVAL = zbar_scan_y(scanner, y);
#line 3066 "ZBar.c"
	{
	    SV * RETVALSV;
	    RETVALSV = SvREFCNT_inc(lookup_enum(LOOKUP_zbar_symbol_type_t, (int)RETVAL));
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Barcode__ZBar); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Barcode__ZBar)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Barcode::ZBar::version", XS_Barcode__ZBar_version, file, "");
        (void)newXSproto_portable("Barcode::ZBar::increase_verbosity", XS_Barcode__ZBar_increase_verbosity, file, "");
        (void)newXSproto_portable("Barcode::ZBar::set_verbosity", XS_Barcode__ZBar_set_verbosity, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::parse_config", XS_Barcode__ZBar_parse_config, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Error::get_error_code", XS_Barcode__ZBar__Error_get_error_code, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Error::error_string", XS_Barcode__ZBar__Error_error_string, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::DESTROY", XS_Barcode__ZBar__Symbol_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_type", XS_Barcode__ZBar__Symbol_get_type, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_configs", XS_Barcode__ZBar__Symbol_get_configs, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_modifiers", XS_Barcode__ZBar__Symbol_get_modifiers, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_data", XS_Barcode__ZBar__Symbol_get_data, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_count", XS_Barcode__ZBar__Symbol_get_count, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_quality", XS_Barcode__ZBar__Symbol_get_quality, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_loc", XS_Barcode__ZBar__Symbol_get_loc, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_orientation", XS_Barcode__ZBar__Symbol_get_orientation, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Symbol::get_components", XS_Barcode__ZBar__Symbol_get_components, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::new", XS_Barcode__ZBar__Image_new, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::DESTROY", XS_Barcode__ZBar__Image_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::convert", XS_Barcode__ZBar__Image_convert, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::convert_resize", XS_Barcode__ZBar__Image_convert_resize, file, "$$$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_format", XS_Barcode__ZBar__Image_get_format, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_sequence", XS_Barcode__ZBar__Image_get_sequence, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_size", XS_Barcode__ZBar__Image_get_size, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_crop", XS_Barcode__ZBar__Image_get_crop, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_data", XS_Barcode__ZBar__Image_get_data, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::get_symbols", XS_Barcode__ZBar__Image_get_symbols, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Image::set_format", XS_Barcode__ZBar__Image_set_format, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::set_sequence", XS_Barcode__ZBar__Image_set_sequence, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::set_size", XS_Barcode__ZBar__Image_set_size, file, "$$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::set_crop", XS_Barcode__ZBar__Image_set_crop, file, "$$$$$");
        (void)newXSproto_portable("Barcode::ZBar::Image::set_data", XS_Barcode__ZBar__Image_set_data, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::new", XS_Barcode__ZBar__Processor_new, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::DESTROY", XS_Barcode__ZBar__Processor_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::init", XS_Barcode__ZBar__Processor_init, file, "$;$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::request_size", XS_Barcode__ZBar__Processor_request_size, file, "$$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::force_format", XS_Barcode__ZBar__Processor_force_format, file, "$;$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::set_config", XS_Barcode__ZBar__Processor_set_config, file, "$$$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::parse_config", XS_Barcode__ZBar__Processor_parse_config, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::is_visible", XS_Barcode__ZBar__Processor_is_visible, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::set_visible", XS_Barcode__ZBar__Processor_set_visible, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::set_active", XS_Barcode__ZBar__Processor_set_active, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::get_results", XS_Barcode__ZBar__Processor_get_results, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::user_wait", XS_Barcode__ZBar__Processor_user_wait, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::process_one", XS_Barcode__ZBar__Processor_process_one, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::process_image", XS_Barcode__ZBar__Processor_process_image, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Processor::set_data_handler", XS_Barcode__ZBar__Processor_set_data_handler, file, "$;$$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::new", XS_Barcode__ZBar__ImageScanner_new, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::DESTROY", XS_Barcode__ZBar__ImageScanner_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::set_config", XS_Barcode__ZBar__ImageScanner_set_config, file, "$$$;$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::parse_config", XS_Barcode__ZBar__ImageScanner_parse_config, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::enable_cache", XS_Barcode__ZBar__ImageScanner_enable_cache, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::recycle_image", XS_Barcode__ZBar__ImageScanner_recycle_image, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::get_results", XS_Barcode__ZBar__ImageScanner_get_results, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::ImageScanner::scan_image", XS_Barcode__ZBar__ImageScanner_scan_image, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::new", XS_Barcode__ZBar__Decoder_new, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::DESTROY", XS_Barcode__ZBar__Decoder_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::set_config", XS_Barcode__ZBar__Decoder_set_config, file, "$$$;$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::parse_config", XS_Barcode__ZBar__Decoder_parse_config, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::reset", XS_Barcode__ZBar__Decoder_reset, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::new_scan", XS_Barcode__ZBar__Decoder_new_scan, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::decode_width", XS_Barcode__ZBar__Decoder_decode_width, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_color", XS_Barcode__ZBar__Decoder_get_color, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_data", XS_Barcode__ZBar__Decoder_get_data, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_type", XS_Barcode__ZBar__Decoder_get_type, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_configs", XS_Barcode__ZBar__Decoder_get_configs, file, "$$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_modifiers", XS_Barcode__ZBar__Decoder_get_modifiers, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::get_direction", XS_Barcode__ZBar__Decoder_get_direction, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Decoder::set_handler", XS_Barcode__ZBar__Decoder_set_handler, file, "$;$$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::new", XS_Barcode__ZBar__Scanner_new, file, "$;$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::DESTROY", XS_Barcode__ZBar__Scanner_DESTROY, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::reset", XS_Barcode__ZBar__Scanner_reset, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::new_scan", XS_Barcode__ZBar__Scanner_new_scan, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::get_color", XS_Barcode__ZBar__Scanner_get_color, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::get_width", XS_Barcode__ZBar__Scanner_get_width, file, "$");
        (void)newXSproto_portable("Barcode::ZBar::Scanner::scan_y", XS_Barcode__ZBar__Scanner_scan_y, file, "$$");

    /* Initialisation Section */

#line 199 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar", TRUE);

        LOOKUP_zbar_color_t = newAV();
        CONSTANT(color, , SPACE, "SPACE");
        CONSTANT(color, , BAR, "BAR");
    }

#line 244 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar::Error", TRUE);

        LOOKUP_zbar_error_t = newAV();
        CONSTANT(error, ERR_, NOMEM, "out of memory");
        CONSTANT(error, ERR_, INTERNAL, "internal library error");
        CONSTANT(error, ERR_, UNSUPPORTED, "unsupported request");
        CONSTANT(error, ERR_, INVALID, "invalid request");
        CONSTANT(error, ERR_, SYSTEM, "system error");
        CONSTANT(error, ERR_, LOCKING, "locking error");
        CONSTANT(error, ERR_, BUSY, "all resources busy");
        CONSTANT(error, ERR_, XDISPLAY, "X11 display error");
        CONSTANT(error, ERR_, XPROTO, "X11 protocol error");
        CONSTANT(error, ERR_, CLOSED, "output window is closed");
        CONSTANT(error, ERR_, WINAPI, "windows system error");
    }

#line 281 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar::Config", TRUE);

        LOOKUP_zbar_config_t = newAV();
        CONSTANT(config, CFG_, ENABLE, "enable");
        CONSTANT(config, CFG_, ADD_CHECK, "add-check");
        CONSTANT(config, CFG_, EMIT_CHECK, "emit-check");
        CONSTANT(config, CFG_, ASCII, "ascii");
        CONSTANT(config, CFG_, MIN_LEN, "min-length");
        CONSTANT(config, CFG_, MAX_LEN, "max-length");
        CONSTANT(config, CFG_, UNCERTAINTY, "uncertainty");
        CONSTANT(config, CFG_, POSITION, "position");
        CONSTANT(config, CFG_, X_DENSITY, "x-density");
        CONSTANT(config, CFG_, Y_DENSITY, "y-density");
    }

#line 300 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar::Modifier", TRUE);

        LOOKUP_zbar_modifier_t = newAV();
        CONSTANT(modifier, MOD_, GS1, "GS1");
        CONSTANT(modifier, MOD_, AIM, "AIM");
    }

#line 311 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar::Orient", TRUE);

        LOOKUP_zbar_orientation_t = newAV();
        CONSTANT(orientation, ORIENT_, UNKNOWN, "UNKNOWN");
        CONSTANT(orientation, ORIENT_, UP, "UP");
        CONSTANT(orientation, ORIENT_, RIGHT, "RIGHT");
        CONSTANT(orientation, ORIENT_, DOWN, "DOWN");
        CONSTANT(orientation, ORIENT_, LEFT, "LEFT");
    }

#line 326 "ZBar.xs"
    {
        HV *stash = gv_stashpv("Barcode::ZBar::Symbol", TRUE);

        LOOKUP_zbar_symbol_type_t = newAV();
        CONSTANT(symbol_type, , NONE, "None");
        CONSTANT(symbol_type, , PARTIAL, "Partial");
        CONSTANT(symbol_type, , EAN8, zbar_get_symbol_name(ZBAR_EAN8));
        CONSTANT(symbol_type, , UPCE, zbar_get_symbol_name(ZBAR_UPCE));
        CONSTANT(symbol_type, , ISBN10, zbar_get_symbol_name(ZBAR_ISBN10));
        CONSTANT(symbol_type, , UPCA, zbar_get_symbol_name(ZBAR_UPCA));
        CONSTANT(symbol_type, , EAN13, zbar_get_symbol_name(ZBAR_EAN13));
        CONSTANT(symbol_type, , ISBN13, zbar_get_symbol_name(ZBAR_ISBN13));
        CONSTANT(symbol_type, , DATABAR, zbar_get_symbol_name(ZBAR_DATABAR));
        CONSTANT(symbol_type, , DATABAR_EXP,
                 zbar_get_symbol_name(ZBAR_DATABAR_EXP));
        CONSTANT(symbol_type, , I25, zbar_get_symbol_name(ZBAR_I25));
        CONSTANT(symbol_type, , CODABAR, zbar_get_symbol_name(ZBAR_CODABAR));
        CONSTANT(symbol_type, , CODE39, zbar_get_symbol_name(ZBAR_CODE39));
        CONSTANT(symbol_type, , PDF417, zbar_get_symbol_name(ZBAR_PDF417));
        CONSTANT(symbol_type, , QRCODE, zbar_get_symbol_name(ZBAR_QRCODE));
        CONSTANT(symbol_type, , CODE93, zbar_get_symbol_name(ZBAR_CODE93));
        CONSTANT(symbol_type, , CODE128, zbar_get_symbol_name(ZBAR_CODE128));
    }

#line 3273 "ZBar.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
