// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file enumerations.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__ENUMERATIONS_HPP
#define FAST_DDS_GENERATED__ENUMERATIONS_HPP

#include <cstdint>
#include <utility>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ENUMERATIONS_SOURCE)
#define ENUMERATIONS_DllAPI __declspec( dllexport )
#else
#define ENUMERATIONS_DllAPI __declspec( dllimport )
#endif // ENUMERATIONS_SOURCE
#else
#define ENUMERATIONS_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ENUMERATIONS_DllAPI
#endif // _WIN32

namespace Test {

/*!
 * @brief This class represents the enumeration InnerEnumHelper defined by the user in the IDL file.
 * @ingroup enumerations
 */
enum class InnerEnumHelper : int32_t
{
    ENUM_VALUE_1,
    ENUM_VALUE_2,
    ENUM_VALUE_3
};

} // namespace Test
/*!
 * @brief This class represents the enumeration EnumWithValues defined by the user in the IDL file.
 * @ingroup enumerations
 */
enum class EnumWithValues : int32_t
{
    ENUM_VALUE1 = -3,
    ENUM_VALUE2 = 0,
    ENUM_VALUE3 = 3
};
/*!
 * @brief This class represents the structure EnumStructure defined by the user in the IDL file.
 * @ingroup enumerations
 */
class EnumStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EnumStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EnumStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EnumStructure that will be copied.
     */
    eProsima_user_DllExport EnumStructure(
            const EnumStructure& x)
    {
                    m_var_InnerEnumHelper = x.m_var_InnerEnumHelper;

                    m_var_scoped_InnerEnumHelper = x.m_var_scoped_InnerEnumHelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EnumStructure that will be copied.
     */
    eProsima_user_DllExport EnumStructure(
            EnumStructure&& x) noexcept
    {
        m_var_InnerEnumHelper = x.m_var_InnerEnumHelper;
        m_var_scoped_InnerEnumHelper = x.m_var_scoped_InnerEnumHelper;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EnumStructure that will be copied.
     */
    eProsima_user_DllExport EnumStructure& operator =(
            const EnumStructure& x)
    {

                    m_var_InnerEnumHelper = x.m_var_InnerEnumHelper;

                    m_var_scoped_InnerEnumHelper = x.m_var_scoped_InnerEnumHelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EnumStructure that will be copied.
     */
    eProsima_user_DllExport EnumStructure& operator =(
            EnumStructure&& x) noexcept
    {

        m_var_InnerEnumHelper = x.m_var_InnerEnumHelper;
        m_var_scoped_InnerEnumHelper = x.m_var_scoped_InnerEnumHelper;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EnumStructure& x) const
    {
        return (m_var_InnerEnumHelper == x.m_var_InnerEnumHelper &&
           m_var_scoped_InnerEnumHelper == x.m_var_scoped_InnerEnumHelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EnumStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_InnerEnumHelper
     * @param _var_InnerEnumHelper New value for member var_InnerEnumHelper
     */
    eProsima_user_DllExport void var_InnerEnumHelper(
            InnerEnumHelper _var_InnerEnumHelper)
    {
        m_var_InnerEnumHelper = _var_InnerEnumHelper;
    }

    /*!
     * @brief This function returns the value of member var_InnerEnumHelper
     * @return Value of member var_InnerEnumHelper
     */
    eProsima_user_DllExport InnerEnumHelper var_InnerEnumHelper() const
    {
        return m_var_InnerEnumHelper;
    }

    /*!
     * @brief This function returns a reference to member var_InnerEnumHelper
     * @return Reference to member var_InnerEnumHelper
     */
    eProsima_user_DllExport InnerEnumHelper& var_InnerEnumHelper()
    {
        return m_var_InnerEnumHelper;
    }


    /*!
     * @brief This function sets a value in member var_scoped_InnerEnumHelper
     * @param _var_scoped_InnerEnumHelper New value for member var_scoped_InnerEnumHelper
     */
    eProsima_user_DllExport void var_scoped_InnerEnumHelper(
            Test::InnerEnumHelper _var_scoped_InnerEnumHelper)
    {
        m_var_scoped_InnerEnumHelper = _var_scoped_InnerEnumHelper;
    }

    /*!
     * @brief This function returns the value of member var_scoped_InnerEnumHelper
     * @return Value of member var_scoped_InnerEnumHelper
     */
    eProsima_user_DllExport Test::InnerEnumHelper var_scoped_InnerEnumHelper() const
    {
        return m_var_scoped_InnerEnumHelper;
    }

    /*!
     * @brief This function returns a reference to member var_scoped_InnerEnumHelper
     * @return Reference to member var_scoped_InnerEnumHelper
     */
    eProsima_user_DllExport Test::InnerEnumHelper& var_scoped_InnerEnumHelper()
    {
        return m_var_scoped_InnerEnumHelper;
    }



private:

    InnerEnumHelper m_var_InnerEnumHelper{InnerEnumHelper::ENUM_VALUE_1};
    Test::InnerEnumHelper m_var_scoped_InnerEnumHelper{Test::InnerEnumHelper::ENUM_VALUE_1};

};
/*!
 * @brief This class represents the structure BitMaskStructure defined by the user in the IDL file.
 * @ingroup enumerations
 */
class BitMaskStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BitMaskStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BitMaskStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BitMaskStructure(
            const BitMaskStructure& x)
    {
                    m_var_InnerBitMaskHelper = x.m_var_InnerBitMaskHelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BitMaskStructure(
            BitMaskStructure&& x) noexcept
    {
        m_var_InnerBitMaskHelper = std::move(x.m_var_InnerBitMaskHelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BitMaskStructure& operator =(
            const BitMaskStructure& x)
    {

                    m_var_InnerBitMaskHelper = x.m_var_InnerBitMaskHelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BitMaskStructure& operator =(
            BitMaskStructure&& x) noexcept
    {

        m_var_InnerBitMaskHelper = std::move(x.m_var_InnerBitMaskHelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BitMaskStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BitMaskStructure& x) const
    {
        return (m_var_InnerBitMaskHelper == x.m_var_InnerBitMaskHelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x BitMaskStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BitMaskStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_InnerBitMaskHelper
     * @param _var_InnerBitMaskHelper New value to be copied in member var_InnerBitMaskHelper
     */
    eProsima_user_DllExport void var_InnerBitMaskHelper(
            const InnerBitMaskHelper& _var_InnerBitMaskHelper)
    {
        m_var_InnerBitMaskHelper = _var_InnerBitMaskHelper;
    }

    /*!
     * @brief This function moves the value in member var_InnerBitMaskHelper
     * @param _var_InnerBitMaskHelper New value to be moved in member var_InnerBitMaskHelper
     */
    eProsima_user_DllExport void var_InnerBitMaskHelper(
            InnerBitMaskHelper&& _var_InnerBitMaskHelper)
    {
        m_var_InnerBitMaskHelper = std::move(_var_InnerBitMaskHelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerBitMaskHelper
     * @return Constant reference to member var_InnerBitMaskHelper
     */
    eProsima_user_DllExport const InnerBitMaskHelper& var_InnerBitMaskHelper() const
    {
        return m_var_InnerBitMaskHelper;
    }

    /*!
     * @brief This function returns a reference to member var_InnerBitMaskHelper
     * @return Reference to member var_InnerBitMaskHelper
     */
    eProsima_user_DllExport InnerBitMaskHelper& var_InnerBitMaskHelper()
    {
        return m_var_InnerBitMaskHelper;
    }



private:

    InnerBitMaskHelper m_var_InnerBitMaskHelper{0};

};
/*!
 * @brief This class represents the structure BoundedBitMaskStructure defined by the user in the IDL file.
 * @ingroup enumerations
 */
class BoundedBitMaskStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport BoundedBitMaskStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~BoundedBitMaskStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object BoundedBitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BoundedBitMaskStructure(
            const BoundedBitMaskStructure& x)
    {
                    m_var_InnerBoundedBitMaskHelper = x.m_var_InnerBoundedBitMaskHelper;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object BoundedBitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BoundedBitMaskStructure(
            BoundedBitMaskStructure&& x) noexcept
    {
        m_var_InnerBoundedBitMaskHelper = std::move(x.m_var_InnerBoundedBitMaskHelper);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object BoundedBitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BoundedBitMaskStructure& operator =(
            const BoundedBitMaskStructure& x)
    {

                    m_var_InnerBoundedBitMaskHelper = x.m_var_InnerBoundedBitMaskHelper;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object BoundedBitMaskStructure that will be copied.
     */
    eProsima_user_DllExport BoundedBitMaskStructure& operator =(
            BoundedBitMaskStructure&& x) noexcept
    {

        m_var_InnerBoundedBitMaskHelper = std::move(x.m_var_InnerBoundedBitMaskHelper);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBitMaskStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const BoundedBitMaskStructure& x) const
    {
        return (m_var_InnerBoundedBitMaskHelper == x.m_var_InnerBoundedBitMaskHelper);
    }

    /*!
     * @brief Comparison operator.
     * @param x BoundedBitMaskStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const BoundedBitMaskStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_InnerBoundedBitMaskHelper
     * @param _var_InnerBoundedBitMaskHelper New value to be copied in member var_InnerBoundedBitMaskHelper
     */
    eProsima_user_DllExport void var_InnerBoundedBitMaskHelper(
            const InnerBoundedBitMaskHelper& _var_InnerBoundedBitMaskHelper)
    {
        m_var_InnerBoundedBitMaskHelper = _var_InnerBoundedBitMaskHelper;
    }

    /*!
     * @brief This function moves the value in member var_InnerBoundedBitMaskHelper
     * @param _var_InnerBoundedBitMaskHelper New value to be moved in member var_InnerBoundedBitMaskHelper
     */
    eProsima_user_DllExport void var_InnerBoundedBitMaskHelper(
            InnerBoundedBitMaskHelper&& _var_InnerBoundedBitMaskHelper)
    {
        m_var_InnerBoundedBitMaskHelper = std::move(_var_InnerBoundedBitMaskHelper);
    }

    /*!
     * @brief This function returns a constant reference to member var_InnerBoundedBitMaskHelper
     * @return Constant reference to member var_InnerBoundedBitMaskHelper
     */
    eProsima_user_DllExport const InnerBoundedBitMaskHelper& var_InnerBoundedBitMaskHelper() const
    {
        return m_var_InnerBoundedBitMaskHelper;
    }

    /*!
     * @brief This function returns a reference to member var_InnerBoundedBitMaskHelper
     * @return Reference to member var_InnerBoundedBitMaskHelper
     */
    eProsima_user_DllExport InnerBoundedBitMaskHelper& var_InnerBoundedBitMaskHelper()
    {
        return m_var_InnerBoundedBitMaskHelper;
    }



private:

    InnerBoundedBitMaskHelper m_var_InnerBoundedBitMaskHelper{0};

};
/*!
 * @brief This class represents the structure EnumWithValuesStructure defined by the user in the IDL file.
 * @ingroup enumerations
 */
class EnumWithValuesStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EnumWithValuesStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EnumWithValuesStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EnumWithValuesStructure that will be copied.
     */
    eProsima_user_DllExport EnumWithValuesStructure(
            const EnumWithValuesStructure& x)
    {
                    m_var_enumwithvalues = x.m_var_enumwithvalues;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EnumWithValuesStructure that will be copied.
     */
    eProsima_user_DllExport EnumWithValuesStructure(
            EnumWithValuesStructure&& x) noexcept
    {
        m_var_enumwithvalues = x.m_var_enumwithvalues;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EnumWithValuesStructure that will be copied.
     */
    eProsima_user_DllExport EnumWithValuesStructure& operator =(
            const EnumWithValuesStructure& x)
    {

                    m_var_enumwithvalues = x.m_var_enumwithvalues;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EnumWithValuesStructure that will be copied.
     */
    eProsima_user_DllExport EnumWithValuesStructure& operator =(
            EnumWithValuesStructure&& x) noexcept
    {

        m_var_enumwithvalues = x.m_var_enumwithvalues;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumWithValuesStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EnumWithValuesStructure& x) const
    {
        return (m_var_enumwithvalues == x.m_var_enumwithvalues);
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumWithValuesStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EnumWithValuesStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_enumwithvalues
     * @param _var_enumwithvalues New value for member var_enumwithvalues
     */
    eProsima_user_DllExport void var_enumwithvalues(
            EnumWithValues _var_enumwithvalues)
    {
        m_var_enumwithvalues = _var_enumwithvalues;
    }

    /*!
     * @brief This function returns the value of member var_enumwithvalues
     * @return Value of member var_enumwithvalues
     */
    eProsima_user_DllExport EnumWithValues var_enumwithvalues() const
    {
        return m_var_enumwithvalues;
    }

    /*!
     * @brief This function returns a reference to member var_enumwithvalues
     * @return Reference to member var_enumwithvalues
     */
    eProsima_user_DllExport EnumWithValues& var_enumwithvalues()
    {
        return m_var_enumwithvalues;
    }



private:

    EnumWithValues m_var_enumwithvalues{EnumWithValues::ENUM_VALUE1};

};

#endif // _FAST_DDS_GENERATED_ENUMERATIONS_HPP_


