/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __DELAY_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#define MAX_FEEDBACK 32768
#define MIN_FEEDBACK 0

typedef struct delay{
  sample *(* get_buffer)(struct delay *);
  void (*next_buffer)(struct delay *);
  sample_producer **(*get_children)(struct delay *);
  char **(*get_header)(struct delay *);
  char **(*get_code)(struct delay *);
  char **(*get_footer)(struct delay *);
  int next;
  sample *delay_buffer;
  sample_producer *input;
  sample_producer *unused; /* dummy member to terminate list of children */
  sample *buffer;
  int feedback;
  double delay_time_milli;
  int delay_size;
  int d_index;
  int biggest_size;
}delay;


delay *delay_new(double delay_time_milli,int feedback, sample_producer *input);
sample *delay_get_buffer(delay *this);
void delay_next_buffer(delay *this);
void delay_set_time(delay *this,double delay_time_milli);
void delay_set_feedback(delay *this,int feedback);
/*
  Local Variables:
  mode: font-lock
  End:
*/

