# is-posix-bracket [![NPM version](https://img.shields.io/npm/v/is-posix-bracket.svg?style=flat)](https://www.npmjs.com/package/is-posix-bracket) [![NPM downloads](https://img.shields.io/npm/dm/is-posix-bracket.svg?style=flat)](https://npmjs.org/package/is-posix-bracket) [![Build Status](https://img.shields.io/travis/jonschlinkert/is-posix-bracket.svg?style=flat)](https://travis-ci.org/jonschlinkert/is-posix-bracket)

> Returns true if the given string is a POSIX bracket expression (POSIX character class).

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install is-posix-bracket --save
```

## Usage

```js
var isPosixBracket = require('is-posix-bracket');

isPosixBracket('[foo:]]');
//=> false
isPosixBracket('[xdigit:]]');
//=> false
isPosixBracket('[[:xdigit:]]');
//=> true
isPosixBracket('[[:xdigit:]]');
//=> true
isPosixBracket('[[:alpha:]123]');
//=> true
isPosixBracket('[[:alpha:]123]');
//=> true
isPosixBracket('[a-c[:digit:]x-z]');
//=> true
isPosixBracket('[:al:]');
//=> true
isPosixBracket('[abc[:punct:][0-9]');
//=> true
```

## Related projects

You might also be interested in these projects:

* [braces](https://www.npmjs.com/package/braces): Fastest brace expansion for node.js, with the most complete support for the Bash 4.3 braces… [more](https://www.npmjs.com/package/braces) | [homepage](https://github.com/jonschlinkert/braces)
* [expand-brackets](https://www.npmjs.com/package/expand-brackets): Expand POSIX bracket expressions (character classes) in glob patterns. | [homepage](https://github.com/jonschlinkert/expand-brackets)
* [is-extglob](https://www.npmjs.com/package/is-extglob): Returns true if a string has an extglob. | [homepage](https://github.com/jonschlinkert/is-extglob)
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern.… [more](https://www.npmjs.com/package/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob)
* [micromatch](https://www.npmjs.com/package/micromatch): Glob matching for javascript/node.js. A drop-in replacement and faster alternative to minimatch and multimatch. Just… [more](https://www.npmjs.com/package/micromatch) | [homepage](https://github.com/jonschlinkert/micromatch)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/is-posix-bracket/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/is-posix-bracket/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v, on April 05, 2016._