/***********************************************/
/**
* @file normalEquationFile.h
*
* @brief Read normals from file.
* @see NormalEquation
*
* @author Torsten Mayer-Guerr
* @date 2004-12-10
*
*/
/***********************************************/

#ifndef __GROOPS_NORMALEQUATIONFILE__
#define __GROOPS_NORMALEQUATIONFILE__

// Latex documentation
#ifdef DOCSTRING_NormalEquation
static const char *docstringNormalEquationFile = R"(
\subsection{File}\label{normalEquationType:file}
Reads a system of normal equations from file \configFile{inputfileNormalEquation}{normalEquation}
as generated by e.g. \program{NormalsBuild}.
)";
#endif

/***********************************************/

#include "classes/normalEquation/normalEquation.h"
#include "files/fileNormalEquation.h"

/***** CLASS ***********************************/

/** @brief Read normals from file.
* @ingroup normalEquationGroup
* @see NormalEquation */
class NormalEquationFile : public NormalEquationBase
{
  FileName           fileName;
  UInt               startIndex;
  UInt               paraCount, rhsCount, obsCount;
  std::vector<ParameterName> names;
  MatrixDistributed  normals;
  Matrix             n;
  Vector             lPl;
  Double             sigma2;

public:
  NormalEquationFile(Config &config);

  UInt   rightHandSideCount() const override {return lPl.size();}
  UInt   parameterCount()     const override {return paraCount + startIndex;}
  void   parameterNames(std::vector<ParameterName> &names) const override;
  void   init(MatrixDistributed &normals, UInt rhsCount) override;
  Bool   addNormalEquation(UInt rhsNo, const const_MatrixSlice &x, const const_MatrixSlice &Wz,
                           MatrixDistributed &normals, Matrix &n, Vector &lPl, UInt &obsCount) override;
  Vector contribution(MatrixDistributed &Cov) override;
  std::vector<Double> varianceComponentFactors() const override {return std::vector<Double>({sigma2});}
};

/***********************************************/

#endif
