#ifdef __KERNEL__
#ifndef _PPC64_MACHDEP_H
#define _PPC64_MACHDEP_H

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <linux/config.h>
#include <linux/seq_file.h>

struct pt_regs;
struct pci_bus;	
struct device_node;
struct TceTable;
struct rtc_time;

#ifdef CONFIG_SMP
struct smp_ops_t {
	void  (*message_pass)(int target, int msg, unsigned long data, int wait);
	int   (*probe)(void);
	void  (*kick_cpu)(int nr);
	void  (*setup_cpu)(int nr);
	void  (*take_timebase)(void);
	void  (*give_timebase)(void);
};
#endif

struct machdep_calls {
	void            (*hpte_invalidate)(unsigned long slot,
					   unsigned long va,
					   int large,
					   int local);
	long		(*hpte_updatepp)(unsigned long slot, 
					 unsigned long newpp, 
					 unsigned long va,
					 int large);
	void            (*hpte_updateboltedpp)(unsigned long newpp, 
					       unsigned long ea);
	long		(*insert_hpte)(unsigned long hpte_group,
				       unsigned long vpn,
				       unsigned long prpn,
				       int secondary, 
				       unsigned long hpteflags, 
				       int bolted,
				       int large);
	long		(*remove_hpte)(unsigned long hpte_group);
	void		(*flush_hash_range)(unsigned long context,
					    unsigned long number,
					    int local);
	void		(*make_pte)(void *htab, unsigned long va,
				    unsigned long pa,
				    int mode,
				    unsigned long hash_mask,
				    int large);

	void		(*tce_build)(struct TceTable * tbl,
				     long tcenum,
				     unsigned long uaddr,
				     int direction);
	void		(*tce_free_one)(struct TceTable *tbl,
				        long tcenum);    

	void		(*setup_arch)(void);
	/* Optional, may be NULL. */
	void		(*setup_residual)(struct seq_file *m, int cpu_id);
	/* Optional, may be NULL. */
	void		(*get_cpuinfo)(struct seq_file *m);

	void		(*init_IRQ)(void);
	void		(*init_ras_IRQ)(void);
	int		(*get_irq)(struct pt_regs *);

	/* Optional, may be NULL. */
	void		(*init)(void);

	void		(*restart)(char *cmd);
	void		(*power_off)(void);
	void		(*halt)(void);

	int		(*set_rtc_time)(struct rtc_time *);
	void		(*get_rtc_time)(struct rtc_time *);
	void		(*get_boot_time)(struct rtc_time *);

	void		(*calibrate_decr)(void);

	void		(*progress)(char *, unsigned short);

	/* Debug interface.  Low level I/O to some terminal device */
	void		(*udbg_putc)(unsigned char c);
	unsigned char	(*udbg_getc)(void);
	int		(*udbg_getc_poll)(void);

	/* PCI interfaces */
	int (*pcibios_read_config)(struct device_node *dn, int where, int size,
				   u32 *val);
	int (*pcibios_write_config)(struct device_node *dn, int where,
				    int size, u32 val);

	/* Called after scanning the bus, before allocating
	 * resources
	 */
	void (*pcibios_fixup)(void);

	/* Called for each PCI bus in the system
	 * when it's probed
	 */
	void (*pcibios_fixup_bus)(struct pci_bus *);

#ifdef CONFIG_SMP
	/* functions for dealing with other cpus */
	struct smp_ops_t smp_ops;
#endif /* CONFIG_SMP */
};

extern struct machdep_calls ppc_md;
extern char cmd_line[512];

#endif /* _PPC64_MACHDEP_H */
#endif /* __KERNEL__ */
