#!/usr/bin/python2.5
#
# Written by Philipp Kolmann <philipp@kolmann.at>
# $Id: skysentials.py 141 2007-11-22 17:42:53Z pkolmann $

import gtk
import gobject
import sys
import re
import string

#Skype4Py
import Skype4Py

# Local Classes
import ListSMS
import RegisterPhone
import SendSMS
import About
import TransferCall

REV="$Rev: 141 $"

__version__ = "1.0.1"

class MainWindow:

	def switch_page(self, notebook, page, page_num):
		pass

	def __init__(self):
		# Class Vars:
		self.smsid = 0
		self.sms = {}
		self.smstimeout = None
		self.friendswithmobile = {}
		self.friends = {}
		self.phones = {}

		#Skype objects
		skype = Skype4Py.Skype()
		skype.FriendlyName = 'SkySentials'

		# attach to Skype client
		skype.Attach()

		# Fetch all Friends with Mobile Numbers
		for friend in skype.Friends:
			# Get all friends with Mobiles
			phone = friend.PhoneMobile
			phone = SendSMS.SendSMS.clean_number(phone)
			if friend.DisplayName:
				self.friends[friend.DisplayName] = \
					friend.Handle

				x  = friend.DisplayName
				x += " ("
				x += phone
				x += ")"
				if (friend.PhoneMobile != ""):
					self.friendswithmobile[x] = \
						phone
					self.phones[phone] = \
						x
			elif friend.FullName:
				self.friends[friend.FullName] = \
					friend.Handle

				x  = friend.FullName
				x += " ("
				x += phone
				x += ")"
				if (friend.PhoneMobile != ""):
					self.friendswithmobile[x] = \
						phone
					self.phones[phone] = \
						x
			else:
				self.friends[friend.Handle] = \
					friend.Handle

				x  = friend.Handle
				x += " ("
				x += phone
				x += ")"
				if (friend.PhoneMobile != ""):
					self.friendswithmobile[x] =  \
						phone
					self.phones[phone] = \
						x

			if (friend.IsSkypeOutContact):
				x = friend.DisplayName + " ("
				x += friend.Handle
				x += ")"
				self.friendswithmobile[x] = \
					friend.Handle
				self.phones[friend.Handle] = \
					x

		# Classes
		self.SendSMS = SendSMS.SendSMS(skype, self.friendswithmobile)
		self.TransferCall = TransferCall.TransferCall(skype,
			self.friends)
		self.ListSMS = ListSMS.ListSMS(skype, self.phones)
		self.RegisterPhone = RegisterPhone.RegisterPhone(skype)
		self.About = About.About(__version__)

		# GTK Stuff:
		# http://www.pygtk.org/dist/pygtk2-tut.pdf
		window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		window.set_resizable(True)
		window.set_title("SkySentials for Linux Skype")
		window.connect("delete_event", lambda w,e: gtk.main_quit())

		window.set_geometry_hints(min_width=350, min_height=350)
		vbox = gtk.VBox(False, 0)
		nb = gtk.Notebook()
		nb.set_tab_pos(gtk.POS_TOP)

		label = gtk.Label('Send SMS')
		label.show()
		nb.append_page(self.SendSMS.window_send_sms(), label)
		label = gtk.Label('SMS List')
		label.show()
		nb.append_page(self.ListSMS.window_list_sms(), label)
		label = gtk.Label('Transfer Call')
		label.show()
		nb.append_page(self.TransferCall.window_show(), label)
		label = gtk.Label('Register Phone')
		label.show()
		nb.append_page(self.RegisterPhone.window_register_phone(), label)
		label = gtk.Label('About')
		label.show()
		nb.append_page(self.About.window_about(), label)

		nb.connect('switch-page', self.switch_page)

		nb.show()
		vbox.pack_start(nb, True, True, 0)

		button = gtk.Button("Quit")
		button.connect("clicked", lambda w: gtk.main_quit())
		vbox.pack_start(button, False, False, 10)
		button.show()

		window.add(vbox)
		vbox.show()

		window.show()
		self.ListSMS.start()

def main():
	MainWindow()
	# init Threading (getting Skype4Py Threads work with GTK)
	gtk.gdk.threads_init()
	gtk.main()
	return 0	

if __name__ == "__main__":
	main()
