// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package swf provides a client for Amazon Simple Workflow Service.
package swf

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCountClosedWorkflowExecutions = "CountClosedWorkflowExecutions"

// CountClosedWorkflowExecutionsRequest generates a request for the CountClosedWorkflowExecutions operation.
func (c *SWF) CountClosedWorkflowExecutionsRequest(input *CountClosedWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionCount) {
	op := &request.Operation{
		Name:       opCountClosedWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountClosedWorkflowExecutionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &WorkflowExecutionCount{}
	req.Data = output
	return
}

// Returns the number of closed workflow executions within the given domain
// that meet the specified filtering criteria.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  tagFilter.tag: String constraint. The key is
// swf:tagFilter.tag. typeFilter.name: String constraint. The key is swf:typeFilter.name.
// typeFilter.version: String constraint. The key is swf:typeFilter.version.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) CountClosedWorkflowExecutions(input *CountClosedWorkflowExecutionsInput) (*WorkflowExecutionCount, error) {
	req, out := c.CountClosedWorkflowExecutionsRequest(input)
	err := req.Send()
	return out, err
}

const opCountOpenWorkflowExecutions = "CountOpenWorkflowExecutions"

// CountOpenWorkflowExecutionsRequest generates a request for the CountOpenWorkflowExecutions operation.
func (c *SWF) CountOpenWorkflowExecutionsRequest(input *CountOpenWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionCount) {
	op := &request.Operation{
		Name:       opCountOpenWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountOpenWorkflowExecutionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &WorkflowExecutionCount{}
	req.Data = output
	return
}

// Returns the number of open workflow executions within the given domain that
// meet the specified filtering criteria.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  tagFilter.tag: String constraint. The key is
// swf:tagFilter.tag. typeFilter.name: String constraint. The key is swf:typeFilter.name.
// typeFilter.version: String constraint. The key is swf:typeFilter.version.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) CountOpenWorkflowExecutions(input *CountOpenWorkflowExecutionsInput) (*WorkflowExecutionCount, error) {
	req, out := c.CountOpenWorkflowExecutionsRequest(input)
	err := req.Send()
	return out, err
}

const opCountPendingActivityTasks = "CountPendingActivityTasks"

// CountPendingActivityTasksRequest generates a request for the CountPendingActivityTasks operation.
func (c *SWF) CountPendingActivityTasksRequest(input *CountPendingActivityTasksInput) (req *request.Request, output *PendingTaskCount) {
	op := &request.Operation{
		Name:       opCountPendingActivityTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingActivityTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PendingTaskCount{}
	req.Data = output
	return
}

// Returns the estimated number of activity tasks in the specified task list.
// The count returned is an approximation and is not guaranteed to be exact.
// If you specify a task list that no activity task was ever scheduled in then
// 0 will be returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the taskList.name parameter by using a Condition element
// with the swf:taskList.name key to allow the action to access only certain
// task lists.  If the caller does not have sufficient permissions to invoke
// the action, or the parameter values fall outside the specified constraints,
// the action fails. The associated event attribute's cause parameter will be
// set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) CountPendingActivityTasks(input *CountPendingActivityTasksInput) (*PendingTaskCount, error) {
	req, out := c.CountPendingActivityTasksRequest(input)
	err := req.Send()
	return out, err
}

const opCountPendingDecisionTasks = "CountPendingDecisionTasks"

// CountPendingDecisionTasksRequest generates a request for the CountPendingDecisionTasks operation.
func (c *SWF) CountPendingDecisionTasksRequest(input *CountPendingDecisionTasksInput) (req *request.Request, output *PendingTaskCount) {
	op := &request.Operation{
		Name:       opCountPendingDecisionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingDecisionTasksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PendingTaskCount{}
	req.Data = output
	return
}

// Returns the estimated number of decision tasks in the specified task list.
// The count returned is an approximation and is not guaranteed to be exact.
// If you specify a task list that no decision task was ever scheduled in then
// 0 will be returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the taskList.name parameter by using a Condition element
// with the swf:taskList.name key to allow the action to access only certain
// task lists.  If the caller does not have sufficient permissions to invoke
// the action, or the parameter values fall outside the specified constraints,
// the action fails. The associated event attribute's cause parameter will be
// set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) CountPendingDecisionTasks(input *CountPendingDecisionTasksInput) (*PendingTaskCount, error) {
	req, out := c.CountPendingDecisionTasksRequest(input)
	err := req.Send()
	return out, err
}

const opDeprecateActivityType = "DeprecateActivityType"

// DeprecateActivityTypeRequest generates a request for the DeprecateActivityType operation.
func (c *SWF) DeprecateActivityTypeRequest(input *DeprecateActivityTypeInput) (req *request.Request, output *DeprecateActivityTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateActivityTypeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeprecateActivityTypeOutput{}
	req.Data = output
	return
}

// Deprecates the specified activity type. After an activity type has been deprecated,
// you cannot create new tasks of that activity type. Tasks of this type that
// were scheduled before the type was deprecated will continue to run.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  activityType.name: String constraint. The key
// is swf:activityType.name. activityType.version: String constraint. The key
// is swf:activityType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DeprecateActivityType(input *DeprecateActivityTypeInput) (*DeprecateActivityTypeOutput, error) {
	req, out := c.DeprecateActivityTypeRequest(input)
	err := req.Send()
	return out, err
}

const opDeprecateDomain = "DeprecateDomain"

// DeprecateDomainRequest generates a request for the DeprecateDomain operation.
func (c *SWF) DeprecateDomainRequest(input *DeprecateDomainInput) (req *request.Request, output *DeprecateDomainOutput) {
	op := &request.Operation{
		Name:       opDeprecateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateDomainInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeprecateDomainOutput{}
	req.Data = output
	return
}

// Deprecates the specified domain. After a domain has been deprecated it cannot
// be used to create new workflow executions or register new types. However,
// you can still use visibility actions on this domain. Deprecating a domain
// also deprecates all activity and workflow types registered in the domain.
// Executions that were started before the domain was deprecated will continue
// to run.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DeprecateDomain(input *DeprecateDomainInput) (*DeprecateDomainOutput, error) {
	req, out := c.DeprecateDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDeprecateWorkflowType = "DeprecateWorkflowType"

// DeprecateWorkflowTypeRequest generates a request for the DeprecateWorkflowType operation.
func (c *SWF) DeprecateWorkflowTypeRequest(input *DeprecateWorkflowTypeInput) (req *request.Request, output *DeprecateWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateWorkflowTypeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeprecateWorkflowTypeOutput{}
	req.Data = output
	return
}

// Deprecates the specified workflow type. After a workflow type has been deprecated,
// you cannot create new executions of that type. Executions that were started
// before the type was deprecated will continue to run. A deprecated workflow
// type may still be used when calling visibility actions.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  workflowType.name: String constraint. The key
// is swf:workflowType.name. workflowType.version: String constraint. The key
// is swf:workflowType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DeprecateWorkflowType(input *DeprecateWorkflowTypeInput) (*DeprecateWorkflowTypeOutput, error) {
	req, out := c.DeprecateWorkflowTypeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeActivityType = "DescribeActivityType"

// DescribeActivityTypeRequest generates a request for the DescribeActivityType operation.
func (c *SWF) DescribeActivityTypeRequest(input *DescribeActivityTypeInput) (req *request.Request, output *DescribeActivityTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActivityTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeActivityTypeOutput{}
	req.Data = output
	return
}

// Returns information about the specified activity type. This includes configuration
// settings provided when the type was registered and other general information
// about the type.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  activityType.name: String constraint. The key
// is swf:activityType.name. activityType.version: String constraint. The key
// is swf:activityType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DescribeActivityType(input *DescribeActivityTypeInput) (*DescribeActivityTypeOutput, error) {
	req, out := c.DescribeActivityTypeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a request for the DescribeDomain operation.
func (c *SWF) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDomainOutput{}
	req.Data = output
	return
}

// Returns information about the specified domain, including description and
// status.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeWorkflowExecution = "DescribeWorkflowExecution"

// DescribeWorkflowExecutionRequest generates a request for the DescribeWorkflowExecution operation.
func (c *SWF) DescribeWorkflowExecutionRequest(input *DescribeWorkflowExecutionInput) (req *request.Request, output *DescribeWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeWorkflowExecutionOutput{}
	req.Data = output
	return
}

// Returns information about the specified workflow execution including its
// type and some statistics.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DescribeWorkflowExecution(input *DescribeWorkflowExecutionInput) (*DescribeWorkflowExecutionOutput, error) {
	req, out := c.DescribeWorkflowExecutionRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeWorkflowType = "DescribeWorkflowType"

// DescribeWorkflowTypeRequest generates a request for the DescribeWorkflowType operation.
func (c *SWF) DescribeWorkflowTypeRequest(input *DescribeWorkflowTypeInput) (req *request.Request, output *DescribeWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeWorkflowTypeOutput{}
	req.Data = output
	return
}

// Returns information about the specified workflow type. This includes configuration
// settings specified when the type was registered and other information such
// as creation date, current status, and so on.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  workflowType.name: String constraint. The key
// is swf:workflowType.name. workflowType.version: String constraint. The key
// is swf:workflowType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) DescribeWorkflowType(input *DescribeWorkflowTypeInput) (*DescribeWorkflowTypeOutput, error) {
	req, out := c.DescribeWorkflowTypeRequest(input)
	err := req.Send()
	return out, err
}

const opGetWorkflowExecutionHistory = "GetWorkflowExecutionHistory"

// GetWorkflowExecutionHistoryRequest generates a request for the GetWorkflowExecutionHistory operation.
func (c *SWF) GetWorkflowExecutionHistoryRequest(input *GetWorkflowExecutionHistoryInput) (req *request.Request, output *GetWorkflowExecutionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetWorkflowExecutionHistoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetWorkflowExecutionHistoryOutput{}
	req.Data = output
	return
}

// Returns the history of the specified workflow execution. The results may
// be split into multiple pages. To retrieve subsequent pages, make the call
// again using the nextPageToken returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) GetWorkflowExecutionHistory(input *GetWorkflowExecutionHistoryInput) (*GetWorkflowExecutionHistoryOutput, error) {
	req, out := c.GetWorkflowExecutionHistoryRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) GetWorkflowExecutionHistoryPages(input *GetWorkflowExecutionHistoryInput, fn func(p *GetWorkflowExecutionHistoryOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetWorkflowExecutionHistoryRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetWorkflowExecutionHistoryOutput), lastPage)
	})
}

const opListActivityTypes = "ListActivityTypes"

// ListActivityTypesRequest generates a request for the ListActivityTypes operation.
func (c *SWF) ListActivityTypesRequest(input *ListActivityTypesInput) (req *request.Request, output *ListActivityTypesOutput) {
	op := &request.Operation{
		Name:       opListActivityTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActivityTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListActivityTypesOutput{}
	req.Data = output
	return
}

// Returns information about all activities registered in the specified domain
// that match the specified name and registration status. The result includes
// information like creation date, current status of the activity, etc. The
// results may be split into multiple pages. To retrieve subsequent pages, make
// the call again using the nextPageToken returned by the initial call.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) ListActivityTypes(input *ListActivityTypesInput) (*ListActivityTypesOutput, error) {
	req, out := c.ListActivityTypesRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) ListActivityTypesPages(input *ListActivityTypesInput, fn func(p *ListActivityTypesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListActivityTypesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListActivityTypesOutput), lastPage)
	})
}

const opListClosedWorkflowExecutions = "ListClosedWorkflowExecutions"

// ListClosedWorkflowExecutionsRequest generates a request for the ListClosedWorkflowExecutions operation.
func (c *SWF) ListClosedWorkflowExecutionsRequest(input *ListClosedWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionInfos) {
	op := &request.Operation{
		Name:       opListClosedWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClosedWorkflowExecutionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &WorkflowExecutionInfos{}
	req.Data = output
	return
}

// Returns a list of closed workflow executions in the specified domain that
// meet the filtering criteria. The results may be split into multiple pages.
// To retrieve subsequent pages, make the call again using the nextPageToken
// returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  tagFilter.tag: String constraint. The key is
// swf:tagFilter.tag. typeFilter.name: String constraint. The key is swf:typeFilter.name.
// typeFilter.version: String constraint. The key is swf:typeFilter.version.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) ListClosedWorkflowExecutions(input *ListClosedWorkflowExecutionsInput) (*WorkflowExecutionInfos, error) {
	req, out := c.ListClosedWorkflowExecutionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) ListClosedWorkflowExecutionsPages(input *ListClosedWorkflowExecutionsInput, fn func(p *WorkflowExecutionInfos, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListClosedWorkflowExecutionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*WorkflowExecutionInfos), lastPage)
	})
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a request for the ListDomains operation.
func (c *SWF) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDomainsOutput{}
	req.Data = output
	return
}

// Returns the list of domains registered in the account. The results may be
// split into multiple pages. To retrieve subsequent pages, make the call again
// using the nextPageToken returned by the initial call.
//
//  This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. The element must be set to arn:aws:swf::AccountID:domain/*,
// where AccountID is the account ID, with no dashes. Use an Action element
// to allow or deny permission to call this action. You cannot use an IAM policy
// to constrain this action's parameters.  If the caller does not have sufficient
// permissions to invoke the action, or the parameter values fall outside the
// specified constraints, the action fails. The associated event attribute's
// cause parameter will be set to OPERATION_NOT_PERMITTED. For details and example
// IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) ListDomainsPages(input *ListDomainsInput, fn func(p *ListDomainsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDomainsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDomainsOutput), lastPage)
	})
}

const opListOpenWorkflowExecutions = "ListOpenWorkflowExecutions"

// ListOpenWorkflowExecutionsRequest generates a request for the ListOpenWorkflowExecutions operation.
func (c *SWF) ListOpenWorkflowExecutionsRequest(input *ListOpenWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionInfos) {
	op := &request.Operation{
		Name:       opListOpenWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOpenWorkflowExecutionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &WorkflowExecutionInfos{}
	req.Data = output
	return
}

// Returns a list of open workflow executions in the specified domain that meet
// the filtering criteria. The results may be split into multiple pages. To
// retrieve subsequent pages, make the call again using the nextPageToken returned
// by the initial call.
//
//  This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  tagFilter.tag: String constraint. The key is
// swf:tagFilter.tag. typeFilter.name: String constraint. The key is swf:typeFilter.name.
// typeFilter.version: String constraint. The key is swf:typeFilter.version.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) ListOpenWorkflowExecutions(input *ListOpenWorkflowExecutionsInput) (*WorkflowExecutionInfos, error) {
	req, out := c.ListOpenWorkflowExecutionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) ListOpenWorkflowExecutionsPages(input *ListOpenWorkflowExecutionsInput, fn func(p *WorkflowExecutionInfos, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListOpenWorkflowExecutionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*WorkflowExecutionInfos), lastPage)
	})
}

const opListWorkflowTypes = "ListWorkflowTypes"

// ListWorkflowTypesRequest generates a request for the ListWorkflowTypes operation.
func (c *SWF) ListWorkflowTypesRequest(input *ListWorkflowTypesInput) (req *request.Request, output *ListWorkflowTypesOutput) {
	op := &request.Operation{
		Name:       opListWorkflowTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListWorkflowTypesOutput{}
	req.Data = output
	return
}

// Returns information about workflow types in the specified domain. The results
// may be split into multiple pages that can be retrieved by making the call
// repeatedly.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) ListWorkflowTypes(input *ListWorkflowTypesInput) (*ListWorkflowTypesOutput, error) {
	req, out := c.ListWorkflowTypesRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) ListWorkflowTypesPages(input *ListWorkflowTypesInput, fn func(p *ListWorkflowTypesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListWorkflowTypesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListWorkflowTypesOutput), lastPage)
	})
}

const opPollForActivityTask = "PollForActivityTask"

// PollForActivityTaskRequest generates a request for the PollForActivityTask operation.
func (c *SWF) PollForActivityTaskRequest(input *PollForActivityTaskInput) (req *request.Request, output *PollForActivityTaskOutput) {
	op := &request.Operation{
		Name:       opPollForActivityTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForActivityTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PollForActivityTaskOutput{}
	req.Data = output
	return
}

// Used by workers to get an ActivityTask from the specified activity taskList.
// This initiates a long poll, where the service holds the HTTP connection open
// and responds as soon as a task becomes available. The maximum time the service
// holds on to the request before responding is 60 seconds. If no task is available
// within 60 seconds, the poll will return an empty result. An empty result,
// in this context, means that an ActivityTask is returned, but that the value
// of taskToken is an empty string. If a task is returned, the worker should
// use its type to identify and process it correctly.
//
// Workers should set their client side socket timeout to at least 70 seconds
// (10 seconds higher than the maximum time service may hold the poll request).
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the taskList.name parameter by using a Condition element
// with the swf:taskList.name key to allow the action to access only certain
// task lists.  If the caller does not have sufficient permissions to invoke
// the action, or the parameter values fall outside the specified constraints,
// the action fails. The associated event attribute's cause parameter will be
// set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) PollForActivityTask(input *PollForActivityTaskInput) (*PollForActivityTaskOutput, error) {
	req, out := c.PollForActivityTaskRequest(input)
	err := req.Send()
	return out, err
}

const opPollForDecisionTask = "PollForDecisionTask"

// PollForDecisionTaskRequest generates a request for the PollForDecisionTask operation.
func (c *SWF) PollForDecisionTaskRequest(input *PollForDecisionTaskInput) (req *request.Request, output *PollForDecisionTaskOutput) {
	op := &request.Operation{
		Name:       opPollForDecisionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &PollForDecisionTaskInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PollForDecisionTaskOutput{}
	req.Data = output
	return
}

// Used by deciders to get a DecisionTask from the specified decision taskList.
// A decision task may be returned for any open workflow execution that is using
// the specified task list. The task includes a paginated view of the history
// of the workflow execution. The decider should use the workflow type and the
// history to determine how to properly handle the task.
//
// This action initiates a long poll, where the service holds the HTTP connection
// open and responds as soon a task becomes available. If no decision task is
// available in the specified task list before the timeout of 60 seconds expires,
// an empty result is returned. An empty result, in this context, means that
// a DecisionTask is returned, but that the value of taskToken is an empty string.
//
// Deciders should set their client-side socket timeout to at least 70 seconds
// (10 seconds higher than the timeout). Because the number of workflow history
// events for a single workflow execution might be very large, the result returned
// might be split up across a number of pages. To retrieve subsequent pages,
// make additional calls to PollForDecisionTask using the nextPageToken returned
// by the initial call. Note that you do not call GetWorkflowExecutionHistory
// with this nextPageToken. Instead, call PollForDecisionTask again. Access
// Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the taskList.name parameter by using a Condition element
// with the swf:taskList.name key to allow the action to access only certain
// task lists.  If the caller does not have sufficient permissions to invoke
// the action, or the parameter values fall outside the specified constraints,
// the action fails. The associated event attribute's cause parameter will be
// set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) PollForDecisionTask(input *PollForDecisionTaskInput) (*PollForDecisionTaskOutput, error) {
	req, out := c.PollForDecisionTaskRequest(input)
	err := req.Send()
	return out, err
}

func (c *SWF) PollForDecisionTaskPages(input *PollForDecisionTaskInput, fn func(p *PollForDecisionTaskOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.PollForDecisionTaskRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*PollForDecisionTaskOutput), lastPage)
	})
}

const opRecordActivityTaskHeartbeat = "RecordActivityTaskHeartbeat"

// RecordActivityTaskHeartbeatRequest generates a request for the RecordActivityTaskHeartbeat operation.
func (c *SWF) RecordActivityTaskHeartbeatRequest(input *RecordActivityTaskHeartbeatInput) (req *request.Request, output *RecordActivityTaskHeartbeatOutput) {
	op := &request.Operation{
		Name:       opRecordActivityTaskHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordActivityTaskHeartbeatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RecordActivityTaskHeartbeatOutput{}
	req.Data = output
	return
}

// Used by activity workers to report to the service that the ActivityTask represented
// by the specified taskToken is still making progress. The worker can also
// (optionally) specify details of the progress, for example percent complete,
// using the details parameter. This action can also be used by the worker as
// a mechanism to check if cancellation is being requested for the activity
// task. If a cancellation is being attempted for the specified task, then the
// boolean cancelRequested flag returned by the service is set to true.
//
// This action resets the taskHeartbeatTimeout clock. The taskHeartbeatTimeout
// is specified in RegisterActivityType.
//
// This action does not in itself create an event in the workflow execution
// history. However, if the task times out, the workflow execution history will
// contain a ActivityTaskTimedOut event that contains the information from the
// last heartbeat generated by the activity worker.
//
// The taskStartToCloseTimeout of an activity type is the maximum duration
// of an activity task, regardless of the number of RecordActivityTaskHeartbeat
// requests received. The taskStartToCloseTimeout is also specified in RegisterActivityType.
// This operation is only useful for long-lived activities to report liveliness
// of the task and to determine if a cancellation is being attempted.  If the
// cancelRequested flag returns true, a cancellation is being attempted. If
// the worker can cancel the activity, it should respond with RespondActivityTaskCanceled.
// Otherwise, it should ignore the cancellation request. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RecordActivityTaskHeartbeat(input *RecordActivityTaskHeartbeatInput) (*RecordActivityTaskHeartbeatOutput, error) {
	req, out := c.RecordActivityTaskHeartbeatRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterActivityType = "RegisterActivityType"

// RegisterActivityTypeRequest generates a request for the RegisterActivityType operation.
func (c *SWF) RegisterActivityTypeRequest(input *RegisterActivityTypeInput) (req *request.Request, output *RegisterActivityTypeOutput) {
	op := &request.Operation{
		Name:       opRegisterActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterActivityTypeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RegisterActivityTypeOutput{}
	req.Data = output
	return
}

// Registers a new activity type along with its configuration settings in the
// specified domain.
//
// A TypeAlreadyExists fault is returned if the type already exists in the
// domain. You cannot change any configuration settings of the type after its
// registration, and it must be registered as a new version. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.   defaultTaskList.name: String constraint. The
// key is swf:defaultTaskList.name.  name: String constraint. The key is swf:name.
//  version: String constraint. The key is swf:version.    If the caller does
// not have sufficient permissions to invoke the action, or the parameter values
// fall outside the specified constraints, the action fails. The associated
// event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RegisterActivityType(input *RegisterActivityTypeInput) (*RegisterActivityTypeOutput, error) {
	req, out := c.RegisterActivityTypeRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterDomain = "RegisterDomain"

// RegisterDomainRequest generates a request for the RegisterDomain operation.
func (c *SWF) RegisterDomainRequest(input *RegisterDomainInput) (req *request.Request, output *RegisterDomainOutput) {
	op := &request.Operation{
		Name:       opRegisterDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDomainInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RegisterDomainOutput{}
	req.Data = output
	return
}

// Registers a new domain.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  You cannot use an IAM policy to control domain access for this action.
// The name of the domain being registered is available as the resource of this
// action. Use an Action element to allow or deny permission to call this action.
// You cannot use an IAM policy to constrain this action's parameters.  If the
// caller does not have sufficient permissions to invoke the action, or the
// parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RegisterDomain(input *RegisterDomainInput) (*RegisterDomainOutput, error) {
	req, out := c.RegisterDomainRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterWorkflowType = "RegisterWorkflowType"

// RegisterWorkflowTypeRequest generates a request for the RegisterWorkflowType operation.
func (c *SWF) RegisterWorkflowTypeRequest(input *RegisterWorkflowTypeInput) (req *request.Request, output *RegisterWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opRegisterWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWorkflowTypeInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RegisterWorkflowTypeOutput{}
	req.Data = output
	return
}

// Registers a new workflow type and its configuration settings in the specified
// domain.
//
// The retention period for the workflow history is set by the RegisterDomain
// action.
//
// If the type already exists, then a TypeAlreadyExists fault is returned.
// You cannot change the configuration settings of a workflow type once it is
// registered and it must be registered as a new version. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.   defaultTaskList.name: String constraint. The
// key is swf:defaultTaskList.name.  name: String constraint. The key is swf:name.
//  version: String constraint. The key is swf:version.    If the caller does
// not have sufficient permissions to invoke the action, or the parameter values
// fall outside the specified constraints, the action fails. The associated
// event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RegisterWorkflowType(input *RegisterWorkflowTypeInput) (*RegisterWorkflowTypeOutput, error) {
	req, out := c.RegisterWorkflowTypeRequest(input)
	err := req.Send()
	return out, err
}

const opRequestCancelWorkflowExecution = "RequestCancelWorkflowExecution"

// RequestCancelWorkflowExecutionRequest generates a request for the RequestCancelWorkflowExecution operation.
func (c *SWF) RequestCancelWorkflowExecutionRequest(input *RequestCancelWorkflowExecutionInput) (req *request.Request, output *RequestCancelWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opRequestCancelWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCancelWorkflowExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RequestCancelWorkflowExecutionOutput{}
	req.Data = output
	return
}

// Records a WorkflowExecutionCancelRequested event in the currently running
// workflow execution identified by the given domain, workflowId, and runId.
// This logically requests the cancellation of the workflow execution as a whole.
// It is up to the decider to take appropriate actions when it receives an execution
// history with this event.
//
// If the runId is not specified, the WorkflowExecutionCancelRequested event
// is recorded in the history of the current open workflow execution with the
// specified workflowId in the domain. Because this action allows the workflow
// to properly clean up and gracefully close, it should be used instead of TerminateWorkflowExecution
// when possible. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RequestCancelWorkflowExecution(input *RequestCancelWorkflowExecutionInput) (*RequestCancelWorkflowExecutionOutput, error) {
	req, out := c.RequestCancelWorkflowExecutionRequest(input)
	err := req.Send()
	return out, err
}

const opRespondActivityTaskCanceled = "RespondActivityTaskCanceled"

// RespondActivityTaskCanceledRequest generates a request for the RespondActivityTaskCanceled operation.
func (c *SWF) RespondActivityTaskCanceledRequest(input *RespondActivityTaskCanceledInput) (req *request.Request, output *RespondActivityTaskCanceledOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskCanceled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskCanceledInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RespondActivityTaskCanceledOutput{}
	req.Data = output
	return
}

// Used by workers to tell the service that the ActivityTask identified by the
// taskToken was successfully canceled. Additional details can be optionally
// provided using the details argument.
//
// These details (if provided) appear in the ActivityTaskCanceled event added
// to the workflow history.
//
// Only use this operation if the canceled flag of a RecordActivityTaskHeartbeat
// request returns true and if the activity can be safely undone or abandoned.
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RespondActivityTaskCanceled(input *RespondActivityTaskCanceledInput) (*RespondActivityTaskCanceledOutput, error) {
	req, out := c.RespondActivityTaskCanceledRequest(input)
	err := req.Send()
	return out, err
}

const opRespondActivityTaskCompleted = "RespondActivityTaskCompleted"

// RespondActivityTaskCompletedRequest generates a request for the RespondActivityTaskCompleted operation.
func (c *SWF) RespondActivityTaskCompletedRequest(input *RespondActivityTaskCompletedInput) (req *request.Request, output *RespondActivityTaskCompletedOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskCompleted,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskCompletedInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RespondActivityTaskCompletedOutput{}
	req.Data = output
	return
}

// Used by workers to tell the service that the ActivityTask identified by the
// taskToken completed successfully with a result (if provided). The result
// appears in the ActivityTaskCompleted event in the workflow history.
//
//  If the requested task does not complete successfully, use RespondActivityTaskFailed
// instead. If the worker finds that the task is canceled through the canceled
// flag returned by RecordActivityTaskHeartbeat, it should cancel the task,
// clean up and then call RespondActivityTaskCanceled. A task is considered
// open from the time that it is scheduled until it is closed. Therefore a task
// is reported as open while a worker is processing it. A task is closed after
// it has been specified in a call to RespondActivityTaskCompleted, RespondActivityTaskCanceled,
// RespondActivityTaskFailed, or the task has timed out (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RespondActivityTaskCompleted(input *RespondActivityTaskCompletedInput) (*RespondActivityTaskCompletedOutput, error) {
	req, out := c.RespondActivityTaskCompletedRequest(input)
	err := req.Send()
	return out, err
}

const opRespondActivityTaskFailed = "RespondActivityTaskFailed"

// RespondActivityTaskFailedRequest generates a request for the RespondActivityTaskFailed operation.
func (c *SWF) RespondActivityTaskFailedRequest(input *RespondActivityTaskFailedInput) (req *request.Request, output *RespondActivityTaskFailedOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskFailed,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskFailedInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RespondActivityTaskFailedOutput{}
	req.Data = output
	return
}

// Used by workers to tell the service that the ActivityTask identified by the
// taskToken has failed with reason (if specified). The reason and details appear
// in the ActivityTaskFailed event added to the workflow history.
//
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RespondActivityTaskFailed(input *RespondActivityTaskFailedInput) (*RespondActivityTaskFailedOutput, error) {
	req, out := c.RespondActivityTaskFailedRequest(input)
	err := req.Send()
	return out, err
}

const opRespondDecisionTaskCompleted = "RespondDecisionTaskCompleted"

// RespondDecisionTaskCompletedRequest generates a request for the RespondDecisionTaskCompleted operation.
func (c *SWF) RespondDecisionTaskCompletedRequest(input *RespondDecisionTaskCompletedInput) (req *request.Request, output *RespondDecisionTaskCompletedOutput) {
	op := &request.Operation{
		Name:       opRespondDecisionTaskCompleted,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondDecisionTaskCompletedInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RespondDecisionTaskCompletedOutput{}
	req.Data = output
	return
}

// Used by deciders to tell the service that the DecisionTask identified by
// the taskToken has successfully completed. The decisions argument specifies
// the list of decisions made while processing the task.
//
// A DecisionTaskCompleted event is added to the workflow history. The executionContext
// specified is attached to the event in the workflow execution history.
//
// Access Control
//
// If an IAM policy grants permission to use RespondDecisionTaskCompleted,
// it can express permissions for the list of decisions in the decisions parameter.
// Each of the decisions has one or more parameters, much like a regular API
// call. To allow for policies to be as readable as possible, you can express
// permissions on decisions as if they were actual API calls, including applying
// conditions to some parameters. For more information, see Using IAM to Manage
// Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) RespondDecisionTaskCompleted(input *RespondDecisionTaskCompletedInput) (*RespondDecisionTaskCompletedOutput, error) {
	req, out := c.RespondDecisionTaskCompletedRequest(input)
	err := req.Send()
	return out, err
}

const opSignalWorkflowExecution = "SignalWorkflowExecution"

// SignalWorkflowExecutionRequest generates a request for the SignalWorkflowExecution operation.
func (c *SWF) SignalWorkflowExecutionRequest(input *SignalWorkflowExecutionInput) (req *request.Request, output *SignalWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opSignalWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalWorkflowExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SignalWorkflowExecutionOutput{}
	req.Data = output
	return
}

// Records a WorkflowExecutionSignaled event in the workflow execution history
// and creates a decision task for the workflow execution identified by the
// given domain, workflowId and runId. The event is recorded with the specified
// user defined signalName and input (if provided).
//
//  If a runId is not specified, then the WorkflowExecutionSignaled event is
// recorded in the history of the current open workflow with the matching workflowId
// in the domain.  If the specified workflow execution is not open, this method
// fails with UnknownResource. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) SignalWorkflowExecution(input *SignalWorkflowExecutionInput) (*SignalWorkflowExecutionOutput, error) {
	req, out := c.SignalWorkflowExecutionRequest(input)
	err := req.Send()
	return out, err
}

const opStartWorkflowExecution = "StartWorkflowExecution"

// StartWorkflowExecutionRequest generates a request for the StartWorkflowExecution operation.
func (c *SWF) StartWorkflowExecutionRequest(input *StartWorkflowExecutionInput) (req *request.Request, output *StartWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opStartWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkflowExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartWorkflowExecutionOutput{}
	req.Data = output
	return
}

// Starts an execution of the workflow type in the specified domain using the
// provided workflowId and input data.
//
// This action returns the newly started workflow execution.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.   tagList.member.0: The key is swf:tagList.member.0.
//  tagList.member.1: The key is swf:tagList.member.1.  tagList.member.2: The
// key is swf:tagList.member.2.  tagList.member.3: The key is swf:tagList.member.3.
//  tagList.member.4: The key is swf:tagList.member.4. taskList: String constraint.
// The key is swf:taskList.name. workflowType.name: String constraint. The key
// is swf:workflowType.name. workflowType.version: String constraint. The key
// is swf:workflowType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) StartWorkflowExecution(input *StartWorkflowExecutionInput) (*StartWorkflowExecutionOutput, error) {
	req, out := c.StartWorkflowExecutionRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateWorkflowExecution = "TerminateWorkflowExecution"

// TerminateWorkflowExecutionRequest generates a request for the TerminateWorkflowExecution operation.
func (c *SWF) TerminateWorkflowExecutionRequest(input *TerminateWorkflowExecutionInput) (req *request.Request, output *TerminateWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkflowExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &TerminateWorkflowExecutionOutput{}
	req.Data = output
	return
}

// Records a WorkflowExecutionTerminated event and forces closure of the workflow
// execution identified by the given domain, runId, and workflowId. The child
// policy, registered with the workflow type or specified when starting this
// execution, is applied to any open child workflow executions of this workflow
// execution.
//
//  If the identified workflow execution was in progress, it is terminated
// immediately.  If a runId is not specified, then the WorkflowExecutionTerminated
// event is recorded in the history of the current open workflow with the matching
// workflowId in the domain.  You should consider using RequestCancelWorkflowExecution
// action instead because it allows the workflow to gracefully close while TerminateWorkflowExecution
// does not. Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
func (c *SWF) TerminateWorkflowExecution(input *TerminateWorkflowExecutionInput) (*TerminateWorkflowExecutionOutput, error) {
	req, out := c.TerminateWorkflowExecutionRequest(input)
	err := req.Send()
	return out, err
}

// Provides details of the ActivityTaskCancelRequested event.
type ActivityTaskCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the task.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskCanceled event.
type ActivityTaskCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation (if any).
	Details *string `locationName:"details" type:"string"`

	// If set, contains the ID of the last ActivityTaskCancelRequested event recorded
	// for this activity task. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	LatestCancelRequestedEventId *int64 `locationName:"latestCancelRequestedEventId" type:"long"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCanceledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskCompleted event.
type ActivityTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The results of the activity task (if any).
	Result *string `locationName:"result" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCompletedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskFailed event.
type ActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure (if any).
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure (if any).
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskScheduled event.
type ActivityTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the activity task.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of the activity task.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data is not sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum time before which the worker processing this task must report
	// progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded,
	// the activity task is automatically timed out. If the worker subsequently
	// attempts to record a heartbeat or return a result, it will be ignored.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum amount of time for this activity task.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// The maximum amount of time the activity task can wait to be assigned to a
	// worker.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// The maximum amount of time a worker may take to process the activity task.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The task list in which the activity task has been scheduled.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// Optional. The priority to assign to the scheduled activity task. If set,
	// this will override any default priority value that was assigned when the
	// activity type was registered.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ActivityTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskScheduledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskStarted event.
type ActivityTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the worker that was assigned this task. This aids diagnostics
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskStartedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ActivityTaskTimedOut event.
type ActivityTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// Contains the content of the details parameter for the last call made by the
	// activity to RecordActivityTaskHeartbeat.
	Details *string `locationName:"details" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"ActivityTaskTimeoutType"`
}

// String returns the string representation
func (s ActivityTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskTimedOutEventAttributes) GoString() string {
	return s.String()
}

// Represents an activity type.
type ActivityType struct {
	_ struct{} `type:"structure"`

	// The name of this activity.
	//
	// The combination of activity type name and version must be unique within
	// a domain.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of this activity.
	//
	// The combination of activity type name and version must be unique with in
	// a domain.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityType) GoString() string {
	return s.String()
}

// Configuration settings registered with the activity type.
type ActivityTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// Optional. The default maximum time, in seconds, before which a worker processing
	// a task must report progress by calling RecordActivityTaskHeartbeat.
	//
	// You can specify this value only when registering an activity type. The registered
	// default value can be overridden when you schedule a task through the ScheduleActivityTask
	// decision. If the activity worker subsequently attempts to record a heartbeat
	// or returns a result, the activity worker receives an UnknownResource fault.
	// In this case, Amazon SWF no longer considers the activity task to be valid;
	// the activity worker should clean up the activity task.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string `locationName:"defaultTaskHeartbeatTimeout" type:"string"`

	// Optional. The default task list specified for this activity type at registration.
	// This default is used if a task list is not provided when a task is scheduled
	// through the ScheduleActivityTask decision. You can override the default registered
	// task list when scheduling a task through the ScheduleActivityTask decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// Optional. The default task priority for tasks of this activity type, specified
	// at registration. If not set, then "0" will be used as the default priority.
	// This default can be overridden when scheduling an activity task.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// Optional. The default maximum duration, specified when registering the activity
	// type, for tasks of this activity type. You can override this default when
	// scheduling a task through the ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string `locationName:"defaultTaskScheduleToCloseTimeout" type:"string"`

	// Optional. The default maximum duration, specified when registering the activity
	// type, that a task of an activity type can wait before being assigned to a
	// worker. You can override this default when scheduling a task through the
	// ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string `locationName:"defaultTaskScheduleToStartTimeout" type:"string"`

	// Optional. The default maximum duration for tasks of an activity type specified
	// when registering the activity type. You can override this default when scheduling
	// a task through the ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ActivityTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTypeConfiguration) GoString() string {
	return s.String()
}

// Detailed information about an activity type.
type ActivityTypeInfo struct {
	_ struct{} `type:"structure"`

	// The ActivityType type structure representing the activity type.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The date and time this activity type was created through RegisterActivityType.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// If DEPRECATED, the date and time DeprecateActivityType was called.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp" timestampFormat:"unix"`

	// The description of the activity type provided in RegisterActivityType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the activity type.
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`
}

// String returns the string representation
func (s ActivityTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTypeInfo) GoString() string {
	return s.String()
}

// Provides details of the CancelTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type CancelTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Required. The unique ID of the timer to cancel.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTimerDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the CancelTimerFailed event.
type CancelTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CancelTimerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the CancelTimer decision that failed.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTimerFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the CancelWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type CancelWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. details of the cancellation.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s CancelWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the CancelWorkflowExecutionFailed event.
type CancelWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CancelWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CancelWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provide details of the ChildWorkflowExecutionCanceled event.
type ChildWorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was canceled.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionCanceledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ChildWorkflowExecutionCompleted event.
type ChildWorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The result of the child workflow execution (if any).
	Result *string `locationName:"result" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was completed.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionCompletedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ChildWorkflowExecutionFailed event.
type ChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The reason for the failure (if provided).
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that failed.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ChildWorkflowExecutionStarted event.
type ChildWorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The child workflow execution that was started.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionStartedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ChildWorkflowExecutionTerminated event.
type ChildWorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was terminated.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionTerminatedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ChildWorkflowExecutionTimedOut event.
type ChildWorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused the child workflow execution to time
	// out.
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"WorkflowExecutionTimeoutType"`

	// The child workflow execution that timed out.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionTimedOutEventAttributes) GoString() string {
	return s.String()
}

// Used to filter the closed workflow executions in visibility APIs by their
// close status.
type CloseStatusFilter struct {
	_ struct{} `type:"structure"`

	// Required. The close status that must match the close status of an execution
	// for it to meet the criteria of this filter.
	Status *string `locationName:"status" type:"string" required:"true" enum:"CloseStatus"`
}

// String returns the string representation
func (s CloseStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseStatusFilter) GoString() string {
	return s.String()
}

// Provides details of the CompleteWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type CompleteWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The result of the workflow execution. The form of the result is implementation
	// defined.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the CompleteWorkflowExecutionFailed event.
type CompleteWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CompleteWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ContinueAsNewWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.   tag: Optional.. A tag used to identify the workflow
// execution taskList: String constraint. The key is swf:taskList.name. workflowType.version:
// String constraint. The key is swf:workflowType.version.    If the caller
// does not have sufficient permissions to invoke the action, or the parameter
// values fall outside the specified constraints, the action fails. The associated
// event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type ContinueAsNewWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// the new execution if it is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.  A child policy
	// for this workflow execution must be specified either as a default for the
	// workflow type or through this parameter. If neither this parameter is set
	// nor a default child policy was specified at registration time then a fault
	// will be returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// If set, specifies the total duration for this workflow execution. This overrides
	// the defaultExecutionStartToCloseTimeout specified when registering the workflow
	// type.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be
	// specified either as a default for the workflow type or through this field.
	// If neither this field is set nor a default execution start-to-close timeout
	// was specified at registration time then a fault will be returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
	//
	// In order for this workflow execution to invoke AWS Lambda functions, an
	// appropriate IAM role must be specified either as a default for the workflow
	// type or through this field.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the new workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// Represents a task list.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// Optional. The task priority that, if set, specifies the priority for the
	// decision tasks for this workflow execution. This overrides the defaultTaskPriority
	// specified when registering the workflow type. Valid values are integers that
	// range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for the new workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A task start-to-close timeout for the new workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault will be returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	WorkflowTypeVersion *string `locationName:"workflowTypeVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueAsNewWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the ContinueAsNewWorkflowExecutionFailed event.
type ContinueAsNewWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ContinueAsNewWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueAsNewWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

type CountClosedWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// If specified, only workflow executions that match this close status are counted.
	// This filter has an affect only if executionStatus is specified as CLOSED.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	CloseStatusFilter *CloseStatusFilter `locationName:"closeStatusFilter" type:"structure"`

	// If specified, only workflow executions that meet the close time criteria
	// of the filter are counted.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	CloseTimeFilter *ExecutionTimeFilter `locationName:"closeTimeFilter" type:"structure"`

	// The name of the domain containing the workflow executions to count.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the WorkflowId in the filter
	// are counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// If specified, only workflow executions that meet the start time criteria
	// of the filter are counted.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure"`

	// If specified, only executions that have a tag that matches the filter are
	// counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, indicates the type of the workflow executions to be counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s CountClosedWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountClosedWorkflowExecutionsInput) GoString() string {
	return s.String()
}

type CountOpenWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow executions to count.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the WorkflowId in the filter
	// are counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// Specifies the start time criteria that workflow executions must meet in order
	// to be counted.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure" required:"true"`

	// If specified, only executions that have a tag that matches the filter are
	// counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// Specifies the type of the workflow executions to be counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s CountOpenWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountOpenWorkflowExecutionsInput) GoString() string {
	return s.String()
}

type CountPendingActivityTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingActivityTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountPendingActivityTasksInput) GoString() string {
	return s.String()
}

type CountPendingDecisionTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingDecisionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountPendingDecisionTasksInput) GoString() string {
	return s.String()
}

// Specifies a decision made by the decider. A decision can be one of these
// types:
//
//   CancelTimer: cancels a previously started timer and records a TimerCanceled
// event in the history.  CancelWorkflowExecution: closes the workflow execution
// and records a WorkflowExecutionCanceled event in the history.  CompleteWorkflowExecution:
// closes the workflow execution and records a WorkflowExecutionCompleted event
// in the history .  ContinueAsNewWorkflowExecution: closes the workflow execution
// and starts a new workflow execution of the same type using the same workflow
// ID and a unique run ID. A WorkflowExecutionContinuedAsNew event is recorded
// in the history.  FailWorkflowExecution: closes the workflow execution and
// records a WorkflowExecutionFailed event in the history.  RecordMarker: records
// a MarkerRecorded event in the history. Markers can be used for adding custom
// information in the history for instance to let deciders know that they do
// not need to look at the history beyond the marker event.  RequestCancelActivityTask:
// attempts to cancel a previously scheduled activity task. If the activity
// task was scheduled but has not been assigned to a worker, then it will be
// canceled. If the activity task was already assigned to a worker, then the
// worker will be informed that cancellation has been requested in the response
// to RecordActivityTaskHeartbeat.  RequestCancelExternalWorkflowExecution:
// requests that a request be made to cancel the specified external workflow
// execution and records a RequestCancelExternalWorkflowExecutionInitiated event
// in the history.  ScheduleActivityTask: schedules an activity task.  ScheduleLambdaFunction:
// schedules a AWS Lambda function.  SignalExternalWorkflowExecution: requests
// a signal to be delivered to the specified external workflow execution and
// records a SignalExternalWorkflowExecutionInitiated event in the history.
//  StartChildWorkflowExecution: requests that a child workflow execution be
// started and records a StartChildWorkflowExecutionInitiated event in the history.
// The child workflow execution is a separate workflow execution with its own
// history.  StartTimer: starts a timer for this workflow execution and records
// a TimerStarted event in the history. This timer will fire after the specified
// delay and record a TimerFired event.  Access Control
//
// If you grant permission to use RespondDecisionTaskCompleted, you can use
// IAM policies to express permissions for the list of decisions returned by
// this action as if they were members of the API. Treating decisions as a pseudo
// API maintains a uniform conceptual model and helps keep policies readable.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
//
// Decision Failure
//
// Decisions can fail for several reasons
//
//  The ordering of decisions should follow a logical flow. Some decisions
// might not make sense in the current context of the workflow execution and
// will therefore fail. A limit on your account was reached. The decision lacks
// sufficient permissions.  One of the following events might be added to the
// history to indicate an error. The event attribute's cause parameter indicates
// the cause. If cause is set to OPERATION_NOT_PERMITTED, the decision failed
// because it lacked sufficient permissions. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
//
//   ScheduleActivityTaskFailed: a ScheduleActivityTask decision failed. This
// could happen if the activity type specified in the decision is not registered,
// is in a deprecated state, or the decision is not properly configured.  ScheduleLambdaFunctionFailed:
// a ScheduleLambdaFunctionFailed decision failed. This could happen if the
// AWS Lambda function specified in the decision does not exist, or the AWS
// Lambda service's limits are exceeded.  RequestCancelActivityTaskFailed: a
// RequestCancelActivityTask decision failed. This could happen if there is
// no open activity task with the specified activityId.  StartTimerFailed: a
// StartTimer decision failed. This could happen if there is another open timer
// with the same timerId.  CancelTimerFailed: a CancelTimer decision failed.
// This could happen if there is no open timer with the specified timerId.
// StartChildWorkflowExecutionFailed: a StartChildWorkflowExecution decision
// failed. This could happen if the workflow type specified is not registered,
// is deprecated, or the decision is not properly configured.  SignalExternalWorkflowExecutionFailed:
// a SignalExternalWorkflowExecution decision failed. This could happen if the
// workflowID specified in the decision was incorrect.  RequestCancelExternalWorkflowExecutionFailed:
// a RequestCancelExternalWorkflowExecution decision failed. This could happen
// if the workflowID specified in the decision was incorrect.  CancelWorkflowExecutionFailed:
// a CancelWorkflowExecution decision failed. This could happen if there is
// an unhandled decision task pending in the workflow execution.  CompleteWorkflowExecutionFailed:
// a CompleteWorkflowExecution decision failed. This could happen if there is
// an unhandled decision task pending in the workflow execution.  ContinueAsNewWorkflowExecutionFailed:
// a ContinueAsNewWorkflowExecution decision failed. This could happen if there
// is an unhandled decision task pending in the workflow execution or the ContinueAsNewWorkflowExecution
// decision was not configured correctly.  FailWorkflowExecutionFailed: a FailWorkflowExecution
// decision failed. This could happen if there is an unhandled decision task
// pending in the workflow execution.  The preceding error events might occur
// due to an error in the decider logic, which might put the workflow execution
// in an unstable state The cause field in the event structure for the error
// event indicates the cause of the error.
//
// A workflow execution may be closed by the decider by returning one of the
// following decisions when completing a decision task: CompleteWorkflowExecution,
// FailWorkflowExecution, CancelWorkflowExecution and ContinueAsNewWorkflowExecution.
// An UnhandledDecision fault will be returned if a workflow closing decision
// is specified and a signal or activity event had been added to the history
// while the decision task was being performed by the decider. Unlike the above
// situations which are logic issues, this fault is always possible because
// of race conditions in a distributed system. The right action here is to call
// RespondDecisionTaskCompleted without any decisions. This would result in
// another decision task with these new events included in the history. The
// decider should handle the new events and may decide to close the workflow
// execution. How to code a decision
//
// You code a decision by first setting the decision type field to one of the
// above decision values, and then set the corresponding attributes field shown
// below:
//
//   ScheduleActivityTaskDecisionAttributes   ScheduleLambdaFunctionDecisionAttributes
//   RequestCancelActivityTaskDecisionAttributes   CompleteWorkflowExecutionDecisionAttributes
//   FailWorkflowExecutionDecisionAttributes   CancelWorkflowExecutionDecisionAttributes
//   ContinueAsNewWorkflowExecutionDecisionAttributes   RecordMarkerDecisionAttributes
//   StartTimerDecisionAttributes   CancelTimerDecisionAttributes   SignalExternalWorkflowExecutionDecisionAttributes
//   RequestCancelExternalWorkflowExecutionDecisionAttributes   StartChildWorkflowExecutionDecisionAttributes
type Decision struct {
	_ struct{} `type:"structure"`

	// Provides details of the CancelTimer decision. It is not set for other decision
	// types.
	CancelTimerDecisionAttributes *CancelTimerDecisionAttributes `locationName:"cancelTimerDecisionAttributes" type:"structure"`

	// Provides details of the CancelWorkflowExecution decision. It is not set for
	// other decision types.
	CancelWorkflowExecutionDecisionAttributes *CancelWorkflowExecutionDecisionAttributes `locationName:"cancelWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the CompleteWorkflowExecution decision. It is not set
	// for other decision types.
	CompleteWorkflowExecutionDecisionAttributes *CompleteWorkflowExecutionDecisionAttributes `locationName:"completeWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the ContinueAsNewWorkflowExecution decision. It is not
	// set for other decision types.
	ContinueAsNewWorkflowExecutionDecisionAttributes *ContinueAsNewWorkflowExecutionDecisionAttributes `locationName:"continueAsNewWorkflowExecutionDecisionAttributes" type:"structure"`

	// Specifies the type of the decision.
	DecisionType *string `locationName:"decisionType" type:"string" required:"true" enum:"DecisionType"`

	// Provides details of the FailWorkflowExecution decision. It is not set for
	// other decision types.
	FailWorkflowExecutionDecisionAttributes *FailWorkflowExecutionDecisionAttributes `locationName:"failWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the RecordMarker decision. It is not set for other decision
	// types.
	RecordMarkerDecisionAttributes *RecordMarkerDecisionAttributes `locationName:"recordMarkerDecisionAttributes" type:"structure"`

	// Provides details of the RequestCancelActivityTask decision. It is not set
	// for other decision types.
	RequestCancelActivityTaskDecisionAttributes *RequestCancelActivityTaskDecisionAttributes `locationName:"requestCancelActivityTaskDecisionAttributes" type:"structure"`

	// Provides details of the RequestCancelExternalWorkflowExecution decision.
	// It is not set for other decision types.
	RequestCancelExternalWorkflowExecutionDecisionAttributes *RequestCancelExternalWorkflowExecutionDecisionAttributes `locationName:"requestCancelExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the ScheduleActivityTask decision. It is not set for
	// other decision types.
	ScheduleActivityTaskDecisionAttributes *ScheduleActivityTaskDecisionAttributes `locationName:"scheduleActivityTaskDecisionAttributes" type:"structure"`

	// Provides details of the ScheduleLambdaFunction decision.
	//
	// Access Control
	//
	// You can use IAM policies to control this decision's access to Amazon SWF
	// resources as follows:
	//
	//  Use a Resource element with the domain name to limit the action to only
	// specified domains. Use an Action element to allow or deny permission to call
	// this action. Constrain the following parameters by using a Condition element
	// with the appropriate keys.  activityType.name: String constraint. The key
	// is swf:activityType.name. activityType.version: String constraint. The key
	// is swf:activityType.version. taskList: String constraint. The key is swf:taskList.name.
	//    If the caller does not have sufficient permissions to invoke the action,
	// or the parameter values fall outside the specified constraints, the action
	// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
	// For details and example IAM policies, see Using IAM to Manage Access to Amazon
	// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	ScheduleLambdaFunctionDecisionAttributes *ScheduleLambdaFunctionDecisionAttributes `locationName:"scheduleLambdaFunctionDecisionAttributes" type:"structure"`

	// Provides details of the SignalExternalWorkflowExecution decision. It is not
	// set for other decision types.
	SignalExternalWorkflowExecutionDecisionAttributes *SignalExternalWorkflowExecutionDecisionAttributes `locationName:"signalExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the StartChildWorkflowExecution decision. It is not set
	// for other decision types.
	StartChildWorkflowExecutionDecisionAttributes *StartChildWorkflowExecutionDecisionAttributes `locationName:"startChildWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides details of the StartTimer decision. It is not set for other decision
	// types.
	StartTimerDecisionAttributes *StartTimerDecisionAttributes `locationName:"startTimerDecisionAttributes" type:"structure"`
}

// String returns the string representation
func (s Decision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Decision) GoString() string {
	return s.String()
}

// Provides details of the DecisionTaskCompleted event.
type DecisionTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// User defined context for the workflow execution.
	ExecutionContext *string `locationName:"executionContext" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskCompletedEventAttributes) GoString() string {
	return s.String()
}

// Provides details about the DecisionTaskScheduled event.
type DecisionTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The maximum duration for this decision task. The task is considered timed
	// out if it does not completed within this duration.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The name of the task list in which the decision task was scheduled.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// Optional. A task priority that, if set, specifies the priority for this decision
	// task. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s DecisionTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskScheduledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the DecisionTaskStarted event.
type DecisionTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the decider making the request. This enables diagnostic tracing
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskStartedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the DecisionTaskTimedOut event.
type DecisionTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of timeout that expired before the decision task could be completed.
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"DecisionTaskTimeoutType"`
}

// String returns the string representation
func (s DecisionTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskTimedOutEventAttributes) GoString() string {
	return s.String()
}

type DeprecateActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// The activity type to deprecate.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The name of the domain in which the activity type is registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateActivityTypeInput) GoString() string {
	return s.String()
}

type DeprecateActivityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateActivityTypeOutput) GoString() string {
	return s.String()
}

type DeprecateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to deprecate.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateDomainInput) GoString() string {
	return s.String()
}

type DeprecateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateDomainOutput) GoString() string {
	return s.String()
}

type DeprecateWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the workflow type is registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow type to deprecate.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeprecateWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateWorkflowTypeInput) GoString() string {
	return s.String()
}

type DeprecateWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateWorkflowTypeOutput) GoString() string {
	return s.String()
}

type DescribeActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// The activity type to get information about. Activity types are identified
	// by the name and version that were supplied when the activity was registered.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The name of the domain in which the activity type is registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityTypeInput) GoString() string {
	return s.String()
}

// Detailed information about an activity type.
type DescribeActivityTypeOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings registered with the activity type.
	Configuration *ActivityTypeConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// General information about the activity type.
	//
	// The status of activity type (returned in the ActivityTypeInfo structure)
	// can be one of the following.
	//
	//   REGISTERED: The type is registered and available. Workers supporting this
	// type should be running.   DEPRECATED: The type was deprecated using DeprecateActivityType,
	// but is still in use. You should keep workers supporting this type running.
	// You cannot create new tasks of this type.
	TypeInfo *ActivityTypeInfo `locationName:"typeInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityTypeOutput) GoString() string {
	return s.String()
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to describe.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Contains details of a domain.
type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration settings of a domain.
	Configuration *DomainConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// Contains general information about a domain.
	DomainInfo *DomainInfo `locationName:"domainInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

type DescribeWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow execution to describe.
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Contains details about a workflow execution.
type DescribeWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for this workflow execution including timeout
	// values, tasklist etc.
	ExecutionConfiguration *WorkflowExecutionConfiguration `locationName:"executionConfiguration" type:"structure" required:"true"`

	// Information about the workflow execution.
	ExecutionInfo *WorkflowExecutionInfo `locationName:"executionInfo" type:"structure" required:"true"`

	// The time when the last activity task was scheduled for this workflow execution.
	// You can use this information to determine if the workflow has not made progress
	// for an unusually long period of time and might require a corrective action.
	LatestActivityTaskTimestamp *time.Time `locationName:"latestActivityTaskTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The latest executionContext provided by the decider for this workflow execution.
	// A decider can provide an executionContext (a free-form string) when closing
	// a decision task using RespondDecisionTaskCompleted.
	LatestExecutionContext *string `locationName:"latestExecutionContext" type:"string"`

	// The number of tasks for this workflow execution. This includes open and closed
	// tasks of all types.
	OpenCounts *WorkflowExecutionOpenCounts `locationName:"openCounts" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowExecutionOutput) GoString() string {
	return s.String()
}

type DescribeWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which this workflow type is registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow type to describe.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowTypeInput) GoString() string {
	return s.String()
}

// Contains details about a workflow type.
type DescribeWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`

	// Configuration settings of the workflow type registered through RegisterWorkflowType
	Configuration *WorkflowTypeConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// General information about the workflow type.
	//
	// The status of the workflow type (returned in the WorkflowTypeInfo structure)
	// can be one of the following.
	//
	//   REGISTERED: The type is registered and available. Workers supporting this
	// type should be running.  DEPRECATED: The type was deprecated using DeprecateWorkflowType,
	// but is still in use. You should keep workers supporting this type running.
	// You cannot create new workflow executions of this type.
	TypeInfo *WorkflowTypeInfo `locationName:"typeInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowTypeOutput) GoString() string {
	return s.String()
}

// Contains the configuration settings of a domain.
type DomainConfiguration struct {
	_ struct{} `type:"structure"`

	// The retention period for workflow executions in this domain.
	WorkflowExecutionRetentionPeriodInDays *string `locationName:"workflowExecutionRetentionPeriodInDays" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainConfiguration) GoString() string {
	return s.String()
}

// Contains general information about a domain.
type DomainInfo struct {
	_ struct{} `type:"structure"`

	// The description of the domain provided through RegisterDomain.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain. This name is unique within the account.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the domain:
	//
	//   REGISTERED: The domain is properly registered and available. You can use
	// this domain for registering types and creating new workflow executions.
	//  DEPRECATED: The domain was deprecated using DeprecateDomain, but is still
	// in use. You should not create new workflow executions in this domain.
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainInfo) GoString() string {
	return s.String()
}

// Used to filter the workflow executions in visibility APIs by various time-based
// rules. Each parameter, if specified, defines a rule that must be satisfied
// by each returned query result. The parameter values are in the Unix Time
// format (https://en.wikipedia.org/wiki/Unix_time). For example: "oldestDate":
// 1325376070.
type ExecutionTimeFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the latest start or close date and time to return.
	LatestDate *time.Time `locationName:"latestDate" type:"timestamp" timestampFormat:"unix"`

	// Specifies the oldest start or close date and time to return.
	OldestDate *time.Time `locationName:"oldestDate" type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s ExecutionTimeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionTimeFilter) GoString() string {
	return s.String()
}

// Provides details of the ExternalWorkflowExecutionCancelRequested event.
type ExternalWorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution to which the cancellation request was delivered.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalWorkflowExecutionCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ExternalWorkflowExecutionSignaled event.
type ExternalWorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution that the signal was delivered to.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalWorkflowExecutionSignaledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the FailWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type FailWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Details of the failure.
	Details *string `locationName:"details" type:"string"`

	// A descriptive reason for the failure that may help in diagnostics.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s FailWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the FailWorkflowExecutionFailed event.
type FailWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"FailWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s FailWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

type GetWorkflowExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Specifies the workflow execution for which to return the history.
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the events in reverse order. By default the results
	// are returned in ascending order of the eventTimeStamp of the events.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkflowExecutionHistoryInput) GoString() string {
	return s.String()
}

// Paginated representation of a workflow history for a workflow execution.
// This is the up to date, complete and authoritative record of the events related
// to all tasks and events in the life of the workflow execution.
type GetWorkflowExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of history events.
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkflowExecutionHistoryOutput) GoString() string {
	return s.String()
}

// Event within a workflow execution. A history event can be one of these types:
//
//   WorkflowExecutionStarted: The workflow execution was started.  WorkflowExecutionCompleted:
// The workflow execution was closed due to successful completion.  WorkflowExecutionFailed:
// The workflow execution closed due to a failure.  WorkflowExecutionTimedOut:
// The workflow execution was closed because a time out was exceeded.  WorkflowExecutionCanceled:
// The workflow execution was successfully canceled and closed.  WorkflowExecutionTerminated:
// The workflow execution was terminated.  WorkflowExecutionContinuedAsNew:
// The workflow execution was closed and a new execution of the same type was
// created with the same workflowId.  WorkflowExecutionCancelRequested: A request
// to cancel this workflow execution was made.  DecisionTaskScheduled: A decision
// task was scheduled for the workflow execution.  DecisionTaskStarted: The
// decision task was dispatched to a decider.  DecisionTaskCompleted: The decider
// successfully completed a decision task by calling RespondDecisionTaskCompleted.
//  DecisionTaskTimedOut: The decision task timed out.  ActivityTaskScheduled:
// An activity task was scheduled for execution.  ScheduleActivityTaskFailed:
// Failed to process ScheduleActivityTask decision. This happens when the decision
// is not configured properly, for example the activity type specified is not
// registered.  ActivityTaskStarted: The scheduled activity task was dispatched
// to a worker.  ActivityTaskCompleted: An activity worker successfully completed
// an activity task by calling RespondActivityTaskCompleted.  ActivityTaskFailed:
// An activity worker failed an activity task by calling RespondActivityTaskFailed.
//  ActivityTaskTimedOut: The activity task timed out.  ActivityTaskCanceled:
// The activity task was successfully canceled.  ActivityTaskCancelRequested:
// A RequestCancelActivityTask decision was received by the system.  RequestCancelActivityTaskFailed:
// Failed to process RequestCancelActivityTask decision. This happens when the
// decision is not configured properly.  WorkflowExecutionSignaled: An external
// signal was received for the workflow execution.  MarkerRecorded: A marker
// was recorded in the workflow history as the result of a RecordMarker decision.
//  TimerStarted: A timer was started for the workflow execution due to a StartTimer
// decision.  StartTimerFailed: Failed to process StartTimer decision. This
// happens when the decision is not configured properly, for example a timer
// already exists with the specified timer ID.  TimerFired: A timer, previously
// started for this workflow execution, fired.  TimerCanceled: A timer, previously
// started for this workflow execution, was successfully canceled.  CancelTimerFailed:
// Failed to process CancelTimer decision. This happens when the decision is
// not configured properly, for example no timer exists with the specified timer
// ID.  StartChildWorkflowExecutionInitiated: A request was made to start a
// child workflow execution.  StartChildWorkflowExecutionFailed: Failed to process
// StartChildWorkflowExecution decision. This happens when the decision is not
// configured properly, for example the workflow type specified is not registered.
//  ChildWorkflowExecutionStarted: A child workflow execution was successfully
// started.  ChildWorkflowExecutionCompleted: A child workflow execution, started
// by this workflow execution, completed successfully and was closed.  ChildWorkflowExecutionFailed:
// A child workflow execution, started by this workflow execution, failed to
// complete successfully and was closed.  ChildWorkflowExecutionTimedOut: A
// child workflow execution, started by this workflow execution, timed out and
// was closed.  ChildWorkflowExecutionCanceled: A child workflow execution,
// started by this workflow execution, was canceled and closed.  ChildWorkflowExecutionTerminated:
// A child workflow execution, started by this workflow execution, was terminated.
//  SignalExternalWorkflowExecutionInitiated: A request to signal an external
// workflow was made.  ExternalWorkflowExecutionSignaled: A signal, requested
// by this workflow execution, was successfully delivered to the target external
// workflow execution.  SignalExternalWorkflowExecutionFailed: The request to
// signal an external workflow execution failed.  RequestCancelExternalWorkflowExecutionInitiated:
// A request was made to request the cancellation of an external workflow execution.
//  ExternalWorkflowExecutionCancelRequested: Request to cancel an external
// workflow execution was successfully delivered to the target execution.  RequestCancelExternalWorkflowExecutionFailed:
// Request to cancel an external workflow execution failed.  LambdaFunctionScheduled:
// An AWS Lambda function was scheduled for execution.  LambdaFunctionStarted:
// The scheduled function was invoked in the AWS Lambda service.  LambdaFunctionCompleted:
// The AWS Lambda function successfully completed.  LambdaFunctionFailed: The
// AWS Lambda function execution failed.  LambdaFunctionTimedOut: The AWS Lambda
// function execution timed out.  ScheduleLambdaFunctionFailed: Failed to process
// ScheduleLambdaFunction decision. This happens when the workflow execution
// does not have the proper IAM role attached to invoke AWS Lambda functions.
//  StartLambdaFunctionFailed: Failed to invoke the scheduled function in the
// AWS Lambda service. This happens when the AWS Lambda service is not available
// in the current region, or received too many requests.
type HistoryEvent struct {
	_ struct{} `type:"structure"`

	// If the event is of type ActivityTaskcancelRequested then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	ActivityTaskCancelRequestedEventAttributes *ActivityTaskCancelRequestedEventAttributes `locationName:"activityTaskCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCanceled then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	ActivityTaskCanceledEventAttributes *ActivityTaskCanceledEventAttributes `locationName:"activityTaskCanceledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCompleted then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	ActivityTaskCompletedEventAttributes *ActivityTaskCompletedEventAttributes `locationName:"activityTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskFailed then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	ActivityTaskFailedEventAttributes *ActivityTaskFailedEventAttributes `locationName:"activityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskScheduled then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	ActivityTaskScheduledEventAttributes *ActivityTaskScheduledEventAttributes `locationName:"activityTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskStarted then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	ActivityTaskStartedEventAttributes *ActivityTaskStartedEventAttributes `locationName:"activityTaskStartedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskTimedOut then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	ActivityTaskTimedOutEventAttributes *ActivityTaskTimedOutEventAttributes `locationName:"activityTaskTimedOutEventAttributes" type:"structure"`

	// If the event is of type CancelTimerFailed then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	CancelTimerFailedEventAttributes *CancelTimerFailedEventAttributes `locationName:"cancelTimerFailedEventAttributes" type:"structure"`

	// If the event is of type CancelWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It is not set for
	// other event types.
	CancelWorkflowExecutionFailedEventAttributes *CancelWorkflowExecutionFailedEventAttributes `locationName:"cancelWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCanceled then this member is
	// set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionCanceledEventAttributes *ChildWorkflowExecutionCanceledEventAttributes `locationName:"childWorkflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCompleted then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionCompletedEventAttributes *ChildWorkflowExecutionCompletedEventAttributes `locationName:"childWorkflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionFailedEventAttributes *ChildWorkflowExecutionFailedEventAttributes `locationName:"childWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionStarted then this member is
	// set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionStartedEventAttributes *ChildWorkflowExecutionStartedEventAttributes `locationName:"childWorkflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTerminated then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionTerminatedEventAttributes *ChildWorkflowExecutionTerminatedEventAttributes `locationName:"childWorkflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTimedOut then this member is
	// set and provides detailed information about the event. It is not set for
	// other event types.
	ChildWorkflowExecutionTimedOutEventAttributes *ChildWorkflowExecutionTimedOutEventAttributes `locationName:"childWorkflowExecutionTimedOutEventAttributes" type:"structure"`

	// If the event is of type CompleteWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	CompleteWorkflowExecutionFailedEventAttributes *CompleteWorkflowExecutionFailedEventAttributes `locationName:"completeWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ContinueAsNewWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	ContinueAsNewWorkflowExecutionFailedEventAttributes *ContinueAsNewWorkflowExecutionFailedEventAttributes `locationName:"continueAsNewWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskCompleted then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	DecisionTaskCompletedEventAttributes *DecisionTaskCompletedEventAttributes `locationName:"decisionTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskScheduled then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	DecisionTaskScheduledEventAttributes *DecisionTaskScheduledEventAttributes `locationName:"decisionTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskStarted then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	DecisionTaskStartedEventAttributes *DecisionTaskStartedEventAttributes `locationName:"decisionTaskStartedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskTimedOut then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	DecisionTaskTimedOutEventAttributes *DecisionTaskTimedOutEventAttributes `locationName:"decisionTaskTimedOutEventAttributes" type:"structure"`

	// The system generated ID of the event. This ID uniquely identifies the event
	// with in the workflow execution history.
	EventId *int64 `locationName:"eventId" type:"long" required:"true"`

	// The date and time when the event occurred.
	EventTimestamp *time.Time `locationName:"eventTimestamp" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The type of the history event.
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventType"`

	// If the event is of type ExternalWorkflowExecutionCancelRequested then this
	// member is set and provides detailed information about the event. It is not
	// set for other event types.
	ExternalWorkflowExecutionCancelRequestedEventAttributes *ExternalWorkflowExecutionCancelRequestedEventAttributes `locationName:"externalWorkflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ExternalWorkflowExecutionSignaled then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	ExternalWorkflowExecutionSignaledEventAttributes *ExternalWorkflowExecutionSignaledEventAttributes `locationName:"externalWorkflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type FailWorkflowExecutionFailed then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	FailWorkflowExecutionFailedEventAttributes *FailWorkflowExecutionFailedEventAttributes `locationName:"failWorkflowExecutionFailedEventAttributes" type:"structure"`

	// Provides details for the LambdaFunctionCompleted event.
	LambdaFunctionCompletedEventAttributes *LambdaFunctionCompletedEventAttributes `locationName:"lambdaFunctionCompletedEventAttributes" type:"structure"`

	// Provides details for the LambdaFunctionFailed event.
	LambdaFunctionFailedEventAttributes *LambdaFunctionFailedEventAttributes `locationName:"lambdaFunctionFailedEventAttributes" type:"structure"`

	// Provides details for the LambdaFunctionScheduled event.
	LambdaFunctionScheduledEventAttributes *LambdaFunctionScheduledEventAttributes `locationName:"lambdaFunctionScheduledEventAttributes" type:"structure"`

	// Provides details for the LambdaFunctionStarted event.
	LambdaFunctionStartedEventAttributes *LambdaFunctionStartedEventAttributes `locationName:"lambdaFunctionStartedEventAttributes" type:"structure"`

	// Provides details for the LambdaFunctionTimedOut event.
	LambdaFunctionTimedOutEventAttributes *LambdaFunctionTimedOutEventAttributes `locationName:"lambdaFunctionTimedOutEventAttributes" type:"structure"`

	// If the event is of type MarkerRecorded then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	MarkerRecordedEventAttributes *MarkerRecordedEventAttributes `locationName:"markerRecordedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskFailed then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	RecordMarkerFailedEventAttributes *RecordMarkerFailedEventAttributes `locationName:"recordMarkerFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelActivityTaskFailed then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	RequestCancelActivityTaskFailedEventAttributes *RequestCancelActivityTaskFailedEventAttributes `locationName:"requestCancelActivityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionFailed then
	// this member is set and provides detailed information about the event. It
	// is not set for other event types.
	RequestCancelExternalWorkflowExecutionFailedEventAttributes *RequestCancelExternalWorkflowExecutionFailedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionInitiated then
	// this member is set and provides detailed information about the event. It
	// is not set for other event types.
	RequestCancelExternalWorkflowExecutionInitiatedEventAttributes *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type ScheduleActivityTaskFailed then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	ScheduleActivityTaskFailedEventAttributes *ScheduleActivityTaskFailedEventAttributes `locationName:"scheduleActivityTaskFailedEventAttributes" type:"structure"`

	// Provides details for the ScheduleLambdaFunctionFailed event.
	ScheduleLambdaFunctionFailedEventAttributes *ScheduleLambdaFunctionFailedEventAttributes `locationName:"scheduleLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	SignalExternalWorkflowExecutionFailedEventAttributes *SignalExternalWorkflowExecutionFailedEventAttributes `locationName:"signalExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionInitiated then this
	// member is set and provides detailed information about the event. It is not
	// set for other event types.
	SignalExternalWorkflowExecutionInitiatedEventAttributes *SignalExternalWorkflowExecutionInitiatedEventAttributes `locationName:"signalExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	StartChildWorkflowExecutionFailedEventAttributes *StartChildWorkflowExecutionFailedEventAttributes `locationName:"startChildWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionInitiated then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	StartChildWorkflowExecutionInitiatedEventAttributes *StartChildWorkflowExecutionInitiatedEventAttributes `locationName:"startChildWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// Provides details for the StartLambdaFunctionFailed event.
	StartLambdaFunctionFailedEventAttributes *StartLambdaFunctionFailedEventAttributes `locationName:"startLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type StartTimerFailed then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	StartTimerFailedEventAttributes *StartTimerFailedEventAttributes `locationName:"startTimerFailedEventAttributes" type:"structure"`

	// If the event is of type TimerCanceled then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	TimerCanceledEventAttributes *TimerCanceledEventAttributes `locationName:"timerCanceledEventAttributes" type:"structure"`

	// If the event is of type TimerFired then this member is set and provides detailed
	// information about the event. It is not set for other event types.
	TimerFiredEventAttributes *TimerFiredEventAttributes `locationName:"timerFiredEventAttributes" type:"structure"`

	// If the event is of type TimerStarted then this member is set and provides
	// detailed information about the event. It is not set for other event types.
	TimerStartedEventAttributes *TimerStartedEventAttributes `locationName:"timerStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCancelRequested then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	WorkflowExecutionCancelRequestedEventAttributes *WorkflowExecutionCancelRequestedEventAttributes `locationName:"workflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCanceled then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionCanceledEventAttributes *WorkflowExecutionCanceledEventAttributes `locationName:"workflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCompleted then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionCompletedEventAttributes *WorkflowExecutionCompletedEventAttributes `locationName:"workflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionContinuedAsNew then this member
	// is set and provides detailed information about the event. It is not set for
	// other event types.
	WorkflowExecutionContinuedAsNewEventAttributes *WorkflowExecutionContinuedAsNewEventAttributes `locationName:"workflowExecutionContinuedAsNewEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It is not set for other event
	// types.
	WorkflowExecutionFailedEventAttributes *WorkflowExecutionFailedEventAttributes `locationName:"workflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionSignaled then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionSignaledEventAttributes *WorkflowExecutionSignaledEventAttributes `locationName:"workflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionStarted then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionStartedEventAttributes *WorkflowExecutionStartedEventAttributes `locationName:"workflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTerminated then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionTerminatedEventAttributes *WorkflowExecutionTerminatedEventAttributes `locationName:"workflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTimedOut then this member is set
	// and provides detailed information about the event. It is not set for other
	// event types.
	WorkflowExecutionTimedOutEventAttributes *WorkflowExecutionTimedOutEventAttributes `locationName:"workflowExecutionTimedOutEventAttributes" type:"structure"`
}

// String returns the string representation
func (s HistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryEvent) GoString() string {
	return s.String()
}

// Provides details for the LambdaFunctionCompleted event.
type LambdaFunctionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The result of the function execution (if any).
	Result *string `locationName:"result" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this AWS
	// Lambda function was scheduled. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded in the history.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionCompletedEventAttributes) GoString() string {
	return s.String()
}

// Provides details for the LambdaFunctionFailed event.
type LambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure (if any).
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure (if any).
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this AWS
	// Lambda function was scheduled. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded in the history.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details for the LambdaFunctionScheduled event.
type LambdaFunctionScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event for the decision that resulted
	// in the scheduling of this AWS Lambda function. This information can be useful
	// for diagnosing problems by tracing back the chain of events leading up to
	// this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The unique Amazon SWF ID for the AWS Lambda task.
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// Input provided to the AWS Lambda function.
	Input *string `locationName:"input" min:"1" type:"string"`

	// The name of the scheduled AWS Lambda function.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum time, in seconds, that the AWS Lambda function can take to execute
	// from start to close before it is marked as failed.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduledEventAttributes) GoString() string {
	return s.String()
}

// Provides details for the LambdaFunctionStarted event.
type LambdaFunctionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this AWS
	// Lambda function was scheduled. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionStartedEventAttributes) GoString() string {
	return s.String()
}

// Provides details for the LambdaFunctionTimedOut event.
type LambdaFunctionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this AWS
	// Lambda function was scheduled. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded in the history.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	TimeoutType *string `locationName:"timeoutType" type:"string" enum:"LambdaFunctionTimeoutType"`
}

// String returns the string representation
func (s LambdaFunctionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionTimedOutEventAttributes) GoString() string {
	return s.String()
}

type ListActivityTypesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the activity types have been registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If specified, only lists the activity types that have this name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the activity types to list.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default, the results
	// are returned in ascending alphabetical order by name of the activity types.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListActivityTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivityTypesInput) GoString() string {
	return s.String()
}

// Contains a paginated list of activity type information structures.
type ListActivityTypesOutput struct {
	_ struct{} `type:"structure"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// List of activity type information.
	TypeInfos []*ActivityTypeInfo `locationName:"typeInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s ListActivityTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivityTypesOutput) GoString() string {
	return s.String()
}

type ListClosedWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// If specified, only workflow executions that match this close status are listed.
	// For example, if TERMINATED is specified, then only TERMINATED workflow executions
	// are listed.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	CloseStatusFilter *CloseStatusFilter `locationName:"closeStatusFilter" type:"structure"`

	// If specified, the workflow executions are included in the returned results
	// based on whether their close times are within the range specified by this
	// filter. Also, if this parameter is specified, the returned results are ordered
	// by their close times.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	CloseTimeFilter *ExecutionTimeFilter `locationName:"closeTimeFilter" type:"structure"`

	// The name of the domain that contains the workflow executions to list.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the workflow ID specified
	// in the filter are returned.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in descending order of the start or the close time of the executions.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// If specified, the workflow executions are included in the returned results
	// based on whether their start times are within the range specified by this
	// filter. Also, if this parameter is specified, the returned results are ordered
	// by their start times.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure"`

	// If specified, only executions that have the matching tag are listed.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, only executions of the type specified in the filter are returned.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s ListClosedWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClosedWorkflowExecutionsInput) GoString() string {
	return s.String()
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the domains to list.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default, the results
	// are returned in ascending alphabetical order by name of the domains.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Contains a paginated collection of DomainInfo structures.
type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DomainInfo structures.
	DomainInfos []*DomainInfo `locationName:"domainInfos" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

type ListOpenWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the workflow executions to list.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the workflow ID specified
	// in the filter are returned.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in descending order of the start time of the executions.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// Workflow executions are included in the returned results based on whether
	// their start times are within the range specified by this filter.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure" required:"true"`

	// If specified, only executions that have the matching tag are listed.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, only executions of the type specified in the filter are returned.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s ListOpenWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenWorkflowExecutionsInput) GoString() string {
	return s.String()
}

type ListWorkflowTypesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the workflow types have been registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If specified, lists the workflow type with this name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the workflow types to list.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in ascending alphabetical order of the name of the workflow
	// types.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListWorkflowTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowTypesInput) GoString() string {
	return s.String()
}

// Contains a paginated list of information structures about workflow types.
type ListWorkflowTypesOutput struct {
	_ struct{} `type:"structure"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// The list of workflow type information.
	TypeInfos []*WorkflowTypeInfo `locationName:"typeInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s ListWorkflowTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowTypesOutput) GoString() string {
	return s.String()
}

// Provides details of the MarkerRecorded event.
type MarkerRecordedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarker decision that requested this marker. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// Details of the marker (if any).
	Details *string `locationName:"details" type:"string"`

	// The name of the marker.
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MarkerRecordedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarkerRecordedEventAttributes) GoString() string {
	return s.String()
}

// Contains the count of tasks in a task list.
type PendingTaskCount struct {
	_ struct{} `type:"structure"`

	// The number of tasks in the task list.
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s PendingTaskCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingTaskCount) GoString() string {
	return s.String()
}

type PollForActivityTaskInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task lists being polled.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Identity of the worker making the request, recorded in the ActivityTaskStarted
	// event in the workflow history. This enables diagnostic tracing when problems
	// arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// Specifies the task list to poll for activity tasks.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForActivityTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForActivityTaskInput) GoString() string {
	return s.String()
}

// Unit of work sent to an activity worker.
type PollForActivityTaskOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the task.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of this activity task.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The inputs provided when the activity task was scheduled. The form of the
	// input is user defined and should be meaningful to the activity implementation.
	Input *string `locationName:"input" type:"string"`

	// The ID of the ActivityTaskStarted event recorded in the history.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The opaque string used as a handle on the task. This token is used by workers
	// to communicate progress and response information back to the system about
	// the task.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`

	// The workflow execution that started this activity task.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForActivityTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForActivityTaskOutput) GoString() string {
	return s.String()
}

type PollForDecisionTaskInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the task lists to poll.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Identity of the decider making the request, which is recorded in the DecisionTaskStarted
	// event in the workflow history. This enables diagnostic tracing when problems
	// arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The maximum number of results that will be returned per call. nextPageToken
	// can be used to obtain futher pages of results. The default is 1000, which
	// is the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	//
	// The nextPageToken returned by this action cannot be used with GetWorkflowExecutionHistory
	// to get the next page. You must call PollForDecisionTask again (with the nextPageToken)
	// to retrieve the next page of history records. Calling PollForDecisionTask
	// with a nextPageToken will not return a new decision task..
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the events in reverse order. By default the results
	// are returned in ascending order of the eventTimestamp of the events.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// Specifies the task list to poll for decision tasks.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForDecisionTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForDecisionTaskInput) GoString() string {
	return s.String()
}

// A structure that represents a decision task. Decision tasks are sent to deciders
// in order for them to make decisions.
type PollForDecisionTaskOutput struct {
	_ struct{} `type:"structure"`

	// A paginated list of history events of the workflow execution. The decider
	// uses this during the processing of the decision task.
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// The ID of the DecisionTaskStarted event of the previous decision task of
	// this workflow execution that was processed by the decider. This can be used
	// to determine the events in the history new since the last decision task received
	// by the decider.
	PreviousStartedEventId *int64 `locationName:"previousStartedEventId" type:"long"`

	// The ID of the DecisionTaskStarted event recorded in the history.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The opaque string used as a handle on the task. This token is used by workers
	// to communicate progress and response information back to the system about
	// the task.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`

	// The workflow execution for which this decision task was created.
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the workflow execution for which this decision task was created.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForDecisionTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForDecisionTaskOutput) GoString() string {
	return s.String()
}

type RecordActivityTaskHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// If specified, contains details about the progress of the task.
	Details *string `locationName:"details" type:"string"`

	// The taskToken of the ActivityTask.
	//
	//  taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordActivityTaskHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordActivityTaskHeartbeatInput) GoString() string {
	return s.String()
}

// Status information about an activity task.
type RecordActivityTaskHeartbeatOutput struct {
	_ struct{} `type:"structure"`

	// Set to true if cancellation of the task is requested.
	CancelRequested *bool `locationName:"cancelRequested" type:"boolean" required:"true"`
}

// String returns the string representation
func (s RecordActivityTaskHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordActivityTaskHeartbeatOutput) GoString() string {
	return s.String()
}

// Provides details of the RecordMarker decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type RecordMarkerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. details of the marker.
	Details *string `locationName:"details" type:"string"`

	// Required. The name of the marker.
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordMarkerDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the RecordMarkerFailed event.
type RecordMarkerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RecordMarkerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarkerFailed decision for this cancellation request.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The marker's name.
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordMarkerFailedEventAttributes) GoString() string {
	return s.String()
}

type RegisterActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the default maximum time before which a worker processing
	// a task of this type must report progress by calling RecordActivityTaskHeartbeat.
	// If the timeout is exceeded, the activity task is automatically timed out.
	// This default can be overridden when scheduling an activity task using the
	// ScheduleActivityTask decision. If the activity worker subsequently attempts
	// to record a heartbeat or returns a result, the activity worker receives an
	// UnknownResource fault. In this case, Amazon SWF no longer considers the activity
	// task to be valid; the activity worker should clean up the activity task.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string `locationName:"defaultTaskHeartbeatTimeout" type:"string"`

	// If set, specifies the default task list to use for scheduling tasks of this
	// activity type. This default task list is used if a task list is not provided
	// when a task is scheduled through the ScheduleActivityTask decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority to assign to the activity type. If not assigned,
	// then "0" will be used. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// If set, specifies the default maximum duration for a task of this activity
	// type. This default can be overridden when scheduling an activity task using
	// the ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string `locationName:"defaultTaskScheduleToCloseTimeout" type:"string"`

	// If set, specifies the default maximum duration that a task of this activity
	// type can wait before being assigned to a worker. This default can be overridden
	// when scheduling an activity task using the ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string `locationName:"defaultTaskScheduleToStartTimeout" type:"string"`

	// If set, specifies the default maximum duration that a worker can take to
	// process tasks of this activity type. This default can be overridden when
	// scheduling an activity task using the ScheduleActivityTask decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`

	// A textual description of the activity type.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain in which this activity is to be registered.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the activity type within the domain.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the activity type.
	//
	// The activity type consists of the name and version, the combination of which
	// must be unique within the domain. The specified string must not start or
	// end with whitespace. It must not contain a : (colon), / (slash), | (vertical
	// bar), or any control characters (\u0000-\u001f | \u007f - \u009f). Also,
	// it must not contain the literal string quotarnquot.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterActivityTypeInput) GoString() string {
	return s.String()
}

type RegisterActivityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterActivityTypeOutput) GoString() string {
	return s.String()
}

type RegisterDomainInput struct {
	_ struct{} `type:"structure"`

	// A text description of the domain.
	Description *string `locationName:"description" type:"string"`

	// Name of the domain to register. The name must be unique in the region that
	// the domain is registered in.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The duration (in days) that records and histories of workflow executions
	// on the domain should be kept by the service. After the retention period,
	// the workflow execution is not available in the results of visibility calls.
	//
	// If you pass the value NONE or 0 (zero), then the workflow execution history
	// will not be retained. As soon as the workflow execution completes, the execution
	// record and its history are deleted.
	//
	// The maximum workflow execution retention period is 90 days. For more information
	// about Amazon SWF service limits, see: Amazon SWF Service Limits (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html)
	// in the Amazon SWF Developer Guide.
	WorkflowExecutionRetentionPeriodInDays *string `locationName:"workflowExecutionRetentionPeriodInDays" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainInput) GoString() string {
	return s.String()
}

type RegisterDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainOutput) GoString() string {
	return s.String()
}

type RegisterWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the default policy to use for the child workflow executions
	// when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	DefaultChildPolicy *string `locationName:"defaultChildPolicy" type:"string" enum:"ChildPolicy"`

	// If set, specifies the default maximum duration for executions of this workflow
	// type. You can override this default when starting an execution through the
	// StartWorkflowExecution action or StartChildWorkflowExecution decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot
	// specify a value of "NONE" for defaultExecutionStartToCloseTimeout; there
	// is a one-year max limit on the time that a workflow execution can run. Exceeding
	// this limit will always cause the workflow execution to time out.
	DefaultExecutionStartToCloseTimeout *string `locationName:"defaultExecutionStartToCloseTimeout" type:"string"`

	// The ARN of the default IAM role to use when a workflow execution of this
	// type invokes AWS Lambda functions.
	//
	// This default can be overridden when starting a workflow execution using
	// the StartWorkflowExecution action or the StartChildWorkflowExecution and
	// ContinueAsNewWorkflowExecution decision.
	DefaultLambdaRole *string `locationName:"defaultLambdaRole" min:"1" type:"string"`

	// If set, specifies the default task list to use for scheduling decision tasks
	// for executions of this workflow type. This default is used only if a task
	// list is not provided when starting the execution through the StartWorkflowExecution
	// action or StartChildWorkflowExecution decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority to assign to the workflow type. If not assigned,
	// then "0" will be used. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// If set, specifies the default maximum duration of decision tasks for this
	// workflow type. This default can be overridden when starting a workflow execution
	// using the StartWorkflowExecution action or the StartChildWorkflowExecution
	// decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`

	// Textual description of the workflow type.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain in which to register the workflow type.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the workflow type.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the workflow type.
	//
	// The workflow type consists of the name and version, the combination of which
	// must be unique within the domain. To get a list of all currently registered
	// workflow types, use the ListWorkflowTypes action. The specified string must
	// not start or end with whitespace. It must not contain a : (colon), / (slash),
	// | (vertical bar), or any control characters (\u0000-\u001f | \u007f - \u009f).
	// Also, it must not contain the literal string quotarnquot.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterWorkflowTypeInput) GoString() string {
	return s.String()
}

type RegisterWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterWorkflowTypeOutput) GoString() string {
	return s.String()
}

// Provides details of the RequestCancelActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type RequestCancelActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId of the activity task to be canceled.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelActivityTaskDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the RequestCancelActivityTaskFailed event.
type RequestCancelActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the RequestCancelActivityTask decision that failed.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RequestCancelActivityTaskFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the RequestCancelExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type RequestCancelExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The runId of the external workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// Required. The workflowId of the external workflow execution to cancel.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the RequestCancelExternalWorkflowExecutionFailed event.
type RequestCancelExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RequestCancelExternalWorkflowExecutionFailedCause"`

	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow to which the cancel request was to
	// be delivered.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the RequestCancelExternalWorkflowExecutionInitiated event.
type RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution to be canceled.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution to be canceled.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

type RequestCancelWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to cancel.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The runId of the workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the workflow execution to cancel.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelWorkflowExecutionInput) GoString() string {
	return s.String()
}

type RequestCancelWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelWorkflowExecutionOutput) GoString() string {
	return s.String()
}

type RespondActivityTaskCanceledInput struct {
	_ struct{} `type:"structure"`

	// Optional. Information about the cancellation.
	Details *string `locationName:"details" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskCanceledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCanceledInput) GoString() string {
	return s.String()
}

type RespondActivityTaskCanceledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskCanceledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCanceledOutput) GoString() string {
	return s.String()
}

type RespondActivityTaskCompletedInput struct {
	_ struct{} `type:"structure"`

	// The result of the activity task. It is a free form string that is implementation
	// specific.
	Result *string `locationName:"result" type:"string"`

	// The taskToken of the ActivityTask.
	//
	//  taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCompletedInput) GoString() string {
	return s.String()
}

type RespondActivityTaskCompletedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCompletedOutput) GoString() string {
	return s.String()
}

type RespondActivityTaskFailedInput struct {
	_ struct{} `type:"structure"`

	// Optional. Detailed information about the failure.
	Details *string `locationName:"details" type:"string"`

	// Description of the error that may assist in diagnostics.
	Reason *string `locationName:"reason" type:"string"`

	// The taskToken of the ActivityTask.
	//
	//  taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskFailedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskFailedInput) GoString() string {
	return s.String()
}

type RespondActivityTaskFailedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskFailedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskFailedOutput) GoString() string {
	return s.String()
}

type RespondDecisionTaskCompletedInput struct {
	_ struct{} `type:"structure"`

	// The list of decisions (possibly empty) made by the decider while processing
	// this decision task. See the docs for the decision structure for details.
	Decisions []*Decision `locationName:"decisions" type:"list"`

	// User defined context to add to workflow execution.
	ExecutionContext *string `locationName:"executionContext" type:"string"`

	// The taskToken from the DecisionTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondDecisionTaskCompletedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondDecisionTaskCompletedInput) GoString() string {
	return s.String()
}

type RespondDecisionTaskCompletedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondDecisionTaskCompletedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondDecisionTaskCompletedOutput) GoString() string {
	return s.String()
}

// Provides details of the ScheduleActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  activityType.name: String constraint. The key
// is swf:activityType.name. activityType.version: String constraint. The key
// is swf:activityType.version. taskList: String constraint. The key is swf:taskList.name.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type ScheduleActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Required. The activityId of the activity task.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// Required. The type of the activity task to schedule.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data is not sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// If set, specifies the maximum time before which a worker processing a task
	// of this type must report progress by calling RecordActivityTaskHeartbeat.
	// If the timeout is exceeded, the activity task is automatically timed out.
	// If the worker subsequently attempts to record a heartbeat or returns a result,
	// it will be ignored. This overrides the default heartbeat timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum duration for this activity task.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A schedule-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-close timeout was specified at registration
	// time then a fault will be returned.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// Optional. If set, specifies the maximum duration the activity task can wait
	// to be assigned to a worker. This overrides the default schedule-to-start
	// timeout specified when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A schedule-to-start timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-start timeout was specified at registration
	// time then a fault will be returned.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// If set, specifies the maximum duration a worker may take to process this
	// activity task. This overrides the default start-to-close timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A start-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default start-to-close timeout was specified at registration
	// time then a fault will be returned.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// If set, specifies the name of the task list in which to schedule the activity
	// task. If not specified, the defaultTaskList registered with the activity
	// type will be used.
	//
	// A task list for this activity task must be specified either as a default
	// for the activity type or through this field. If neither this field is set
	// nor a default task list was specified at registration time then a fault will
	// be returned. The specified string must not start or end with whitespace.
	// It must not contain a : (colon), / (slash), | (vertical bar), or any control
	// characters (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the
	// literal string quotarnquot.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// Optional. If set, specifies the priority with which the activity task is
	// to be assigned to a worker. This overrides the defaultTaskPriority specified
	// when registering the activity type using RegisterActivityType. Valid values
	// are integers that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE
	// (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ScheduleActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActivityTaskDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the ScheduleActivityTaskFailed event.
type ScheduleActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the ScheduleActivityTask decision that failed.
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The activity type provided in the ScheduleActivityTask decision that failed.
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ScheduleActivityTaskFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ScheduleActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the ScheduleLambdaFunction decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.  activityType.name: String constraint. The key
// is swf:activityType.name. activityType.version: String constraint. The key
// is swf:activityType.version. taskList: String constraint. The key is swf:taskList.name.
//    If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type ScheduleLambdaFunctionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Required. The SWF id of the AWS Lambda task.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The input provided to the AWS Lambda function.
	Input *string `locationName:"input" min:"1" type:"string"`

	// Required. The name of the AWS Lambda function to invoke.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// If set, specifies the maximum duration the function may take to execute.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleLambdaFunctionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details for the ScheduleLambdaFunctionFailed event.
type ScheduleLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ScheduleLambdaFunctionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this AWS Lambda function. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The unique Amazon SWF ID of the AWS Lambda task.
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the scheduled AWS Lambda function.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleLambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the SignalExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type SignalExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// Optional. Input data to be provided with the signal. The target workflow
	// execution will use the signal name and input data to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to be signaled.
	RunId *string `locationName:"runId" type:"string"`

	// Required. The name of the signal.The target workflow execution will use the
	// signal name and input to process the signal.
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// Required. The workflowId of the workflow execution to be signaled.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the SignalExternalWorkflowExecutionFailed event.
type SignalExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"SignalExternalWorkflowExecutionFailedCause"`

	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution that the signal was being delivered
	// to.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution that the signal was being
	// delivered to.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the SignalExternalWorkflowExecutionInitiated event.
type SignalExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// Input provided to the signal (if any).
	Input *string `locationName:"input" type:"string"`

	// The runId of the external workflow execution to send the signal to.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal.
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the external workflow execution.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

type SignalWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to signal.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Data to attach to the WorkflowExecutionSignaled event in the target workflow
	// execution's history.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to signal.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal. This name must be meaningful to the target workflow.
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the workflow execution to signal.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalWorkflowExecutionInput) GoString() string {
	return s.String()
}

type SignalWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Provides details of the StartChildWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. Constrain the following parameters by using a Condition element
// with the appropriate keys.   tagList.member.N: The key is "swf:tagList.N"
// where N is the tag number from 0 to 4, inclusive. taskList: String constraint.
// The key is swf:taskList.name. workflowType.name: String constraint. The key
// is swf:workflowType.name. workflowType.version: String constraint. The key
// is swf:workflowType.version.    If the caller does not have sufficient permissions
// to invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// will be set to OPERATION_NOT_PERMITTED. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type StartChildWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. If set, specifies the policy to use for the child workflow executions
	// if the workflow execution being started is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.  A child policy
	// for this workflow execution must be specified either as a default for the
	// workflow type or through this parameter. If neither this parameter is set
	// nor a default child policy was specified at registration time then a fault
	// will be returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data is not sent to the child workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
	// specified when registering the workflow type.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be
	// specified either as a default for the workflow type or through this parameter.
	// If neither this parameter is set nor a default execution start-to-close timeout
	// was specified at registration time then a fault will be returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input to be provided to the workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
	//
	// In order for this workflow execution to invoke AWS Lambda functions, an
	// appropriate IAM role must be specified either as a default for the workflow
	// type or through this field.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the child workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list to be used for decision tasks of the child workflow
	// execution.
	//
	// A task list for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter
	// is set nor a default task list was specified at registration time then a
	// fault will be returned. The specified string must not start or end with whitespace.
	// It must not contain a : (colon), / (slash), | (vertical bar), or any control
	// characters (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the
	// literal string quotarnquot.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// Optional. A task priority that, if set, specifies the priority for a decision
	// task of this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A task start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault will be returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// Required. The workflowId of the workflow execution.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// Required. The type of the workflow execution to be started.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the StartChildWorkflowExecutionFailed event.
type StartChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"StartChildWorkflowExecutionFailedCause"`

	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the cause of events.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The workflowId of the child workflow execution.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The workflow type provided in the StartChildWorkflowExecution decision that
	// failed.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the StartChildWorkflowExecutionInitiated event.
type StartChildWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this execution gets
	// terminated by explicitly calling the TerminateWorkflowExecution action or
	// due to an expired timeout.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// decision tasks. This data is not sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the cause of events.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum duration for the child workflow execution. If the workflow execution
	// is not closed within this duration, it will be timed out and force terminated.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The inputs provided to the child workflow execution (if any).
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to this workflow execution to use when invoking AWS
	// Lambda functions.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associated with the child workflow execution.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list used for the decision tasks of the child workflow
	// execution.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// Optional. The priority assigned for the decision tasks for this workflow
	// execution. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for the decision tasks for this workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflowId of the child workflow execution.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the child workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

// Provides details for the StartLambdaFunctionFailed event.
type StartLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" enum:"StartLambdaFunctionFailedCause"`

	// The error message (if any).
	Message *string `locationName:"message" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this AWS
	// Lambda function was scheduled. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long"`
}

// String returns the string representation
func (s StartLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the StartTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//  Use a Resource element with the domain name to limit the action to only
// specified domains. Use an Action element to allow or deny permission to call
// this action. You cannot use an IAM policy to constrain this action's parameters.
//  If the caller does not have sufficient permissions to invoke the action,
// or the parameter values fall outside the specified constraints, the action
// fails. The associated event attribute's cause parameter will be set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
type StartTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// Required. The duration to wait before firing the timer.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0.
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// Required. The unique ID of the timer.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimerDecisionAttributes) GoString() string {
	return s.String()
}

// Provides details of the StartTimerFailed event.
type StartTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because
	// it lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html).
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"StartTimerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the StartTimer decision that failed.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimerFailedEventAttributes) GoString() string {
	return s.String()
}

type StartWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// this workflow execution if it is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.  A child policy
	// for this workflow execution must be specified either as a default for the
	// workflow type or through this parameter. If neither this parameter is set
	// nor a default child policy was specified at registration time then a fault
	// will be returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// The name of the domain in which the workflow execution is created.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
	// specified when registering the workflow type.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. Exceeding this limit will cause the workflow execution to time out. Unlike
	// some of the other timeout parameters in Amazon SWF, you cannot specify a
	// value of "NONE" for this timeout; there is a one-year max limit on the time
	// that a workflow execution can run.
	//
	//  An execution start-to-close timeout must be specified either through this
	// parameter or as a default when the workflow type is registered. If neither
	// this parameter nor a default execution start-to-close timeout is specified,
	// a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input for the workflow execution. This is a free form string which should
	// be meaningful to the workflow you are starting. This input is made available
	// to the new workflow execution in the WorkflowExecutionStarted history event.
	Input *string `locationName:"input" type:"string"`

	// The ARN of an IAM role that authorizes Amazon SWF to invoke AWS Lambda functions.
	//
	// In order for this workflow execution to invoke AWS Lambda functions, an
	// appropriate IAM role must be specified either as a default for the workflow
	// type or through this field.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the workflow execution. You can specify
	// a maximum of 5 tags. You can list workflow executions with a specific tag
	// by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and
	// specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// The task list to use for the decision tasks generated for this workflow execution.
	// This overrides the defaultTaskList specified when registering the workflow
	// type.
	//
	// A task list for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter
	// is set nor a default task list was specified at registration time then a
	// fault will be returned. The specified string must not start or end with whitespace.
	// It must not contain a : (colon), / (slash), | (vertical bar), or any control
	// characters (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the
	// literal string quotarnquot.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// The task priority to use for this workflow execution. This will override
	// any default priority that was assigned when the workflow type was registered.
	// If not set, then the default task priority for the workflow type will be
	// used. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	//
	// A task start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault will be returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The user defined identifier associated with the workflow execution. You can
	// use this to associate a custom identifier with the workflow execution. You
	// may specify the same identifier if a workflow execution is logically a restart
	// of a previous execution. You cannot have two open workflow executions with
	// the same workflowId at the same time.
	//
	// The specified string must not start or end with whitespace. It must not
	// contain a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f - \u009f). Also, it must not contain the literal
	// string quotarnquot.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the workflow to start.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Specifies the runId of a workflow execution.
type StartWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The runId of a workflow execution. This ID is generated by the service and
	// can be used to uniquely identify the workflow execution within a domain.
	RunId *string `locationName:"runId" min:"1" type:"string"`
}

// String returns the string representation
func (s StartWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Used to filter the workflow executions in visibility APIs based on a tag.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// Required. Specifies the tag that must be associated with the execution for
	// it to meet the filter criteria.
	Tag *string `locationName:"tag" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Represents a task list.
type TaskList struct {
	_ struct{} `type:"structure"`

	// The name of the task list.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskList) GoString() string {
	return s.String()
}

type TerminateWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// the workflow execution being terminated. This policy overrides the child
	// policy specified for the workflow execution at registration time or when
	// starting the execution.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.  A child policy
	// for this workflow execution must be specified either as a default for the
	// workflow type or through this parameter. If neither this parameter is set
	// nor a default child policy was specified at registration time then a fault
	// will be returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// Optional. Details for terminating the workflow execution.
	Details *string `locationName:"details" type:"string"`

	// The domain of the workflow execution to terminate.
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Optional. A descriptive reason for terminating the workflow execution.
	Reason *string `locationName:"reason" type:"string"`

	// The runId of the workflow execution to terminate.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the workflow execution to terminate.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkflowExecutionInput) GoString() string {
	return s.String()
}

type TerminateWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Provides details of the TimerCanceled event.
type TimerCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that was canceled.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerCanceledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the TimerFired event.
type TimerFiredEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that fired.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerFiredEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerFiredEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the TimerStarted event.
type TimerStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Optional. Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The duration of time after which the timer will fire.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0.
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// The unique ID of the timer that was started.
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerStartedEventAttributes) GoString() string {
	return s.String()
}

// Represents a workflow execution.
type WorkflowExecution struct {
	_ struct{} `type:"structure"`

	// A system-generated unique identifier for the workflow execution.
	RunId *string `locationName:"runId" min:"1" type:"string" required:"true"`

	// The user defined identifier associated with the workflow execution.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecution) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionCancelRequested event.
type WorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the request to cancel the workflow execution was automatically
	// generated, and specifies the cause. This happens if the parent workflow execution
	// times out or is terminated, and the child policy is set to cancel child executions.
	Cause *string `locationName:"cause" type:"string" enum:"WorkflowExecutionCancelRequestedCause"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this workflow
	// execution.The source event with this ID can be found in the history of the
	// source workflow execution. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The external workflow execution for which the cancellation was requested.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`
}

// String returns the string representation
func (s WorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionCanceled event.
type WorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// Details for the cancellation (if any).
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCanceledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionCompleted event.
type WorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The result produced by the workflow execution upon successful completion.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCompletedEventAttributes) GoString() string {
	return s.String()
}

// The configuration settings for a workflow execution including timeout values,
// tasklist etc. These configuration settings are determined from the defaults
// specified when registering the workflow type and those specified when starting
// the workflow execution.
type WorkflowExecutionConfiguration struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The total duration for this workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" min:"1" type:"string" required:"true"`

	// The IAM role used by this workflow execution when invoking AWS Lambda functions.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The task list used for the decision tasks generated for this workflow execution.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority assigned to decision tasks for this workflow execution. Valid
	// values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for decision tasks for this workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionConfiguration) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionContinuedAsNew event.
type WorkflowExecutionContinuedAsNewEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions of the new execution
	// if it is terminated by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The total duration allowed for the new workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to this workflow execution to use when invoking AWS
	// Lambda functions.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The runId of the new workflow execution.
	NewExecutionRunId *string `locationName:"newExecutionRunId" min:"1" type:"string" required:"true"`

	// The list of tags associated with the new workflow execution.
	TagList []*string `locationName:"tagList" type:"list"`

	// Represents a task list.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for the new workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// Represents a workflow type.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionContinuedAsNewEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionContinuedAsNewEventAttributes) GoString() string {
	return s.String()
}

// Contains the count of workflow executions returned from CountOpenWorkflowExecutions
// or CountClosedWorkflowExecutions
type WorkflowExecutionCount struct {
	_ struct{} `type:"structure"`

	// The number of workflow executions.
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s WorkflowExecutionCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCount) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionFailed event.
type WorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the failure (if any).
	Details *string `locationName:"details" type:"string"`

	// The descriptive reason provided for the failure (if any).
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// Used to filter the workflow executions in visibility APIs by their workflowId.
type WorkflowExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The workflowId to pass of match the criteria of this filter.
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionFilter) GoString() string {
	return s.String()
}

// Contains information about a workflow execution.
type WorkflowExecutionInfo struct {
	_ struct{} `type:"structure"`

	// Set to true if a cancellation is requested for this workflow execution.
	CancelRequested *bool `locationName:"cancelRequested" type:"boolean"`

	// If the execution status is closed then this specifies how the execution was
	// closed:
	//
	//   COMPLETED: the execution was successfully completed.  CANCELED: the execution
	// was canceled.Cancellation allows the implementation to gracefully clean up
	// before the execution is closed.  TERMINATED: the execution was force terminated.
	//  FAILED: the execution failed to complete.  TIMED_OUT: the execution did
	// not complete in the alloted time and was automatically timed out.  CONTINUED_AS_NEW:
	// the execution is logically continued. This means the current execution was
	// completed and a new execution was started to carry on the workflow.
	CloseStatus *string `locationName:"closeStatus" type:"string" enum:"CloseStatus"`

	// The time when the workflow execution was closed. Set only if the execution
	// status is CLOSED.
	CloseTimestamp *time.Time `locationName:"closeTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The workflow execution this information is about.
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The current status of the execution.
	ExecutionStatus *string `locationName:"executionStatus" type:"string" required:"true" enum:"ExecutionStatus"`

	// If this workflow execution is a child of another execution then contains
	// the workflow execution that started this execution.
	Parent *WorkflowExecution `locationName:"parent" type:"structure"`

	// The time when the execution was started.
	StartTimestamp *time.Time `locationName:"startTimestamp" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The list of tags associated with the workflow execution. Tags can be used
	// to identify and list workflow executions of interest through the visibility
	// APIs. A workflow execution can have a maximum of 5 tags.
	TagList []*string `locationName:"tagList" type:"list"`

	// The type of the workflow execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionInfo) GoString() string {
	return s.String()
}

// Contains a paginated list of information about workflow executions.
type WorkflowExecutionInfos struct {
	_ struct{} `type:"structure"`

	// The list of workflow information structures.
	ExecutionInfos []*WorkflowExecutionInfo `locationName:"executionInfos" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionInfos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionInfos) GoString() string {
	return s.String()
}

// Contains the counts of open tasks, child workflow executions and timers for
// a workflow execution.
type WorkflowExecutionOpenCounts struct {
	_ struct{} `type:"structure"`

	// The count of activity tasks whose status is OPEN.
	OpenActivityTasks *int64 `locationName:"openActivityTasks" type:"integer" required:"true"`

	// The count of child workflow executions whose status is OPEN.
	OpenChildWorkflowExecutions *int64 `locationName:"openChildWorkflowExecutions" type:"integer" required:"true"`

	// The count of decision tasks whose status is OPEN. A workflow execution can
	// have at most one open decision task.
	OpenDecisionTasks *int64 `locationName:"openDecisionTasks" type:"integer" required:"true"`

	// The count of AWS Lambda functions that are currently executing.
	OpenLambdaFunctions *int64 `locationName:"openLambdaFunctions" type:"integer"`

	// The count of timers started by this workflow execution that have not fired
	// yet.
	OpenTimers *int64 `locationName:"openTimers" type:"integer" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionOpenCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionOpenCounts) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionSignaled event.
type WorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflow decision to signal this workflow execution.The
	// source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event. This field is set only
	// if the signal was initiated by another workflow execution.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The workflow execution that sent the signal. This is set only of the signal
	// was sent by another workflow execution.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`

	// Inputs provided with the signal (if any). The decider can use the signal
	// name and inputs to determine how to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The name of the signal received. The decider can use the signal name and
	// inputs to determine how to the process the signal.
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionSignaledEventAttributes) GoString() string {
	return s.String()
}

// Provides details of WorkflowExecutionStarted event.
type WorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// If this workflow execution was started due to a ContinueAsNewWorkflowExecution
	// decision, then it contains the runId of the previous workflow execution that
	// was closed and continued as this execution.
	ContinuedExecutionRunId *string `locationName:"continuedExecutionRunId" type:"string"`

	// The maximum duration for this workflow execution.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the workflow execution (if any).
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to this workflow execution to use when invoking AWS
	// Lambda functions.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution decision to start this workflow execution.
	// The source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	ParentInitiatedEventId *int64 `locationName:"parentInitiatedEventId" type:"long"`

	// The source workflow execution that started this workflow execution. The member
	// is not set if the workflow execution was not started by a workflow.
	ParentWorkflowExecution *WorkflowExecution `locationName:"parentWorkflowExecution" type:"structure"`

	// The list of tags associated with this workflow execution. An execution can
	// have up to 5 tags.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list for scheduling the decision tasks for this workflow
	// execution.
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for this workflow type.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflow type of this execution.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionStartedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionTerminated event.
type WorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the workflow execution was automatically terminated,
	// and specifies the cause. This happens if the parent workflow execution times
	// out or is terminated and the child policy is set to terminate child executions.
	Cause *string `locationName:"cause" type:"string" enum:"WorkflowExecutionTerminatedCause"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The details provided for the termination (if any).
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the termination (if any).
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionTerminatedEventAttributes) GoString() string {
	return s.String()
}

// Provides details of the WorkflowExecutionTimedOut event.
type WorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The type of timeout that caused this event.
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"WorkflowExecutionTimeoutType"`
}

// String returns the string representation
func (s WorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionTimedOutEventAttributes) GoString() string {
	return s.String()
}

// Represents a workflow type.
type WorkflowType struct {
	_ struct{} `type:"structure"`

	// Required. The name of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Required. The version of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowType) GoString() string {
	return s.String()
}

// The configuration settings of a workflow type.
type WorkflowTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// Optional. The default policy to use for the child workflow executions when
	// a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// The supported child policies are:
	//
	//  TERMINATE: the child executions will be terminated. REQUEST_CANCEL: a request
	// to cancel will be attempted for each child execution by recording a WorkflowExecutionCancelRequested
	// event in its history. It is up to the decider to take appropriate actions
	// when it receives an execution history with this event. ABANDON: no action
	// will be taken. The child executions will continue to run.
	DefaultChildPolicy *string `locationName:"defaultChildPolicy" type:"string" enum:"ChildPolicy"`

	// Optional. The default maximum duration, specified when registering the workflow
	// type, for executions of this workflow type. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultExecutionStartToCloseTimeout *string `locationName:"defaultExecutionStartToCloseTimeout" type:"string"`

	// The default IAM role to use when a workflow execution invokes a AWS Lambda
	// function.
	DefaultLambdaRole *string `locationName:"defaultLambdaRole" min:"1" type:"string"`

	// Optional. The default task list, specified when registering the workflow
	// type, for decisions tasks scheduled for workflow executions of this type.
	// This default can be overridden when starting a workflow execution using the
	// StartWorkflowExecution action or the StartChildWorkflowExecution decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// Optional. The default task priority, specified when registering the workflow
	// type, for all decision tasks of this workflow type. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon Simple Workflow Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// Optional. The default maximum duration, specified when registering the workflow
	// type, that a decision task for executions of this workflow type might take
	// before returning completion or failure. If the task does not close in the
	// specified time then the task is automatically timed out and rescheduled.
	// If the decider eventually reports a completion or failure, it is ignored.
	// This default can be overridden when starting a workflow execution using the
	// StartWorkflowExecution action or the StartChildWorkflowExecution decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. The value "NONE" can be used to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeConfiguration) GoString() string {
	return s.String()
}

// Used to filter workflow execution query results by type. Each parameter,
// if specified, defines a rule that must be satisfied by each returned result.
type WorkflowTypeFilter struct {
	_ struct{} `type:"structure"`

	// Required. Name of the workflow type.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Version of the workflow type.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeFilter) GoString() string {
	return s.String()
}

// Contains information about a workflow type.
type WorkflowTypeInfo struct {
	_ struct{} `type:"structure"`

	// The date when this type was registered.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix" required:"true"`

	// If the type is in deprecated state, then it is set to the date when the type
	// was deprecated.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp" timestampFormat:"unix"`

	// The description of the type registered through RegisterWorkflowType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the workflow type.
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`

	// The workflow type this information is about.
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeInfo) GoString() string {
	return s.String()
}

const (
	// @enum ActivityTaskTimeoutType
	ActivityTaskTimeoutTypeStartToClose = "START_TO_CLOSE"
	// @enum ActivityTaskTimeoutType
	ActivityTaskTimeoutTypeScheduleToStart = "SCHEDULE_TO_START"
	// @enum ActivityTaskTimeoutType
	ActivityTaskTimeoutTypeScheduleToClose = "SCHEDULE_TO_CLOSE"
	// @enum ActivityTaskTimeoutType
	ActivityTaskTimeoutTypeHeartbeat = "HEARTBEAT"
)

const (
	// @enum CancelTimerFailedCause
	CancelTimerFailedCauseTimerIdUnknown = "TIMER_ID_UNKNOWN"
	// @enum CancelTimerFailedCause
	CancelTimerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum CancelWorkflowExecutionFailedCause
	CancelWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"
	// @enum CancelWorkflowExecutionFailedCause
	CancelWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum ChildPolicy
	ChildPolicyTerminate = "TERMINATE"
	// @enum ChildPolicy
	ChildPolicyRequestCancel = "REQUEST_CANCEL"
	// @enum ChildPolicy
	ChildPolicyAbandon = "ABANDON"
)

const (
	// @enum CloseStatus
	CloseStatusCompleted = "COMPLETED"
	// @enum CloseStatus
	CloseStatusFailed = "FAILED"
	// @enum CloseStatus
	CloseStatusCanceled = "CANCELED"
	// @enum CloseStatus
	CloseStatusTerminated = "TERMINATED"
	// @enum CloseStatus
	CloseStatusContinuedAsNew = "CONTINUED_AS_NEW"
	// @enum CloseStatus
	CloseStatusTimedOut = "TIMED_OUT"
)

const (
	// @enum CompleteWorkflowExecutionFailedCause
	CompleteWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"
	// @enum CompleteWorkflowExecutionFailedCause
	CompleteWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDeprecated = "WORKFLOW_TYPE_DEPRECATED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist = "WORKFLOW_TYPE_DOES_NOT_EXIST"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined = "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined = "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseDefaultChildPolicyUndefined = "DEFAULT_CHILD_POLICY_UNDEFINED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseContinueAsNewWorkflowExecutionRateExceeded = "CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED"
	// @enum ContinueAsNewWorkflowExecutionFailedCause
	ContinueAsNewWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum DecisionTaskTimeoutType
	DecisionTaskTimeoutTypeStartToClose = "START_TO_CLOSE"
)

const (
	// @enum DecisionType
	DecisionTypeScheduleActivityTask = "ScheduleActivityTask"
	// @enum DecisionType
	DecisionTypeRequestCancelActivityTask = "RequestCancelActivityTask"
	// @enum DecisionType
	DecisionTypeCompleteWorkflowExecution = "CompleteWorkflowExecution"
	// @enum DecisionType
	DecisionTypeFailWorkflowExecution = "FailWorkflowExecution"
	// @enum DecisionType
	DecisionTypeCancelWorkflowExecution = "CancelWorkflowExecution"
	// @enum DecisionType
	DecisionTypeContinueAsNewWorkflowExecution = "ContinueAsNewWorkflowExecution"
	// @enum DecisionType
	DecisionTypeRecordMarker = "RecordMarker"
	// @enum DecisionType
	DecisionTypeStartTimer = "StartTimer"
	// @enum DecisionType
	DecisionTypeCancelTimer = "CancelTimer"
	// @enum DecisionType
	DecisionTypeSignalExternalWorkflowExecution = "SignalExternalWorkflowExecution"
	// @enum DecisionType
	DecisionTypeRequestCancelExternalWorkflowExecution = "RequestCancelExternalWorkflowExecution"
	// @enum DecisionType
	DecisionTypeStartChildWorkflowExecution = "StartChildWorkflowExecution"
	// @enum DecisionType
	DecisionTypeScheduleLambdaFunction = "ScheduleLambdaFunction"
)

const (
	// @enum EventType
	EventTypeWorkflowExecutionStarted = "WorkflowExecutionStarted"
	// @enum EventType
	EventTypeWorkflowExecutionCancelRequested = "WorkflowExecutionCancelRequested"
	// @enum EventType
	EventTypeWorkflowExecutionCompleted = "WorkflowExecutionCompleted"
	// @enum EventType
	EventTypeCompleteWorkflowExecutionFailed = "CompleteWorkflowExecutionFailed"
	// @enum EventType
	EventTypeWorkflowExecutionFailed = "WorkflowExecutionFailed"
	// @enum EventType
	EventTypeFailWorkflowExecutionFailed = "FailWorkflowExecutionFailed"
	// @enum EventType
	EventTypeWorkflowExecutionTimedOut = "WorkflowExecutionTimedOut"
	// @enum EventType
	EventTypeWorkflowExecutionCanceled = "WorkflowExecutionCanceled"
	// @enum EventType
	EventTypeCancelWorkflowExecutionFailed = "CancelWorkflowExecutionFailed"
	// @enum EventType
	EventTypeWorkflowExecutionContinuedAsNew = "WorkflowExecutionContinuedAsNew"
	// @enum EventType
	EventTypeContinueAsNewWorkflowExecutionFailed = "ContinueAsNewWorkflowExecutionFailed"
	// @enum EventType
	EventTypeWorkflowExecutionTerminated = "WorkflowExecutionTerminated"
	// @enum EventType
	EventTypeDecisionTaskScheduled = "DecisionTaskScheduled"
	// @enum EventType
	EventTypeDecisionTaskStarted = "DecisionTaskStarted"
	// @enum EventType
	EventTypeDecisionTaskCompleted = "DecisionTaskCompleted"
	// @enum EventType
	EventTypeDecisionTaskTimedOut = "DecisionTaskTimedOut"
	// @enum EventType
	EventTypeActivityTaskScheduled = "ActivityTaskScheduled"
	// @enum EventType
	EventTypeScheduleActivityTaskFailed = "ScheduleActivityTaskFailed"
	// @enum EventType
	EventTypeActivityTaskStarted = "ActivityTaskStarted"
	// @enum EventType
	EventTypeActivityTaskCompleted = "ActivityTaskCompleted"
	// @enum EventType
	EventTypeActivityTaskFailed = "ActivityTaskFailed"
	// @enum EventType
	EventTypeActivityTaskTimedOut = "ActivityTaskTimedOut"
	// @enum EventType
	EventTypeActivityTaskCanceled = "ActivityTaskCanceled"
	// @enum EventType
	EventTypeActivityTaskCancelRequested = "ActivityTaskCancelRequested"
	// @enum EventType
	EventTypeRequestCancelActivityTaskFailed = "RequestCancelActivityTaskFailed"
	// @enum EventType
	EventTypeWorkflowExecutionSignaled = "WorkflowExecutionSignaled"
	// @enum EventType
	EventTypeMarkerRecorded = "MarkerRecorded"
	// @enum EventType
	EventTypeRecordMarkerFailed = "RecordMarkerFailed"
	// @enum EventType
	EventTypeTimerStarted = "TimerStarted"
	// @enum EventType
	EventTypeStartTimerFailed = "StartTimerFailed"
	// @enum EventType
	EventTypeTimerFired = "TimerFired"
	// @enum EventType
	EventTypeTimerCanceled = "TimerCanceled"
	// @enum EventType
	EventTypeCancelTimerFailed = "CancelTimerFailed"
	// @enum EventType
	EventTypeStartChildWorkflowExecutionInitiated = "StartChildWorkflowExecutionInitiated"
	// @enum EventType
	EventTypeStartChildWorkflowExecutionFailed = "StartChildWorkflowExecutionFailed"
	// @enum EventType
	EventTypeChildWorkflowExecutionStarted = "ChildWorkflowExecutionStarted"
	// @enum EventType
	EventTypeChildWorkflowExecutionCompleted = "ChildWorkflowExecutionCompleted"
	// @enum EventType
	EventTypeChildWorkflowExecutionFailed = "ChildWorkflowExecutionFailed"
	// @enum EventType
	EventTypeChildWorkflowExecutionTimedOut = "ChildWorkflowExecutionTimedOut"
	// @enum EventType
	EventTypeChildWorkflowExecutionCanceled = "ChildWorkflowExecutionCanceled"
	// @enum EventType
	EventTypeChildWorkflowExecutionTerminated = "ChildWorkflowExecutionTerminated"
	// @enum EventType
	EventTypeSignalExternalWorkflowExecutionInitiated = "SignalExternalWorkflowExecutionInitiated"
	// @enum EventType
	EventTypeSignalExternalWorkflowExecutionFailed = "SignalExternalWorkflowExecutionFailed"
	// @enum EventType
	EventTypeExternalWorkflowExecutionSignaled = "ExternalWorkflowExecutionSignaled"
	// @enum EventType
	EventTypeRequestCancelExternalWorkflowExecutionInitiated = "RequestCancelExternalWorkflowExecutionInitiated"
	// @enum EventType
	EventTypeRequestCancelExternalWorkflowExecutionFailed = "RequestCancelExternalWorkflowExecutionFailed"
	// @enum EventType
	EventTypeExternalWorkflowExecutionCancelRequested = "ExternalWorkflowExecutionCancelRequested"
	// @enum EventType
	EventTypeLambdaFunctionScheduled = "LambdaFunctionScheduled"
	// @enum EventType
	EventTypeLambdaFunctionStarted = "LambdaFunctionStarted"
	// @enum EventType
	EventTypeLambdaFunctionCompleted = "LambdaFunctionCompleted"
	// @enum EventType
	EventTypeLambdaFunctionFailed = "LambdaFunctionFailed"
	// @enum EventType
	EventTypeLambdaFunctionTimedOut = "LambdaFunctionTimedOut"
	// @enum EventType
	EventTypeScheduleLambdaFunctionFailed = "ScheduleLambdaFunctionFailed"
	// @enum EventType
	EventTypeStartLambdaFunctionFailed = "StartLambdaFunctionFailed"
)

const (
	// @enum ExecutionStatus
	ExecutionStatusOpen = "OPEN"
	// @enum ExecutionStatus
	ExecutionStatusClosed = "CLOSED"
)

const (
	// @enum FailWorkflowExecutionFailedCause
	FailWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"
	// @enum FailWorkflowExecutionFailedCause
	FailWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum LambdaFunctionTimeoutType
	LambdaFunctionTimeoutTypeStartToClose = "START_TO_CLOSE"
)

const (
	// @enum RecordMarkerFailedCause
	RecordMarkerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum RegistrationStatus
	RegistrationStatusRegistered = "REGISTERED"
	// @enum RegistrationStatus
	RegistrationStatusDeprecated = "DEPRECATED"
)

const (
	// @enum RequestCancelActivityTaskFailedCause
	RequestCancelActivityTaskFailedCauseActivityIdUnknown = "ACTIVITY_ID_UNKNOWN"
	// @enum RequestCancelActivityTaskFailedCause
	RequestCancelActivityTaskFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum RequestCancelExternalWorkflowExecutionFailedCause
	RequestCancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"
	// @enum RequestCancelExternalWorkflowExecutionFailedCause
	RequestCancelExternalWorkflowExecutionFailedCauseRequestCancelExternalWorkflowExecutionRateExceeded = "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"
	// @enum RequestCancelExternalWorkflowExecutionFailedCause
	RequestCancelExternalWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseActivityTypeDeprecated = "ACTIVITY_TYPE_DEPRECATED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseActivityTypeDoesNotExist = "ACTIVITY_TYPE_DOES_NOT_EXIST"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseActivityIdAlreadyInUse = "ACTIVITY_ID_ALREADY_IN_USE"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseOpenActivitiesLimitExceeded = "OPEN_ACTIVITIES_LIMIT_EXCEEDED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseActivityCreationRateExceeded = "ACTIVITY_CREATION_RATE_EXCEEDED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseDefaultScheduleToCloseTimeoutUndefined = "DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseDefaultScheduleToStartTimeoutUndefined = "DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseDefaultStartToCloseTimeoutUndefined = "DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseDefaultHeartbeatTimeoutUndefined = "DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED"
	// @enum ScheduleActivityTaskFailedCause
	ScheduleActivityTaskFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum ScheduleLambdaFunctionFailedCause
	ScheduleLambdaFunctionFailedCauseIdAlreadyInUse = "ID_ALREADY_IN_USE"
	// @enum ScheduleLambdaFunctionFailedCause
	ScheduleLambdaFunctionFailedCauseOpenLambdaFunctionsLimitExceeded = "OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED"
	// @enum ScheduleLambdaFunctionFailedCause
	ScheduleLambdaFunctionFailedCauseLambdaFunctionCreationRateExceeded = "LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED"
	// @enum ScheduleLambdaFunctionFailedCause
	ScheduleLambdaFunctionFailedCauseLambdaServiceNotAvailableInRegion = "LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION"
)

const (
	// @enum SignalExternalWorkflowExecutionFailedCause
	SignalExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"
	// @enum SignalExternalWorkflowExecutionFailedCause
	SignalExternalWorkflowExecutionFailedCauseSignalExternalWorkflowExecutionRateExceeded = "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"
	// @enum SignalExternalWorkflowExecutionFailedCause
	SignalExternalWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist = "WORKFLOW_TYPE_DOES_NOT_EXIST"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseWorkflowTypeDeprecated = "WORKFLOW_TYPE_DEPRECATED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseOpenChildrenLimitExceeded = "OPEN_CHILDREN_LIMIT_EXCEEDED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseOpenWorkflowsLimitExceeded = "OPEN_WORKFLOWS_LIMIT_EXCEEDED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseChildCreationRateExceeded = "CHILD_CREATION_RATE_EXCEEDED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning = "WORKFLOW_ALREADY_RUNNING"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined = "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined = "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseDefaultChildPolicyUndefined = "DEFAULT_CHILD_POLICY_UNDEFINED"
	// @enum StartChildWorkflowExecutionFailedCause
	StartChildWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum StartLambdaFunctionFailedCause
	StartLambdaFunctionFailedCauseAssumeRoleFailed = "ASSUME_ROLE_FAILED"
)

const (
	// @enum StartTimerFailedCause
	StartTimerFailedCauseTimerIdAlreadyInUse = "TIMER_ID_ALREADY_IN_USE"
	// @enum StartTimerFailedCause
	StartTimerFailedCauseOpenTimersLimitExceeded = "OPEN_TIMERS_LIMIT_EXCEEDED"
	// @enum StartTimerFailedCause
	StartTimerFailedCauseTimerCreationRateExceeded = "TIMER_CREATION_RATE_EXCEEDED"
	// @enum StartTimerFailedCause
	StartTimerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// @enum WorkflowExecutionCancelRequestedCause
	WorkflowExecutionCancelRequestedCauseChildPolicyApplied = "CHILD_POLICY_APPLIED"
)

const (
	// @enum WorkflowExecutionTerminatedCause
	WorkflowExecutionTerminatedCauseChildPolicyApplied = "CHILD_POLICY_APPLIED"
	// @enum WorkflowExecutionTerminatedCause
	WorkflowExecutionTerminatedCauseEventLimitExceeded = "EVENT_LIMIT_EXCEEDED"
	// @enum WorkflowExecutionTerminatedCause
	WorkflowExecutionTerminatedCauseOperatorInitiated = "OPERATOR_INITIATED"
)

const (
	// @enum WorkflowExecutionTimeoutType
	WorkflowExecutionTimeoutTypeStartToClose = "START_TO_CLOSE"
)
