/*
 * Copyright (c) 2018, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <arch_helpers.h>
#include <platform.h>
#include <stdint.h>

#define RANDOM_CANARY_VALUE	2144346116U

u_register_t plat_get_stack_protector_canary(void)
{
	/*
	 * Ideally, a random number should be returned instead of the
	 * combination of a timer's value and a compile-time constant.
	 */
	return RANDOM_CANARY_VALUE ^ (u_register_t)read_cntpct_el0();
}

