<!--[metadata]>
+++
title = "join"
description = "Create a Swarm node."
keywords = ["swarm, create, join"]
[menu.main]
identifier="swarm.join"
parent="smn_swarm_subcmds"
+++
<![end-metadata]-->

# join — Create a Swarm node

Prerequisite: Before using `join`, establish a discovery backend as described in [this discovery topic](../discovery.md).

The `join` command creates a Swarm node whose purpose is to run containers on behalf of the cluster. A typical cluster has multiple Swarm nodes.

To create a Swarm node, use the following syntax:

    $ docker run swarm join [OPTIONS] <discovery>

For example, to create a Swarm node in a high-availability cluster with other managers, enter:

    $ docker run -d swarm join --advertise=172.30.0.69:2375 consul://172.30.0.161:8500


Or, for example, to create a Swarm node that uses Transport Layer Security (TLS) to authenticate the Docker Swarm nodes, enter:

    $ sudo docker run -d swarm join --addr=node1:2376 token://86222732d62b6868d441d430aee4f055

## Arguments

The `join` command has only one argument:

### `<discovery>` — Discovery backend

Before you create a Swarm node, [create a discovery token](create.md) or [set up a discovery backend](../discovery.md) for your cluster.

When you create the Swarm node, use the `<discovery>` argument to specify one of the following discovery backends:

* `token://<token>`
* `consul://<ip1>/<path>`
* `etcd://<ip1>,<ip2>,<ip3>/<path>`
* `file://<path/to/file>`
* `zk://<ip1>,<ip2>/<path>`
* `[nodes://]<iprange>,<iprange>`

Where:

* `<token>` is a discovery token generated by Docker Hub's hosted discovery service. To generate this discovery token, use the [`create`](create.md) command.
    > Warning: Docker Hub's hosted discovery backend is not recommended for production use. It’s intended only for testing/development.

* `ip1`, `ip2`, `ip3` are each the IP address and port numbers of a discovery backend node.
* `path` (optional) is a path to a key-value store on the discovery backend. When you use a single backend to service multiple clusters, you use paths to maintain separate key-value stores for each cluster.
* `path/to/file` is the path to a file that contains a static list of the Swarm managers and nodes that are members the cluster. <!--tbd - can the file contain ipranges?-->
* `iprange` is an IP address or a range of IP addresses followed by a port number.

For example:
* A discovery token: `token://0ac50ef75c9739f5bfeeaf00503d4e6e`
* A Consul node: `consul://172.30.0.165:8500`

The environment variable for `<discovery>` is `$SWARM_DISCOVERY`.

For more information and examples, see the [Docker Swarm Discovery](../discovery.md) topic.

## Options

The `join` command has the following options:

### `--advertise` or `--addr` — Advertise the Docker Engine's IP and port number

Use `--advertise <ip>:<port>` or `--addr <ip>:<port>` to advertise the IP address and port number of the Docker Engine. For example, `--advertise 172.30.0.161:4000`. Swarm managers MUST be able to reach this Swarm node at this address.

The environment variable for `--advertise` is `$SWARM_ADVERTISE`.

### `--heartbeat` — Period between each heartbeat

Use `--heartbeat "<interval>s"` to specify the interval, in seconds, between heartbeats the node sends to the primary manager. These heartbeats indicate that the node is healthy and reachable. By default, the interval is 60 seconds.

### `--ttl` — Sets the expiration of an ephemeral node

Use `--ttl "<interval>s"` to specify the time-to-live (TTL) interval, in seconds, of an ephemeral node. The default interval is `180s`. <!-- tbd - Define ephemeral node. Explain what triggers the ttl countdown. -->

### `--delay` — Add a random delay in [0s,delay] to avoid synchronized registration

Use `--delay "<interval>s"` to specify the maximum interval for a random delay, in seconds, before the node registers with the discovery backend. If you deploy a large number of nodes simultaneously, the random delay spreads registrations out over the interval and avoids saturating the discovery backend.

### `--discovery-opt` — Discovery options

Use `--discovery-opt <value>` to discovery options, such as paths to the TLS files; the CA's public key certificate, the certificate, and the private key of the distributed K/V store on a Consul or etcd discovery backend. You can enter multiple discovery options. For example:

    --discovery-opt kv.cacertfile=/path/to/mycacert.pem \
    --discovery-opt kv.certfile=/path/to/mycert.pem \
    --discovery-opt kv.keyfile=/path/to/mykey.pem \

For more information, see [Use TLS with distributed key/value discovery](../discovery.md)
