/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package extensions

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/kubernetes/pkg/api"
	pkg4_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	pkg5_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg4_resource.Quantity
		var v2 pkg1_unversioned.LabelSelector
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [2]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = x.Selector != nil
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(2)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym20 := z.DecBinary()
	_ = yym20
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct21 := r.ContainerType()
		if yyct21 == codecSelferValueTypeMap1234 {
			yyl21 := r.ReadMapStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl21, d)
			}
		} else if yyct21 == codecSelferValueTypeArray1234 {
			yyl21 := r.ReadArrayStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl21, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys22Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys22Slc
	var yyhl22 bool = l >= 0
	for yyj22 := 0; ; yyj22++ {
		if yyhl22 {
			if yyj22 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys22Slc = r.DecodeBytes(yys22Slc, true, true)
		yys22 := string(yys22Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys22 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys22)
		} // end switch yys22
	} // end for yyj22
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym30 := z.EncBinary()
		_ = yym30
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep31 := !z.EncBinary()
			yy2arr31 := z.EncBasicHandle().StructToArray
			var yyq31 [5]bool
			_, _, _ = yysep31, yyq31, yy2arr31
			const yyr31 bool = false
			yyq31[0] = x.Kind != ""
			yyq31[1] = x.APIVersion != ""
			yyq31[2] = true
			yyq31[3] = true
			yyq31[4] = true
			var yynn31 int
			if yyr31 || yy2arr31 {
				r.EncodeArrayStart(5)
			} else {
				yynn31 = 0
				for _, b := range yyq31 {
					if b {
						yynn31++
					}
				}
				r.EncodeMapStart(yynn31)
				yynn31 = 0
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[0] {
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[1] {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym37 := z.EncBinary()
					_ = yym37
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[2] {
					yy39 := &x.ObjectMeta
					yy39.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy40 := &x.ObjectMeta
					yy40.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[3] {
					yy42 := &x.Spec
					yy42.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.Spec
					yy43.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[4] {
					yy45 := &x.Status
					yy45.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy46 := &x.Status
					yy46.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym47 := z.DecBinary()
	_ = yym47
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct48 := r.ContainerType()
		if yyct48 == codecSelferValueTypeMap1234 {
			yyl48 := r.ReadMapStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl48, d)
			}
		} else if yyct48 == codecSelferValueTypeArray1234 {
			yyl48 := r.ReadArrayStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl48, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys49Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys49Slc
	var yyhl49 bool = l >= 0
	for yyj49 := 0; ; yyj49++ {
		if yyhl49 {
			if yyj49 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys49Slc = r.DecodeBytes(yys49Slc, true, true)
		yys49 := string(yys49Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys49 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv52 := &x.ObjectMeta
				yyv52.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv53 := &x.Spec
				yyv53.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv54 := &x.Status
				yyv54.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys49)
		} // end switch yys49
	} // end for yyj49
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj55 int
	var yyb55 bool
	var yyhl55 bool = l >= 0
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv58 := &x.ObjectMeta
		yyv58.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv59 := &x.Spec
		yyv59.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv60 := &x.Status
		yyv60.CodecDecodeSelf(d)
	}
	for {
		yyj55++
		if yyhl55 {
			yyb55 = yyj55 > l
		} else {
			yyb55 = r.CheckBreak()
		}
		if yyb55 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj55-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym61 := z.EncBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep62 := !z.EncBinary()
			yy2arr62 := z.EncBasicHandle().StructToArray
			var yyq62 [2]bool
			_, _, _ = yysep62, yyq62, yy2arr62
			const yyr62 bool = false
			yyq62[0] = x.Kind != ""
			yyq62[1] = x.APIVersion != ""
			var yynn62 int
			if yyr62 || yy2arr62 {
				r.EncodeArrayStart(2)
			} else {
				yynn62 = 0
				for _, b := range yyq62 {
					if b {
						yynn62++
					}
				}
				r.EncodeMapStart(yynn62)
				yynn62 = 0
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[0] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[1] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym69 := z.DecBinary()
	_ = yym69
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct70 := r.ContainerType()
		if yyct70 == codecSelferValueTypeMap1234 {
			yyl70 := r.ReadMapStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl70, d)
			}
		} else if yyct70 == codecSelferValueTypeArray1234 {
			yyl70 := r.ReadArrayStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl70, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys71Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys71Slc
	var yyhl71 bool = l >= 0
	for yyj71 := 0; ; yyj71++ {
		if yyhl71 {
			if yyj71 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys71Slc = r.DecodeBytes(yys71Slc, true, true)
		yys71 := string(yys71Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys71 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys71)
		} // end switch yys71
	} // end for yyj71
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj74 int
	var yyb74 bool
	var yyhl74 bool = l >= 0
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj74++
		if yyhl74 {
			yyb74 = yyj74 > l
		} else {
			yyb74 = r.CheckBreak()
		}
		if yyb74 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj74-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTarget) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [2]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(2)
			} else {
				yynn78 = 2
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym80 := z.EncBinary()
				_ = yym80
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy83 := &x.TargetValue
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else if z.HasExtensions() && z.EncExt(yy83) {
				} else if !yym84 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy83)
				} else {
					z.EncFallback(yy83)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy85 := &x.TargetValue
				yym86 := z.EncBinary()
				_ = yym86
				if false {
				} else if z.HasExtensions() && z.EncExt(yy85) {
				} else if !yym86 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy85)
				} else {
					z.EncFallback(yy85)
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTarget) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym87 := z.DecBinary()
	_ = yym87
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct88 := r.ContainerType()
		if yyct88 == codecSelferValueTypeMap1234 {
			yyl88 := r.ReadMapStart()
			if yyl88 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl88, d)
			}
		} else if yyct88 == codecSelferValueTypeArray1234 {
			yyl88 := r.ReadArrayStart()
			if yyl88 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl88, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTarget) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys89Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys89Slc
	var yyhl89 bool = l >= 0
	for yyj89 := 0; ; yyj89++ {
		if yyhl89 {
			if yyj89 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys89Slc = r.DecodeBytes(yys89Slc, true, true)
		yys89 := string(yys89Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys89 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.TargetValue = pkg4_resource.Quantity{}
			} else {
				yyv91 := &x.TargetValue
				yym92 := z.DecBinary()
				_ = yym92
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv91) {
				} else if !yym92 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv91)
				} else {
					z.DecFallback(yyv91, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys89)
		} // end switch yys89
	} // end for yyj89
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTarget) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj93 int
	var yyb93 bool
	var yyhl93 bool = l >= 0
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetValue = pkg4_resource.Quantity{}
	} else {
		yyv95 := &x.TargetValue
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv95) {
		} else if !yym96 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv95)
		} else {
			z.DecFallback(yyv95, false)
		}
	}
	for {
		yyj93++
		if yyhl93 {
			yyb93 = yyj93 > l
		} else {
			yyb93 = r.CheckBreak()
		}
		if yyb93 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj93-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTargetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym97 := z.EncBinary()
		_ = yym97
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep98 := !z.EncBinary()
			yy2arr98 := z.EncBasicHandle().StructToArray
			var yyq98 [1]bool
			_, _, _ = yysep98, yyq98, yy2arr98
			const yyr98 bool = false
			var yynn98 int
			if yyr98 || yy2arr98 {
				r.EncodeArrayStart(1)
			} else {
				yynn98 = 1
				for _, b := range yyq98 {
					if b {
						yynn98++
					}
				}
				r.EncodeMapStart(yynn98)
				yynn98 = 0
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym100 := z.EncBinary()
					_ = yym100
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym101 := z.EncBinary()
					_ = yym101
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTargetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym102 := z.DecBinary()
	_ = yym102
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct103 := r.ContainerType()
		if yyct103 == codecSelferValueTypeMap1234 {
			yyl103 := r.ReadMapStart()
			if yyl103 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl103, d)
			}
		} else if yyct103 == codecSelferValueTypeArray1234 {
			yyl103 := r.ReadArrayStart()
			if yyl103 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl103, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTargetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys104Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys104Slc
	var yyhl104 bool = l >= 0
	for yyj104 := 0; ; yyj104++ {
		if yyhl104 {
			if yyj104 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys104Slc = r.DecodeBytes(yys104Slc, true, true)
		yys104 := string(yys104Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys104 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv105 := &x.Items
				yym106 := z.DecBinary()
				_ = yym106
				if false {
				} else {
					h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv105), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys104)
		} // end switch yys104
	} // end for yyj104
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTargetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj107 int
	var yyb107 bool
	var yyhl107 bool = l >= 0
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv108 := &x.Items
		yym109 := z.DecBinary()
		_ = yym109
		if false {
		} else {
			h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv108), d)
		}
	}
	for {
		yyj107++
		if yyhl107 {
			yyb107 = yyj107 > l
		} else {
			yyb107 = r.CheckBreak()
		}
		if yyb107 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj107-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym110 := z.EncBinary()
		_ = yym110
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep111 := !z.EncBinary()
			yy2arr111 := z.EncBasicHandle().StructToArray
			var yyq111 [2]bool
			_, _, _ = yysep111, yyq111, yy2arr111
			const yyr111 bool = false
			var yynn111 int
			if yyr111 || yy2arr111 {
				r.EncodeArrayStart(2)
			} else {
				yynn111 = 2
				for _, b := range yyq111 {
					if b {
						yynn111++
					}
				}
				r.EncodeMapStart(yynn111)
				yynn111 = 0
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym113 := z.EncBinary()
				_ = yym113
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym114 := z.EncBinary()
				_ = yym114
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy116 := &x.CurrentValue
				yym117 := z.EncBinary()
				_ = yym117
				if false {
				} else if z.HasExtensions() && z.EncExt(yy116) {
				} else if !yym117 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy116)
				} else {
					z.EncFallback(yy116)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy118 := &x.CurrentValue
				yym119 := z.EncBinary()
				_ = yym119
				if false {
				} else if z.HasExtensions() && z.EncExt(yy118) {
				} else if !yym119 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy118)
				} else {
					z.EncFallback(yy118)
				}
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym120 := z.DecBinary()
	_ = yym120
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct121 := r.ContainerType()
		if yyct121 == codecSelferValueTypeMap1234 {
			yyl121 := r.ReadMapStart()
			if yyl121 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl121, d)
			}
		} else if yyct121 == codecSelferValueTypeArray1234 {
			yyl121 := r.ReadArrayStart()
			if yyl121 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl121, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys122Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys122Slc
	var yyhl122 bool = l >= 0
	for yyj122 := 0; ; yyj122++ {
		if yyhl122 {
			if yyj122 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys122Slc = r.DecodeBytes(yys122Slc, true, true)
		yys122 := string(yys122Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys122 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.CurrentValue = pkg4_resource.Quantity{}
			} else {
				yyv124 := &x.CurrentValue
				yym125 := z.DecBinary()
				_ = yym125
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv124) {
				} else if !yym125 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv124)
				} else {
					z.DecFallback(yyv124, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys122)
		} // end switch yys122
	} // end for yyj122
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj126 int
	var yyb126 bool
	var yyhl126 bool = l >= 0
	yyj126++
	if yyhl126 {
		yyb126 = yyj126 > l
	} else {
		yyb126 = r.CheckBreak()
	}
	if yyb126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj126++
	if yyhl126 {
		yyb126 = yyj126 > l
	} else {
		yyb126 = r.CheckBreak()
	}
	if yyb126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentValue = pkg4_resource.Quantity{}
	} else {
		yyv128 := &x.CurrentValue
		yym129 := z.DecBinary()
		_ = yym129
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv128) {
		} else if !yym129 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv128)
		} else {
			z.DecFallback(yyv128, false)
		}
	}
	for {
		yyj126++
		if yyhl126 {
			yyb126 = yyj126 > l
		} else {
			yyb126 = r.CheckBreak()
		}
		if yyb126 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj126-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatusList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym130 := z.EncBinary()
		_ = yym130
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep131 := !z.EncBinary()
			yy2arr131 := z.EncBasicHandle().StructToArray
			var yyq131 [1]bool
			_, _, _ = yysep131, yyq131, yy2arr131
			const yyr131 bool = false
			var yynn131 int
			if yyr131 || yy2arr131 {
				r.EncodeArrayStart(1)
			} else {
				yynn131 = 1
				for _, b := range yyq131 {
					if b {
						yynn131++
					}
				}
				r.EncodeMapStart(yynn131)
				yynn131 = 0
			}
			if yyr131 || yy2arr131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym134 := z.EncBinary()
					_ = yym134
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			}
			if yyr131 || yy2arr131 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatusList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym135 := z.DecBinary()
	_ = yym135
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct136 := r.ContainerType()
		if yyct136 == codecSelferValueTypeMap1234 {
			yyl136 := r.ReadMapStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl136, d)
			}
		} else if yyct136 == codecSelferValueTypeArray1234 {
			yyl136 := r.ReadArrayStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl136, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys137Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys137Slc
	var yyhl137 bool = l >= 0
	for yyj137 := 0; ; yyj137++ {
		if yyhl137 {
			if yyj137 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys137Slc = r.DecodeBytes(yys137Slc, true, true)
		yys137 := string(yys137Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys137 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv138 := &x.Items
				yym139 := z.DecBinary()
				_ = yym139
				if false {
				} else {
					h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv138), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys137)
		} // end switch yys137
	} // end for yyj137
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj140 int
	var yyb140 bool
	var yyhl140 bool = l >= 0
	yyj140++
	if yyhl140 {
		yyb140 = yyj140 > l
	} else {
		yyb140 = r.CheckBreak()
	}
	if yyb140 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv141 := &x.Items
		yym142 := z.DecBinary()
		_ = yym142
		if false {
		} else {
			h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv141), d)
		}
	}
	for {
		yyj140++
		if yyhl140 {
			yyb140 = yyj140 > l
		} else {
			yyb140 = r.CheckBreak()
		}
		if yyb140 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj140-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym143 := z.EncBinary()
		_ = yym143
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep144 := !z.EncBinary()
			yy2arr144 := z.EncBasicHandle().StructToArray
			var yyq144 [5]bool
			_, _, _ = yysep144, yyq144, yy2arr144
			const yyr144 bool = false
			yyq144[0] = x.Kind != ""
			yyq144[1] = x.APIVersion != ""
			yyq144[2] = true
			yyq144[3] = x.Description != ""
			yyq144[4] = len(x.Versions) != 0
			var yynn144 int
			if yyr144 || yy2arr144 {
				r.EncodeArrayStart(5)
			} else {
				yynn144 = 0
				for _, b := range yyq144 {
					if b {
						yynn144++
					}
				}
				r.EncodeMapStart(yynn144)
				yynn144 = 0
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[0] {
					yym146 := z.EncBinary()
					_ = yym146
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym147 := z.EncBinary()
					_ = yym147
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[1] {
					yym149 := z.EncBinary()
					_ = yym149
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym150 := z.EncBinary()
					_ = yym150
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[2] {
					yy152 := &x.ObjectMeta
					yy152.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy153 := &x.ObjectMeta
					yy153.CodecEncodeSelf(e)
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[3] {
					yym155 := z.EncBinary()
					_ = yym155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym158 := z.EncBinary()
						_ = yym158
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym159 := z.EncBinary()
						_ = yym159
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym160 := z.DecBinary()
	_ = yym160
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct161 := r.ContainerType()
		if yyct161 == codecSelferValueTypeMap1234 {
			yyl161 := r.ReadMapStart()
			if yyl161 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl161, d)
			}
		} else if yyct161 == codecSelferValueTypeArray1234 {
			yyl161 := r.ReadArrayStart()
			if yyl161 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl161, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys162Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys162Slc
	var yyhl162 bool = l >= 0
	for yyj162 := 0; ; yyj162++ {
		if yyhl162 {
			if yyj162 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys162Slc = r.DecodeBytes(yys162Slc, true, true)
		yys162 := string(yys162Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys162 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv165 := &x.ObjectMeta
				yyv165.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv167 := &x.Versions
				yym168 := z.DecBinary()
				_ = yym168
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv167), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys162)
		} // end switch yys162
	} // end for yyj162
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj169 int
	var yyb169 bool
	var yyhl169 bool = l >= 0
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv172 := &x.ObjectMeta
		yyv172.CodecDecodeSelf(d)
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv174 := &x.Versions
		yym175 := z.DecBinary()
		_ = yym175
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv174), d)
		}
	}
	for {
		yyj169++
		if yyhl169 {
			yyb169 = yyj169 > l
		} else {
			yyb169 = r.CheckBreak()
		}
		if yyb169 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj169-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym176 := z.EncBinary()
		_ = yym176
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep177 := !z.EncBinary()
			yy2arr177 := z.EncBasicHandle().StructToArray
			var yyq177 [4]bool
			_, _, _ = yysep177, yyq177, yy2arr177
			const yyr177 bool = false
			yyq177[0] = x.Kind != ""
			yyq177[1] = x.APIVersion != ""
			yyq177[2] = true
			var yynn177 int
			if yyr177 || yy2arr177 {
				r.EncodeArrayStart(4)
			} else {
				yynn177 = 1
				for _, b := range yyq177 {
					if b {
						yynn177++
					}
				}
				r.EncodeMapStart(yynn177)
				yynn177 = 0
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[0] {
					yym179 := z.EncBinary()
					_ = yym179
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq177[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym180 := z.EncBinary()
					_ = yym180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[1] {
					yym182 := z.EncBinary()
					_ = yym182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq177[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym183 := z.EncBinary()
					_ = yym183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[2] {
					yy185 := &x.ListMeta
					yym186 := z.EncBinary()
					_ = yym186
					if false {
					} else if z.HasExtensions() && z.EncExt(yy185) {
					} else {
						z.EncFallback(yy185)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq177[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy187 := &x.ListMeta
					yym188 := z.EncBinary()
					_ = yym188
					if false {
					} else if z.HasExtensions() && z.EncExt(yy187) {
					} else {
						z.EncFallback(yy187)
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym190 := z.EncBinary()
					_ = yym190
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym191 := z.EncBinary()
					_ = yym191
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym192 := z.DecBinary()
	_ = yym192
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct193 := r.ContainerType()
		if yyct193 == codecSelferValueTypeMap1234 {
			yyl193 := r.ReadMapStart()
			if yyl193 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl193, d)
			}
		} else if yyct193 == codecSelferValueTypeArray1234 {
			yyl193 := r.ReadArrayStart()
			if yyl193 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl193, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys194Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys194Slc
	var yyhl194 bool = l >= 0
	for yyj194 := 0; ; yyj194++ {
		if yyhl194 {
			if yyj194 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys194Slc = r.DecodeBytes(yys194Slc, true, true)
		yys194 := string(yys194Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys194 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv197 := &x.ListMeta
				yym198 := z.DecBinary()
				_ = yym198
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv197) {
				} else {
					z.DecFallback(yyv197, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv199 := &x.Items
				yym200 := z.DecBinary()
				_ = yym200
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv199), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys194)
		} // end switch yys194
	} // end for yyj194
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj201 int
	var yyb201 bool
	var yyhl201 bool = l >= 0
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv204 := &x.ListMeta
		yym205 := z.DecBinary()
		_ = yym205
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv204) {
		} else {
			z.DecFallback(yyv204, false)
		}
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv206 := &x.Items
		yym207 := z.DecBinary()
		_ = yym207
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv206), d)
		}
	}
	for {
		yyj201++
		if yyhl201 {
			yyb201 = yyj201 > l
		} else {
			yyb201 = r.CheckBreak()
		}
		if yyb201 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj201-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym208 := z.EncBinary()
		_ = yym208
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep209 := !z.EncBinary()
			yy2arr209 := z.EncBasicHandle().StructToArray
			var yyq209 [1]bool
			_, _, _ = yysep209, yyq209, yy2arr209
			const yyr209 bool = false
			yyq209[0] = x.Name != ""
			var yynn209 int
			if yyr209 || yy2arr209 {
				r.EncodeArrayStart(1)
			} else {
				yynn209 = 0
				for _, b := range yyq209 {
					if b {
						yynn209++
					}
				}
				r.EncodeMapStart(yynn209)
				yynn209 = 0
			}
			if yyr209 || yy2arr209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq209[0] {
					yym211 := z.EncBinary()
					_ = yym211
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq209[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym212 := z.EncBinary()
					_ = yym212
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr209 || yy2arr209 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym213 := z.DecBinary()
	_ = yym213
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct214 := r.ContainerType()
		if yyct214 == codecSelferValueTypeMap1234 {
			yyl214 := r.ReadMapStart()
			if yyl214 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl214, d)
			}
		} else if yyct214 == codecSelferValueTypeArray1234 {
			yyl214 := r.ReadArrayStart()
			if yyl214 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl214, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys215Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys215Slc
	var yyhl215 bool = l >= 0
	for yyj215 := 0; ; yyj215++ {
		if yyhl215 {
			if yyj215 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys215Slc = r.DecodeBytes(yys215Slc, true, true)
		yys215 := string(yys215Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys215 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys215)
		} // end switch yys215
	} // end for yyj215
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj217 int
	var yyb217 bool
	var yyhl217 bool = l >= 0
	yyj217++
	if yyhl217 {
		yyb217 = yyj217 > l
	} else {
		yyb217 = r.CheckBreak()
	}
	if yyb217 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj217++
		if yyhl217 {
			yyb217 = yyj217 > l
		} else {
			yyb217 = r.CheckBreak()
		}
		if yyb217 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj217-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym219 := z.EncBinary()
		_ = yym219
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep220 := !z.EncBinary()
			yy2arr220 := z.EncBasicHandle().StructToArray
			var yyq220 [4]bool
			_, _, _ = yysep220, yyq220, yy2arr220
			const yyr220 bool = false
			yyq220[0] = x.Kind != ""
			yyq220[1] = x.APIVersion != ""
			yyq220[2] = true
			yyq220[3] = len(x.Data) != 0
			var yynn220 int
			if yyr220 || yy2arr220 {
				r.EncodeArrayStart(4)
			} else {
				yynn220 = 0
				for _, b := range yyq220 {
					if b {
						yynn220++
					}
				}
				r.EncodeMapStart(yynn220)
				yynn220 = 0
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[0] {
					yym222 := z.EncBinary()
					_ = yym222
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq220[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym223 := z.EncBinary()
					_ = yym223
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[1] {
					yym225 := z.EncBinary()
					_ = yym225
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq220[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym226 := z.EncBinary()
					_ = yym226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[2] {
					yy228 := &x.ObjectMeta
					yy228.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq220[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy229 := &x.ObjectMeta
					yy229.CodecEncodeSelf(e)
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym231 := z.EncBinary()
						_ = yym231
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq220[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym232 := z.EncBinary()
						_ = yym232
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym233 := z.DecBinary()
	_ = yym233
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct234 := r.ContainerType()
		if yyct234 == codecSelferValueTypeMap1234 {
			yyl234 := r.ReadMapStart()
			if yyl234 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl234, d)
			}
		} else if yyct234 == codecSelferValueTypeArray1234 {
			yyl234 := r.ReadArrayStart()
			if yyl234 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl234, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys235Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys235Slc
	var yyhl235 bool = l >= 0
	for yyj235 := 0; ; yyj235++ {
		if yyhl235 {
			if yyj235 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys235Slc = r.DecodeBytes(yys235Slc, true, true)
		yys235 := string(yys235Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys235 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv238 := &x.ObjectMeta
				yyv238.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv239 := &x.Data
				yym240 := z.DecBinary()
				_ = yym240
				if false {
				} else {
					*yyv239 = r.DecodeBytes(*(*[]byte)(yyv239), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys235)
		} // end switch yys235
	} // end for yyj235
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj241 int
	var yyb241 bool
	var yyhl241 bool = l >= 0
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv244 := &x.ObjectMeta
		yyv244.CodecDecodeSelf(d)
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv245 := &x.Data
		yym246 := z.DecBinary()
		_ = yym246
		if false {
		} else {
			*yyv245 = r.DecodeBytes(*(*[]byte)(yyv245), false, false)
		}
	}
	for {
		yyj241++
		if yyhl241 {
			yyb241 = yyj241 > l
		} else {
			yyb241 = r.CheckBreak()
		}
		if yyb241 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj241-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym247 := z.EncBinary()
		_ = yym247
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep248 := !z.EncBinary()
			yy2arr248 := z.EncBasicHandle().StructToArray
			var yyq248 [5]bool
			_, _, _ = yysep248, yyq248, yy2arr248
			const yyr248 bool = false
			yyq248[0] = x.Kind != ""
			yyq248[1] = x.APIVersion != ""
			yyq248[2] = true
			yyq248[3] = true
			yyq248[4] = true
			var yynn248 int
			if yyr248 || yy2arr248 {
				r.EncodeArrayStart(5)
			} else {
				yynn248 = 0
				for _, b := range yyq248 {
					if b {
						yynn248++
					}
				}
				r.EncodeMapStart(yynn248)
				yynn248 = 0
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[0] {
					yym250 := z.EncBinary()
					_ = yym250
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq248[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym251 := z.EncBinary()
					_ = yym251
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[1] {
					yym253 := z.EncBinary()
					_ = yym253
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq248[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym254 := z.EncBinary()
					_ = yym254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[2] {
					yy256 := &x.ObjectMeta
					yy256.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy257 := &x.ObjectMeta
					yy257.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[3] {
					yy259 := &x.Spec
					yy259.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy260 := &x.Spec
					yy260.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[4] {
					yy262 := &x.Status
					yy262.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy263 := &x.Status
					yy263.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym264 := z.DecBinary()
	_ = yym264
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct265 := r.ContainerType()
		if yyct265 == codecSelferValueTypeMap1234 {
			yyl265 := r.ReadMapStart()
			if yyl265 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl265, d)
			}
		} else if yyct265 == codecSelferValueTypeArray1234 {
			yyl265 := r.ReadArrayStart()
			if yyl265 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl265, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys266Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys266Slc
	var yyhl266 bool = l >= 0
	for yyj266 := 0; ; yyj266++ {
		if yyhl266 {
			if yyj266 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys266Slc = r.DecodeBytes(yys266Slc, true, true)
		yys266 := string(yys266Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys266 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv269 := &x.ObjectMeta
				yyv269.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv270 := &x.Spec
				yyv270.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv271 := &x.Status
				yyv271.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys266)
		} // end switch yys266
	} // end for yyj266
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj272 int
	var yyb272 bool
	var yyhl272 bool = l >= 0
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv275 := &x.ObjectMeta
		yyv275.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv276 := &x.Spec
		yyv276.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv277 := &x.Status
		yyv277.CodecDecodeSelf(d)
	}
	for {
		yyj272++
		if yyhl272 {
			yyb272 = yyj272 > l
		} else {
			yyb272 = r.CheckBreak()
		}
		if yyb272 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj272-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym278 := z.EncBinary()
		_ = yym278
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep279 := !z.EncBinary()
			yy2arr279 := z.EncBasicHandle().StructToArray
			var yyq279 [8]bool
			_, _, _ = yysep279, yyq279, yy2arr279
			const yyr279 bool = false
			yyq279[0] = x.Replicas != 0
			yyq279[1] = x.Selector != nil
			yyq279[3] = true
			yyq279[4] = x.MinReadySeconds != 0
			yyq279[5] = x.RevisionHistoryLimit != nil
			yyq279[6] = x.Paused != false
			yyq279[7] = x.RollbackTo != nil
			var yynn279 int
			if yyr279 || yy2arr279 {
				r.EncodeArrayStart(8)
			} else {
				yynn279 = 1
				for _, b := range yyq279 {
					if b {
						yynn279++
					}
				}
				r.EncodeMapStart(yynn279)
				yynn279 = 0
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[0] {
					yym281 := z.EncBinary()
					_ = yym281
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq279[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym282 := z.EncBinary()
					_ = yym282
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym284 := z.EncBinary()
						_ = yym284
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym285 := z.EncBinary()
						_ = yym285
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy287 := &x.Template
				yy287.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy288 := &x.Template
				yy288.CodecEncodeSelf(e)
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[3] {
					yy290 := &x.Strategy
					yy290.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy291 := &x.Strategy
					yy291.CodecEncodeSelf(e)
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[4] {
					yym293 := z.EncBinary()
					_ = yym293
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq279[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[5] {
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy296 := *x.RevisionHistoryLimit
						yym297 := z.EncBinary()
						_ = yym297
						if false {
						} else {
							r.EncodeInt(int64(yy296))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revisionHistoryLimit"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy298 := *x.RevisionHistoryLimit
						yym299 := z.EncBinary()
						_ = yym299
						if false {
						} else {
							r.EncodeInt(int64(yy298))
						}
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[6] {
					yym301 := z.EncBinary()
					_ = yym301
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq279[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("paused"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym302 := z.EncBinary()
					_ = yym302
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[7] {
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym304 := z.DecBinary()
	_ = yym304
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct305 := r.ContainerType()
		if yyct305 == codecSelferValueTypeMap1234 {
			yyl305 := r.ReadMapStart()
			if yyl305 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl305, d)
			}
		} else if yyct305 == codecSelferValueTypeArray1234 {
			yyl305 := r.ReadArrayStart()
			if yyl305 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl305, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys306Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys306Slc
	var yyhl306 bool = l >= 0
	for yyj306 := 0; ; yyj306++ {
		if yyhl306 {
			if yyj306 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys306Slc = r.DecodeBytes(yys306Slc, true, true)
		yys306 := string(yys306Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys306 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym309 := z.DecBinary()
				_ = yym309
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv310 := &x.Template
				yyv310.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv311 := &x.Strategy
				yyv311.CodecDecodeSelf(d)
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "revisionHistoryLimit":
			if r.TryDecodeAsNil() {
				if x.RevisionHistoryLimit != nil {
					x.RevisionHistoryLimit = nil
				}
			} else {
				if x.RevisionHistoryLimit == nil {
					x.RevisionHistoryLimit = new(int32)
				}
				yym314 := z.DecBinary()
				_ = yym314
				if false {
				} else {
					*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
				}
			}
		case "paused":
			if r.TryDecodeAsNil() {
				x.Paused = false
			} else {
				x.Paused = bool(r.DecodeBool())
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				if x.RollbackTo != nil {
					x.RollbackTo = nil
				}
			} else {
				if x.RollbackTo == nil {
					x.RollbackTo = new(RollbackConfig)
				}
				x.RollbackTo.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys306)
		} // end switch yys306
	} // end for yyj306
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj317 int
	var yyb317 bool
	var yyhl317 bool = l >= 0
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym320 := z.DecBinary()
		_ = yym320
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv321 := &x.Template
		yyv321.CodecDecodeSelf(d)
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv322 := &x.Strategy
		yyv322.CodecDecodeSelf(d)
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RevisionHistoryLimit != nil {
			x.RevisionHistoryLimit = nil
		}
	} else {
		if x.RevisionHistoryLimit == nil {
			x.RevisionHistoryLimit = new(int32)
		}
		yym325 := z.DecBinary()
		_ = yym325
		if false {
		} else {
			*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
		}
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paused = false
	} else {
		x.Paused = bool(r.DecodeBool())
	}
	yyj317++
	if yyhl317 {
		yyb317 = yyj317 > l
	} else {
		yyb317 = r.CheckBreak()
	}
	if yyb317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollbackTo != nil {
			x.RollbackTo = nil
		}
	} else {
		if x.RollbackTo == nil {
			x.RollbackTo = new(RollbackConfig)
		}
		x.RollbackTo.CodecDecodeSelf(d)
	}
	for {
		yyj317++
		if yyhl317 {
			yyb317 = yyj317 > l
		} else {
			yyb317 = r.CheckBreak()
		}
		if yyb317 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj317-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentRollback) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym328 := z.EncBinary()
		_ = yym328
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep329 := !z.EncBinary()
			yy2arr329 := z.EncBasicHandle().StructToArray
			var yyq329 [5]bool
			_, _, _ = yysep329, yyq329, yy2arr329
			const yyr329 bool = false
			yyq329[0] = x.Kind != ""
			yyq329[1] = x.APIVersion != ""
			yyq329[3] = len(x.UpdatedAnnotations) != 0
			var yynn329 int
			if yyr329 || yy2arr329 {
				r.EncodeArrayStart(5)
			} else {
				yynn329 = 2
				for _, b := range yyq329 {
					if b {
						yynn329++
					}
				}
				r.EncodeMapStart(yynn329)
				yynn329 = 0
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[0] {
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym332 := z.EncBinary()
					_ = yym332
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[1] {
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym335 := z.EncBinary()
					_ = yym335
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym337 := z.EncBinary()
				_ = yym337
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym338 := z.EncBinary()
				_ = yym338
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[3] {
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym340 := z.EncBinary()
						_ = yym340
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedAnnotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym341 := z.EncBinary()
						_ = yym341
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy343 := &x.RollbackTo
				yy343.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy344 := &x.RollbackTo
				yy344.CodecEncodeSelf(e)
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentRollback) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym345 := z.DecBinary()
	_ = yym345
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct346 := r.ContainerType()
		if yyct346 == codecSelferValueTypeMap1234 {
			yyl346 := r.ReadMapStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl346, d)
			}
		} else if yyct346 == codecSelferValueTypeArray1234 {
			yyl346 := r.ReadArrayStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl346, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentRollback) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys347Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys347Slc
	var yyhl347 bool = l >= 0
	for yyj347 := 0; ; yyj347++ {
		if yyhl347 {
			if yyj347 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys347Slc = r.DecodeBytes(yys347Slc, true, true)
		yys347 := string(yys347Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys347 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "updatedAnnotations":
			if r.TryDecodeAsNil() {
				x.UpdatedAnnotations = nil
			} else {
				yyv351 := &x.UpdatedAnnotations
				yym352 := z.DecBinary()
				_ = yym352
				if false {
				} else {
					z.F.DecMapStringStringX(yyv351, false, d)
				}
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				x.RollbackTo = RollbackConfig{}
			} else {
				yyv353 := &x.RollbackTo
				yyv353.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys347)
		} // end switch yys347
	} // end for yyj347
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentRollback) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj354 int
	var yyb354 bool
	var yyhl354 bool = l >= 0
	yyj354++
	if yyhl354 {
		yyb354 = yyj354 > l
	} else {
		yyb354 = r.CheckBreak()
	}
	if yyb354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj354++
	if yyhl354 {
		yyb354 = yyj354 > l
	} else {
		yyb354 = r.CheckBreak()
	}
	if yyb354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj354++
	if yyhl354 {
		yyb354 = yyj354 > l
	} else {
		yyb354 = r.CheckBreak()
	}
	if yyb354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj354++
	if yyhl354 {
		yyb354 = yyj354 > l
	} else {
		yyb354 = r.CheckBreak()
	}
	if yyb354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedAnnotations = nil
	} else {
		yyv358 := &x.UpdatedAnnotations
		yym359 := z.DecBinary()
		_ = yym359
		if false {
		} else {
			z.F.DecMapStringStringX(yyv358, false, d)
		}
	}
	yyj354++
	if yyhl354 {
		yyb354 = yyj354 > l
	} else {
		yyb354 = r.CheckBreak()
	}
	if yyb354 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RollbackTo = RollbackConfig{}
	} else {
		yyv360 := &x.RollbackTo
		yyv360.CodecDecodeSelf(d)
	}
	for {
		yyj354++
		if yyhl354 {
			yyb354 = yyj354 > l
		} else {
			yyb354 = r.CheckBreak()
		}
		if yyb354 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj354-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RollbackConfig) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym361 := z.EncBinary()
		_ = yym361
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep362 := !z.EncBinary()
			yy2arr362 := z.EncBasicHandle().StructToArray
			var yyq362 [1]bool
			_, _, _ = yysep362, yyq362, yy2arr362
			const yyr362 bool = false
			yyq362[0] = x.Revision != 0
			var yynn362 int
			if yyr362 || yy2arr362 {
				r.EncodeArrayStart(1)
			} else {
				yynn362 = 0
				for _, b := range yyq362 {
					if b {
						yynn362++
					}
				}
				r.EncodeMapStart(yynn362)
				yynn362 = 0
			}
			if yyr362 || yy2arr362 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq362[0] {
					yym364 := z.EncBinary()
					_ = yym364
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq362[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym365 := z.EncBinary()
					_ = yym365
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				}
			}
			if yyr362 || yy2arr362 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollbackConfig) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym366 := z.DecBinary()
	_ = yym366
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct367 := r.ContainerType()
		if yyct367 == codecSelferValueTypeMap1234 {
			yyl367 := r.ReadMapStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl367, d)
			}
		} else if yyct367 == codecSelferValueTypeArray1234 {
			yyl367 := r.ReadArrayStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl367, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollbackConfig) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys368Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys368Slc
	var yyhl368 bool = l >= 0
	for yyj368 := 0; ; yyj368++ {
		if yyhl368 {
			if yyj368 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys368Slc = r.DecodeBytes(yys368Slc, true, true)
		yys368 := string(yys368Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys368 {
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = 0
			} else {
				x.Revision = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys368)
		} // end switch yys368
	} // end for yyj368
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollbackConfig) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj370 int
	var yyb370 bool
	var yyhl370 bool = l >= 0
	yyj370++
	if yyhl370 {
		yyb370 = yyj370 > l
	} else {
		yyb370 = r.CheckBreak()
	}
	if yyb370 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = 0
	} else {
		x.Revision = int64(r.DecodeInt(64))
	}
	for {
		yyj370++
		if yyhl370 {
			yyb370 = yyj370 > l
		} else {
			yyb370 = r.CheckBreak()
		}
		if yyb370 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj370-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym372 := z.EncBinary()
		_ = yym372
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep373 := !z.EncBinary()
			yy2arr373 := z.EncBasicHandle().StructToArray
			var yyq373 [2]bool
			_, _, _ = yysep373, yyq373, yy2arr373
			const yyr373 bool = false
			yyq373[0] = x.Type != ""
			yyq373[1] = x.RollingUpdate != nil
			var yynn373 int
			if yyr373 || yy2arr373 {
				r.EncodeArrayStart(2)
			} else {
				yynn373 = 0
				for _, b := range yyq373 {
					if b {
						yynn373++
					}
				}
				r.EncodeMapStart(yynn373)
				yynn373 = 0
			}
			if yyr373 || yy2arr373 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq373[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq373[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr373 || yy2arr373 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq373[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq373[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr373 || yy2arr373 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym376 := z.DecBinary()
	_ = yym376
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct377 := r.ContainerType()
		if yyct377 == codecSelferValueTypeMap1234 {
			yyl377 := r.ReadMapStart()
			if yyl377 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl377, d)
			}
		} else if yyct377 == codecSelferValueTypeArray1234 {
			yyl377 := r.ReadArrayStart()
			if yyl377 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl377, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys378Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys378Slc
	var yyhl378 bool = l >= 0
	for yyj378 := 0; ; yyj378++ {
		if yyhl378 {
			if yyj378 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys378Slc = r.DecodeBytes(yys378Slc, true, true)
		yys378 := string(yys378Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys378 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys378)
		} // end switch yys378
	} // end for yyj378
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj381 int
	var yyb381 bool
	var yyhl381 bool = l >= 0
	yyj381++
	if yyhl381 {
		yyb381 = yyj381 > l
	} else {
		yyb381 = r.CheckBreak()
	}
	if yyb381 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj381++
	if yyhl381 {
		yyb381 = yyj381 > l
	} else {
		yyb381 = r.CheckBreak()
	}
	if yyb381 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj381++
		if yyhl381 {
			yyb381 = yyj381 > l
		} else {
			yyb381 = r.CheckBreak()
		}
		if yyb381 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj381-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym384 := z.EncBinary()
	_ = yym384
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym385 := z.DecBinary()
	_ = yym385
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym386 := z.EncBinary()
		_ = yym386
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep387 := !z.EncBinary()
			yy2arr387 := z.EncBasicHandle().StructToArray
			var yyq387 [2]bool
			_, _, _ = yysep387, yyq387, yy2arr387
			const yyr387 bool = false
			yyq387[0] = true
			yyq387[1] = true
			var yynn387 int
			if yyr387 || yy2arr387 {
				r.EncodeArrayStart(2)
			} else {
				yynn387 = 0
				for _, b := range yyq387 {
					if b {
						yynn387++
					}
				}
				r.EncodeMapStart(yynn387)
				yynn387 = 0
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[0] {
					yy389 := &x.MaxUnavailable
					yym390 := z.EncBinary()
					_ = yym390
					if false {
					} else if z.HasExtensions() && z.EncExt(yy389) {
					} else if !yym390 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy389)
					} else {
						z.EncFallback(yy389)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy391 := &x.MaxUnavailable
					yym392 := z.EncBinary()
					_ = yym392
					if false {
					} else if z.HasExtensions() && z.EncExt(yy391) {
					} else if !yym392 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy391)
					} else {
						z.EncFallback(yy391)
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq387[1] {
					yy394 := &x.MaxSurge
					yym395 := z.EncBinary()
					_ = yym395
					if false {
					} else if z.HasExtensions() && z.EncExt(yy394) {
					} else if !yym395 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy394)
					} else {
						z.EncFallback(yy394)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq387[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy396 := &x.MaxSurge
					yym397 := z.EncBinary()
					_ = yym397
					if false {
					} else if z.HasExtensions() && z.EncExt(yy396) {
					} else if !yym397 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy396)
					} else {
						z.EncFallback(yy396)
					}
				}
			}
			if yyr387 || yy2arr387 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym398 := z.DecBinary()
	_ = yym398
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct399 := r.ContainerType()
		if yyct399 == codecSelferValueTypeMap1234 {
			yyl399 := r.ReadMapStart()
			if yyl399 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl399, d)
			}
		} else if yyct399 == codecSelferValueTypeArray1234 {
			yyl399 := r.ReadArrayStart()
			if yyl399 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl399, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys400Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys400Slc
	var yyhl400 bool = l >= 0
	for yyj400 := 0; ; yyj400++ {
		if yyhl400 {
			if yyj400 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys400Slc = r.DecodeBytes(yys400Slc, true, true)
		yys400 := string(yys400Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys400 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				x.MaxUnavailable = pkg5_intstr.IntOrString{}
			} else {
				yyv401 := &x.MaxUnavailable
				yym402 := z.DecBinary()
				_ = yym402
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv401) {
				} else if !yym402 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv401)
				} else {
					z.DecFallback(yyv401, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				x.MaxSurge = pkg5_intstr.IntOrString{}
			} else {
				yyv403 := &x.MaxSurge
				yym404 := z.DecBinary()
				_ = yym404
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv403) {
				} else if !yym404 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv403)
				} else {
					z.DecFallback(yyv403, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys400)
		} // end switch yys400
	} // end for yyj400
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj405 int
	var yyb405 bool
	var yyhl405 bool = l >= 0
	yyj405++
	if yyhl405 {
		yyb405 = yyj405 > l
	} else {
		yyb405 = r.CheckBreak()
	}
	if yyb405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxUnavailable = pkg5_intstr.IntOrString{}
	} else {
		yyv406 := &x.MaxUnavailable
		yym407 := z.DecBinary()
		_ = yym407
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv406) {
		} else if !yym407 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv406)
		} else {
			z.DecFallback(yyv406, false)
		}
	}
	yyj405++
	if yyhl405 {
		yyb405 = yyj405 > l
	} else {
		yyb405 = r.CheckBreak()
	}
	if yyb405 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxSurge = pkg5_intstr.IntOrString{}
	} else {
		yyv408 := &x.MaxSurge
		yym409 := z.DecBinary()
		_ = yym409
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv408) {
		} else if !yym409 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv408)
		} else {
			z.DecFallback(yyv408, false)
		}
	}
	for {
		yyj405++
		if yyhl405 {
			yyb405 = yyj405 > l
		} else {
			yyb405 = r.CheckBreak()
		}
		if yyb405 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj405-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym410 := z.EncBinary()
		_ = yym410
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep411 := !z.EncBinary()
			yy2arr411 := z.EncBasicHandle().StructToArray
			var yyq411 [5]bool
			_, _, _ = yysep411, yyq411, yy2arr411
			const yyr411 bool = false
			yyq411[0] = x.ObservedGeneration != 0
			yyq411[1] = x.Replicas != 0
			yyq411[2] = x.UpdatedReplicas != 0
			yyq411[3] = x.AvailableReplicas != 0
			yyq411[4] = x.UnavailableReplicas != 0
			var yynn411 int
			if yyr411 || yy2arr411 {
				r.EncodeArrayStart(5)
			} else {
				yynn411 = 0
				for _, b := range yyq411 {
					if b {
						yynn411++
					}
				}
				r.EncodeMapStart(yynn411)
				yynn411 = 0
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq411[0] {
					yym413 := z.EncBinary()
					_ = yym413
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq411[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym414 := z.EncBinary()
					_ = yym414
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq411[1] {
					yym416 := z.EncBinary()
					_ = yym416
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq411[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym417 := z.EncBinary()
					_ = yym417
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq411[2] {
					yym419 := z.EncBinary()
					_ = yym419
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq411[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym420 := z.EncBinary()
					_ = yym420
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq411[3] {
					yym422 := z.EncBinary()
					_ = yym422
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq411[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym423 := z.EncBinary()
					_ = yym423
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq411[4] {
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq411[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unavailableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				}
			}
			if yyr411 || yy2arr411 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym427 := z.DecBinary()
	_ = yym427
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct428 := r.ContainerType()
		if yyct428 == codecSelferValueTypeMap1234 {
			yyl428 := r.ReadMapStart()
			if yyl428 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl428, d)
			}
		} else if yyct428 == codecSelferValueTypeArray1234 {
			yyl428 := r.ReadArrayStart()
			if yyl428 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl428, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys429Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys429Slc
	var yyhl429 bool = l >= 0
	for yyj429 := 0; ; yyj429++ {
		if yyhl429 {
			if yyj429 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys429Slc = r.DecodeBytes(yys429Slc, true, true)
		yys429 := string(yys429Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys429 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "unavailableReplicas":
			if r.TryDecodeAsNil() {
				x.UnavailableReplicas = 0
			} else {
				x.UnavailableReplicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys429)
		} // end switch yys429
	} // end for yyj429
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj435 int
	var yyb435 bool
	var yyhl435 bool = l >= 0
	yyj435++
	if yyhl435 {
		yyb435 = yyj435 > l
	} else {
		yyb435 = r.CheckBreak()
	}
	if yyb435 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj435++
	if yyhl435 {
		yyb435 = yyj435 > l
	} else {
		yyb435 = r.CheckBreak()
	}
	if yyb435 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj435++
	if yyhl435 {
		yyb435 = yyj435 > l
	} else {
		yyb435 = r.CheckBreak()
	}
	if yyb435 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int32(r.DecodeInt(32))
	}
	yyj435++
	if yyhl435 {
		yyb435 = yyj435 > l
	} else {
		yyb435 = r.CheckBreak()
	}
	if yyb435 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj435++
	if yyhl435 {
		yyb435 = yyj435 > l
	} else {
		yyb435 = r.CheckBreak()
	}
	if yyb435 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnavailableReplicas = 0
	} else {
		x.UnavailableReplicas = int32(r.DecodeInt(32))
	}
	for {
		yyj435++
		if yyhl435 {
			yyb435 = yyj435 > l
		} else {
			yyb435 = r.CheckBreak()
		}
		if yyb435 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj435-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym441 := z.EncBinary()
		_ = yym441
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep442 := !z.EncBinary()
			yy2arr442 := z.EncBasicHandle().StructToArray
			var yyq442 [4]bool
			_, _, _ = yysep442, yyq442, yy2arr442
			const yyr442 bool = false
			yyq442[0] = x.Kind != ""
			yyq442[1] = x.APIVersion != ""
			yyq442[2] = true
			var yynn442 int
			if yyr442 || yy2arr442 {
				r.EncodeArrayStart(4)
			} else {
				yynn442 = 1
				for _, b := range yyq442 {
					if b {
						yynn442++
					}
				}
				r.EncodeMapStart(yynn442)
				yynn442 = 0
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[0] {
					yym444 := z.EncBinary()
					_ = yym444
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[1] {
					yym447 := z.EncBinary()
					_ = yym447
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq442[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq442[2] {
					yy450 := &x.ListMeta
					yym451 := z.EncBinary()
					_ = yym451
					if false {
					} else if z.HasExtensions() && z.EncExt(yy450) {
					} else {
						z.EncFallback(yy450)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq442[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy452 := &x.ListMeta
					yym453 := z.EncBinary()
					_ = yym453
					if false {
					} else if z.HasExtensions() && z.EncExt(yy452) {
					} else {
						z.EncFallback(yy452)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym455 := z.EncBinary()
					_ = yym455
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr442 || yy2arr442 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym457 := z.DecBinary()
	_ = yym457
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct458 := r.ContainerType()
		if yyct458 == codecSelferValueTypeMap1234 {
			yyl458 := r.ReadMapStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl458, d)
			}
		} else if yyct458 == codecSelferValueTypeArray1234 {
			yyl458 := r.ReadArrayStart()
			if yyl458 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl458, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys459Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys459Slc
	var yyhl459 bool = l >= 0
	for yyj459 := 0; ; yyj459++ {
		if yyhl459 {
			if yyj459 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys459Slc = r.DecodeBytes(yys459Slc, true, true)
		yys459 := string(yys459Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys459 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv462 := &x.ListMeta
				yym463 := z.DecBinary()
				_ = yym463
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv462) {
				} else {
					z.DecFallback(yyv462, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv464 := &x.Items
				yym465 := z.DecBinary()
				_ = yym465
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv464), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys459)
		} // end switch yys459
	} // end for yyj459
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj466 int
	var yyb466 bool
	var yyhl466 bool = l >= 0
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv469 := &x.ListMeta
		yym470 := z.DecBinary()
		_ = yym470
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv469) {
		} else {
			z.DecFallback(yyv469, false)
		}
	}
	yyj466++
	if yyhl466 {
		yyb466 = yyj466 > l
	} else {
		yyb466 = r.CheckBreak()
	}
	if yyb466 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv471 := &x.Items
		yym472 := z.DecBinary()
		_ = yym472
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv471), d)
		}
	}
	for {
		yyj466++
		if yyhl466 {
			yyb466 = yyj466 > l
		} else {
			yyb466 = r.CheckBreak()
		}
		if yyb466 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj466-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym473 := z.EncBinary()
		_ = yym473
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep474 := !z.EncBinary()
			yy2arr474 := z.EncBasicHandle().StructToArray
			var yyq474 [2]bool
			_, _, _ = yysep474, yyq474, yy2arr474
			const yyr474 bool = false
			yyq474[0] = x.Selector != nil
			var yynn474 int
			if yyr474 || yy2arr474 {
				r.EncodeArrayStart(2)
			} else {
				yynn474 = 1
				for _, b := range yyq474 {
					if b {
						yynn474++
					}
				}
				r.EncodeMapStart(yynn474)
				yynn474 = 0
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq474[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym476 := z.EncBinary()
						_ = yym476
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq474[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym477 := z.EncBinary()
						_ = yym477
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy479 := &x.Template
				yy479.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy480 := &x.Template
				yy480.CodecEncodeSelf(e)
			}
			if yyr474 || yy2arr474 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym481 := z.DecBinary()
	_ = yym481
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct482 := r.ContainerType()
		if yyct482 == codecSelferValueTypeMap1234 {
			yyl482 := r.ReadMapStart()
			if yyl482 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl482, d)
			}
		} else if yyct482 == codecSelferValueTypeArray1234 {
			yyl482 := r.ReadArrayStart()
			if yyl482 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl482, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys483Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys483Slc
	var yyhl483 bool = l >= 0
	for yyj483 := 0; ; yyj483++ {
		if yyhl483 {
			if yyj483 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys483Slc = r.DecodeBytes(yys483Slc, true, true)
		yys483 := string(yys483Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys483 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym485 := z.DecBinary()
				_ = yym485
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv486 := &x.Template
				yyv486.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys483)
		} // end switch yys483
	} // end for yyj483
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj487 int
	var yyb487 bool
	var yyhl487 bool = l >= 0
	yyj487++
	if yyhl487 {
		yyb487 = yyj487 > l
	} else {
		yyb487 = r.CheckBreak()
	}
	if yyb487 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym489 := z.DecBinary()
		_ = yym489
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj487++
	if yyhl487 {
		yyb487 = yyj487 > l
	} else {
		yyb487 = r.CheckBreak()
	}
	if yyb487 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv490 := &x.Template
		yyv490.CodecDecodeSelf(d)
	}
	for {
		yyj487++
		if yyhl487 {
			yyb487 = yyj487 > l
		} else {
			yyb487 = r.CheckBreak()
		}
		if yyb487 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj487-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym491 := z.EncBinary()
		_ = yym491
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep492 := !z.EncBinary()
			yy2arr492 := z.EncBasicHandle().StructToArray
			var yyq492 [3]bool
			_, _, _ = yysep492, yyq492, yy2arr492
			const yyr492 bool = false
			var yynn492 int
			if yyr492 || yy2arr492 {
				r.EncodeArrayStart(3)
			} else {
				yynn492 = 3
				for _, b := range yyq492 {
					if b {
						yynn492++
					}
				}
				r.EncodeMapStart(yynn492)
				yynn492 = 0
			}
			if yyr492 || yy2arr492 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym494 := z.EncBinary()
				_ = yym494
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym495 := z.EncBinary()
				_ = yym495
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr492 || yy2arr492 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym497 := z.EncBinary()
				_ = yym497
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym498 := z.EncBinary()
				_ = yym498
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr492 || yy2arr492 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym500 := z.EncBinary()
				_ = yym500
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym501 := z.EncBinary()
				_ = yym501
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr492 || yy2arr492 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym502 := z.DecBinary()
	_ = yym502
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct503 := r.ContainerType()
		if yyct503 == codecSelferValueTypeMap1234 {
			yyl503 := r.ReadMapStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl503, d)
			}
		} else if yyct503 == codecSelferValueTypeArray1234 {
			yyl503 := r.ReadArrayStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl503, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys504Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys504Slc
	var yyhl504 bool = l >= 0
	for yyj504 := 0; ; yyj504++ {
		if yyhl504 {
			if yyj504 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys504Slc = r.DecodeBytes(yys504Slc, true, true)
		yys504 := string(yys504Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys504 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int32(r.DecodeInt(32))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys504)
		} // end switch yys504
	} // end for yyj504
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj508 int
	var yyb508 bool
	var yyhl508 bool = l >= 0
	yyj508++
	if yyhl508 {
		yyb508 = yyj508 > l
	} else {
		yyb508 = r.CheckBreak()
	}
	if yyb508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj508++
	if yyhl508 {
		yyb508 = yyj508 > l
	} else {
		yyb508 = r.CheckBreak()
	}
	if yyb508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int32(r.DecodeInt(32))
	}
	yyj508++
	if yyhl508 {
		yyb508 = yyj508 > l
	} else {
		yyb508 = r.CheckBreak()
	}
	if yyb508 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int32(r.DecodeInt(32))
	}
	for {
		yyj508++
		if yyhl508 {
			yyb508 = yyj508 > l
		} else {
			yyb508 = r.CheckBreak()
		}
		if yyb508 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj508-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym512 := z.EncBinary()
		_ = yym512
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep513 := !z.EncBinary()
			yy2arr513 := z.EncBasicHandle().StructToArray
			var yyq513 [5]bool
			_, _, _ = yysep513, yyq513, yy2arr513
			const yyr513 bool = false
			yyq513[0] = x.Kind != ""
			yyq513[1] = x.APIVersion != ""
			yyq513[2] = true
			yyq513[3] = true
			yyq513[4] = true
			var yynn513 int
			if yyr513 || yy2arr513 {
				r.EncodeArrayStart(5)
			} else {
				yynn513 = 0
				for _, b := range yyq513 {
					if b {
						yynn513++
					}
				}
				r.EncodeMapStart(yynn513)
				yynn513 = 0
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq513[0] {
					yym515 := z.EncBinary()
					_ = yym515
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq513[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym516 := z.EncBinary()
					_ = yym516
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq513[1] {
					yym518 := z.EncBinary()
					_ = yym518
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq513[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq513[2] {
					yy521 := &x.ObjectMeta
					yy521.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq513[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy522 := &x.ObjectMeta
					yy522.CodecEncodeSelf(e)
				}
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq513[3] {
					yy524 := &x.Spec
					yy524.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq513[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy525 := &x.Spec
					yy525.CodecEncodeSelf(e)
				}
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq513[4] {
					yy527 := &x.Status
					yy527.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq513[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy528 := &x.Status
					yy528.CodecEncodeSelf(e)
				}
			}
			if yyr513 || yy2arr513 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym529 := z.DecBinary()
	_ = yym529
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct530 := r.ContainerType()
		if yyct530 == codecSelferValueTypeMap1234 {
			yyl530 := r.ReadMapStart()
			if yyl530 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl530, d)
			}
		} else if yyct530 == codecSelferValueTypeArray1234 {
			yyl530 := r.ReadArrayStart()
			if yyl530 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl530, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys531Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys531Slc
	var yyhl531 bool = l >= 0
	for yyj531 := 0; ; yyj531++ {
		if yyhl531 {
			if yyj531 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys531Slc = r.DecodeBytes(yys531Slc, true, true)
		yys531 := string(yys531Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys531 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv534 := &x.ObjectMeta
				yyv534.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv535 := &x.Spec
				yyv535.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv536 := &x.Status
				yyv536.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys531)
		} // end switch yys531
	} // end for yyj531
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj537 int
	var yyb537 bool
	var yyhl537 bool = l >= 0
	yyj537++
	if yyhl537 {
		yyb537 = yyj537 > l
	} else {
		yyb537 = r.CheckBreak()
	}
	if yyb537 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj537++
	if yyhl537 {
		yyb537 = yyj537 > l
	} else {
		yyb537 = r.CheckBreak()
	}
	if yyb537 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj537++
	if yyhl537 {
		yyb537 = yyj537 > l
	} else {
		yyb537 = r.CheckBreak()
	}
	if yyb537 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv540 := &x.ObjectMeta
		yyv540.CodecDecodeSelf(d)
	}
	yyj537++
	if yyhl537 {
		yyb537 = yyj537 > l
	} else {
		yyb537 = r.CheckBreak()
	}
	if yyb537 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv541 := &x.Spec
		yyv541.CodecDecodeSelf(d)
	}
	yyj537++
	if yyhl537 {
		yyb537 = yyj537 > l
	} else {
		yyb537 = r.CheckBreak()
	}
	if yyb537 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv542 := &x.Status
		yyv542.CodecDecodeSelf(d)
	}
	for {
		yyj537++
		if yyhl537 {
			yyb537 = yyj537 > l
		} else {
			yyb537 = r.CheckBreak()
		}
		if yyb537 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj537-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym543 := z.EncBinary()
		_ = yym543
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep544 := !z.EncBinary()
			yy2arr544 := z.EncBasicHandle().StructToArray
			var yyq544 [4]bool
			_, _, _ = yysep544, yyq544, yy2arr544
			const yyr544 bool = false
			yyq544[0] = x.Kind != ""
			yyq544[1] = x.APIVersion != ""
			yyq544[2] = true
			var yynn544 int
			if yyr544 || yy2arr544 {
				r.EncodeArrayStart(4)
			} else {
				yynn544 = 1
				for _, b := range yyq544 {
					if b {
						yynn544++
					}
				}
				r.EncodeMapStart(yynn544)
				yynn544 = 0
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[0] {
					yym546 := z.EncBinary()
					_ = yym546
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq544[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym547 := z.EncBinary()
					_ = yym547
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[1] {
					yym549 := z.EncBinary()
					_ = yym549
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq544[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym550 := z.EncBinary()
					_ = yym550
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq544[2] {
					yy552 := &x.ListMeta
					yym553 := z.EncBinary()
					_ = yym553
					if false {
					} else if z.HasExtensions() && z.EncExt(yy552) {
					} else {
						z.EncFallback(yy552)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq544[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy554 := &x.ListMeta
					yym555 := z.EncBinary()
					_ = yym555
					if false {
					} else if z.HasExtensions() && z.EncExt(yy554) {
					} else {
						z.EncFallback(yy554)
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym557 := z.EncBinary()
					_ = yym557
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym558 := z.EncBinary()
					_ = yym558
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr544 || yy2arr544 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym559 := z.DecBinary()
	_ = yym559
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct560 := r.ContainerType()
		if yyct560 == codecSelferValueTypeMap1234 {
			yyl560 := r.ReadMapStart()
			if yyl560 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl560, d)
			}
		} else if yyct560 == codecSelferValueTypeArray1234 {
			yyl560 := r.ReadArrayStart()
			if yyl560 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl560, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys561Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys561Slc
	var yyhl561 bool = l >= 0
	for yyj561 := 0; ; yyj561++ {
		if yyhl561 {
			if yyj561 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys561Slc = r.DecodeBytes(yys561Slc, true, true)
		yys561 := string(yys561Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys561 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv564 := &x.ListMeta
				yym565 := z.DecBinary()
				_ = yym565
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv564) {
				} else {
					z.DecFallback(yyv564, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv566 := &x.Items
				yym567 := z.DecBinary()
				_ = yym567
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv566), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys561)
		} // end switch yys561
	} // end for yyj561
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj568 int
	var yyb568 bool
	var yyhl568 bool = l >= 0
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv571 := &x.ListMeta
		yym572 := z.DecBinary()
		_ = yym572
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv571) {
		} else {
			z.DecFallback(yyv571, false)
		}
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv573 := &x.Items
		yym574 := z.DecBinary()
		_ = yym574
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv573), d)
		}
	}
	for {
		yyj568++
		if yyhl568 {
			yyb568 = yyj568 > l
		} else {
			yyb568 = r.CheckBreak()
		}
		if yyb568 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj568-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym575 := z.EncBinary()
		_ = yym575
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep576 := !z.EncBinary()
			yy2arr576 := z.EncBasicHandle().StructToArray
			var yyq576 [4]bool
			_, _, _ = yysep576, yyq576, yy2arr576
			const yyr576 bool = false
			yyq576[0] = x.Kind != ""
			yyq576[1] = x.APIVersion != ""
			yyq576[2] = true
			var yynn576 int
			if yyr576 || yy2arr576 {
				r.EncodeArrayStart(4)
			} else {
				yynn576 = 1
				for _, b := range yyq576 {
					if b {
						yynn576++
					}
				}
				r.EncodeMapStart(yynn576)
				yynn576 = 0
			}
			if yyr576 || yy2arr576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq576[0] {
					yym578 := z.EncBinary()
					_ = yym578
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq576[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym579 := z.EncBinary()
					_ = yym579
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr576 || yy2arr576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq576[1] {
					yym581 := z.EncBinary()
					_ = yym581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq576[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym582 := z.EncBinary()
					_ = yym582
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr576 || yy2arr576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq576[2] {
					yy584 := &x.ListMeta
					yym585 := z.EncBinary()
					_ = yym585
					if false {
					} else if z.HasExtensions() && z.EncExt(yy584) {
					} else {
						z.EncFallback(yy584)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq576[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy586 := &x.ListMeta
					yym587 := z.EncBinary()
					_ = yym587
					if false {
					} else if z.HasExtensions() && z.EncExt(yy586) {
					} else {
						z.EncFallback(yy586)
					}
				}
			}
			if yyr576 || yy2arr576 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym589 := z.EncBinary()
					_ = yym589
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym590 := z.EncBinary()
					_ = yym590
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr576 || yy2arr576 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym591 := z.DecBinary()
	_ = yym591
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct592 := r.ContainerType()
		if yyct592 == codecSelferValueTypeMap1234 {
			yyl592 := r.ReadMapStart()
			if yyl592 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl592, d)
			}
		} else if yyct592 == codecSelferValueTypeArray1234 {
			yyl592 := r.ReadArrayStart()
			if yyl592 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl592, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys593Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys593Slc
	var yyhl593 bool = l >= 0
	for yyj593 := 0; ; yyj593++ {
		if yyhl593 {
			if yyj593 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys593Slc = r.DecodeBytes(yys593Slc, true, true)
		yys593 := string(yys593Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys593 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv596 := &x.ListMeta
				yym597 := z.DecBinary()
				_ = yym597
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv596) {
				} else {
					z.DecFallback(yyv596, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv598 := &x.Items
				yym599 := z.DecBinary()
				_ = yym599
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv598), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys593)
		} // end switch yys593
	} // end for yyj593
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj600 int
	var yyb600 bool
	var yyhl600 bool = l >= 0
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv603 := &x.ListMeta
		yym604 := z.DecBinary()
		_ = yym604
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv603) {
		} else {
			z.DecFallback(yyv603, false)
		}
	}
	yyj600++
	if yyhl600 {
		yyb600 = yyj600 > l
	} else {
		yyb600 = r.CheckBreak()
	}
	if yyb600 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv605 := &x.Items
		yym606 := z.DecBinary()
		_ = yym606
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv605), d)
		}
	}
	for {
		yyj600++
		if yyhl600 {
			yyb600 = yyj600 > l
		} else {
			yyb600 = r.CheckBreak()
		}
		if yyb600 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj600-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym607 := z.EncBinary()
		_ = yym607
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep608 := !z.EncBinary()
			yy2arr608 := z.EncBasicHandle().StructToArray
			var yyq608 [5]bool
			_, _, _ = yysep608, yyq608, yy2arr608
			const yyr608 bool = false
			yyq608[0] = x.Kind != ""
			yyq608[1] = x.APIVersion != ""
			yyq608[2] = true
			yyq608[3] = true
			yyq608[4] = true
			var yynn608 int
			if yyr608 || yy2arr608 {
				r.EncodeArrayStart(5)
			} else {
				yynn608 = 0
				for _, b := range yyq608 {
					if b {
						yynn608++
					}
				}
				r.EncodeMapStart(yynn608)
				yynn608 = 0
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq608[0] {
					yym610 := z.EncBinary()
					_ = yym610
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq608[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym611 := z.EncBinary()
					_ = yym611
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq608[1] {
					yym613 := z.EncBinary()
					_ = yym613
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq608[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym614 := z.EncBinary()
					_ = yym614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq608[2] {
					yy616 := &x.ObjectMeta
					yy616.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq608[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy617 := &x.ObjectMeta
					yy617.CodecEncodeSelf(e)
				}
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq608[3] {
					yy619 := &x.Spec
					yy619.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq608[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy620 := &x.Spec
					yy620.CodecEncodeSelf(e)
				}
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq608[4] {
					yy622 := &x.Status
					yy622.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq608[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy623 := &x.Status
					yy623.CodecEncodeSelf(e)
				}
			}
			if yyr608 || yy2arr608 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym624 := z.DecBinary()
	_ = yym624
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct625 := r.ContainerType()
		if yyct625 == codecSelferValueTypeMap1234 {
			yyl625 := r.ReadMapStart()
			if yyl625 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl625, d)
			}
		} else if yyct625 == codecSelferValueTypeArray1234 {
			yyl625 := r.ReadArrayStart()
			if yyl625 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl625, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys626Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys626Slc
	var yyhl626 bool = l >= 0
	for yyj626 := 0; ; yyj626++ {
		if yyhl626 {
			if yyj626 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys626Slc = r.DecodeBytes(yys626Slc, true, true)
		yys626 := string(yys626Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys626 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv629 := &x.ObjectMeta
				yyv629.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv630 := &x.Spec
				yyv630.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv631 := &x.Status
				yyv631.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys626)
		} // end switch yys626
	} // end for yyj626
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj632 int
	var yyb632 bool
	var yyhl632 bool = l >= 0
	yyj632++
	if yyhl632 {
		yyb632 = yyj632 > l
	} else {
		yyb632 = r.CheckBreak()
	}
	if yyb632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj632++
	if yyhl632 {
		yyb632 = yyj632 > l
	} else {
		yyb632 = r.CheckBreak()
	}
	if yyb632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj632++
	if yyhl632 {
		yyb632 = yyj632 > l
	} else {
		yyb632 = r.CheckBreak()
	}
	if yyb632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv635 := &x.ObjectMeta
		yyv635.CodecDecodeSelf(d)
	}
	yyj632++
	if yyhl632 {
		yyb632 = yyj632 > l
	} else {
		yyb632 = r.CheckBreak()
	}
	if yyb632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv636 := &x.Spec
		yyv636.CodecDecodeSelf(d)
	}
	yyj632++
	if yyhl632 {
		yyb632 = yyj632 > l
	} else {
		yyb632 = r.CheckBreak()
	}
	if yyb632 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv637 := &x.Status
		yyv637.CodecDecodeSelf(d)
	}
	for {
		yyj632++
		if yyhl632 {
			yyb632 = yyj632 > l
		} else {
			yyb632 = r.CheckBreak()
		}
		if yyb632 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj632-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym638 := z.EncBinary()
		_ = yym638
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep639 := !z.EncBinary()
			yy2arr639 := z.EncBasicHandle().StructToArray
			var yyq639 [4]bool
			_, _, _ = yysep639, yyq639, yy2arr639
			const yyr639 bool = false
			yyq639[0] = x.Kind != ""
			yyq639[1] = x.APIVersion != ""
			yyq639[2] = true
			var yynn639 int
			if yyr639 || yy2arr639 {
				r.EncodeArrayStart(4)
			} else {
				yynn639 = 1
				for _, b := range yyq639 {
					if b {
						yynn639++
					}
				}
				r.EncodeMapStart(yynn639)
				yynn639 = 0
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[0] {
					yym641 := z.EncBinary()
					_ = yym641
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq639[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym642 := z.EncBinary()
					_ = yym642
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[1] {
					yym644 := z.EncBinary()
					_ = yym644
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq639[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym645 := z.EncBinary()
					_ = yym645
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq639[2] {
					yy647 := &x.ListMeta
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else if z.HasExtensions() && z.EncExt(yy647) {
					} else {
						z.EncFallback(yy647)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq639[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy649 := &x.ListMeta
					yym650 := z.EncBinary()
					_ = yym650
					if false {
					} else if z.HasExtensions() && z.EncExt(yy649) {
					} else {
						z.EncFallback(yy649)
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym652 := z.EncBinary()
					_ = yym652
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym653 := z.EncBinary()
					_ = yym653
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr639 || yy2arr639 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym654 := z.DecBinary()
	_ = yym654
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct655 := r.ContainerType()
		if yyct655 == codecSelferValueTypeMap1234 {
			yyl655 := r.ReadMapStart()
			if yyl655 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl655, d)
			}
		} else if yyct655 == codecSelferValueTypeArray1234 {
			yyl655 := r.ReadArrayStart()
			if yyl655 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl655, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys656Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys656Slc
	var yyhl656 bool = l >= 0
	for yyj656 := 0; ; yyj656++ {
		if yyhl656 {
			if yyj656 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys656Slc = r.DecodeBytes(yys656Slc, true, true)
		yys656 := string(yys656Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys656 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv659 := &x.ListMeta
				yym660 := z.DecBinary()
				_ = yym660
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv659) {
				} else {
					z.DecFallback(yyv659, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv661 := &x.Items
				yym662 := z.DecBinary()
				_ = yym662
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv661), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys656)
		} // end switch yys656
	} // end for yyj656
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj663 int
	var yyb663 bool
	var yyhl663 bool = l >= 0
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv666 := &x.ListMeta
		yym667 := z.DecBinary()
		_ = yym667
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv666) {
		} else {
			z.DecFallback(yyv666, false)
		}
	}
	yyj663++
	if yyhl663 {
		yyb663 = yyj663 > l
	} else {
		yyb663 = r.CheckBreak()
	}
	if yyb663 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv668 := &x.Items
		yym669 := z.DecBinary()
		_ = yym669
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv668), d)
		}
	}
	for {
		yyj663++
		if yyhl663 {
			yyb663 = yyj663 > l
		} else {
			yyb663 = r.CheckBreak()
		}
		if yyb663 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj663-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym670 := z.EncBinary()
		_ = yym670
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep671 := !z.EncBinary()
			yy2arr671 := z.EncBasicHandle().StructToArray
			var yyq671 [3]bool
			_, _, _ = yysep671, yyq671, yy2arr671
			const yyr671 bool = false
			yyq671[0] = x.Backend != nil
			yyq671[1] = len(x.TLS) != 0
			yyq671[2] = len(x.Rules) != 0
			var yynn671 int
			if yyr671 || yy2arr671 {
				r.EncodeArrayStart(3)
			} else {
				yynn671 = 0
				for _, b := range yyq671 {
					if b {
						yynn671++
					}
				}
				r.EncodeMapStart(yynn671)
				yynn671 = 0
			}
			if yyr671 || yy2arr671 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq671[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq671[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr671 || yy2arr671 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq671[1] {
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym674 := z.EncBinary()
						_ = yym674
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq671[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym675 := z.EncBinary()
						_ = yym675
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				}
			}
			if yyr671 || yy2arr671 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq671[2] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym677 := z.EncBinary()
						_ = yym677
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq671[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym678 := z.EncBinary()
						_ = yym678
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr671 || yy2arr671 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym679 := z.DecBinary()
	_ = yym679
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct680 := r.ContainerType()
		if yyct680 == codecSelferValueTypeMap1234 {
			yyl680 := r.ReadMapStart()
			if yyl680 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl680, d)
			}
		} else if yyct680 == codecSelferValueTypeArray1234 {
			yyl680 := r.ReadArrayStart()
			if yyl680 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl680, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys681Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys681Slc
	var yyhl681 bool = l >= 0
	for yyj681 := 0; ; yyj681++ {
		if yyhl681 {
			if yyj681 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys681Slc = r.DecodeBytes(yys681Slc, true, true)
		yys681 := string(yys681Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys681 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "tls":
			if r.TryDecodeAsNil() {
				x.TLS = nil
			} else {
				yyv683 := &x.TLS
				yym684 := z.DecBinary()
				_ = yym684
				if false {
				} else {
					h.decSliceIngressTLS((*[]IngressTLS)(yyv683), d)
				}
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv685 := &x.Rules
				yym686 := z.DecBinary()
				_ = yym686
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv685), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys681)
		} // end switch yys681
	} // end for yyj681
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj687 int
	var yyb687 bool
	var yyhl687 bool = l >= 0
	yyj687++
	if yyhl687 {
		yyb687 = yyj687 > l
	} else {
		yyb687 = r.CheckBreak()
	}
	if yyb687 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj687++
	if yyhl687 {
		yyb687 = yyj687 > l
	} else {
		yyb687 = r.CheckBreak()
	}
	if yyb687 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLS = nil
	} else {
		yyv689 := &x.TLS
		yym690 := z.DecBinary()
		_ = yym690
		if false {
		} else {
			h.decSliceIngressTLS((*[]IngressTLS)(yyv689), d)
		}
	}
	yyj687++
	if yyhl687 {
		yyb687 = yyj687 > l
	} else {
		yyb687 = r.CheckBreak()
	}
	if yyb687 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv691 := &x.Rules
		yym692 := z.DecBinary()
		_ = yym692
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv691), d)
		}
	}
	for {
		yyj687++
		if yyhl687 {
			yyb687 = yyj687 > l
		} else {
			yyb687 = r.CheckBreak()
		}
		if yyb687 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj687-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressTLS) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym693 := z.EncBinary()
		_ = yym693
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep694 := !z.EncBinary()
			yy2arr694 := z.EncBasicHandle().StructToArray
			var yyq694 [2]bool
			_, _, _ = yysep694, yyq694, yy2arr694
			const yyr694 bool = false
			yyq694[0] = len(x.Hosts) != 0
			yyq694[1] = x.SecretName != ""
			var yynn694 int
			if yyr694 || yy2arr694 {
				r.EncodeArrayStart(2)
			} else {
				yynn694 = 0
				for _, b := range yyq694 {
					if b {
						yynn694++
					}
				}
				r.EncodeMapStart(yynn694)
				yynn694 = 0
			}
			if yyr694 || yy2arr694 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq694[0] {
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym696 := z.EncBinary()
						_ = yym696
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq694[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hosts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym697 := z.EncBinary()
						_ = yym697
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				}
			}
			if yyr694 || yy2arr694 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq694[1] {
					yym699 := z.EncBinary()
					_ = yym699
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq694[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym700 := z.EncBinary()
					_ = yym700
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr694 || yy2arr694 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressTLS) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym701 := z.DecBinary()
	_ = yym701
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct702 := r.ContainerType()
		if yyct702 == codecSelferValueTypeMap1234 {
			yyl702 := r.ReadMapStart()
			if yyl702 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl702, d)
			}
		} else if yyct702 == codecSelferValueTypeArray1234 {
			yyl702 := r.ReadArrayStart()
			if yyl702 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl702, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressTLS) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys703Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys703Slc
	var yyhl703 bool = l >= 0
	for yyj703 := 0; ; yyj703++ {
		if yyhl703 {
			if yyj703 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys703Slc = r.DecodeBytes(yys703Slc, true, true)
		yys703 := string(yys703Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys703 {
		case "hosts":
			if r.TryDecodeAsNil() {
				x.Hosts = nil
			} else {
				yyv704 := &x.Hosts
				yym705 := z.DecBinary()
				_ = yym705
				if false {
				} else {
					z.F.DecSliceStringX(yyv704, false, d)
				}
			}
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys703)
		} // end switch yys703
	} // end for yyj703
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressTLS) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj707 int
	var yyb707 bool
	var yyhl707 bool = l >= 0
	yyj707++
	if yyhl707 {
		yyb707 = yyj707 > l
	} else {
		yyb707 = r.CheckBreak()
	}
	if yyb707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hosts = nil
	} else {
		yyv708 := &x.Hosts
		yym709 := z.DecBinary()
		_ = yym709
		if false {
		} else {
			z.F.DecSliceStringX(yyv708, false, d)
		}
	}
	yyj707++
	if yyhl707 {
		yyb707 = yyj707 > l
	} else {
		yyb707 = r.CheckBreak()
	}
	if yyb707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj707++
		if yyhl707 {
			yyb707 = yyj707 > l
		} else {
			yyb707 = r.CheckBreak()
		}
		if yyb707 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj707-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym711 := z.EncBinary()
		_ = yym711
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep712 := !z.EncBinary()
			yy2arr712 := z.EncBasicHandle().StructToArray
			var yyq712 [1]bool
			_, _, _ = yysep712, yyq712, yy2arr712
			const yyr712 bool = false
			yyq712[0] = true
			var yynn712 int
			if yyr712 || yy2arr712 {
				r.EncodeArrayStart(1)
			} else {
				yynn712 = 0
				for _, b := range yyq712 {
					if b {
						yynn712++
					}
				}
				r.EncodeMapStart(yynn712)
				yynn712 = 0
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[0] {
					yy714 := &x.LoadBalancer
					yy714.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq712[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy715 := &x.LoadBalancer
					yy715.CodecEncodeSelf(e)
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym716 := z.DecBinary()
	_ = yym716
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct717 := r.ContainerType()
		if yyct717 == codecSelferValueTypeMap1234 {
			yyl717 := r.ReadMapStart()
			if yyl717 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl717, d)
			}
		} else if yyct717 == codecSelferValueTypeArray1234 {
			yyl717 := r.ReadArrayStart()
			if yyl717 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl717, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys718Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys718Slc
	var yyhl718 bool = l >= 0
	for yyj718 := 0; ; yyj718++ {
		if yyhl718 {
			if yyj718 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys718Slc = r.DecodeBytes(yys718Slc, true, true)
		yys718 := string(yys718Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys718 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
			} else {
				yyv719 := &x.LoadBalancer
				yyv719.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys718)
		} // end switch yys718
	} // end for yyj718
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj720 int
	var yyb720 bool
	var yyhl720 bool = l >= 0
	yyj720++
	if yyhl720 {
		yyb720 = yyj720 > l
	} else {
		yyb720 = r.CheckBreak()
	}
	if yyb720 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
	} else {
		yyv721 := &x.LoadBalancer
		yyv721.CodecDecodeSelf(d)
	}
	for {
		yyj720++
		if yyhl720 {
			yyb720 = yyj720 > l
		} else {
			yyb720 = r.CheckBreak()
		}
		if yyb720 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj720-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym722 := z.EncBinary()
		_ = yym722
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep723 := !z.EncBinary()
			yy2arr723 := z.EncBasicHandle().StructToArray
			var yyq723 [2]bool
			_, _, _ = yysep723, yyq723, yy2arr723
			const yyr723 bool = false
			yyq723[0] = x.Host != ""
			yyq723[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn723 int
			if yyr723 || yy2arr723 {
				r.EncodeArrayStart(2)
			} else {
				yynn723 = 0
				for _, b := range yyq723 {
					if b {
						yynn723++
					}
				}
				r.EncodeMapStart(yynn723)
				yynn723 = 0
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq723[0] {
					yym725 := z.EncBinary()
					_ = yym725
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq723[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym726 := z.EncBinary()
					_ = yym726
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn727 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn727 = true
				goto LABEL727
			}
		LABEL727:
			if yyr723 || yy2arr723 {
				if yyn727 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq723[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq723[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn727 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr723 || yy2arr723 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym728 := z.DecBinary()
	_ = yym728
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct729 := r.ContainerType()
		if yyct729 == codecSelferValueTypeMap1234 {
			yyl729 := r.ReadMapStart()
			if yyl729 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl729, d)
			}
		} else if yyct729 == codecSelferValueTypeArray1234 {
			yyl729 := r.ReadArrayStart()
			if yyl729 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl729, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys730Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys730Slc
	var yyhl730 bool = l >= 0
	for yyj730 := 0; ; yyj730++ {
		if yyhl730 {
			if yyj730 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys730Slc = r.DecodeBytes(yys730Slc, true, true)
		yys730 := string(yys730Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys730 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys730)
		} // end switch yys730
	} // end for yyj730
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj733 int
	var yyb733 bool
	var yyhl733 bool = l >= 0
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj733++
	if yyhl733 {
		yyb733 = yyj733 > l
	} else {
		yyb733 = r.CheckBreak()
	}
	if yyb733 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj733++
		if yyhl733 {
			yyb733 = yyj733 > l
		} else {
			yyb733 = r.CheckBreak()
		}
		if yyb733 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj733-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym736 := z.EncBinary()
		_ = yym736
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep737 := !z.EncBinary()
			yy2arr737 := z.EncBasicHandle().StructToArray
			var yyq737 [1]bool
			_, _, _ = yysep737, yyq737, yy2arr737
			const yyr737 bool = false
			yyq737[0] = x.HTTP != nil
			var yynn737 int
			if yyr737 || yy2arr737 {
				r.EncodeArrayStart(1)
			} else {
				yynn737 = 0
				for _, b := range yyq737 {
					if b {
						yynn737++
					}
				}
				r.EncodeMapStart(yynn737)
				yynn737 = 0
			}
			if yyr737 || yy2arr737 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq737[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq737[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr737 || yy2arr737 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym739 := z.DecBinary()
	_ = yym739
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct740 := r.ContainerType()
		if yyct740 == codecSelferValueTypeMap1234 {
			yyl740 := r.ReadMapStart()
			if yyl740 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl740, d)
			}
		} else if yyct740 == codecSelferValueTypeArray1234 {
			yyl740 := r.ReadArrayStart()
			if yyl740 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl740, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys741Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys741Slc
	var yyhl741 bool = l >= 0
	for yyj741 := 0; ; yyj741++ {
		if yyhl741 {
			if yyj741 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys741Slc = r.DecodeBytes(yys741Slc, true, true)
		yys741 := string(yys741Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys741 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys741)
		} // end switch yys741
	} // end for yyj741
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj743 int
	var yyb743 bool
	var yyhl743 bool = l >= 0
	yyj743++
	if yyhl743 {
		yyb743 = yyj743 > l
	} else {
		yyb743 = r.CheckBreak()
	}
	if yyb743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj743++
		if yyhl743 {
			yyb743 = yyj743 > l
		} else {
			yyb743 = r.CheckBreak()
		}
		if yyb743 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj743-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym745 := z.EncBinary()
		_ = yym745
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep746 := !z.EncBinary()
			yy2arr746 := z.EncBasicHandle().StructToArray
			var yyq746 [1]bool
			_, _, _ = yysep746, yyq746, yy2arr746
			const yyr746 bool = false
			var yynn746 int
			if yyr746 || yy2arr746 {
				r.EncodeArrayStart(1)
			} else {
				yynn746 = 1
				for _, b := range yyq746 {
					if b {
						yynn746++
					}
				}
				r.EncodeMapStart(yynn746)
				yynn746 = 0
			}
			if yyr746 || yy2arr746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym748 := z.EncBinary()
					_ = yym748
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym749 := z.EncBinary()
					_ = yym749
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr746 || yy2arr746 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym750 := z.DecBinary()
	_ = yym750
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct751 := r.ContainerType()
		if yyct751 == codecSelferValueTypeMap1234 {
			yyl751 := r.ReadMapStart()
			if yyl751 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl751, d)
			}
		} else if yyct751 == codecSelferValueTypeArray1234 {
			yyl751 := r.ReadArrayStart()
			if yyl751 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl751, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys752Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys752Slc
	var yyhl752 bool = l >= 0
	for yyj752 := 0; ; yyj752++ {
		if yyhl752 {
			if yyj752 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys752Slc = r.DecodeBytes(yys752Slc, true, true)
		yys752 := string(yys752Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys752 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv753 := &x.Paths
				yym754 := z.DecBinary()
				_ = yym754
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv753), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys752)
		} // end switch yys752
	} // end for yyj752
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj755 int
	var yyb755 bool
	var yyhl755 bool = l >= 0
	yyj755++
	if yyhl755 {
		yyb755 = yyj755 > l
	} else {
		yyb755 = r.CheckBreak()
	}
	if yyb755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv756 := &x.Paths
		yym757 := z.DecBinary()
		_ = yym757
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv756), d)
		}
	}
	for {
		yyj755++
		if yyhl755 {
			yyb755 = yyj755 > l
		} else {
			yyb755 = r.CheckBreak()
		}
		if yyb755 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj755-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym758 := z.EncBinary()
		_ = yym758
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep759 := !z.EncBinary()
			yy2arr759 := z.EncBasicHandle().StructToArray
			var yyq759 [2]bool
			_, _, _ = yysep759, yyq759, yy2arr759
			const yyr759 bool = false
			yyq759[0] = x.Path != ""
			var yynn759 int
			if yyr759 || yy2arr759 {
				r.EncodeArrayStart(2)
			} else {
				yynn759 = 1
				for _, b := range yyq759 {
					if b {
						yynn759++
					}
				}
				r.EncodeMapStart(yynn759)
				yynn759 = 0
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq759[0] {
					yym761 := z.EncBinary()
					_ = yym761
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq759[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym762 := z.EncBinary()
					_ = yym762
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy764 := &x.Backend
				yy764.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy765 := &x.Backend
				yy765.CodecEncodeSelf(e)
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym766 := z.DecBinary()
	_ = yym766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct767 := r.ContainerType()
		if yyct767 == codecSelferValueTypeMap1234 {
			yyl767 := r.ReadMapStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl767, d)
			}
		} else if yyct767 == codecSelferValueTypeArray1234 {
			yyl767 := r.ReadArrayStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl767, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys768Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys768Slc
	var yyhl768 bool = l >= 0
	for yyj768 := 0; ; yyj768++ {
		if yyhl768 {
			if yyj768 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys768Slc = r.DecodeBytes(yys768Slc, true, true)
		yys768 := string(yys768Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys768 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv770 := &x.Backend
				yyv770.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys768)
		} // end switch yys768
	} // end for yyj768
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj771 int
	var yyb771 bool
	var yyhl771 bool = l >= 0
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj771++
	if yyhl771 {
		yyb771 = yyj771 > l
	} else {
		yyb771 = r.CheckBreak()
	}
	if yyb771 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv773 := &x.Backend
		yyv773.CodecDecodeSelf(d)
	}
	for {
		yyj771++
		if yyhl771 {
			yyb771 = yyj771 > l
		} else {
			yyb771 = r.CheckBreak()
		}
		if yyb771 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj771-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym774 := z.EncBinary()
		_ = yym774
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep775 := !z.EncBinary()
			yy2arr775 := z.EncBasicHandle().StructToArray
			var yyq775 [2]bool
			_, _, _ = yysep775, yyq775, yy2arr775
			const yyr775 bool = false
			var yynn775 int
			if yyr775 || yy2arr775 {
				r.EncodeArrayStart(2)
			} else {
				yynn775 = 2
				for _, b := range yyq775 {
					if b {
						yynn775++
					}
				}
				r.EncodeMapStart(yynn775)
				yynn775 = 0
			}
			if yyr775 || yy2arr775 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym777 := z.EncBinary()
				_ = yym777
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym778 := z.EncBinary()
				_ = yym778
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr775 || yy2arr775 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy780 := &x.ServicePort
				yym781 := z.EncBinary()
				_ = yym781
				if false {
				} else if z.HasExtensions() && z.EncExt(yy780) {
				} else if !yym781 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy780)
				} else {
					z.EncFallback(yy780)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy782 := &x.ServicePort
				yym783 := z.EncBinary()
				_ = yym783
				if false {
				} else if z.HasExtensions() && z.EncExt(yy782) {
				} else if !yym783 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy782)
				} else {
					z.EncFallback(yy782)
				}
			}
			if yyr775 || yy2arr775 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym784 := z.DecBinary()
	_ = yym784
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct785 := r.ContainerType()
		if yyct785 == codecSelferValueTypeMap1234 {
			yyl785 := r.ReadMapStart()
			if yyl785 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl785, d)
			}
		} else if yyct785 == codecSelferValueTypeArray1234 {
			yyl785 := r.ReadArrayStart()
			if yyl785 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl785, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys786Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys786Slc
	var yyhl786 bool = l >= 0
	for yyj786 := 0; ; yyj786++ {
		if yyhl786 {
			if yyj786 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys786Slc = r.DecodeBytes(yys786Slc, true, true)
		yys786 := string(yys786Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys786 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg5_intstr.IntOrString{}
			} else {
				yyv788 := &x.ServicePort
				yym789 := z.DecBinary()
				_ = yym789
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv788) {
				} else if !yym789 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv788)
				} else {
					z.DecFallback(yyv788, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys786)
		} // end switch yys786
	} // end for yyj786
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj790 int
	var yyb790 bool
	var yyhl790 bool = l >= 0
	yyj790++
	if yyhl790 {
		yyb790 = yyj790 > l
	} else {
		yyb790 = r.CheckBreak()
	}
	if yyb790 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj790++
	if yyhl790 {
		yyb790 = yyj790 > l
	} else {
		yyb790 = r.CheckBreak()
	}
	if yyb790 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg5_intstr.IntOrString{}
	} else {
		yyv792 := &x.ServicePort
		yym793 := z.DecBinary()
		_ = yym793
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv792) {
		} else if !yym793 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv792)
		} else {
			z.DecFallback(yyv792, false)
		}
	}
	for {
		yyj790++
		if yyhl790 {
			yyb790 = yyj790 > l
		} else {
			yyb790 = r.CheckBreak()
		}
		if yyb790 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj790-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym794 := z.EncBinary()
		_ = yym794
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep795 := !z.EncBinary()
			yy2arr795 := z.EncBasicHandle().StructToArray
			var yyq795 [5]bool
			_, _, _ = yysep795, yyq795, yy2arr795
			const yyr795 bool = false
			yyq795[0] = x.Kind != ""
			yyq795[1] = x.APIVersion != ""
			yyq795[2] = true
			yyq795[3] = true
			yyq795[4] = true
			var yynn795 int
			if yyr795 || yy2arr795 {
				r.EncodeArrayStart(5)
			} else {
				yynn795 = 0
				for _, b := range yyq795 {
					if b {
						yynn795++
					}
				}
				r.EncodeMapStart(yynn795)
				yynn795 = 0
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq795[0] {
					yym797 := z.EncBinary()
					_ = yym797
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq795[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym798 := z.EncBinary()
					_ = yym798
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq795[1] {
					yym800 := z.EncBinary()
					_ = yym800
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq795[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym801 := z.EncBinary()
					_ = yym801
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq795[2] {
					yy803 := &x.ObjectMeta
					yy803.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq795[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy804 := &x.ObjectMeta
					yy804.CodecEncodeSelf(e)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq795[3] {
					yy806 := &x.Spec
					yy806.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq795[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy807 := &x.Spec
					yy807.CodecEncodeSelf(e)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq795[4] {
					yy809 := &x.Status
					yy809.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq795[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy810 := &x.Status
					yy810.CodecEncodeSelf(e)
				}
			}
			if yyr795 || yy2arr795 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym811 := z.DecBinary()
	_ = yym811
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct812 := r.ContainerType()
		if yyct812 == codecSelferValueTypeMap1234 {
			yyl812 := r.ReadMapStart()
			if yyl812 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl812, d)
			}
		} else if yyct812 == codecSelferValueTypeArray1234 {
			yyl812 := r.ReadArrayStart()
			if yyl812 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl812, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys813Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys813Slc
	var yyhl813 bool = l >= 0
	for yyj813 := 0; ; yyj813++ {
		if yyhl813 {
			if yyj813 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys813Slc = r.DecodeBytes(yys813Slc, true, true)
		yys813 := string(yys813Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys813 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv816 := &x.ObjectMeta
				yyv816.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicaSetSpec{}
			} else {
				yyv817 := &x.Spec
				yyv817.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicaSetStatus{}
			} else {
				yyv818 := &x.Status
				yyv818.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys813)
		} // end switch yys813
	} // end for yyj813
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj819 int
	var yyb819 bool
	var yyhl819 bool = l >= 0
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv822 := &x.ObjectMeta
		yyv822.CodecDecodeSelf(d)
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicaSetSpec{}
	} else {
		yyv823 := &x.Spec
		yyv823.CodecDecodeSelf(d)
	}
	yyj819++
	if yyhl819 {
		yyb819 = yyj819 > l
	} else {
		yyb819 = r.CheckBreak()
	}
	if yyb819 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicaSetStatus{}
	} else {
		yyv824 := &x.Status
		yyv824.CodecDecodeSelf(d)
	}
	for {
		yyj819++
		if yyhl819 {
			yyb819 = yyj819 > l
		} else {
			yyb819 = r.CheckBreak()
		}
		if yyb819 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj819-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym825 := z.EncBinary()
		_ = yym825
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep826 := !z.EncBinary()
			yy2arr826 := z.EncBasicHandle().StructToArray
			var yyq826 [4]bool
			_, _, _ = yysep826, yyq826, yy2arr826
			const yyr826 bool = false
			yyq826[0] = x.Kind != ""
			yyq826[1] = x.APIVersion != ""
			yyq826[2] = true
			var yynn826 int
			if yyr826 || yy2arr826 {
				r.EncodeArrayStart(4)
			} else {
				yynn826 = 1
				for _, b := range yyq826 {
					if b {
						yynn826++
					}
				}
				r.EncodeMapStart(yynn826)
				yynn826 = 0
			}
			if yyr826 || yy2arr826 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq826[0] {
					yym828 := z.EncBinary()
					_ = yym828
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq826[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym829 := z.EncBinary()
					_ = yym829
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr826 || yy2arr826 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq826[1] {
					yym831 := z.EncBinary()
					_ = yym831
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq826[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym832 := z.EncBinary()
					_ = yym832
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr826 || yy2arr826 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq826[2] {
					yy834 := &x.ListMeta
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else if z.HasExtensions() && z.EncExt(yy834) {
					} else {
						z.EncFallback(yy834)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq826[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy836 := &x.ListMeta
					yym837 := z.EncBinary()
					_ = yym837
					if false {
					} else if z.HasExtensions() && z.EncExt(yy836) {
					} else {
						z.EncFallback(yy836)
					}
				}
			}
			if yyr826 || yy2arr826 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym839 := z.EncBinary()
					_ = yym839
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym840 := z.EncBinary()
					_ = yym840
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			}
			if yyr826 || yy2arr826 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym841 := z.DecBinary()
	_ = yym841
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct842 := r.ContainerType()
		if yyct842 == codecSelferValueTypeMap1234 {
			yyl842 := r.ReadMapStart()
			if yyl842 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl842, d)
			}
		} else if yyct842 == codecSelferValueTypeArray1234 {
			yyl842 := r.ReadArrayStart()
			if yyl842 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl842, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys843Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys843Slc
	var yyhl843 bool = l >= 0
	for yyj843 := 0; ; yyj843++ {
		if yyhl843 {
			if yyj843 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys843Slc = r.DecodeBytes(yys843Slc, true, true)
		yys843 := string(yys843Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys843 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv846 := &x.ListMeta
				yym847 := z.DecBinary()
				_ = yym847
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv846) {
				} else {
					z.DecFallback(yyv846, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv848 := &x.Items
				yym849 := z.DecBinary()
				_ = yym849
				if false {
				} else {
					h.decSliceReplicaSet((*[]ReplicaSet)(yyv848), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys843)
		} // end switch yys843
	} // end for yyj843
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj850 int
	var yyb850 bool
	var yyhl850 bool = l >= 0
	yyj850++
	if yyhl850 {
		yyb850 = yyj850 > l
	} else {
		yyb850 = r.CheckBreak()
	}
	if yyb850 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj850++
	if yyhl850 {
		yyb850 = yyj850 > l
	} else {
		yyb850 = r.CheckBreak()
	}
	if yyb850 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj850++
	if yyhl850 {
		yyb850 = yyj850 > l
	} else {
		yyb850 = r.CheckBreak()
	}
	if yyb850 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv853 := &x.ListMeta
		yym854 := z.DecBinary()
		_ = yym854
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv853) {
		} else {
			z.DecFallback(yyv853, false)
		}
	}
	yyj850++
	if yyhl850 {
		yyb850 = yyj850 > l
	} else {
		yyb850 = r.CheckBreak()
	}
	if yyb850 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv855 := &x.Items
		yym856 := z.DecBinary()
		_ = yym856
		if false {
		} else {
			h.decSliceReplicaSet((*[]ReplicaSet)(yyv855), d)
		}
	}
	for {
		yyj850++
		if yyhl850 {
			yyb850 = yyj850 > l
		} else {
			yyb850 = r.CheckBreak()
		}
		if yyb850 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj850-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym857 := z.EncBinary()
		_ = yym857
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep858 := !z.EncBinary()
			yy2arr858 := z.EncBasicHandle().StructToArray
			var yyq858 [3]bool
			_, _, _ = yysep858, yyq858, yy2arr858
			const yyr858 bool = false
			yyq858[1] = x.Selector != nil
			yyq858[2] = true
			var yynn858 int
			if yyr858 || yy2arr858 {
				r.EncodeArrayStart(3)
			} else {
				yynn858 = 1
				for _, b := range yyq858 {
					if b {
						yynn858++
					}
				}
				r.EncodeMapStart(yynn858)
				yynn858 = 0
			}
			if yyr858 || yy2arr858 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym860 := z.EncBinary()
				_ = yym860
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym861 := z.EncBinary()
				_ = yym861
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr858 || yy2arr858 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq858[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym863 := z.EncBinary()
						_ = yym863
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq858[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym864 := z.EncBinary()
						_ = yym864
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr858 || yy2arr858 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq858[2] {
					yy866 := &x.Template
					yy866.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq858[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy867 := &x.Template
					yy867.CodecEncodeSelf(e)
				}
			}
			if yyr858 || yy2arr858 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym868 := z.DecBinary()
	_ = yym868
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct869 := r.ContainerType()
		if yyct869 == codecSelferValueTypeMap1234 {
			yyl869 := r.ReadMapStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl869, d)
			}
		} else if yyct869 == codecSelferValueTypeArray1234 {
			yyl869 := r.ReadArrayStart()
			if yyl869 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl869, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys870Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys870Slc
	var yyhl870 bool = l >= 0
	for yyj870 := 0; ; yyj870++ {
		if yyhl870 {
			if yyj870 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys870Slc = r.DecodeBytes(yys870Slc, true, true)
		yys870 := string(yys870Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys870 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym873 := z.DecBinary()
				_ = yym873
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv874 := &x.Template
				yyv874.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys870)
		} // end switch yys870
	} // end for yyj870
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj875 int
	var yyb875 bool
	var yyhl875 bool = l >= 0
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym878 := z.DecBinary()
		_ = yym878
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj875++
	if yyhl875 {
		yyb875 = yyj875 > l
	} else {
		yyb875 = r.CheckBreak()
	}
	if yyb875 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv879 := &x.Template
		yyv879.CodecDecodeSelf(d)
	}
	for {
		yyj875++
		if yyhl875 {
			yyb875 = yyj875 > l
		} else {
			yyb875 = r.CheckBreak()
		}
		if yyb875 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj875-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym880 := z.EncBinary()
		_ = yym880
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep881 := !z.EncBinary()
			yy2arr881 := z.EncBasicHandle().StructToArray
			var yyq881 [4]bool
			_, _, _ = yysep881, yyq881, yy2arr881
			const yyr881 bool = false
			yyq881[1] = x.FullyLabeledReplicas != 0
			yyq881[2] = x.ReadyReplicas != 0
			yyq881[3] = x.ObservedGeneration != 0
			var yynn881 int
			if yyr881 || yy2arr881 {
				r.EncodeArrayStart(4)
			} else {
				yynn881 = 1
				for _, b := range yyq881 {
					if b {
						yynn881++
					}
				}
				r.EncodeMapStart(yynn881)
				yynn881 = 0
			}
			if yyr881 || yy2arr881 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym883 := z.EncBinary()
				_ = yym883
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym884 := z.EncBinary()
				_ = yym884
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr881 || yy2arr881 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq881[1] {
					yym886 := z.EncBinary()
					_ = yym886
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq881[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym887 := z.EncBinary()
					_ = yym887
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr881 || yy2arr881 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq881[2] {
					yym889 := z.EncBinary()
					_ = yym889
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq881[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym890 := z.EncBinary()
					_ = yym890
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr881 || yy2arr881 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq881[3] {
					yym892 := z.EncBinary()
					_ = yym892
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq881[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym893 := z.EncBinary()
					_ = yym893
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr881 || yy2arr881 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym894 := z.DecBinary()
	_ = yym894
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct895 := r.ContainerType()
		if yyct895 == codecSelferValueTypeMap1234 {
			yyl895 := r.ReadMapStart()
			if yyl895 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl895, d)
			}
		} else if yyct895 == codecSelferValueTypeArray1234 {
			yyl895 := r.ReadArrayStart()
			if yyl895 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl895, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys896Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys896Slc
	var yyhl896 bool = l >= 0
	for yyj896 := 0; ; yyj896++ {
		if yyhl896 {
			if yyj896 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys896Slc = r.DecodeBytes(yys896Slc, true, true)
		yys896 := string(yys896Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys896 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys896)
		} // end switch yys896
	} // end for yyj896
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj901 int
	var yyb901 bool
	var yyhl901 bool = l >= 0
	yyj901++
	if yyhl901 {
		yyb901 = yyj901 > l
	} else {
		yyb901 = r.CheckBreak()
	}
	if yyb901 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj901++
	if yyhl901 {
		yyb901 = yyj901 > l
	} else {
		yyb901 = r.CheckBreak()
	}
	if yyb901 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj901++
	if yyhl901 {
		yyb901 = yyj901 > l
	} else {
		yyb901 = r.CheckBreak()
	}
	if yyb901 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj901++
	if yyhl901 {
		yyb901 = yyj901 > l
	} else {
		yyb901 = r.CheckBreak()
	}
	if yyb901 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	for {
		yyj901++
		if yyhl901 {
			yyb901 = yyj901 > l
		} else {
			yyb901 = r.CheckBreak()
		}
		if yyb901 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj901-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym906 := z.EncBinary()
		_ = yym906
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep907 := !z.EncBinary()
			yy2arr907 := z.EncBasicHandle().StructToArray
			var yyq907 [4]bool
			_, _, _ = yysep907, yyq907, yy2arr907
			const yyr907 bool = false
			yyq907[0] = x.Kind != ""
			yyq907[1] = x.APIVersion != ""
			yyq907[2] = true
			yyq907[3] = true
			var yynn907 int
			if yyr907 || yy2arr907 {
				r.EncodeArrayStart(4)
			} else {
				yynn907 = 0
				for _, b := range yyq907 {
					if b {
						yynn907++
					}
				}
				r.EncodeMapStart(yynn907)
				yynn907 = 0
			}
			if yyr907 || yy2arr907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq907[0] {
					yym909 := z.EncBinary()
					_ = yym909
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq907[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym910 := z.EncBinary()
					_ = yym910
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr907 || yy2arr907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq907[1] {
					yym912 := z.EncBinary()
					_ = yym912
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq907[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym913 := z.EncBinary()
					_ = yym913
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr907 || yy2arr907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq907[2] {
					yy915 := &x.ObjectMeta
					yy915.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq907[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy916 := &x.ObjectMeta
					yy916.CodecEncodeSelf(e)
				}
			}
			if yyr907 || yy2arr907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq907[3] {
					yy918 := &x.Spec
					yy918.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq907[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy919 := &x.Spec
					yy919.CodecEncodeSelf(e)
				}
			}
			if yyr907 || yy2arr907 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym920 := z.DecBinary()
	_ = yym920
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct921 := r.ContainerType()
		if yyct921 == codecSelferValueTypeMap1234 {
			yyl921 := r.ReadMapStart()
			if yyl921 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl921, d)
			}
		} else if yyct921 == codecSelferValueTypeArray1234 {
			yyl921 := r.ReadArrayStart()
			if yyl921 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl921, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys922Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys922Slc
	var yyhl922 bool = l >= 0
	for yyj922 := 0; ; yyj922++ {
		if yyhl922 {
			if yyj922 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys922Slc = r.DecodeBytes(yys922Slc, true, true)
		yys922 := string(yys922Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys922 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv925 := &x.ObjectMeta
				yyv925.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSecurityPolicySpec{}
			} else {
				yyv926 := &x.Spec
				yyv926.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys922)
		} // end switch yys922
	} // end for yyj922
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj927 int
	var yyb927 bool
	var yyhl927 bool = l >= 0
	yyj927++
	if yyhl927 {
		yyb927 = yyj927 > l
	} else {
		yyb927 = r.CheckBreak()
	}
	if yyb927 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj927++
	if yyhl927 {
		yyb927 = yyj927 > l
	} else {
		yyb927 = r.CheckBreak()
	}
	if yyb927 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj927++
	if yyhl927 {
		yyb927 = yyj927 > l
	} else {
		yyb927 = r.CheckBreak()
	}
	if yyb927 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv930 := &x.ObjectMeta
		yyv930.CodecDecodeSelf(d)
	}
	yyj927++
	if yyhl927 {
		yyb927 = yyj927 > l
	} else {
		yyb927 = r.CheckBreak()
	}
	if yyb927 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSecurityPolicySpec{}
	} else {
		yyv931 := &x.Spec
		yyv931.CodecDecodeSelf(d)
	}
	for {
		yyj927++
		if yyhl927 {
			yyb927 = yyj927 > l
		} else {
			yyb927 = r.CheckBreak()
		}
		if yyb927 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj927-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym932 := z.EncBinary()
		_ = yym932
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep933 := !z.EncBinary()
			yy2arr933 := z.EncBasicHandle().StructToArray
			var yyq933 [14]bool
			_, _, _ = yysep933, yyq933, yy2arr933
			const yyr933 bool = false
			yyq933[0] = x.Privileged != false
			yyq933[1] = len(x.DefaultAddCapabilities) != 0
			yyq933[2] = len(x.RequiredDropCapabilities) != 0
			yyq933[3] = len(x.AllowedCapabilities) != 0
			yyq933[4] = len(x.Volumes) != 0
			yyq933[5] = x.HostNetwork != false
			yyq933[6] = len(x.HostPorts) != 0
			yyq933[7] = x.HostPID != false
			yyq933[8] = x.HostIPC != false
			yyq933[13] = x.ReadOnlyRootFilesystem != false
			var yynn933 int
			if yyr933 || yy2arr933 {
				r.EncodeArrayStart(14)
			} else {
				yynn933 = 4
				for _, b := range yyq933 {
					if b {
						yynn933++
					}
				}
				r.EncodeMapStart(yynn933)
				yynn933 = 0
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[0] {
					yym935 := z.EncBinary()
					_ = yym935
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq933[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("privileged"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym936 := z.EncBinary()
					_ = yym936
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[1] {
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym938 := z.EncBinary()
						_ = yym938
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultAddCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym939 := z.EncBinary()
						_ = yym939
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[2] {
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym941 := z.EncBinary()
						_ = yym941
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDropCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym942 := z.EncBinary()
						_ = yym942
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[3] {
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym944 := z.EncBinary()
						_ = yym944
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.AllowedCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allowedCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym945 := z.EncBinary()
						_ = yym945
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.AllowedCapabilities), e)
						}
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[4] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym947 := z.EncBinary()
						_ = yym947
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym948 := z.EncBinary()
						_ = yym948
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[5] {
					yym950 := z.EncBinary()
					_ = yym950
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq933[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym951 := z.EncBinary()
					_ = yym951
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[6] {
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym953 := z.EncBinary()
						_ = yym953
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq933[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPorts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym954 := z.EncBinary()
						_ = yym954
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[7] {
					yym956 := z.EncBinary()
					_ = yym956
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq933[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym957 := z.EncBinary()
					_ = yym957
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[8] {
					yym959 := z.EncBinary()
					_ = yym959
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq933[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym960 := z.EncBinary()
					_ = yym960
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy962 := &x.SELinux
				yy962.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seLinux"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy963 := &x.SELinux
				yy963.CodecEncodeSelf(e)
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy965 := &x.RunAsUser
				yy965.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy966 := &x.RunAsUser
				yy966.CodecEncodeSelf(e)
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy968 := &x.SupplementalGroups
				yy968.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy969 := &x.SupplementalGroups
				yy969.CodecEncodeSelf(e)
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy971 := &x.FSGroup
				yy971.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy972 := &x.FSGroup
				yy972.CodecEncodeSelf(e)
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq933[13] {
					yym974 := z.EncBinary()
					_ = yym974
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq933[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnlyRootFilesystem"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym975 := z.EncBinary()
					_ = yym975
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				}
			}
			if yyr933 || yy2arr933 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym976 := z.DecBinary()
	_ = yym976
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct977 := r.ContainerType()
		if yyct977 == codecSelferValueTypeMap1234 {
			yyl977 := r.ReadMapStart()
			if yyl977 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl977, d)
			}
		} else if yyct977 == codecSelferValueTypeArray1234 {
			yyl977 := r.ReadArrayStart()
			if yyl977 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl977, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys978Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys978Slc
	var yyhl978 bool = l >= 0
	for yyj978 := 0; ; yyj978++ {
		if yyhl978 {
			if yyj978 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys978Slc = r.DecodeBytes(yys978Slc, true, true)
		yys978 := string(yys978Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys978 {
		case "privileged":
			if r.TryDecodeAsNil() {
				x.Privileged = false
			} else {
				x.Privileged = bool(r.DecodeBool())
			}
		case "defaultAddCapabilities":
			if r.TryDecodeAsNil() {
				x.DefaultAddCapabilities = nil
			} else {
				yyv980 := &x.DefaultAddCapabilities
				yym981 := z.DecBinary()
				_ = yym981
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv980), d)
				}
			}
		case "requiredDropCapabilities":
			if r.TryDecodeAsNil() {
				x.RequiredDropCapabilities = nil
			} else {
				yyv982 := &x.RequiredDropCapabilities
				yym983 := z.DecBinary()
				_ = yym983
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv982), d)
				}
			}
		case "allowedCapabilities":
			if r.TryDecodeAsNil() {
				x.AllowedCapabilities = nil
			} else {
				yyv984 := &x.AllowedCapabilities
				yym985 := z.DecBinary()
				_ = yym985
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv984), d)
				}
			}
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv986 := &x.Volumes
				yym987 := z.DecBinary()
				_ = yym987
				if false {
				} else {
					h.decSliceFSType((*[]FSType)(yyv986), d)
				}
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPorts":
			if r.TryDecodeAsNil() {
				x.HostPorts = nil
			} else {
				yyv989 := &x.HostPorts
				yym990 := z.DecBinary()
				_ = yym990
				if false {
				} else {
					h.decSliceHostPortRange((*[]HostPortRange)(yyv989), d)
				}
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinux":
			if r.TryDecodeAsNil() {
				x.SELinux = SELinuxStrategyOptions{}
			} else {
				yyv993 := &x.SELinux
				yyv993.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				x.RunAsUser = RunAsUserStrategyOptions{}
			} else {
				yyv994 := &x.RunAsUser
				yyv994.CodecDecodeSelf(d)
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
			} else {
				yyv995 := &x.SupplementalGroups
				yyv995.CodecDecodeSelf(d)
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				x.FSGroup = FSGroupStrategyOptions{}
			} else {
				yyv996 := &x.FSGroup
				yyv996.CodecDecodeSelf(d)
			}
		case "readOnlyRootFilesystem":
			if r.TryDecodeAsNil() {
				x.ReadOnlyRootFilesystem = false
			} else {
				x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys978)
		} // end switch yys978
	} // end for yyj978
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj998 int
	var yyb998 bool
	var yyhl998 bool = l >= 0
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Privileged = false
	} else {
		x.Privileged = bool(r.DecodeBool())
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultAddCapabilities = nil
	} else {
		yyv1000 := &x.DefaultAddCapabilities
		yym1001 := z.DecBinary()
		_ = yym1001
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1000), d)
		}
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDropCapabilities = nil
	} else {
		yyv1002 := &x.RequiredDropCapabilities
		yym1003 := z.DecBinary()
		_ = yym1003
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1002), d)
		}
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedCapabilities = nil
	} else {
		yyv1004 := &x.AllowedCapabilities
		yym1005 := z.DecBinary()
		_ = yym1005
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1004), d)
		}
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1006 := &x.Volumes
		yym1007 := z.DecBinary()
		_ = yym1007
		if false {
		} else {
			h.decSliceFSType((*[]FSType)(yyv1006), d)
		}
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPorts = nil
	} else {
		yyv1009 := &x.HostPorts
		yym1010 := z.DecBinary()
		_ = yym1010
		if false {
		} else {
			h.decSliceHostPortRange((*[]HostPortRange)(yyv1009), d)
		}
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SELinux = SELinuxStrategyOptions{}
	} else {
		yyv1013 := &x.SELinux
		yyv1013.CodecDecodeSelf(d)
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RunAsUser = RunAsUserStrategyOptions{}
	} else {
		yyv1014 := &x.RunAsUser
		yyv1014.CodecDecodeSelf(d)
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
	} else {
		yyv1015 := &x.SupplementalGroups
		yyv1015.CodecDecodeSelf(d)
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSGroup = FSGroupStrategyOptions{}
	} else {
		yyv1016 := &x.FSGroup
		yyv1016.CodecDecodeSelf(d)
	}
	yyj998++
	if yyhl998 {
		yyb998 = yyj998 > l
	} else {
		yyb998 = r.CheckBreak()
	}
	if yyb998 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyRootFilesystem = false
	} else {
		x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
	}
	for {
		yyj998++
		if yyhl998 {
			yyb998 = yyj998 > l
		} else {
			yyb998 = r.CheckBreak()
		}
		if yyb998 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj998-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HostPortRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1018 := z.EncBinary()
		_ = yym1018
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1019 := !z.EncBinary()
			yy2arr1019 := z.EncBasicHandle().StructToArray
			var yyq1019 [2]bool
			_, _, _ = yysep1019, yyq1019, yy2arr1019
			const yyr1019 bool = false
			var yynn1019 int
			if yyr1019 || yy2arr1019 {
				r.EncodeArrayStart(2)
			} else {
				yynn1019 = 2
				for _, b := range yyq1019 {
					if b {
						yynn1019++
					}
				}
				r.EncodeMapStart(yynn1019)
				yynn1019 = 0
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1021 := z.EncBinary()
				_ = yym1021
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1022 := z.EncBinary()
				_ = yym1022
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1024 := z.EncBinary()
				_ = yym1024
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPortRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1026 := z.DecBinary()
	_ = yym1026
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1027 := r.ContainerType()
		if yyct1027 == codecSelferValueTypeMap1234 {
			yyl1027 := r.ReadMapStart()
			if yyl1027 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1027, d)
			}
		} else if yyct1027 == codecSelferValueTypeArray1234 {
			yyl1027 := r.ReadArrayStart()
			if yyl1027 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1027, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPortRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1028Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1028Slc
	var yyhl1028 bool = l >= 0
	for yyj1028 := 0; ; yyj1028++ {
		if yyhl1028 {
			if yyj1028 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1028Slc = r.DecodeBytes(yys1028Slc, true, true)
		yys1028 := string(yys1028Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1028 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1028)
		} // end switch yys1028
	} // end for yyj1028
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPortRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1031 int
	var yyb1031 bool
	var yyhl1031 bool = l >= 0
	yyj1031++
	if yyhl1031 {
		yyb1031 = yyj1031 > l
	} else {
		yyb1031 = r.CheckBreak()
	}
	if yyb1031 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1031++
	if yyhl1031 {
		yyb1031 = yyj1031 > l
	} else {
		yyb1031 = r.CheckBreak()
	}
	if yyb1031 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj1031++
		if yyhl1031 {
			yyb1031 = yyj1031 > l
		} else {
			yyb1031 = r.CheckBreak()
		}
		if yyb1031 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1031-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1034 := z.EncBinary()
	_ = yym1034
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1035 := z.DecBinary()
	_ = yym1035
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SELinuxStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1036 := z.EncBinary()
		_ = yym1036
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1037 := !z.EncBinary()
			yy2arr1037 := z.EncBasicHandle().StructToArray
			var yyq1037 [2]bool
			_, _, _ = yysep1037, yyq1037, yy2arr1037
			const yyr1037 bool = false
			yyq1037[1] = x.SELinuxOptions != nil
			var yynn1037 int
			if yyr1037 || yy2arr1037 {
				r.EncodeArrayStart(2)
			} else {
				yynn1037 = 1
				for _, b := range yyq1037 {
					if b {
						yynn1037++
					}
				}
				r.EncodeMapStart(yynn1037)
				yynn1037 = 0
			}
			if yyr1037 || yy2arr1037 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1037 || yy2arr1037 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1037[1] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1037[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1037 || yy2arr1037 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SELinuxStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1040 := z.DecBinary()
	_ = yym1040
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1041 := r.ContainerType()
		if yyct1041 == codecSelferValueTypeMap1234 {
			yyl1041 := r.ReadMapStart()
			if yyl1041 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1041, d)
			}
		} else if yyct1041 == codecSelferValueTypeArray1234 {
			yyl1041 := r.ReadArrayStart()
			if yyl1041 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1041, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1042Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1042Slc
	var yyhl1042 bool = l >= 0
	for yyj1042 := 0; ; yyj1042++ {
		if yyhl1042 {
			if yyj1042 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1042Slc = r.DecodeBytes(yys1042Slc, true, true)
		yys1042 := string(yys1042Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1042 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SELinuxStrategy(r.DecodeString())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(pkg2_api.SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1042)
		} // end switch yys1042
	} // end for yyj1042
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1045 int
	var yyb1045 bool
	var yyhl1045 bool = l >= 0
	yyj1045++
	if yyhl1045 {
		yyb1045 = yyj1045 > l
	} else {
		yyb1045 = r.CheckBreak()
	}
	if yyb1045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SELinuxStrategy(r.DecodeString())
	}
	yyj1045++
	if yyhl1045 {
		yyb1045 = yyj1045 > l
	} else {
		yyb1045 = r.CheckBreak()
	}
	if yyb1045 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(pkg2_api.SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	for {
		yyj1045++
		if yyhl1045 {
			yyb1045 = yyj1045 > l
		} else {
			yyb1045 = r.CheckBreak()
		}
		if yyb1045 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1045-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SELinuxStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1048 := z.EncBinary()
	_ = yym1048
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SELinuxStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1049 := z.DecBinary()
	_ = yym1049
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RunAsUserStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1050 := z.EncBinary()
		_ = yym1050
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1051 := !z.EncBinary()
			yy2arr1051 := z.EncBasicHandle().StructToArray
			var yyq1051 [2]bool
			_, _, _ = yysep1051, yyq1051, yy2arr1051
			const yyr1051 bool = false
			yyq1051[1] = len(x.Ranges) != 0
			var yynn1051 int
			if yyr1051 || yy2arr1051 {
				r.EncodeArrayStart(2)
			} else {
				yynn1051 = 1
				for _, b := range yyq1051 {
					if b {
						yynn1051++
					}
				}
				r.EncodeMapStart(yynn1051)
				yynn1051 = 0
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1051[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1054 := z.EncBinary()
						_ = yym1054
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1051[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1055 := z.EncBinary()
						_ = yym1055
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1051 || yy2arr1051 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RunAsUserStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1056 := z.DecBinary()
	_ = yym1056
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1057 := r.ContainerType()
		if yyct1057 == codecSelferValueTypeMap1234 {
			yyl1057 := r.ReadMapStart()
			if yyl1057 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1057, d)
			}
		} else if yyct1057 == codecSelferValueTypeArray1234 {
			yyl1057 := r.ReadArrayStart()
			if yyl1057 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1057, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1058Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1058Slc
	var yyhl1058 bool = l >= 0
	for yyj1058 := 0; ; yyj1058++ {
		if yyhl1058 {
			if yyj1058 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1058Slc = r.DecodeBytes(yys1058Slc, true, true)
		yys1058 := string(yys1058Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1058 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = RunAsUserStrategy(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1060 := &x.Ranges
				yym1061 := z.DecBinary()
				_ = yym1061
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1060), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1058)
		} // end switch yys1058
	} // end for yyj1058
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1062 int
	var yyb1062 bool
	var yyhl1062 bool = l >= 0
	yyj1062++
	if yyhl1062 {
		yyb1062 = yyj1062 > l
	} else {
		yyb1062 = r.CheckBreak()
	}
	if yyb1062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = RunAsUserStrategy(r.DecodeString())
	}
	yyj1062++
	if yyhl1062 {
		yyb1062 = yyj1062 > l
	} else {
		yyb1062 = r.CheckBreak()
	}
	if yyb1062 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1064 := &x.Ranges
		yym1065 := z.DecBinary()
		_ = yym1065
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1064), d)
		}
	}
	for {
		yyj1062++
		if yyhl1062 {
			yyb1062 = yyj1062 > l
		} else {
			yyb1062 = r.CheckBreak()
		}
		if yyb1062 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1062-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IDRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1066 := z.EncBinary()
		_ = yym1066
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1067 := !z.EncBinary()
			yy2arr1067 := z.EncBasicHandle().StructToArray
			var yyq1067 [2]bool
			_, _, _ = yysep1067, yyq1067, yy2arr1067
			const yyr1067 bool = false
			var yynn1067 int
			if yyr1067 || yy2arr1067 {
				r.EncodeArrayStart(2)
			} else {
				yynn1067 = 2
				for _, b := range yyq1067 {
					if b {
						yynn1067++
					}
				}
				r.EncodeMapStart(yynn1067)
				yynn1067 = 0
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1069 := z.EncBinary()
				_ = yym1069
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1070 := z.EncBinary()
				_ = yym1070
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1072 := z.EncBinary()
				_ = yym1072
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1073 := z.EncBinary()
				_ = yym1073
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IDRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1074 := z.DecBinary()
	_ = yym1074
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1075 := r.ContainerType()
		if yyct1075 == codecSelferValueTypeMap1234 {
			yyl1075 := r.ReadMapStart()
			if yyl1075 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1075, d)
			}
		} else if yyct1075 == codecSelferValueTypeArray1234 {
			yyl1075 := r.ReadArrayStart()
			if yyl1075 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1075, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IDRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1076Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1076Slc
	var yyhl1076 bool = l >= 0
	for yyj1076 := 0; ; yyj1076++ {
		if yyhl1076 {
			if yyj1076 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1076Slc = r.DecodeBytes(yys1076Slc, true, true)
		yys1076 := string(yys1076Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1076 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int64(r.DecodeInt(64))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1076)
		} // end switch yys1076
	} // end for yyj1076
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IDRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1079 int
	var yyb1079 bool
	var yyhl1079 bool = l >= 0
	yyj1079++
	if yyhl1079 {
		yyb1079 = yyj1079 > l
	} else {
		yyb1079 = r.CheckBreak()
	}
	if yyb1079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int64(r.DecodeInt(64))
	}
	yyj1079++
	if yyhl1079 {
		yyb1079 = yyj1079 > l
	} else {
		yyb1079 = r.CheckBreak()
	}
	if yyb1079 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int64(r.DecodeInt(64))
	}
	for {
		yyj1079++
		if yyhl1079 {
			yyb1079 = yyj1079 > l
		} else {
			yyb1079 = r.CheckBreak()
		}
		if yyb1079 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1079-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RunAsUserStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1082 := z.EncBinary()
	_ = yym1082
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RunAsUserStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1083 := z.DecBinary()
	_ = yym1083
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *FSGroupStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1084 := z.EncBinary()
		_ = yym1084
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1085 := !z.EncBinary()
			yy2arr1085 := z.EncBasicHandle().StructToArray
			var yyq1085 [2]bool
			_, _, _ = yysep1085, yyq1085, yy2arr1085
			const yyr1085 bool = false
			yyq1085[0] = x.Rule != ""
			yyq1085[1] = len(x.Ranges) != 0
			var yynn1085 int
			if yyr1085 || yy2arr1085 {
				r.EncodeArrayStart(2)
			} else {
				yynn1085 = 0
				for _, b := range yyq1085 {
					if b {
						yynn1085++
					}
				}
				r.EncodeMapStart(yynn1085)
				yynn1085 = 0
			}
			if yyr1085 || yy2arr1085 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1085[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1085[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1085 || yy2arr1085 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1085[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1088 := z.EncBinary()
						_ = yym1088
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1085[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1089 := z.EncBinary()
						_ = yym1089
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1085 || yy2arr1085 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FSGroupStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1090 := z.DecBinary()
	_ = yym1090
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1091 := r.ContainerType()
		if yyct1091 == codecSelferValueTypeMap1234 {
			yyl1091 := r.ReadMapStart()
			if yyl1091 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1091, d)
			}
		} else if yyct1091 == codecSelferValueTypeArray1234 {
			yyl1091 := r.ReadArrayStart()
			if yyl1091 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1091, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1092Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1092Slc
	var yyhl1092 bool = l >= 0
	for yyj1092 := 0; ; yyj1092++ {
		if yyhl1092 {
			if yyj1092 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1092Slc = r.DecodeBytes(yys1092Slc, true, true)
		yys1092 := string(yys1092Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1092 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = FSGroupStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1094 := &x.Ranges
				yym1095 := z.DecBinary()
				_ = yym1095
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1094), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1092)
		} // end switch yys1092
	} // end for yyj1092
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1096 int
	var yyb1096 bool
	var yyhl1096 bool = l >= 0
	yyj1096++
	if yyhl1096 {
		yyb1096 = yyj1096 > l
	} else {
		yyb1096 = r.CheckBreak()
	}
	if yyb1096 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = FSGroupStrategyType(r.DecodeString())
	}
	yyj1096++
	if yyhl1096 {
		yyb1096 = yyj1096 > l
	} else {
		yyb1096 = r.CheckBreak()
	}
	if yyb1096 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1098 := &x.Ranges
		yym1099 := z.DecBinary()
		_ = yym1099
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1098), d)
		}
	}
	for {
		yyj1096++
		if yyhl1096 {
			yyb1096 = yyj1096 > l
		} else {
			yyb1096 = r.CheckBreak()
		}
		if yyb1096 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1096-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSGroupStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1100 := z.EncBinary()
	_ = yym1100
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSGroupStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1101 := z.DecBinary()
	_ = yym1101
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1102 := z.EncBinary()
		_ = yym1102
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1103 := !z.EncBinary()
			yy2arr1103 := z.EncBasicHandle().StructToArray
			var yyq1103 [2]bool
			_, _, _ = yysep1103, yyq1103, yy2arr1103
			const yyr1103 bool = false
			yyq1103[0] = x.Rule != ""
			yyq1103[1] = len(x.Ranges) != 0
			var yynn1103 int
			if yyr1103 || yy2arr1103 {
				r.EncodeArrayStart(2)
			} else {
				yynn1103 = 0
				for _, b := range yyq1103 {
					if b {
						yynn1103++
					}
				}
				r.EncodeMapStart(yynn1103)
				yynn1103 = 0
			}
			if yyr1103 || yy2arr1103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1103[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1103[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1103 || yy2arr1103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1103[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1106 := z.EncBinary()
						_ = yym1106
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1103[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1107 := z.EncBinary()
						_ = yym1107
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1103 || yy2arr1103 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1108 := z.DecBinary()
	_ = yym1108
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1109 := r.ContainerType()
		if yyct1109 == codecSelferValueTypeMap1234 {
			yyl1109 := r.ReadMapStart()
			if yyl1109 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1109, d)
			}
		} else if yyct1109 == codecSelferValueTypeArray1234 {
			yyl1109 := r.ReadArrayStart()
			if yyl1109 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1109, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1110Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1110Slc
	var yyhl1110 bool = l >= 0
	for yyj1110 := 0; ; yyj1110++ {
		if yyhl1110 {
			if yyj1110 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1110Slc = r.DecodeBytes(yys1110Slc, true, true)
		yys1110 := string(yys1110Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1110 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1112 := &x.Ranges
				yym1113 := z.DecBinary()
				_ = yym1113
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1112), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1110)
		} // end switch yys1110
	} // end for yyj1110
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1114 int
	var yyb1114 bool
	var yyhl1114 bool = l >= 0
	yyj1114++
	if yyhl1114 {
		yyb1114 = yyj1114 > l
	} else {
		yyb1114 = r.CheckBreak()
	}
	if yyb1114 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
	}
	yyj1114++
	if yyhl1114 {
		yyb1114 = yyj1114 > l
	} else {
		yyb1114 = r.CheckBreak()
	}
	if yyb1114 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1116 := &x.Ranges
		yym1117 := z.DecBinary()
		_ = yym1117
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1116), d)
		}
	}
	for {
		yyj1114++
		if yyhl1114 {
			yyb1114 = yyj1114 > l
		} else {
			yyb1114 = r.CheckBreak()
		}
		if yyb1114 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1114-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SupplementalGroupsStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1118 := z.EncBinary()
	_ = yym1118
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SupplementalGroupsStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1119 := z.DecBinary()
	_ = yym1119
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSecurityPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1120 := z.EncBinary()
		_ = yym1120
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1121 := !z.EncBinary()
			yy2arr1121 := z.EncBasicHandle().StructToArray
			var yyq1121 [4]bool
			_, _, _ = yysep1121, yyq1121, yy2arr1121
			const yyr1121 bool = false
			yyq1121[0] = x.Kind != ""
			yyq1121[1] = x.APIVersion != ""
			yyq1121[2] = true
			var yynn1121 int
			if yyr1121 || yy2arr1121 {
				r.EncodeArrayStart(4)
			} else {
				yynn1121 = 1
				for _, b := range yyq1121 {
					if b {
						yynn1121++
					}
				}
				r.EncodeMapStart(yynn1121)
				yynn1121 = 0
			}
			if yyr1121 || yy2arr1121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1121[0] {
					yym1123 := z.EncBinary()
					_ = yym1123
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1121[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1124 := z.EncBinary()
					_ = yym1124
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1121 || yy2arr1121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1121[1] {
					yym1126 := z.EncBinary()
					_ = yym1126
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1121[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1127 := z.EncBinary()
					_ = yym1127
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1121 || yy2arr1121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1121[2] {
					yy1129 := &x.ListMeta
					yym1130 := z.EncBinary()
					_ = yym1130
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1129) {
					} else {
						z.EncFallback(yy1129)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1121[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1131 := &x.ListMeta
					yym1132 := z.EncBinary()
					_ = yym1132
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1131) {
					} else {
						z.EncFallback(yy1131)
					}
				}
			}
			if yyr1121 || yy2arr1121 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1134 := z.EncBinary()
					_ = yym1134
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1135 := z.EncBinary()
					_ = yym1135
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			}
			if yyr1121 || yy2arr1121 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1136 := z.DecBinary()
	_ = yym1136
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1137 := r.ContainerType()
		if yyct1137 == codecSelferValueTypeMap1234 {
			yyl1137 := r.ReadMapStart()
			if yyl1137 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1137, d)
			}
		} else if yyct1137 == codecSelferValueTypeArray1234 {
			yyl1137 := r.ReadArrayStart()
			if yyl1137 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1137, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1138Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1138Slc
	var yyhl1138 bool = l >= 0
	for yyj1138 := 0; ; yyj1138++ {
		if yyhl1138 {
			if yyj1138 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1138Slc = r.DecodeBytes(yys1138Slc, true, true)
		yys1138 := string(yys1138Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1138 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1141 := &x.ListMeta
				yym1142 := z.DecBinary()
				_ = yym1142
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1141) {
				} else {
					z.DecFallback(yyv1141, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1143 := &x.Items
				yym1144 := z.DecBinary()
				_ = yym1144
				if false {
				} else {
					h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1143), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1138)
		} // end switch yys1138
	} // end for yyj1138
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1145 int
	var yyb1145 bool
	var yyhl1145 bool = l >= 0
	yyj1145++
	if yyhl1145 {
		yyb1145 = yyj1145 > l
	} else {
		yyb1145 = r.CheckBreak()
	}
	if yyb1145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1145++
	if yyhl1145 {
		yyb1145 = yyj1145 > l
	} else {
		yyb1145 = r.CheckBreak()
	}
	if yyb1145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1145++
	if yyhl1145 {
		yyb1145 = yyj1145 > l
	} else {
		yyb1145 = r.CheckBreak()
	}
	if yyb1145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1148 := &x.ListMeta
		yym1149 := z.DecBinary()
		_ = yym1149
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1148) {
		} else {
			z.DecFallback(yyv1148, false)
		}
	}
	yyj1145++
	if yyhl1145 {
		yyb1145 = yyj1145 > l
	} else {
		yyb1145 = r.CheckBreak()
	}
	if yyb1145 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1150 := &x.Items
		yym1151 := z.DecBinary()
		_ = yym1151
		if false {
		} else {
			h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1150), d)
		}
	}
	for {
		yyj1145++
		if yyhl1145 {
			yyb1145 = yyj1145 > l
		} else {
			yyb1145 = r.CheckBreak()
		}
		if yyb1145 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1145-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1152 := z.EncBinary()
		_ = yym1152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1153 := !z.EncBinary()
			yy2arr1153 := z.EncBasicHandle().StructToArray
			var yyq1153 [4]bool
			_, _, _ = yysep1153, yyq1153, yy2arr1153
			const yyr1153 bool = false
			yyq1153[0] = x.Kind != ""
			yyq1153[1] = x.APIVersion != ""
			yyq1153[2] = true
			yyq1153[3] = true
			var yynn1153 int
			if yyr1153 || yy2arr1153 {
				r.EncodeArrayStart(4)
			} else {
				yynn1153 = 0
				for _, b := range yyq1153 {
					if b {
						yynn1153++
					}
				}
				r.EncodeMapStart(yynn1153)
				yynn1153 = 0
			}
			if yyr1153 || yy2arr1153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1153[0] {
					yym1155 := z.EncBinary()
					_ = yym1155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1153[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1156 := z.EncBinary()
					_ = yym1156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1153 || yy2arr1153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1153[1] {
					yym1158 := z.EncBinary()
					_ = yym1158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1153[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1159 := z.EncBinary()
					_ = yym1159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1153 || yy2arr1153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1153[2] {
					yy1161 := &x.ObjectMeta
					yy1161.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1153[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1162 := &x.ObjectMeta
					yy1162.CodecEncodeSelf(e)
				}
			}
			if yyr1153 || yy2arr1153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1153[3] {
					yy1164 := &x.Spec
					yy1164.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1153[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1165 := &x.Spec
					yy1165.CodecEncodeSelf(e)
				}
			}
			if yyr1153 || yy2arr1153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1166 := z.DecBinary()
	_ = yym1166
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1167 := r.ContainerType()
		if yyct1167 == codecSelferValueTypeMap1234 {
			yyl1167 := r.ReadMapStart()
			if yyl1167 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1167, d)
			}
		} else if yyct1167 == codecSelferValueTypeArray1234 {
			yyl1167 := r.ReadArrayStart()
			if yyl1167 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1167, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1168Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1168Slc
	var yyhl1168 bool = l >= 0
	for yyj1168 := 0; ; yyj1168++ {
		if yyhl1168 {
			if yyj1168 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1168Slc = r.DecodeBytes(yys1168Slc, true, true)
		yys1168 := string(yys1168Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1168 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv1171 := &x.ObjectMeta
				yyv1171.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NetworkPolicySpec{}
			} else {
				yyv1172 := &x.Spec
				yyv1172.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1168)
		} // end switch yys1168
	} // end for yyj1168
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1173 int
	var yyb1173 bool
	var yyhl1173 bool = l >= 0
	yyj1173++
	if yyhl1173 {
		yyb1173 = yyj1173 > l
	} else {
		yyb1173 = r.CheckBreak()
	}
	if yyb1173 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1173++
	if yyhl1173 {
		yyb1173 = yyj1173 > l
	} else {
		yyb1173 = r.CheckBreak()
	}
	if yyb1173 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1173++
	if yyhl1173 {
		yyb1173 = yyj1173 > l
	} else {
		yyb1173 = r.CheckBreak()
	}
	if yyb1173 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv1176 := &x.ObjectMeta
		yyv1176.CodecDecodeSelf(d)
	}
	yyj1173++
	if yyhl1173 {
		yyb1173 = yyj1173 > l
	} else {
		yyb1173 = r.CheckBreak()
	}
	if yyb1173 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NetworkPolicySpec{}
	} else {
		yyv1177 := &x.Spec
		yyv1177.CodecDecodeSelf(d)
	}
	for {
		yyj1173++
		if yyhl1173 {
			yyb1173 = yyj1173 > l
		} else {
			yyb1173 = r.CheckBreak()
		}
		if yyb1173 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1173-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1178 := z.EncBinary()
		_ = yym1178
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1179 := !z.EncBinary()
			yy2arr1179 := z.EncBasicHandle().StructToArray
			var yyq1179 [2]bool
			_, _, _ = yysep1179, yyq1179, yy2arr1179
			const yyr1179 bool = false
			yyq1179[1] = len(x.Ingress) != 0
			var yynn1179 int
			if yyr1179 || yy2arr1179 {
				r.EncodeArrayStart(2)
			} else {
				yynn1179 = 1
				for _, b := range yyq1179 {
					if b {
						yynn1179++
					}
				}
				r.EncodeMapStart(yynn1179)
				yynn1179 = 0
			}
			if yyr1179 || yy2arr1179 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1181 := &x.PodSelector
				yym1182 := z.EncBinary()
				_ = yym1182
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1181) {
				} else {
					z.EncFallback(yy1181)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1183 := &x.PodSelector
				yym1184 := z.EncBinary()
				_ = yym1184
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1183) {
				} else {
					z.EncFallback(yy1183)
				}
			}
			if yyr1179 || yy2arr1179 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1179[1] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1186 := z.EncBinary()
						_ = yym1186
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1179[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1187 := z.EncBinary()
						_ = yym1187
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1179 || yy2arr1179 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1188 := z.DecBinary()
	_ = yym1188
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1189 := r.ContainerType()
		if yyct1189 == codecSelferValueTypeMap1234 {
			yyl1189 := r.ReadMapStart()
			if yyl1189 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1189, d)
			}
		} else if yyct1189 == codecSelferValueTypeArray1234 {
			yyl1189 := r.ReadArrayStart()
			if yyl1189 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1189, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1190Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1190Slc
	var yyhl1190 bool = l >= 0
	for yyj1190 := 0; ; yyj1190++ {
		if yyhl1190 {
			if yyj1190 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1190Slc = r.DecodeBytes(yys1190Slc, true, true)
		yys1190 := string(yys1190Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1190 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				x.PodSelector = pkg1_unversioned.LabelSelector{}
			} else {
				yyv1191 := &x.PodSelector
				yym1192 := z.DecBinary()
				_ = yym1192
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1191) {
				} else {
					z.DecFallback(yyv1191, false)
				}
			}
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1193 := &x.Ingress
				yym1194 := z.DecBinary()
				_ = yym1194
				if false {
				} else {
					h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1193), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1190)
		} // end switch yys1190
	} // end for yyj1190
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1195 int
	var yyb1195 bool
	var yyhl1195 bool = l >= 0
	yyj1195++
	if yyhl1195 {
		yyb1195 = yyj1195 > l
	} else {
		yyb1195 = r.CheckBreak()
	}
	if yyb1195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSelector = pkg1_unversioned.LabelSelector{}
	} else {
		yyv1196 := &x.PodSelector
		yym1197 := z.DecBinary()
		_ = yym1197
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1196) {
		} else {
			z.DecFallback(yyv1196, false)
		}
	}
	yyj1195++
	if yyhl1195 {
		yyb1195 = yyj1195 > l
	} else {
		yyb1195 = r.CheckBreak()
	}
	if yyb1195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1198 := &x.Ingress
		yym1199 := z.DecBinary()
		_ = yym1199
		if false {
		} else {
			h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1198), d)
		}
	}
	for {
		yyj1195++
		if yyhl1195 {
			yyb1195 = yyj1195 > l
		} else {
			yyb1195 = r.CheckBreak()
		}
		if yyb1195 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1195-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyIngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1200 := z.EncBinary()
		_ = yym1200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1201 := !z.EncBinary()
			yy2arr1201 := z.EncBasicHandle().StructToArray
			var yyq1201 [2]bool
			_, _, _ = yysep1201, yyq1201, yy2arr1201
			const yyr1201 bool = false
			yyq1201[0] = len(x.Ports) != 0
			yyq1201[1] = len(x.From) != 0
			var yynn1201 int
			if yyr1201 || yy2arr1201 {
				r.EncodeArrayStart(2)
			} else {
				yynn1201 = 0
				for _, b := range yyq1201 {
					if b {
						yynn1201++
					}
				}
				r.EncodeMapStart(yynn1201)
				yynn1201 = 0
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1201[0] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1203 := z.EncBinary()
						_ = yym1203
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1201[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1204 := z.EncBinary()
						_ = yym1204
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1201[1] {
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1206 := z.EncBinary()
						_ = yym1206
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1201[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("from"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1207 := z.EncBinary()
						_ = yym1207
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				}
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyIngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1208 := z.DecBinary()
	_ = yym1208
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1209 := r.ContainerType()
		if yyct1209 == codecSelferValueTypeMap1234 {
			yyl1209 := r.ReadMapStart()
			if yyl1209 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1209, d)
			}
		} else if yyct1209 == codecSelferValueTypeArray1234 {
			yyl1209 := r.ReadArrayStart()
			if yyl1209 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1209, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1210Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1210Slc
	var yyhl1210 bool = l >= 0
	for yyj1210 := 0; ; yyj1210++ {
		if yyhl1210 {
			if yyj1210 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1210Slc = r.DecodeBytes(yys1210Slc, true, true)
		yys1210 := string(yys1210Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1210 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1211 := &x.Ports
				yym1212 := z.DecBinary()
				_ = yym1212
				if false {
				} else {
					h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1211), d)
				}
			}
		case "from":
			if r.TryDecodeAsNil() {
				x.From = nil
			} else {
				yyv1213 := &x.From
				yym1214 := z.DecBinary()
				_ = yym1214
				if false {
				} else {
					h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1213), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1210)
		} // end switch yys1210
	} // end for yyj1210
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1215 int
	var yyb1215 bool
	var yyhl1215 bool = l >= 0
	yyj1215++
	if yyhl1215 {
		yyb1215 = yyj1215 > l
	} else {
		yyb1215 = r.CheckBreak()
	}
	if yyb1215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1216 := &x.Ports
		yym1217 := z.DecBinary()
		_ = yym1217
		if false {
		} else {
			h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1216), d)
		}
	}
	yyj1215++
	if yyhl1215 {
		yyb1215 = yyj1215 > l
	} else {
		yyb1215 = r.CheckBreak()
	}
	if yyb1215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.From = nil
	} else {
		yyv1218 := &x.From
		yym1219 := z.DecBinary()
		_ = yym1219
		if false {
		} else {
			h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1218), d)
		}
	}
	for {
		yyj1215++
		if yyhl1215 {
			yyb1215 = yyj1215 > l
		} else {
			yyb1215 = r.CheckBreak()
		}
		if yyb1215 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1215-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1220 := z.EncBinary()
		_ = yym1220
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1221 := !z.EncBinary()
			yy2arr1221 := z.EncBasicHandle().StructToArray
			var yyq1221 [2]bool
			_, _, _ = yysep1221, yyq1221, yy2arr1221
			const yyr1221 bool = false
			yyq1221[0] = x.Protocol != nil
			yyq1221[1] = x.Port != nil
			var yynn1221 int
			if yyr1221 || yy2arr1221 {
				r.EncodeArrayStart(2)
			} else {
				yynn1221 = 0
				for _, b := range yyq1221 {
					if b {
						yynn1221++
					}
				}
				r.EncodeMapStart(yynn1221)
				yynn1221 = 0
			}
			if yyr1221 || yy2arr1221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1221[0] {
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1223 := *x.Protocol
						yym1224 := z.EncBinary()
						_ = yym1224
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1223) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1223))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1221[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1225 := *x.Protocol
						yym1226 := z.EncBinary()
						_ = yym1226
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1225) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1225))
						}
					}
				}
			}
			if yyr1221 || yy2arr1221 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1221[1] {
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1228 := z.EncBinary()
						_ = yym1228
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1228 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1221[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1229 := z.EncBinary()
						_ = yym1229
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1229 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				}
			}
			if yyr1221 || yy2arr1221 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1230 := z.DecBinary()
	_ = yym1230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1231 := r.ContainerType()
		if yyct1231 == codecSelferValueTypeMap1234 {
			yyl1231 := r.ReadMapStart()
			if yyl1231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1231, d)
			}
		} else if yyct1231 == codecSelferValueTypeArray1234 {
			yyl1231 := r.ReadArrayStart()
			if yyl1231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1232Slc
	var yyhl1232 bool = l >= 0
	for yyj1232 := 0; ; yyj1232++ {
		if yyhl1232 {
			if yyj1232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1232Slc = r.DecodeBytes(yys1232Slc, true, true)
		yys1232 := string(yys1232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1232 {
		case "protocol":
			if r.TryDecodeAsNil() {
				if x.Protocol != nil {
					x.Protocol = nil
				}
			} else {
				if x.Protocol == nil {
					x.Protocol = new(pkg2_api.Protocol)
				}
				x.Protocol.CodecDecodeSelf(d)
			}
		case "port":
			if r.TryDecodeAsNil() {
				if x.Port != nil {
					x.Port = nil
				}
			} else {
				if x.Port == nil {
					x.Port = new(pkg5_intstr.IntOrString)
				}
				yym1235 := z.DecBinary()
				_ = yym1235
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Port) {
				} else if !yym1235 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Port)
				} else {
					z.DecFallback(x.Port, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1232)
		} // end switch yys1232
	} // end for yyj1232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1236 int
	var yyb1236 bool
	var yyhl1236 bool = l >= 0
	yyj1236++
	if yyhl1236 {
		yyb1236 = yyj1236 > l
	} else {
		yyb1236 = r.CheckBreak()
	}
	if yyb1236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Protocol != nil {
			x.Protocol = nil
		}
	} else {
		if x.Protocol == nil {
			x.Protocol = new(pkg2_api.Protocol)
		}
		x.Protocol.CodecDecodeSelf(d)
	}
	yyj1236++
	if yyhl1236 {
		yyb1236 = yyj1236 > l
	} else {
		yyb1236 = r.CheckBreak()
	}
	if yyb1236 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Port != nil {
			x.Port = nil
		}
	} else {
		if x.Port == nil {
			x.Port = new(pkg5_intstr.IntOrString)
		}
		yym1239 := z.DecBinary()
		_ = yym1239
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Port) {
		} else if !yym1239 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Port)
		} else {
			z.DecFallback(x.Port, false)
		}
	}
	for {
		yyj1236++
		if yyhl1236 {
			yyb1236 = yyj1236 > l
		} else {
			yyb1236 = r.CheckBreak()
		}
		if yyb1236 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1236-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPeer) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1240 := z.EncBinary()
		_ = yym1240
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1241 := !z.EncBinary()
			yy2arr1241 := z.EncBasicHandle().StructToArray
			var yyq1241 [2]bool
			_, _, _ = yysep1241, yyq1241, yy2arr1241
			const yyr1241 bool = false
			yyq1241[0] = x.PodSelector != nil
			yyq1241[1] = x.NamespaceSelector != nil
			var yynn1241 int
			if yyr1241 || yy2arr1241 {
				r.EncodeArrayStart(2)
			} else {
				yynn1241 = 0
				for _, b := range yyq1241 {
					if b {
						yynn1241++
					}
				}
				r.EncodeMapStart(yynn1241)
				yynn1241 = 0
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1241[0] {
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1243 := z.EncBinary()
						_ = yym1243
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1241[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1244 := z.EncBinary()
						_ = yym1244
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1241[1] {
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1246 := z.EncBinary()
						_ = yym1246
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1241[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespaceSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1247 := z.EncBinary()
						_ = yym1247
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				}
			}
			if yyr1241 || yy2arr1241 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPeer) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1248 := z.DecBinary()
	_ = yym1248
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1249 := r.ContainerType()
		if yyct1249 == codecSelferValueTypeMap1234 {
			yyl1249 := r.ReadMapStart()
			if yyl1249 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1249, d)
			}
		} else if yyct1249 == codecSelferValueTypeArray1234 {
			yyl1249 := r.ReadArrayStart()
			if yyl1249 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1249, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1250Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1250Slc
	var yyhl1250 bool = l >= 0
	for yyj1250 := 0; ; yyj1250++ {
		if yyhl1250 {
			if yyj1250 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1250Slc = r.DecodeBytes(yys1250Slc, true, true)
		yys1250 := string(yys1250Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1250 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				if x.PodSelector != nil {
					x.PodSelector = nil
				}
			} else {
				if x.PodSelector == nil {
					x.PodSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1252 := z.DecBinary()
				_ = yym1252
				if false {
				} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
				} else {
					z.DecFallback(x.PodSelector, false)
				}
			}
		case "namespaceSelector":
			if r.TryDecodeAsNil() {
				if x.NamespaceSelector != nil {
					x.NamespaceSelector = nil
				}
			} else {
				if x.NamespaceSelector == nil {
					x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1254 := z.DecBinary()
				_ = yym1254
				if false {
				} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
				} else {
					z.DecFallback(x.NamespaceSelector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1250)
		} // end switch yys1250
	} // end for yyj1250
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1255 int
	var yyb1255 bool
	var yyhl1255 bool = l >= 0
	yyj1255++
	if yyhl1255 {
		yyb1255 = yyj1255 > l
	} else {
		yyb1255 = r.CheckBreak()
	}
	if yyb1255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodSelector != nil {
			x.PodSelector = nil
		}
	} else {
		if x.PodSelector == nil {
			x.PodSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1257 := z.DecBinary()
		_ = yym1257
		if false {
		} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
		} else {
			z.DecFallback(x.PodSelector, false)
		}
	}
	yyj1255++
	if yyhl1255 {
		yyb1255 = yyj1255 > l
	} else {
		yyb1255 = r.CheckBreak()
	}
	if yyb1255 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NamespaceSelector != nil {
			x.NamespaceSelector = nil
		}
	} else {
		if x.NamespaceSelector == nil {
			x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1259 := z.DecBinary()
		_ = yym1259
		if false {
		} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
		} else {
			z.DecFallback(x.NamespaceSelector, false)
		}
	}
	for {
		yyj1255++
		if yyhl1255 {
			yyb1255 = yyj1255 > l
		} else {
			yyb1255 = r.CheckBreak()
		}
		if yyb1255 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1255-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1260 := z.EncBinary()
		_ = yym1260
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1261 := !z.EncBinary()
			yy2arr1261 := z.EncBasicHandle().StructToArray
			var yyq1261 [4]bool
			_, _, _ = yysep1261, yyq1261, yy2arr1261
			const yyr1261 bool = false
			yyq1261[0] = x.Kind != ""
			yyq1261[1] = x.APIVersion != ""
			yyq1261[2] = true
			var yynn1261 int
			if yyr1261 || yy2arr1261 {
				r.EncodeArrayStart(4)
			} else {
				yynn1261 = 1
				for _, b := range yyq1261 {
					if b {
						yynn1261++
					}
				}
				r.EncodeMapStart(yynn1261)
				yynn1261 = 0
			}
			if yyr1261 || yy2arr1261 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1261[0] {
					yym1263 := z.EncBinary()
					_ = yym1263
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1261[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1264 := z.EncBinary()
					_ = yym1264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1261 || yy2arr1261 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1261[1] {
					yym1266 := z.EncBinary()
					_ = yym1266
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1261[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1267 := z.EncBinary()
					_ = yym1267
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1261 || yy2arr1261 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1261[2] {
					yy1269 := &x.ListMeta
					yym1270 := z.EncBinary()
					_ = yym1270
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1269) {
					} else {
						z.EncFallback(yy1269)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1261[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1271 := &x.ListMeta
					yym1272 := z.EncBinary()
					_ = yym1272
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1271) {
					} else {
						z.EncFallback(yy1271)
					}
				}
			}
			if yyr1261 || yy2arr1261 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1274 := z.EncBinary()
					_ = yym1274
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1275 := z.EncBinary()
					_ = yym1275
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			}
			if yyr1261 || yy2arr1261 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1276 := z.DecBinary()
	_ = yym1276
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1277 := r.ContainerType()
		if yyct1277 == codecSelferValueTypeMap1234 {
			yyl1277 := r.ReadMapStart()
			if yyl1277 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1277, d)
			}
		} else if yyct1277 == codecSelferValueTypeArray1234 {
			yyl1277 := r.ReadArrayStart()
			if yyl1277 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1277, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1278Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1278Slc
	var yyhl1278 bool = l >= 0
	for yyj1278 := 0; ; yyj1278++ {
		if yyhl1278 {
			if yyj1278 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1278Slc = r.DecodeBytes(yys1278Slc, true, true)
		yys1278 := string(yys1278Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1278 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1281 := &x.ListMeta
				yym1282 := z.DecBinary()
				_ = yym1282
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1281) {
				} else {
					z.DecFallback(yyv1281, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1283 := &x.Items
				yym1284 := z.DecBinary()
				_ = yym1284
				if false {
				} else {
					h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1283), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1278)
		} // end switch yys1278
	} // end for yyj1278
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1285 int
	var yyb1285 bool
	var yyhl1285 bool = l >= 0
	yyj1285++
	if yyhl1285 {
		yyb1285 = yyj1285 > l
	} else {
		yyb1285 = r.CheckBreak()
	}
	if yyb1285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1285++
	if yyhl1285 {
		yyb1285 = yyj1285 > l
	} else {
		yyb1285 = r.CheckBreak()
	}
	if yyb1285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1285++
	if yyhl1285 {
		yyb1285 = yyj1285 > l
	} else {
		yyb1285 = r.CheckBreak()
	}
	if yyb1285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1288 := &x.ListMeta
		yym1289 := z.DecBinary()
		_ = yym1289
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1288) {
		} else {
			z.DecFallback(yyv1288, false)
		}
	}
	yyj1285++
	if yyhl1285 {
		yyb1285 = yyj1285 > l
	} else {
		yyb1285 = r.CheckBreak()
	}
	if yyb1285 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1290 := &x.Items
		yym1291 := z.DecBinary()
		_ = yym1291
		if false {
		} else {
			h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1290), d)
		}
	}
	for {
		yyj1285++
		if yyhl1285 {
			yyb1285 = yyj1285 > l
		} else {
			yyb1285 = r.CheckBreak()
		}
		if yyb1285 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1285-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceCustomMetricTarget(v []CustomMetricTarget, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1292 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1293 := &yyv1292
		yy1293.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricTarget(v *[]CustomMetricTarget, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1294 := *v
	yyh1294, yyl1294 := z.DecSliceHelperStart()
	var yyc1294 bool
	if yyl1294 == 0 {
		if yyv1294 == nil {
			yyv1294 = []CustomMetricTarget{}
			yyc1294 = true
		} else if len(yyv1294) != 0 {
			yyv1294 = yyv1294[:0]
			yyc1294 = true
		}
	} else if yyl1294 > 0 {
		var yyrr1294, yyrl1294 int
		var yyrt1294 bool
		if yyl1294 > cap(yyv1294) {

			yyrg1294 := len(yyv1294) > 0
			yyv21294 := yyv1294
			yyrl1294, yyrt1294 = z.DecInferLen(yyl1294, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1294 {
				if yyrl1294 <= cap(yyv1294) {
					yyv1294 = yyv1294[:yyrl1294]
				} else {
					yyv1294 = make([]CustomMetricTarget, yyrl1294)
				}
			} else {
				yyv1294 = make([]CustomMetricTarget, yyrl1294)
			}
			yyc1294 = true
			yyrr1294 = len(yyv1294)
			if yyrg1294 {
				copy(yyv1294, yyv21294)
			}
		} else if yyl1294 != len(yyv1294) {
			yyv1294 = yyv1294[:yyl1294]
			yyc1294 = true
		}
		yyj1294 := 0
		for ; yyj1294 < yyrr1294; yyj1294++ {
			yyh1294.ElemContainerState(yyj1294)
			if r.TryDecodeAsNil() {
				yyv1294[yyj1294] = CustomMetricTarget{}
			} else {
				yyv1295 := &yyv1294[yyj1294]
				yyv1295.CodecDecodeSelf(d)
			}

		}
		if yyrt1294 {
			for ; yyj1294 < yyl1294; yyj1294++ {
				yyv1294 = append(yyv1294, CustomMetricTarget{})
				yyh1294.ElemContainerState(yyj1294)
				if r.TryDecodeAsNil() {
					yyv1294[yyj1294] = CustomMetricTarget{}
				} else {
					yyv1296 := &yyv1294[yyj1294]
					yyv1296.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1294 := 0
		for ; !r.CheckBreak(); yyj1294++ {

			if yyj1294 >= len(yyv1294) {
				yyv1294 = append(yyv1294, CustomMetricTarget{}) // var yyz1294 CustomMetricTarget
				yyc1294 = true
			}
			yyh1294.ElemContainerState(yyj1294)
			if yyj1294 < len(yyv1294) {
				if r.TryDecodeAsNil() {
					yyv1294[yyj1294] = CustomMetricTarget{}
				} else {
					yyv1297 := &yyv1294[yyj1294]
					yyv1297.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1294 < len(yyv1294) {
			yyv1294 = yyv1294[:yyj1294]
			yyc1294 = true
		} else if yyj1294 == 0 && yyv1294 == nil {
			yyv1294 = []CustomMetricTarget{}
			yyc1294 = true
		}
	}
	yyh1294.End()
	if yyc1294 {
		*v = yyv1294
	}
}

func (x codecSelfer1234) encSliceCustomMetricCurrentStatus(v []CustomMetricCurrentStatus, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1298 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1299 := &yyv1298
		yy1299.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricCurrentStatus(v *[]CustomMetricCurrentStatus, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1300 := *v
	yyh1300, yyl1300 := z.DecSliceHelperStart()
	var yyc1300 bool
	if yyl1300 == 0 {
		if yyv1300 == nil {
			yyv1300 = []CustomMetricCurrentStatus{}
			yyc1300 = true
		} else if len(yyv1300) != 0 {
			yyv1300 = yyv1300[:0]
			yyc1300 = true
		}
	} else if yyl1300 > 0 {
		var yyrr1300, yyrl1300 int
		var yyrt1300 bool
		if yyl1300 > cap(yyv1300) {

			yyrg1300 := len(yyv1300) > 0
			yyv21300 := yyv1300
			yyrl1300, yyrt1300 = z.DecInferLen(yyl1300, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1300 {
				if yyrl1300 <= cap(yyv1300) {
					yyv1300 = yyv1300[:yyrl1300]
				} else {
					yyv1300 = make([]CustomMetricCurrentStatus, yyrl1300)
				}
			} else {
				yyv1300 = make([]CustomMetricCurrentStatus, yyrl1300)
			}
			yyc1300 = true
			yyrr1300 = len(yyv1300)
			if yyrg1300 {
				copy(yyv1300, yyv21300)
			}
		} else if yyl1300 != len(yyv1300) {
			yyv1300 = yyv1300[:yyl1300]
			yyc1300 = true
		}
		yyj1300 := 0
		for ; yyj1300 < yyrr1300; yyj1300++ {
			yyh1300.ElemContainerState(yyj1300)
			if r.TryDecodeAsNil() {
				yyv1300[yyj1300] = CustomMetricCurrentStatus{}
			} else {
				yyv1301 := &yyv1300[yyj1300]
				yyv1301.CodecDecodeSelf(d)
			}

		}
		if yyrt1300 {
			for ; yyj1300 < yyl1300; yyj1300++ {
				yyv1300 = append(yyv1300, CustomMetricCurrentStatus{})
				yyh1300.ElemContainerState(yyj1300)
				if r.TryDecodeAsNil() {
					yyv1300[yyj1300] = CustomMetricCurrentStatus{}
				} else {
					yyv1302 := &yyv1300[yyj1300]
					yyv1302.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1300 := 0
		for ; !r.CheckBreak(); yyj1300++ {

			if yyj1300 >= len(yyv1300) {
				yyv1300 = append(yyv1300, CustomMetricCurrentStatus{}) // var yyz1300 CustomMetricCurrentStatus
				yyc1300 = true
			}
			yyh1300.ElemContainerState(yyj1300)
			if yyj1300 < len(yyv1300) {
				if r.TryDecodeAsNil() {
					yyv1300[yyj1300] = CustomMetricCurrentStatus{}
				} else {
					yyv1303 := &yyv1300[yyj1300]
					yyv1303.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1300 < len(yyv1300) {
			yyv1300 = yyv1300[:yyj1300]
			yyc1300 = true
		} else if yyj1300 == 0 && yyv1300 == nil {
			yyv1300 = []CustomMetricCurrentStatus{}
			yyc1300 = true
		}
	}
	yyh1300.End()
	if yyc1300 {
		*v = yyv1300
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1304 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1305 := &yyv1304
		yy1305.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1306 := *v
	yyh1306, yyl1306 := z.DecSliceHelperStart()
	var yyc1306 bool
	if yyl1306 == 0 {
		if yyv1306 == nil {
			yyv1306 = []APIVersion{}
			yyc1306 = true
		} else if len(yyv1306) != 0 {
			yyv1306 = yyv1306[:0]
			yyc1306 = true
		}
	} else if yyl1306 > 0 {
		var yyrr1306, yyrl1306 int
		var yyrt1306 bool
		if yyl1306 > cap(yyv1306) {

			yyrg1306 := len(yyv1306) > 0
			yyv21306 := yyv1306
			yyrl1306, yyrt1306 = z.DecInferLen(yyl1306, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1306 {
				if yyrl1306 <= cap(yyv1306) {
					yyv1306 = yyv1306[:yyrl1306]
				} else {
					yyv1306 = make([]APIVersion, yyrl1306)
				}
			} else {
				yyv1306 = make([]APIVersion, yyrl1306)
			}
			yyc1306 = true
			yyrr1306 = len(yyv1306)
			if yyrg1306 {
				copy(yyv1306, yyv21306)
			}
		} else if yyl1306 != len(yyv1306) {
			yyv1306 = yyv1306[:yyl1306]
			yyc1306 = true
		}
		yyj1306 := 0
		for ; yyj1306 < yyrr1306; yyj1306++ {
			yyh1306.ElemContainerState(yyj1306)
			if r.TryDecodeAsNil() {
				yyv1306[yyj1306] = APIVersion{}
			} else {
				yyv1307 := &yyv1306[yyj1306]
				yyv1307.CodecDecodeSelf(d)
			}

		}
		if yyrt1306 {
			for ; yyj1306 < yyl1306; yyj1306++ {
				yyv1306 = append(yyv1306, APIVersion{})
				yyh1306.ElemContainerState(yyj1306)
				if r.TryDecodeAsNil() {
					yyv1306[yyj1306] = APIVersion{}
				} else {
					yyv1308 := &yyv1306[yyj1306]
					yyv1308.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1306 := 0
		for ; !r.CheckBreak(); yyj1306++ {

			if yyj1306 >= len(yyv1306) {
				yyv1306 = append(yyv1306, APIVersion{}) // var yyz1306 APIVersion
				yyc1306 = true
			}
			yyh1306.ElemContainerState(yyj1306)
			if yyj1306 < len(yyv1306) {
				if r.TryDecodeAsNil() {
					yyv1306[yyj1306] = APIVersion{}
				} else {
					yyv1309 := &yyv1306[yyj1306]
					yyv1309.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1306 < len(yyv1306) {
			yyv1306 = yyv1306[:yyj1306]
			yyc1306 = true
		} else if yyj1306 == 0 && yyv1306 == nil {
			yyv1306 = []APIVersion{}
			yyc1306 = true
		}
	}
	yyh1306.End()
	if yyc1306 {
		*v = yyv1306
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1310 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1311 := &yyv1310
		yy1311.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1312 := *v
	yyh1312, yyl1312 := z.DecSliceHelperStart()
	var yyc1312 bool
	if yyl1312 == 0 {
		if yyv1312 == nil {
			yyv1312 = []ThirdPartyResource{}
			yyc1312 = true
		} else if len(yyv1312) != 0 {
			yyv1312 = yyv1312[:0]
			yyc1312 = true
		}
	} else if yyl1312 > 0 {
		var yyrr1312, yyrl1312 int
		var yyrt1312 bool
		if yyl1312 > cap(yyv1312) {

			yyrg1312 := len(yyv1312) > 0
			yyv21312 := yyv1312
			yyrl1312, yyrt1312 = z.DecInferLen(yyl1312, z.DecBasicHandle().MaxInitLen, 296)
			if yyrt1312 {
				if yyrl1312 <= cap(yyv1312) {
					yyv1312 = yyv1312[:yyrl1312]
				} else {
					yyv1312 = make([]ThirdPartyResource, yyrl1312)
				}
			} else {
				yyv1312 = make([]ThirdPartyResource, yyrl1312)
			}
			yyc1312 = true
			yyrr1312 = len(yyv1312)
			if yyrg1312 {
				copy(yyv1312, yyv21312)
			}
		} else if yyl1312 != len(yyv1312) {
			yyv1312 = yyv1312[:yyl1312]
			yyc1312 = true
		}
		yyj1312 := 0
		for ; yyj1312 < yyrr1312; yyj1312++ {
			yyh1312.ElemContainerState(yyj1312)
			if r.TryDecodeAsNil() {
				yyv1312[yyj1312] = ThirdPartyResource{}
			} else {
				yyv1313 := &yyv1312[yyj1312]
				yyv1313.CodecDecodeSelf(d)
			}

		}
		if yyrt1312 {
			for ; yyj1312 < yyl1312; yyj1312++ {
				yyv1312 = append(yyv1312, ThirdPartyResource{})
				yyh1312.ElemContainerState(yyj1312)
				if r.TryDecodeAsNil() {
					yyv1312[yyj1312] = ThirdPartyResource{}
				} else {
					yyv1314 := &yyv1312[yyj1312]
					yyv1314.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1312 := 0
		for ; !r.CheckBreak(); yyj1312++ {

			if yyj1312 >= len(yyv1312) {
				yyv1312 = append(yyv1312, ThirdPartyResource{}) // var yyz1312 ThirdPartyResource
				yyc1312 = true
			}
			yyh1312.ElemContainerState(yyj1312)
			if yyj1312 < len(yyv1312) {
				if r.TryDecodeAsNil() {
					yyv1312[yyj1312] = ThirdPartyResource{}
				} else {
					yyv1315 := &yyv1312[yyj1312]
					yyv1315.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1312 < len(yyv1312) {
			yyv1312 = yyv1312[:yyj1312]
			yyc1312 = true
		} else if yyj1312 == 0 && yyv1312 == nil {
			yyv1312 = []ThirdPartyResource{}
			yyc1312 = true
		}
	}
	yyh1312.End()
	if yyc1312 {
		*v = yyv1312
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1316 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1317 := &yyv1316
		yy1317.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1318 := *v
	yyh1318, yyl1318 := z.DecSliceHelperStart()
	var yyc1318 bool
	if yyl1318 == 0 {
		if yyv1318 == nil {
			yyv1318 = []Deployment{}
			yyc1318 = true
		} else if len(yyv1318) != 0 {
			yyv1318 = yyv1318[:0]
			yyc1318 = true
		}
	} else if yyl1318 > 0 {
		var yyrr1318, yyrl1318 int
		var yyrt1318 bool
		if yyl1318 > cap(yyv1318) {

			yyrg1318 := len(yyv1318) > 0
			yyv21318 := yyv1318
			yyrl1318, yyrt1318 = z.DecInferLen(yyl1318, z.DecBasicHandle().MaxInitLen, 800)
			if yyrt1318 {
				if yyrl1318 <= cap(yyv1318) {
					yyv1318 = yyv1318[:yyrl1318]
				} else {
					yyv1318 = make([]Deployment, yyrl1318)
				}
			} else {
				yyv1318 = make([]Deployment, yyrl1318)
			}
			yyc1318 = true
			yyrr1318 = len(yyv1318)
			if yyrg1318 {
				copy(yyv1318, yyv21318)
			}
		} else if yyl1318 != len(yyv1318) {
			yyv1318 = yyv1318[:yyl1318]
			yyc1318 = true
		}
		yyj1318 := 0
		for ; yyj1318 < yyrr1318; yyj1318++ {
			yyh1318.ElemContainerState(yyj1318)
			if r.TryDecodeAsNil() {
				yyv1318[yyj1318] = Deployment{}
			} else {
				yyv1319 := &yyv1318[yyj1318]
				yyv1319.CodecDecodeSelf(d)
			}

		}
		if yyrt1318 {
			for ; yyj1318 < yyl1318; yyj1318++ {
				yyv1318 = append(yyv1318, Deployment{})
				yyh1318.ElemContainerState(yyj1318)
				if r.TryDecodeAsNil() {
					yyv1318[yyj1318] = Deployment{}
				} else {
					yyv1320 := &yyv1318[yyj1318]
					yyv1320.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1318 := 0
		for ; !r.CheckBreak(); yyj1318++ {

			if yyj1318 >= len(yyv1318) {
				yyv1318 = append(yyv1318, Deployment{}) // var yyz1318 Deployment
				yyc1318 = true
			}
			yyh1318.ElemContainerState(yyj1318)
			if yyj1318 < len(yyv1318) {
				if r.TryDecodeAsNil() {
					yyv1318[yyj1318] = Deployment{}
				} else {
					yyv1321 := &yyv1318[yyj1318]
					yyv1321.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1318 < len(yyv1318) {
			yyv1318 = yyv1318[:yyj1318]
			yyc1318 = true
		} else if yyj1318 == 0 && yyv1318 == nil {
			yyv1318 = []Deployment{}
			yyc1318 = true
		}
	}
	yyh1318.End()
	if yyc1318 {
		*v = yyv1318
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1322 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1323 := &yyv1322
		yy1323.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1324 := *v
	yyh1324, yyl1324 := z.DecSliceHelperStart()
	var yyc1324 bool
	if yyl1324 == 0 {
		if yyv1324 == nil {
			yyv1324 = []DaemonSet{}
			yyc1324 = true
		} else if len(yyv1324) != 0 {
			yyv1324 = yyv1324[:0]
			yyc1324 = true
		}
	} else if yyl1324 > 0 {
		var yyrr1324, yyrl1324 int
		var yyrt1324 bool
		if yyl1324 > cap(yyv1324) {

			yyrg1324 := len(yyv1324) > 0
			yyv21324 := yyv1324
			yyrl1324, yyrt1324 = z.DecInferLen(yyl1324, z.DecBasicHandle().MaxInitLen, 728)
			if yyrt1324 {
				if yyrl1324 <= cap(yyv1324) {
					yyv1324 = yyv1324[:yyrl1324]
				} else {
					yyv1324 = make([]DaemonSet, yyrl1324)
				}
			} else {
				yyv1324 = make([]DaemonSet, yyrl1324)
			}
			yyc1324 = true
			yyrr1324 = len(yyv1324)
			if yyrg1324 {
				copy(yyv1324, yyv21324)
			}
		} else if yyl1324 != len(yyv1324) {
			yyv1324 = yyv1324[:yyl1324]
			yyc1324 = true
		}
		yyj1324 := 0
		for ; yyj1324 < yyrr1324; yyj1324++ {
			yyh1324.ElemContainerState(yyj1324)
			if r.TryDecodeAsNil() {
				yyv1324[yyj1324] = DaemonSet{}
			} else {
				yyv1325 := &yyv1324[yyj1324]
				yyv1325.CodecDecodeSelf(d)
			}

		}
		if yyrt1324 {
			for ; yyj1324 < yyl1324; yyj1324++ {
				yyv1324 = append(yyv1324, DaemonSet{})
				yyh1324.ElemContainerState(yyj1324)
				if r.TryDecodeAsNil() {
					yyv1324[yyj1324] = DaemonSet{}
				} else {
					yyv1326 := &yyv1324[yyj1324]
					yyv1326.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1324 := 0
		for ; !r.CheckBreak(); yyj1324++ {

			if yyj1324 >= len(yyv1324) {
				yyv1324 = append(yyv1324, DaemonSet{}) // var yyz1324 DaemonSet
				yyc1324 = true
			}
			yyh1324.ElemContainerState(yyj1324)
			if yyj1324 < len(yyv1324) {
				if r.TryDecodeAsNil() {
					yyv1324[yyj1324] = DaemonSet{}
				} else {
					yyv1327 := &yyv1324[yyj1324]
					yyv1327.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1324 < len(yyv1324) {
			yyv1324 = yyv1324[:yyj1324]
			yyc1324 = true
		} else if yyj1324 == 0 && yyv1324 == nil {
			yyv1324 = []DaemonSet{}
			yyc1324 = true
		}
	}
	yyh1324.End()
	if yyc1324 {
		*v = yyv1324
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1328 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1329 := &yyv1328
		yy1329.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1330 := *v
	yyh1330, yyl1330 := z.DecSliceHelperStart()
	var yyc1330 bool
	if yyl1330 == 0 {
		if yyv1330 == nil {
			yyv1330 = []ThirdPartyResourceData{}
			yyc1330 = true
		} else if len(yyv1330) != 0 {
			yyv1330 = yyv1330[:0]
			yyc1330 = true
		}
	} else if yyl1330 > 0 {
		var yyrr1330, yyrl1330 int
		var yyrt1330 bool
		if yyl1330 > cap(yyv1330) {

			yyrg1330 := len(yyv1330) > 0
			yyv21330 := yyv1330
			yyrl1330, yyrt1330 = z.DecInferLen(yyl1330, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt1330 {
				if yyrl1330 <= cap(yyv1330) {
					yyv1330 = yyv1330[:yyrl1330]
				} else {
					yyv1330 = make([]ThirdPartyResourceData, yyrl1330)
				}
			} else {
				yyv1330 = make([]ThirdPartyResourceData, yyrl1330)
			}
			yyc1330 = true
			yyrr1330 = len(yyv1330)
			if yyrg1330 {
				copy(yyv1330, yyv21330)
			}
		} else if yyl1330 != len(yyv1330) {
			yyv1330 = yyv1330[:yyl1330]
			yyc1330 = true
		}
		yyj1330 := 0
		for ; yyj1330 < yyrr1330; yyj1330++ {
			yyh1330.ElemContainerState(yyj1330)
			if r.TryDecodeAsNil() {
				yyv1330[yyj1330] = ThirdPartyResourceData{}
			} else {
				yyv1331 := &yyv1330[yyj1330]
				yyv1331.CodecDecodeSelf(d)
			}

		}
		if yyrt1330 {
			for ; yyj1330 < yyl1330; yyj1330++ {
				yyv1330 = append(yyv1330, ThirdPartyResourceData{})
				yyh1330.ElemContainerState(yyj1330)
				if r.TryDecodeAsNil() {
					yyv1330[yyj1330] = ThirdPartyResourceData{}
				} else {
					yyv1332 := &yyv1330[yyj1330]
					yyv1332.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1330 := 0
		for ; !r.CheckBreak(); yyj1330++ {

			if yyj1330 >= len(yyv1330) {
				yyv1330 = append(yyv1330, ThirdPartyResourceData{}) // var yyz1330 ThirdPartyResourceData
				yyc1330 = true
			}
			yyh1330.ElemContainerState(yyj1330)
			if yyj1330 < len(yyv1330) {
				if r.TryDecodeAsNil() {
					yyv1330[yyj1330] = ThirdPartyResourceData{}
				} else {
					yyv1333 := &yyv1330[yyj1330]
					yyv1333.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1330 < len(yyv1330) {
			yyv1330 = yyv1330[:yyj1330]
			yyc1330 = true
		} else if yyj1330 == 0 && yyv1330 == nil {
			yyv1330 = []ThirdPartyResourceData{}
			yyc1330 = true
		}
	}
	yyh1330.End()
	if yyc1330 {
		*v = yyv1330
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1334 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1335 := &yyv1334
		yy1335.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1336 := *v
	yyh1336, yyl1336 := z.DecSliceHelperStart()
	var yyc1336 bool
	if yyl1336 == 0 {
		if yyv1336 == nil {
			yyv1336 = []Ingress{}
			yyc1336 = true
		} else if len(yyv1336) != 0 {
			yyv1336 = yyv1336[:0]
			yyc1336 = true
		}
	} else if yyl1336 > 0 {
		var yyrr1336, yyrl1336 int
		var yyrt1336 bool
		if yyl1336 > cap(yyv1336) {

			yyrg1336 := len(yyv1336) > 0
			yyv21336 := yyv1336
			yyrl1336, yyrt1336 = z.DecInferLen(yyl1336, z.DecBasicHandle().MaxInitLen, 336)
			if yyrt1336 {
				if yyrl1336 <= cap(yyv1336) {
					yyv1336 = yyv1336[:yyrl1336]
				} else {
					yyv1336 = make([]Ingress, yyrl1336)
				}
			} else {
				yyv1336 = make([]Ingress, yyrl1336)
			}
			yyc1336 = true
			yyrr1336 = len(yyv1336)
			if yyrg1336 {
				copy(yyv1336, yyv21336)
			}
		} else if yyl1336 != len(yyv1336) {
			yyv1336 = yyv1336[:yyl1336]
			yyc1336 = true
		}
		yyj1336 := 0
		for ; yyj1336 < yyrr1336; yyj1336++ {
			yyh1336.ElemContainerState(yyj1336)
			if r.TryDecodeAsNil() {
				yyv1336[yyj1336] = Ingress{}
			} else {
				yyv1337 := &yyv1336[yyj1336]
				yyv1337.CodecDecodeSelf(d)
			}

		}
		if yyrt1336 {
			for ; yyj1336 < yyl1336; yyj1336++ {
				yyv1336 = append(yyv1336, Ingress{})
				yyh1336.ElemContainerState(yyj1336)
				if r.TryDecodeAsNil() {
					yyv1336[yyj1336] = Ingress{}
				} else {
					yyv1338 := &yyv1336[yyj1336]
					yyv1338.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1336 := 0
		for ; !r.CheckBreak(); yyj1336++ {

			if yyj1336 >= len(yyv1336) {
				yyv1336 = append(yyv1336, Ingress{}) // var yyz1336 Ingress
				yyc1336 = true
			}
			yyh1336.ElemContainerState(yyj1336)
			if yyj1336 < len(yyv1336) {
				if r.TryDecodeAsNil() {
					yyv1336[yyj1336] = Ingress{}
				} else {
					yyv1339 := &yyv1336[yyj1336]
					yyv1339.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1336 < len(yyv1336) {
			yyv1336 = yyv1336[:yyj1336]
			yyc1336 = true
		} else if yyj1336 == 0 && yyv1336 == nil {
			yyv1336 = []Ingress{}
			yyc1336 = true
		}
	}
	yyh1336.End()
	if yyc1336 {
		*v = yyv1336
	}
}

func (x codecSelfer1234) encSliceIngressTLS(v []IngressTLS, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1340 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1341 := &yyv1340
		yy1341.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressTLS(v *[]IngressTLS, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1342 := *v
	yyh1342, yyl1342 := z.DecSliceHelperStart()
	var yyc1342 bool
	if yyl1342 == 0 {
		if yyv1342 == nil {
			yyv1342 = []IngressTLS{}
			yyc1342 = true
		} else if len(yyv1342) != 0 {
			yyv1342 = yyv1342[:0]
			yyc1342 = true
		}
	} else if yyl1342 > 0 {
		var yyrr1342, yyrl1342 int
		var yyrt1342 bool
		if yyl1342 > cap(yyv1342) {

			yyrg1342 := len(yyv1342) > 0
			yyv21342 := yyv1342
			yyrl1342, yyrt1342 = z.DecInferLen(yyl1342, z.DecBasicHandle().MaxInitLen, 40)
			if yyrt1342 {
				if yyrl1342 <= cap(yyv1342) {
					yyv1342 = yyv1342[:yyrl1342]
				} else {
					yyv1342 = make([]IngressTLS, yyrl1342)
				}
			} else {
				yyv1342 = make([]IngressTLS, yyrl1342)
			}
			yyc1342 = true
			yyrr1342 = len(yyv1342)
			if yyrg1342 {
				copy(yyv1342, yyv21342)
			}
		} else if yyl1342 != len(yyv1342) {
			yyv1342 = yyv1342[:yyl1342]
			yyc1342 = true
		}
		yyj1342 := 0
		for ; yyj1342 < yyrr1342; yyj1342++ {
			yyh1342.ElemContainerState(yyj1342)
			if r.TryDecodeAsNil() {
				yyv1342[yyj1342] = IngressTLS{}
			} else {
				yyv1343 := &yyv1342[yyj1342]
				yyv1343.CodecDecodeSelf(d)
			}

		}
		if yyrt1342 {
			for ; yyj1342 < yyl1342; yyj1342++ {
				yyv1342 = append(yyv1342, IngressTLS{})
				yyh1342.ElemContainerState(yyj1342)
				if r.TryDecodeAsNil() {
					yyv1342[yyj1342] = IngressTLS{}
				} else {
					yyv1344 := &yyv1342[yyj1342]
					yyv1344.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1342 := 0
		for ; !r.CheckBreak(); yyj1342++ {

			if yyj1342 >= len(yyv1342) {
				yyv1342 = append(yyv1342, IngressTLS{}) // var yyz1342 IngressTLS
				yyc1342 = true
			}
			yyh1342.ElemContainerState(yyj1342)
			if yyj1342 < len(yyv1342) {
				if r.TryDecodeAsNil() {
					yyv1342[yyj1342] = IngressTLS{}
				} else {
					yyv1345 := &yyv1342[yyj1342]
					yyv1345.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1342 < len(yyv1342) {
			yyv1342 = yyv1342[:yyj1342]
			yyc1342 = true
		} else if yyj1342 == 0 && yyv1342 == nil {
			yyv1342 = []IngressTLS{}
			yyc1342 = true
		}
	}
	yyh1342.End()
	if yyc1342 {
		*v = yyv1342
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1346 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1347 := &yyv1346
		yy1347.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1348 := *v
	yyh1348, yyl1348 := z.DecSliceHelperStart()
	var yyc1348 bool
	if yyl1348 == 0 {
		if yyv1348 == nil {
			yyv1348 = []IngressRule{}
			yyc1348 = true
		} else if len(yyv1348) != 0 {
			yyv1348 = yyv1348[:0]
			yyc1348 = true
		}
	} else if yyl1348 > 0 {
		var yyrr1348, yyrl1348 int
		var yyrt1348 bool
		if yyl1348 > cap(yyv1348) {

			yyrg1348 := len(yyv1348) > 0
			yyv21348 := yyv1348
			yyrl1348, yyrt1348 = z.DecInferLen(yyl1348, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1348 {
				if yyrl1348 <= cap(yyv1348) {
					yyv1348 = yyv1348[:yyrl1348]
				} else {
					yyv1348 = make([]IngressRule, yyrl1348)
				}
			} else {
				yyv1348 = make([]IngressRule, yyrl1348)
			}
			yyc1348 = true
			yyrr1348 = len(yyv1348)
			if yyrg1348 {
				copy(yyv1348, yyv21348)
			}
		} else if yyl1348 != len(yyv1348) {
			yyv1348 = yyv1348[:yyl1348]
			yyc1348 = true
		}
		yyj1348 := 0
		for ; yyj1348 < yyrr1348; yyj1348++ {
			yyh1348.ElemContainerState(yyj1348)
			if r.TryDecodeAsNil() {
				yyv1348[yyj1348] = IngressRule{}
			} else {
				yyv1349 := &yyv1348[yyj1348]
				yyv1349.CodecDecodeSelf(d)
			}

		}
		if yyrt1348 {
			for ; yyj1348 < yyl1348; yyj1348++ {
				yyv1348 = append(yyv1348, IngressRule{})
				yyh1348.ElemContainerState(yyj1348)
				if r.TryDecodeAsNil() {
					yyv1348[yyj1348] = IngressRule{}
				} else {
					yyv1350 := &yyv1348[yyj1348]
					yyv1350.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1348 := 0
		for ; !r.CheckBreak(); yyj1348++ {

			if yyj1348 >= len(yyv1348) {
				yyv1348 = append(yyv1348, IngressRule{}) // var yyz1348 IngressRule
				yyc1348 = true
			}
			yyh1348.ElemContainerState(yyj1348)
			if yyj1348 < len(yyv1348) {
				if r.TryDecodeAsNil() {
					yyv1348[yyj1348] = IngressRule{}
				} else {
					yyv1351 := &yyv1348[yyj1348]
					yyv1351.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1348 < len(yyv1348) {
			yyv1348 = yyv1348[:yyj1348]
			yyc1348 = true
		} else if yyj1348 == 0 && yyv1348 == nil {
			yyv1348 = []IngressRule{}
			yyc1348 = true
		}
	}
	yyh1348.End()
	if yyc1348 {
		*v = yyv1348
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1352 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1353 := &yyv1352
		yy1353.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1354 := *v
	yyh1354, yyl1354 := z.DecSliceHelperStart()
	var yyc1354 bool
	if yyl1354 == 0 {
		if yyv1354 == nil {
			yyv1354 = []HTTPIngressPath{}
			yyc1354 = true
		} else if len(yyv1354) != 0 {
			yyv1354 = yyv1354[:0]
			yyc1354 = true
		}
	} else if yyl1354 > 0 {
		var yyrr1354, yyrl1354 int
		var yyrt1354 bool
		if yyl1354 > cap(yyv1354) {

			yyrg1354 := len(yyv1354) > 0
			yyv21354 := yyv1354
			yyrl1354, yyrt1354 = z.DecInferLen(yyl1354, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1354 {
				if yyrl1354 <= cap(yyv1354) {
					yyv1354 = yyv1354[:yyrl1354]
				} else {
					yyv1354 = make([]HTTPIngressPath, yyrl1354)
				}
			} else {
				yyv1354 = make([]HTTPIngressPath, yyrl1354)
			}
			yyc1354 = true
			yyrr1354 = len(yyv1354)
			if yyrg1354 {
				copy(yyv1354, yyv21354)
			}
		} else if yyl1354 != len(yyv1354) {
			yyv1354 = yyv1354[:yyl1354]
			yyc1354 = true
		}
		yyj1354 := 0
		for ; yyj1354 < yyrr1354; yyj1354++ {
			yyh1354.ElemContainerState(yyj1354)
			if r.TryDecodeAsNil() {
				yyv1354[yyj1354] = HTTPIngressPath{}
			} else {
				yyv1355 := &yyv1354[yyj1354]
				yyv1355.CodecDecodeSelf(d)
			}

		}
		if yyrt1354 {
			for ; yyj1354 < yyl1354; yyj1354++ {
				yyv1354 = append(yyv1354, HTTPIngressPath{})
				yyh1354.ElemContainerState(yyj1354)
				if r.TryDecodeAsNil() {
					yyv1354[yyj1354] = HTTPIngressPath{}
				} else {
					yyv1356 := &yyv1354[yyj1354]
					yyv1356.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1354 := 0
		for ; !r.CheckBreak(); yyj1354++ {

			if yyj1354 >= len(yyv1354) {
				yyv1354 = append(yyv1354, HTTPIngressPath{}) // var yyz1354 HTTPIngressPath
				yyc1354 = true
			}
			yyh1354.ElemContainerState(yyj1354)
			if yyj1354 < len(yyv1354) {
				if r.TryDecodeAsNil() {
					yyv1354[yyj1354] = HTTPIngressPath{}
				} else {
					yyv1357 := &yyv1354[yyj1354]
					yyv1357.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1354 < len(yyv1354) {
			yyv1354 = yyv1354[:yyj1354]
			yyc1354 = true
		} else if yyj1354 == 0 && yyv1354 == nil {
			yyv1354 = []HTTPIngressPath{}
			yyc1354 = true
		}
	}
	yyh1354.End()
	if yyc1354 {
		*v = yyv1354
	}
}

func (x codecSelfer1234) encSliceReplicaSet(v []ReplicaSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1358 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1359 := &yyv1358
		yy1359.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSet(v *[]ReplicaSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1360 := *v
	yyh1360, yyl1360 := z.DecSliceHelperStart()
	var yyc1360 bool
	if yyl1360 == 0 {
		if yyv1360 == nil {
			yyv1360 = []ReplicaSet{}
			yyc1360 = true
		} else if len(yyv1360) != 0 {
			yyv1360 = yyv1360[:0]
			yyc1360 = true
		}
	} else if yyl1360 > 0 {
		var yyrr1360, yyrl1360 int
		var yyrt1360 bool
		if yyl1360 > cap(yyv1360) {

			yyrg1360 := len(yyv1360) > 0
			yyv21360 := yyv1360
			yyrl1360, yyrt1360 = z.DecInferLen(yyl1360, z.DecBasicHandle().MaxInitLen, 744)
			if yyrt1360 {
				if yyrl1360 <= cap(yyv1360) {
					yyv1360 = yyv1360[:yyrl1360]
				} else {
					yyv1360 = make([]ReplicaSet, yyrl1360)
				}
			} else {
				yyv1360 = make([]ReplicaSet, yyrl1360)
			}
			yyc1360 = true
			yyrr1360 = len(yyv1360)
			if yyrg1360 {
				copy(yyv1360, yyv21360)
			}
		} else if yyl1360 != len(yyv1360) {
			yyv1360 = yyv1360[:yyl1360]
			yyc1360 = true
		}
		yyj1360 := 0
		for ; yyj1360 < yyrr1360; yyj1360++ {
			yyh1360.ElemContainerState(yyj1360)
			if r.TryDecodeAsNil() {
				yyv1360[yyj1360] = ReplicaSet{}
			} else {
				yyv1361 := &yyv1360[yyj1360]
				yyv1361.CodecDecodeSelf(d)
			}

		}
		if yyrt1360 {
			for ; yyj1360 < yyl1360; yyj1360++ {
				yyv1360 = append(yyv1360, ReplicaSet{})
				yyh1360.ElemContainerState(yyj1360)
				if r.TryDecodeAsNil() {
					yyv1360[yyj1360] = ReplicaSet{}
				} else {
					yyv1362 := &yyv1360[yyj1360]
					yyv1362.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1360 := 0
		for ; !r.CheckBreak(); yyj1360++ {

			if yyj1360 >= len(yyv1360) {
				yyv1360 = append(yyv1360, ReplicaSet{}) // var yyz1360 ReplicaSet
				yyc1360 = true
			}
			yyh1360.ElemContainerState(yyj1360)
			if yyj1360 < len(yyv1360) {
				if r.TryDecodeAsNil() {
					yyv1360[yyj1360] = ReplicaSet{}
				} else {
					yyv1363 := &yyv1360[yyj1360]
					yyv1363.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1360 < len(yyv1360) {
			yyv1360 = yyv1360[:yyj1360]
			yyc1360 = true
		} else if yyj1360 == 0 && yyv1360 == nil {
			yyv1360 = []ReplicaSet{}
			yyc1360 = true
		}
	}
	yyh1360.End()
	if yyc1360 {
		*v = yyv1360
	}
}

func (x codecSelfer1234) encSliceapi_Capability(v []pkg2_api.Capability, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1364 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym1365 := z.EncBinary()
		_ = yym1365
		if false {
		} else if z.HasExtensions() && z.EncExt(yyv1364) {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1364))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceapi_Capability(v *[]pkg2_api.Capability, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1366 := *v
	yyh1366, yyl1366 := z.DecSliceHelperStart()
	var yyc1366 bool
	if yyl1366 == 0 {
		if yyv1366 == nil {
			yyv1366 = []pkg2_api.Capability{}
			yyc1366 = true
		} else if len(yyv1366) != 0 {
			yyv1366 = yyv1366[:0]
			yyc1366 = true
		}
	} else if yyl1366 > 0 {
		var yyrr1366, yyrl1366 int
		var yyrt1366 bool
		if yyl1366 > cap(yyv1366) {

			yyrl1366, yyrt1366 = z.DecInferLen(yyl1366, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1366 {
				if yyrl1366 <= cap(yyv1366) {
					yyv1366 = yyv1366[:yyrl1366]
				} else {
					yyv1366 = make([]pkg2_api.Capability, yyrl1366)
				}
			} else {
				yyv1366 = make([]pkg2_api.Capability, yyrl1366)
			}
			yyc1366 = true
			yyrr1366 = len(yyv1366)
		} else if yyl1366 != len(yyv1366) {
			yyv1366 = yyv1366[:yyl1366]
			yyc1366 = true
		}
		yyj1366 := 0
		for ; yyj1366 < yyrr1366; yyj1366++ {
			yyh1366.ElemContainerState(yyj1366)
			if r.TryDecodeAsNil() {
				yyv1366[yyj1366] = ""
			} else {
				yyv1366[yyj1366] = pkg2_api.Capability(r.DecodeString())
			}

		}
		if yyrt1366 {
			for ; yyj1366 < yyl1366; yyj1366++ {
				yyv1366 = append(yyv1366, "")
				yyh1366.ElemContainerState(yyj1366)
				if r.TryDecodeAsNil() {
					yyv1366[yyj1366] = ""
				} else {
					yyv1366[yyj1366] = pkg2_api.Capability(r.DecodeString())
				}

			}
		}

	} else {
		yyj1366 := 0
		for ; !r.CheckBreak(); yyj1366++ {

			if yyj1366 >= len(yyv1366) {
				yyv1366 = append(yyv1366, "") // var yyz1366 pkg2_api.Capability
				yyc1366 = true
			}
			yyh1366.ElemContainerState(yyj1366)
			if yyj1366 < len(yyv1366) {
				if r.TryDecodeAsNil() {
					yyv1366[yyj1366] = ""
				} else {
					yyv1366[yyj1366] = pkg2_api.Capability(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1366 < len(yyv1366) {
			yyv1366 = yyv1366[:yyj1366]
			yyc1366 = true
		} else if yyj1366 == 0 && yyv1366 == nil {
			yyv1366 = []pkg2_api.Capability{}
			yyc1366 = true
		}
	}
	yyh1366.End()
	if yyc1366 {
		*v = yyv1366
	}
}

func (x codecSelfer1234) encSliceFSType(v []FSType, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1370 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yyv1370.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceFSType(v *[]FSType, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1371 := *v
	yyh1371, yyl1371 := z.DecSliceHelperStart()
	var yyc1371 bool
	if yyl1371 == 0 {
		if yyv1371 == nil {
			yyv1371 = []FSType{}
			yyc1371 = true
		} else if len(yyv1371) != 0 {
			yyv1371 = yyv1371[:0]
			yyc1371 = true
		}
	} else if yyl1371 > 0 {
		var yyrr1371, yyrl1371 int
		var yyrt1371 bool
		if yyl1371 > cap(yyv1371) {

			yyrl1371, yyrt1371 = z.DecInferLen(yyl1371, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1371 {
				if yyrl1371 <= cap(yyv1371) {
					yyv1371 = yyv1371[:yyrl1371]
				} else {
					yyv1371 = make([]FSType, yyrl1371)
				}
			} else {
				yyv1371 = make([]FSType, yyrl1371)
			}
			yyc1371 = true
			yyrr1371 = len(yyv1371)
		} else if yyl1371 != len(yyv1371) {
			yyv1371 = yyv1371[:yyl1371]
			yyc1371 = true
		}
		yyj1371 := 0
		for ; yyj1371 < yyrr1371; yyj1371++ {
			yyh1371.ElemContainerState(yyj1371)
			if r.TryDecodeAsNil() {
				yyv1371[yyj1371] = ""
			} else {
				yyv1371[yyj1371] = FSType(r.DecodeString())
			}

		}
		if yyrt1371 {
			for ; yyj1371 < yyl1371; yyj1371++ {
				yyv1371 = append(yyv1371, "")
				yyh1371.ElemContainerState(yyj1371)
				if r.TryDecodeAsNil() {
					yyv1371[yyj1371] = ""
				} else {
					yyv1371[yyj1371] = FSType(r.DecodeString())
				}

			}
		}

	} else {
		yyj1371 := 0
		for ; !r.CheckBreak(); yyj1371++ {

			if yyj1371 >= len(yyv1371) {
				yyv1371 = append(yyv1371, "") // var yyz1371 FSType
				yyc1371 = true
			}
			yyh1371.ElemContainerState(yyj1371)
			if yyj1371 < len(yyv1371) {
				if r.TryDecodeAsNil() {
					yyv1371[yyj1371] = ""
				} else {
					yyv1371[yyj1371] = FSType(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1371 < len(yyv1371) {
			yyv1371 = yyv1371[:yyj1371]
			yyc1371 = true
		} else if yyj1371 == 0 && yyv1371 == nil {
			yyv1371 = []FSType{}
			yyc1371 = true
		}
	}
	yyh1371.End()
	if yyc1371 {
		*v = yyv1371
	}
}

func (x codecSelfer1234) encSliceHostPortRange(v []HostPortRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1375 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1376 := &yyv1375
		yy1376.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHostPortRange(v *[]HostPortRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1377 := *v
	yyh1377, yyl1377 := z.DecSliceHelperStart()
	var yyc1377 bool
	if yyl1377 == 0 {
		if yyv1377 == nil {
			yyv1377 = []HostPortRange{}
			yyc1377 = true
		} else if len(yyv1377) != 0 {
			yyv1377 = yyv1377[:0]
			yyc1377 = true
		}
	} else if yyl1377 > 0 {
		var yyrr1377, yyrl1377 int
		var yyrt1377 bool
		if yyl1377 > cap(yyv1377) {

			yyrg1377 := len(yyv1377) > 0
			yyv21377 := yyv1377
			yyrl1377, yyrt1377 = z.DecInferLen(yyl1377, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1377 {
				if yyrl1377 <= cap(yyv1377) {
					yyv1377 = yyv1377[:yyrl1377]
				} else {
					yyv1377 = make([]HostPortRange, yyrl1377)
				}
			} else {
				yyv1377 = make([]HostPortRange, yyrl1377)
			}
			yyc1377 = true
			yyrr1377 = len(yyv1377)
			if yyrg1377 {
				copy(yyv1377, yyv21377)
			}
		} else if yyl1377 != len(yyv1377) {
			yyv1377 = yyv1377[:yyl1377]
			yyc1377 = true
		}
		yyj1377 := 0
		for ; yyj1377 < yyrr1377; yyj1377++ {
			yyh1377.ElemContainerState(yyj1377)
			if r.TryDecodeAsNil() {
				yyv1377[yyj1377] = HostPortRange{}
			} else {
				yyv1378 := &yyv1377[yyj1377]
				yyv1378.CodecDecodeSelf(d)
			}

		}
		if yyrt1377 {
			for ; yyj1377 < yyl1377; yyj1377++ {
				yyv1377 = append(yyv1377, HostPortRange{})
				yyh1377.ElemContainerState(yyj1377)
				if r.TryDecodeAsNil() {
					yyv1377[yyj1377] = HostPortRange{}
				} else {
					yyv1379 := &yyv1377[yyj1377]
					yyv1379.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1377 := 0
		for ; !r.CheckBreak(); yyj1377++ {

			if yyj1377 >= len(yyv1377) {
				yyv1377 = append(yyv1377, HostPortRange{}) // var yyz1377 HostPortRange
				yyc1377 = true
			}
			yyh1377.ElemContainerState(yyj1377)
			if yyj1377 < len(yyv1377) {
				if r.TryDecodeAsNil() {
					yyv1377[yyj1377] = HostPortRange{}
				} else {
					yyv1380 := &yyv1377[yyj1377]
					yyv1380.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1377 < len(yyv1377) {
			yyv1377 = yyv1377[:yyj1377]
			yyc1377 = true
		} else if yyj1377 == 0 && yyv1377 == nil {
			yyv1377 = []HostPortRange{}
			yyc1377 = true
		}
	}
	yyh1377.End()
	if yyc1377 {
		*v = yyv1377
	}
}

func (x codecSelfer1234) encSliceIDRange(v []IDRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1381 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1382 := &yyv1381
		yy1382.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIDRange(v *[]IDRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1383 := *v
	yyh1383, yyl1383 := z.DecSliceHelperStart()
	var yyc1383 bool
	if yyl1383 == 0 {
		if yyv1383 == nil {
			yyv1383 = []IDRange{}
			yyc1383 = true
		} else if len(yyv1383) != 0 {
			yyv1383 = yyv1383[:0]
			yyc1383 = true
		}
	} else if yyl1383 > 0 {
		var yyrr1383, yyrl1383 int
		var yyrt1383 bool
		if yyl1383 > cap(yyv1383) {

			yyrg1383 := len(yyv1383) > 0
			yyv21383 := yyv1383
			yyrl1383, yyrt1383 = z.DecInferLen(yyl1383, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1383 {
				if yyrl1383 <= cap(yyv1383) {
					yyv1383 = yyv1383[:yyrl1383]
				} else {
					yyv1383 = make([]IDRange, yyrl1383)
				}
			} else {
				yyv1383 = make([]IDRange, yyrl1383)
			}
			yyc1383 = true
			yyrr1383 = len(yyv1383)
			if yyrg1383 {
				copy(yyv1383, yyv21383)
			}
		} else if yyl1383 != len(yyv1383) {
			yyv1383 = yyv1383[:yyl1383]
			yyc1383 = true
		}
		yyj1383 := 0
		for ; yyj1383 < yyrr1383; yyj1383++ {
			yyh1383.ElemContainerState(yyj1383)
			if r.TryDecodeAsNil() {
				yyv1383[yyj1383] = IDRange{}
			} else {
				yyv1384 := &yyv1383[yyj1383]
				yyv1384.CodecDecodeSelf(d)
			}

		}
		if yyrt1383 {
			for ; yyj1383 < yyl1383; yyj1383++ {
				yyv1383 = append(yyv1383, IDRange{})
				yyh1383.ElemContainerState(yyj1383)
				if r.TryDecodeAsNil() {
					yyv1383[yyj1383] = IDRange{}
				} else {
					yyv1385 := &yyv1383[yyj1383]
					yyv1385.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1383 := 0
		for ; !r.CheckBreak(); yyj1383++ {

			if yyj1383 >= len(yyv1383) {
				yyv1383 = append(yyv1383, IDRange{}) // var yyz1383 IDRange
				yyc1383 = true
			}
			yyh1383.ElemContainerState(yyj1383)
			if yyj1383 < len(yyv1383) {
				if r.TryDecodeAsNil() {
					yyv1383[yyj1383] = IDRange{}
				} else {
					yyv1386 := &yyv1383[yyj1383]
					yyv1386.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1383 < len(yyv1383) {
			yyv1383 = yyv1383[:yyj1383]
			yyc1383 = true
		} else if yyj1383 == 0 && yyv1383 == nil {
			yyv1383 = []IDRange{}
			yyc1383 = true
		}
	}
	yyh1383.End()
	if yyc1383 {
		*v = yyv1383
	}
}

func (x codecSelfer1234) encSlicePodSecurityPolicy(v []PodSecurityPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1387 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1388 := &yyv1387
		yy1388.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodSecurityPolicy(v *[]PodSecurityPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1389 := *v
	yyh1389, yyl1389 := z.DecSliceHelperStart()
	var yyc1389 bool
	if yyl1389 == 0 {
		if yyv1389 == nil {
			yyv1389 = []PodSecurityPolicy{}
			yyc1389 = true
		} else if len(yyv1389) != 0 {
			yyv1389 = yyv1389[:0]
			yyc1389 = true
		}
	} else if yyl1389 > 0 {
		var yyrr1389, yyrl1389 int
		var yyrt1389 bool
		if yyl1389 > cap(yyv1389) {

			yyrg1389 := len(yyv1389) > 0
			yyv21389 := yyv1389
			yyrl1389, yyrt1389 = z.DecInferLen(yyl1389, z.DecBasicHandle().MaxInitLen, 552)
			if yyrt1389 {
				if yyrl1389 <= cap(yyv1389) {
					yyv1389 = yyv1389[:yyrl1389]
				} else {
					yyv1389 = make([]PodSecurityPolicy, yyrl1389)
				}
			} else {
				yyv1389 = make([]PodSecurityPolicy, yyrl1389)
			}
			yyc1389 = true
			yyrr1389 = len(yyv1389)
			if yyrg1389 {
				copy(yyv1389, yyv21389)
			}
		} else if yyl1389 != len(yyv1389) {
			yyv1389 = yyv1389[:yyl1389]
			yyc1389 = true
		}
		yyj1389 := 0
		for ; yyj1389 < yyrr1389; yyj1389++ {
			yyh1389.ElemContainerState(yyj1389)
			if r.TryDecodeAsNil() {
				yyv1389[yyj1389] = PodSecurityPolicy{}
			} else {
				yyv1390 := &yyv1389[yyj1389]
				yyv1390.CodecDecodeSelf(d)
			}

		}
		if yyrt1389 {
			for ; yyj1389 < yyl1389; yyj1389++ {
				yyv1389 = append(yyv1389, PodSecurityPolicy{})
				yyh1389.ElemContainerState(yyj1389)
				if r.TryDecodeAsNil() {
					yyv1389[yyj1389] = PodSecurityPolicy{}
				} else {
					yyv1391 := &yyv1389[yyj1389]
					yyv1391.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1389 := 0
		for ; !r.CheckBreak(); yyj1389++ {

			if yyj1389 >= len(yyv1389) {
				yyv1389 = append(yyv1389, PodSecurityPolicy{}) // var yyz1389 PodSecurityPolicy
				yyc1389 = true
			}
			yyh1389.ElemContainerState(yyj1389)
			if yyj1389 < len(yyv1389) {
				if r.TryDecodeAsNil() {
					yyv1389[yyj1389] = PodSecurityPolicy{}
				} else {
					yyv1392 := &yyv1389[yyj1389]
					yyv1392.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1389 < len(yyv1389) {
			yyv1389 = yyv1389[:yyj1389]
			yyc1389 = true
		} else if yyj1389 == 0 && yyv1389 == nil {
			yyv1389 = []PodSecurityPolicy{}
			yyc1389 = true
		}
	}
	yyh1389.End()
	if yyc1389 {
		*v = yyv1389
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyIngressRule(v []NetworkPolicyIngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1393 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1394 := &yyv1393
		yy1394.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyIngressRule(v *[]NetworkPolicyIngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1395 := *v
	yyh1395, yyl1395 := z.DecSliceHelperStart()
	var yyc1395 bool
	if yyl1395 == 0 {
		if yyv1395 == nil {
			yyv1395 = []NetworkPolicyIngressRule{}
			yyc1395 = true
		} else if len(yyv1395) != 0 {
			yyv1395 = yyv1395[:0]
			yyc1395 = true
		}
	} else if yyl1395 > 0 {
		var yyrr1395, yyrl1395 int
		var yyrt1395 bool
		if yyl1395 > cap(yyv1395) {

			yyrg1395 := len(yyv1395) > 0
			yyv21395 := yyv1395
			yyrl1395, yyrt1395 = z.DecInferLen(yyl1395, z.DecBasicHandle().MaxInitLen, 48)
			if yyrt1395 {
				if yyrl1395 <= cap(yyv1395) {
					yyv1395 = yyv1395[:yyrl1395]
				} else {
					yyv1395 = make([]NetworkPolicyIngressRule, yyrl1395)
				}
			} else {
				yyv1395 = make([]NetworkPolicyIngressRule, yyrl1395)
			}
			yyc1395 = true
			yyrr1395 = len(yyv1395)
			if yyrg1395 {
				copy(yyv1395, yyv21395)
			}
		} else if yyl1395 != len(yyv1395) {
			yyv1395 = yyv1395[:yyl1395]
			yyc1395 = true
		}
		yyj1395 := 0
		for ; yyj1395 < yyrr1395; yyj1395++ {
			yyh1395.ElemContainerState(yyj1395)
			if r.TryDecodeAsNil() {
				yyv1395[yyj1395] = NetworkPolicyIngressRule{}
			} else {
				yyv1396 := &yyv1395[yyj1395]
				yyv1396.CodecDecodeSelf(d)
			}

		}
		if yyrt1395 {
			for ; yyj1395 < yyl1395; yyj1395++ {
				yyv1395 = append(yyv1395, NetworkPolicyIngressRule{})
				yyh1395.ElemContainerState(yyj1395)
				if r.TryDecodeAsNil() {
					yyv1395[yyj1395] = NetworkPolicyIngressRule{}
				} else {
					yyv1397 := &yyv1395[yyj1395]
					yyv1397.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1395 := 0
		for ; !r.CheckBreak(); yyj1395++ {

			if yyj1395 >= len(yyv1395) {
				yyv1395 = append(yyv1395, NetworkPolicyIngressRule{}) // var yyz1395 NetworkPolicyIngressRule
				yyc1395 = true
			}
			yyh1395.ElemContainerState(yyj1395)
			if yyj1395 < len(yyv1395) {
				if r.TryDecodeAsNil() {
					yyv1395[yyj1395] = NetworkPolicyIngressRule{}
				} else {
					yyv1398 := &yyv1395[yyj1395]
					yyv1398.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1395 < len(yyv1395) {
			yyv1395 = yyv1395[:yyj1395]
			yyc1395 = true
		} else if yyj1395 == 0 && yyv1395 == nil {
			yyv1395 = []NetworkPolicyIngressRule{}
			yyc1395 = true
		}
	}
	yyh1395.End()
	if yyc1395 {
		*v = yyv1395
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPort(v []NetworkPolicyPort, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1399 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1400 := &yyv1399
		yy1400.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPort(v *[]NetworkPolicyPort, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1401 := *v
	yyh1401, yyl1401 := z.DecSliceHelperStart()
	var yyc1401 bool
	if yyl1401 == 0 {
		if yyv1401 == nil {
			yyv1401 = []NetworkPolicyPort{}
			yyc1401 = true
		} else if len(yyv1401) != 0 {
			yyv1401 = yyv1401[:0]
			yyc1401 = true
		}
	} else if yyl1401 > 0 {
		var yyrr1401, yyrl1401 int
		var yyrt1401 bool
		if yyl1401 > cap(yyv1401) {

			yyrg1401 := len(yyv1401) > 0
			yyv21401 := yyv1401
			yyrl1401, yyrt1401 = z.DecInferLen(yyl1401, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1401 {
				if yyrl1401 <= cap(yyv1401) {
					yyv1401 = yyv1401[:yyrl1401]
				} else {
					yyv1401 = make([]NetworkPolicyPort, yyrl1401)
				}
			} else {
				yyv1401 = make([]NetworkPolicyPort, yyrl1401)
			}
			yyc1401 = true
			yyrr1401 = len(yyv1401)
			if yyrg1401 {
				copy(yyv1401, yyv21401)
			}
		} else if yyl1401 != len(yyv1401) {
			yyv1401 = yyv1401[:yyl1401]
			yyc1401 = true
		}
		yyj1401 := 0
		for ; yyj1401 < yyrr1401; yyj1401++ {
			yyh1401.ElemContainerState(yyj1401)
			if r.TryDecodeAsNil() {
				yyv1401[yyj1401] = NetworkPolicyPort{}
			} else {
				yyv1402 := &yyv1401[yyj1401]
				yyv1402.CodecDecodeSelf(d)
			}

		}
		if yyrt1401 {
			for ; yyj1401 < yyl1401; yyj1401++ {
				yyv1401 = append(yyv1401, NetworkPolicyPort{})
				yyh1401.ElemContainerState(yyj1401)
				if r.TryDecodeAsNil() {
					yyv1401[yyj1401] = NetworkPolicyPort{}
				} else {
					yyv1403 := &yyv1401[yyj1401]
					yyv1403.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1401 := 0
		for ; !r.CheckBreak(); yyj1401++ {

			if yyj1401 >= len(yyv1401) {
				yyv1401 = append(yyv1401, NetworkPolicyPort{}) // var yyz1401 NetworkPolicyPort
				yyc1401 = true
			}
			yyh1401.ElemContainerState(yyj1401)
			if yyj1401 < len(yyv1401) {
				if r.TryDecodeAsNil() {
					yyv1401[yyj1401] = NetworkPolicyPort{}
				} else {
					yyv1404 := &yyv1401[yyj1401]
					yyv1404.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1401 < len(yyv1401) {
			yyv1401 = yyv1401[:yyj1401]
			yyc1401 = true
		} else if yyj1401 == 0 && yyv1401 == nil {
			yyv1401 = []NetworkPolicyPort{}
			yyc1401 = true
		}
	}
	yyh1401.End()
	if yyc1401 {
		*v = yyv1401
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPeer(v []NetworkPolicyPeer, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1405 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1406 := &yyv1405
		yy1406.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPeer(v *[]NetworkPolicyPeer, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1407 := *v
	yyh1407, yyl1407 := z.DecSliceHelperStart()
	var yyc1407 bool
	if yyl1407 == 0 {
		if yyv1407 == nil {
			yyv1407 = []NetworkPolicyPeer{}
			yyc1407 = true
		} else if len(yyv1407) != 0 {
			yyv1407 = yyv1407[:0]
			yyc1407 = true
		}
	} else if yyl1407 > 0 {
		var yyrr1407, yyrl1407 int
		var yyrt1407 bool
		if yyl1407 > cap(yyv1407) {

			yyrg1407 := len(yyv1407) > 0
			yyv21407 := yyv1407
			yyrl1407, yyrt1407 = z.DecInferLen(yyl1407, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1407 {
				if yyrl1407 <= cap(yyv1407) {
					yyv1407 = yyv1407[:yyrl1407]
				} else {
					yyv1407 = make([]NetworkPolicyPeer, yyrl1407)
				}
			} else {
				yyv1407 = make([]NetworkPolicyPeer, yyrl1407)
			}
			yyc1407 = true
			yyrr1407 = len(yyv1407)
			if yyrg1407 {
				copy(yyv1407, yyv21407)
			}
		} else if yyl1407 != len(yyv1407) {
			yyv1407 = yyv1407[:yyl1407]
			yyc1407 = true
		}
		yyj1407 := 0
		for ; yyj1407 < yyrr1407; yyj1407++ {
			yyh1407.ElemContainerState(yyj1407)
			if r.TryDecodeAsNil() {
				yyv1407[yyj1407] = NetworkPolicyPeer{}
			} else {
				yyv1408 := &yyv1407[yyj1407]
				yyv1408.CodecDecodeSelf(d)
			}

		}
		if yyrt1407 {
			for ; yyj1407 < yyl1407; yyj1407++ {
				yyv1407 = append(yyv1407, NetworkPolicyPeer{})
				yyh1407.ElemContainerState(yyj1407)
				if r.TryDecodeAsNil() {
					yyv1407[yyj1407] = NetworkPolicyPeer{}
				} else {
					yyv1409 := &yyv1407[yyj1407]
					yyv1409.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1407 := 0
		for ; !r.CheckBreak(); yyj1407++ {

			if yyj1407 >= len(yyv1407) {
				yyv1407 = append(yyv1407, NetworkPolicyPeer{}) // var yyz1407 NetworkPolicyPeer
				yyc1407 = true
			}
			yyh1407.ElemContainerState(yyj1407)
			if yyj1407 < len(yyv1407) {
				if r.TryDecodeAsNil() {
					yyv1407[yyj1407] = NetworkPolicyPeer{}
				} else {
					yyv1410 := &yyv1407[yyj1407]
					yyv1410.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1407 < len(yyv1407) {
			yyv1407 = yyv1407[:yyj1407]
			yyc1407 = true
		} else if yyj1407 == 0 && yyv1407 == nil {
			yyv1407 = []NetworkPolicyPeer{}
			yyc1407 = true
		}
	}
	yyh1407.End()
	if yyc1407 {
		*v = yyv1407
	}
}

func (x codecSelfer1234) encSliceNetworkPolicy(v []NetworkPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1411 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1412 := &yyv1411
		yy1412.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicy(v *[]NetworkPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1413 := *v
	yyh1413, yyl1413 := z.DecSliceHelperStart()
	var yyc1413 bool
	if yyl1413 == 0 {
		if yyv1413 == nil {
			yyv1413 = []NetworkPolicy{}
			yyc1413 = true
		} else if len(yyv1413) != 0 {
			yyv1413 = yyv1413[:0]
			yyc1413 = true
		}
	} else if yyl1413 > 0 {
		var yyrr1413, yyrl1413 int
		var yyrt1413 bool
		if yyl1413 > cap(yyv1413) {

			yyrg1413 := len(yyv1413) > 0
			yyv21413 := yyv1413
			yyrl1413, yyrt1413 = z.DecInferLen(yyl1413, z.DecBasicHandle().MaxInitLen, 312)
			if yyrt1413 {
				if yyrl1413 <= cap(yyv1413) {
					yyv1413 = yyv1413[:yyrl1413]
				} else {
					yyv1413 = make([]NetworkPolicy, yyrl1413)
				}
			} else {
				yyv1413 = make([]NetworkPolicy, yyrl1413)
			}
			yyc1413 = true
			yyrr1413 = len(yyv1413)
			if yyrg1413 {
				copy(yyv1413, yyv21413)
			}
		} else if yyl1413 != len(yyv1413) {
			yyv1413 = yyv1413[:yyl1413]
			yyc1413 = true
		}
		yyj1413 := 0
		for ; yyj1413 < yyrr1413; yyj1413++ {
			yyh1413.ElemContainerState(yyj1413)
			if r.TryDecodeAsNil() {
				yyv1413[yyj1413] = NetworkPolicy{}
			} else {
				yyv1414 := &yyv1413[yyj1413]
				yyv1414.CodecDecodeSelf(d)
			}

		}
		if yyrt1413 {
			for ; yyj1413 < yyl1413; yyj1413++ {
				yyv1413 = append(yyv1413, NetworkPolicy{})
				yyh1413.ElemContainerState(yyj1413)
				if r.TryDecodeAsNil() {
					yyv1413[yyj1413] = NetworkPolicy{}
				} else {
					yyv1415 := &yyv1413[yyj1413]
					yyv1415.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1413 := 0
		for ; !r.CheckBreak(); yyj1413++ {

			if yyj1413 >= len(yyv1413) {
				yyv1413 = append(yyv1413, NetworkPolicy{}) // var yyz1413 NetworkPolicy
				yyc1413 = true
			}
			yyh1413.ElemContainerState(yyj1413)
			if yyj1413 < len(yyv1413) {
				if r.TryDecodeAsNil() {
					yyv1413[yyj1413] = NetworkPolicy{}
				} else {
					yyv1416 := &yyv1413[yyj1413]
					yyv1416.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1413 < len(yyv1413) {
			yyv1413 = yyv1413[:yyj1413]
			yyc1413 = true
		} else if yyj1413 == 0 && yyv1413 == nil {
			yyv1413 = []NetworkPolicy{}
			yyc1413 = true
		}
	}
	yyh1413.End()
	if yyc1413 {
		*v = yyv1413
	}
}
