/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1alpha1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg3_v1 "k8s.io/kubernetes/pkg/api/v1"
	pkg1_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg4_types "k8s.io/kubernetes/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_unversioned.TypeMeta
		var v1 pkg3_v1.ObjectMeta
		var v2 pkg1_runtime.RawExtension
		var v3 pkg4_types.UID
		var v4 time.Time
		_, _, _, _, _ = v0, v1, v2, v3, v4
	}
}

func (x *PolicyRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = true
			yyq2[2] = len(x.APIGroups) != 0
			yyq2[3] = len(x.Resources) != 0
			yyq2[4] = len(x.ResourceNames) != 0
			yyq2[5] = len(x.NonResourceURLs) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Verbs == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						z.F.EncSliceStringV(x.Verbs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("verbs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Verbs == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						z.F.EncSliceStringV(x.Verbs, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yy7 := &x.AttributeRestrictions
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else if z.HasExtensions() && z.EncExt(yy7) {
					} else if !yym8 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy7)
					} else {
						z.EncFallback(yy7)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("attributeRestrictions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy9 := &x.AttributeRestrictions
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else if z.HasExtensions() && z.EncExt(yy9) {
					} else if !yym10 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy9)
					} else {
						z.EncFallback(yy9)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.APIGroups == nil {
						r.EncodeNil()
					} else {
						yym12 := z.EncBinary()
						_ = yym12
						if false {
						} else {
							z.F.EncSliceStringV(x.APIGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.APIGroups == nil {
						r.EncodeNil()
					} else {
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							z.F.EncSliceStringV(x.APIGroups, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Resources == nil {
						r.EncodeNil()
					} else {
						yym15 := z.EncBinary()
						_ = yym15
						if false {
						} else {
							z.F.EncSliceStringV(x.Resources, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Resources == nil {
						r.EncodeNil()
					} else {
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							z.F.EncSliceStringV(x.Resources, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.ResourceNames == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncSliceStringV(x.ResourceNames, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceNames"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceNames == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncSliceStringV(x.ResourceNames, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.NonResourceURLs == nil {
						r.EncodeNil()
					} else {
						yym21 := z.EncBinary()
						_ = yym21
						if false {
						} else {
							z.F.EncSliceStringV(x.NonResourceURLs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nonResourceURLs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NonResourceURLs == nil {
						r.EncodeNil()
					} else {
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else {
							z.F.EncSliceStringV(x.NonResourceURLs, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PolicyRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym23 := z.DecBinary()
	_ = yym23
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct24 := r.ContainerType()
		if yyct24 == codecSelferValueTypeMap1234 {
			yyl24 := r.ReadMapStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl24, d)
			}
		} else if yyct24 == codecSelferValueTypeArray1234 {
			yyl24 := r.ReadArrayStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl24, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PolicyRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys25Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys25Slc
	var yyhl25 bool = l >= 0
	for yyj25 := 0; ; yyj25++ {
		if yyhl25 {
			if yyj25 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys25Slc = r.DecodeBytes(yys25Slc, true, true)
		yys25 := string(yys25Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys25 {
		case "verbs":
			if r.TryDecodeAsNil() {
				x.Verbs = nil
			} else {
				yyv26 := &x.Verbs
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					z.F.DecSliceStringX(yyv26, false, d)
				}
			}
		case "attributeRestrictions":
			if r.TryDecodeAsNil() {
				x.AttributeRestrictions = pkg1_runtime.RawExtension{}
			} else {
				yyv28 := &x.AttributeRestrictions
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv28) {
				} else if !yym29 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv28)
				} else {
					z.DecFallback(yyv28, false)
				}
			}
		case "apiGroups":
			if r.TryDecodeAsNil() {
				x.APIGroups = nil
			} else {
				yyv30 := &x.APIGroups
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					z.F.DecSliceStringX(yyv30, false, d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = nil
			} else {
				yyv32 := &x.Resources
				yym33 := z.DecBinary()
				_ = yym33
				if false {
				} else {
					z.F.DecSliceStringX(yyv32, false, d)
				}
			}
		case "resourceNames":
			if r.TryDecodeAsNil() {
				x.ResourceNames = nil
			} else {
				yyv34 := &x.ResourceNames
				yym35 := z.DecBinary()
				_ = yym35
				if false {
				} else {
					z.F.DecSliceStringX(yyv34, false, d)
				}
			}
		case "nonResourceURLs":
			if r.TryDecodeAsNil() {
				x.NonResourceURLs = nil
			} else {
				yyv36 := &x.NonResourceURLs
				yym37 := z.DecBinary()
				_ = yym37
				if false {
				} else {
					z.F.DecSliceStringX(yyv36, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys25)
		} // end switch yys25
	} // end for yyj25
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PolicyRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj38 int
	var yyb38 bool
	var yyhl38 bool = l >= 0
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verbs = nil
	} else {
		yyv39 := &x.Verbs
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			z.F.DecSliceStringX(yyv39, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AttributeRestrictions = pkg1_runtime.RawExtension{}
	} else {
		yyv41 := &x.AttributeRestrictions
		yym42 := z.DecBinary()
		_ = yym42
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv41) {
		} else if !yym42 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv41)
		} else {
			z.DecFallback(yyv41, false)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIGroups = nil
	} else {
		yyv43 := &x.APIGroups
		yym44 := z.DecBinary()
		_ = yym44
		if false {
		} else {
			z.F.DecSliceStringX(yyv43, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = nil
	} else {
		yyv45 := &x.Resources
		yym46 := z.DecBinary()
		_ = yym46
		if false {
		} else {
			z.F.DecSliceStringX(yyv45, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceNames = nil
	} else {
		yyv47 := &x.ResourceNames
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else {
			z.F.DecSliceStringX(yyv47, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonResourceURLs = nil
	} else {
		yyv49 := &x.NonResourceURLs
		yym50 := z.DecBinary()
		_ = yym50
		if false {
		} else {
			z.F.DecSliceStringX(yyv49, false, d)
		}
	}
	for {
		yyj38++
		if yyhl38 {
			yyb38 = yyj38 > l
		} else {
			yyb38 = r.CheckBreak()
		}
		if yyb38 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj38-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Subject) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym51 := z.EncBinary()
		_ = yym51
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep52 := !z.EncBinary()
			yy2arr52 := z.EncBasicHandle().StructToArray
			var yyq52 [4]bool
			_, _, _ = yysep52, yyq52, yy2arr52
			const yyr52 bool = false
			yyq52[1] = x.APIVersion != ""
			yyq52[3] = x.Namespace != ""
			var yynn52 int
			if yyr52 || yy2arr52 {
				r.EncodeArrayStart(4)
			} else {
				yynn52 = 2
				for _, b := range yyq52 {
					if b {
						yynn52++
					}
				}
				r.EncodeMapStart(yynn52)
				yynn52 = 0
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kind"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq52[1] {
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq52[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym58 := z.EncBinary()
					_ = yym58
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym60 := z.EncBinary()
				_ = yym60
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq52[3] {
					yym63 := z.EncBinary()
					_ = yym63
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq52[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Subject) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym65 := z.DecBinary()
	_ = yym65
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct66 := r.ContainerType()
		if yyct66 == codecSelferValueTypeMap1234 {
			yyl66 := r.ReadMapStart()
			if yyl66 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl66, d)
			}
		} else if yyct66 == codecSelferValueTypeArray1234 {
			yyl66 := r.ReadArrayStart()
			if yyl66 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl66, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Subject) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys67Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys67Slc
	var yyhl67 bool = l >= 0
	for yyj67 := 0; ; yyj67++ {
		if yyhl67 {
			if yyj67 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys67Slc = r.DecodeBytes(yys67Slc, true, true)
		yys67 := string(yys67Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys67 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys67)
		} // end switch yys67
	} // end for yyj67
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Subject) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj72 int
	var yyb72 bool
	var yyhl72 bool = l >= 0
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	for {
		yyj72++
		if yyhl72 {
			yyb72 = yyj72 > l
		} else {
			yyb72 = r.CheckBreak()
		}
		if yyb72 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj72-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Role) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [4]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			yyq78[0] = x.Kind != ""
			yyq78[1] = x.APIVersion != ""
			yyq78[2] = true
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(4)
			} else {
				yynn78 = 1
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[0] {
					yym80 := z.EncBinary()
					_ = yym80
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym81 := z.EncBinary()
					_ = yym81
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[1] {
					yym83 := z.EncBinary()
					_ = yym83
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq78[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym84 := z.EncBinary()
					_ = yym84
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq78[2] {
					yy86 := &x.ObjectMeta
					yy86.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq78[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy87 := &x.ObjectMeta
					yy87.CodecEncodeSelf(e)
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rules"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym90 := z.EncBinary()
					_ = yym90
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Role) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym91 := z.DecBinary()
	_ = yym91
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct92 := r.ContainerType()
		if yyct92 == codecSelferValueTypeMap1234 {
			yyl92 := r.ReadMapStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl92, d)
			}
		} else if yyct92 == codecSelferValueTypeArray1234 {
			yyl92 := r.ReadArrayStart()
			if yyl92 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl92, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Role) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys93Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys93Slc
	var yyhl93 bool = l >= 0
	for yyj93 := 0; ; yyj93++ {
		if yyhl93 {
			if yyj93 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys93Slc = r.DecodeBytes(yys93Slc, true, true)
		yys93 := string(yys93Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys93 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv96 := &x.ObjectMeta
				yyv96.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv97 := &x.Rules
				yym98 := z.DecBinary()
				_ = yym98
				if false {
				} else {
					h.decSlicePolicyRule((*[]PolicyRule)(yyv97), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys93)
		} // end switch yys93
	} // end for yyj93
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Role) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj99 int
	var yyb99 bool
	var yyhl99 bool = l >= 0
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv102 := &x.ObjectMeta
		yyv102.CodecDecodeSelf(d)
	}
	yyj99++
	if yyhl99 {
		yyb99 = yyj99 > l
	} else {
		yyb99 = r.CheckBreak()
	}
	if yyb99 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv103 := &x.Rules
		yym104 := z.DecBinary()
		_ = yym104
		if false {
		} else {
			h.decSlicePolicyRule((*[]PolicyRule)(yyv103), d)
		}
	}
	for {
		yyj99++
		if yyhl99 {
			yyb99 = yyj99 > l
		} else {
			yyb99 = r.CheckBreak()
		}
		if yyb99 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj99-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleBinding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym105 := z.EncBinary()
		_ = yym105
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep106 := !z.EncBinary()
			yy2arr106 := z.EncBasicHandle().StructToArray
			var yyq106 [5]bool
			_, _, _ = yysep106, yyq106, yy2arr106
			const yyr106 bool = false
			yyq106[0] = x.Kind != ""
			yyq106[1] = x.APIVersion != ""
			yyq106[2] = true
			var yynn106 int
			if yyr106 || yy2arr106 {
				r.EncodeArrayStart(5)
			} else {
				yynn106 = 2
				for _, b := range yyq106 {
					if b {
						yynn106++
					}
				}
				r.EncodeMapStart(yynn106)
				yynn106 = 0
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq106[0] {
					yym108 := z.EncBinary()
					_ = yym108
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq106[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym109 := z.EncBinary()
					_ = yym109
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq106[1] {
					yym111 := z.EncBinary()
					_ = yym111
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq106[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym112 := z.EncBinary()
					_ = yym112
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq106[2] {
					yy114 := &x.ObjectMeta
					yy114.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq106[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy115 := &x.ObjectMeta
					yy115.CodecEncodeSelf(e)
				}
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym117 := z.EncBinary()
					_ = yym117
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subjects"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym118 := z.EncBinary()
					_ = yym118
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy120 := &x.RoleRef
				yy120.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("roleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy121 := &x.RoleRef
				yy121.CodecEncodeSelf(e)
			}
			if yyr106 || yy2arr106 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleBinding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym122 := z.DecBinary()
	_ = yym122
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct123 := r.ContainerType()
		if yyct123 == codecSelferValueTypeMap1234 {
			yyl123 := r.ReadMapStart()
			if yyl123 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl123, d)
			}
		} else if yyct123 == codecSelferValueTypeArray1234 {
			yyl123 := r.ReadArrayStart()
			if yyl123 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl123, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleBinding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys124Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys124Slc
	var yyhl124 bool = l >= 0
	for yyj124 := 0; ; yyj124++ {
		if yyhl124 {
			if yyj124 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys124Slc = r.DecodeBytes(yys124Slc, true, true)
		yys124 := string(yys124Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys124 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv127 := &x.ObjectMeta
				yyv127.CodecDecodeSelf(d)
			}
		case "subjects":
			if r.TryDecodeAsNil() {
				x.Subjects = nil
			} else {
				yyv128 := &x.Subjects
				yym129 := z.DecBinary()
				_ = yym129
				if false {
				} else {
					h.decSliceSubject((*[]Subject)(yyv128), d)
				}
			}
		case "roleRef":
			if r.TryDecodeAsNil() {
				x.RoleRef = pkg3_v1.ObjectReference{}
			} else {
				yyv130 := &x.RoleRef
				yyv130.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys124)
		} // end switch yys124
	} // end for yyj124
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleBinding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj131 int
	var yyb131 bool
	var yyhl131 bool = l >= 0
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv134 := &x.ObjectMeta
		yyv134.CodecDecodeSelf(d)
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subjects = nil
	} else {
		yyv135 := &x.Subjects
		yym136 := z.DecBinary()
		_ = yym136
		if false {
		} else {
			h.decSliceSubject((*[]Subject)(yyv135), d)
		}
	}
	yyj131++
	if yyhl131 {
		yyb131 = yyj131 > l
	} else {
		yyb131 = r.CheckBreak()
	}
	if yyb131 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RoleRef = pkg3_v1.ObjectReference{}
	} else {
		yyv137 := &x.RoleRef
		yyv137.CodecDecodeSelf(d)
	}
	for {
		yyj131++
		if yyhl131 {
			yyb131 = yyj131 > l
		} else {
			yyb131 = r.CheckBreak()
		}
		if yyb131 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj131-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleBindingList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym138 := z.EncBinary()
		_ = yym138
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep139 := !z.EncBinary()
			yy2arr139 := z.EncBasicHandle().StructToArray
			var yyq139 [4]bool
			_, _, _ = yysep139, yyq139, yy2arr139
			const yyr139 bool = false
			yyq139[0] = x.Kind != ""
			yyq139[1] = x.APIVersion != ""
			yyq139[2] = true
			var yynn139 int
			if yyr139 || yy2arr139 {
				r.EncodeArrayStart(4)
			} else {
				yynn139 = 1
				for _, b := range yyq139 {
					if b {
						yynn139++
					}
				}
				r.EncodeMapStart(yynn139)
				yynn139 = 0
			}
			if yyr139 || yy2arr139 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq139[0] {
					yym141 := z.EncBinary()
					_ = yym141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq139[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr139 || yy2arr139 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq139[1] {
					yym144 := z.EncBinary()
					_ = yym144
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq139[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym145 := z.EncBinary()
					_ = yym145
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr139 || yy2arr139 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq139[2] {
					yy147 := &x.ListMeta
					yym148 := z.EncBinary()
					_ = yym148
					if false {
					} else if z.HasExtensions() && z.EncExt(yy147) {
					} else {
						z.EncFallback(yy147)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq139[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy149 := &x.ListMeta
					yym150 := z.EncBinary()
					_ = yym150
					if false {
					} else if z.HasExtensions() && z.EncExt(yy149) {
					} else {
						z.EncFallback(yy149)
					}
				}
			}
			if yyr139 || yy2arr139 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym152 := z.EncBinary()
					_ = yym152
					if false {
					} else {
						h.encSliceRoleBinding(([]RoleBinding)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym153 := z.EncBinary()
					_ = yym153
					if false {
					} else {
						h.encSliceRoleBinding(([]RoleBinding)(x.Items), e)
					}
				}
			}
			if yyr139 || yy2arr139 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleBindingList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym154 := z.DecBinary()
	_ = yym154
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct155 := r.ContainerType()
		if yyct155 == codecSelferValueTypeMap1234 {
			yyl155 := r.ReadMapStart()
			if yyl155 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl155, d)
			}
		} else if yyct155 == codecSelferValueTypeArray1234 {
			yyl155 := r.ReadArrayStart()
			if yyl155 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl155, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleBindingList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys156Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys156Slc
	var yyhl156 bool = l >= 0
	for yyj156 := 0; ; yyj156++ {
		if yyhl156 {
			if yyj156 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys156Slc = r.DecodeBytes(yys156Slc, true, true)
		yys156 := string(yys156Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys156 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv159 := &x.ListMeta
				yym160 := z.DecBinary()
				_ = yym160
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv159) {
				} else {
					z.DecFallback(yyv159, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv161 := &x.Items
				yym162 := z.DecBinary()
				_ = yym162
				if false {
				} else {
					h.decSliceRoleBinding((*[]RoleBinding)(yyv161), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys156)
		} // end switch yys156
	} // end for yyj156
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleBindingList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj163 int
	var yyb163 bool
	var yyhl163 bool = l >= 0
	yyj163++
	if yyhl163 {
		yyb163 = yyj163 > l
	} else {
		yyb163 = r.CheckBreak()
	}
	if yyb163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj163++
	if yyhl163 {
		yyb163 = yyj163 > l
	} else {
		yyb163 = r.CheckBreak()
	}
	if yyb163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj163++
	if yyhl163 {
		yyb163 = yyj163 > l
	} else {
		yyb163 = r.CheckBreak()
	}
	if yyb163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv166 := &x.ListMeta
		yym167 := z.DecBinary()
		_ = yym167
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv166) {
		} else {
			z.DecFallback(yyv166, false)
		}
	}
	yyj163++
	if yyhl163 {
		yyb163 = yyj163 > l
	} else {
		yyb163 = r.CheckBreak()
	}
	if yyb163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv168 := &x.Items
		yym169 := z.DecBinary()
		_ = yym169
		if false {
		} else {
			h.decSliceRoleBinding((*[]RoleBinding)(yyv168), d)
		}
	}
	for {
		yyj163++
		if yyhl163 {
			yyb163 = yyj163 > l
		} else {
			yyb163 = r.CheckBreak()
		}
		if yyb163 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj163-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym170 := z.EncBinary()
		_ = yym170
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep171 := !z.EncBinary()
			yy2arr171 := z.EncBasicHandle().StructToArray
			var yyq171 [4]bool
			_, _, _ = yysep171, yyq171, yy2arr171
			const yyr171 bool = false
			yyq171[0] = x.Kind != ""
			yyq171[1] = x.APIVersion != ""
			yyq171[2] = true
			var yynn171 int
			if yyr171 || yy2arr171 {
				r.EncodeArrayStart(4)
			} else {
				yynn171 = 1
				for _, b := range yyq171 {
					if b {
						yynn171++
					}
				}
				r.EncodeMapStart(yynn171)
				yynn171 = 0
			}
			if yyr171 || yy2arr171 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq171[0] {
					yym173 := z.EncBinary()
					_ = yym173
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq171[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym174 := z.EncBinary()
					_ = yym174
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr171 || yy2arr171 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq171[1] {
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq171[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym177 := z.EncBinary()
					_ = yym177
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr171 || yy2arr171 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq171[2] {
					yy179 := &x.ListMeta
					yym180 := z.EncBinary()
					_ = yym180
					if false {
					} else if z.HasExtensions() && z.EncExt(yy179) {
					} else {
						z.EncFallback(yy179)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq171[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy181 := &x.ListMeta
					yym182 := z.EncBinary()
					_ = yym182
					if false {
					} else if z.HasExtensions() && z.EncExt(yy181) {
					} else {
						z.EncFallback(yy181)
					}
				}
			}
			if yyr171 || yy2arr171 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym184 := z.EncBinary()
					_ = yym184
					if false {
					} else {
						h.encSliceRole(([]Role)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym185 := z.EncBinary()
					_ = yym185
					if false {
					} else {
						h.encSliceRole(([]Role)(x.Items), e)
					}
				}
			}
			if yyr171 || yy2arr171 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym186 := z.DecBinary()
	_ = yym186
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct187 := r.ContainerType()
		if yyct187 == codecSelferValueTypeMap1234 {
			yyl187 := r.ReadMapStart()
			if yyl187 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl187, d)
			}
		} else if yyct187 == codecSelferValueTypeArray1234 {
			yyl187 := r.ReadArrayStart()
			if yyl187 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl187, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys188Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys188Slc
	var yyhl188 bool = l >= 0
	for yyj188 := 0; ; yyj188++ {
		if yyhl188 {
			if yyj188 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys188Slc = r.DecodeBytes(yys188Slc, true, true)
		yys188 := string(yys188Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys188 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv191 := &x.ListMeta
				yym192 := z.DecBinary()
				_ = yym192
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv191) {
				} else {
					z.DecFallback(yyv191, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv193 := &x.Items
				yym194 := z.DecBinary()
				_ = yym194
				if false {
				} else {
					h.decSliceRole((*[]Role)(yyv193), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys188)
		} // end switch yys188
	} // end for yyj188
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj195 int
	var yyb195 bool
	var yyhl195 bool = l >= 0
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv198 := &x.ListMeta
		yym199 := z.DecBinary()
		_ = yym199
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv198) {
		} else {
			z.DecFallback(yyv198, false)
		}
	}
	yyj195++
	if yyhl195 {
		yyb195 = yyj195 > l
	} else {
		yyb195 = r.CheckBreak()
	}
	if yyb195 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv200 := &x.Items
		yym201 := z.DecBinary()
		_ = yym201
		if false {
		} else {
			h.decSliceRole((*[]Role)(yyv200), d)
		}
	}
	for {
		yyj195++
		if yyhl195 {
			yyb195 = yyj195 > l
		} else {
			yyb195 = r.CheckBreak()
		}
		if yyb195 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj195-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRole) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym202 := z.EncBinary()
		_ = yym202
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep203 := !z.EncBinary()
			yy2arr203 := z.EncBasicHandle().StructToArray
			var yyq203 [4]bool
			_, _, _ = yysep203, yyq203, yy2arr203
			const yyr203 bool = false
			yyq203[0] = x.Kind != ""
			yyq203[1] = x.APIVersion != ""
			yyq203[2] = true
			var yynn203 int
			if yyr203 || yy2arr203 {
				r.EncodeArrayStart(4)
			} else {
				yynn203 = 1
				for _, b := range yyq203 {
					if b {
						yynn203++
					}
				}
				r.EncodeMapStart(yynn203)
				yynn203 = 0
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq203[0] {
					yym205 := z.EncBinary()
					_ = yym205
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq203[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym206 := z.EncBinary()
					_ = yym206
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq203[1] {
					yym208 := z.EncBinary()
					_ = yym208
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq203[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym209 := z.EncBinary()
					_ = yym209
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq203[2] {
					yy211 := &x.ObjectMeta
					yy211.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq203[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy212 := &x.ObjectMeta
					yy212.CodecEncodeSelf(e)
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym214 := z.EncBinary()
					_ = yym214
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rules"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym215 := z.EncBinary()
					_ = yym215
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRole) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym216 := z.DecBinary()
	_ = yym216
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct217 := r.ContainerType()
		if yyct217 == codecSelferValueTypeMap1234 {
			yyl217 := r.ReadMapStart()
			if yyl217 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl217, d)
			}
		} else if yyct217 == codecSelferValueTypeArray1234 {
			yyl217 := r.ReadArrayStart()
			if yyl217 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl217, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRole) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys218Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys218Slc
	var yyhl218 bool = l >= 0
	for yyj218 := 0; ; yyj218++ {
		if yyhl218 {
			if yyj218 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys218Slc = r.DecodeBytes(yys218Slc, true, true)
		yys218 := string(yys218Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys218 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv221 := &x.ObjectMeta
				yyv221.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv222 := &x.Rules
				yym223 := z.DecBinary()
				_ = yym223
				if false {
				} else {
					h.decSlicePolicyRule((*[]PolicyRule)(yyv222), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys218)
		} // end switch yys218
	} // end for yyj218
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRole) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj224 int
	var yyb224 bool
	var yyhl224 bool = l >= 0
	yyj224++
	if yyhl224 {
		yyb224 = yyj224 > l
	} else {
		yyb224 = r.CheckBreak()
	}
	if yyb224 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj224++
	if yyhl224 {
		yyb224 = yyj224 > l
	} else {
		yyb224 = r.CheckBreak()
	}
	if yyb224 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj224++
	if yyhl224 {
		yyb224 = yyj224 > l
	} else {
		yyb224 = r.CheckBreak()
	}
	if yyb224 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv227 := &x.ObjectMeta
		yyv227.CodecDecodeSelf(d)
	}
	yyj224++
	if yyhl224 {
		yyb224 = yyj224 > l
	} else {
		yyb224 = r.CheckBreak()
	}
	if yyb224 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv228 := &x.Rules
		yym229 := z.DecBinary()
		_ = yym229
		if false {
		} else {
			h.decSlicePolicyRule((*[]PolicyRule)(yyv228), d)
		}
	}
	for {
		yyj224++
		if yyhl224 {
			yyb224 = yyj224 > l
		} else {
			yyb224 = r.CheckBreak()
		}
		if yyb224 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj224-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleBinding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym230 := z.EncBinary()
		_ = yym230
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep231 := !z.EncBinary()
			yy2arr231 := z.EncBasicHandle().StructToArray
			var yyq231 [5]bool
			_, _, _ = yysep231, yyq231, yy2arr231
			const yyr231 bool = false
			yyq231[0] = x.Kind != ""
			yyq231[1] = x.APIVersion != ""
			yyq231[2] = true
			var yynn231 int
			if yyr231 || yy2arr231 {
				r.EncodeArrayStart(5)
			} else {
				yynn231 = 2
				for _, b := range yyq231 {
					if b {
						yynn231++
					}
				}
				r.EncodeMapStart(yynn231)
				yynn231 = 0
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq231[0] {
					yym233 := z.EncBinary()
					_ = yym233
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq231[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym234 := z.EncBinary()
					_ = yym234
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq231[1] {
					yym236 := z.EncBinary()
					_ = yym236
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq231[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym237 := z.EncBinary()
					_ = yym237
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq231[2] {
					yy239 := &x.ObjectMeta
					yy239.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq231[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy240 := &x.ObjectMeta
					yy240.CodecEncodeSelf(e)
				}
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym242 := z.EncBinary()
					_ = yym242
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subjects"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym243 := z.EncBinary()
					_ = yym243
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy245 := &x.RoleRef
				yy245.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("roleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy246 := &x.RoleRef
				yy246.CodecEncodeSelf(e)
			}
			if yyr231 || yy2arr231 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleBinding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym247 := z.DecBinary()
	_ = yym247
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct248 := r.ContainerType()
		if yyct248 == codecSelferValueTypeMap1234 {
			yyl248 := r.ReadMapStart()
			if yyl248 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl248, d)
			}
		} else if yyct248 == codecSelferValueTypeArray1234 {
			yyl248 := r.ReadArrayStart()
			if yyl248 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl248, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleBinding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys249Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys249Slc
	var yyhl249 bool = l >= 0
	for yyj249 := 0; ; yyj249++ {
		if yyhl249 {
			if yyj249 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys249Slc = r.DecodeBytes(yys249Slc, true, true)
		yys249 := string(yys249Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys249 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv252 := &x.ObjectMeta
				yyv252.CodecDecodeSelf(d)
			}
		case "subjects":
			if r.TryDecodeAsNil() {
				x.Subjects = nil
			} else {
				yyv253 := &x.Subjects
				yym254 := z.DecBinary()
				_ = yym254
				if false {
				} else {
					h.decSliceSubject((*[]Subject)(yyv253), d)
				}
			}
		case "roleRef":
			if r.TryDecodeAsNil() {
				x.RoleRef = pkg3_v1.ObjectReference{}
			} else {
				yyv255 := &x.RoleRef
				yyv255.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys249)
		} // end switch yys249
	} // end for yyj249
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleBinding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj256 int
	var yyb256 bool
	var yyhl256 bool = l >= 0
	yyj256++
	if yyhl256 {
		yyb256 = yyj256 > l
	} else {
		yyb256 = r.CheckBreak()
	}
	if yyb256 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj256++
	if yyhl256 {
		yyb256 = yyj256 > l
	} else {
		yyb256 = r.CheckBreak()
	}
	if yyb256 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj256++
	if yyhl256 {
		yyb256 = yyj256 > l
	} else {
		yyb256 = r.CheckBreak()
	}
	if yyb256 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv259 := &x.ObjectMeta
		yyv259.CodecDecodeSelf(d)
	}
	yyj256++
	if yyhl256 {
		yyb256 = yyj256 > l
	} else {
		yyb256 = r.CheckBreak()
	}
	if yyb256 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subjects = nil
	} else {
		yyv260 := &x.Subjects
		yym261 := z.DecBinary()
		_ = yym261
		if false {
		} else {
			h.decSliceSubject((*[]Subject)(yyv260), d)
		}
	}
	yyj256++
	if yyhl256 {
		yyb256 = yyj256 > l
	} else {
		yyb256 = r.CheckBreak()
	}
	if yyb256 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RoleRef = pkg3_v1.ObjectReference{}
	} else {
		yyv262 := &x.RoleRef
		yyv262.CodecDecodeSelf(d)
	}
	for {
		yyj256++
		if yyhl256 {
			yyb256 = yyj256 > l
		} else {
			yyb256 = r.CheckBreak()
		}
		if yyb256 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj256-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleBindingList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym263 := z.EncBinary()
		_ = yym263
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep264 := !z.EncBinary()
			yy2arr264 := z.EncBasicHandle().StructToArray
			var yyq264 [4]bool
			_, _, _ = yysep264, yyq264, yy2arr264
			const yyr264 bool = false
			yyq264[0] = x.Kind != ""
			yyq264[1] = x.APIVersion != ""
			yyq264[2] = true
			var yynn264 int
			if yyr264 || yy2arr264 {
				r.EncodeArrayStart(4)
			} else {
				yynn264 = 1
				for _, b := range yyq264 {
					if b {
						yynn264++
					}
				}
				r.EncodeMapStart(yynn264)
				yynn264 = 0
			}
			if yyr264 || yy2arr264 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq264[0] {
					yym266 := z.EncBinary()
					_ = yym266
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq264[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym267 := z.EncBinary()
					_ = yym267
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr264 || yy2arr264 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq264[1] {
					yym269 := z.EncBinary()
					_ = yym269
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq264[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym270 := z.EncBinary()
					_ = yym270
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr264 || yy2arr264 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq264[2] {
					yy272 := &x.ListMeta
					yym273 := z.EncBinary()
					_ = yym273
					if false {
					} else if z.HasExtensions() && z.EncExt(yy272) {
					} else {
						z.EncFallback(yy272)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq264[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy274 := &x.ListMeta
					yym275 := z.EncBinary()
					_ = yym275
					if false {
					} else if z.HasExtensions() && z.EncExt(yy274) {
					} else {
						z.EncFallback(yy274)
					}
				}
			}
			if yyr264 || yy2arr264 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym277 := z.EncBinary()
					_ = yym277
					if false {
					} else {
						h.encSliceClusterRoleBinding(([]ClusterRoleBinding)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym278 := z.EncBinary()
					_ = yym278
					if false {
					} else {
						h.encSliceClusterRoleBinding(([]ClusterRoleBinding)(x.Items), e)
					}
				}
			}
			if yyr264 || yy2arr264 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleBindingList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym279 := z.DecBinary()
	_ = yym279
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct280 := r.ContainerType()
		if yyct280 == codecSelferValueTypeMap1234 {
			yyl280 := r.ReadMapStart()
			if yyl280 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl280, d)
			}
		} else if yyct280 == codecSelferValueTypeArray1234 {
			yyl280 := r.ReadArrayStart()
			if yyl280 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl280, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleBindingList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys281Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys281Slc
	var yyhl281 bool = l >= 0
	for yyj281 := 0; ; yyj281++ {
		if yyhl281 {
			if yyj281 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys281Slc = r.DecodeBytes(yys281Slc, true, true)
		yys281 := string(yys281Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys281 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv284 := &x.ListMeta
				yym285 := z.DecBinary()
				_ = yym285
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv284) {
				} else {
					z.DecFallback(yyv284, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv286 := &x.Items
				yym287 := z.DecBinary()
				_ = yym287
				if false {
				} else {
					h.decSliceClusterRoleBinding((*[]ClusterRoleBinding)(yyv286), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys281)
		} // end switch yys281
	} // end for yyj281
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleBindingList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj288 int
	var yyb288 bool
	var yyhl288 bool = l >= 0
	yyj288++
	if yyhl288 {
		yyb288 = yyj288 > l
	} else {
		yyb288 = r.CheckBreak()
	}
	if yyb288 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj288++
	if yyhl288 {
		yyb288 = yyj288 > l
	} else {
		yyb288 = r.CheckBreak()
	}
	if yyb288 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj288++
	if yyhl288 {
		yyb288 = yyj288 > l
	} else {
		yyb288 = r.CheckBreak()
	}
	if yyb288 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv291 := &x.ListMeta
		yym292 := z.DecBinary()
		_ = yym292
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv291) {
		} else {
			z.DecFallback(yyv291, false)
		}
	}
	yyj288++
	if yyhl288 {
		yyb288 = yyj288 > l
	} else {
		yyb288 = r.CheckBreak()
	}
	if yyb288 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv293 := &x.Items
		yym294 := z.DecBinary()
		_ = yym294
		if false {
		} else {
			h.decSliceClusterRoleBinding((*[]ClusterRoleBinding)(yyv293), d)
		}
	}
	for {
		yyj288++
		if yyhl288 {
			yyb288 = yyj288 > l
		} else {
			yyb288 = r.CheckBreak()
		}
		if yyb288 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj288-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym295 := z.EncBinary()
		_ = yym295
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep296 := !z.EncBinary()
			yy2arr296 := z.EncBasicHandle().StructToArray
			var yyq296 [4]bool
			_, _, _ = yysep296, yyq296, yy2arr296
			const yyr296 bool = false
			yyq296[0] = x.Kind != ""
			yyq296[1] = x.APIVersion != ""
			yyq296[2] = true
			var yynn296 int
			if yyr296 || yy2arr296 {
				r.EncodeArrayStart(4)
			} else {
				yynn296 = 1
				for _, b := range yyq296 {
					if b {
						yynn296++
					}
				}
				r.EncodeMapStart(yynn296)
				yynn296 = 0
			}
			if yyr296 || yy2arr296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq296[0] {
					yym298 := z.EncBinary()
					_ = yym298
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq296[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym299 := z.EncBinary()
					_ = yym299
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr296 || yy2arr296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq296[1] {
					yym301 := z.EncBinary()
					_ = yym301
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq296[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym302 := z.EncBinary()
					_ = yym302
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr296 || yy2arr296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq296[2] {
					yy304 := &x.ListMeta
					yym305 := z.EncBinary()
					_ = yym305
					if false {
					} else if z.HasExtensions() && z.EncExt(yy304) {
					} else {
						z.EncFallback(yy304)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq296[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy306 := &x.ListMeta
					yym307 := z.EncBinary()
					_ = yym307
					if false {
					} else if z.HasExtensions() && z.EncExt(yy306) {
					} else {
						z.EncFallback(yy306)
					}
				}
			}
			if yyr296 || yy2arr296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym309 := z.EncBinary()
					_ = yym309
					if false {
					} else {
						h.encSliceClusterRole(([]ClusterRole)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym310 := z.EncBinary()
					_ = yym310
					if false {
					} else {
						h.encSliceClusterRole(([]ClusterRole)(x.Items), e)
					}
				}
			}
			if yyr296 || yy2arr296 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym311 := z.DecBinary()
	_ = yym311
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct312 := r.ContainerType()
		if yyct312 == codecSelferValueTypeMap1234 {
			yyl312 := r.ReadMapStart()
			if yyl312 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl312, d)
			}
		} else if yyct312 == codecSelferValueTypeArray1234 {
			yyl312 := r.ReadArrayStart()
			if yyl312 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl312, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys313Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys313Slc
	var yyhl313 bool = l >= 0
	for yyj313 := 0; ; yyj313++ {
		if yyhl313 {
			if yyj313 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys313Slc = r.DecodeBytes(yys313Slc, true, true)
		yys313 := string(yys313Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys313 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv316 := &x.ListMeta
				yym317 := z.DecBinary()
				_ = yym317
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv316) {
				} else {
					z.DecFallback(yyv316, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv318 := &x.Items
				yym319 := z.DecBinary()
				_ = yym319
				if false {
				} else {
					h.decSliceClusterRole((*[]ClusterRole)(yyv318), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys313)
		} // end switch yys313
	} // end for yyj313
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj320 int
	var yyb320 bool
	var yyhl320 bool = l >= 0
	yyj320++
	if yyhl320 {
		yyb320 = yyj320 > l
	} else {
		yyb320 = r.CheckBreak()
	}
	if yyb320 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj320++
	if yyhl320 {
		yyb320 = yyj320 > l
	} else {
		yyb320 = r.CheckBreak()
	}
	if yyb320 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj320++
	if yyhl320 {
		yyb320 = yyj320 > l
	} else {
		yyb320 = r.CheckBreak()
	}
	if yyb320 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv323 := &x.ListMeta
		yym324 := z.DecBinary()
		_ = yym324
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv323) {
		} else {
			z.DecFallback(yyv323, false)
		}
	}
	yyj320++
	if yyhl320 {
		yyb320 = yyj320 > l
	} else {
		yyb320 = r.CheckBreak()
	}
	if yyb320 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv325 := &x.Items
		yym326 := z.DecBinary()
		_ = yym326
		if false {
		} else {
			h.decSliceClusterRole((*[]ClusterRole)(yyv325), d)
		}
	}
	for {
		yyj320++
		if yyhl320 {
			yyb320 = yyj320 > l
		} else {
			yyb320 = r.CheckBreak()
		}
		if yyb320 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj320-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSlicePolicyRule(v []PolicyRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv327 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy328 := &yyv327
		yy328.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePolicyRule(v *[]PolicyRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv329 := *v
	yyh329, yyl329 := z.DecSliceHelperStart()
	var yyc329 bool
	if yyl329 == 0 {
		if yyv329 == nil {
			yyv329 = []PolicyRule{}
			yyc329 = true
		} else if len(yyv329) != 0 {
			yyv329 = yyv329[:0]
			yyc329 = true
		}
	} else if yyl329 > 0 {
		var yyrr329, yyrl329 int
		var yyrt329 bool
		if yyl329 > cap(yyv329) {

			yyrg329 := len(yyv329) > 0
			yyv2329 := yyv329
			yyrl329, yyrt329 = z.DecInferLen(yyl329, z.DecBasicHandle().MaxInitLen, 160)
			if yyrt329 {
				if yyrl329 <= cap(yyv329) {
					yyv329 = yyv329[:yyrl329]
				} else {
					yyv329 = make([]PolicyRule, yyrl329)
				}
			} else {
				yyv329 = make([]PolicyRule, yyrl329)
			}
			yyc329 = true
			yyrr329 = len(yyv329)
			if yyrg329 {
				copy(yyv329, yyv2329)
			}
		} else if yyl329 != len(yyv329) {
			yyv329 = yyv329[:yyl329]
			yyc329 = true
		}
		yyj329 := 0
		for ; yyj329 < yyrr329; yyj329++ {
			yyh329.ElemContainerState(yyj329)
			if r.TryDecodeAsNil() {
				yyv329[yyj329] = PolicyRule{}
			} else {
				yyv330 := &yyv329[yyj329]
				yyv330.CodecDecodeSelf(d)
			}

		}
		if yyrt329 {
			for ; yyj329 < yyl329; yyj329++ {
				yyv329 = append(yyv329, PolicyRule{})
				yyh329.ElemContainerState(yyj329)
				if r.TryDecodeAsNil() {
					yyv329[yyj329] = PolicyRule{}
				} else {
					yyv331 := &yyv329[yyj329]
					yyv331.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj329 := 0
		for ; !r.CheckBreak(); yyj329++ {

			if yyj329 >= len(yyv329) {
				yyv329 = append(yyv329, PolicyRule{}) // var yyz329 PolicyRule
				yyc329 = true
			}
			yyh329.ElemContainerState(yyj329)
			if yyj329 < len(yyv329) {
				if r.TryDecodeAsNil() {
					yyv329[yyj329] = PolicyRule{}
				} else {
					yyv332 := &yyv329[yyj329]
					yyv332.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj329 < len(yyv329) {
			yyv329 = yyv329[:yyj329]
			yyc329 = true
		} else if yyj329 == 0 && yyv329 == nil {
			yyv329 = []PolicyRule{}
			yyc329 = true
		}
	}
	yyh329.End()
	if yyc329 {
		*v = yyv329
	}
}

func (x codecSelfer1234) encSliceSubject(v []Subject, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv333 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy334 := &yyv333
		yy334.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceSubject(v *[]Subject, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv335 := *v
	yyh335, yyl335 := z.DecSliceHelperStart()
	var yyc335 bool
	if yyl335 == 0 {
		if yyv335 == nil {
			yyv335 = []Subject{}
			yyc335 = true
		} else if len(yyv335) != 0 {
			yyv335 = yyv335[:0]
			yyc335 = true
		}
	} else if yyl335 > 0 {
		var yyrr335, yyrl335 int
		var yyrt335 bool
		if yyl335 > cap(yyv335) {

			yyrg335 := len(yyv335) > 0
			yyv2335 := yyv335
			yyrl335, yyrt335 = z.DecInferLen(yyl335, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt335 {
				if yyrl335 <= cap(yyv335) {
					yyv335 = yyv335[:yyrl335]
				} else {
					yyv335 = make([]Subject, yyrl335)
				}
			} else {
				yyv335 = make([]Subject, yyrl335)
			}
			yyc335 = true
			yyrr335 = len(yyv335)
			if yyrg335 {
				copy(yyv335, yyv2335)
			}
		} else if yyl335 != len(yyv335) {
			yyv335 = yyv335[:yyl335]
			yyc335 = true
		}
		yyj335 := 0
		for ; yyj335 < yyrr335; yyj335++ {
			yyh335.ElemContainerState(yyj335)
			if r.TryDecodeAsNil() {
				yyv335[yyj335] = Subject{}
			} else {
				yyv336 := &yyv335[yyj335]
				yyv336.CodecDecodeSelf(d)
			}

		}
		if yyrt335 {
			for ; yyj335 < yyl335; yyj335++ {
				yyv335 = append(yyv335, Subject{})
				yyh335.ElemContainerState(yyj335)
				if r.TryDecodeAsNil() {
					yyv335[yyj335] = Subject{}
				} else {
					yyv337 := &yyv335[yyj335]
					yyv337.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj335 := 0
		for ; !r.CheckBreak(); yyj335++ {

			if yyj335 >= len(yyv335) {
				yyv335 = append(yyv335, Subject{}) // var yyz335 Subject
				yyc335 = true
			}
			yyh335.ElemContainerState(yyj335)
			if yyj335 < len(yyv335) {
				if r.TryDecodeAsNil() {
					yyv335[yyj335] = Subject{}
				} else {
					yyv338 := &yyv335[yyj335]
					yyv338.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj335 < len(yyv335) {
			yyv335 = yyv335[:yyj335]
			yyc335 = true
		} else if yyj335 == 0 && yyv335 == nil {
			yyv335 = []Subject{}
			yyc335 = true
		}
	}
	yyh335.End()
	if yyc335 {
		*v = yyv335
	}
}

func (x codecSelfer1234) encSliceRoleBinding(v []RoleBinding, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv339 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy340 := &yyv339
		yy340.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceRoleBinding(v *[]RoleBinding, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv341 := *v
	yyh341, yyl341 := z.DecSliceHelperStart()
	var yyc341 bool
	if yyl341 == 0 {
		if yyv341 == nil {
			yyv341 = []RoleBinding{}
			yyc341 = true
		} else if len(yyv341) != 0 {
			yyv341 = yyv341[:0]
			yyc341 = true
		}
	} else if yyl341 > 0 {
		var yyrr341, yyrl341 int
		var yyrt341 bool
		if yyl341 > cap(yyv341) {

			yyrg341 := len(yyv341) > 0
			yyv2341 := yyv341
			yyrl341, yyrt341 = z.DecInferLen(yyl341, z.DecBasicHandle().MaxInitLen, 392)
			if yyrt341 {
				if yyrl341 <= cap(yyv341) {
					yyv341 = yyv341[:yyrl341]
				} else {
					yyv341 = make([]RoleBinding, yyrl341)
				}
			} else {
				yyv341 = make([]RoleBinding, yyrl341)
			}
			yyc341 = true
			yyrr341 = len(yyv341)
			if yyrg341 {
				copy(yyv341, yyv2341)
			}
		} else if yyl341 != len(yyv341) {
			yyv341 = yyv341[:yyl341]
			yyc341 = true
		}
		yyj341 := 0
		for ; yyj341 < yyrr341; yyj341++ {
			yyh341.ElemContainerState(yyj341)
			if r.TryDecodeAsNil() {
				yyv341[yyj341] = RoleBinding{}
			} else {
				yyv342 := &yyv341[yyj341]
				yyv342.CodecDecodeSelf(d)
			}

		}
		if yyrt341 {
			for ; yyj341 < yyl341; yyj341++ {
				yyv341 = append(yyv341, RoleBinding{})
				yyh341.ElemContainerState(yyj341)
				if r.TryDecodeAsNil() {
					yyv341[yyj341] = RoleBinding{}
				} else {
					yyv343 := &yyv341[yyj341]
					yyv343.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj341 := 0
		for ; !r.CheckBreak(); yyj341++ {

			if yyj341 >= len(yyv341) {
				yyv341 = append(yyv341, RoleBinding{}) // var yyz341 RoleBinding
				yyc341 = true
			}
			yyh341.ElemContainerState(yyj341)
			if yyj341 < len(yyv341) {
				if r.TryDecodeAsNil() {
					yyv341[yyj341] = RoleBinding{}
				} else {
					yyv344 := &yyv341[yyj341]
					yyv344.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj341 < len(yyv341) {
			yyv341 = yyv341[:yyj341]
			yyc341 = true
		} else if yyj341 == 0 && yyv341 == nil {
			yyv341 = []RoleBinding{}
			yyc341 = true
		}
	}
	yyh341.End()
	if yyc341 {
		*v = yyv341
	}
}

func (x codecSelfer1234) encSliceRole(v []Role, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv345 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy346 := &yyv345
		yy346.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceRole(v *[]Role, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv347 := *v
	yyh347, yyl347 := z.DecSliceHelperStart()
	var yyc347 bool
	if yyl347 == 0 {
		if yyv347 == nil {
			yyv347 = []Role{}
			yyc347 = true
		} else if len(yyv347) != 0 {
			yyv347 = yyv347[:0]
			yyc347 = true
		}
	} else if yyl347 > 0 {
		var yyrr347, yyrl347 int
		var yyrt347 bool
		if yyl347 > cap(yyv347) {

			yyrg347 := len(yyv347) > 0
			yyv2347 := yyv347
			yyrl347, yyrt347 = z.DecInferLen(yyl347, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt347 {
				if yyrl347 <= cap(yyv347) {
					yyv347 = yyv347[:yyrl347]
				} else {
					yyv347 = make([]Role, yyrl347)
				}
			} else {
				yyv347 = make([]Role, yyrl347)
			}
			yyc347 = true
			yyrr347 = len(yyv347)
			if yyrg347 {
				copy(yyv347, yyv2347)
			}
		} else if yyl347 != len(yyv347) {
			yyv347 = yyv347[:yyl347]
			yyc347 = true
		}
		yyj347 := 0
		for ; yyj347 < yyrr347; yyj347++ {
			yyh347.ElemContainerState(yyj347)
			if r.TryDecodeAsNil() {
				yyv347[yyj347] = Role{}
			} else {
				yyv348 := &yyv347[yyj347]
				yyv348.CodecDecodeSelf(d)
			}

		}
		if yyrt347 {
			for ; yyj347 < yyl347; yyj347++ {
				yyv347 = append(yyv347, Role{})
				yyh347.ElemContainerState(yyj347)
				if r.TryDecodeAsNil() {
					yyv347[yyj347] = Role{}
				} else {
					yyv349 := &yyv347[yyj347]
					yyv349.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj347 := 0
		for ; !r.CheckBreak(); yyj347++ {

			if yyj347 >= len(yyv347) {
				yyv347 = append(yyv347, Role{}) // var yyz347 Role
				yyc347 = true
			}
			yyh347.ElemContainerState(yyj347)
			if yyj347 < len(yyv347) {
				if r.TryDecodeAsNil() {
					yyv347[yyj347] = Role{}
				} else {
					yyv350 := &yyv347[yyj347]
					yyv350.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj347 < len(yyv347) {
			yyv347 = yyv347[:yyj347]
			yyc347 = true
		} else if yyj347 == 0 && yyv347 == nil {
			yyv347 = []Role{}
			yyc347 = true
		}
	}
	yyh347.End()
	if yyc347 {
		*v = yyv347
	}
}

func (x codecSelfer1234) encSliceClusterRoleBinding(v []ClusterRoleBinding, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv351 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy352 := &yyv351
		yy352.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterRoleBinding(v *[]ClusterRoleBinding, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv353 := *v
	yyh353, yyl353 := z.DecSliceHelperStart()
	var yyc353 bool
	if yyl353 == 0 {
		if yyv353 == nil {
			yyv353 = []ClusterRoleBinding{}
			yyc353 = true
		} else if len(yyv353) != 0 {
			yyv353 = yyv353[:0]
			yyc353 = true
		}
	} else if yyl353 > 0 {
		var yyrr353, yyrl353 int
		var yyrt353 bool
		if yyl353 > cap(yyv353) {

			yyrg353 := len(yyv353) > 0
			yyv2353 := yyv353
			yyrl353, yyrt353 = z.DecInferLen(yyl353, z.DecBasicHandle().MaxInitLen, 392)
			if yyrt353 {
				if yyrl353 <= cap(yyv353) {
					yyv353 = yyv353[:yyrl353]
				} else {
					yyv353 = make([]ClusterRoleBinding, yyrl353)
				}
			} else {
				yyv353 = make([]ClusterRoleBinding, yyrl353)
			}
			yyc353 = true
			yyrr353 = len(yyv353)
			if yyrg353 {
				copy(yyv353, yyv2353)
			}
		} else if yyl353 != len(yyv353) {
			yyv353 = yyv353[:yyl353]
			yyc353 = true
		}
		yyj353 := 0
		for ; yyj353 < yyrr353; yyj353++ {
			yyh353.ElemContainerState(yyj353)
			if r.TryDecodeAsNil() {
				yyv353[yyj353] = ClusterRoleBinding{}
			} else {
				yyv354 := &yyv353[yyj353]
				yyv354.CodecDecodeSelf(d)
			}

		}
		if yyrt353 {
			for ; yyj353 < yyl353; yyj353++ {
				yyv353 = append(yyv353, ClusterRoleBinding{})
				yyh353.ElemContainerState(yyj353)
				if r.TryDecodeAsNil() {
					yyv353[yyj353] = ClusterRoleBinding{}
				} else {
					yyv355 := &yyv353[yyj353]
					yyv355.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj353 := 0
		for ; !r.CheckBreak(); yyj353++ {

			if yyj353 >= len(yyv353) {
				yyv353 = append(yyv353, ClusterRoleBinding{}) // var yyz353 ClusterRoleBinding
				yyc353 = true
			}
			yyh353.ElemContainerState(yyj353)
			if yyj353 < len(yyv353) {
				if r.TryDecodeAsNil() {
					yyv353[yyj353] = ClusterRoleBinding{}
				} else {
					yyv356 := &yyv353[yyj353]
					yyv356.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj353 < len(yyv353) {
			yyv353 = yyv353[:yyj353]
			yyc353 = true
		} else if yyj353 == 0 && yyv353 == nil {
			yyv353 = []ClusterRoleBinding{}
			yyc353 = true
		}
	}
	yyh353.End()
	if yyc353 {
		*v = yyv353
	}
}

func (x codecSelfer1234) encSliceClusterRole(v []ClusterRole, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv357 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy358 := &yyv357
		yy358.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterRole(v *[]ClusterRole, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv359 := *v
	yyh359, yyl359 := z.DecSliceHelperStart()
	var yyc359 bool
	if yyl359 == 0 {
		if yyv359 == nil {
			yyv359 = []ClusterRole{}
			yyc359 = true
		} else if len(yyv359) != 0 {
			yyv359 = yyv359[:0]
			yyc359 = true
		}
	} else if yyl359 > 0 {
		var yyrr359, yyrl359 int
		var yyrt359 bool
		if yyl359 > cap(yyv359) {

			yyrg359 := len(yyv359) > 0
			yyv2359 := yyv359
			yyrl359, yyrt359 = z.DecInferLen(yyl359, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt359 {
				if yyrl359 <= cap(yyv359) {
					yyv359 = yyv359[:yyrl359]
				} else {
					yyv359 = make([]ClusterRole, yyrl359)
				}
			} else {
				yyv359 = make([]ClusterRole, yyrl359)
			}
			yyc359 = true
			yyrr359 = len(yyv359)
			if yyrg359 {
				copy(yyv359, yyv2359)
			}
		} else if yyl359 != len(yyv359) {
			yyv359 = yyv359[:yyl359]
			yyc359 = true
		}
		yyj359 := 0
		for ; yyj359 < yyrr359; yyj359++ {
			yyh359.ElemContainerState(yyj359)
			if r.TryDecodeAsNil() {
				yyv359[yyj359] = ClusterRole{}
			} else {
				yyv360 := &yyv359[yyj359]
				yyv360.CodecDecodeSelf(d)
			}

		}
		if yyrt359 {
			for ; yyj359 < yyl359; yyj359++ {
				yyv359 = append(yyv359, ClusterRole{})
				yyh359.ElemContainerState(yyj359)
				if r.TryDecodeAsNil() {
					yyv359[yyj359] = ClusterRole{}
				} else {
					yyv361 := &yyv359[yyj359]
					yyv361.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj359 := 0
		for ; !r.CheckBreak(); yyj359++ {

			if yyj359 >= len(yyv359) {
				yyv359 = append(yyv359, ClusterRole{}) // var yyz359 ClusterRole
				yyc359 = true
			}
			yyh359.ElemContainerState(yyj359)
			if yyj359 < len(yyv359) {
				if r.TryDecodeAsNil() {
					yyv359[yyj359] = ClusterRole{}
				} else {
					yyv362 := &yyv359[yyj359]
					yyv362.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj359 < len(yyv359) {
			yyv359 = yyv359[:yyj359]
			yyc359 = true
		} else if yyj359 == 0 && yyv359 == nil {
			yyv359 = []ClusterRole{}
			yyc359 = true
		}
	}
	yyh359.End()
	if yyc359 {
		*v = yyv359
	}
}
