package tests::ui;

use File::Basename qw/dirname/;
use Cwd qw/realpath/;

use base 'Test::Unit::TestSuite';

sub name { 'All UI Lire Unit Tests' }

sub include_tests {

    # Files containing test cases all ends in Test.pm
    my $dir =  realpath( dirname(__FILE__) );

    opendir DIR, $dir
      or die "can't opendir $dir: $!";
    my @tests = ();
    foreach my $e ( readdir DIR ) {
        next unless $e =~ /^(UI.*Test)\.pm$/;
        push @tests, "tests::$1";
    }
    closedir DIR;

    @tests;
}

1;
