/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ActionCommandBuilder.java,v 1.8 2005/10/13 07:21:29 pietschy Exp $
 */

package org.pietschy.command;

import org.w3c.dom.Element;

class
ActionCommandBuilder
extends AbstractCommandBuilder
{
   static final String _ID_ = "$Id: ActionCommandBuilder.java,v 1.8 2005/10/13 07:21:29 pietschy Exp $";

   public void configure(Command command, Element commandRoot)
   {
      populateProperties(command, commandRoot);

      Element e = (Element) Util.getFirstElement(commandRoot, Names.ACTION_COMMAND_ELEMENT);
      if (e != null)
         ((ActionCommand) command).setActionCommand(getElementText(e).trim());
      else
         ((ActionCommand) command).setActionCommand(command.getId().toString());
   }

}
