RPMBUILD ?= rpmbuild
VERSION ?= $(shell eval `grep \^PACKAGE_VERSION= configure` ; echo $$PACKAGE_VERSION)
RELEASE ?= $(shell git describe --tags | tr - .)
PACKAGE = $(shell eval `grep \^PACKAGE_NAME= configure` ; echo $$PACKAGE_NAME)
RPM_NAME_VERSION = $(PACKAGE)-$(VERSION)
TARBALL = $(RPM_NAME_VERSION).tar.xz

clean:
	rm -rf dist
	rm -rf rpmbuild

local-archive:
	-mkdir -p dist/$(RPM_NAME_VERSION)
	rsync -a --exclude=dist --exclude=.git --exclude=rpmbuild . dist/$(RPM_NAME_VERSION)

tarballs: local-archive
	-mkdir -p dist/sources
	cd dist; tar cfJ sources/$(TARBALL) $(RPM_NAME_VERSION)
	rm -rf dist/$(RPM_NAME_VERSION)

rpmroot:
	rm -rf $(RPMBUILD)
	mkdir -p $(RPMBUILD)/BUILD
	mkdir -p $(RPMBUILD)/RPMS
	mkdir -p $(RPMBUILD)/SOURCES
	mkdir -p $(RPMBUILD)/SPECS
	mkdir -p $(RPMBUILD)/SRPMS

rpmdistdir:
	mkdir -p dist/rpms

srpmdistdir:
	mkdir -p dist/srpms

rpmbuildprep:
	cp dist/sources/$(TARBALL) $(RPMBUILD)/SOURCES/

srpms: rpmroot srpmdistdir tarballs rpmbuildprep
	rpmbuild --define "_topdir $(RPMBUILD)" --define "dist .$(RELEASE)" -bs $(PACKAGE).spec
	cp $(RPMBUILD)/SRPMS/$(RPM_NAME_VERSION)-*.src.rpm dist/srpms/
	rm -rf $(RPMBUILD)
