/*
 * Copyright 2003-2007 Keith Seymour.
 * Copyright 1992-2007 The University of Tennessee. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer listed
 *   in this license in the documentation and/or other materials
 *   provided with the distribution.
 * 
 * - Neither the name of the copyright holders nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This file was auto-generated by the org.netlib.generate.JavaGenerator
 * program, a part of netlib-java.
 * 
 * @see http://code.google.com/p/netlib-java/
 */
package org.netlib.lapack;

import java.util.logging.Logger;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

/**
 * LAPACK provider implementation which uses F2J.
 *
 * @see http://sourceforge.net/projects/f2j
 * @author Samuel Halliday
 */
final class JLAPACK extends LAPACK {

	static final LAPACK INSTANCE = new JLAPACK();

	private JLAPACK() {
	}

	@Override
	public void dbdsdc(String uplo, String compq, int n, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, double[] q, int[] iq, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dbdsdc.dbdsdc(uplo, compq, n, d, 0, e, 0, u, 0, ldu, vt, 0, ldvt, q, 0, iq, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dbdsqr(String uplo, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dbdsqr.dbdsqr(uplo, n, ncvt, nru, ncc, d, 0, e, 0, vt, 0, ldvt, u, 0, ldu, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void ddisna(String job, int m, int n, double[] d, double[] sep, intW info) {
		org.netlib.lapack.Ddisna.ddisna(job, m, n, d, 0, sep, 0, info);
	}

	@Override
	public void dgbbrd(String vect, int m, int n, int ncc, int kl, int ku, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] pt, int ldpt, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dgbbrd.dgbbrd(vect, m, n, ncc, kl, ku, ab, 0, ldab, d, 0, e, 0, q, 0, ldq, pt, 0, ldpt, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dgbcon(String norm, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgbcon.dgbcon(norm, n, kl, ku, ab, 0, ldab, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dgbequ(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info) {
		org.netlib.lapack.Dgbequ.dgbequ(m, n, kl, ku, ab, 0, ldab, r, 0, c, 0, rowcnd, colcnd, amax, info);
	}

	@Override
	public void dgbrfs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgbrfs.dgbrfs(trans, n, kl, ku, nrhs, ab, 0, ldab, afb, 0, ldafb, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgbsv(int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgbsv.dgbsv(n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dgbsvx(String fact, String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgbsvx.dgbsvx(fact, trans, n, kl, ku, nrhs, ab, 0, ldab, afb, 0, ldafb, ipiv, 0, equed, r, 0, c, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgbtf2(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info) {
		org.netlib.lapack.Dgbtf2.dgbtf2(m, n, kl, ku, ab, 0, ldab, ipiv, 0, info);
	}

	@Override
	public void dgbtrf(int m, int n, int kl, int ku, double[] ab, int ldab, int[] ipiv, intW info) {
		org.netlib.lapack.Dgbtrf.dgbtrf(m, n, kl, ku, ab, 0, ldab, ipiv, 0, info);
	}

	@Override
	public void dgbtrs(String trans, int n, int kl, int ku, int nrhs, double[] ab, int ldab, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgbtrs.dgbtrs(trans, n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dgebak(String job, String side, int n, int ilo, int ihi, double[] scale, int m, double[] v, int ldv, intW info) {
		org.netlib.lapack.Dgebak.dgebak(job, side, n, ilo, ihi, scale, 0, m, v, 0, ldv, info);
	}

	@Override
	public void dgebal(String job, int n, double[] a, int lda, intW ilo, intW ihi, double[] scale, intW info) {
		org.netlib.lapack.Dgebal.dgebal(job, n, a, 0, lda, ilo, ihi, scale, 0, info);
	}

	@Override
	public void dgebd2(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, intW info) {
		org.netlib.lapack.Dgebd2.dgebd2(m, n, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, work, 0, info);
	}

	@Override
	public void dgebrd(int m, int n, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgebrd.dgebrd(m, n, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, work, 0, lwork, info);
	}

	@Override
	public void dgecon(String norm, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgecon.dgecon(norm, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dgeequ(int m, int n, double[] a, int lda, double[] r, double[] c, doubleW rowcnd, doubleW colcnd, doubleW amax, intW info) {
		org.netlib.lapack.Dgeequ.dgeequ(m, n, a, 0, lda, r, 0, c, 0, rowcnd, colcnd, amax, info);
	}

	@Override
	public void dgeev(String jobvl, String jobvr, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgeev.dgeev(jobvl, jobvr, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void dgeevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] scale, doubleW abnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dgeevx.dgeevx(balanc, jobvl, jobvr, sense, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, ilo, ihi, scale, 0, abnrm, rconde, 0, rcondv, 0, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dgegs(String jobvsl, String jobvsr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vsl, int ldvsl, double[] vsr, int ldvsr, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgegs.dgegs(jobvsl, jobvsr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vsl, 0, ldvsl, vsr, 0, ldvsr, work, 0, lwork, info);
	}

	@Override
	public void dgegv(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgegv.dgegv(jobvl, jobvr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void dgehd2(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgehd2.dgehd2(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dgehrd(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgehrd.dgehrd(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgelq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgelq2.dgelq2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dgelqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgelqf.dgelqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgels(String trans, int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgels.dgels(trans, m, n, nrhs, a, 0, lda, b, 0, ldb, work, 0, lwork, info);
	}

	@Override
	public void dgelsd(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dgelsd.dgelsd(m, n, nrhs, a, 0, lda, b, 0, ldb, s, 0, rcond, rank, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dgelss(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] s, double rcond, intW rank, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgelss.dgelss(m, n, nrhs, a, 0, lda, b, 0, ldb, s, 0, rcond, rank, work, 0, lwork, info);
	}

	@Override
	public void dgelsx(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, intW info) {
		org.netlib.lapack.Dgelsx.dgelsx(m, n, nrhs, a, 0, lda, b, 0, ldb, jpvt, 0, rcond, rank, work, 0, info);
	}

	@Override
	public void dgelsy(int m, int n, int nrhs, double[] a, int lda, double[] b, int ldb, int[] jpvt, double rcond, intW rank, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgelsy.dgelsy(m, n, nrhs, a, 0, lda, b, 0, ldb, jpvt, 0, rcond, rank, work, 0, lwork, info);
	}

	@Override
	public void dgeql2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgeql2.dgeql2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dgeqlf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgeqlf.dgeqlf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgeqp3(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgeqp3.dgeqp3(m, n, a, 0, lda, jpvt, 0, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgeqpf(int m, int n, double[] a, int lda, int[] jpvt, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgeqpf.dgeqpf(m, n, a, 0, lda, jpvt, 0, tau, 0, work, 0, info);
	}

	@Override
	public void dgeqr2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgeqr2.dgeqr2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dgeqrf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgeqrf.dgeqrf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgerfs(String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgerfs.dgerfs(trans, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgerq2(int m, int n, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dgerq2.dgerq2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dgerqf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgerqf.dgerqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dgesc2(int n, double[] a, int lda, double[] rhs, int[] ipiv, int[] jpiv, doubleW scale) {
		org.netlib.lapack.Dgesc2.dgesc2(n, a, 0, lda, rhs, 0, ipiv, 0, jpiv, 0, scale);
	}

	@Override
	public void dgesdd(String jobz, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dgesdd.dgesdd(jobz, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dgesv(int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgesv.dgesv(n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dgesvd(String jobu, String jobvt, int m, int n, double[] a, int lda, double[] s, double[] u, int ldu, double[] vt, int ldvt, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgesvd.dgesvd(jobu, jobvt, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, info);
	}

	@Override
	public void dgesvx(String fact, String trans, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, StringW equed, double[] r, double[] c, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgesvx.dgesvx(fact, trans, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, equed, r, 0, c, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgetc2(int n, double[] a, int lda, int[] ipiv, int[] jpiv, intW info) {
		org.netlib.lapack.Dgetc2.dgetc2(n, a, 0, lda, ipiv, 0, jpiv, 0, info);
	}

	@Override
	public void dgetf2(int m, int n, double[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Dgetf2.dgetf2(m, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void dgetrf(int m, int n, double[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Dgetrf.dgetrf(m, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void dgetri(int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgetri.dgetri(n, a, 0, lda, ipiv, 0, work, 0, lwork, info);
	}

	@Override
	public void dgetrs(String trans, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgetrs.dgetrs(trans, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dggbak(String job, String side, int n, int ilo, int ihi, double[] lscale, double[] rscale, int m, double[] v, int ldv, intW info) {
		org.netlib.lapack.Dggbak.dggbak(job, side, n, ilo, ihi, lscale, 0, rscale, 0, m, v, 0, ldv, info);
	}

	@Override
	public void dggbal(String job, int n, double[] a, int lda, double[] b, int ldb, intW ilo, intW ihi, double[] lscale, double[] rscale, double[] work, intW info) {
		org.netlib.lapack.Dggbal.dggbal(job, n, a, 0, lda, b, 0, ldb, ilo, ihi, lscale, 0, rscale, 0, work, 0, info);
	}

	@Override
	public void dggev(String jobvl, String jobvr, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dggev.dggev(jobvl, jobvr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void dggevx(String balanc, String jobvl, String jobvr, String sense, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] vl, int ldvl, double[] vr, int ldvr, intW ilo, intW ihi, double[] lscale, double[] rscale, doubleW abnrm, doubleW bbnrm, double[] rconde, double[] rcondv, double[] work, int lwork, int[] iwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Dggevx.dggevx(balanc, jobvl, jobvr, sense, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, ilo, ihi, lscale, 0, rscale, 0, abnrm, bbnrm, rconde, 0, rcondv, 0, work, 0, lwork, iwork, 0, bwork, 0, info);
	}

	@Override
	public void dggglm(int n, int m, int p, double[] a, int lda, double[] b, int ldb, double[] d, double[] x, double[] y, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dggglm.dggglm(n, m, p, a, 0, lda, b, 0, ldb, d, 0, x, 0, y, 0, work, 0, lwork, info);
	}

	@Override
	public void dgghrd(String compq, String compz, int n, int ilo, int ihi, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, intW info) {
		org.netlib.lapack.Dgghrd.dgghrd(compq, compz, n, ilo, ihi, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, info);
	}

	@Override
	public void dgglse(int m, int n, int p, double[] a, int lda, double[] b, int ldb, double[] c, double[] d, double[] x, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dgglse.dgglse(m, n, p, a, 0, lda, b, 0, ldb, c, 0, d, 0, x, 0, work, 0, lwork, info);
	}

	@Override
	public void dggqrf(int n, int m, int p, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dggqrf.dggqrf(n, m, p, a, 0, lda, taua, 0, b, 0, ldb, taub, 0, work, 0, lwork, info);
	}

	@Override
	public void dggrqf(int m, int p, int n, double[] a, int lda, double[] taua, double[] b, int ldb, double[] taub, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dggrqf.dggrqf(m, p, n, a, 0, lda, taua, 0, b, 0, ldb, taub, 0, work, 0, lwork, info);
	}

	@Override
	public void dggsvd(String jobu, String jobv, String jobq, int m, int n, int p, intW k, intW l, double[] a, int lda, double[] b, int ldb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dggsvd.dggsvd(jobu, jobv, jobq, m, n, p, k, l, a, 0, lda, b, 0, ldb, alpha, 0, beta, 0, u, 0, ldu, v, 0, ldv, q, 0, ldq, work, 0, iwork, 0, info);
	}

	@Override
	public void dggsvp(String jobu, String jobv, String jobq, int m, int p, int n, double[] a, int lda, double[] b, int ldb, double tola, double tolb, intW k, intW l, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, int[] iwork, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dggsvp.dggsvp(jobu, jobv, jobq, m, p, n, a, 0, lda, b, 0, ldb, tola, tolb, k, l, u, 0, ldu, v, 0, ldv, q, 0, ldq, iwork, 0, tau, 0, work, 0, info);
	}

	@Override
	public void dgtcon(String norm, int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgtcon.dgtcon(norm, n, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dgtrfs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgtrfs.dgtrfs(trans, n, nrhs, dl, 0, d, 0, du, 0, dlf, 0, df, 0, duf, 0, du2, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgtsv(int n, int nrhs, double[] dl, double[] d, double[] du, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgtsv.dgtsv(n, nrhs, dl, 0, d, 0, du, 0, b, 0, ldb, info);
	}

	@Override
	public void dgtsvx(String fact, String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] dlf, double[] df, double[] duf, double[] du2, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dgtsvx.dgtsvx(fact, trans, n, nrhs, dl, 0, d, 0, du, 0, dlf, 0, df, 0, duf, 0, du2, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dgttrf(int n, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, intW info) {
		org.netlib.lapack.Dgttrf.dgttrf(n, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, info);
	}

	@Override
	public void dgttrs(String trans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dgttrs.dgttrs(trans, n, nrhs, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dgtts2(int itrans, int n, int nrhs, double[] dl, double[] d, double[] du, double[] du2, int[] ipiv, double[] b, int ldb) {
		org.netlib.lapack.Dgtts2.dgtts2(itrans, n, nrhs, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, b, 0, ldb);
	}

	@Override
	public void dhgeqz(String job, String compq, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] t, int ldt, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dhgeqz.dhgeqz(job, compq, compz, n, ilo, ihi, h, 0, ldh, t, 0, ldt, alphar, 0, alphai, 0, beta, 0, q, 0, ldq, z, 0, ldz, work, 0, lwork, info);
	}

	@Override
	public void dhsein(String side, String eigsrc, String initv, boolean[] select, int n, double[] h, int ldh, double[] wr, double[] wi, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, int[] ifaill, int[] ifailr, intW info) {
		org.netlib.lapack.Dhsein.dhsein(side, eigsrc, initv, select, 0, n, h, 0, ldh, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, ifaill, 0, ifailr, 0, info);
	}

	@Override
	public void dhseqr(String job, String compz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, double[] z, int ldz, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dhseqr.dhseqr(job, compz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, z, 0, ldz, work, 0, lwork, info);
	}

	@Override
	public void dlabad(doubleW small, doubleW large) {
		org.netlib.lapack.Dlabad.dlabad(small, large);
	}

	@Override
	public void dlabrd(int m, int n, int nb, double[] a, int lda, double[] d, double[] e, double[] tauq, double[] taup, double[] x, int ldx, double[] y, int ldy) {
		org.netlib.lapack.Dlabrd.dlabrd(m, n, nb, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, x, 0, ldx, y, 0, ldy);
	}

	@Override
	public void dlacon(int n, double[] v, double[] x, int[] isgn, doubleW est, intW kase) {
		org.netlib.lapack.Dlacon.dlacon(n, v, 0, x, 0, isgn, 0, est, kase);
	}

	@Override
	public void dlacpy(String uplo, int m, int n, double[] a, int lda, double[] b, int ldb) {
		org.netlib.lapack.Dlacpy.dlacpy(uplo, m, n, a, 0, lda, b, 0, ldb);
	}

	@Override
	public void dladiv(double a, double b, double c, double d, doubleW p, doubleW q) {
		org.netlib.lapack.Dladiv.dladiv(a, b, c, d, p, q);
	}

	@Override
	public void dlae2(double a, double b, double c, doubleW rt1, doubleW rt2) {
		org.netlib.lapack.Dlae2.dlae2(a, b, c, rt1, rt2);
	}

	@Override
	public void dlaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, double abstol, double reltol, double pivmin, double[] d, double[] e, double[] e2, int[] nval, double[] ab, double[] c, intW mout, int[] nab, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlaebz.dlaebz(ijob, nitmax, n, mmax, minp, nbmin, abstol, reltol, pivmin, d, 0, e, 0, e2, 0, nval, 0, ab, 0, c, 0, mout, nab, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dlaed0(int icompq, int qsiz, int n, double[] d, double[] e, double[] q, int ldq, double[] qstore, int ldqs, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlaed0.dlaed0(icompq, qsiz, n, d, 0, e, 0, q, 0, ldq, qstore, 0, ldqs, work, 0, iwork, 0, info);
	}

	@Override
	public void dlaed1(int n, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlaed1.dlaed1(n, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, work, 0, iwork, 0, info);
	}

	@Override
	public void dlaed2(intW k, int n, int n1, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, double[] z, double[] dlamda, double[] w, double[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, intW info) {
		org.netlib.lapack.Dlaed2.dlaed2(k, n, n1, d, 0, q, 0, ldq, indxq, 0, rho, z, 0, dlamda, 0, w, 0, q2, 0, indx, 0, indxc, 0, indxp, 0, coltyp, 0, info);
	}

	@Override
	public void dlaed3(int k, int n, int n1, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] q2, int[] indx, int[] ctot, double[] w, double[] s, intW info) {
		org.netlib.lapack.Dlaed3.dlaed3(k, n, n1, d, 0, q, 0, ldq, rho, dlamda, 0, q2, 0, indx, 0, ctot, 0, w, 0, s, 0, info);
	}

	@Override
	public void dlaed4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam, intW info) {
		org.netlib.lapack.Dlaed4.dlaed4(n, i, d, 0, z, 0, delta, 0, rho, dlam, info);
	}

	@Override
	public void dlaed5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dlam) {
		org.netlib.lapack.Dlaed5.dlaed5(i, d, 0, z, 0, delta, 0, rho, dlam);
	}

	@Override
	public void dlaed6(int kniter, boolean orgati, double rho, double[] d, double[] z, double finit, doubleW tau, intW info) {
		org.netlib.lapack.Dlaed6.dlaed6(kniter, orgati, rho, d, 0, z, 0, finit, tau, info);
	}

	@Override
	public void dlaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlaed7.dlaed7(icompq, n, qsiz, tlvls, curlvl, curpbm, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, qstore, 0, qptr, 0, prmptr, 0, perm, 0, givptr, 0, givcol, 0, givnum, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dlaed8(int icompq, intW k, int n, int qsiz, double[] d, double[] q, int ldq, int[] indxq, doubleW rho, int cutpnt, double[] z, double[] dlamda, double[] q2, int ldq2, double[] w, int[] perm, intW givptr, int[] givcol, double[] givnum, int[] indxp, int[] indx, intW info) {
		org.netlib.lapack.Dlaed8.dlaed8(icompq, k, n, qsiz, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, z, 0, dlamda, 0, q2, 0, ldq2, w, 0, perm, 0, givptr, givcol, 0, givnum, 0, indxp, 0, indx, 0, info);
	}

	@Override
	public void dlaed9(int k, int kstart, int kstop, int n, double[] d, double[] q, int ldq, double rho, double[] dlamda, double[] w, double[] s, int lds, intW info) {
		org.netlib.lapack.Dlaed9.dlaed9(k, kstart, kstop, n, d, 0, q, 0, ldq, rho, dlamda, 0, w, 0, s, 0, lds, info);
	}

	@Override
	public void dlaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, double[] givnum, double[] q, int[] qptr, double[] z, double[] ztemp, intW info) {
		org.netlib.lapack.Dlaeda.dlaeda(n, tlvls, curlvl, curpbm, prmptr, 0, perm, 0, givptr, 0, givcol, 0, givnum, 0, q, 0, qptr, 0, z, 0, ztemp, 0, info);
	}

	@Override
	public void dlaein(boolean rightv, boolean noinit, int n, double[] h, int ldh, double wr, double wi, double[] vr, double[] vi, double[] b, int ldb, double[] work, double eps3, double smlnum, double bignum, intW info) {
		org.netlib.lapack.Dlaein.dlaein(rightv, noinit, n, h, 0, ldh, wr, wi, vr, 0, vi, 0, b, 0, ldb, work, 0, eps3, smlnum, bignum, info);
	}

	@Override
	public void dlaev2(double a, double b, double c, doubleW rt1, doubleW rt2, doubleW cs1, doubleW sn1) {
		org.netlib.lapack.Dlaev2.dlaev2(a, b, c, rt1, rt2, cs1, sn1);
	}

	@Override
	public void dlaexc(boolean wantq, int n, double[] t, int ldt, double[] q, int ldq, int j1, int n1, int n2, double[] work, intW info) {
		org.netlib.lapack.Dlaexc.dlaexc(wantq, n, t, 0, ldt, q, 0, ldq, j1, n1, n2, work, 0, info);
	}

	@Override
	public void dlag2(double[] a, int lda, double[] b, int ldb, double safmin, doubleW scale1, doubleW scale2, doubleW wr1, doubleW wr2, doubleW wi) {
		org.netlib.lapack.Dlag2.dlag2(a, 0, lda, b, 0, ldb, safmin, scale1, scale2, wr1, wr2, wi);
	}

	@Override
	public void dlags2(boolean upper, double a1, double a2, double a3, double b1, double b2, double b3, doubleW csu, doubleW snu, doubleW csv, doubleW snv, doubleW csq, doubleW snq) {
		org.netlib.lapack.Dlags2.dlags2(upper, a1, a2, a3, b1, b2, b3, csu, snu, csv, snv, csq, snq);
	}

	@Override
	public void dlagtf(int n, double[] a, double lambda, double[] b, double[] c, double tol, double[] d, int[] in, intW info) {
		org.netlib.lapack.Dlagtf.dlagtf(n, a, 0, lambda, b, 0, c, 0, tol, d, 0, in, 0, info);
	}

	@Override
	public void dlagtm(String trans, int n, int nrhs, double alpha, double[] dl, double[] d, double[] du, double[] x, int ldx, double beta, double[] b, int ldb) {
		org.netlib.lapack.Dlagtm.dlagtm(trans, n, nrhs, alpha, dl, 0, d, 0, du, 0, x, 0, ldx, beta, b, 0, ldb);
	}

	@Override
	public void dlagts(int job, int n, double[] a, double[] b, double[] c, double[] d, int[] in, double[] y, doubleW tol, intW info) {
		org.netlib.lapack.Dlagts.dlagts(job, n, a, 0, b, 0, c, 0, d, 0, in, 0, y, 0, tol, info);
	}

	@Override
	public void dlagv2(double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, doubleW csl, doubleW snl, doubleW csr, doubleW snr) {
		org.netlib.lapack.Dlagv2.dlagv2(a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, csl, snl, csr, snr);
	}

	@Override
	public void dlahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, double[] h, int ldh, double[] wr, double[] wi, int iloz, int ihiz, double[] z, int ldz, intW info) {
		org.netlib.lapack.Dlahqr.dlahqr(wantt, wantz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, iloz, ihiz, z, 0, ldz, info);
	}

	@Override
	public void dlahrd(int n, int k, int nb, double[] a, int lda, double[] tau, double[] t, int ldt, double[] y, int ldy) {
		org.netlib.lapack.Dlahrd.dlahrd(n, k, nb, a, 0, lda, tau, 0, t, 0, ldt, y, 0, ldy);
	}

	@Override
	public void dlaic1(int job, int j, double[] x, double sest, double[] w, double gamma, doubleW sestpr, doubleW s, doubleW c) {
		org.netlib.lapack.Dlaic1.dlaic1(job, j, x, 0, sest, w, 0, gamma, sestpr, s, c);
	}

	@Override
	public void dlaln2(boolean ltrans, int na, int nw, double smin, double ca, double[] a, int lda, double d1, double d2, double[] b, int ldb, double wr, double wi, double[] x, int ldx, doubleW scale, doubleW xnorm, intW info) {
		org.netlib.lapack.Dlaln2.dlaln2(ltrans, na, nw, smin, ca, a, 0, lda, d1, d2, b, 0, ldb, wr, wi, x, 0, ldx, scale, xnorm, info);
	}

	@Override
	public void dlals0(int icompq, int nl, int nr, int sqre, int nrhs, double[] b, int ldb, double[] bx, int ldbx, int[] perm, int givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, int k, double c, double s, double[] work, intW info) {
		org.netlib.lapack.Dlals0.dlals0(icompq, nl, nr, sqre, nrhs, b, 0, ldb, bx, 0, ldbx, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, poles, 0, difl, 0, difr, 0, z, 0, k, c, s, work, 0, info);
	}

	@Override
	public void dlalsa(int icompq, int smlsiz, int n, int nrhs, double[] b, int ldb, double[] bx, int ldbx, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlalsa.dlalsa(icompq, smlsiz, n, nrhs, b, 0, ldb, bx, 0, ldbx, u, 0, ldu, vt, 0, k, 0, difl, 0, difr, 0, z, 0, poles, 0, givptr, 0, givcol, 0, ldgcol, perm, 0, givnum, 0, c, 0, s, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dlalsd(String uplo, int smlsiz, int n, int nrhs, double[] d, double[] e, double[] b, int ldb, double rcond, intW rank, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlalsd.dlalsd(uplo, smlsiz, n, nrhs, d, 0, e, 0, b, 0, ldb, rcond, rank, work, 0, iwork, 0, info);
	}

	@Override
	public void dlamrg(int n1, int n2, double[] a, int dtrd1, int dtrd2, int[] index) {
		org.netlib.lapack.Dlamrg.dlamrg(n1, n2, a, 0, dtrd1, dtrd2, index, 0);
	}

	@Override
	public void dlanv2(doubleW a, doubleW b, doubleW c, doubleW d, doubleW rt1r, doubleW rt1i, doubleW rt2r, doubleW rt2i, doubleW cs, doubleW sn) {
		org.netlib.lapack.Dlanv2.dlanv2(a, b, c, d, rt1r, rt1i, rt2r, rt2i, cs, sn);
	}

	@Override
	public void dlapll(int n, double[] x, int incx, double[] y, int incy, doubleW ssmin) {
		org.netlib.lapack.Dlapll.dlapll(n, x, 0, incx, y, 0, incy, ssmin);
	}

	@Override
	public void dlapmt(boolean forwrd, int m, int n, double[] x, int ldx, int[] k) {
		org.netlib.lapack.Dlapmt.dlapmt(forwrd, m, n, x, 0, ldx, k, 0);
	}

	@Override
	public void dlaqgb(int m, int n, int kl, int ku, double[] ab, int ldab, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed) {
		org.netlib.lapack.Dlaqgb.dlaqgb(m, n, kl, ku, ab, 0, ldab, r, 0, c, 0, rowcnd, colcnd, amax, equed);
	}

	@Override
	public void dlaqge(int m, int n, double[] a, int lda, double[] r, double[] c, double rowcnd, double colcnd, double amax, StringW equed) {
		org.netlib.lapack.Dlaqge.dlaqge(m, n, a, 0, lda, r, 0, c, 0, rowcnd, colcnd, amax, equed);
	}

	@Override
	public void dlaqp2(int m, int n, int offset, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] work) {
		org.netlib.lapack.Dlaqp2.dlaqp2(m, n, offset, a, 0, lda, jpvt, 0, tau, 0, vn1, 0, vn2, 0, work, 0);
	}

	@Override
	public void dlaqps(int m, int n, int offset, int nb, intW kb, double[] a, int lda, int[] jpvt, double[] tau, double[] vn1, double[] vn2, double[] auxv, double[] f, int ldf) {
		org.netlib.lapack.Dlaqps.dlaqps(m, n, offset, nb, kb, a, 0, lda, jpvt, 0, tau, 0, vn1, 0, vn2, 0, auxv, 0, f, 0, ldf);
	}

	@Override
	public void dlaqsb(String uplo, int n, int kd, double[] ab, int ldab, double[] s, double scond, double amax, StringW equed) {
		org.netlib.lapack.Dlaqsb.dlaqsb(uplo, n, kd, ab, 0, ldab, s, 0, scond, amax, equed);
	}

	@Override
	public void dlaqsp(String uplo, int n, double[] ap, double[] s, double scond, double amax, StringW equed) {
		org.netlib.lapack.Dlaqsp.dlaqsp(uplo, n, ap, 0, s, 0, scond, amax, equed);
	}

	@Override
	public void dlaqsy(String uplo, int n, double[] a, int lda, double[] s, double scond, double amax, StringW equed) {
		org.netlib.lapack.Dlaqsy.dlaqsy(uplo, n, a, 0, lda, s, 0, scond, amax, equed);
	}

	@Override
	public void dlaqtr(boolean ltran, boolean lreal, int n, double[] t, int ldt, double[] b, double w, doubleW scale, double[] x, double[] work, intW info) {
		org.netlib.lapack.Dlaqtr.dlaqtr(ltran, lreal, n, t, 0, ldt, b, 0, w, scale, x, 0, work, 0, info);
	}

	@Override
	public void dlar2v(int n, double[] x, double[] y, double[] z, int incx, double[] c, double[] s, int incc) {
		org.netlib.lapack.Dlar2v.dlar2v(n, x, 0, y, 0, z, 0, incx, c, 0, s, 0, incc);
	}

	@Override
	public void dlarf(String side, int m, int n, double[] v, int incv, double tau, double[] c, int Ldc, double[] work) {
		org.netlib.lapack.Dlarf.dlarf(side, m, n, v, 0, incv, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void dlarfb(String side, String trans, String direct, String storev, int m, int n, int k, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork) {
		org.netlib.lapack.Dlarfb.dlarfb(side, trans, direct, storev, m, n, k, v, 0, ldv, t, 0, ldt, c, 0, Ldc, work, 0, ldwork);
	}

	@Override
	public void dlarfg(int n, doubleW alpha, double[] x, int incx, doubleW tau) {
		org.netlib.lapack.Dlarfg.dlarfg(n, alpha, x, 0, incx, tau);
	}

	@Override
	public void dlarft(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt) {
		org.netlib.lapack.Dlarft.dlarft(direct, storev, n, k, v, 0, ldv, tau, 0, t, 0, ldt);
	}

	@Override
	public void dlarfx(String side, int m, int n, double[] v, double tau, double[] c, int Ldc, double[] work) {
		org.netlib.lapack.Dlarfx.dlarfx(side, m, n, v, 0, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void dlargv(int n, double[] x, int incx, double[] y, int incy, double[] c, int incc) {
		org.netlib.lapack.Dlargv.dlargv(n, x, 0, incx, y, 0, incy, c, 0, incc);
	}

	@Override
	public void dlarnv(int idist, int[] iseed, int n, double[] x) {
		org.netlib.lapack.Dlarnv.dlarnv(idist, iseed, 0, n, x, 0);
	}

	@Override
	public void dlartg(double f, double g, doubleW cs, doubleW sn, doubleW r) {
		org.netlib.lapack.Dlartg.dlartg(f, g, cs, sn, r);
	}

	@Override
	public void dlartv(int n, double[] x, int incx, double[] y, int incy, double[] c, double[] s, int incc) {
		org.netlib.lapack.Dlartv.dlartv(n, x, 0, incx, y, 0, incy, c, 0, s, 0, incc);
	}

	@Override
	public void dlaruv(int[] iseed, int n, double[] x) {
		org.netlib.lapack.Dlaruv.dlaruv(iseed, 0, n, x, 0);
	}

	@Override
	public void dlarz(String side, int m, int n, int l, double[] v, int incv, double tau, double[] c, int Ldc, double[] work) {
		org.netlib.lapack.Dlarz.dlarz(side, m, n, l, v, 0, incv, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void dlarzb(String side, String trans, String direct, String storev, int m, int n, int k, int l, double[] v, int ldv, double[] t, int ldt, double[] c, int Ldc, double[] work, int ldwork) {
		org.netlib.lapack.Dlarzb.dlarzb(side, trans, direct, storev, m, n, k, l, v, 0, ldv, t, 0, ldt, c, 0, Ldc, work, 0, ldwork);
	}

	@Override
	public void dlarzt(String direct, String storev, int n, int k, double[] v, int ldv, double[] tau, double[] t, int ldt) {
		org.netlib.lapack.Dlarzt.dlarzt(direct, storev, n, k, v, 0, ldv, tau, 0, t, 0, ldt);
	}

	@Override
	public void dlas2(double f, double g, double h, doubleW ssmin, doubleW ssmax) {
		org.netlib.lapack.Dlas2.dlas2(f, g, h, ssmin, ssmax);
	}

	@Override
	public void dlascl(String type, int kl, int ku, double cfrom, double cto, int m, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dlascl.dlascl(type, kl, ku, cfrom, cto, m, n, a, 0, lda, info);
	}

	@Override
	public void dlasd0(int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int ldvt, int smlsiz, int[] iwork, double[] work, intW info) {
		org.netlib.lapack.Dlasd0.dlasd0(n, sqre, d, 0, e, 0, u, 0, ldu, vt, 0, ldvt, smlsiz, iwork, 0, work, 0, info);
	}

	@Override
	public void dlasd1(int nl, int nr, int sqre, double[] d, doubleW alpha, doubleW beta, double[] u, int ldu, double[] vt, int ldvt, int[] idxq, int[] iwork, double[] work, intW info) {
		org.netlib.lapack.Dlasd1.dlasd1(nl, nr, sqre, d, 0, alpha, beta, u, 0, ldu, vt, 0, ldvt, idxq, 0, iwork, 0, work, 0, info);
	}

	@Override
	public void dlasd2(int nl, int nr, int sqre, intW k, double[] d, double[] z, double alpha, double beta, double[] u, int ldu, double[] vt, int ldvt, double[] dsigma, double[] u2, int ldu2, double[] vt2, int ldvt2, int[] idxp, int[] idx, int[] idxc, int[] idxq, int[] coltyp, intW info) {
		org.netlib.lapack.Dlasd2.dlasd2(nl, nr, sqre, k, d, 0, z, 0, alpha, beta, u, 0, ldu, vt, 0, ldvt, dsigma, 0, u2, 0, ldu2, vt2, 0, ldvt2, idxp, 0, idx, 0, idxc, 0, idxq, 0, coltyp, 0, info);
	}

	@Override
	public void dlasd3(int nl, int nr, int sqre, int k, double[] d, double[] q, int ldq, double[] dsigma, double[] u, int ldu, double[] u2, int ldu2, double[] vt, int ldvt, double[] vt2, int ldvt2, int[] idxc, int[] ctot, double[] z, intW info) {
		org.netlib.lapack.Dlasd3.dlasd3(nl, nr, sqre, k, d, 0, q, 0, ldq, dsigma, 0, u, 0, ldu, u2, 0, ldu2, vt, 0, ldvt, vt2, 0, ldvt2, idxc, 0, ctot, 0, z, 0, info);
	}

	@Override
	public void dlasd4(int n, int i, double[] d, double[] z, double[] delta, double rho, doubleW sigma, double[] work, intW info) {
		org.netlib.lapack.Dlasd4.dlasd4(n, i, d, 0, z, 0, delta, 0, rho, sigma, work, 0, info);
	}

	@Override
	public void dlasd5(int i, double[] d, double[] z, double[] delta, double rho, doubleW dsigma, double[] work) {
		org.netlib.lapack.Dlasd5.dlasd5(i, d, 0, z, 0, delta, 0, rho, dsigma, work, 0);
	}

	@Override
	public void dlasd6(int icompq, int nl, int nr, int sqre, double[] d, double[] vf, double[] vl, doubleW alpha, doubleW beta, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, double[] poles, double[] difl, double[] difr, double[] z, intW k, doubleW c, doubleW s, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlasd6.dlasd6(icompq, nl, nr, sqre, d, 0, vf, 0, vl, 0, alpha, beta, idxq, 0, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, poles, 0, difl, 0, difr, 0, z, 0, k, c, s, work, 0, iwork, 0, info);
	}

	@Override
	public void dlasd7(int icompq, int nl, int nr, int sqre, intW k, double[] d, double[] z, double[] zw, double[] vf, double[] vfw, double[] vl, double[] vlw, double alpha, double beta, double[] dsigma, int[] idx, int[] idxp, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, double[] givnum, int ldgnum, doubleW c, doubleW s, intW info) {
		org.netlib.lapack.Dlasd7.dlasd7(icompq, nl, nr, sqre, k, d, 0, z, 0, zw, 0, vf, 0, vfw, 0, vl, 0, vlw, 0, alpha, beta, dsigma, 0, idx, 0, idxp, 0, idxq, 0, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, c, s, info);
	}

	@Override
	public void dlasd8(int icompq, int k, double[] d, double[] z, double[] vf, double[] vl, double[] difl, double[] difr, int lddifr, double[] dsigma, double[] work, intW info) {
		org.netlib.lapack.Dlasd8.dlasd8(icompq, k, d, 0, z, 0, vf, 0, vl, 0, difl, 0, difr, 0, lddifr, dsigma, 0, work, 0, info);
	}

	@Override
	public void dlasda(int icompq, int smlsiz, int n, int sqre, double[] d, double[] e, double[] u, int ldu, double[] vt, int[] k, double[] difl, double[] difr, double[] z, double[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, double[] givnum, double[] c, double[] s, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dlasda.dlasda(icompq, smlsiz, n, sqre, d, 0, e, 0, u, 0, ldu, vt, 0, k, 0, difl, 0, difr, 0, z, 0, poles, 0, givptr, 0, givcol, 0, ldgcol, perm, 0, givnum, 0, c, 0, s, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dlasdq(String uplo, int sqre, int n, int ncvt, int nru, int ncc, double[] d, double[] e, double[] vt, int ldvt, double[] u, int ldu, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dlasdq.dlasdq(uplo, sqre, n, ncvt, nru, ncc, d, 0, e, 0, vt, 0, ldvt, u, 0, ldu, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dlasdt(int n, intW lvl, intW nd, int[] inode, int[] ndiml, int[] ndimr, int msub) {
		org.netlib.lapack.Dlasdt.dlasdt(n, lvl, nd, inode, 0, ndiml, 0, ndimr, 0, msub);
	}

	@Override
	public void dlaset(String uplo, int m, int n, double alpha, double beta, double[] a, int lda) {
		org.netlib.lapack.Dlaset.dlaset(uplo, m, n, alpha, beta, a, 0, lda);
	}

	@Override
	public void dlasq1(int n, double[] d, double[] e, double[] work, intW info) {
		org.netlib.lapack.Dlasq1.dlasq1(n, d, 0, e, 0, work, 0, info);
	}

	@Override
	public void dlasq2(int n, double[] z, intW info) {
		org.netlib.lapack.Dlasq2.dlasq2(n, z, 0, info);
	}

	@Override
	public void dlasq3(int i0, intW n0, double[] z, int pp, doubleW dmin, doubleW sigma, doubleW desig, doubleW qmax, intW nfail, intW iter, intW ndiv, boolean ieee) {
		org.netlib.lapack.Dlasq3.dlasq3(i0, n0, z, 0, pp, dmin, sigma, desig, qmax, nfail, iter, ndiv, ieee);
	}

	@Override
	public void dlasq4(int i0, int n0, double[] z, int pp, int n0in, double dmin, double dmin1, double dmin2, double dn, double dn1, double dn2, doubleW tau, intW ttype) {
		org.netlib.lapack.Dlasq4.dlasq4(i0, n0, z, 0, pp, n0in, dmin, dmin1, dmin2, dn, dn1, dn2, tau, ttype);
	}

	@Override
	public void dlasq5(int i0, int n0, double[] z, int pp, double tau, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2, boolean ieee) {
		org.netlib.lapack.Dlasq5.dlasq5(i0, n0, z, 0, pp, tau, dmin, dmin1, dmin2, dn, dnm1, dnm2, ieee);
	}

	@Override
	public void dlasq6(int i0, int n0, double[] z, int pp, doubleW dmin, doubleW dmin1, doubleW dmin2, doubleW dn, doubleW dnm1, doubleW dnm2) {
		org.netlib.lapack.Dlasq6.dlasq6(i0, n0, z, 0, pp, dmin, dmin1, dmin2, dn, dnm1, dnm2);
	}

	@Override
	public void dlasr(String side, String pivot, String direct, int m, int n, double[] c, double[] s, double[] a, int lda) {
		org.netlib.lapack.Dlasr.dlasr(side, pivot, direct, m, n, c, 0, s, 0, a, 0, lda);
	}

	@Override
	public void dlasrt(String id, int n, double[] d, intW info) {
		org.netlib.lapack.Dlasrt.dlasrt(id, n, d, 0, info);
	}

	@Override
	public void dlassq(int n, double[] x, int incx, doubleW scale, doubleW sumsq) {
		org.netlib.lapack.Dlassq.dlassq(n, x, 0, incx, scale, sumsq);
	}

	@Override
	public void dlasv2(double f, double g, double h, doubleW ssmin, doubleW ssmax, doubleW snr, doubleW csr, doubleW snl, doubleW csl) {
		org.netlib.lapack.Dlasv2.dlasv2(f, g, h, ssmin, ssmax, snr, csr, snl, csl);
	}

	@Override
	public void dlaswp(int n, double[] a, int lda, int k1, int k2, int[] ipiv, int incx) {
		org.netlib.lapack.Dlaswp.dlaswp(n, a, 0, lda, k1, k2, ipiv, 0, incx);
	}

	@Override
	public void dlasy2(boolean ltranl, boolean ltranr, int isgn, int n1, int n2, double[] tl, int ldtl, double[] tr, int ldtr, double[] b, int ldb, doubleW scale, double[] x, int ldx, doubleW xnorm, intW info) {
		org.netlib.lapack.Dlasy2.dlasy2(ltranl, ltranr, isgn, n1, n2, tl, 0, ldtl, tr, 0, ldtr, b, 0, ldb, scale, x, 0, ldx, xnorm, info);
	}

	@Override
	public void dlasyf(String uplo, int n, int nb, intW kb, double[] a, int lda, int[] ipiv, double[] w, int ldw, intW info) {
		org.netlib.lapack.Dlasyf.dlasyf(uplo, n, nb, kb, a, 0, lda, ipiv, 0, w, 0, ldw, info);
	}

	@Override
	public void dlatbs(String uplo, String trans, String diag, String normin, int n, int kd, double[] ab, int ldab, double[] x, doubleW scale, double[] cnorm, intW info) {
		org.netlib.lapack.Dlatbs.dlatbs(uplo, trans, diag, normin, n, kd, ab, 0, ldab, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void dlatdf(int ijob, int n, double[] z, int ldz, double[] rhs, doubleW rdsum, doubleW rdscal, int[] ipiv, int[] jpiv) {
		org.netlib.lapack.Dlatdf.dlatdf(ijob, n, z, 0, ldz, rhs, 0, rdsum, rdscal, ipiv, 0, jpiv, 0);
	}

	@Override
	public void dlatps(String uplo, String trans, String diag, String normin, int n, double[] ap, double[] x, doubleW scale, double[] cnorm, intW info) {
		org.netlib.lapack.Dlatps.dlatps(uplo, trans, diag, normin, n, ap, 0, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void dlatrd(String uplo, int n, int nb, double[] a, int lda, double[] e, double[] tau, double[] w, int ldw) {
		org.netlib.lapack.Dlatrd.dlatrd(uplo, n, nb, a, 0, lda, e, 0, tau, 0, w, 0, ldw);
	}

	@Override
	public void dlatrs(String uplo, String trans, String diag, String normin, int n, double[] a, int lda, double[] x, doubleW scale, double[] cnorm, intW info) {
		org.netlib.lapack.Dlatrs.dlatrs(uplo, trans, diag, normin, n, a, 0, lda, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void dlatrz(int m, int n, int l, double[] a, int lda, double[] tau, double[] work) {
		org.netlib.lapack.Dlatrz.dlatrz(m, n, l, a, 0, lda, tau, 0, work, 0);
	}

	@Override
	public void dlatzm(String side, int m, int n, double[] v, int incv, double tau, double[] c1, double[] c2, int Ldc, double[] work) {
		org.netlib.lapack.Dlatzm.dlatzm(side, m, n, v, 0, incv, tau, c1, 0, c2, 0, Ldc, work, 0);
	}

	@Override
	public void dlauu2(String uplo, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dlauu2.dlauu2(uplo, n, a, 0, lda, info);
	}

	@Override
	public void dlauum(String uplo, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dlauum.dlauum(uplo, n, a, 0, lda, info);
	}

	@Override
	public void dopgtr(String uplo, int n, double[] ap, double[] tau, double[] q, int ldq, double[] work, intW info) {
		org.netlib.lapack.Dopgtr.dopgtr(uplo, n, ap, 0, tau, 0, q, 0, ldq, work, 0, info);
	}

	@Override
	public void dopmtr(String side, String uplo, String trans, int m, int n, double[] ap, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dopmtr.dopmtr(side, uplo, trans, m, n, ap, 0, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dorg2l(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dorg2l.dorg2l(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dorg2r(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dorg2r.dorg2r(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dorgbr(String vect, int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorgbr.dorgbr(vect, m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorghr(int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorghr.dorghr(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorgl2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dorgl2.dorgl2(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dorglq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorglq.dorglq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorgql(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorgql.dorgql(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorgqr(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorgqr.dorgqr(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorgr2(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, intW info) {
		org.netlib.lapack.Dorgr2.dorgr2(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void dorgrq(int m, int n, int k, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorgrq.dorgrq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorgtr(String uplo, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dorgtr.dorgtr(uplo, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dorm2l(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dorm2l.dorm2l(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dorm2r(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dorm2r.dorm2r(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dormbr(String vect, String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormbr.dormbr(vect, side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormhr(String side, String trans, int m, int n, int ilo, int ihi, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormhr.dormhr(side, trans, m, n, ilo, ihi, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dorml2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dorml2.dorml2(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dormlq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormlq.dormlq(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormql(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormql.dormql(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormqr(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormqr.dormqr(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormr2(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dormr2.dormr2(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dormr3(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, intW info) {
		org.netlib.lapack.Dormr3.dormr3(side, trans, m, n, k, l, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void dormrq(String side, String trans, int m, int n, int k, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormrq.dormrq(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormrz(String side, String trans, int m, int n, int k, int l, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormrz.dormrz(side, trans, m, n, k, l, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dormtr(String side, String uplo, String trans, int m, int n, double[] a, int lda, double[] tau, double[] c, int Ldc, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dormtr.dormtr(side, uplo, trans, m, n, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void dpbcon(String uplo, int n, int kd, double[] ab, int ldab, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dpbcon.dpbcon(uplo, n, kd, ab, 0, ldab, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dpbequ(String uplo, int n, int kd, double[] ab, int ldab, double[] s, doubleW scond, doubleW amax, intW info) {
		org.netlib.lapack.Dpbequ.dpbequ(uplo, n, kd, ab, 0, ldab, s, 0, scond, amax, info);
	}

	@Override
	public void dpbrfs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dpbrfs.dpbrfs(uplo, n, kd, nrhs, ab, 0, ldab, afb, 0, ldafb, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dpbstf(String uplo, int n, int kd, double[] ab, int ldab, intW info) {
		org.netlib.lapack.Dpbstf.dpbstf(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void dpbsv(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dpbsv.dpbsv(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void dpbsvx(String fact, String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] afb, int ldafb, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dpbsvx.dpbsvx(fact, uplo, n, kd, nrhs, ab, 0, ldab, afb, 0, ldafb, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dpbtf2(String uplo, int n, int kd, double[] ab, int ldab, intW info) {
		org.netlib.lapack.Dpbtf2.dpbtf2(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void dpbtrf(String uplo, int n, int kd, double[] ab, int ldab, intW info) {
		org.netlib.lapack.Dpbtrf.dpbtrf(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void dpbtrs(String uplo, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dpbtrs.dpbtrs(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void dpocon(String uplo, int n, double[] a, int lda, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dpocon.dpocon(uplo, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dpoequ(int n, double[] a, int lda, double[] s, doubleW scond, doubleW amax, intW info) {
		org.netlib.lapack.Dpoequ.dpoequ(n, a, 0, lda, s, 0, scond, amax, info);
	}

	@Override
	public void dporfs(String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dporfs.dporfs(uplo, n, nrhs, a, 0, lda, af, 0, ldaf, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dposv(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dposv.dposv(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void dposvx(String fact, String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dposvx.dposvx(fact, uplo, n, nrhs, a, 0, lda, af, 0, ldaf, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dpotf2(String uplo, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dpotf2.dpotf2(uplo, n, a, 0, lda, info);
	}

	@Override
	public void dpotrf(String uplo, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dpotrf.dpotrf(uplo, n, a, 0, lda, info);
	}

	@Override
	public void dpotri(String uplo, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dpotri.dpotri(uplo, n, a, 0, lda, info);
	}

	@Override
	public void dpotrs(String uplo, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dpotrs.dpotrs(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void dppcon(String uplo, int n, double[] ap, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dppcon.dppcon(uplo, n, ap, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dppequ(String uplo, int n, double[] ap, double[] s, doubleW scond, doubleW amax, intW info) {
		org.netlib.lapack.Dppequ.dppequ(uplo, n, ap, 0, s, 0, scond, amax, info);
	}

	@Override
	public void dpprfs(String uplo, int n, int nrhs, double[] ap, double[] afp, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dpprfs.dpprfs(uplo, n, nrhs, ap, 0, afp, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dppsv(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dppsv.dppsv(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void dppsvx(String fact, String uplo, int n, int nrhs, double[] ap, double[] afp, StringW equed, double[] s, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dppsvx.dppsvx(fact, uplo, n, nrhs, ap, 0, afp, 0, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dpptrf(String uplo, int n, double[] ap, intW info) {
		org.netlib.lapack.Dpptrf.dpptrf(uplo, n, ap, 0, info);
	}

	@Override
	public void dpptri(String uplo, int n, double[] ap, intW info) {
		org.netlib.lapack.Dpptri.dpptri(uplo, n, ap, 0, info);
	}

	@Override
	public void dpptrs(String uplo, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dpptrs.dpptrs(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void dptcon(int n, double[] d, double[] e, double anorm, doubleW rcond, double[] work, intW info) {
		org.netlib.lapack.Dptcon.dptcon(n, d, 0, e, 0, anorm, rcond, work, 0, info);
	}

	@Override
	public void dpteqr(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dpteqr.dpteqr(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dptrfs(int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, intW info) {
		org.netlib.lapack.Dptrfs.dptrfs(n, nrhs, d, 0, e, 0, df, 0, ef, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, info);
	}

	@Override
	public void dptsv(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dptsv.dptsv(n, nrhs, d, 0, e, 0, b, 0, ldb, info);
	}

	@Override
	public void dptsvx(String fact, int n, int nrhs, double[] d, double[] e, double[] df, double[] ef, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, intW info) {
		org.netlib.lapack.Dptsvx.dptsvx(fact, n, nrhs, d, 0, e, 0, df, 0, ef, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, info);
	}

	@Override
	public void dpttrf(int n, double[] d, double[] e, intW info) {
		org.netlib.lapack.Dpttrf.dpttrf(n, d, 0, e, 0, info);
	}

	@Override
	public void dpttrs(int n, int nrhs, double[] d, double[] e, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dpttrs.dpttrs(n, nrhs, d, 0, e, 0, b, 0, ldb, info);
	}

	@Override
	public void dptts2(int n, int nrhs, double[] d, double[] e, double[] b, int ldb) {
		org.netlib.lapack.Dptts2.dptts2(n, nrhs, d, 0, e, 0, b, 0, ldb);
	}

	@Override
	public void drscl(int n, double sa, double[] sx, int incx) {
		org.netlib.lapack.Drscl.drscl(n, sa, sx, 0, incx);
	}

	@Override
	public void dsbev(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dsbev.dsbev(jobz, uplo, n, kd, ab, 0, ldab, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dsbevd(String jobz, String uplo, int n, int kd, double[] ab, int ldab, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dsbevd.dsbevd(jobz, uplo, n, kd, ab, 0, ldab, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dsbevx(String jobz, String range, String uplo, int n, int kd, double[] ab, int ldab, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dsbevx.dsbevx(jobz, range, uplo, n, kd, ab, 0, ldab, q, 0, ldq, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsbgst(String vect, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] x, int ldx, double[] work, intW info) {
		org.netlib.lapack.Dsbgst.dsbgst(vect, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, x, 0, ldx, work, 0, info);
	}

	@Override
	public void dsbgv(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dsbgv.dsbgv(jobz, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dsbgvd(String jobz, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dsbgvd.dsbgvd(jobz, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dsbgvx(String jobz, String range, String uplo, int n, int ka, int kb, double[] ab, int ldab, double[] bb, int ldbb, double[] q, int ldq, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dsbgvx.dsbgvx(jobz, range, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, q, 0, ldq, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsbtrd(String vect, String uplo, int n, int kd, double[] ab, int ldab, double[] d, double[] e, double[] q, int ldq, double[] work, intW info) {
		org.netlib.lapack.Dsbtrd.dsbtrd(vect, uplo, n, kd, ab, 0, ldab, d, 0, e, 0, q, 0, ldq, work, 0, info);
	}

	@Override
	public void dspcon(String uplo, int n, double[] ap, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dspcon.dspcon(uplo, n, ap, 0, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dspev(String jobz, String uplo, int n, double[] ap, double[] w, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dspev.dspev(jobz, uplo, n, ap, 0, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dspevd(String jobz, String uplo, int n, double[] ap, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dspevd.dspevd(jobz, uplo, n, ap, 0, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dspevx(String jobz, String range, String uplo, int n, double[] ap, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dspevx.dspevx(jobz, range, uplo, n, ap, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dspgst(int itype, String uplo, int n, double[] ap, double[] bp, intW info) {
		org.netlib.lapack.Dspgst.dspgst(itype, uplo, n, ap, 0, bp, 0, info);
	}

	@Override
	public void dspgv(int itype, String jobz, String uplo, int n, double[] ap, double[] bp, double[] w, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dspgv.dspgv(itype, jobz, uplo, n, ap, 0, bp, 0, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dspgvd(int itype, String jobz, String uplo, int n, double[] ap, double[] bp, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dspgvd.dspgvd(itype, jobz, uplo, n, ap, 0, bp, 0, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dspgvx(int itype, String jobz, String range, String uplo, int n, double[] ap, double[] bp, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dspgvx.dspgvx(itype, jobz, range, uplo, n, ap, 0, bp, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsprfs(String uplo, int n, int nrhs, double[] ap, double[] afp, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dsprfs.dsprfs(uplo, n, nrhs, ap, 0, afp, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dspsv(String uplo, int n, int nrhs, double[] ap, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dspsv.dspsv(uplo, n, nrhs, ap, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dspsvx(String fact, String uplo, int n, int nrhs, double[] ap, double[] afp, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dspsvx.dspsvx(fact, uplo, n, nrhs, ap, 0, afp, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dsptrd(String uplo, int n, double[] ap, double[] d, double[] e, double[] tau, intW info) {
		org.netlib.lapack.Dsptrd.dsptrd(uplo, n, ap, 0, d, 0, e, 0, tau, 0, info);
	}

	@Override
	public void dsptrf(String uplo, int n, double[] ap, int[] ipiv, intW info) {
		org.netlib.lapack.Dsptrf.dsptrf(uplo, n, ap, 0, ipiv, 0, info);
	}

	@Override
	public void dsptri(String uplo, int n, double[] ap, int[] ipiv, double[] work, intW info) {
		org.netlib.lapack.Dsptri.dsptri(uplo, n, ap, 0, ipiv, 0, work, 0, info);
	}

	@Override
	public void dsptrs(String uplo, int n, int nrhs, double[] ap, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dsptrs.dsptrs(uplo, n, nrhs, ap, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dstebz(String range, String order, int n, double vl, double vu, int il, int iu, double abstol, double[] d, double[] e, intW m, intW nsplit, double[] w, int[] iblock, int[] isplit, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dstebz.dstebz(range, order, n, vl, vu, il, iu, abstol, d, 0, e, 0, m, nsplit, w, 0, iblock, 0, isplit, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dstedc(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dstedc.dstedc(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dstegr(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dstegr.dstegr(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dstein(int n, double[] d, double[] e, int m, double[] w, int[] iblock, int[] isplit, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dstein.dstein(n, d, 0, e, 0, m, w, 0, iblock, 0, isplit, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsteqr(String compz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dsteqr.dsteqr(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dsterf(int n, double[] d, double[] e, intW info) {
		org.netlib.lapack.Dsterf.dsterf(n, d, 0, e, 0, info);
	}

	@Override
	public void dstev(String jobz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, intW info) {
		org.netlib.lapack.Dstev.dstev(jobz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void dstevd(String jobz, int n, double[] d, double[] e, double[] z, int ldz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dstevd.dstevd(jobz, n, d, 0, e, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dstevr(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dstevr.dstevr(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dstevx(String jobz, String range, int n, double[] d, double[] e, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dstevx.dstevx(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsycon(String uplo, int n, double[] a, int lda, int[] ipiv, double anorm, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dsycon.dsycon(uplo, n, a, 0, lda, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dsyev(String jobz, String uplo, int n, double[] a, int lda, double[] w, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dsyev.dsyev(jobz, uplo, n, a, 0, lda, w, 0, work, 0, lwork, info);
	}

	@Override
	public void dsyevd(String jobz, String uplo, int n, double[] a, int lda, double[] w, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dsyevd.dsyevd(jobz, uplo, n, a, 0, lda, w, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dsyevr(String jobz, String range, String uplo, int n, double[] a, int lda, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, int[] isuppz, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dsyevr.dsyevr(jobz, range, uplo, n, a, 0, lda, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dsyevx(String jobz, String range, String uplo, int n, double[] a, int lda, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dsyevx.dsyevx(jobz, range, uplo, n, a, 0, lda, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsygs2(int itype, String uplo, int n, double[] a, int lda, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dsygs2.dsygs2(itype, uplo, n, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void dsygst(int itype, String uplo, int n, double[] a, int lda, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dsygst.dsygst(itype, uplo, n, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void dsygv(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dsygv.dsygv(itype, jobz, uplo, n, a, 0, lda, b, 0, ldb, w, 0, work, 0, lwork, info);
	}

	@Override
	public void dsygvd(int itype, String jobz, String uplo, int n, double[] a, int lda, double[] b, int ldb, double[] w, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dsygvd.dsygvd(itype, jobz, uplo, n, a, 0, lda, b, 0, ldb, w, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dsygvx(int itype, String jobz, String range, String uplo, int n, double[] a, int lda, double[] b, int ldb, double vl, double vu, int il, int iu, double abstol, intW m, double[] w, double[] z, int ldz, double[] work, int lwork, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Dsygvx.dsygvx(itype, jobz, range, uplo, n, a, 0, lda, b, 0, ldb, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, ifail, 0, info);
	}

	@Override
	public void dsyrfs(String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dsyrfs.dsyrfs(uplo, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dsysv(String uplo, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dsysv.dsysv(uplo, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, work, 0, lwork, info);
	}

	@Override
	public void dsysvx(String fact, String uplo, int n, int nrhs, double[] a, int lda, double[] af, int ldaf, int[] ipiv, double[] b, int ldb, double[] x, int ldx, doubleW rcond, double[] ferr, double[] berr, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dsysvx.dsysvx(fact, uplo, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dsytd2(String uplo, int n, double[] a, int lda, double[] d, double[] e, double[] tau, intW info) {
		org.netlib.lapack.Dsytd2.dsytd2(uplo, n, a, 0, lda, d, 0, e, 0, tau, 0, info);
	}

	@Override
	public void dsytf2(String uplo, int n, double[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Dsytf2.dsytf2(uplo, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void dsytrd(String uplo, int n, double[] a, int lda, double[] d, double[] e, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dsytrd.dsytrd(uplo, n, a, 0, lda, d, 0, e, 0, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void dsytrf(String uplo, int n, double[] a, int lda, int[] ipiv, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dsytrf.dsytrf(uplo, n, a, 0, lda, ipiv, 0, work, 0, lwork, info);
	}

	@Override
	public void dsytri(String uplo, int n, double[] a, int lda, int[] ipiv, double[] work, intW info) {
		org.netlib.lapack.Dsytri.dsytri(uplo, n, a, 0, lda, ipiv, 0, work, 0, info);
	}

	@Override
	public void dsytrs(String uplo, int n, int nrhs, double[] a, int lda, int[] ipiv, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dsytrs.dsytrs(uplo, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void dtbcon(String norm, String uplo, String diag, int n, int kd, double[] ab, int ldab, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtbcon.dtbcon(norm, uplo, diag, n, kd, ab, 0, ldab, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dtbrfs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtbrfs.dtbrfs(uplo, trans, diag, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dtbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, double[] ab, int ldab, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dtbtrs.dtbtrs(uplo, trans, diag, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void dtgevc(String side, String howmny, boolean[] select, int n, double[] s, int lds, double[] p, int ldp, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, intW info) {
		org.netlib.lapack.Dtgevc.dtgevc(side, howmny, select, 0, n, s, 0, lds, p, 0, ldp, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, info);
	}

	@Override
	public void dtgex2(boolean wantq, boolean wantz, int n, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, int j1, int n1, int n2, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dtgex2.dtgex2(wantq, wantz, n, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, j1, n1, n2, work, 0, lwork, info);
	}

	@Override
	public void dtgexc(boolean wantq, boolean wantz, int n, double[] a, int lda, double[] b, int ldb, double[] q, int ldq, double[] z, int ldz, intW ifst, intW ilst, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dtgexc.dtgexc(wantq, wantz, n, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, ifst, ilst, work, 0, lwork, info);
	}

	@Override
	public void dtgsen(int ijob, boolean wantq, boolean wantz, boolean[] select, int n, double[] a, int lda, double[] b, int ldb, double[] alphar, double[] alphai, double[] beta, double[] q, int ldq, double[] z, int ldz, intW m, doubleW pl, doubleW pr, double[] dif, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dtgsen.dtgsen(ijob, wantq, wantz, select, 0, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, q, 0, ldq, z, 0, ldz, m, pl, pr, dif, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dtgsja(String jobu, String jobv, String jobq, int m, int p, int n, int k, int l, double[] a, int lda, double[] b, int ldb, double tola, double tolb, double[] alpha, double[] beta, double[] u, int ldu, double[] v, int ldv, double[] q, int ldq, double[] work, intW ncycle, intW info) {
		org.netlib.lapack.Dtgsja.dtgsja(jobu, jobv, jobq, m, p, n, k, l, a, 0, lda, b, 0, ldb, tola, tolb, alpha, 0, beta, 0, u, 0, ldu, v, 0, ldv, q, 0, ldq, work, 0, ncycle, info);
	}

	@Override
	public void dtgsna(String job, String howmny, boolean[] select, int n, double[] a, int lda, double[] b, int ldb, double[] vl, int ldvl, double[] vr, int ldvr, double[] s, double[] dif, int mm, intW m, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dtgsna.dtgsna(job, howmny, select, 0, n, a, 0, lda, b, 0, ldb, vl, 0, ldvl, vr, 0, ldvr, s, 0, dif, 0, mm, m, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dtgsy2(String trans, int ijob, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, double[] d, int ldd, double[] e, int lde, double[] f, int ldf, doubleW scale, doubleW rdsum, doubleW rdscal, int[] iwork, intW pq, intW info) {
		org.netlib.lapack.Dtgsy2.dtgsy2(trans, ijob, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, d, 0, ldd, e, 0, lde, f, 0, ldf, scale, rdsum, rdscal, iwork, 0, pq, info);
	}

	@Override
	public void dtgsyl(String trans, int ijob, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, double[] d, int ldd, double[] e, int lde, double[] f, int ldf, doubleW scale, doubleW dif, double[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Dtgsyl.dtgsyl(trans, ijob, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, d, 0, ldd, e, 0, lde, f, 0, ldf, scale, dif, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void dtpcon(String norm, String uplo, String diag, int n, double[] ap, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtpcon.dtpcon(norm, uplo, diag, n, ap, 0, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dtprfs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtprfs.dtprfs(uplo, trans, diag, n, nrhs, ap, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dtptri(String uplo, String diag, int n, double[] ap, intW info) {
		org.netlib.lapack.Dtptri.dtptri(uplo, diag, n, ap, 0, info);
	}

	@Override
	public void dtptrs(String uplo, String trans, String diag, int n, int nrhs, double[] ap, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dtptrs.dtptrs(uplo, trans, diag, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void dtrcon(String norm, String uplo, String diag, int n, double[] a, int lda, doubleW rcond, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtrcon.dtrcon(norm, uplo, diag, n, a, 0, lda, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void dtrevc(String side, String howmny, boolean[] select, int n, double[] t, int ldt, double[] vl, int ldvl, double[] vr, int ldvr, int mm, intW m, double[] work, intW info) {
		org.netlib.lapack.Dtrevc.dtrevc(side, howmny, select, 0, n, t, 0, ldt, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, info);
	}

	@Override
	public void dtrexc(String compq, int n, double[] t, int ldt, double[] q, int ldq, intW ifst, intW ilst, double[] work, intW info) {
		org.netlib.lapack.Dtrexc.dtrexc(compq, n, t, 0, ldt, q, 0, ldq, ifst, ilst, work, 0, info);
	}

	@Override
	public void dtrrfs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int lda, double[] b, int ldb, double[] x, int ldx, double[] ferr, double[] berr, double[] work, int[] iwork, intW info) {
		org.netlib.lapack.Dtrrfs.dtrrfs(uplo, trans, diag, n, nrhs, a, 0, lda, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void dtrsen(String job, String compq, boolean[] select, int n, double[] t, int ldt, double[] q, int ldq, double[] wr, double[] wi, intW m, doubleW s, doubleW sep, double[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Dtrsen.dtrsen(job, compq, select, 0, n, t, 0, ldt, q, 0, ldq, wr, 0, wi, 0, m, s, sep, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void dtrsna(String job, String howmny, boolean[] select, int n, double[] t, int ldt, double[] vl, int ldvl, double[] vr, int ldvr, double[] s, double[] sep, int mm, intW m, double[] work, int ldwork, int[] iwork, intW info) {
		org.netlib.lapack.Dtrsna.dtrsna(job, howmny, select, 0, n, t, 0, ldt, vl, 0, ldvl, vr, 0, ldvr, s, 0, sep, 0, mm, m, work, 0, ldwork, iwork, 0, info);
	}

	@Override
	public void dtrsyl(String trana, String tranb, int isgn, int m, int n, double[] a, int lda, double[] b, int ldb, double[] c, int Ldc, doubleW scale, intW info) {
		org.netlib.lapack.Dtrsyl.dtrsyl(trana, tranb, isgn, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, scale, info);
	}

	@Override
	public void dtrti2(String uplo, String diag, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dtrti2.dtrti2(uplo, diag, n, a, 0, lda, info);
	}

	@Override
	public void dtrtri(String uplo, String diag, int n, double[] a, int lda, intW info) {
		org.netlib.lapack.Dtrtri.dtrtri(uplo, diag, n, a, 0, lda, info);
	}

	@Override
	public void dtrtrs(String uplo, String trans, String diag, int n, int nrhs, double[] a, int lda, double[] b, int ldb, intW info) {
		org.netlib.lapack.Dtrtrs.dtrtrs(uplo, trans, diag, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void dtzrqf(int m, int n, double[] a, int lda, double[] tau, intW info) {
		org.netlib.lapack.Dtzrqf.dtzrqf(m, n, a, 0, lda, tau, 0, info);
	}

	@Override
	public void dtzrzf(int m, int n, double[] a, int lda, double[] tau, double[] work, int lwork, intW info) {
		org.netlib.lapack.Dtzrzf.dtzrzf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public int ieeeck(int ispec, float zero, float one) {
		return org.netlib.lapack.Ieeeck.ieeeck(ispec, zero, one);
	}

	@Override
	public int ilaenv(int ispec, String name, String opts, int n1, int n2, int n3, int n4) {
		return org.netlib.lapack.Ilaenv.ilaenv(ispec, name, opts, n1, n2, n3, n4);
	}

	@Override
	public void sbdsdc(String uplo, String compq, int n, float[] d, float[] e, float[] u, int ldu, float[] vt, int ldvt, float[] q, int[] iq, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sbdsdc.sbdsdc(uplo, compq, n, d, 0, e, 0, u, 0, ldu, vt, 0, ldvt, q, 0, iq, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sbdsqr(String uplo, int n, int ncvt, int nru, int ncc, float[] d, float[] e, float[] vt, int ldvt, float[] u, int ldu, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sbdsqr.sbdsqr(uplo, n, ncvt, nru, ncc, d, 0, e, 0, vt, 0, ldvt, u, 0, ldu, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sdisna(String job, int m, int n, float[] d, float[] sep, intW info) {
		org.netlib.lapack.Sdisna.sdisna(job, m, n, d, 0, sep, 0, info);
	}

	@Override
	public void sgbbrd(String vect, int m, int n, int ncc, int kl, int ku, float[] ab, int ldab, float[] d, float[] e, float[] q, int ldq, float[] pt, int ldpt, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sgbbrd.sgbbrd(vect, m, n, ncc, kl, ku, ab, 0, ldab, d, 0, e, 0, q, 0, ldq, pt, 0, ldpt, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sgbcon(String norm, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgbcon.sgbcon(norm, n, kl, ku, ab, 0, ldab, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void sgbequ(int m, int n, int kl, int ku, float[] ab, int ldab, float[] r, float[] c, floatW rowcnd, floatW colcnd, floatW amax, intW info) {
		org.netlib.lapack.Sgbequ.sgbequ(m, n, kl, ku, ab, 0, ldab, r, 0, c, 0, rowcnd, colcnd, amax, info);
	}

	@Override
	public void sgbrfs(String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgbrfs.sgbrfs(trans, n, kl, ku, nrhs, ab, 0, ldab, afb, 0, ldafb, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgbsv(int n, int kl, int ku, int nrhs, float[] ab, int ldab, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgbsv.sgbsv(n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sgbsvx(String fact, String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, int[] ipiv, StringW equed, float[] r, float[] c, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgbsvx.sgbsvx(fact, trans, n, kl, ku, nrhs, ab, 0, ldab, afb, 0, ldafb, ipiv, 0, equed, r, 0, c, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgbtf2(int m, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, intW info) {
		org.netlib.lapack.Sgbtf2.sgbtf2(m, n, kl, ku, ab, 0, ldab, ipiv, 0, info);
	}

	@Override
	public void sgbtrf(int m, int n, int kl, int ku, float[] ab, int ldab, int[] ipiv, intW info) {
		org.netlib.lapack.Sgbtrf.sgbtrf(m, n, kl, ku, ab, 0, ldab, ipiv, 0, info);
	}

	@Override
	public void sgbtrs(String trans, int n, int kl, int ku, int nrhs, float[] ab, int ldab, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgbtrs.sgbtrs(trans, n, kl, ku, nrhs, ab, 0, ldab, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sgebak(String job, String side, int n, int ilo, int ihi, float[] scale, int m, float[] v, int ldv, intW info) {
		org.netlib.lapack.Sgebak.sgebak(job, side, n, ilo, ihi, scale, 0, m, v, 0, ldv, info);
	}

	@Override
	public void sgebal(String job, int n, float[] a, int lda, intW ilo, intW ihi, float[] scale, intW info) {
		org.netlib.lapack.Sgebal.sgebal(job, n, a, 0, lda, ilo, ihi, scale, 0, info);
	}

	@Override
	public void sgebd2(int m, int n, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] work, intW info) {
		org.netlib.lapack.Sgebd2.sgebd2(m, n, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, work, 0, info);
	}

	@Override
	public void sgebrd(int m, int n, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgebrd.sgebrd(m, n, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, work, 0, lwork, info);
	}

	@Override
	public void sgecon(String norm, int n, float[] a, int lda, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgecon.sgecon(norm, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void sgeequ(int m, int n, float[] a, int lda, float[] r, float[] c, floatW rowcnd, floatW colcnd, floatW amax, intW info) {
		org.netlib.lapack.Sgeequ.sgeequ(m, n, a, 0, lda, r, 0, c, 0, rowcnd, colcnd, amax, info);
	}

	@Override
	public void sgeev(String jobvl, String jobvr, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgeev.sgeev(jobvl, jobvr, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void sgeevx(String balanc, String jobvl, String jobvr, String sense, int n, float[] a, int lda, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, intW ilo, intW ihi, float[] scale, floatW abnrm, float[] rconde, float[] rcondv, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Sgeevx.sgeevx(balanc, jobvl, jobvr, sense, n, a, 0, lda, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, ilo, ihi, scale, 0, abnrm, rconde, 0, rcondv, 0, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void sgegs(String jobvsl, String jobvsr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vsl, int ldvsl, float[] vsr, int ldvsr, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgegs.sgegs(jobvsl, jobvsr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vsl, 0, ldvsl, vsr, 0, ldvsr, work, 0, lwork, info);
	}

	@Override
	public void sgegv(String jobvl, String jobvr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgegv.sgegv(jobvl, jobvr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void sgehd2(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgehd2.sgehd2(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sgehrd(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgehrd.sgehrd(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgelq2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgelq2.sgelq2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sgelqf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgelqf.sgelqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgels(String trans, int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgels.sgels(trans, m, n, nrhs, a, 0, lda, b, 0, ldb, work, 0, lwork, info);
	}

	@Override
	public void sgelsd(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] s, float rcond, intW rank, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Sgelsd.sgelsd(m, n, nrhs, a, 0, lda, b, 0, ldb, s, 0, rcond, rank, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void sgelss(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] s, float rcond, intW rank, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgelss.sgelss(m, n, nrhs, a, 0, lda, b, 0, ldb, s, 0, rcond, rank, work, 0, lwork, info);
	}

	@Override
	public void sgelsx(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, int[] jpvt, float rcond, intW rank, float[] work, intW info) {
		org.netlib.lapack.Sgelsx.sgelsx(m, n, nrhs, a, 0, lda, b, 0, ldb, jpvt, 0, rcond, rank, work, 0, info);
	}

	@Override
	public void sgelsy(int m, int n, int nrhs, float[] a, int lda, float[] b, int ldb, int[] jpvt, float rcond, intW rank, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgelsy.sgelsy(m, n, nrhs, a, 0, lda, b, 0, ldb, jpvt, 0, rcond, rank, work, 0, lwork, info);
	}

	@Override
	public void sgeql2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgeql2.sgeql2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sgeqlf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgeqlf.sgeqlf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgeqp3(int m, int n, float[] a, int lda, int[] jpvt, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgeqp3.sgeqp3(m, n, a, 0, lda, jpvt, 0, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgeqpf(int m, int n, float[] a, int lda, int[] jpvt, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgeqpf.sgeqpf(m, n, a, 0, lda, jpvt, 0, tau, 0, work, 0, info);
	}

	@Override
	public void sgeqr2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgeqr2.sgeqr2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sgeqrf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgeqrf.sgeqrf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgerfs(String trans, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgerfs.sgerfs(trans, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgerq2(int m, int n, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sgerq2.sgerq2(m, n, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sgerqf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgerqf.sgerqf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sgesc2(int n, float[] a, int lda, float[] rhs, int[] ipiv, int[] jpiv, floatW scale) {
		org.netlib.lapack.Sgesc2.sgesc2(n, a, 0, lda, rhs, 0, ipiv, 0, jpiv, 0, scale);
	}

	@Override
	public void sgesdd(String jobz, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Sgesdd.sgesdd(jobz, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void sgesv(int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgesv.sgesv(n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sgesvd(String jobu, String jobvt, int m, int n, float[] a, int lda, float[] s, float[] u, int ldu, float[] vt, int ldvt, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgesvd.sgesvd(jobu, jobvt, m, n, a, 0, lda, s, 0, u, 0, ldu, vt, 0, ldvt, work, 0, lwork, info);
	}

	@Override
	public void sgesvx(String fact, String trans, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, StringW equed, float[] r, float[] c, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgesvx.sgesvx(fact, trans, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, equed, r, 0, c, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgetc2(int n, float[] a, int lda, int[] ipiv, int[] jpiv, intW info) {
		org.netlib.lapack.Sgetc2.sgetc2(n, a, 0, lda, ipiv, 0, jpiv, 0, info);
	}

	@Override
	public void sgetf2(int m, int n, float[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Sgetf2.sgetf2(m, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void sgetrf(int m, int n, float[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Sgetrf.sgetrf(m, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void sgetri(int n, float[] a, int lda, int[] ipiv, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgetri.sgetri(n, a, 0, lda, ipiv, 0, work, 0, lwork, info);
	}

	@Override
	public void sgetrs(String trans, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgetrs.sgetrs(trans, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sggbak(String job, String side, int n, int ilo, int ihi, float[] lscale, float[] rscale, int m, float[] v, int ldv, intW info) {
		org.netlib.lapack.Sggbak.sggbak(job, side, n, ilo, ihi, lscale, 0, rscale, 0, m, v, 0, ldv, info);
	}

	@Override
	public void sggbal(String job, int n, float[] a, int lda, float[] b, int ldb, intW ilo, intW ihi, float[] lscale, float[] rscale, float[] work, intW info) {
		org.netlib.lapack.Sggbal.sggbal(job, n, a, 0, lda, b, 0, ldb, ilo, ihi, lscale, 0, rscale, 0, work, 0, info);
	}

	@Override
	public void sggev(String jobvl, String jobvr, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sggev.sggev(jobvl, jobvr, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, work, 0, lwork, info);
	}

	@Override
	public void sggevx(String balanc, String jobvl, String jobvr, String sense, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] vl, int ldvl, float[] vr, int ldvr, intW ilo, intW ihi, float[] lscale, float[] rscale, floatW abnrm, floatW bbnrm, float[] rconde, float[] rcondv, float[] work, int lwork, int[] iwork, boolean[] bwork, intW info) {
		org.netlib.lapack.Sggevx.sggevx(balanc, jobvl, jobvr, sense, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, vl, 0, ldvl, vr, 0, ldvr, ilo, ihi, lscale, 0, rscale, 0, abnrm, bbnrm, rconde, 0, rcondv, 0, work, 0, lwork, iwork, 0, bwork, 0, info);
	}

	@Override
	public void sggglm(int n, int m, int p, float[] a, int lda, float[] b, int ldb, float[] d, float[] x, float[] y, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sggglm.sggglm(n, m, p, a, 0, lda, b, 0, ldb, d, 0, x, 0, y, 0, work, 0, lwork, info);
	}

	@Override
	public void sgghrd(String compq, String compz, int n, int ilo, int ihi, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, intW info) {
		org.netlib.lapack.Sgghrd.sgghrd(compq, compz, n, ilo, ihi, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, info);
	}

	@Override
	public void sgglse(int m, int n, int p, float[] a, int lda, float[] b, int ldb, float[] c, float[] d, float[] x, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sgglse.sgglse(m, n, p, a, 0, lda, b, 0, ldb, c, 0, d, 0, x, 0, work, 0, lwork, info);
	}

	@Override
	public void sggqrf(int n, int m, int p, float[] a, int lda, float[] taua, float[] b, int ldb, float[] taub, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sggqrf.sggqrf(n, m, p, a, 0, lda, taua, 0, b, 0, ldb, taub, 0, work, 0, lwork, info);
	}

	@Override
	public void sggrqf(int m, int p, int n, float[] a, int lda, float[] taua, float[] b, int ldb, float[] taub, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sggrqf.sggrqf(m, p, n, a, 0, lda, taua, 0, b, 0, ldb, taub, 0, work, 0, lwork, info);
	}

	@Override
	public void sggsvd(String jobu, String jobv, String jobq, int m, int n, int p, intW k, intW l, float[] a, int lda, float[] b, int ldb, float[] alpha, float[] beta, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sggsvd.sggsvd(jobu, jobv, jobq, m, n, p, k, l, a, 0, lda, b, 0, ldb, alpha, 0, beta, 0, u, 0, ldu, v, 0, ldv, q, 0, ldq, work, 0, iwork, 0, info);
	}

	@Override
	public void sggsvp(String jobu, String jobv, String jobq, int m, int p, int n, float[] a, int lda, float[] b, int ldb, float tola, float tolb, intW k, intW l, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, int[] iwork, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sggsvp.sggsvp(jobu, jobv, jobq, m, p, n, a, 0, lda, b, 0, ldb, tola, tolb, k, l, u, 0, ldu, v, 0, ldv, q, 0, ldq, iwork, 0, tau, 0, work, 0, info);
	}

	@Override
	public void sgtcon(String norm, int n, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgtcon.sgtcon(norm, n, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void sgtrfs(String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] dlf, float[] df, float[] duf, float[] du2, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgtrfs.sgtrfs(trans, n, nrhs, dl, 0, d, 0, du, 0, dlf, 0, df, 0, duf, 0, du2, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgtsv(int n, int nrhs, float[] dl, float[] d, float[] du, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgtsv.sgtsv(n, nrhs, dl, 0, d, 0, du, 0, b, 0, ldb, info);
	}

	@Override
	public void sgtsvx(String fact, String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] dlf, float[] df, float[] duf, float[] du2, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sgtsvx.sgtsvx(fact, trans, n, nrhs, dl, 0, d, 0, du, 0, dlf, 0, df, 0, duf, 0, du2, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sgttrf(int n, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, intW info) {
		org.netlib.lapack.Sgttrf.sgttrf(n, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, info);
	}

	@Override
	public void sgttrs(String trans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sgttrs.sgttrs(trans, n, nrhs, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sgtts2(int itrans, int n, int nrhs, float[] dl, float[] d, float[] du, float[] du2, int[] ipiv, float[] b, int ldb) {
		org.netlib.lapack.Sgtts2.sgtts2(itrans, n, nrhs, dl, 0, d, 0, du, 0, du2, 0, ipiv, 0, b, 0, ldb);
	}

	@Override
	public void shgeqz(String job, String compq, String compz, int n, int ilo, int ihi, float[] h, int ldh, float[] t, int ldt, float[] alphar, float[] alphai, float[] beta, float[] q, int ldq, float[] z, int ldz, float[] work, int lwork, intW info) {
		org.netlib.lapack.Shgeqz.shgeqz(job, compq, compz, n, ilo, ihi, h, 0, ldh, t, 0, ldt, alphar, 0, alphai, 0, beta, 0, q, 0, ldq, z, 0, ldz, work, 0, lwork, info);
	}

	@Override
	public void shsein(String side, String eigsrc, String initv, boolean[] select, int n, float[] h, int ldh, float[] wr, float[] wi, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, int[] ifaill, int[] ifailr, intW info) {
		org.netlib.lapack.Shsein.shsein(side, eigsrc, initv, select, 0, n, h, 0, ldh, wr, 0, wi, 0, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, ifaill, 0, ifailr, 0, info);
	}

	@Override
	public void shseqr(String job, String compz, int n, int ilo, int ihi, float[] h, int ldh, float[] wr, float[] wi, float[] z, int ldz, float[] work, int lwork, intW info) {
		org.netlib.lapack.Shseqr.shseqr(job, compz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, z, 0, ldz, work, 0, lwork, info);
	}

	@Override
	public void slabad(floatW small, floatW large) {
		org.netlib.lapack.Slabad.slabad(small, large);
	}

	@Override
	public void slabrd(int m, int n, int nb, float[] a, int lda, float[] d, float[] e, float[] tauq, float[] taup, float[] x, int ldx, float[] y, int ldy) {
		org.netlib.lapack.Slabrd.slabrd(m, n, nb, a, 0, lda, d, 0, e, 0, tauq, 0, taup, 0, x, 0, ldx, y, 0, ldy);
	}

	@Override
	public void slacon(int n, float[] v, float[] x, int[] isgn, floatW est, intW kase) {
		org.netlib.lapack.Slacon.slacon(n, v, 0, x, 0, isgn, 0, est, kase);
	}

	@Override
	public void slacpy(String uplo, int m, int n, float[] a, int lda, float[] b, int ldb) {
		org.netlib.lapack.Slacpy.slacpy(uplo, m, n, a, 0, lda, b, 0, ldb);
	}

	@Override
	public void sladiv(float a, float b, float c, float d, floatW p, floatW q) {
		org.netlib.lapack.Sladiv.sladiv(a, b, c, d, p, q);
	}

	@Override
	public void slae2(float a, float b, float c, floatW rt1, floatW rt2) {
		org.netlib.lapack.Slae2.slae2(a, b, c, rt1, rt2);
	}

	@Override
	public void slaebz(int ijob, int nitmax, int n, int mmax, int minp, int nbmin, float abstol, float reltol, float pivmin, float[] d, float[] e, float[] e2, int[] nval, float[] ab, float[] c, intW mout, int[] nab, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slaebz.slaebz(ijob, nitmax, n, mmax, minp, nbmin, abstol, reltol, pivmin, d, 0, e, 0, e2, 0, nval, 0, ab, 0, c, 0, mout, nab, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void slaed0(int icompq, int qsiz, int n, float[] d, float[] e, float[] q, int ldq, float[] qstore, int ldqs, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slaed0.slaed0(icompq, qsiz, n, d, 0, e, 0, q, 0, ldq, qstore, 0, ldqs, work, 0, iwork, 0, info);
	}

	@Override
	public void slaed1(int n, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slaed1.slaed1(n, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, work, 0, iwork, 0, info);
	}

	@Override
	public void slaed2(intW k, int n, int n1, float[] d, float[] q, int ldq, int[] indxq, floatW rho, float[] z, float[] dlamda, float[] w, float[] q2, int[] indx, int[] indxc, int[] indxp, int[] coltyp, intW info) {
		org.netlib.lapack.Slaed2.slaed2(k, n, n1, d, 0, q, 0, ldq, indxq, 0, rho, z, 0, dlamda, 0, w, 0, q2, 0, indx, 0, indxc, 0, indxp, 0, coltyp, 0, info);
	}

	@Override
	public void slaed3(int k, int n, int n1, float[] d, float[] q, int ldq, float rho, float[] dlamda, float[] q2, int[] indx, int[] ctot, float[] w, float[] s, intW info) {
		org.netlib.lapack.Slaed3.slaed3(k, n, n1, d, 0, q, 0, ldq, rho, dlamda, 0, q2, 0, indx, 0, ctot, 0, w, 0, s, 0, info);
	}

	@Override
	public void slaed4(int n, int i, float[] d, float[] z, float[] delta, float rho, floatW dlam, intW info) {
		org.netlib.lapack.Slaed4.slaed4(n, i, d, 0, z, 0, delta, 0, rho, dlam, info);
	}

	@Override
	public void slaed5(int i, float[] d, float[] z, float[] delta, float rho, floatW dlam) {
		org.netlib.lapack.Slaed5.slaed5(i, d, 0, z, 0, delta, 0, rho, dlam);
	}

	@Override
	public void slaed6(int kniter, boolean orgati, float rho, float[] d, float[] z, float finit, floatW tau, intW info) {
		org.netlib.lapack.Slaed6.slaed6(kniter, orgati, rho, d, 0, z, 0, finit, tau, info);
	}

	@Override
	public void slaed7(int icompq, int n, int qsiz, int tlvls, int curlvl, int curpbm, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] qstore, int[] qptr, int[] prmptr, int[] perm, int[] givptr, int[] givcol, float[] givnum, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slaed7.slaed7(icompq, n, qsiz, tlvls, curlvl, curpbm, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, qstore, 0, qptr, 0, prmptr, 0, perm, 0, givptr, 0, givcol, 0, givnum, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void slaed8(int icompq, intW k, int n, int qsiz, float[] d, float[] q, int ldq, int[] indxq, floatW rho, int cutpnt, float[] z, float[] dlamda, float[] q2, int ldq2, float[] w, int[] perm, intW givptr, int[] givcol, float[] givnum, int[] indxp, int[] indx, intW info) {
		org.netlib.lapack.Slaed8.slaed8(icompq, k, n, qsiz, d, 0, q, 0, ldq, indxq, 0, rho, cutpnt, z, 0, dlamda, 0, q2, 0, ldq2, w, 0, perm, 0, givptr, givcol, 0, givnum, 0, indxp, 0, indx, 0, info);
	}

	@Override
	public void slaed9(int k, int kstart, int kstop, int n, float[] d, float[] q, int ldq, float rho, float[] dlamda, float[] w, float[] s, int lds, intW info) {
		org.netlib.lapack.Slaed9.slaed9(k, kstart, kstop, n, d, 0, q, 0, ldq, rho, dlamda, 0, w, 0, s, 0, lds, info);
	}

	@Override
	public void slaeda(int n, int tlvls, int curlvl, int curpbm, int[] prmptr, int[] perm, int[] givptr, int[] givcol, float[] givnum, float[] q, int[] qptr, float[] z, float[] ztemp, intW info) {
		org.netlib.lapack.Slaeda.slaeda(n, tlvls, curlvl, curpbm, prmptr, 0, perm, 0, givptr, 0, givcol, 0, givnum, 0, q, 0, qptr, 0, z, 0, ztemp, 0, info);
	}

	@Override
	public void slaein(boolean rightv, boolean noinit, int n, float[] h, int ldh, float wr, float wi, float[] vr, float[] vi, float[] b, int ldb, float[] work, float eps3, float smlnum, float bignum, intW info) {
		org.netlib.lapack.Slaein.slaein(rightv, noinit, n, h, 0, ldh, wr, wi, vr, 0, vi, 0, b, 0, ldb, work, 0, eps3, smlnum, bignum, info);
	}

	@Override
	public void slaev2(float a, float b, float c, floatW rt1, floatW rt2, floatW cs1, floatW sn1) {
		org.netlib.lapack.Slaev2.slaev2(a, b, c, rt1, rt2, cs1, sn1);
	}

	@Override
	public void slaexc(boolean wantq, int n, float[] t, int ldt, float[] q, int ldq, int j1, int n1, int n2, float[] work, intW info) {
		org.netlib.lapack.Slaexc.slaexc(wantq, n, t, 0, ldt, q, 0, ldq, j1, n1, n2, work, 0, info);
	}

	@Override
	public void slag2(float[] a, int lda, float[] b, int ldb, float safmin, floatW scale1, floatW scale2, floatW wr1, floatW wr2, floatW wi) {
		org.netlib.lapack.Slag2.slag2(a, 0, lda, b, 0, ldb, safmin, scale1, scale2, wr1, wr2, wi);
	}

	@Override
	public void slags2(boolean upper, float a1, float a2, float a3, float b1, float b2, float b3, floatW csu, floatW snu, floatW csv, floatW snv, floatW csq, floatW snq) {
		org.netlib.lapack.Slags2.slags2(upper, a1, a2, a3, b1, b2, b3, csu, snu, csv, snv, csq, snq);
	}

	@Override
	public void slagtf(int n, float[] a, float lambda, float[] b, float[] c, float tol, float[] d, int[] in, intW info) {
		org.netlib.lapack.Slagtf.slagtf(n, a, 0, lambda, b, 0, c, 0, tol, d, 0, in, 0, info);
	}

	@Override
	public void slagtm(String trans, int n, int nrhs, float alpha, float[] dl, float[] d, float[] du, float[] x, int ldx, float beta, float[] b, int ldb) {
		org.netlib.lapack.Slagtm.slagtm(trans, n, nrhs, alpha, dl, 0, d, 0, du, 0, x, 0, ldx, beta, b, 0, ldb);
	}

	@Override
	public void slagts(int job, int n, float[] a, float[] b, float[] c, float[] d, int[] in, float[] y, floatW tol, intW info) {
		org.netlib.lapack.Slagts.slagts(job, n, a, 0, b, 0, c, 0, d, 0, in, 0, y, 0, tol, info);
	}

	@Override
	public void slagv2(float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, floatW csl, floatW snl, floatW csr, floatW snr) {
		org.netlib.lapack.Slagv2.slagv2(a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, csl, snl, csr, snr);
	}

	@Override
	public void slahqr(boolean wantt, boolean wantz, int n, int ilo, int ihi, float[] h, int ldh, float[] wr, float[] wi, int iloz, int ihiz, float[] z, int ldz, intW info) {
		org.netlib.lapack.Slahqr.slahqr(wantt, wantz, n, ilo, ihi, h, 0, ldh, wr, 0, wi, 0, iloz, ihiz, z, 0, ldz, info);
	}

	@Override
	public void slahrd(int n, int k, int nb, float[] a, int lda, float[] tau, float[] t, int ldt, float[] y, int ldy) {
		org.netlib.lapack.Slahrd.slahrd(n, k, nb, a, 0, lda, tau, 0, t, 0, ldt, y, 0, ldy);
	}

	@Override
	public void slaic1(int job, int j, float[] x, float sest, float[] w, float gamma, floatW sestpr, floatW s, floatW c) {
		org.netlib.lapack.Slaic1.slaic1(job, j, x, 0, sest, w, 0, gamma, sestpr, s, c);
	}

	@Override
	public void slaln2(boolean ltrans, int na, int nw, float smin, float ca, float[] a, int lda, float d1, float d2, float[] b, int ldb, float wr, float wi, float[] x, int ldx, floatW scale, floatW xnorm, intW info) {
		org.netlib.lapack.Slaln2.slaln2(ltrans, na, nw, smin, ca, a, 0, lda, d1, d2, b, 0, ldb, wr, wi, x, 0, ldx, scale, xnorm, info);
	}

	@Override
	public void slals0(int icompq, int nl, int nr, int sqre, int nrhs, float[] b, int ldb, float[] bx, int ldbx, int[] perm, int givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, float[] poles, float[] difl, float[] difr, float[] z, int k, float c, float s, float[] work, intW info) {
		org.netlib.lapack.Slals0.slals0(icompq, nl, nr, sqre, nrhs, b, 0, ldb, bx, 0, ldbx, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, poles, 0, difl, 0, difr, 0, z, 0, k, c, s, work, 0, info);
	}

	@Override
	public void slalsa(int icompq, int smlsiz, int n, int nrhs, float[] b, int ldb, float[] bx, int ldbx, float[] u, int ldu, float[] vt, int[] k, float[] difl, float[] difr, float[] z, float[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, float[] givnum, float[] c, float[] s, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slalsa.slalsa(icompq, smlsiz, n, nrhs, b, 0, ldb, bx, 0, ldbx, u, 0, ldu, vt, 0, k, 0, difl, 0, difr, 0, z, 0, poles, 0, givptr, 0, givcol, 0, ldgcol, perm, 0, givnum, 0, c, 0, s, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void slalsd(String uplo, int smlsiz, int n, int nrhs, float[] d, float[] e, float[] b, int ldb, float rcond, intW rank, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slalsd.slalsd(uplo, smlsiz, n, nrhs, d, 0, e, 0, b, 0, ldb, rcond, rank, work, 0, iwork, 0, info);
	}

	@Override
	public void slamrg(int n1, int n2, float[] a, int strd1, int strd2, int[] index) {
		org.netlib.lapack.Slamrg.slamrg(n1, n2, a, 0, strd1, strd2, index, 0);
	}

	@Override
	public void slanv2(floatW a, floatW b, floatW c, floatW d, floatW rt1r, floatW rt1i, floatW rt2r, floatW rt2i, floatW cs, floatW sn) {
		org.netlib.lapack.Slanv2.slanv2(a, b, c, d, rt1r, rt1i, rt2r, rt2i, cs, sn);
	}

	@Override
	public void slapll(int n, float[] x, int incx, float[] y, int incy, floatW ssmin) {
		org.netlib.lapack.Slapll.slapll(n, x, 0, incx, y, 0, incy, ssmin);
	}

	@Override
	public void slapmt(boolean forwrd, int m, int n, float[] x, int ldx, int[] k) {
		org.netlib.lapack.Slapmt.slapmt(forwrd, m, n, x, 0, ldx, k, 0);
	}

	@Override
	public void slaqgb(int m, int n, int kl, int ku, float[] ab, int ldab, float[] r, float[] c, float rowcnd, float colcnd, float amax, StringW equed) {
		org.netlib.lapack.Slaqgb.slaqgb(m, n, kl, ku, ab, 0, ldab, r, 0, c, 0, rowcnd, colcnd, amax, equed);
	}

	@Override
	public void slaqge(int m, int n, float[] a, int lda, float[] r, float[] c, float rowcnd, float colcnd, float amax, StringW equed) {
		org.netlib.lapack.Slaqge.slaqge(m, n, a, 0, lda, r, 0, c, 0, rowcnd, colcnd, amax, equed);
	}

	@Override
	public void slaqp2(int m, int n, int offset, float[] a, int lda, int[] jpvt, float[] tau, float[] vn1, float[] vn2, float[] work) {
		org.netlib.lapack.Slaqp2.slaqp2(m, n, offset, a, 0, lda, jpvt, 0, tau, 0, vn1, 0, vn2, 0, work, 0);
	}

	@Override
	public void slaqps(int m, int n, int offset, int nb, intW kb, float[] a, int lda, int[] jpvt, float[] tau, float[] vn1, float[] vn2, float[] auxv, float[] f, int ldf) {
		org.netlib.lapack.Slaqps.slaqps(m, n, offset, nb, kb, a, 0, lda, jpvt, 0, tau, 0, vn1, 0, vn2, 0, auxv, 0, f, 0, ldf);
	}

	@Override
	public void slaqsb(String uplo, int n, int kd, float[] ab, int ldab, float[] s, float scond, float amax, StringW equed) {
		org.netlib.lapack.Slaqsb.slaqsb(uplo, n, kd, ab, 0, ldab, s, 0, scond, amax, equed);
	}

	@Override
	public void slaqsp(String uplo, int n, float[] ap, float[] s, float scond, float amax, StringW equed) {
		org.netlib.lapack.Slaqsp.slaqsp(uplo, n, ap, 0, s, 0, scond, amax, equed);
	}

	@Override
	public void slaqsy(String uplo, int n, float[] a, int lda, float[] s, float scond, float amax, StringW equed) {
		org.netlib.lapack.Slaqsy.slaqsy(uplo, n, a, 0, lda, s, 0, scond, amax, equed);
	}

	@Override
	public void slaqtr(boolean ltran, boolean lreal, int n, float[] t, int ldt, float[] b, float w, floatW scale, float[] x, float[] work, intW info) {
		org.netlib.lapack.Slaqtr.slaqtr(ltran, lreal, n, t, 0, ldt, b, 0, w, scale, x, 0, work, 0, info);
	}

	@Override
	public void slar2v(int n, float[] x, float[] y, float[] z, int incx, float[] c, float[] s, int incc) {
		org.netlib.lapack.Slar2v.slar2v(n, x, 0, y, 0, z, 0, incx, c, 0, s, 0, incc);
	}

	@Override
	public void slarf(String side, int m, int n, float[] v, int incv, float tau, float[] c, int Ldc, float[] work) {
		org.netlib.lapack.Slarf.slarf(side, m, n, v, 0, incv, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void slarfb(String side, String trans, String direct, String storev, int m, int n, int k, float[] v, int ldv, float[] t, int ldt, float[] c, int Ldc, float[] work, int ldwork) {
		org.netlib.lapack.Slarfb.slarfb(side, trans, direct, storev, m, n, k, v, 0, ldv, t, 0, ldt, c, 0, Ldc, work, 0, ldwork);
	}

	@Override
	public void slarfg(int n, floatW alpha, float[] x, int incx, floatW tau) {
		org.netlib.lapack.Slarfg.slarfg(n, alpha, x, 0, incx, tau);
	}

	@Override
	public void slarft(String direct, String storev, int n, int k, float[] v, int ldv, float[] tau, float[] t, int ldt) {
		org.netlib.lapack.Slarft.slarft(direct, storev, n, k, v, 0, ldv, tau, 0, t, 0, ldt);
	}

	@Override
	public void slarfx(String side, int m, int n, float[] v, float tau, float[] c, int Ldc, float[] work) {
		org.netlib.lapack.Slarfx.slarfx(side, m, n, v, 0, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void slargv(int n, float[] x, int incx, float[] y, int incy, float[] c, int incc) {
		org.netlib.lapack.Slargv.slargv(n, x, 0, incx, y, 0, incy, c, 0, incc);
	}

	@Override
	public void slarnv(int idist, int[] iseed, int n, float[] x) {
		org.netlib.lapack.Slarnv.slarnv(idist, iseed, 0, n, x, 0);
	}

	@Override
	public void slartg(float f, float g, floatW cs, floatW sn, floatW r) {
		org.netlib.lapack.Slartg.slartg(f, g, cs, sn, r);
	}

	@Override
	public void slartv(int n, float[] x, int incx, float[] y, int incy, float[] c, float[] s, int incc) {
		org.netlib.lapack.Slartv.slartv(n, x, 0, incx, y, 0, incy, c, 0, s, 0, incc);
	}

	@Override
	public void slaruv(int[] iseed, int n, float[] x) {
		org.netlib.lapack.Slaruv.slaruv(iseed, 0, n, x, 0);
	}

	@Override
	public void slarz(String side, int m, int n, int l, float[] v, int incv, float tau, float[] c, int Ldc, float[] work) {
		org.netlib.lapack.Slarz.slarz(side, m, n, l, v, 0, incv, tau, c, 0, Ldc, work, 0);
	}

	@Override
	public void slarzb(String side, String trans, String direct, String storev, int m, int n, int k, int l, float[] v, int ldv, float[] t, int ldt, float[] c, int Ldc, float[] work, int ldwork) {
		org.netlib.lapack.Slarzb.slarzb(side, trans, direct, storev, m, n, k, l, v, 0, ldv, t, 0, ldt, c, 0, Ldc, work, 0, ldwork);
	}

	@Override
	public void slarzt(String direct, String storev, int n, int k, float[] v, int ldv, float[] tau, float[] t, int ldt) {
		org.netlib.lapack.Slarzt.slarzt(direct, storev, n, k, v, 0, ldv, tau, 0, t, 0, ldt);
	}

	@Override
	public void slas2(float f, float g, float h, floatW ssmin, floatW ssmax) {
		org.netlib.lapack.Slas2.slas2(f, g, h, ssmin, ssmax);
	}

	@Override
	public void slascl(String type, int kl, int ku, float cfrom, float cto, int m, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Slascl.slascl(type, kl, ku, cfrom, cto, m, n, a, 0, lda, info);
	}

	@Override
	public void slasd0(int n, int sqre, float[] d, float[] e, float[] u, int ldu, float[] vt, int ldvt, int smlsiz, int[] iwork, float[] work, intW info) {
		org.netlib.lapack.Slasd0.slasd0(n, sqre, d, 0, e, 0, u, 0, ldu, vt, 0, ldvt, smlsiz, iwork, 0, work, 0, info);
	}

	@Override
	public void slasd1(int nl, int nr, int sqre, float[] d, floatW alpha, floatW beta, float[] u, int ldu, float[] vt, int ldvt, int[] idxq, int[] iwork, float[] work, intW info) {
		org.netlib.lapack.Slasd1.slasd1(nl, nr, sqre, d, 0, alpha, beta, u, 0, ldu, vt, 0, ldvt, idxq, 0, iwork, 0, work, 0, info);
	}

	@Override
	public void slasd2(int nl, int nr, int sqre, intW k, float[] d, float[] z, float alpha, float beta, float[] u, int ldu, float[] vt, int ldvt, float[] dsigma, float[] u2, int ldu2, float[] vt2, int ldvt2, int[] idxp, int[] idx, int[] idxc, int[] idxq, int[] coltyp, intW info) {
		org.netlib.lapack.Slasd2.slasd2(nl, nr, sqre, k, d, 0, z, 0, alpha, beta, u, 0, ldu, vt, 0, ldvt, dsigma, 0, u2, 0, ldu2, vt2, 0, ldvt2, idxp, 0, idx, 0, idxc, 0, idxq, 0, coltyp, 0, info);
	}

	@Override
	public void slasd3(int nl, int nr, int sqre, int k, float[] d, float[] q, int ldq, float[] dsigma, float[] u, int ldu, float[] u2, int ldu2, float[] vt, int ldvt, float[] vt2, int ldvt2, int[] idxc, int[] ctot, float[] z, intW info) {
		org.netlib.lapack.Slasd3.slasd3(nl, nr, sqre, k, d, 0, q, 0, ldq, dsigma, 0, u, 0, ldu, u2, 0, ldu2, vt, 0, ldvt, vt2, 0, ldvt2, idxc, 0, ctot, 0, z, 0, info);
	}

	@Override
	public void slasd4(int n, int i, float[] d, float[] z, float[] delta, float rho, floatW sigma, float[] work, intW info) {
		org.netlib.lapack.Slasd4.slasd4(n, i, d, 0, z, 0, delta, 0, rho, sigma, work, 0, info);
	}

	@Override
	public void slasd5(int i, float[] d, float[] z, float[] delta, float rho, floatW dsigma, float[] work) {
		org.netlib.lapack.Slasd5.slasd5(i, d, 0, z, 0, delta, 0, rho, dsigma, work, 0);
	}

	@Override
	public void slasd6(int icompq, int nl, int nr, int sqre, float[] d, float[] vf, float[] vl, floatW alpha, floatW beta, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, float[] poles, float[] difl, float[] difr, float[] z, intW k, floatW c, floatW s, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slasd6.slasd6(icompq, nl, nr, sqre, d, 0, vf, 0, vl, 0, alpha, beta, idxq, 0, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, poles, 0, difl, 0, difr, 0, z, 0, k, c, s, work, 0, iwork, 0, info);
	}

	@Override
	public void slasd7(int icompq, int nl, int nr, int sqre, intW k, float[] d, float[] z, float[] zw, float[] vf, float[] vfw, float[] vl, float[] vlw, float alpha, float beta, float[] dsigma, int[] idx, int[] idxp, int[] idxq, int[] perm, intW givptr, int[] givcol, int ldgcol, float[] givnum, int ldgnum, floatW c, floatW s, intW info) {
		org.netlib.lapack.Slasd7.slasd7(icompq, nl, nr, sqre, k, d, 0, z, 0, zw, 0, vf, 0, vfw, 0, vl, 0, vlw, 0, alpha, beta, dsigma, 0, idx, 0, idxp, 0, idxq, 0, perm, 0, givptr, givcol, 0, ldgcol, givnum, 0, ldgnum, c, s, info);
	}

	@Override
	public void slasd8(int icompq, int k, float[] d, float[] z, float[] vf, float[] vl, float[] difl, float[] difr, int lddifr, float[] dsigma, float[] work, intW info) {
		org.netlib.lapack.Slasd8.slasd8(icompq, k, d, 0, z, 0, vf, 0, vl, 0, difl, 0, difr, 0, lddifr, dsigma, 0, work, 0, info);
	}

	@Override
	public void slasda(int icompq, int smlsiz, int n, int sqre, float[] d, float[] e, float[] u, int ldu, float[] vt, int[] k, float[] difl, float[] difr, float[] z, float[] poles, int[] givptr, int[] givcol, int ldgcol, int[] perm, float[] givnum, float[] c, float[] s, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Slasda.slasda(icompq, smlsiz, n, sqre, d, 0, e, 0, u, 0, ldu, vt, 0, k, 0, difl, 0, difr, 0, z, 0, poles, 0, givptr, 0, givcol, 0, ldgcol, perm, 0, givnum, 0, c, 0, s, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void slasdq(String uplo, int sqre, int n, int ncvt, int nru, int ncc, float[] d, float[] e, float[] vt, int ldvt, float[] u, int ldu, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Slasdq.slasdq(uplo, sqre, n, ncvt, nru, ncc, d, 0, e, 0, vt, 0, ldvt, u, 0, ldu, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void slasdt(int n, intW lvl, intW nd, int[] inode, int[] ndiml, int[] ndimr, int msub) {
		org.netlib.lapack.Slasdt.slasdt(n, lvl, nd, inode, 0, ndiml, 0, ndimr, 0, msub);
	}

	@Override
	public void slaset(String uplo, int m, int n, float alpha, float beta, float[] a, int lda) {
		org.netlib.lapack.Slaset.slaset(uplo, m, n, alpha, beta, a, 0, lda);
	}

	@Override
	public void slasq1(int n, float[] d, float[] e, float[] work, intW info) {
		org.netlib.lapack.Slasq1.slasq1(n, d, 0, e, 0, work, 0, info);
	}

	@Override
	public void slasq2(int n, float[] z, intW info) {
		org.netlib.lapack.Slasq2.slasq2(n, z, 0, info);
	}

	@Override
	public void slasq3(int i0, intW n0, float[] z, int pp, floatW dmin, floatW sigma, floatW desig, floatW qmax, intW nfail, intW iter, intW ndiv, boolean ieee) {
		org.netlib.lapack.Slasq3.slasq3(i0, n0, z, 0, pp, dmin, sigma, desig, qmax, nfail, iter, ndiv, ieee);
	}

	@Override
	public void slasq4(int i0, int n0, float[] z, int pp, int n0in, float dmin, float dmin1, float dmin2, float dn, float dn1, float dn2, floatW tau, intW ttype) {
		org.netlib.lapack.Slasq4.slasq4(i0, n0, z, 0, pp, n0in, dmin, dmin1, dmin2, dn, dn1, dn2, tau, ttype);
	}

	@Override
	public void slasq5(int i0, int n0, float[] z, int pp, float tau, floatW dmin, floatW dmin1, floatW dmin2, floatW dn, floatW dnm1, floatW dnm2, boolean ieee) {
		org.netlib.lapack.Slasq5.slasq5(i0, n0, z, 0, pp, tau, dmin, dmin1, dmin2, dn, dnm1, dnm2, ieee);
	}

	@Override
	public void slasq6(int i0, int n0, float[] z, int pp, floatW dmin, floatW dmin1, floatW dmin2, floatW dn, floatW dnm1, floatW dnm2) {
		org.netlib.lapack.Slasq6.slasq6(i0, n0, z, 0, pp, dmin, dmin1, dmin2, dn, dnm1, dnm2);
	}

	@Override
	public void slasr(String side, String pivot, String direct, int m, int n, float[] c, float[] s, float[] a, int lda) {
		org.netlib.lapack.Slasr.slasr(side, pivot, direct, m, n, c, 0, s, 0, a, 0, lda);
	}

	@Override
	public void slasrt(String id, int n, float[] d, intW info) {
		org.netlib.lapack.Slasrt.slasrt(id, n, d, 0, info);
	}

	@Override
	public void slassq(int n, float[] x, int incx, floatW scale, floatW sumsq) {
		org.netlib.lapack.Slassq.slassq(n, x, 0, incx, scale, sumsq);
	}

	@Override
	public void slasv2(float f, float g, float h, floatW ssmin, floatW ssmax, floatW snr, floatW csr, floatW snl, floatW csl) {
		org.netlib.lapack.Slasv2.slasv2(f, g, h, ssmin, ssmax, snr, csr, snl, csl);
	}

	@Override
	public void slaswp(int n, float[] a, int lda, int k1, int k2, int[] ipiv, int incx) {
		org.netlib.lapack.Slaswp.slaswp(n, a, 0, lda, k1, k2, ipiv, 0, incx);
	}

	@Override
	public void slasy2(boolean ltranl, boolean ltranr, int isgn, int n1, int n2, float[] tl, int ldtl, float[] tr, int ldtr, float[] b, int ldb, floatW scale, float[] x, int ldx, floatW xnorm, intW info) {
		org.netlib.lapack.Slasy2.slasy2(ltranl, ltranr, isgn, n1, n2, tl, 0, ldtl, tr, 0, ldtr, b, 0, ldb, scale, x, 0, ldx, xnorm, info);
	}

	@Override
	public void slasyf(String uplo, int n, int nb, intW kb, float[] a, int lda, int[] ipiv, float[] w, int ldw, intW info) {
		org.netlib.lapack.Slasyf.slasyf(uplo, n, nb, kb, a, 0, lda, ipiv, 0, w, 0, ldw, info);
	}

	@Override
	public void slatbs(String uplo, String trans, String diag, String normin, int n, int kd, float[] ab, int ldab, float[] x, floatW scale, float[] cnorm, intW info) {
		org.netlib.lapack.Slatbs.slatbs(uplo, trans, diag, normin, n, kd, ab, 0, ldab, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void slatdf(int ijob, int n, float[] z, int ldz, float[] rhs, floatW rdsum, floatW rdscal, int[] ipiv, int[] jpiv) {
		org.netlib.lapack.Slatdf.slatdf(ijob, n, z, 0, ldz, rhs, 0, rdsum, rdscal, ipiv, 0, jpiv, 0);
	}

	@Override
	public void slatps(String uplo, String trans, String diag, String normin, int n, float[] ap, float[] x, floatW scale, float[] cnorm, intW info) {
		org.netlib.lapack.Slatps.slatps(uplo, trans, diag, normin, n, ap, 0, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void slatrd(String uplo, int n, int nb, float[] a, int lda, float[] e, float[] tau, float[] w, int ldw) {
		org.netlib.lapack.Slatrd.slatrd(uplo, n, nb, a, 0, lda, e, 0, tau, 0, w, 0, ldw);
	}

	@Override
	public void slatrs(String uplo, String trans, String diag, String normin, int n, float[] a, int lda, float[] x, floatW scale, float[] cnorm, intW info) {
		org.netlib.lapack.Slatrs.slatrs(uplo, trans, diag, normin, n, a, 0, lda, x, 0, scale, cnorm, 0, info);
	}

	@Override
	public void slatrz(int m, int n, int l, float[] a, int lda, float[] tau, float[] work) {
		org.netlib.lapack.Slatrz.slatrz(m, n, l, a, 0, lda, tau, 0, work, 0);
	}

	@Override
	public void slatzm(String side, int m, int n, float[] v, int incv, float tau, float[] c1, float[] c2, int Ldc, float[] work) {
		org.netlib.lapack.Slatzm.slatzm(side, m, n, v, 0, incv, tau, c1, 0, c2, 0, Ldc, work, 0);
	}

	@Override
	public void slauu2(String uplo, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Slauu2.slauu2(uplo, n, a, 0, lda, info);
	}

	@Override
	public void slauum(String uplo, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Slauum.slauum(uplo, n, a, 0, lda, info);
	}

	@Override
	public void sopgtr(String uplo, int n, float[] ap, float[] tau, float[] q, int ldq, float[] work, intW info) {
		org.netlib.lapack.Sopgtr.sopgtr(uplo, n, ap, 0, tau, 0, q, 0, ldq, work, 0, info);
	}

	@Override
	public void sopmtr(String side, String uplo, String trans, int m, int n, float[] ap, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sopmtr.sopmtr(side, uplo, trans, m, n, ap, 0, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sorg2l(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sorg2l.sorg2l(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sorg2r(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sorg2r.sorg2r(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sorgbr(String vect, int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorgbr.sorgbr(vect, m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorghr(int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorghr.sorghr(n, ilo, ihi, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorgl2(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sorgl2.sorgl2(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sorglq(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorglq.sorglq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorgql(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorgql.sorgql(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorgqr(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorgqr.sorgqr(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorgr2(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, intW info) {
		org.netlib.lapack.Sorgr2.sorgr2(m, n, k, a, 0, lda, tau, 0, work, 0, info);
	}

	@Override
	public void sorgrq(int m, int n, int k, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorgrq.sorgrq(m, n, k, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorgtr(String uplo, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sorgtr.sorgtr(uplo, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void sorm2l(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sorm2l.sorm2l(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sorm2r(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sorm2r.sorm2r(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sormbr(String vect, String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormbr.sormbr(vect, side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormhr(String side, String trans, int m, int n, int ilo, int ihi, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormhr.sormhr(side, trans, m, n, ilo, ihi, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sorml2(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sorml2.sorml2(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sormlq(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormlq.sormlq(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormql(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormql.sormql(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormqr(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormqr.sormqr(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormr2(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sormr2.sormr2(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sormr3(String side, String trans, int m, int n, int k, int l, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, intW info) {
		org.netlib.lapack.Sormr3.sormr3(side, trans, m, n, k, l, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, info);
	}

	@Override
	public void sormrq(String side, String trans, int m, int n, int k, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormrq.sormrq(side, trans, m, n, k, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormrz(String side, String trans, int m, int n, int k, int l, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormrz.sormrz(side, trans, m, n, k, l, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void sormtr(String side, String uplo, String trans, int m, int n, float[] a, int lda, float[] tau, float[] c, int Ldc, float[] work, int lwork, intW info) {
		org.netlib.lapack.Sormtr.sormtr(side, uplo, trans, m, n, a, 0, lda, tau, 0, c, 0, Ldc, work, 0, lwork, info);
	}

	@Override
	public void spbcon(String uplo, int n, int kd, float[] ab, int ldab, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Spbcon.spbcon(uplo, n, kd, ab, 0, ldab, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void spbequ(String uplo, int n, int kd, float[] ab, int ldab, float[] s, floatW scond, floatW amax, intW info) {
		org.netlib.lapack.Spbequ.spbequ(uplo, n, kd, ab, 0, ldab, s, 0, scond, amax, info);
	}

	@Override
	public void spbrfs(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Spbrfs.spbrfs(uplo, n, kd, nrhs, ab, 0, ldab, afb, 0, ldafb, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void spbstf(String uplo, int n, int kd, float[] ab, int ldab, intW info) {
		org.netlib.lapack.Spbstf.spbstf(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void spbsv(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info) {
		org.netlib.lapack.Spbsv.spbsv(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void spbsvx(String fact, String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] afb, int ldafb, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Spbsvx.spbsvx(fact, uplo, n, kd, nrhs, ab, 0, ldab, afb, 0, ldafb, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void spbtf2(String uplo, int n, int kd, float[] ab, int ldab, intW info) {
		org.netlib.lapack.Spbtf2.spbtf2(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void spbtrf(String uplo, int n, int kd, float[] ab, int ldab, intW info) {
		org.netlib.lapack.Spbtrf.spbtrf(uplo, n, kd, ab, 0, ldab, info);
	}

	@Override
	public void spbtrs(String uplo, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info) {
		org.netlib.lapack.Spbtrs.spbtrs(uplo, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void spocon(String uplo, int n, float[] a, int lda, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Spocon.spocon(uplo, n, a, 0, lda, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void spoequ(int n, float[] a, int lda, float[] s, floatW scond, floatW amax, intW info) {
		org.netlib.lapack.Spoequ.spoequ(n, a, 0, lda, s, 0, scond, amax, info);
	}

	@Override
	public void sporfs(String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sporfs.sporfs(uplo, n, nrhs, a, 0, lda, af, 0, ldaf, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sposv(String uplo, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sposv.sposv(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void sposvx(String fact, String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sposvx.sposvx(fact, uplo, n, nrhs, a, 0, lda, af, 0, ldaf, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void spotf2(String uplo, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Spotf2.spotf2(uplo, n, a, 0, lda, info);
	}

	@Override
	public void spotrf(String uplo, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Spotrf.spotrf(uplo, n, a, 0, lda, info);
	}

	@Override
	public void spotri(String uplo, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Spotri.spotri(uplo, n, a, 0, lda, info);
	}

	@Override
	public void spotrs(String uplo, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info) {
		org.netlib.lapack.Spotrs.spotrs(uplo, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void sppcon(String uplo, int n, float[] ap, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sppcon.sppcon(uplo, n, ap, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void sppequ(String uplo, int n, float[] ap, float[] s, floatW scond, floatW amax, intW info) {
		org.netlib.lapack.Sppequ.sppequ(uplo, n, ap, 0, s, 0, scond, amax, info);
	}

	@Override
	public void spprfs(String uplo, int n, int nrhs, float[] ap, float[] afp, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Spprfs.spprfs(uplo, n, nrhs, ap, 0, afp, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sppsv(String uplo, int n, int nrhs, float[] ap, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sppsv.sppsv(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void sppsvx(String fact, String uplo, int n, int nrhs, float[] ap, float[] afp, StringW equed, float[] s, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sppsvx.sppsvx(fact, uplo, n, nrhs, ap, 0, afp, 0, equed, s, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void spptrf(String uplo, int n, float[] ap, intW info) {
		org.netlib.lapack.Spptrf.spptrf(uplo, n, ap, 0, info);
	}

	@Override
	public void spptri(String uplo, int n, float[] ap, intW info) {
		org.netlib.lapack.Spptri.spptri(uplo, n, ap, 0, info);
	}

	@Override
	public void spptrs(String uplo, int n, int nrhs, float[] ap, float[] b, int ldb, intW info) {
		org.netlib.lapack.Spptrs.spptrs(uplo, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void sptcon(int n, float[] d, float[] e, float anorm, floatW rcond, float[] work, intW info) {
		org.netlib.lapack.Sptcon.sptcon(n, d, 0, e, 0, anorm, rcond, work, 0, info);
	}

	@Override
	public void spteqr(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Spteqr.spteqr(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void sptrfs(int n, int nrhs, float[] d, float[] e, float[] df, float[] ef, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, intW info) {
		org.netlib.lapack.Sptrfs.sptrfs(n, nrhs, d, 0, e, 0, df, 0, ef, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, info);
	}

	@Override
	public void sptsv(int n, int nrhs, float[] d, float[] e, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sptsv.sptsv(n, nrhs, d, 0, e, 0, b, 0, ldb, info);
	}

	@Override
	public void sptsvx(String fact, int n, int nrhs, float[] d, float[] e, float[] df, float[] ef, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, intW info) {
		org.netlib.lapack.Sptsvx.sptsvx(fact, n, nrhs, d, 0, e, 0, df, 0, ef, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, info);
	}

	@Override
	public void spttrf(int n, float[] d, float[] e, intW info) {
		org.netlib.lapack.Spttrf.spttrf(n, d, 0, e, 0, info);
	}

	@Override
	public void spttrs(int n, int nrhs, float[] d, float[] e, float[] b, int ldb, intW info) {
		org.netlib.lapack.Spttrs.spttrs(n, nrhs, d, 0, e, 0, b, 0, ldb, info);
	}

	@Override
	public void sptts2(int n, int nrhs, float[] d, float[] e, float[] b, int ldb) {
		org.netlib.lapack.Sptts2.sptts2(n, nrhs, d, 0, e, 0, b, 0, ldb);
	}

	@Override
	public void srscl(int n, float sa, float[] sx, int incx) {
		org.netlib.lapack.Srscl.srscl(n, sa, sx, 0, incx);
	}

	@Override
	public void ssbev(String jobz, String uplo, int n, int kd, float[] ab, int ldab, float[] w, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Ssbev.ssbev(jobz, uplo, n, kd, ab, 0, ldab, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void ssbevd(String jobz, String uplo, int n, int kd, float[] ab, int ldab, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Ssbevd.ssbevd(jobz, uplo, n, kd, ab, 0, ldab, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void ssbevx(String jobz, String range, String uplo, int n, int kd, float[] ab, int ldab, float[] q, int ldq, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Ssbevx.ssbevx(jobz, range, uplo, n, kd, ab, 0, ldab, q, 0, ldq, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssbgst(String vect, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] x, int ldx, float[] work, intW info) {
		org.netlib.lapack.Ssbgst.ssbgst(vect, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, x, 0, ldx, work, 0, info);
	}

	@Override
	public void ssbgv(String jobz, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] w, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Ssbgv.ssbgv(jobz, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void ssbgvd(String jobz, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Ssbgvd.ssbgvd(jobz, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void ssbgvx(String jobz, String range, String uplo, int n, int ka, int kb, float[] ab, int ldab, float[] bb, int ldbb, float[] q, int ldq, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Ssbgvx.ssbgvx(jobz, range, uplo, n, ka, kb, ab, 0, ldab, bb, 0, ldbb, q, 0, ldq, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssbtrd(String vect, String uplo, int n, int kd, float[] ab, int ldab, float[] d, float[] e, float[] q, int ldq, float[] work, intW info) {
		org.netlib.lapack.Ssbtrd.ssbtrd(vect, uplo, n, kd, ab, 0, ldab, d, 0, e, 0, q, 0, ldq, work, 0, info);
	}

	@Override
	public void sspcon(String uplo, int n, float[] ap, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sspcon.sspcon(uplo, n, ap, 0, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void sspev(String jobz, String uplo, int n, float[] ap, float[] w, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Sspev.sspev(jobz, uplo, n, ap, 0, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void sspevd(String jobz, String uplo, int n, float[] ap, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sspevd.sspevd(jobz, uplo, n, ap, 0, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sspevx(String jobz, String range, String uplo, int n, float[] ap, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Sspevx.sspevx(jobz, range, uplo, n, ap, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void sspgst(int itype, String uplo, int n, float[] ap, float[] bp, intW info) {
		org.netlib.lapack.Sspgst.sspgst(itype, uplo, n, ap, 0, bp, 0, info);
	}

	@Override
	public void sspgv(int itype, String jobz, String uplo, int n, float[] ap, float[] bp, float[] w, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Sspgv.sspgv(itype, jobz, uplo, n, ap, 0, bp, 0, w, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void sspgvd(int itype, String jobz, String uplo, int n, float[] ap, float[] bp, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sspgvd.sspgvd(itype, jobz, uplo, n, ap, 0, bp, 0, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sspgvx(int itype, String jobz, String range, String uplo, int n, float[] ap, float[] bp, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Sspgvx.sspgvx(itype, jobz, range, uplo, n, ap, 0, bp, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssprfs(String uplo, int n, int nrhs, float[] ap, float[] afp, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Ssprfs.ssprfs(uplo, n, nrhs, ap, 0, afp, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sspsv(String uplo, int n, int nrhs, float[] ap, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Sspsv.sspsv(uplo, n, nrhs, ap, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sspsvx(String fact, String uplo, int n, int nrhs, float[] ap, float[] afp, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sspsvx.sspsvx(fact, uplo, n, nrhs, ap, 0, afp, 0, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void ssptrd(String uplo, int n, float[] ap, float[] d, float[] e, float[] tau, intW info) {
		org.netlib.lapack.Ssptrd.ssptrd(uplo, n, ap, 0, d, 0, e, 0, tau, 0, info);
	}

	@Override
	public void ssptrf(String uplo, int n, float[] ap, int[] ipiv, intW info) {
		org.netlib.lapack.Ssptrf.ssptrf(uplo, n, ap, 0, ipiv, 0, info);
	}

	@Override
	public void ssptri(String uplo, int n, float[] ap, int[] ipiv, float[] work, intW info) {
		org.netlib.lapack.Ssptri.ssptri(uplo, n, ap, 0, ipiv, 0, work, 0, info);
	}

	@Override
	public void ssptrs(String uplo, int n, int nrhs, float[] ap, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Ssptrs.ssptrs(uplo, n, nrhs, ap, 0, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void sstebz(String range, String order, int n, float vl, float vu, int il, int iu, float abstol, float[] d, float[] e, intW m, intW nsplit, float[] w, int[] iblock, int[] isplit, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Sstebz.sstebz(range, order, n, vl, vu, il, iu, abstol, d, 0, e, 0, m, nsplit, w, 0, iblock, 0, isplit, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void sstedc(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sstedc.sstedc(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sstegr(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sstegr.sstegr(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sstein(int n, float[] d, float[] e, int m, float[] w, int[] iblock, int[] isplit, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Sstein.sstein(n, d, 0, e, 0, m, w, 0, iblock, 0, isplit, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssteqr(String compz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Ssteqr.ssteqr(compz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void ssterf(int n, float[] d, float[] e, intW info) {
		org.netlib.lapack.Ssterf.ssterf(n, d, 0, e, 0, info);
	}

	@Override
	public void sstev(String jobz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, intW info) {
		org.netlib.lapack.Sstev.sstev(jobz, n, d, 0, e, 0, z, 0, ldz, work, 0, info);
	}

	@Override
	public void sstevd(String jobz, int n, float[] d, float[] e, float[] z, int ldz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sstevd.sstevd(jobz, n, d, 0, e, 0, z, 0, ldz, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sstevr(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Sstevr.sstevr(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void sstevx(String jobz, String range, int n, float[] d, float[] e, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Sstevx.sstevx(jobz, range, n, d, 0, e, 0, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssycon(String uplo, int n, float[] a, int lda, int[] ipiv, float anorm, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Ssycon.ssycon(uplo, n, a, 0, lda, ipiv, 0, anorm, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void ssyev(String jobz, String uplo, int n, float[] a, int lda, float[] w, float[] work, int lwork, intW info) {
		org.netlib.lapack.Ssyev.ssyev(jobz, uplo, n, a, 0, lda, w, 0, work, 0, lwork, info);
	}

	@Override
	public void ssyevd(String jobz, String uplo, int n, float[] a, int lda, float[] w, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Ssyevd.ssyevd(jobz, uplo, n, a, 0, lda, w, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void ssyevr(String jobz, String range, String uplo, int n, float[] a, int lda, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, int[] isuppz, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Ssyevr.ssyevr(jobz, range, uplo, n, a, 0, lda, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, isuppz, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void ssyevx(String jobz, String range, String uplo, int n, float[] a, int lda, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Ssyevx.ssyevx(jobz, range, uplo, n, a, 0, lda, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssygs2(int itype, String uplo, int n, float[] a, int lda, float[] b, int ldb, intW info) {
		org.netlib.lapack.Ssygs2.ssygs2(itype, uplo, n, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void ssygst(int itype, String uplo, int n, float[] a, int lda, float[] b, int ldb, intW info) {
		org.netlib.lapack.Ssygst.ssygst(itype, uplo, n, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void ssygv(int itype, String jobz, String uplo, int n, float[] a, int lda, float[] b, int ldb, float[] w, float[] work, int lwork, intW info) {
		org.netlib.lapack.Ssygv.ssygv(itype, jobz, uplo, n, a, 0, lda, b, 0, ldb, w, 0, work, 0, lwork, info);
	}

	@Override
	public void ssygvd(int itype, String jobz, String uplo, int n, float[] a, int lda, float[] b, int ldb, float[] w, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Ssygvd.ssygvd(itype, jobz, uplo, n, a, 0, lda, b, 0, ldb, w, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void ssygvx(int itype, String jobz, String range, String uplo, int n, float[] a, int lda, float[] b, int ldb, float vl, float vu, int il, int iu, float abstol, intW m, float[] w, float[] z, int ldz, float[] work, int lwork, int[] iwork, int[] ifail, intW info) {
		org.netlib.lapack.Ssygvx.ssygvx(itype, jobz, range, uplo, n, a, 0, lda, b, 0, ldb, vl, vu, il, iu, abstol, m, w, 0, z, 0, ldz, work, 0, lwork, iwork, 0, ifail, 0, info);
	}

	@Override
	public void ssyrfs(String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Ssyrfs.ssyrfs(uplo, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void ssysv(String uplo, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, float[] work, int lwork, intW info) {
		org.netlib.lapack.Ssysv.ssysv(uplo, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, work, 0, lwork, info);
	}

	@Override
	public void ssysvx(String fact, String uplo, int n, int nrhs, float[] a, int lda, float[] af, int ldaf, int[] ipiv, float[] b, int ldb, float[] x, int ldx, floatW rcond, float[] ferr, float[] berr, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Ssysvx.ssysvx(fact, uplo, n, nrhs, a, 0, lda, af, 0, ldaf, ipiv, 0, b, 0, ldb, x, 0, ldx, rcond, ferr, 0, berr, 0, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void ssytd2(String uplo, int n, float[] a, int lda, float[] d, float[] e, float[] tau, intW info) {
		org.netlib.lapack.Ssytd2.ssytd2(uplo, n, a, 0, lda, d, 0, e, 0, tau, 0, info);
	}

	@Override
	public void ssytf2(String uplo, int n, float[] a, int lda, int[] ipiv, intW info) {
		org.netlib.lapack.Ssytf2.ssytf2(uplo, n, a, 0, lda, ipiv, 0, info);
	}

	@Override
	public void ssytrd(String uplo, int n, float[] a, int lda, float[] d, float[] e, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Ssytrd.ssytrd(uplo, n, a, 0, lda, d, 0, e, 0, tau, 0, work, 0, lwork, info);
	}

	@Override
	public void ssytrf(String uplo, int n, float[] a, int lda, int[] ipiv, float[] work, int lwork, intW info) {
		org.netlib.lapack.Ssytrf.ssytrf(uplo, n, a, 0, lda, ipiv, 0, work, 0, lwork, info);
	}

	@Override
	public void ssytri(String uplo, int n, float[] a, int lda, int[] ipiv, float[] work, intW info) {
		org.netlib.lapack.Ssytri.ssytri(uplo, n, a, 0, lda, ipiv, 0, work, 0, info);
	}

	@Override
	public void ssytrs(String uplo, int n, int nrhs, float[] a, int lda, int[] ipiv, float[] b, int ldb, intW info) {
		org.netlib.lapack.Ssytrs.ssytrs(uplo, n, nrhs, a, 0, lda, ipiv, 0, b, 0, ldb, info);
	}

	@Override
	public void stbcon(String norm, String uplo, String diag, int n, int kd, float[] ab, int ldab, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Stbcon.stbcon(norm, uplo, diag, n, kd, ab, 0, ldab, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void stbrfs(String uplo, String trans, String diag, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Stbrfs.stbrfs(uplo, trans, diag, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void stbtrs(String uplo, String trans, String diag, int n, int kd, int nrhs, float[] ab, int ldab, float[] b, int ldb, intW info) {
		org.netlib.lapack.Stbtrs.stbtrs(uplo, trans, diag, n, kd, nrhs, ab, 0, ldab, b, 0, ldb, info);
	}

	@Override
	public void stgevc(String side, String howmny, boolean[] select, int n, float[] s, int lds, float[] p, int ldp, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, intW info) {
		org.netlib.lapack.Stgevc.stgevc(side, howmny, select, 0, n, s, 0, lds, p, 0, ldp, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, info);
	}

	@Override
	public void stgex2(boolean wantq, boolean wantz, int n, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, int j1, int n1, int n2, float[] work, int lwork, intW info) {
		org.netlib.lapack.Stgex2.stgex2(wantq, wantz, n, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, j1, n1, n2, work, 0, lwork, info);
	}

	@Override
	public void stgexc(boolean wantq, boolean wantz, int n, float[] a, int lda, float[] b, int ldb, float[] q, int ldq, float[] z, int ldz, intW ifst, intW ilst, float[] work, int lwork, intW info) {
		org.netlib.lapack.Stgexc.stgexc(wantq, wantz, n, a, 0, lda, b, 0, ldb, q, 0, ldq, z, 0, ldz, ifst, ilst, work, 0, lwork, info);
	}

	@Override
	public void stgsen(int ijob, boolean wantq, boolean wantz, boolean[] select, int n, float[] a, int lda, float[] b, int ldb, float[] alphar, float[] alphai, float[] beta, float[] q, int ldq, float[] z, int ldz, intW m, floatW pl, floatW pr, float[] dif, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Stgsen.stgsen(ijob, wantq, wantz, select, 0, n, a, 0, lda, b, 0, ldb, alphar, 0, alphai, 0, beta, 0, q, 0, ldq, z, 0, ldz, m, pl, pr, dif, 0, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void stgsja(String jobu, String jobv, String jobq, int m, int p, int n, int k, int l, float[] a, int lda, float[] b, int ldb, float tola, float tolb, float[] alpha, float[] beta, float[] u, int ldu, float[] v, int ldv, float[] q, int ldq, float[] work, intW ncycle, intW info) {
		org.netlib.lapack.Stgsja.stgsja(jobu, jobv, jobq, m, p, n, k, l, a, 0, lda, b, 0, ldb, tola, tolb, alpha, 0, beta, 0, u, 0, ldu, v, 0, ldv, q, 0, ldq, work, 0, ncycle, info);
	}

	@Override
	public void stgsna(String job, String howmny, boolean[] select, int n, float[] a, int lda, float[] b, int ldb, float[] vl, int ldvl, float[] vr, int ldvr, float[] s, float[] dif, int mm, intW m, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Stgsna.stgsna(job, howmny, select, 0, n, a, 0, lda, b, 0, ldb, vl, 0, ldvl, vr, 0, ldvr, s, 0, dif, 0, mm, m, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void stgsy2(String trans, int ijob, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, float[] d, int ldd, float[] e, int lde, float[] f, int ldf, floatW scale, floatW rdsum, floatW rdscal, int[] iwork, intW pq, intW info) {
		org.netlib.lapack.Stgsy2.stgsy2(trans, ijob, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, d, 0, ldd, e, 0, lde, f, 0, ldf, scale, rdsum, rdscal, iwork, 0, pq, info);
	}

	@Override
	public void stgsyl(String trans, int ijob, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, float[] d, int ldd, float[] e, int lde, float[] f, int ldf, floatW scale, floatW dif, float[] work, int lwork, int[] iwork, intW info) {
		org.netlib.lapack.Stgsyl.stgsyl(trans, ijob, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, d, 0, ldd, e, 0, lde, f, 0, ldf, scale, dif, work, 0, lwork, iwork, 0, info);
	}

	@Override
	public void stpcon(String norm, String uplo, String diag, int n, float[] ap, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Stpcon.stpcon(norm, uplo, diag, n, ap, 0, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void stprfs(String uplo, String trans, String diag, int n, int nrhs, float[] ap, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Stprfs.stprfs(uplo, trans, diag, n, nrhs, ap, 0, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void stptri(String uplo, String diag, int n, float[] ap, intW info) {
		org.netlib.lapack.Stptri.stptri(uplo, diag, n, ap, 0, info);
	}

	@Override
	public void stptrs(String uplo, String trans, String diag, int n, int nrhs, float[] ap, float[] b, int ldb, intW info) {
		org.netlib.lapack.Stptrs.stptrs(uplo, trans, diag, n, nrhs, ap, 0, b, 0, ldb, info);
	}

	@Override
	public void strcon(String norm, String uplo, String diag, int n, float[] a, int lda, floatW rcond, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Strcon.strcon(norm, uplo, diag, n, a, 0, lda, rcond, work, 0, iwork, 0, info);
	}

	@Override
	public void strevc(String side, String howmny, boolean[] select, int n, float[] t, int ldt, float[] vl, int ldvl, float[] vr, int ldvr, int mm, intW m, float[] work, intW info) {
		org.netlib.lapack.Strevc.strevc(side, howmny, select, 0, n, t, 0, ldt, vl, 0, ldvl, vr, 0, ldvr, mm, m, work, 0, info);
	}

	@Override
	public void strexc(String compq, int n, float[] t, int ldt, float[] q, int ldq, intW ifst, intW ilst, float[] work, intW info) {
		org.netlib.lapack.Strexc.strexc(compq, n, t, 0, ldt, q, 0, ldq, ifst, ilst, work, 0, info);
	}

	@Override
	public void strrfs(String uplo, String trans, String diag, int n, int nrhs, float[] a, int lda, float[] b, int ldb, float[] x, int ldx, float[] ferr, float[] berr, float[] work, int[] iwork, intW info) {
		org.netlib.lapack.Strrfs.strrfs(uplo, trans, diag, n, nrhs, a, 0, lda, b, 0, ldb, x, 0, ldx, ferr, 0, berr, 0, work, 0, iwork, 0, info);
	}

	@Override
	public void strsen(String job, String compq, boolean[] select, int n, float[] t, int ldt, float[] q, int ldq, float[] wr, float[] wi, intW m, floatW s, floatW sep, float[] work, int lwork, int[] iwork, int liwork, intW info) {
		org.netlib.lapack.Strsen.strsen(job, compq, select, 0, n, t, 0, ldt, q, 0, ldq, wr, 0, wi, 0, m, s, sep, work, 0, lwork, iwork, 0, liwork, info);
	}

	@Override
	public void strsna(String job, String howmny, boolean[] select, int n, float[] t, int ldt, float[] vl, int ldvl, float[] vr, int ldvr, float[] s, float[] sep, int mm, intW m, float[] work, int ldwork, int[] iwork, intW info) {
		org.netlib.lapack.Strsna.strsna(job, howmny, select, 0, n, t, 0, ldt, vl, 0, ldvl, vr, 0, ldvr, s, 0, sep, 0, mm, m, work, 0, ldwork, iwork, 0, info);
	}

	@Override
	public void strsyl(String trana, String tranb, int isgn, int m, int n, float[] a, int lda, float[] b, int ldb, float[] c, int Ldc, floatW scale, intW info) {
		org.netlib.lapack.Strsyl.strsyl(trana, tranb, isgn, m, n, a, 0, lda, b, 0, ldb, c, 0, Ldc, scale, info);
	}

	@Override
	public void strti2(String uplo, String diag, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Strti2.strti2(uplo, diag, n, a, 0, lda, info);
	}

	@Override
	public void strtri(String uplo, String diag, int n, float[] a, int lda, intW info) {
		org.netlib.lapack.Strtri.strtri(uplo, diag, n, a, 0, lda, info);
	}

	@Override
	public void strtrs(String uplo, String trans, String diag, int n, int nrhs, float[] a, int lda, float[] b, int ldb, intW info) {
		org.netlib.lapack.Strtrs.strtrs(uplo, trans, diag, n, nrhs, a, 0, lda, b, 0, ldb, info);
	}

	@Override
	public void stzrqf(int m, int n, float[] a, int lda, float[] tau, intW info) {
		org.netlib.lapack.Stzrqf.stzrqf(m, n, a, 0, lda, tau, 0, info);
	}

	@Override
	public void stzrzf(int m, int n, float[] a, int lda, float[] tau, float[] work, int lwork, intW info) {
		org.netlib.lapack.Stzrzf.stzrzf(m, n, a, 0, lda, tau, 0, work, 0, lwork, info);
	}

	@Override
	public double dlamch(String cmach) {
		return org.netlib.lapack.Dlamch.dlamch(cmach);
	}

	@Override
	public void dlamc1(intW beta, intW t, booleanW rnd, booleanW ieee1) {
		org.netlib.lapack.Dlamc1.dlamc1(beta, t, rnd, ieee1);
	}

	@Override
	public void dlamc2(intW beta, intW t, booleanW rnd, doubleW eps, intW emin, doubleW rmin, intW emax, doubleW rmax) {
		org.netlib.lapack.Dlamc2.dlamc2(beta, t, rnd, eps, emin, rmin, emax, rmax);
	}

	@Override
	public void dlamc4(intW emin, double start, int base) {
		org.netlib.lapack.Dlamc4.dlamc4(emin, start, base);
	}

	@Override
	public void dlamc5(int beta, int p, int emin, boolean ieee, intW emax, doubleW rmax) {
		org.netlib.lapack.Dlamc5.dlamc5(beta, p, emin, ieee, emax, rmax);
	}

	@Override
	public void slamc1(intW beta, intW t, booleanW rnd, booleanW ieee1) {
		org.netlib.lapack.Slamc1.slamc1(beta, t, rnd, ieee1);
	}

	@Override
	public void slamc2(intW beta, intW t, booleanW rnd, floatW eps, intW emin, floatW rmin, intW emax, floatW rmax) {
		org.netlib.lapack.Slamc2.slamc2(beta, t, rnd, eps, emin, rmin, emax, rmax);
	}

	@Override
	public void slamc4(intW emin, float start, int base) {
		org.netlib.lapack.Slamc4.slamc4(emin, start, base);
	}

	@Override
	public void slamc5(int beta, int p, int emin, boolean ieee, intW emax, floatW rmax) {
		org.netlib.lapack.Slamc5.slamc5(beta, p, emin, ieee, emax, rmax);
	}

}
