/* NVTV GUI (CRTC I810 part) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: gui_i810.c,v 1.4 2003/02/04 22:09:48 dthierbach Exp $
 *
 * Contents:
 *
 * The GTK graphical user interface. CRTC I810 part.
 */

#include "local.h" /* before everything else */

#include <gtk/gtk.h>

#include "gui.h"
#include "gui_i810.h"
#include "backend.h"

#define FIELD(b,m) addr:&(b.m), size:sizeof(b.m)
#define FIELD_CRT(m) FIELD(gui_regs.crtc.i810,m)

static GuiRegMask i810_mask_reg [] = {
  {label:"*HDisplay:",   bits:11, tick:1, FIELD_CRT(tvHDisplay)}, 
  {label:"*HSyncStart:", bits:12, tick:1, FIELD_CRT(tvHSyncStart)}, 
  {label:"*HSyncEnd:",   bits:12, tick:1, FIELD_CRT(tvHSyncEnd)}, 
  {label:"*HTotal:",     bits:12, tick:1, FIELD_CRT(tvHTotal)}, 
  {label:"*VDisplay:",   bits:11, tick:1, FIELD_CRT(tvVDisplay)}, 
  {label:"*VSyncStart:", bits:12, tick:1, FIELD_CRT(tvVSyncStart)},  
  {label:"*VSyncEnd:",   bits:12, tick:1, FIELD_CRT(tvVSyncEnd)},    
  {label:"*VTotal:",     bits:12, tick:1, FIELD_CRT(tvVTotal)},      
  {label:"borderRed:",   bits:8,  tick:1, FIELD_CRT(borderRed)},      
  {label:"borderGreen:", bits:8,  tick:1, FIELD_CRT(borderGreen)},
  {label:"borderBlue:",  bits:8,  tick:1, FIELD_CRT(borderBlue)},
  {label:NULL }
};

static GuiFlagMask i810_mask_flag [] = {
  {label:NULL }
};

GtkWidget *gui_i810_page (void)
{
  GtkAccelGroup *gui_i810_reg_accel_group;

  gui_i810_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("CRTC I810 Register Values", 
    gui_i810_reg_accel_group, PRINT_CRT_REGS,
    GTK_OBJECT (update_crt), GTK_SIGNAL_FUNC (gui_reset_crt_cb),
    0, 0, 8, i810_mask_reg, 0, 11, NULL, 6, 0, 11, i810_mask_flag);

#if 0 /* FIXME */
  button = gtk_button_new_with_label ("Check");
  gtk_widget_set_sensitive (GTK_WIDGET (button), FALSE);
  /* check if registers are "sane", correct if necessary */
  gtk_table_attach(GTK_TABLE(page), button, 2,3,1,2,
    GTK_FILL, GTK_FILL, 0, 0);
#endif
}

  
