      SUBROUTINE tce_mo2e_incore_2eorb(rtdb,d_v2,
     1                                kax_v2_alpha_offset,
     1                                size_2e)
C     $Id$
C     This is a Fortran77 program generated by Tensor Contraction Engine v.1.0
C     Copyright (c) Battelle & Pacific Northwest National Laboratory (2002)
C     t ( p1 p2 h3 h4 )_t
      IMPLICIT NONE
#include "rtdb.fh"
#include "global.fh"
#include "mafdecls.fh"
#include "stdio.fh"
#include "util.fh"
#include "bas.fh"
#include "schwarz.fh"
#include "sym.fh"
#include "sf.fh"
#include "errquit.fh"
#include "tce.fh"
#include "tce_main.fh"
c
c
      integer rtdb                 ! Run-time database
      integer d_v2                 ! MO integrals
      integer kax_v2_alpha_offset  ! MO integrals offset
      integer size_2e              ! 2e file size
      integer size
c
      INTEGER size_2g2a,l_2g2a,k_2g2a
      INTEGER azone1,azone2,azone3,azone4
      INTEGER g1b,g2b,g3b,g4b
      INTEGER igi1,igi2,igi3,igi4
      INTEGER ii,i,j,k,l,N,ipos1,ipos2,ipos3,ipos4
      INTEGER del1,del2,p1rel,p2rel
      INTEGER size_4a,l_4a,k_4a
c
      integer mu,nu,rho,sigma
      integer mu_lo,mu_hi
      integer nu_lo,nu_hi
      integer rho_lo,rho_hi
      integer sigma_lo,sigma_hi
      integer mu_range
      integer nu_range
      integer rho_range
      integer sigma_range
      integer mu1,nu1,rho1,sigma1
      integer shift_mu,shift_nu
      integer shift_rho,shift_sigma
      integer work1,work2          ! Work array sizes
      integer l_work1,k_work1      ! Work array 1
      integer l_work2,k_work2      ! Work array 2
      integer imu1,inu1,irho1,isigma1
c
      integer l_movecs_orb,k_movecs_orb
      integer l_gpair,k_gpair
      integer len_pair,g12_shift
c ATTENTION,ACHTUNG,UWAGA 2000 - max # of CPU
c
      integer size_2g2z,l_2g2z,k_2g2z
      integer tot_azone1_sh,tot_azone2_sh
      integer tot_azone3_sh,tot_azone4_sh
      integer ixi,jxi,point_pair
c
      integer iha,ihb !number of corr. alpha, beta holes
      integer ipa,ipb !number of corr. alpha, beta particles
c compression
      integer max_size_temp,size_temp,sumx
c      double precision wall,cpu,wall1,cpu1,wall2,cpu2,wall3,cpu3
      double precision cpu_clock(0:9),wall_clock(0:9)
c
      double precision tot_zone(1000)
c
      integer l_3a1m_offset,k_3a1m_offset,size_3a1mf
      integer l_1a3m_offset,k_1a3m_offset,size_1a3mf
      integer d_1a3m,d_3a1m
      integer size_3a1m
      integer l_3a1m,k_3a1m
      integer size_amc
      integer key_3a1m,offset_3a1m
      integer l_4a_sort,k_4a_sort
      integer size_2a2m,l_2a2m,k_2a2m
      integer l_3a1m_sort,k_3a1m_sort
      integer l_2a2m_aux,k_2a2m_aux
      integer key_1a3m,offset_1a3m
      integer l_1a3m,k_1a3m,size_1a3m
      integer l_1a3m_sort,k_1a3m_sort
      INTEGER IROW,ICOL,IRES
      INTEGER INDEX_PAIR
      integer l_4m,k_4m,size_4m,key_4m,offset_4m
      integer sf3a1m_chunk,sf1a3m_chunk
c
      integer l_integral,l_coeff
      integer k_integral,k_coeff
      integer size_ic,size_icc,size_integral,size_coeff,max_na
c
      integer l_4af_offset,k_4af_offset,d_4af
      integer k_2a2m_offset,l_2a2m_offset
      integer sf_chunk,request
      integer key_4af,offset_4af,size_4af
      integer sf2a2m_chunk,key_2a2m,offset_2a2m
      integer d_2a2m,size_2a2mf
      character*255 filename
c
      integer size_max1,size_max2,ip_max1,ip_max2
      integer chunk_max1,chunk_max2,i_from_x,i_to_x
      integer isizef(5),imaxch(5)
      integer d_max1,d_max2
c
      integer l_a4_offset,k_a4_offset
      integer offset_bl4a,size_bl4a,a4_ini,a4_fin
      integer offset_ismall,length_a4,key_ini
      integer l_a3_offset,k_a3_offset
      integer length_a3,offset_bl3a1m,size_bl3a1m
      integer size_3a1mi,a3_ini,a3_fin
c
      integer l_a2_offset,k_a2_offset,length_a2
      integer offset_bl2a2m,size_bl2a2m,a2_ini,a2_fin
      integer size_1a3mi,size_2a2mi
c
      integer length_a1
      integer l_a1_offset,k_a1_offset
      integer offset_bl1a3m,size_bl1a3m,a1_ini,a1_fin
c I/O improvements
      integer handle_4a,handle_3a1m,handle_2a2m,handle_1a3m
c new offseting fro 13 and 14
      integer k_aux,l_aux,size_aux
c *** debug ***
      double precision xxx,xmax
c      integer iqx
      integer ierrcode1,ierrcode2
c *************
c
      logical parallel
c
      INTEGER length
      INTEGER next
      INTEGER nprocs
      INTEGER count
      integer nxtask
      external nxtask
      logical nodezero
      parallel = .true.

      cpu_clock(0)  = -util_cpusec()
      wall_clock(0) = -util_wallsec()

      max_size_temp=imaxsize**4
c
      call tce_mo2e_offset_intorb_old(l_aux,
     &         k_aux,size_aux)
c
      do ii=1,1000
       tot_zone(ii)=0.0d0
      enddo
      if(atpart.gt.1000)
     &  call errquit('tce_zones: atpart too big',1,MA_ERR)
      sumx=0
      do ii=1,atpart
       tot_zone(ii)=sumx
       sumx=sumx+nalength(ii)
      enddo
c
      nodezero=(ga_nodeid().eq.0)
c
c this module is called only if intorb = .true.
c N is the number of correlated orbitals
        N = nmo(1) - nfc(1) - nfv(1)
        iha = nocc(1)-nfc(1)
        ihb = nocc(ipol)-nfc(ipol)
        ipa = nmo(1)-nocc(1)-nfv(1)
        ipb = nmo(ipol)-nocc(ipol)-nfv(ipol)
c
      sf_chunk=(imaxsize+10)**4
      sf3a1m_chunk=((imaxsize+10)**3)*tile_dim
      sf2a2m_chunk=((tile_dim)**2)*((imaxsize+10)**2)
      sf1a3m_chunk=((tile_dim)**3)*(imaxsize+10)
c
c l_integral and l_coeff local files are opened here
c ATTENTION,ACHTUNG,UWAGA - "manually" defined
cc      size_ic=2*(imaxsize+10)**4
cc      size_ic=2*(imaxsize)**4
      max_na=0
      do ixi=1,atpart
       if(nalength(ixi).gt.max_na) max_na=nalength(ixi)
      enddo
c     it was
cc      size_ic=2*(max_na)**4+1
c     it is
        size_ic=2*((max_na)**4)+1
        size_icc=tile_dim*max_na
c
       if(nodezero) then
        write(6,*)'2_EL_BATCH AND COEFF MATRIX'
c        write(6,1000)'size_ic   ',size_ic
c        write(6,1000)'size_icc  ',size_icc
        write(6,1000)'tile_dim  ',tile_dim
        write(6,1000)'max_na    ',max_na
        call util_flush(6)
       end if
c
      if (.not.ma_push_get(mt_dbl,size_ic,'l_int',
     1  l_integral,k_integral))
     1  call errquit('tce_4s: MA problem l_int',0,MA_ERR)
c
      if (.not.ma_push_get(mt_dbl,size_icc,'l_coeff',
     1  l_coeff,k_coeff))
     1  call errquit('tce_4s: MA problem l_coeff',0,MA_ERR)
c
       call tce_4a_offsetx1(l_4af_offset,k_4af_offset,size_4af)
       call tce_3a1m_offsetx1(l_3a1m_offset,k_3a1m_offset,size_3a1mf)
       call tce_2a2m_offsetx1(l_2a2m_offset,k_2a2m_offset,size_2a2mf)
       call tce_1a3m_offsetx1(l_1a3m_offset,k_1a3m_offset,size_1a3mf)
c
c choose two largeast size_4af,size_3a1mf,size_2a2mf,size_1a3mf,size_2e
c size_max1 > size_max2
       size_max1=0
       size_max2=0
c
       chunk_max1=0
       chunk_max2=0
c
       isizef(1)=size_4af
       isizef(2)=size_3a1mf
       isizef(3)=size_2a2mf
       isizef(4)=size_1a3mf
       isizef(5)=size_2e
c
       imaxch(1)=sf_chunk
       imaxch(2)=sf3a1m_chunk
       imaxch(3)=sf2a2m_chunk
       imaxch(4)=sf1a3m_chunk
       imaxch(5)=tile_dim**4
c
       do i=1,5
        if(isizef(i).gt.size_max1) then
         size_max1=isizef(i)
         ip_max1=i
         chunk_max1=imaxch(i)
        end if
       enddo
       do i=1,5
       if(i.eq.ip_max1) go to 771
        if(isizef(i).gt.size_max2) then
         size_max2=isizef(i)
         ip_max2=i
         chunk_max2=imaxch(i)
        end if
  771  continue
       enddo
c
c CHUNK_SIZE IS PROPERLY DEFINED HERE
c
       chunk_max1=size_ic
       chunk_max2=size_ic
c
c
c
       if(nodezero) then
        write(6,*)'INTERMEDIATE FILES'
        write(6,1000)'size_4af    ',size_4af
        write(6,1000)'size_3a1mf  ',size_3a1mf
        write(6,1000)'size_2a2mf  ',size_2a2mf
        write(6,1000)'size_1a3mf  ',size_1a3mf
        write(6,1000)'size_2e     ',size_2e
       end if
c
        if(parallel) call ga_sync()
c
c alpha orbitals only
c
      if (.not.ma_push_get(mt_dbl,nbf*(iha+ipa)
     1  ,"sorted MO coeffs",
     2  l_movecs_orb,k_movecs_orb))
     3  call errquit('tce_mo2e_zone: MA problem 1',0,
     2    BASIS_ERR)
      call dfill(nbf*(iha+ipa),0.0d0, dbl_mb(k_movecs_orb), 1)
      do i=1,iha
      do isigma1=1,nbf
       dbl_mb(k_movecs_orb+(i-1)*nbf+isigma1-1)=
     & dbl_mb(k_movecs_sorted+(i-1)*nbf+isigma1-1)
      enddo
      enddo
      do i=iha+1,iha+ipa
      do isigma1=1,nbf
       dbl_mb(k_movecs_orb+(i-1)*nbf+isigma1-1)=
     & dbl_mb(k_movecs_sorted+(i+ihb-1)*nbf+isigma1-1)
      enddo
      enddo
c
c
      call int_mem_2e4c(work1,work2)
      if (.not.ma_push_get(mt_dbl,work1,'work1',l_work1,k_work1))
     1  call errquit('tce_ao2e: MA problem work1',0,MA_ERR)
      if (.not.ma_push_get(mt_dbl,work2,'work2',l_work2,k_work2))
     1  call errquit('tce_ao2e: MA problem work2',1,MA_ERR)
c
c 4af file formed here
c
        call util_file_name('4af',.false.,.false.,filename)
        size = size_4af
        if (.not.ga_create(mt_dbl,size,1,filename,-1,1,handle_4a)) then
          write(LuOut,*) ' available GA memory ',ga_memory_avail(),
     1                   ' bytes'
          call errquit ('tce_mo2e_incore_2eorb: failed ga_create size=',
     1                  size,GA_ERR)
        endif
        i_to_x=handle_4a
c
      cpu_clock(0)  = cpu_clock(0)+util_cpusec()
      wall_clock(0) = wall_clock(0)+util_wallsec()
      if (nodezero) then
         write(LuOut,9480) 'setup',cpu_clock(0),wall_clock(0)
         call util_flush(LuOut)
      endif
      cpu_clock(1)  = -util_cpusec()
      wall_clock(1) = -util_wallsec()
c
      nprocs = GA_NNODES()
      count = 0
      next = NXTASK(nprocs, 1)
      DO azone1 = 1,atpart      !nu
      DO azone2 = azone1,atpart !mu
      DO azone3 = 1,atpart      !sigma
      DO azone4 = azone3,atpart !rho
      IF (next.eq.count) THEN
c ---------------------------
        size_4a = nalength(azone1)*nalength(azone2)*
     1            nalength(azone3)*nalength(azone4)
        if(.not.ma_push_get(mt_dbl,size_4a,'4a',l_4a,k_4a))
     1     call errquit('tce_4af_zones1: MA problem',0,MA_ERR)
        call dfill(size_4a, 0.0d0, dbl_mb(k_4a), 1)
         shift_mu = 0
         do mu    = a2length(azone2)+1,a2length(azone2+1)
            if (.not.bas_cn2bfr(ao_bas_han,mu,mu_lo,mu_hi))
     1      call errquit('tce_ao2e: basis fn range problem 1',0,
     2      BASIS_ERR)
            mu_range = mu_hi - mu_lo + 1
         shift_nu = 0
         do nu    = a2length(azone1)+1,a2length(azone1+1)
            if (.not.bas_cn2bfr(ao_bas_han,nu,nu_lo,nu_hi))
     1      call errquit('tce_ao2e: basis fn range problem 1',0,
     2      BASIS_ERR)
            nu_range = nu_hi - nu_lo + 1
         shift_rho = 0
         do rho   = a2length(azone4)+1,a2length(azone4+1)
            if (.not.bas_cn2bfr(ao_bas_han,rho,rho_lo,rho_hi))
     1      call errquit('tce_ao2e: basis fn range problem 1',0,
     2      BASIS_ERR)
            rho_range = rho_hi - rho_lo + 1
         shift_sigma = 0
         do sigma = a2length(azone3)+1,a2length(azone3+1)
            if (.not.bas_cn2bfr(ao_bas_han,sigma,sigma_lo,sigma_hi))
     1      call errquit('tce_ao2e: basis fn range problem 1',0,
     2      BASIS_ERR)
            sigma_range = sigma_hi - sigma_lo + 1
            if (schwarz_shell(rho,sigma)*schwarz_shell(mu,nu)
     1          .ge. tol2e) then
            call int_2e4c(ao_bas_han,mu,nu,ao_bas_han,rho,sigma,
     1           work2,dbl_mb(k_work2),work1,dbl_mb(k_work1))
            i=0
             do mu1     = 1,mu_range
             do nu1     = 1,nu_range
             do rho1    = 1,rho_range
             do sigma1  = 1,sigma_range
            i=i+1
            inu1=nu1+shift_nu
            isigma1=sigma1+shift_sigma
            imu1=mu1+shift_mu
            irho1=rho1+shift_rho
            ipos1=(((inu1-1)*nalength(azone2)+imu1-1)*
     1            nalength(azone3)+isigma1-1)*nalength(azone4)
     2            +irho1
            dbl_mb(k_4a+ipos1-1)=dbl_mb(k_work1+i-1)
            enddo
            enddo
            enddo
            enddo
            end if !schwarz  screening
         shift_sigma = shift_sigma + sigma_range
         enddo !sigma
         shift_rho   = shift_rho + rho_range
         enddo !rho
         shift_nu    = shift_nu + nu_range
         enddo !nu
         shift_mu    = shift_mu + mu_range
         enddo !mu
c
         key_4af=azone4 - 1 + atpart * (azone3 - 1 +
     &          atpart * (azone2 - 1 + atpart * (azone1 - 1)))
         call tce_hash(int_mb(k_4af_offset),key_4af,offset_4af)
         call ga_put(i_to_x,offset_4af+1,offset_4af+size_4a,1,1,
     1               dbl_mb(k_4a),1)
c closing l_4a file
        if (.not.ma_pop_stack(l_4a))
     1   call errquit('tce_mo2e_4af2: l_4a',15,MA_ERR)
c ---------------------------
      next = NXTASK(nprocs, 1)
      END IF
      count = count + 1
      ENDDO !azone4
      ENDDO !azone3
      ENDDO !azone2
      ENDDO !azone1
c
c
      call ga_sync()
      next = nxtask(-nprocs,1)
c
      cpu_clock(1)  = cpu_clock(1)+util_cpusec()
      wall_clock(1) = wall_clock(1)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'step 1',cpu_clock(1),wall_clock(1)
        call util_flush(LuOut)
      endif
      cpu_clock(2)  = -util_cpusec()
      wall_clock(2) = -util_wallsec()
c
c
c
c
      if(nodezero) then
        write(6,*)'STEP2 4index'
        call util_flush(6)
      end if
c
c closing/reopening handle_4a file
c opening handle_3a1m file
c
        call util_file_name('3a1mf',.false.,.false.,filename)
        size = size_3a1mf
        if(.not.ga_create(mt_dbl,size,1,filename,-1,1,handle_3a1m)) then
          write(LuOut,*) ' available GA memory ',ga_memory_avail(),
     1                   ' bytes'
          call errquit ('tce_mo2e_incore_2eorb: failed ga_create size=',
     1                  size,GA_ERR)
        endif
        i_from_x=handle_4a
        i_to_x=handle_3a1m
c
      cpu_clock(2)  = cpu_clock(2)+util_cpusec()
      wall_clock(2) = wall_clock(2)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'setup',cpu_clock(2),wall_clock(2)
        call util_flush(LuOut)
      endif
      cpu_clock(3)  = -util_cpusec()
      wall_clock(3) = -util_wallsec()
c
c 3A1M part here
c
      nprocs = GA_NNODES()
      count = 0
      next = NXTASK(nprocs, 1)
c
      DO azone1 = 1,atpart      !nu
      DO azone2 = azone1,atpart !mu
      DO g4b = 1,noa+nva        !k
      DO azone3 = 1,atpart      !sigma
c
      IF (next.eq.count) THEN
c
      size_3a1m=int_mb(k_range_alpha+g4b-1)
     1          *nalength(azone1)*nalength(azone2)*nalength(azone3)
      if (.not.ma_push_get(mt_dbl,size_3a1m,'3a1m',l_3a1m,k_3a1m))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
      call dfill(size_3a1m, 0.0d0, dbl_mb(k_3a1m), 1)
      call a4_offset(azone1,azone2,azone3,size_ic,
     &           l_a4_offset,k_a4_offset)
c
      length_a4=int_mb(k_a4_offset)
      DO ii=1,length_a4
       a4_ini      = int_mb(k_a4_offset+ii)
       a4_fin      = int_mb(k_a4_offset+length_a4+ii)
       key_ini=a4_ini - 1 + atpart * (azone3 - 1 +
     &          atpart * (azone2 - 1 + atpart * (azone1 - 1)))
       call tce_hash(int_mb(k_4af_offset),key_ini,offset_bl4a)
c
       size_bl4a   = int_mb(k_a4_offset+2*length_a4+ii)
        call ga_get(i_from_x,offset_bl4a+1,offset_bl4a+size_bl4a,1,1,
     1    dbl_mb(k_integral),1)
c
      offset_ismall=0
      do i=a4_ini,a4_fin ! over small i ------------------
      tot_azone4_sh=tot_zone(i)
      j=0
      do irho1   =  1,nalength(i)
      do igi4=1,int_mb(k_range_alpha+g4b-1)
       j=j+1
       ipos1=(int_mb(k_offset_alpha+g4b-1)+igi4-1)*nbf+tot_azone4_sh
     &       +irho1
       dbl_mb(k_coeff+j-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c C(g4b irho)* v(irho,isigma,imu,inu)
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g4b-1),
     &   nalength(azone1)*nalength(azone2)*nalength(azone3),
     &   nalength(i),
     &   1.0d0,dbl_mb(k_coeff),int_mb(k_range_alpha+g4b-1),
     &   dbl_mb(k_integral+offset_ismall),nalength(i),1.0d0,
     &   dbl_mb(k_3a1m),int_mb(k_range_alpha+g4b-1))
c
       offset_ismall=offset_ismall+nalength(azone1)*nalength(azone2)*
     1            nalength(azone3)*nalength(i)
       enddo ! over small i ----------------------
c
      ENDDO  ! over ii
        if (.not.ma_pop_stack(l_a4_offset))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
c
c
c
c
      DO azone4 = 1, azone3-1  ! second part ----
c getting piece of 4a
        size_4a = nalength(azone1)*nalength(azone2)*
     1            nalength(azone3)*nalength(azone4)
       if(azone3.le.azone4) then
         key_4af=azone4 - 1 + atpart * (azone3 - 1 +
     &          atpart * (azone2 - 1 + atpart * (azone1 - 1)))
       else
         key_4af=azone3 - 1 + atpart * (azone4 - 1 +
     &          atpart * (azone2 - 1 + atpart * (azone1 - 1)))
       end if
         call tce_hash(int_mb(k_4af_offset),key_4af,offset_4af)
        call ga_get(i_from_x,offset_4af+1,offset_4af+size_4a,1,1,
     1    dbl_mb(k_integral),1)
c
      if(azone4.lt.azone3) then
        if(.not.ma_push_get(mt_dbl,size_4a,'4a_s',l_4a_sort,k_4a_sort))
     1     call errquit('tce_4af_zones1: MA problem',0,MA_ERR)
      CALL TCE_SORT_4KG_(dbl_mb(k_integral),dbl_mb(k_4a_sort),
     & nalength(azone3),nalength(azone4),
     & nalength(azone2),nalength(azone1),
     &2,1,3,4,1.0d0)
      do i=1,size_4a
       dbl_mb(k_integral+i-1)=dbl_mb(k_4a_sort+i-1)
      enddo
        if (.not.ma_pop_stack(l_4a_sort))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
      end if
c
c  C(g4b irho) ==> l_2g2z
c
      size_amc=int_mb(k_range_alpha+g4b-1) *
     1         nalength(azone4)
      i=0
      tot_azone4_sh=tot_zone(azone4)
      do irho1   =  1,nalength(azone4)
      do igi4=1,int_mb(k_range_alpha+g4b-1)
       i=i+1
       ipos1=(int_mb(k_offset_alpha+g4b-1)+igi4-1)*nbf+tot_azone4_sh
     &       +irho1
       dbl_mb(k_coeff+i-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c C(g4b irho)* v(irho,isigma,imu,inu)
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g4b-1),
     &   nalength(azone1)*nalength(azone2)*nalength(azone3),
     &   nalength(azone4),
     &   1.0d0,dbl_mb(k_coeff),int_mb(k_range_alpha+g4b-1),
     &   dbl_mb(k_integral),nalength(azone4),1.0d0,
     &   dbl_mb(k_3a1m),int_mb(k_range_alpha+g4b-1))
c
      ENDDO
c write to file
          key_3a1m =  azone3-1+atpart*(g4b-1+(noa+nva)*
     &    (azone2 - 1 + atpart * (azone1 - 1)))
         call tce_hash(int_mb(k_3a1m_offset),key_3a1m,offset_3a1m)
        call ga_put(i_to_x,offset_3a1m+1,offset_3a1m+size_3a1m,1,1,
     1    dbl_mb(k_3a1m),1)
c
      if (.not.ma_pop_stack(l_3a1m))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
c
      next = NXTASK(nprocs, 1)
      END IF
      count = count + 1
      ENDDO
      ENDDO
      ENDDO
      ENDDO
c 3A1P fully done here
      call ga_sync()
      next = nxtask(-nprocs,1)
c
c
c
      cpu_clock(3)  = cpu_clock(3)+util_cpusec()
      wall_clock(3) = wall_clock(3)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'step 2',cpu_clock(3),wall_clock(3)
        call util_flush(LuOut)
      endif
      cpu_clock(4)  = -util_cpusec()
      wall_clock(4) = -util_wallsec()
c
c
c
      if(nodezero) then
        write(6,*)'STEP3 4index'
        call util_flush(6)
      end if
c
c
c 2A2M part here
c
       if (.not.ga_destroy(handle_4a))
     1   call errquit('ga_destroy: GA problem handle_4a',15,GA_ERR)
c
        call util_file_name('2a2mf',.false.,.false.,filename)
        size = size_2a2mf
        if(.not.ga_create(mt_dbl,size,1,filename,-1,1,handle_2a2m)) then
          write(LuOut,*) ' available GA memory ',ga_memory_avail(),
     1                   ' bytes'
          call errquit ('tce_mo2e_incore_2eorb: failed ga_create size=',
     1                  size,GA_ERR)
        endif
        i_from_x=handle_3a1m
        i_to_x=handle_2a2m
c
      cpu_clock(4)  = cpu_clock(4)+util_cpusec()
      wall_clock(4) = wall_clock(4)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'setup',cpu_clock(4),wall_clock(4)
        call util_flush(LuOut)
      endif
      cpu_clock(5)  = -util_cpusec()
      wall_clock(5) = -util_wallsec()
c
c
      nprocs = GA_NNODES()
      count = 0
      next = NXTASK(nprocs, 1)
c
      DO g3b = 1,noa+nva   !k
      DO g4b = g3b,noa+nva !l
      DO azone1 = 1,atpart      !nu
      DO azone2 = azone1,atpart !mu
c
      IF (next.eq.count) THEN
c
      size_2a2m=int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     1          *nalength(azone1)*nalength(azone2)
      if (.not.ma_push_get(mt_dbl,size_2a2m,'2a2m',l_2a2m,k_2a2m))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
      call dfill(size_2a2m, 0.0d0, dbl_mb(k_2a2m), 1)
c
      call a3_offset(azone1,azone2,g3b,size_ic,
     &           l_a3_offset,k_a3_offset)
      length_a3=int_mb(k_a3_offset)
c
      DO ii=1,length_a3     ! ii---loop

       a3_ini    = int_mb(k_a3_offset+ii)
       a3_fin    = int_mb(k_a3_offset+length_a3+ii)
       key_ini   = a3_ini-1+atpart*(g3b-1+(noa+nva)*
     &    (azone2 - 1 + atpart * (azone1 - 1)))
       call tce_hash(int_mb(k_3a1m_offset),key_ini,offset_bl3a1m)
c
       size_bl3a1m   = int_mb(k_a3_offset+2*length_a3+ii)
c
        call ga_get(i_from_x,offset_bl3a1m+1,offset_bl3a1m+size_bl3a1m,
     1       1,1,dbl_mb(k_integral),1)
      offset_ismall=0
      do i=a3_ini,a3_fin ! over small i ------------------
      size_3a1mi=nalength(azone1)*nalength(azone2)*
     1            nalength(i)*int_mb(k_range_alpha+g3b-1)
      if (.not.ma_push_get(mt_dbl,size_3a1mi,'3a1m',
     1 l_3a1m_sort,k_3a1m_sort))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
      CALL TCE_SORT_4KG_(dbl_mb(k_integral+offset_ismall),
     & dbl_mb(k_3a1m_sort),
     & int_mb(k_range_alpha+g3b-1),nalength(i),
     & nalength(azone2),nalength(azone1),
     &2,1,3,4,1.0d0)
      do j=1,size_3a1mi
       dbl_mb(k_integral+offset_ismall+j-1)=dbl_mb(k_3a1m_sort+j-1)
      enddo
      if (.not.ma_pop_stack(l_3a1m_sort))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
c  C(g4b isigma)
      j=0
      tot_azone3_sh=tot_zone(i)
      do isigma1   =  1,nalength(i)
      do igi4=1,int_mb(k_range_alpha+g4b-1)
       j=j+1
       ipos1=(int_mb(k_offset_alpha+g4b-1)+igi4-1)*nbf+tot_azone3_sh
     &       +isigma1
       dbl_mb(k_coeff+j-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c C(g4b isigma)* v(isigma,g3b,imu,inu)
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g4b-1),
     &   nalength(azone1)*nalength(azone2)*int_mb(k_range_alpha+g3b-1),
     &   nalength(i),
     &   1.0d0,dbl_mb(k_coeff),int_mb(k_range_alpha+g4b-1),
     &   dbl_mb(k_integral+offset_ismall),nalength(i),1.0d0,
     &   dbl_mb(k_2a2m),int_mb(k_range_alpha+g4b-1))
c
      offset_ismall=offset_ismall+nalength(azone1)*nalength(azone2)*
     1            nalength(i)*int_mb(k_range_alpha+g3b-1)
      enddo ! over small i ----------------------
      ENDDO                 ! ii---loop
c
        if (.not.ma_pop_stack(l_a3_offset))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
c write to file
          key_2a2m= azone2 - 1 + atpart*( azone1 - 1 +
     & atpart*(g4b - 1 + (noa+nva) * (g3b-1)))
         call tce_hash(int_mb(k_2a2m_offset),key_2a2m,offset_2a2m)
        call ga_put(i_to_x,offset_2a2m+1,offset_2a2m+size_2a2m,1,1,
     1    dbl_mb(k_2a2m),1)
c           end if  ! --------
c
      if (.not.ma_pop_stack(l_2a2m))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
c
      next = NXTASK(nprocs, 1)
      END IF
      count = count + 1
      ENDDO
      ENDDO
      ENDDO
      ENDDO
c 2A2P fully done here
      call ga_sync()
      next = nxtask(-nprocs,1)
c
c
      cpu_clock(5)  = cpu_clock(5)+util_cpusec()
      wall_clock(5) = wall_clock(5)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'step 3',cpu_clock(5),wall_clock(5)
        call util_flush(LuOut)
      endif
      cpu_clock(6)  = -util_cpusec()
      wall_clock(6) = -util_wallsec()
c
      if(nodezero) then
        write(6,*)'STEP4 4index'
        call util_flush(6)
      end if
c
c 1A3M part here ([g4b][g3b]|[mu][nu]) =>([g4b][g3b]|[g2b][nu])
c                            [mu]>[nu] (azone2>=azone1)
c
c DISK CHANGES =============== 1A3M
c destroying handle_3a1m
c closing/reopening handle_2a2m file
c opening handle_1a3m file
c
       if (.not.ga_destroy(handle_3a1m))
     1  call errquit('ga_destroy: GA problem handle_3a1m',15,GA_ERR)
        call util_file_name('1a3mf',.false.,.false.,filename)
        size = size_1a3mf
        if(.not.ga_create(mt_dbl,size,1,filename,-1,1,handle_1a3m)) then
          write(LuOut,*) ' available GA memory ',ga_memory_avail(),
     1                   ' bytes'
          call errquit ('tce_mo2e_incore_2eorb: failed ga_create size=',
     1                  size,GA_ERR)
        endif
        i_from_x=handle_2a2m
        i_to_x=handle_1a3m
c
      cpu_clock(6)  = cpu_clock(6)+util_cpusec()
      wall_clock(6) = wall_clock(6)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'setup',cpu_clock(6),wall_clock(6)
        call util_flush(LuOut)
      endif
      cpu_clock(7)  = -util_cpusec()
      wall_clock(7) = -util_wallsec()
c
c
      nprocs = GA_NNODES()
      count = 0
      next = NXTASK(nprocs, 1)
c
      DO g3b = 1,noa+nva   !k
      DO g4b = g3b,noa+nva !l
      DO g2b = 1,noa+nva   !
      DO azone1 = 1,atpart      !nu
ccx      DO g3b = 1,noa+nva   !k
ccx      DO g4b = g3b,noa+nva !l
c
      IF (next.eq.count) THEN
      size_1a3m=int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     1         *int_mb(k_range_alpha+g2b-1)*nalength(azone1)
      if (.not.ma_push_get(mt_dbl,size_1a3m,'1a3m',l_1a3m,k_1a3m))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
      call dfill(size_1a3m, 0.0d0, dbl_mb(k_1a3m), 1)
c azone2 >= azone1 - PART1
c
c
      call a2_offset(azone1,g4b,g3b,size_ic,
     &           l_a2_offset,k_a2_offset)
c
      length_a2=int_mb(k_a2_offset)
      DO ii=1,length_a2  !=========================================
       a2_ini      = int_mb(k_a2_offset+ii)
       a2_fin      = int_mb(k_a2_offset+length_a2+ii)
       key_ini=a2_ini - 1 + atpart*( azone1 - 1 +
     & atpart*(g4b - 1 + (noa+nva) * (g3b-1)))
       call tce_hash(int_mb(k_2a2m_offset),key_ini,offset_bl2a2m)
c
       size_bl2a2m   = int_mb(k_a2_offset+2*length_a2+ii)
        call ga_get(i_from_x,offset_bl2a2m+1,
     1    offset_bl2a2m+size_bl2a2m,1,1,dbl_mb(k_integral),1)
c
      offset_ismall=0
      do i=a2_ini,a2_fin ! over small i ------------------
ccc       TRANSPOZYCJA
        size_2a2mi=nalength(azone1)*nalength(i)*
     1     int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
        if (.not.ma_push_get(mt_dbl,size_2a2mi,'2a2m_sort',
     1   l_2a2m_aux,k_2a2m_aux))
     1     call errquit('tce_4ind: step1_1',0,MA_ERR)
        CALL TCE_SORT_4KG_(dbl_mb(k_integral+offset_ismall),
     &   dbl_mb(k_2a2m_aux),
     &   int_mb(k_range_alpha+g4b-1),int_mb(k_range_alpha+g3b-1),
     &   nalength(i),nalength(azone1),
     &   1,2,4,3,1.0d0)
        do j=1,size_2a2mi
         dbl_mb(k_integral+offset_ismall+j-1)=dbl_mb(k_2a2m_aux+j-1)
        enddo
        if (.not.ma_pop_stack(l_2a2m_aux))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
c  C(azone2 g2b)
      j=0
      tot_azone2_sh=tot_zone(i)
      do igi2=1,int_mb(k_range_alpha+g2b-1)
      do imu1   =  1,nalength(i)
       j=j+1
       ipos1=(int_mb(k_offset_alpha+g2b-1)+igi2-1)*nbf+tot_azone2_sh
     &       +imu1
       dbl_mb(k_coeff+j-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c  v(g4b,g3b,inu,imu) C(imu,g2b)
        size_1a3mi=int_mb(k_range_alpha+g4b-1)
     & *int_mb(k_range_alpha+g3b-1)*nalength(azone1)
     & *int_mb(k_range_alpha+g2b-1)
        if (.not.ma_push_get(mt_dbl,size_1a3mi,'1a3m',
     1   l_1a3m_sort,k_1a3m_sort))
     1     call errquit('tce_4ind: step1_1',0,MA_ERR)
c dgemm
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &   *nalength(azone1),
     &   int_mb(k_range_alpha+g2b-1),
     &   nalength(i),
     &   1.0d0,dbl_mb(k_integral+offset_ismall),
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &  *nalength(azone1),
     &   dbl_mb(k_coeff),nalength(i),0.0d0,
     &   dbl_mb(k_1a3m_sort),
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &  *nalength(azone1))
c transpose
        j=0
        do inu1=1,nalength(azone1)
        do igi2=1,int_mb(k_range_alpha+g2b-1)
        do igi3=1,int_mb(k_range_alpha+g3b-1)
        do igi4=1,int_mb(k_range_alpha+g4b-1)
        j=j+1
        ipos1=igi4+int_mb(k_range_alpha+g4b-1)*(
     &   igi3-1+int_mb(k_range_alpha+g3b-1)*(
     &   inu1-1+nalength(azone1)*(igi2-1)))
        dbl_mb(k_1a3m+j-1)=dbl_mb(k_1a3m+j-1)+
     &                     dbl_mb(k_1a3m_sort+ipos1-1)
        enddo
        enddo
        enddo
        enddo
        if (.not.ma_pop_stack(l_1a3m_sort))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
       offset_ismall=offset_ismall+nalength(azone1)*nalength(i)*
     1      int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
       enddo ! over small i ----------------------
      ENDDO  ! over ii !===========================================
        if (.not.ma_pop_stack(l_a2_offset))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
c
c
c azone2 < azone1  - PART2

      DO azone2 = 1,azone1-1 ! PART2 two cases here only one is followed
       size_2a2m=int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     1           *nalength(azone1)*nalength(azone2)
       if (.not.ma_push_get(mt_dbl,size_2a2m,'2a2m',l_2a2m,k_2a2m))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
       if(azone2.ge.azone1) then
          key_2a2m= azone2 - 1 + atpart*( azone1 - 1 +
     & atpart*(g4b - 1 + (noa+nva) * (g3b-1)))
         call tce_hash(int_mb(k_2a2m_offset),key_2a2m,offset_2a2m)
        call ga_get(i_from_x,offset_2a2m+1,offset_2a2m+size_2a2m,1,1,
     1    dbl_mb(k_2a2m),1)
       else
          key_2a2m= azone1 - 1 + atpart*( azone2 - 1 +
     & atpart*(g4b - 1 + (noa+nva) * (g3b-1)))
         call tce_hash(int_mb(k_2a2m_offset),key_2a2m,offset_2a2m)
        call ga_get(i_from_x,offset_2a2m+1,offset_2a2m+size_2a2m,1,1,
     1    dbl_mb(k_2a2m),1)
c            end if ! ------
        end if ! xxxxxx
       if(azone2.ge.azone1) then
ccc       TRANSPOZYCJA
        if (.not.ma_push_get(mt_dbl,size_2a2m,'2a2m_sort',
     1   l_2a2m_aux,k_2a2m_aux))
     1     call errquit('tce_4ind: step1_1',0,MA_ERR)
        CALL TCE_SORT_4KG_(dbl_mb(k_2a2m),dbl_mb(k_2a2m_aux),
     &   int_mb(k_range_alpha+g4b-1),int_mb(k_range_alpha+g3b-1),
     &   nalength(azone2),nalength(azone1),
     &   1,2,4,3,1.0d0)
        do i=1,size_2a2m
         dbl_mb(k_2a2m+i-1)=dbl_mb(k_2a2m_aux+i-1)
        enddo
        if (.not.ma_pop_stack(l_2a2m_aux))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
       end if
c
c  C(imu g2b) ==> l_2g2z
c
      size_amc=int_mb(k_range_alpha+g2b-1) *
     1         nalength(azone2)
      if (.not.ma_push_get(mt_dbl,size_amc,'2g2z',l_2g2z,k_2g2z))
     1    call errquit('tce_r2_divide3: xx-MA problem',0,MA_ERR)
      i=0
      tot_azone2_sh=tot_zone(azone2)
      do igi2=1,int_mb(k_range_alpha+g2b-1)
      do imu1   =  1,nalength(azone2)
       i=i+1
       ipos1=(int_mb(k_offset_alpha+g2b-1)+igi2-1)*nbf+tot_azone2_sh
     &       +imu1
       dbl_mb(k_2g2z+i-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c  v(g4b,g3b,inu,imu) C(imu,g2b)
        if (.not.ma_push_get(mt_dbl,size_1a3m,'1a3m',
     1   l_1a3m_sort,k_1a3m_sort))
     1     call errquit('tce_4ind: step1_1',0,MA_ERR)
c dgemm
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &   *nalength(azone1),
     &   int_mb(k_range_alpha+g2b-1),
     &   nalength(azone2),
     &   1.0d0,dbl_mb(k_2a2m),
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &  *nalength(azone1),
     &   dbl_mb(k_2g2z),nalength(azone2),0.0d0,
     &   dbl_mb(k_1a3m_sort),
     &   int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     &  *nalength(azone1))
c transpose
        i=0
        do inu1=1,nalength(azone1)
        do igi2=1,int_mb(k_range_alpha+g2b-1)
        do igi3=1,int_mb(k_range_alpha+g3b-1)
        do igi4=1,int_mb(k_range_alpha+g4b-1)
        i=i+1
        ipos1=igi4+int_mb(k_range_alpha+g4b-1)*(
     &   igi3-1+int_mb(k_range_alpha+g3b-1)*(
     &   inu1-1+nalength(azone1)*(igi2-1)))
        dbl_mb(k_1a3m+i-1)=dbl_mb(k_1a3m+i-1)+
     &                     dbl_mb(k_1a3m_sort+ipos1-1)
        enddo
        enddo
        enddo
        enddo
c
        if (.not.ma_pop_stack(l_1a3m_sort))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
        if (.not.ma_pop_stack(l_2g2z))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
        if (.not.ma_pop_stack(l_2a2m))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
      ENDDO ! PART2 ends up here ------------------------------------------
c
c
c
c write to file
        key_1a3m= azone1-1+atpart*(g2b-1+(noa+nva)*
     &  (g4b-1+(noa+nva)*(g3b-1)))
         call tce_hash(int_mb(k_1a3m_offset),key_1a3m,offset_1a3m)
        call ga_put(i_to_x,offset_1a3m+1,offset_1a3m+size_1a3m,1,1,
     1    dbl_mb(k_1a3m),1)
c           end if ! -------------
c
      if (.not.ma_pop_stack(l_1a3m))
     1  call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)
c
      next = NXTASK(nprocs, 1)
      END IF
      count = count + 1
      ENDDO
      ENDDO
      ENDDO
      ENDDO
c 1A3P fully done here
      call ga_sync()
      next = nxtask(-nprocs,1)
c
c
c
      cpu_clock(7)  = cpu_clock(7)+util_cpusec()
      wall_clock(7) = wall_clock(7)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'step 4',cpu_clock(7),wall_clock(7)
        call util_flush(LuOut)
      endif
      cpu_clock(8)  = -util_cpusec()
      wall_clock(8) = -util_wallsec()
c
c
c
c
      if(nodezero) then
        write(6,*)'STEP5 4index'
        call util_flush(6)
      end if
c
c 4M starts here
c
c destroying handle_2a2m
c closing/reopening handle_1a3m file
c opening handle_4m file
       if (.not.ga_destroy(handle_2a2m))
     1  call errquit('ga_destroy: GA problem handle_2a2m',15,GA_ERR)
        i_from_x=handle_1a3m
c
c
      cpu_clock(8)  = cpu_clock(8)+util_cpusec()
      wall_clock(8) = wall_clock(8)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'setup',cpu_clock(8),wall_clock(8)
        call util_flush(LuOut)
      endif
      cpu_clock(9)  = -util_cpusec()
      wall_clock(9) = -util_wallsec()
c
      nprocs = GA_NNODES()
      count = 0
      next = NXTASK(nprocs, 1)
c
      DO g1b = 1,noa+nva      !nu
      DO g2b = g1b,noa+nva   !
      DO g3b = 1,noa+nva   !k
      DO g4b = g3b,noa+nva !l
      IF (next.eq.count) THEN
      IF (int_mb(k_spin_alpha+g3b-1)+int_mb(k_spin_alpha+g4b-1).eq.
     &int_mb(k_spin_alpha+g1b-1)+int_mb(k_spin_alpha+g2b-1)) THEN
      IF (ieor(int_mb(k_sym_alpha+g3b-1),ieor(int_mb(k_sym_alpha+g4b-1),
     &    ieor(int_mb(k_sym_alpha+g1b-1),int_mb(k_sym_alpha+g2b-1))))
     &    .eq. irrep_v) THEN
c reversed order
      ICOL=INDEX_PAIR(g4b,g3b)
      IROW=INDEX_PAIR(g2b,g1b)
      IF(IROW.GE.ICOL) THEN
      IRES=INDEX_PAIR(IROW,ICOL)
      size_4m=int_mb(k_range_alpha+g4b-1)*int_mb(k_range_alpha+g3b-1)
     1         *int_mb(k_range_alpha+g2b-1)*int_mb(k_range_alpha+g1b-1)
      if (.not.ma_push_get(mt_dbl,size_4m,'4m',l_4m,k_4m))
     1    call errquit('tce_4ind: step1_1',0,MA_ERR)
      call dfill(size_4m, 0.0d0, dbl_mb(k_4m), 1)
c
      call a1_offset(g1b,g2b,g4b,size_ic,
     &           l_a1_offset,k_a1_offset)
      length_a1=int_mb(k_a1_offset)
      DO ii=1,length_a1     ! ii---loop
       a1_ini    = int_mb(k_a1_offset+ii)
       a1_fin    = int_mb(k_a1_offset+length_a1+ii)
       key_ini   = a1_ini-1+atpart*(g4b-1+(noa+nva)*
     &  (g2b-1+(noa+nva)*(g1b-1)))
       call tce_hash(int_mb(k_1a3m_offset),key_ini,offset_bl1a3m)
c
       size_bl1a3m  = int_mb(k_a1_offset+2*length_a1+ii)
        call ga_get(i_from_x,offset_bl1a3m+1,offset_bl1a3m+size_bl1a3m,
     1       1,1,dbl_mb(k_integral),1)
c           end if ! -------
      offset_ismall=0
      do i=a1_ini,a1_fin ! over small i ------------------
c  C(azone1 g3b)
      j=0
      tot_azone1_sh=tot_zone(i)
      do igi3=1,int_mb(k_range_alpha+g3b-1)
      do inu1   =  1,nalength(i)
       j=j+1
       ipos1=(int_mb(k_offset_alpha+g3b-1)+igi3-1)*nbf+tot_azone1_sh
     &       +inu1
       dbl_mb(k_coeff+j-1)=dbl_mb(k_movecs_orb+ipos1-1)
      enddo
      enddo
c v(g2b,g1b,g4b,inu)*C(inu g3b)
      call dgemm('N','N',
     &   int_mb(k_range_alpha+g2b-1)*int_mb(k_range_alpha+g1b-1)
     &   *int_mb(k_range_alpha+g4b-1),
     &   int_mb(k_range_alpha+g3b-1),
     &   nalength(i),
     &   1.0d0,dbl_mb(k_integral+offset_ismall),
     &   int_mb(k_range_alpha+g2b-1)*int_mb(k_range_alpha+g1b-1)
     &  *int_mb(k_range_alpha+g4b-1),
     &   dbl_mb(k_coeff),nalength(i),1.0d0,
     &   dbl_mb(k_4m),
     &   int_mb(k_range_alpha+g2b-1)*int_mb(k_range_alpha+g1b-1)
     &  *int_mb(k_range_alpha+g4b-1))
c
      offset_ismall=offset_ismall+nalength(i)
     1       *int_mb(k_range_alpha+g4b-1)
     1       *int_mb(k_range_alpha+g1b-1)*int_mb(k_range_alpha+g2b-1)
c
      enddo ! over small i ----------------------
      ENDDO                 ! ii---loop
        if (.not.ma_pop_stack(l_a1_offset))
     1   call errquit('tce_mo2e_trans_zones: uu l_2g2z',15,MA_ERR)
c
c zapis
c
        key_4m=ires
        call tce_hash_n(int_mb(k_aux),key_4m,offset_4m)
        call put_block(d_v2,dbl_mb(k_4m),size_4m,
     &                 offset_4m)
        if (.not.ma_pop_stack(l_4m))
     1    call errquit('tce_mo2e_trans_zones: abc-MA problem',15,MA_ERR)

      END IF
      END IF
      END IF
      next = NXTASK(nprocs, 1)
      END IF
      count = count + 1
      ENDDO
      ENDDO
      ENDDO
      ENDDO
c
       call ga_sync()
       next = nxtask(-nprocs,1)
c
      if(nodezero) then
      write(6,*)'DONE --- DONE ---- DONE ---- DONE'
      end if
c
      cpu_clock(9)  = cpu_clock(9)+util_cpusec()
      wall_clock(9) = wall_clock(9)+util_wallsec()
      if (nodezero) then
        write(LuOut,9480) 'step 4',cpu_clock(9),wall_clock(9)
        call util_flush(LuOut)
      endif
c      cpu_clock(9)  = -util_cpusec()
c      wall_clock(9) = -util_wallsec()
c
c
      if (.not.ma_pop_stack(l_work2))
     1  call errquit('tce_ao2e: MA problem',14,MA_ERR)
      if (.not.ma_pop_stack(l_work1))
     1  call errquit('tce_ao2e: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_movecs_orb))
     1  call errquit('tce_ao2e: MA problem',15,MA_ERR)
c
c
c DISK CHANGES =============== AFTER 4M
c destroying handle_1a3m
c
       if (.not.ga_destroy(handle_1a3m))
     1  call errquit('ga_destroy: GA problem handle_1a3m',15,GA_ERR)
c
      if (.not.ma_pop_stack(l_1a3m_offset))
     1  call errquit('tce_off_1a3m: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_2a2m_offset))
     1  call errquit('tce_off_2a2m: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_3a1m_offset))
     1  call errquit('tce_off_3a1m: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_4af_offset))
     1  call errquit('tce_off_4a: MA problem',15,MA_ERR)
c
c     closing two large local files
c
      if (.not.ma_pop_stack(l_coeff))
     1  call errquit('tce_off_4a: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_integral))
     1  call errquit('tce_off_4a: MA problem',15,MA_ERR)
c
      if (.not.ma_pop_stack(l_aux))
     1  call errquit('tce_off_4a: MA problem',15,MA_ERR)
c
      call ga_sync()
c *** debug ***
 1000 format(2x,A10,1x,i14)
 9480 format(1x,'Cpu & wall time / sec for ',A,2f15.1)
c 800  format('DGEMM1 MAX',i5,2x,3f15.5)
c 801  format('DGEMM2 ',i5,2x,3f15.5)
 8153 format('SF_READ ERROR CODE = ',2x,i10)
 8154 format('SF_READ_WAIT ERROR CODE = ',2x,i10)
 8156 format('SF_WRITE ERROR CODE = ',2x,i10)
 8157 format('SF_WRITE_WAIT ERROR CODE = ',2x,i10)
 8155 format('FU',i6,2x,3i20)
 9000 format('PART1',i4,1x,'Cpu  wall ',2(f17.12,1x),3x,'g4b g3b',2i5)
c 9001 format('PART2',i4,1x,'Cpu  wall ',2(f17.12,1x),3x,'g4b g3b',2i5)
c 9003 format('PART1-4a',i4,1x,'Cpu  wall ',2(f17.12,1x))
c 9004 format('PART1-2g2z',i4,1x,'Cpu  wall ',2(f17.12,1x))
c 9005 format('PART1-dgemm',i4,1x,'Cpu  wall ',2(f17.12,1x))
c 9010 format('  P1-mnrs',i3,1x,2i5,1x,2i5,1x,'Cpu  wall ',2(f17.12,1x))
  555  format('atom loop ',2x,i5,3x,2i5,3x,2i5,i12)
  556  format('atom time',2x,i5,3x,2i5,3x,2i5,'Cpu wall ',2(f12.7,1x))
  777  format('main do loop ',2x,i5,3x,2i5,3x,2i5)
  775  format('main loop step1 ',2x,i5,3x,2i5,3x,2i5)
  776  format('main loop step2 ',2x,i5,3x,2i5,3x,2i5)
  778  format('PART1',2x,i5,3x,2i5,3x,2i5,2x,'Cpu  wall ',2(f17.12,1x))
  779  format('PART2',2x,i5,3x,2i5,3x,2i5,2x,'Cpu  wall ',2(f17.12,1x))
  780  format('ADD BLOCK',2x,i5,3x,2i5,3x,2i5,2x,'Cpu  wall ',
     &        2(f17.12,1x))
c *************
c
      RETURN
      END
