/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import help.Config;
import help.Pair;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import xmlObjects.VtEnv;


/****
 * This class loads the default Groups from standardGroups.xml
 */
public class DefaultGroups{
	
	/**
	 * The Key of this Hashtable is the standard symbol name trimmt by {@link #trimSymbol(String) trimSymbol} method. The value
	 * is a {@link Pair Pair} of the real symbol name as the left value and the hashtable name were it is saved on the right value of the Pair
	 */
	public Hashtable<String,Pair<String,String>> compgroups = new Hashtable<String,Pair<String,String>>();
	
	/**
	 * This Hashtable contains all default group symbols that are added to the table. The keys are the symbol names and the 
	 * values are the group names 
	 */
	
	public static Hashtable<String,String> groups = new Hashtable<String, String>();
	/**
	 * This Hashtable contains all default group symbols that are not added to the symbol table but necessary to set symbols to there default group. The keys are the symbol names and the 
	 * values are the group names 
	 */
	private static Hashtable<String,String> groupsDEF = new Hashtable<String, String>();
	public static final String DEFAULTGROUP = "no Group";
	private static ArrayList<String> standardGroup = new ArrayList<String>();
	private static ArrayList<String> FilterFunc = new ArrayList<String>();
	private static ArrayList<String> FilterFunc_caseSensetiv = new ArrayList<String>();
	
	
	/****
	 * load default groups from standardGroups.xml
	 */
	public DefaultGroups(String defGroupsPath)
	{
		//Load Default groups
		try{
			 
			InputStream in = new FileInputStream(defGroupsPath);
			
			DocumentBuilderFactory factory  = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder  = factory.newDocumentBuilder();
			Document doc = builder.parse(in);
			NodeList liste = doc.getElementsByTagName("group");
			String groupname = "";
			String symbolname = "";
			String vtDef ="";
		    for(int i=0;i<liste.getLength();i++)
			{
				groupname = liste.item(i).getAttributes().getNamedItem("identifier").getNodeValue(); 
				standardGroup.add(groupname.trim());
				
				Node next = liste.item(i).getFirstChild().getNextSibling();
				while(next != null)
				{
					symbolname = next.getTextContent();
					if(!symbolname.trim().equals("") && next.hasAttributes())
					{
						vtDef = next.getAttributes().getNamedItem("vtDef").getNodeValue();
						
						if(vtDef.equals("1"))
						{
							groups.put(symbolname.trim(), groupname.trim());
							compgroups.put(trimSymbol(symbolname), new Pair<String,String>(symbolname,"groups"));
						}
						else
						{
							groupsDEF.put(symbolname.trim(), groupname.trim());
							compgroups.put(trimSymbol(symbolname), new Pair<String,String>(symbolname,"groupsDEF"));
						}
					}
					next = next.getNextSibling();
				}
			}
		    
		    
		    liste = doc.getElementsByTagName("filter");
		    int caseSensetiv = 0;
		    for(int i=0;i<liste.getLength();i++)
			{
		    	caseSensetiv = Integer.parseInt(liste.item(i).getAttributes().getNamedItem("caseSensitive").getNodeValue()); 
		    	Node next = liste.item(i).getFirstChild().getNextSibling();
				while(next != null)
				{
					symbolname = next.getTextContent().trim();
					if(!symbolname.trim().equals("") && next.getNodeName().equals("pattern"))
					{
						if(caseSensetiv == 0)
							FilterFunc.add(symbolname.toLowerCase());
						else
							FilterFunc_caseSensetiv.add(symbolname);
					}
					next = next.getNextSibling();
				}
			}
		    
		    liste = doc.getElementsByTagName("config");
		    String name = "";
		    String val = "";
		    for(int i=0;i<liste.getLength();i++)
			{
		    	name = liste.item(i).getAttributes().getNamedItem("attr").getNodeValue().trim();
		    	val = liste.item(i).getTextContent().trim();
				if(name.trim().equals("nm"))
				{
					VtEnv.nm = val;
					if(val.trim().equals(""))
						System.out.println("nm is not available on your system!");
					continue;
				}
				System.out.println(name + " could not be set!");
			}
		    
		}catch(Exception e)
		{
			Config.errorHandler(e);
			
		}
		
	}
	
	/*****
	 * returns the group name of a given symbol.
	 * @param symbol name of the symbol.
	 * @return name of the group the symbol is in.
	 */
	public String getGroup(String symbol)
	{
		String group = null;
		String symbol2 = trimSymbol(symbol);
		if(compgroups.containsKey(symbol2))
		{
			if(compgroups.get(symbol2).getRight().equals("groups"))
				group = groups.get(compgroups.get(symbol2).getLeft());
			else
				group = groupsDEF.get(compgroups.get(symbol2).getLeft());
		}
		
		if(group == null)
			group = DefaultGroups.DEFAULTGROUP;
		
		return group;
	}
	/*******
	 * checks if the group is in a standard group or not.
	 * @param Group name of a group 
	 * @return true if it is a standardGroup otherwise false
	 */
	public boolean isDefaultGroup(String Group)
	{
		Group.trim();
		if(Group.equals(DEFAULTGROUP))
				return true;
		return standardGroup.contains(Group);
	}

	/********
	 * This method returns All Groups in a Hashtable where the key is symbol name and the value the the group name
	 * @return Hashtable <String,String> with symbols as key and standard group names as values 
	 */
	public Hashtable<String,String> getGroups()
	{
		return groups;
	}
	
	/*******
	 * convert a String in a compareable format.
	 * @return formatted String 
	 */
	public static String trimSymbol(String val)
	{
		if(val == null)
			return null;
		val = val.trim().toLowerCase();
		while(val.startsWith("_"))
			val=val.substring(1);
		while(val.endsWith("_"))
			val=val.substring(0, val.length()-1);
		return val;
	}
	
	public boolean isAllowed(String symbol)
	{

		boolean allowed = true;
		symbol = symbol.trim();
		for(int i=0;i<FilterFunc_caseSensetiv.size();i++)
		{
		 Pattern p = Pattern.compile(FilterFunc_caseSensetiv.get(i));
		 Matcher m = p.matcher(symbol);
		 if(m.matches())
			 return false;
		}
		symbol = symbol.toLowerCase();
		for(int i=0;i<FilterFunc.size();i++)
		{
		 Pattern p = Pattern.compile(FilterFunc.get(i));
		 Matcher m = p.matcher(symbol);
		 if(m.matches())
			 return false;
		}
		
		return allowed;
	}
	
}
