/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;

import java.awt.Component;
import java.awt.Color; 

/***
 * MyListRenderer inherits from DefaultTableCellRenderer and manage the design of the Listbox 
 * of the CounterWidget class
 */
public class MyListRenderer extends DefaultTableCellRenderer implements ListCellRenderer {
	/**
	 * generated serialVersionUID
	 */
	private static final long serialVersionUID = 1075785867914784301L;
	private int PointOfRed = 2;
	private boolean colorIt = false;
	private boolean isEditable = true;
	
	public void setDisabled(){
		isEditable = false;
	}

	/***
	 * set the rendering of the current component
	 */
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {
		
		setText(value.toString());
		setBackground(Color.WHITE);
		if(colorIt)
		{
			if(index <= PointOfRed)
			{
				setBackground(Color.GREEN);

			}
			else
			{
				setBackground(Color.RED);

			}
		}	
			if(isSelected)
				setBackground(Color.YELLOW);
		
		setEnabled(isEditable);
		
		return this;
	}
	
	/***
	 * set the index of the last valid counter (green marked in List)
	 * @param index index of the last valid counter
	 */
	public void setColorBorder(int index)
	{
		this.PointOfRed = index;
		this.repaint();
	}

	/***
	 * set if the listboxelements should be marked green and red or not.
	 * @param colorIt true if elements should be marked otherwise false
	 */
	public void setColorIt(boolean colorIt)
	{
		this.colorIt = colorIt;
	}
	

}