<?php

require_once("inc/read_conf.php");
require_once("inc/db.php");

$conf = readmyconf();
$con = connectme($conf);

if(isset($_SERVER['REMOTE_ADDR'])){
  die("This script should be invoked from the shell, not from the web.");
}

$q = array();

$q[] = "CREATE TABLE IF NOT EXISTS `blockdevices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `machine_id` int(11) NOT NULL ,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `size_mb` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25348 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `clusters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `domain` varchar(253) COLLATE utf8_unicode_ci NOT NULL,
  `vip_hostname` VARCHAR(255) NOT NULL default '',
  `first_master_machine_id` int(11) NULL default NULL,
  `swift_part_power` int(11) NOT NULL default '18',
  `swift_replicas` int(11) NOT NULL default '3',
  `swift_min_part_hours` int(11) NOT NULL default '1',
  `swift_proxy_hostname` VARCHAR(255) NOT NULL default '',
  `swift_encryption_key_id` VARCHAR(255) NOT NULL default '',
  `haproxy_custom_url` VARCHAR(255) NOT NULL default '',
  `statsd_hostname` VARCHAR(255) NOT NULL default '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `ifnames` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `machine_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `macaddr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `max_speed` int(11) NOT NULL default 10,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25754 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `ips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network` int(11) NOT NULL,
  `ip` bigint(128) NOT NULL,
  `type` enum('4','6') NOT NULL DEFAULT '4',
  `machine` INT(11) NOT NULL,
  `usefor` ENUM('machine','vip') NOT NULL DEFAULT 'machine',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniqueip` (`ip`),
  UNIQUE KEY `uniquemachine` (`network`,`machine`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `swiftregion` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniquename` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `machines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `memory` int(11) NOT NULL,
  `ipaddr` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `serial` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `product_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `hostname` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `installed` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `lastseen` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'None',
  `role` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cluster` int(11) DEFAULT NULL,
  `ipmi_use` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `ipmi_call_chassis_bootdev` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  `ipmi_addr` varchar(254) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ipmi_port` int(11) NOT NULL DEFAULT '623',
  `ipmi_username` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ipmi_password` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_id` int(11) NULL,
  `notes` VARCHAR(256) NOT NULL DEFAULT '',
  `ladvd_report` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bios_version` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ipmi_firmware_version` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ipmi_detected_ip` VARCHAR(64) NOT NULL DEFAULT '',
  `use_ceph_if_available` enum('yes','no') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  UNIQUE KEY `serial` (`serial`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `networks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `ip` varchar(64) NOT NULL,
  `cidr` int(3) NOT NULL,
  `is_public` enum('yes','no') NOT NULL DEFAULT 'no',
  `cluster` int(11) DEFAULT NULL,
  `role` varchar(64) DEFAULT NULL,
  `iface1` VARCHAR(32) NULL DEFAULT NULL,
  `iface2` VARCHAR(32) NULL DEFAULT NULL,
  `vlan` int(11) NULL,
  `mtu` int(11) NOT NULL DEFAULT '0',
  `location_id` int(11) NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `passwords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cluster` int(11) NOT NULL,
  `service` varchar(64) NOT NULL,
  `passtype` varchar(64) NOT NULL,
  `pass` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";


$q[] = "CREATE TABLE IF NOT EXISTS `rolecounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cluster` int(11) NOT NULL,
  `role` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cluster` (`cluster`,`role`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";

$q[] = "CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (1,'compute');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (2,'controller');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (3,'network');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (4,'volume');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (5,'sql');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (6,'messaging');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (7,'cephmon');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (8,'cephosd');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (9,'swiftproxy');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (10,'swiftstore');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (11,'custom');";
$q[] = "INSERT IGNORE INTO `roles` (`id`, `name`) VALUES (12,'network');";

$q[] = "CREATE TABLE IF NOT EXISTS `swiftregions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";


$q[] = "CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `hashed_password` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `use_radius` enum('yes','no') NOT NULL DEFAULT 'yes',
  `activated` enum('yes','no') NOT NULL DEFAULT 'yes',
  `is_admin` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";


foreach ($q as $sql){
  $r = mysqli_query($con, $sql);
  if($r === FALSE){
    print("MySQL error: ". mysqli_error($con) . "\n");
    print("when evaluating: $sql\n\n");
  }
}

?>
