// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * third_party/sketchology/proto/animations.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('sketchology.proto.AnimationCurve');
goog.provide('sketchology.proto.ColorAnimation');
goog.provide('sketchology.proto.ScaleAnimation');
goog.provide('sketchology.proto.ElementAnimation');
goog.provide('sketchology.proto.CurveType');

goog.require('goog.proto2.Message');


/**
 * Enumeration CurveType.
 * @enum {number}
 */
sketchology.proto.CurveType = {
  UNSPECIFIED_CURVE_TYPE: 0,
  EASE_IN_OUT: 1,
  EASE_IN: 2,
  EASE_OUT: 3,
  CUSTOM_CUBIC_BEZIER: 4
};



/**
 * Message AnimationCurve.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.AnimationCurve = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.AnimationCurve, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.AnimationCurve.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.AnimationCurve} The cloned message.
 * @override
 */
sketchology.proto.AnimationCurve.prototype.clone;


/**
 * Gets the value of the type field.
 * @return {?sketchology.proto.CurveType} The value.
 */
sketchology.proto.AnimationCurve.prototype.getType = function() {
  return /** @type {?sketchology.proto.CurveType} */ (this.get$Value(1));
};


/**
 * Gets the value of the type field or the default value if not set.
 * @return {!sketchology.proto.CurveType} The value.
 */
sketchology.proto.AnimationCurve.prototype.getTypeOrDefault = function() {
  return /** @type {!sketchology.proto.CurveType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the type field.
 * @param {!sketchology.proto.CurveType} value The value.
 */
sketchology.proto.AnimationCurve.prototype.setType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the type field has a value.
 */
sketchology.proto.AnimationCurve.prototype.hasType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the type field.
 */
sketchology.proto.AnimationCurve.prototype.typeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the type field.
 */
sketchology.proto.AnimationCurve.prototype.clearType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the params field at the index given.
 * @param {number} index The index to lookup.
 * @return {?number} The value.
 */
sketchology.proto.AnimationCurve.prototype.getParams = function(index) {
  return /** @type {?number} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the params field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {number} The value.
 */
sketchology.proto.AnimationCurve.prototype.getParamsOrDefault = function(index) {
  return /** @type {number} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the params field.
 * @param {number} value The value to add.
 */
sketchology.proto.AnimationCurve.prototype.addParams = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the params field.
 * @return {!Array<number>} The values in the field.
 */
sketchology.proto.AnimationCurve.prototype.paramsArray = function() {
  return /** @type {!Array<number>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the params field has a value.
 */
sketchology.proto.AnimationCurve.prototype.hasParams = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the params field.
 */
sketchology.proto.AnimationCurve.prototype.paramsCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the params field.
 */
sketchology.proto.AnimationCurve.prototype.clearParams = function() {
  this.clear$Field(2);
};



/**
 * Message ColorAnimation.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ColorAnimation = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ColorAnimation, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ColorAnimation.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ColorAnimation} The cloned message.
 * @override
 */
sketchology.proto.ColorAnimation.prototype.clone;


/**
 * Gets the value of the duration field.
 * @return {?number} The value.
 */
sketchology.proto.ColorAnimation.prototype.getDuration = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the duration field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ColorAnimation.prototype.getDurationOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the duration field.
 * @param {number} value The value.
 */
sketchology.proto.ColorAnimation.prototype.setDuration = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the duration field has a value.
 */
sketchology.proto.ColorAnimation.prototype.hasDuration = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the duration field.
 */
sketchology.proto.ColorAnimation.prototype.durationCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the duration field.
 */
sketchology.proto.ColorAnimation.prototype.clearDuration = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the curve field.
 * @return {?sketchology.proto.AnimationCurve} The value.
 */
sketchology.proto.ColorAnimation.prototype.getCurve = function() {
  return /** @type {?sketchology.proto.AnimationCurve} */ (this.get$Value(2));
};


/**
 * Gets the value of the curve field or the default value if not set.
 * @return {!sketchology.proto.AnimationCurve} The value.
 */
sketchology.proto.ColorAnimation.prototype.getCurveOrDefault = function() {
  return /** @type {!sketchology.proto.AnimationCurve} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the curve field.
 * @param {!sketchology.proto.AnimationCurve} value The value.
 */
sketchology.proto.ColorAnimation.prototype.setCurve = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the curve field has a value.
 */
sketchology.proto.ColorAnimation.prototype.hasCurve = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the curve field.
 */
sketchology.proto.ColorAnimation.prototype.curveCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the curve field.
 */
sketchology.proto.ColorAnimation.prototype.clearCurve = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the rgba field.
 * @return {?number} The value.
 */
sketchology.proto.ColorAnimation.prototype.getRgba = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the rgba field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ColorAnimation.prototype.getRgbaOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the rgba field.
 * @param {number} value The value.
 */
sketchology.proto.ColorAnimation.prototype.setRgba = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the rgba field has a value.
 */
sketchology.proto.ColorAnimation.prototype.hasRgba = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the rgba field.
 */
sketchology.proto.ColorAnimation.prototype.rgbaCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the rgba field.
 */
sketchology.proto.ColorAnimation.prototype.clearRgba = function() {
  this.clear$Field(3);
};



/**
 * Message ScaleAnimation.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ScaleAnimation = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ScaleAnimation, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ScaleAnimation.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ScaleAnimation} The cloned message.
 * @override
 */
sketchology.proto.ScaleAnimation.prototype.clone;


/**
 * Gets the value of the duration field.
 * @return {?number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getDuration = function() {
  return /** @type {?number} */ (this.get$Value(1));
};


/**
 * Gets the value of the duration field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getDurationOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the duration field.
 * @param {number} value The value.
 */
sketchology.proto.ScaleAnimation.prototype.setDuration = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the duration field has a value.
 */
sketchology.proto.ScaleAnimation.prototype.hasDuration = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the duration field.
 */
sketchology.proto.ScaleAnimation.prototype.durationCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the duration field.
 */
sketchology.proto.ScaleAnimation.prototype.clearDuration = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the curve field.
 * @return {?sketchology.proto.AnimationCurve} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getCurve = function() {
  return /** @type {?sketchology.proto.AnimationCurve} */ (this.get$Value(2));
};


/**
 * Gets the value of the curve field or the default value if not set.
 * @return {!sketchology.proto.AnimationCurve} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getCurveOrDefault = function() {
  return /** @type {!sketchology.proto.AnimationCurve} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the curve field.
 * @param {!sketchology.proto.AnimationCurve} value The value.
 */
sketchology.proto.ScaleAnimation.prototype.setCurve = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the curve field has a value.
 */
sketchology.proto.ScaleAnimation.prototype.hasCurve = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the curve field.
 */
sketchology.proto.ScaleAnimation.prototype.curveCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the curve field.
 */
sketchology.proto.ScaleAnimation.prototype.clearCurve = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the scale_x field.
 * @return {?number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getScaleX = function() {
  return /** @type {?number} */ (this.get$Value(3));
};


/**
 * Gets the value of the scale_x field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getScaleXOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the scale_x field.
 * @param {number} value The value.
 */
sketchology.proto.ScaleAnimation.prototype.setScaleX = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the scale_x field has a value.
 */
sketchology.proto.ScaleAnimation.prototype.hasScaleX = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the scale_x field.
 */
sketchology.proto.ScaleAnimation.prototype.scaleXCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the scale_x field.
 */
sketchology.proto.ScaleAnimation.prototype.clearScaleX = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the scale_y field.
 * @return {?number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getScaleY = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the scale_y field or the default value if not set.
 * @return {number} The value.
 */
sketchology.proto.ScaleAnimation.prototype.getScaleYOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the scale_y field.
 * @param {number} value The value.
 */
sketchology.proto.ScaleAnimation.prototype.setScaleY = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the scale_y field has a value.
 */
sketchology.proto.ScaleAnimation.prototype.hasScaleY = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the scale_y field.
 */
sketchology.proto.ScaleAnimation.prototype.scaleYCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the scale_y field.
 */
sketchology.proto.ScaleAnimation.prototype.clearScaleY = function() {
  this.clear$Field(4);
};



/**
 * Message ElementAnimation.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
sketchology.proto.ElementAnimation = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(sketchology.proto.ElementAnimation, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
sketchology.proto.ElementAnimation.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!sketchology.proto.ElementAnimation} The cloned message.
 * @override
 */
sketchology.proto.ElementAnimation.prototype.clone;


/**
 * Gets the value of the uuid field.
 * @return {?string} The value.
 */
sketchology.proto.ElementAnimation.prototype.getUuid = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the uuid field or the default value if not set.
 * @return {string} The value.
 */
sketchology.proto.ElementAnimation.prototype.getUuidOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the uuid field.
 * @param {string} value The value.
 */
sketchology.proto.ElementAnimation.prototype.setUuid = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the uuid field has a value.
 */
sketchology.proto.ElementAnimation.prototype.hasUuid = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the uuid field.
 */
sketchology.proto.ElementAnimation.prototype.uuidCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the uuid field.
 */
sketchology.proto.ElementAnimation.prototype.clearUuid = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the color_animation field.
 * @return {?sketchology.proto.ColorAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getColorAnimation = function() {
  return /** @type {?sketchology.proto.ColorAnimation} */ (this.get$Value(2));
};


/**
 * Gets the value of the color_animation field or the default value if not set.
 * @return {!sketchology.proto.ColorAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getColorAnimationOrDefault = function() {
  return /** @type {!sketchology.proto.ColorAnimation} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the color_animation field.
 * @param {!sketchology.proto.ColorAnimation} value The value.
 */
sketchology.proto.ElementAnimation.prototype.setColorAnimation = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the color_animation field has a value.
 */
sketchology.proto.ElementAnimation.prototype.hasColorAnimation = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the color_animation field.
 */
sketchology.proto.ElementAnimation.prototype.colorAnimationCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the color_animation field.
 */
sketchology.proto.ElementAnimation.prototype.clearColorAnimation = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the scale_animation field.
 * @return {?sketchology.proto.ScaleAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getScaleAnimation = function() {
  return /** @type {?sketchology.proto.ScaleAnimation} */ (this.get$Value(3));
};


/**
 * Gets the value of the scale_animation field or the default value if not set.
 * @return {!sketchology.proto.ScaleAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getScaleAnimationOrDefault = function() {
  return /** @type {!sketchology.proto.ScaleAnimation} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the scale_animation field.
 * @param {!sketchology.proto.ScaleAnimation} value The value.
 */
sketchology.proto.ElementAnimation.prototype.setScaleAnimation = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the scale_animation field has a value.
 */
sketchology.proto.ElementAnimation.prototype.hasScaleAnimation = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the scale_animation field.
 */
sketchology.proto.ElementAnimation.prototype.scaleAnimationCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the scale_animation field.
 */
sketchology.proto.ElementAnimation.prototype.clearScaleAnimation = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the next field.
 * @return {?sketchology.proto.ElementAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getNext = function() {
  return /** @type {?sketchology.proto.ElementAnimation} */ (this.get$Value(4));
};


/**
 * Gets the value of the next field or the default value if not set.
 * @return {!sketchology.proto.ElementAnimation} The value.
 */
sketchology.proto.ElementAnimation.prototype.getNextOrDefault = function() {
  return /** @type {!sketchology.proto.ElementAnimation} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the next field.
 * @param {!sketchology.proto.ElementAnimation} value The value.
 */
sketchology.proto.ElementAnimation.prototype.setNext = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the next field has a value.
 */
sketchology.proto.ElementAnimation.prototype.hasNext = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the next field.
 */
sketchology.proto.ElementAnimation.prototype.nextCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the next field.
 */
sketchology.proto.ElementAnimation.prototype.clearNext = function() {
  this.clear$Field(4);
};


/** @override */
sketchology.proto.AnimationCurve.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.AnimationCurve.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'AnimationCurve',
        fullName: 'sketchology.proto.AnimationCurve'
      },
      1: {
        name: 'type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: sketchology.proto.CurveType.EASE_IN_OUT,
        type: sketchology.proto.CurveType
      },
      2: {
        name: 'params',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.AnimationCurve.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.AnimationCurve, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.AnimationCurve.getDescriptor =
    sketchology.proto.AnimationCurve.prototype.getDescriptor;


/** @override */
sketchology.proto.ColorAnimation.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ColorAnimation.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ColorAnimation',
        fullName: 'sketchology.proto.ColorAnimation'
      },
      1: {
        name: 'duration',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        defaultValue: 0.5,
        type: Number
      },
      2: {
        name: 'curve',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AnimationCurve
      },
      3: {
        name: 'rgba',
        fieldType: goog.proto2.Message.FieldType.UINT32,
        type: Number
      }
    };
    sketchology.proto.ColorAnimation.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ColorAnimation, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ColorAnimation.getDescriptor =
    sketchology.proto.ColorAnimation.prototype.getDescriptor;


/** @override */
sketchology.proto.ScaleAnimation.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ScaleAnimation.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ScaleAnimation',
        fullName: 'sketchology.proto.ScaleAnimation'
      },
      1: {
        name: 'duration',
        fieldType: goog.proto2.Message.FieldType.DOUBLE,
        defaultValue: 0.5,
        type: Number
      },
      2: {
        name: 'curve',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.AnimationCurve
      },
      3: {
        name: 'scale_x',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      },
      4: {
        name: 'scale_y',
        fieldType: goog.proto2.Message.FieldType.FLOAT,
        type: Number
      }
    };
    sketchology.proto.ScaleAnimation.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ScaleAnimation, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ScaleAnimation.getDescriptor =
    sketchology.proto.ScaleAnimation.prototype.getDescriptor;


/** @override */
sketchology.proto.ElementAnimation.prototype.getDescriptor = function() {
  var descriptor = sketchology.proto.ElementAnimation.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ElementAnimation',
        fullName: 'sketchology.proto.ElementAnimation'
      },
      1: {
        name: 'uuid',
        fieldType: goog.proto2.Message.FieldType.STRING,
        type: String
      },
      2: {
        name: 'color_animation',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ColorAnimation
      },
      3: {
        name: 'scale_animation',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ScaleAnimation
      },
      4: {
        name: 'next',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: sketchology.proto.ElementAnimation
      }
    };
    sketchology.proto.ElementAnimation.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             sketchology.proto.ElementAnimation, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
sketchology.proto.ElementAnimation.getDescriptor =
    sketchology.proto.ElementAnimation.prototype.getDescriptor;
