"""
=================================
Compact estimator representations
=================================

This example illustrates the use of the print_changed_only global parameter.

Setting print_changed_only to True will alternate the representation of
estimators to only show the parameters that have been set to non-default
values. This can be used to have more compact representations.

"""

from sklearn.linear_model import LogisticRegression
from sklearn import set_config


lr = LogisticRegression(penalty="l1")
print("Default representation:")
print(lr)
# LogisticRegression(C=1.0, class_weight=None, dual=False, fit_intercept=True,
#                    intercept_scaling=1, l1_ratio=None, max_iter=100,
#                    multi_class='auto', n_jobs=None, penalty='l1',
#                    random_state=None, solver='warn', tol=0.0001, verbose=0,
#                    warm_start=False)

set_config(print_changed_only=True)
print("\nWith changed_only option:")
print(lr)
# LogisticRegression(penalty='l1')
